﻿// DlgDiscovery.cpp : 

#include "stdafx.h"
#include "NetDemo.h"
#include "DlgSelectCustomPro.h"

#define COL_INDEX_DEV_TYPE              1
#define COL_INDEX_DEV_IP                2
#define COL_INDEX_DEV_PORT              3
#define COL_INDEX_DEV_MAC               4
#define COL_INDEX_DEV_SERAILNUM         5
#define COL_INDEX_DEV_MANUFACTURER      6

void STDCALL NETDEV_GETPRO_CB(IN LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S pstDevInfo, void* lParam)
{
    CDlgSelectPro *pDlgSelectPro = (CDlgSelectPro*)lParam;
    pDlgSelectPro->handleSimProtocol(pstDevInfo);
    return;
}


IMPLEMENT_DYNAMIC(CDlgSelectPro, CDialog)

CDlgSelectPro::CDlgSelectPro(CWnd* pParent /*=NULL*/)
    : CDialog(CDlgSelectPro::IDD, pParent)
    , m_dwProtocolNum(0)
    , m_StrProtocolID("")
{
}

CDlgSelectPro::~CDlgSelectPro()
{
}

void CDlgSelectPro::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_LIST_DEVICE_LIST, m_oProtocolSimpleInfoList);
    DDX_Text(pDX, IDC_LAB_DEVICE_NUM, m_dwProtocolNum);
    DDX_Text(pDX, IDC_EDIT_PROTOCOL_ID, m_StrProtocolID);
    DDX_Text(pDX, IDC_EDIT_PROTOCOL_NAME, m_strProName);
    
    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_TRANS_PRO, m_oAddTransPro);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_TRANS_PRO, m_udwAddTransPro);
    DDX_Text(pDX, IDC_EDIT_TRANS_PORT, m_StrTransPort);

    DDX_Control(pDX, IDC_EDIT_MAIN_STREAM_INFO, m_oAddMainStream);
    DDX_CBIndex(pDX, IDC_EDIT_MAIN_STREAM_INFO, m_udwAddMainStream);
    DDX_Text(pDX, IDC_EDIT_MAINSTREAM_INFO, m_StrMainStream);

    DDX_Control(pDX, IDC_COMBO_ADD_DEVICE_SUB_STREAM, m_oAddSubStream);
    DDX_CBIndex(pDX, IDC_COMBO_ADD_DEVICE_SUB_STREAM, m_udwAddSubStream);
    DDX_Text(pDX, IDC_EDIT_SUBSTREM_INFO, m_StrSubStream);
}


BOOL CDlgSelectPro::OnInitDialog()
{
    CDialog::OnInitDialog();
    CenterWindow();

    InitListCtrl();
    InitCombo();

    CFont oFont;
    oFont.CreateFont(60,30,0,0,120, FALSE,FALSE,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FF_SWISS,"Arial");
    CEdit *pEdit=(CEdit *)GetDlgItem(IDC_LAB_DEVICE_NUM);
    pEdit->SetFont(&oFont,FALSE);
    GetDlgItem(IDC_LAB_DEVICE_NUM)->SetFont(&oFont);

    return TRUE;
}


BEGIN_MESSAGE_MAP(CDlgSelectPro, CDialog)

    ON_BN_CLICKED(IDC_BUTTON_GET_PROLIST, &CDlgSelectPro::OnBnClickedGetCustomProList)
    ON_BN_CLICKED(IDC_BUTTON_GETPRO_DETAIL, &CDlgSelectPro::OnBnClickedGetProDetai)
    ON_BN_CLICKED(IDC_BUTTON_SETPRO_DETAIL, &CDlgSelectPro::OnBnClickedSetProDetai)
    ON_BN_CLICKED(IDC_BUTTON_SETPRO_SELECT, &CDlgSelectPro::OnBnClickedProSelected)
    ON_WM_CLOSE()
    ON_NOTIFY(NM_CLICK, IDC_LIST_DEVICE_LIST, &CDlgSelectPro::OnNMClickListDeviceList)
END_MESSAGE_MAP()


void CDlgSelectPro::InitListCtrl()
{
    m_oProtocolSimpleInfoList.InsertColumn(0, "", LVCFMT_LEFT, 0, -1); 

    CString str="ID";
    m_oProtocolSimpleInfoList.InsertColumn(COL_INDEX_DEV_TYPE,str,LVCFMT_LEFT,100);

    str = "Name";
    m_oProtocolSimpleInfoList.InsertColumn(COL_INDEX_DEV_IP, str, LVCFMT_LEFT, 120);

    m_oProtocolSimpleInfoList.SetExtendedStyle(m_oProtocolSimpleInfoList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

void CDlgSelectPro::InitCombo()
{
    m_oAddTransPro.SetCurSel(0);
    m_oAddTransPro.InsertString(0,_T("UDP"));
    m_oAddTransPro.InsertString(0,_T("TCP"));

    m_oAddMainStream.SetCurSel(0);
    m_oAddMainStream.InsertString(0,_T("Enable"));
    m_oAddMainStream.InsertString(0,_T("NotEnable"));
    m_oAddSubStream.SetCurSel(0);
    m_oAddSubStream.InsertString(0,_T("Enable"));
    m_oAddSubStream.InsertString(0,_T("NotEnable"));

}

void CDlgSelectPro::OnBnClickedGetCustomProList()
{
    m_oProtocolSimpleMap.clear();
    m_dwProtocolNum = m_oProtocolSimpleMap.size();
    GetDlgItem(IDC_LAB_DEVICE_NUM)->SetWindowText("0");

    m_oProtocolSimpleInfoList.DeleteAllItems();
    m_oProtocolSimpleInfoList.SetRedraw(FALSE);

    UpdateData(TRUE);
    GetParent()->GetParent()->SendMessage(WM_ADD_DEVICECHN_GETPRO, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)this);

    m_oProtocolSimpleInfoList.SetRedraw(TRUE);
    m_oProtocolSimpleInfoList.Invalidate();
    m_oProtocolSimpleInfoList.UpdateWindow();

}

void CDlgSelectPro::OnBnClickedProSelected()
{

    if (atoi(m_StrProtocolID.GetBuffer(0)) != 0)
    {
        CDialog::OnOK();
        return;
    }
    MessageBox("Please select One Pro!");
    return;
}


void CDlgSelectPro::OnBnClickedSetProDetai()
{
    // TODO: 在此添加控件通知处理程序代码
    UpdateData();
  
    NETDEV_CUSTON_PROTOCOL_INFO_S stProtocolInfo = {0};
    stProtocolInfo.stCustomProSimpleInfo.udwProID = atoi(m_StrProtocolID.GetBuffer(0));
    memcpy(stProtocolInfo.stCustomProSimpleInfo.szProName, m_strProName.GetBuffer(0), NETDEV_LEN_64-1);

    stProtocolInfo.udwPort = atoi(m_StrTransPort.GetBuffer(0));
    stProtocolInfo.udwTransport = m_udwAddTransPro;

    memcpy(stProtocolInfo.stMainStream.szStreamURL, m_StrMainStream.GetBuffer(0), NETDEV_LEN_128-1);
    stProtocolInfo.stMainStream.udwEnable = this->m_udwAddMainStream;
    memcpy(stProtocolInfo.stSubStream.szStreamURL, m_StrSubStream.GetBuffer(0), NETDEV_LEN_128-1);
    stProtocolInfo.stSubStream.udwEnable = m_udwAddSubStream;

    //iRet = NETDEV_SetDevConfig(stNetDevInfo.lpDevHandle, 1, NETDEV_SET_CUSTOM_PROTOCOL_INFO, &stProtocolInfo, sizeof(NETDEV_CUSTON_PROTOCOL_INFO_S));

    GetParent()->GetParent()->SendMessage(WM_ADD_DEVICECHN_SETPRO_DETAIL, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)&stProtocolInfo);
    return ;
}

void CDlgSelectPro::OnClose()
{
    m_oProtocolSimpleMap.clear();
    m_dwProtocolNum = m_oProtocolSimpleMap.size();
    m_oProtocolSimpleInfoList.DeleteAllItems();

    UpdateData(FALSE);

    CDialog::OnClose();
}

void CDlgSelectPro::handleSimProtocol(LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S pstDevInfo)
{

    int nRow = m_oProtocolSimpleInfoList.InsertItem(0, "");

    CHAR szProID[10] = {0};
    itoa(pstDevInfo->udwProID, szProID, 10);

    m_oProtocolSimpleInfoList.SetItemText(nRow, 1, szProID);

    m_oProtocolSimpleInfoList.SetItemText(nRow, 2, pstDevInfo->szProName);

    m_oProtocolSimpleMap.push_back(*pstDevInfo);

    m_dwProtocolNum = m_oProtocolSimpleMap.size();

    UpdateData(FALSE);
    return;
}

void CDlgSelectPro::OnBnClickedGetProDetai()
{
    // TODO: 在此添加控件通知处理程序代码
    UpdateData();

    GetParent()->GetParent()->SendMessage(WM_ADD_DEVICECHN_GETPRO_DETAIL, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)this);
    UpdateData(FALSE);
    return ;
}


void CDlgSelectPro::OnNMClickListDeviceList(NMHDR *pNMHDR, LRESULT *pResult)
{
    POSITION pos = m_oProtocolSimpleInfoList.GetFirstSelectedItemPosition();
    if (pos > 0)
    {
        INT32 dwIndex = (int)pos - 1;

        CString strProID = m_oProtocolSimpleInfoList.GetItemText(dwIndex, 1);
        CString strProName = m_oProtocolSimpleInfoList.GetItemText(dwIndex, 2);
        m_StrProtocolID = strProID;
        m_strProName = strProName;
    }
    UpdateData(FALSE);
    return ;
}
