#include "stdafx.h"
#include "NetDemo.h"
#include "MenuVca.h"

// CMenuVca 

IMPLEMENT_DYNAMIC(CMenuVca, CDialog)

CMenuVca::CMenuVca(CWnd* pParent /*=NULL*/)
    : CDialog(CMenuVca::IDD, pParent)
{

}

CMenuVca::~CMenuVca()
{
}

void CMenuVca::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_TAB_VCA, m_oTabVCA);
}


BEGIN_MESSAGE_MAP(CMenuVca, CDialog)
    ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_VCA, &CMenuVca::OnTcnSelchangeTabVca)
END_MESSAGE_MAP()

/* Tab index */
typedef enum tabIndexConfig
{
    TAB_INDEX_PEOPLE_COUNTING  = 0,
    TAB_INDEX_PEOPLE_COUNTING_STATISTICS = 1,
	TAB_INDEX_FACE = 2,
	TAB_INDEX_VEHICLE = 3,
    TAB_INDEX_PRODUCESAFE = 4,
};

BOOL CMenuVca::OnInitDialog()
{
    CDialog::OnInitDialog();

    CString str = "People Counting for Report";
    m_oTabVCA.InsertItem(TAB_INDEX_PEOPLE_COUNTING, str);
    m_oDlgPeopleCounting.Create(IDD_VCA_PEOPLE_COUNTING,&m_oTabVCA);
    m_oDlgPeopleCounting.ShowWindow(SW_SHOW);

    str = "People Counting for Statistics";
    m_oTabVCA.InsertItem(TAB_INDEX_PEOPLE_COUNTING_STATISTICS, str);
    m_oDlgPeopleCountingStatistics.Create(IDD_VCA_PEOPLE_COUNTING_STATISTICS, &m_oTabVCA);
    m_oDlgPeopleCountingStatistics.ShowWindow(SW_HIDE);

	str = "Face";
	m_oTabVCA.InsertItem(TAB_INDEX_FACE, str);
	m_oDlgFace.Create(IDD_VCA_FACE, &m_oTabVCA);
	m_oDlgFace.ShowWindow(SW_HIDE);

	str = "Vehicle";
	m_oTabVCA.InsertItem(TAB_INDEX_VEHICLE, str);
	m_oDlgVehicle.Create(IDD_VCA_VEHICLE, &m_oTabVCA);
	m_oDlgVehicle.ShowWindow(SW_HIDE);

    str = "ProduceSafe";
    m_oTabVCA.InsertItem(TAB_INDEX_PRODUCESAFE, str);
    m_oDlgProduce.Create(IDD_VCA_PRODUCE_SAFE, &m_oTabVCA);
    m_oDlgProduce.ShowWindow(SW_HIDE);

    UpdateData(FALSE);

    return TRUE;
}

void CMenuVca::ConfigWithUpdate()
{
    switch(m_dwVCAType)
    {
    case TAB_INDEX_PEOPLE_COUNTING:
        m_oDlgPeopleCounting.ShowWindow(SW_SHOW);
        m_oDlgPeopleCountingStatistics.ShowWindow(SW_HIDE);
		m_oDlgFace.ShowWindow(SW_HIDE);
		m_oDlgVehicle.ShowWindow(SW_HIDE);
        m_oDlgProduce.ShowWindow(SW_HIDE);
        break;
    case TAB_INDEX_PEOPLE_COUNTING_STATISTICS:
        m_oDlgPeopleCounting.ShowWindow(SW_HIDE);
        m_oDlgPeopleCountingStatistics.ShowWindow(SW_SHOW);
		m_oDlgFace.ShowWindow(SW_HIDE);
		m_oDlgVehicle.ShowWindow(SW_HIDE);
        m_oDlgProduce.ShowWindow(SW_HIDE);
        break;
	case TAB_INDEX_FACE:
		m_oDlgPeopleCounting.ShowWindow(SW_HIDE);
		m_oDlgPeopleCountingStatistics.ShowWindow(SW_HIDE);
		m_oDlgFace.ShowWindow(SW_SHOW);
		m_oDlgVehicle.ShowWindow(SW_HIDE);
        m_oDlgProduce.ShowWindow(SW_HIDE);
		m_oDlgVehicle.m_oRealtimeMonitoring.OnBnClickedBtnPersonRecognizeStop();
		break;
	case TAB_INDEX_VEHICLE:
		m_oDlgPeopleCounting.ShowWindow(SW_HIDE);
		m_oDlgPeopleCountingStatistics.ShowWindow(SW_HIDE);
		m_oDlgFace.ShowWindow(SW_HIDE);
		m_oDlgVehicle.ShowWindow(SW_SHOW);
        m_oDlgProduce.ShowWindow(SW_HIDE);
		m_oDlgFace.m_oRealtimeMonitoring.OnBnClickedBtnPersonRecognizeStop();
		break;
    case TAB_INDEX_PRODUCESAFE:
        m_oDlgPeopleCounting.ShowWindow(SW_HIDE);
        m_oDlgPeopleCountingStatistics.ShowWindow(SW_HIDE);
        m_oDlgFace.ShowWindow(SW_HIDE);
        m_oDlgVehicle.ShowWindow(SW_HIDE);
        m_oDlgProduce.ShowWindow(SW_SHOW);
        break;

    default:
        break;
    }
}

void CMenuVca::OnTcnSelchangeTabVca(NMHDR *pNMHDR, LRESULT *pResult)
{
    UpdateData(TRUE);
    m_dwVCAType =  m_oTabVCA.GetCurSel();
    ConfigWithUpdate();
    *pResult = 0;
}
