// VehicleInfo.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "VehicleInfo.h"


// CVehicleInfo Ի

IMPLEMENT_DYNAMIC(CVehicleInfo, CDialog)

CVehicleInfo::CVehicleInfo(CWnd* pParent /*=NULL*/)
	: CDialog(CVehicleInfo::IDD, pParent)
{

}

CVehicleInfo::~CVehicleInfo()
{
}

BOOL CVehicleInfo::OnInitDialog()
{
    CDialog::OnInitDialog();
    InitDialog();

    return TRUE;
}

VOID CVehicleInfo::InitDialog()
{
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_BIG_CAR_E, _T("BIG_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_MINI_CAR_E, _T("MINI_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_EMBASSY_CAR_E, _T("EMBASSY_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_CONSULATE_CAR_E, _T("CONSULATE_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_OVERSEAS_CAR_E, _T("OVERSEAS_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_FOREIGN_CAR_E, _T("FOREIGN_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E, _T("COMMON_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E, _T("HANDINESS_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E, _T("EMBASSY_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E, _T("CONSULATE_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E, _T("OVERSEAS_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E, _T("FOREIGN_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E, _T("LOW_SPEED_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_TRACTOR_E, _T("TRACTOR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_TRAILER_E, _T("TRAILER"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_COACH_CAR_E, _T("COACH_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E, _T("COACH_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E, _T("TEMPORARY_ENTRY_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E, _T("TEMPORARY_ENTRY_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E, _T("TEMPORARY_DRIVING"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_POLICE_CAR_E, _T("POLICE_CAR"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E, _T("POLICE_MOTORBIKE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_AGRICULTURAL_E, _T("AGRICULTURAL"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E, _T("HONGKONG_ENTRY_EXIT"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E, _T("MACAO_ENTRY_EXIT"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_ARMED_POLICE_E, _T("ARMED_POLICE"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_ARMY_E, _T("ARMY"));
     m_oCBoxLicensePlateType.InsertString(NETDEV_PLATE_TYPE_OTHER_E, _T("OTHER"));
     m_oCBoxLicensePlateType.SetCurSel(0);

    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_BLACK_E, _T("BLACK"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_WHITE_E, _T("WHITE"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_GRAY_E, _T("GRAY"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_RED_E, _T("RED"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_BLUE_E, _T("BLUE"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_YELLOW_E, _T("YELLOW"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_ORANGE_E, _T("ORANGE"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_BROWN_E, _T("BROWN"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_GREEN_E, _T("GREEN"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_PURPLE_E, _T("PURPLE"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_CYAN_E, _T("CYAN"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_PINK_E, _T("PINK"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_TRANSPARENT_E, _T("TRANSPARENT"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_SILVERYWHITE_E, _T("SILVERYWHITE"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_DARK_E, _T("DARK"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_LIGHT_E, _T("LIGHT"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_COLOURLESS, _T("COLOURLESS"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_YELLOWGREEN, _T("YELLOWGREEN"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_GRADUALGREEN, _T("GRADUALGREEN"));
    m_oCBoxLicensePlateColor.InsertString(NETDEV_PLATE_COLOR_OTHER_E, _T("OTHER"));
    m_oCBoxLicensePlateColor.SetCurSel(0);

    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BLACK_E, _T("BLACK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_WHITE_E, _T("WHITE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GRAY_E, _T("GRAY"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_RED_E, _T("RED"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BLUE_E, _T("BLUE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_YELLOW_E, _T("YELLOW"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_ORANGE_E, _T("ORANGE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_BROWN_E, _T("BROWN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GREEN_E, _T("GREEN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_PURPLE_E, _T("PURPLE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_CYAN_E, _T("CYAN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_PINK_E, _T("PINK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_TRANSPARENT_E, _T("TRANSPARENT"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_SILVERYWHITE_E, _T("SILVERYWHITE"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_DARK_E, _T("DARK"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_LIGHT_E, _T("LIGHT"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_COLOURLESS, _T("COLOURLESS"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_YELLOWGREEN, _T("YELLOWGREEN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_GRADUALGREEN, _T("GRADUALGREEN"));
    m_oCBoxCarColor.InsertString(NETDEV_PLATE_COLOR_OTHER_E, _T("OTHER"));
    m_oCBoxCarColor.SetCurSel(0);
}

VOID CVehicleInfo::SetType(INT32 dwType)
{
    m_nType = dwType;
}

VOID CVehicleInfo::SetVehicleLibID(INT32 dwLibID)
{
    m_dwVehicleLibID = dwLibID;
}

VOID CVehicleInfo::AddVehicleInfo()
{
    UpdateData(TRUE);
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    BOOL bRet = FALSE;

    NETDEV_VEHICLE_INFO_LIST_S stVehicleMemberList = {0};
    stVehicleMemberList.udwVehicleNum = 1;
    NETDEV_VEHICLE_DETAIL_INFO_S stMemberInfoList = {0};
    stVehicleMemberList.pstMemberInfoList = &stMemberInfoList;

    MBToUTF8(m_strLicensePlate.GetBuffer(0), stMemberInfoList.stPlateAttr.szPlateNo, sizeof(stMemberInfoList.stPlateAttr.szPlateNo) - 1);
    stMemberInfoList.stPlateAttr.udwType = m_oCBoxLicensePlateType.GetCurSel();
    stMemberInfoList.stPlateAttr.udwColor = m_oCBoxLicensePlateColor.GetCurSel();
    stMemberInfoList.stVehicleAttr.udwColor = m_oCBoxCarColor.GetCurSel();

    NETDEV_BATCH_OPERATOR_LIST_S stResultList = {0};
    stResultList.udwNum = 1;
    NETDEV_BATCH_OPERATOR_INFO_S stBatchList = {0};
    stResultList.pstBatchList = &stBatchList;

    bRet = NETDEV_AddVehicleMemberList(lpHandle, m_dwVehicleLibID, &stVehicleMemberList, &stResultList);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_AddVehicleMemberList");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_AddVehicleMemberList");
}

VOID CVehicleInfo::ModifyVehicleInfo()
{
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    BOOL bRet = FALSE;
    MBToUTF8(m_strLicensePlate.GetBuffer(0), m_pstVehicleDetailInfo->stPlateAttr.szPlateNo, sizeof(m_pstVehicleDetailInfo->stPlateAttr.szPlateNo) - 1);
    m_pstVehicleDetailInfo->stPlateAttr.udwType = m_oCBoxLicensePlateType.GetCurSel();
    m_pstVehicleDetailInfo->stPlateAttr.udwColor = m_oCBoxLicensePlateColor.GetCurSel();
    m_pstVehicleDetailInfo->stVehicleAttr.udwColor = m_oCBoxCarColor.GetCurSel();

    NETDEV_VEHICLE_INFO_LIST_S stVehicleMemberList = {0};
    stVehicleMemberList.udwVehicleNum = 1;
    stVehicleMemberList.pstMemberInfoList = m_pstVehicleDetailInfo;

    NETDEV_BATCH_OPERATOR_LIST_S stResultList = {0};
    stResultList.udwNum = 1;
    NETDEV_BATCH_OPERATOR_INFO_S stBatchList = {0};
    stResultList.pstBatchList = &stBatchList;

    bRet = NETDEV_ModifyVehicleMemberInfo(lpHandle, m_dwVehicleLibID, &stVehicleMemberList, &stResultList);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_ModifyVehicleMemberInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_ModifyVehicleMemberInfo");
}

VOID CVehicleInfo::SetVehicleInfo(LPNETDEV_VEHICLE_DETAIL_INFO_S pstVehicleDetailInfo)
{
    m_pstVehicleDetailInfo = pstVehicleDetailInfo;
}

VOID CVehicleInfo::ReloadVehicleInfo()
{
    CHAR szTmp[NETDEV_LEN_64] = {0};
    UTF8ToMB(m_pstVehicleDetailInfo->stPlateAttr.szPlateNo, szTmp, sizeof(szTmp) - 1);
    m_strLicensePlate = szTmp;

    m_oCBoxLicensePlateType.SetCurSel(m_pstVehicleDetailInfo->stPlateAttr.udwType);
    m_oCBoxLicensePlateColor.SetCurSel(m_pstVehicleDetailInfo->stPlateAttr.udwColor);
    m_oCBoxCarColor.SetCurSel(m_pstVehicleDetailInfo->stVehicleAttr.udwColor);

    UpdateData(FALSE);
}

VOID CVehicleInfo::CleanCacheData()
{
    m_strLicensePlate = "";
    UpdateData(FALSE);

    m_dwVehicleLibID = 0;
    m_pstVehicleDetailInfo = NULL;
}

void CVehicleInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_VEHICLE_LICENSE, m_strLicensePlate);
    DDX_Control(pDX, IDC_CMB_VEHICLE_LICENSE_TYPE_LIST, m_oCBoxLicensePlateType);
    DDX_Control(pDX, IDC_CMB_VEHICLE_LICENSE_COLOR_LIST, m_oCBoxLicensePlateColor);
    DDX_Control(pDX, IDC_CMB_CAR_COLOR_LIST, m_oCBoxCarColor);
}


BEGIN_MESSAGE_MAP(CVehicleInfo, CDialog)
    ON_BN_CLICKED(IDC_BTN_ADD_VEHICLE_INFO, &CVehicleInfo::OnBnClickedBtnAddVehicleInfo)
END_MESSAGE_MAP()


// CVehicleInfo Ϣ

void CVehicleInfo::OnBnClickedBtnAddVehicleInfo()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        AddVehicleInfo();
    }
    else
    {
        ModifyVehicleInfo();
    }
}
