// VehicleMonitor.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "VehicleMonitor.h"


// CVehicleMonitor Ի

IMPLEMENT_DYNAMIC(CVehicleMonitor, CDialog)

CVehicleMonitor::CVehicleMonitor(CWnd* pParent /*=NULL*/)
	: CDialog(CVehicleMonitor::IDD, pParent)
{

}

CVehicleMonitor::~CVehicleMonitor()
{
}

VOID CVehicleMonitor::SetType(INT32 dwType)
{
    m_nType = dwType;
}

VOID CVehicleMonitor::SetMonitorInfo(LPNETDEV_MONITION_INFO_S pstMotitorInfo)
{
    m_pstMotitorInfo = pstMotitorInfo;
}

VOID CVehicleMonitor::ReloadMontiorInfo()
{
    CHAR szTmp[NETDEV_LEN_64] = {0};
    UTF8ToMB(m_pstMotitorInfo->stMonitorRuleInfo.szName, szTmp, sizeof(szTmp) - 1);
    m_strTaskName = szTmp;

    if(m_pstMotitorInfo->stMonitorRuleInfo.udwMonitorType == 0)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_VEHICLE_MATCH_ALARM))->SetCheck(TRUE);
    }
    else if(m_pstMotitorInfo->stMonitorRuleInfo.udwMonitorType == 0)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_VEHICLE_NO_MATCH_ALARM))->SetCheck(TRUE);
    }
    else
    {}

    m_oCBoxMonitorReason.SetCurSel(m_pstMotitorInfo->stMonitorRuleInfo.udwMonitorReason);


    UTF8ToMB(m_pstMotitorInfo->stMonitorRuleInfo.szReason, szTmp, sizeof(szTmp) - 1);
    m_strDescribe = szTmp;

    UpdateData(FALSE);
}

VOID CVehicleMonitor::InitDialog()
{
    m_oCBoxMonitorReason.ResetContent();
    m_oCBoxMonitorReason.InsertString(0, "Robbed car");
    m_oCBoxMonitorReason.InsertString(1, "Stolen car");
    m_oCBoxMonitorReason.InsertString(2, "Suspected vehicle");
    m_oCBoxMonitorReason.InsertString(3, "Illegal vehicles");
    m_oCBoxMonitorReason.InsertString(4, "Emergency check and control vehicle");
    m_oCBoxMonitorReason.SetCurSel(0);

    FindVehicleLibInfo();
    UpdateData(TRUE);
}

VOID CVehicleMonitor::AddVehicleMonitor()
{
    UpdateData(TRUE);
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }


    NETDEV_MONITION_INFO_S stMonitorInfo = {0};
    stMonitorInfo.stMonitorRuleInfo.bEnabled = 1;
    MBToUTF8(m_strTaskName.GetBuffer(0), stMonitorInfo.stMonitorRuleInfo.szName, sizeof(stMonitorInfo.stMonitorRuleInfo.szName) - 1);
    stMonitorInfo.stMonitorRuleInfo.udwMonitorType = m_dwMonitorType;
    stMonitorInfo.stMonitorRuleInfo.udwMonitorReason = m_oCBoxMonitorReason.GetCurSel();
    MBToUTF8(m_strDescribe.GetBuffer(0), stMonitorInfo.stMonitorRuleInfo.szReason, sizeof(stMonitorInfo.stMonitorRuleInfo.szReason) - 1);

    stMonitorInfo.stMonitorRuleInfo.udwLibNum = 1;		
    stMonitorInfo.stMonitorRuleInfo.audwLibList[0] = m_oLibInfoVector[m_oCBoxLibName.GetCurSel()].udwID;

    BOOL bRet = NETDEV_AddVehicleMonitorInfo(lpHandle, &stMonitorInfo);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_AddVehicleMonitorInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_AddVehicleMonitorInfo");
}

VOID CVehicleMonitor::ModifyVehicleMonitor()
{
    UpdateData(TRUE);
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    NETDEV_MONITION_RULE_INFO_S stMonitorRuleInfo = {0};
    BOOL bRet = NETDEV_GetVehicleMonitorInfo(lpHandle, m_pstMotitorInfo->udwID, &stMonitorRuleInfo);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_GetVehicleMonitorInfo");
        return;
    }

    NETDEV_MONITION_INFO_S stMonitorInfo = {0};
    stMonitorInfo.stMonitorRuleInfo.bEnabled = 1;
    MBToUTF8(m_strTaskName.GetBuffer(0), stMonitorRuleInfo.szName, sizeof(stMonitorRuleInfo.szName) - 1);
    stMonitorRuleInfo.udwMonitorType = m_dwMonitorType;
    stMonitorRuleInfo.udwMonitorReason = m_oCBoxMonitorReason.GetCurSel();
    MBToUTF8(m_strDescribe.GetBuffer(0), stMonitorRuleInfo.szReason, sizeof(stMonitorRuleInfo.szReason) - 1);

    NETDEV_MONITION_RULE_INFO_S pstMonitorInfo = {0};

    bRet = NETDEV_SetVehicleMonitorInfo(lpHandle, m_pstMotitorInfo->udwID, &stMonitorRuleInfo);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_SetVehicleMonitorInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_SetVehicleMonitorInfo");
}

VOID CVehicleMonitor::FindVehicleLibInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    m_oLibInfoVector.clear();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }
    LPVOID lpVehicleLibHandle = NETDEV_FindVehicleLibList(lpHandle);
    if(NULL ==lpVehicleLibHandle)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindVehicleLibList");
        return;
    }
    else
    {
        while(TRUE)
        {
            NETDEV_LIB_INFO_S stVehicleLibInfo = {0};
            bRet = NETDEV_FindNextVehicleLibInfo(lpVehicleLibHandle,  &stVehicleLibInfo);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                m_oLibInfoVector.push_back(stVehicleLibInfo);
            }
        }
        NETDEV_FindCloseVehicleLibList(lpVehicleLibHandle);
    }

    INT32 dwLibNum = m_oLibInfoVector.size();
    m_oCBoxLibName.ResetContent();
    for(INT32 i = 0; i<dwLibNum; i++)
    {
        CHAR szTmp[NETDEV_LEN_64] = {0};
        UTF8ToMB(m_oLibInfoVector[i].szName, szTmp, sizeof(szTmp) - 1);
        m_oCBoxLibName.InsertString(i, szTmp);
    }
    m_oCBoxLibName.SetCurSel(0);
}

VOID CVehicleMonitor::CleanCache()
{
    m_strTaskName = "";
    m_dwMonitorType = 0;
    m_strDescribe = "";
    m_oCBoxLibName.Clear();
    UpdateData(FALSE);
}

void CVehicleMonitor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_VEHICLE_NAME, m_strTaskName);

    if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_VEHICLE_MATCH_ALARM))->GetCheck())
    {
        m_dwMonitorType = 0;
    }
    else if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_VEHICLE_NO_MATCH_ALARM))->GetCheck())
    {
        m_dwMonitorType = 1;
    }

    DDX_Control(pDX, IDC_CMB_VEHICLE_MONTIOR_REASON_LIST, m_oCBoxMonitorReason);
    DDX_Text(pDX, IDC_EDIT_VEHICLE_DESCRIBE, m_strDescribe);
    DDX_Control(pDX, IDC_CMB_VEHICLE_LIB_LIST, m_oCBoxLibName);
}


BEGIN_MESSAGE_MAP(CVehicleMonitor, CDialog)
    ON_BN_CLICKED(IDC_BTN_ADD_VEHICLE_MONITOR, &CVehicleMonitor::OnBnClickedBtnAddVehicleMonitor)
END_MESSAGE_MAP()


// CVehicleMonitor Ϣ

void CVehicleMonitor::OnBnClickedBtnAddVehicleMonitor()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        AddVehicleMonitor();
    }
    else
    {
        ModifyVehicleMonitor();
    }
}
