#ifndef _NETDEV_H_
#define _NETDEV_H_

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef STATIC
    #define STATIC                  static
#endif

#ifndef CONST
    #define CONST                   const
#endif

#ifndef EXTERN
    #define EXTERN                  extern
#endif

#ifndef INLINE
    #define INLINE                  __inline
#endif

#ifndef UNION
    #define UNION                   union
#endif

#ifndef IN
    #define IN
#endif

#ifndef OUT
    #define OUT
#endif

#ifndef INOUT
    #define INOUT
#endif

#ifndef NEWINTERFACE
    #define NEWINTERFACE
#endif

#if defined(WIN32)  /* windows */
#define NETDEV_API
#else
#define NETDEV_API
#endif

/*  Standard function calling convention */
#ifdef i386
    #ifdef LINUX
        #ifndef STDCALL
        #define STDCALL                 __attribute__((stdcall))__attribute__((visibility ("default")))
        #endif
    #else
        #ifndef STDCALL
        #define STDCALL                 __attribute__((stdcall))
        #endif
    #endif
#else
    #ifdef WIN32
        #ifndef STDCALL
        #define STDCALL                 __stdcall
        #endif
    #else
        #ifdef LINUX
            #ifndef STDCALL
            #define STDCALL                 __attribute__((stdcall))__attribute__((visibility ("default")))
            #endif
        #else
            #ifndef STDCALL
            #define STDCALL
            #endif
        #endif
    #endif
#endif


#ifndef UCHAR_DEF
#define UCHAR_DEF
    typedef unsigned char           UCHAR;
#endif

#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                    CHAR;
#endif

#ifndef BYTE_DEF
#define BYTE_DEF
    typedef unsigned char           BYTE;
#endif

#ifndef UINT16_DEF
#define UINT16_DEF
    typedef unsigned short          UINT16;
#endif

#ifndef UINT_DEF
#define UINT_DEF
    typedef unsigned int            UINT32;
#endif

#ifndef INT16_DEF
#define INT16_DEF
    typedef  short                  INT16;
#endif

#ifndef INT32_DEF
#define INT32_DEF
    typedef  int                    INT32;
#endif

#ifndef LPVOID_DEF
#define LPVOID_DEF
    typedef void*                   LPVOID;
#endif

#ifndef VOID
#ifndef VOID_DEF
#define VOID_DEF
    typedef void                    VOID;
#endif
#endif

#ifndef INT64_DEF
#define INT64_DEF
    typedef long long               INT64;
#endif

#ifndef BOOL_DEF
#define BOOL_DEF
    #ifndef __OBJC__
        typedef int                 BOOL;
    #else
        #import<objc/objc.h>
    #endif
#endif

#ifndef FLOAT
#ifndef VOID_FLOAT
#define VOID_FLOAT
    typedef float                   FLOAT;
#endif
#endif

#ifndef DOUBLE
#ifndef DOUBLE_DEF
#define DOUBLE_DEF
    typedef double                   DOUBLE;
#endif
#endif

#ifndef FALSE
    #define FALSE                   0
#endif

#ifndef TRUE
    #define TRUE                    1
#endif

#ifndef WIN32
    typedef LPVOID                 HWND;
#endif





#ifndef NETDEV_SDK_NO_MEDIA
#define NETDEV_WITH_MEDIA           1           
#endif

#define NETDEV_WITH_CLOUD           1           
#define NETDEV_WITH_XW              1           
#define NETDEV_WITH_VMS             1           /* VMS */
#define NETDEV_WITH_PTZ             1           
#define NETDEV_WITH_SMART           1           
#define NETDEV_WITH_CONFIG          1           
#define NETDEV_WITH_BASIC           1           
#define NETDEV_ALARM_RECOVER_BASE   1           /*  Alarm recover base */
#define NETDEV_WITH_TRANS_CHANEL    1           

/**********************************   Commonly used numerical macros *************** */
#define NETDEV_STREAM_ID_LEN                    32          /* ID  Length of stream ID*/
#define NETDEV_FILE_NAME_LEN                    (256u)      /*   Length of filename */
#define NETDEV_USERNAME_LEN                     (128 + 4)   /* Maximum length of username */
#define NETDEV_PASSWORD_LEN                     128         /* Maximum length of password */
#define NETDEV_DESCRIBE_MAX_LEN                 (512 + 4)   /*  128 * 4128 */
#define NETDEV_DOMAIN_LEN                       64          /*   Maximum length of domain name */
#define NETDEV_PATH_LEN                         128         /* :  Maximum length of path, including filename */
#define NETDEV_MAX_URL_LEN                      512         /* URL   Maximum length of URL */
#define NETDEV_INVALID_CHANNEL_ID               (0XFFFFFF)  /* ID */

/*   Common length */
#define NETDEV_LEN_2                            2
#define NETDEV_LEN_4                            4
#define NETDEV_LEN_6                            6
#define NETDEV_LEN_8                            8
#define NETDEV_LEN_16                           16
#define NETDEV_LEN_32                           32
#define NETDEV_LEN_40                           40
#define NETDEV_LEN_64                           64
#define NETDEV_LEN_128                          128
#define NETDEV_LEN_132                          132
#define NETDEV_LEN_256                          256
#define NETDEV_LEN_260                          260
#define NETDEV_LEN_480                          480
#define NETDEV_LEN_512                          512
#define NETDEV_LEN_1024                         1024
#define NETDEV_LEN_2000                         2000
#define NETDEV_LEN_4096                         4096
#define NETDEV_LEN_8192                         8192

#define NETDEV_IPADDR_STR_MAX_LEN              (64u)        /* IP   Length of IP address string */
#define NETDEV_IPV4_LEN_MAX                     16          /* IPV4 Length of IPV4 address string */
#define NETDEV_IPV6_LEN_MAX                     128         /* IPV6 Length of IPV6 address string */
#define NETDEV_NAME_MAX_LEN                    (256u)       /*   Length of common name string */

#define NETDEV_CODE_STR_MAX_LEN                (256u)       /* CODE   Length of common code */
#define NETDEV_MAX_DATE_STRING_LEN             (64u)        /*  Maximum length of date string "2008-10-02 09:25:33.001 GMT" */
#define NETDEV_MAX_ALARM_IN_NUM                 64          /*   Maximum number of alarm inputs */
#define NETDEV_MAX_ALARM_OUT_NUM                64          /*   Maximum number of alarm outputs */
#define NETDEV_PLAN_SECTION_NUM                 8           /*   Number of scheduled time sections in a day */
#define NETDEV_PLAN_NUM_AWEEK                   8           /* ,  Total number of plans allowed in a week, including Monday to Sunday, and holidays */

#define NETDEV_MAX_PRESET_NUM                   256         /*   Maximum number of presets */
#define NETDEV_MAX_CRUISEPOINT_NUM              32          /*   Maximum number of presets for preset patrol */
#define NETDEV_MAX_CRUISEROUTE_NUM              16          /*   Maximum number of routes for preset patrol */
#define NETDEV_MIN_PTZ_SPEED_LEVEL              1           /*   Maximum PTZ rotating speed */
#define NETDEV_MAX_PTZ_SPEED_LEVEL              9           /*   MinimumPTZ rotating speed */
#define NETDEV_MAX_VIDEO_EFFECT_VALUE           255         /*      Maximum values for image parameters (brightness, contrast, hue, saturation) */
#define NETDEV_MIN_VIDEO_EFFECT_VALUE           0           /*      Minimum values for image parameters (brightness, contrast, hue, saturation) */
#define NETDEV_MAX_VIDEO_EFFECT_GAMMA_VALUE     10          /*  Minimum values for image parameters (Gama) */

#define NETDEV_MAX_PRIVACY_MASK_AREA_NUM        8           /*   Maximum number of privacy mask areas allowed */
#define NETDEV_OSD_TEXTOVERLAY_NUM              6           /*  OSD   Number of OSD text overlays */
#define NETDEV_OSD_TEXT_MAX_LEN                 (64 + 4)    /*  OSD   Length of OSD texts */
#define NETDEV_OSD_TYPE_MAX_NUM                 26          /*  OSD   Maximum number of OSD type */
#define NETDEV_OSD_FONT_SIZE_TYPE_MAX_NUM       4           /*  OSD   Maximum number of OSD font size type */
#define NETDEV_OSD_FONT_STYLE_TYPE_MAX_NUM      4           /*  OSD   Maximum number of OSD font style type */
#define NETDEV_OSD_TIME_FORMAT_MAX_NUM          7           /*  OSD   Maximum number of OSD time format type */
#define NETDEV_OSD_DATE_FORMAT_MAX_NUM          15          /*  OSD   Maximum number of OSD date format type */
#define NETDEV_PULL_ALARM_MAX_NUM               8           /*   Maximum number of alarms a user can get */
#define NETDEV_TRACK_CRUISE_MAXNUM              1           /*   Maximum number of patrol routes allowed  */
#define NETDEV_AUDIO_SOUND_MIN_VALUE            0           /*   Minimum volume */
#define NETDEV_AUDIO_SOUND_MAX_VALUE            255         /*   Maximum volume */
#define NETDEV_MIC_SOUND_MIN_VALUE              0           /*   Minimum volume */
#define NETDEV_MIC_SOUND_MAX_VALUE              255         /*   Maximum volume */
#define NETDEV_SCREEN_INFO_ROW                  18          /*   Screen Info Row */
#define NETDEV_SCREEN_INFO_COLUMN               22          /*   Screen Info Column */
#define NETDEV_CHANNEL_MAX                      512         /*  Maximum number of channel */
#define NETDEV_RESOLUTION_NUM_MAX               32          /*  Maximum number of resolution */
#define NETDEV_MONTH_DAY_MAX                    31          /*  Maximum number of days in a month */
#define NETDEV_VIDEO_ENCODE_TYPE_MAX            16          /*  Maximum number of encode type */
#define NETDEV_PEOPLE_CNT_MAX_NUM               60          /*  Maximum number of people count */
#define NETDEV_WIFISNIFFER_MAC_MAX_NUM          64          /* wifi sniffer MAC  Length of wifi sniffer MAC */
#define NETDEV_WIFISNIFFER_MAC_ARRY_MAX_NUM     128         /* wifi sniffer MAC Maximum number of wifi sniffer MAC array */
#define NETDEV_DISK_MAX_NUM                     256         /*  Maximum number of Disk */
#define NETDEV_LOCAL_DISK_MAX_NUM               32          /*  local Maximum number of Disk */
#define NETDEV_SD_CARD_DISK_MAX_NUM             16          /* SD SD Maximum number of Disk */
#define NETDEV_ARRAY_MAX_NUM                    16          /*  array Maximum number of Disk */
#define NETDEV_EXTEND_CABINET_DISK_MAX_NUM      32          /*  extend cabinet Maximum number of Disk */
#define NETDEV_NAS_MAX_NUM                      16          /* NAS NAS Maximum number of Disk */
#define NETDEV_ESATA_MAX_NUM                    4           /* ESATA eSATA Maximum number of Disk */
#define NETDEV_DISK_SMART_MAX_NUM               128         /* SMART Maximum number of Disk Smart Info */
#define NETDEV_ENCODE_FORMAT_MAX_NUM            3           /*  Maximum number of video compression */
#define NETDEV_SMART_ENCODE_MODEL_MAX_NUM       3           /*  Maximum number of smart image encoding mode */
#define NETDEV_GOP_TYPE_MAX_NUM                 4           /* GOP Maximum number of GOP type */
#define NETDEV_IPSAN_MAX_NUM                    4           /* IPSAN IPSAN Maximum number of Disk */

#define NETDEV_PHOTO_SERVER_MAX_NUM             4           /*  Maximum number of Photo Server */

#define NETDEV_INTELLIGENT_SERVER_MAX_NUM       4           /*  Maximum number of Intelligent Server */

#define NETDEV_MANAGER_SERVER_MAX_NUM           4           /*  Maximum number of Manager Server */

#define NETDEV_DEV_OTHER_LEN_MAX                32          
#define NETDEV_DEV_NAME_LEN_MAX                 64          

#define NETDEV_DEV_PASSWORD_LEN_MAX             64          
#define NETDEV_CLOUD_DEV_USER_NAME_LEN          260         /* ID */
#define NETDEV_CLOUD_USER_NAME_LEN              260         
#define NETDEV_CLOUD_DEV_USER_AUTH_LEN          260         
#define NETDEV_CLOUD_SHARE_TARGET_NAME_LEN      64          
#define NETDEV_CLOUD_SHARE_DESCRIBE_LEN         260         
#define NETDEV_CLOUD_DEV_NAME_LEN               260         
#define NETDEV_XW_MAX_PANE_NUM                  64          
#define NETDEV_NTP_SERVER_LIST_NUM              5           /* NTP */

#define NETDEV_TMS_FACE_RECORD_ID_LEN           32          /* ID */
#define NETDEV_TMS_CAMER_ID_LEN                 32          /* ID */
#define NETDEV_TMS_PASSTIME_LEN                 32          
#define NETDEV_TMS_FACE_TOLLGATE_ID_LEN         32          
#define NETDEV_TMS_HEAT_MAP_DEVID_LEN           32          /* DevID */
#define NETDEV_TMS_HEAT_MAP_RECORD_ID_LEN       16          /* RecordID */
#define NETDEV_TMS_HEAT_MAP_COllECT_TIME_LEN    18          /* CollectTime  */
#define NETDEV_TMS_PIC_COMMON_NUM               10          
#define NETDEV_TMS_CAR_PLATE_CAMID_LEN          32          /* CamID */
#define NETDEV_TMS_CAR_PLATE_RECORDID_LEN       32          /* RecordID */
#define NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN       32          /* TollgateID */
#define NETDEV_TMS_CAR_PLATE_PASSTIME_LEN       18          /* PassTime */
#define NETDEV_TMS_CAR_PLATE_LANEID_LEN         18          /* LaneID */
#define NETDEV_TMS_CAR_PLATE_CARPLATE_LEN       32          /* CarPlate */
#define NETDEV_USER_NAME_ENCRYPT_LEN            256         
#define NETDEV_PASSWORD_ENCRYPT_LEN             256         
#define NETDEV_VIDEO_FORMAT_MAX                 32          
#define NETDEV_VIDEO_FORMAT_NAME_LEN            32          
#define NETDEV_TVWALL_NAME_LEN                  260         
#define NETDEV_FORMAT_SPEC_MAX                  256         
#define NETDEV_LED_SPEC_MAX                     256         
#define NETDEV_FORMAT_NAME_LEN                  32          
#define NETDEV_VIDEO_OUT_MAX                    64          
#define NETDEV_SCENE_NAME_LEN                   260         
#define NETDEV_TIME_LEN                         16          
#define NETDEV_WND_NAME_LEN                     260         
#define NETDEV_SEQUENCE_SRC_MAX                 128         
#define NETDEV_TEXT_LEN                         1024        /* LED */
#define NETDEV_BMAP_NAME_LEN                    256         
#define NETDEV_SEQ_RES_WIN_MAX                  288         
#define NETDEV_MAX_DAY_NUM                      8           
#define NETDEV_MAX_TIME_SECTION_NUM             8           

#define NETDEV_ALARM_SOURCE_MAX_LEN                 (64 + 4)    
#define NETDEV_MAX_EVENT_RES_SIZE                   1024        

#define NETDEV_VIID_CODE_LEN                        48          
#define NETDEV_VIDEO_FORMAT_CAP_NUM                 64          
#define NETDEV_LAYOUT_CAP_NUM                       64          

#define NETDEV_DA_POINT_CODE_LEN                    48          
#define NETDEV_DA_AREA_CODE_LEN                     48          
#define NETDEV_VIRTUAL_MEM_TABLE_MAX                32          
#define NETDEV_EVENT_STORE_TYPE_NUM                 128         
#define NETDEV_MAX_PANE_NUM                         36          /* DC36 */
#define NETDEV_OSD_MAX_NUM_EX                       8           /*  OSD   Maximum Number of OSD */
#define NETDEV_RSA_MAX_VALUE                        3           

#define NETDEV_MAX_VIDEO_BRIGHT_EFFECT_VALUE        199             
#define NETDEV_MAX_VIDEO_CONTRAST_EFFECT_VALUE      199             
#define NETDEV_MAX_VIDEO_SATURATION_EFFECT_VALUE    359             
#define NETDEV_MAX_VIDEO_HUE_EFFECT_VALUE           359             
#define NETDEV_MAX_VIDEO_GAMMA_EFFECT_VALUE         99              
#define NETDEV_PIXEL_CONVERT_RATIO                  5000            /*  , */
#define NETDEV_PANES_NUM                            16              

#define NETDEV_XW_AUDIO_NUM                         16              
#define NETDEV_IP_ADDRESS_LEN                       64              /* IP */

#define NETDEV_TVWALLPLAN_NUM                       4               
#define NETDEV_PLAN_MAX_TVWALL_NUM                  4               
#define NETDEV_TVWALL_MAX_WIN_NUM                   81              
#define NETDEV_TVWALL_MAX_LAYOUT_NUM                64              /* , */
#define NETDEV_ALARM_LINK_PRESET_NUM                16              
#define NETDEV_ALARM_LINK_SWITCHOUT_NUM             16              
#define NETDEV_ALARM_LINK_MONITOR_NUM               16              
#define NETDEV_ALARM_LINK_TVWALL_NUM                32              
#define NETDEV_ALARM_LINK_SOUND_LEN                 512             
#define NETDEV_ALARM_SOURCE_NUM                     1               
#define NETDEV_ALARM_LINK_NUM                       128             

#define NETDEV_TIME_TEMPLATE_NUM                    32              
#define NETDEV_DC_SCHEME_RES_CHN_MAX_NUM            256             /* DC */
#define NETDEV_VIEW_MAX_WIN_NUM                     100             
#define NETDEV_MAX_ROLE_RIGHT_SIZE                  256             
#define NETDEV_MAX_QUERY_CHANNEL_NUM                500             
#define NETDEV_MAX_QUERY_DEV_NUM                    500             
#define NETDEV_GRID_AREAS_LEN                       256             
#define NETDEV_MAX_ORG_ROOT_ID_NUM                  32              
#define NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX      128             
#define NETDEV_RECORD_LOCK_ID_LEN                   64              /* ID */
#define NETDEV_RECORD_LOCK_DESC_LEN                 64              
#define NETDEV_NOTIME                               0               
#define NETDEV_WHITE_BALANCE_MODE_MAX_NUM           16              /*  Maximum number of Image white balance mode count */
#define NETDEV_FOCUS_MODE_MAX_NUM                   16              /*  Maximum number of Image focus mode count */
#define NETDEV_FOCUS_SCENE_MAX_NUM                  16              /*  Maximum number of Image focus scene count */
#define NETDEV_IMAGE_ROTATION_MODE_MAX_NUM          16              /*  Maximum number of Image rotation mode count */
#define NETDEV_LAMP_CTRL_TYPE_MAX_NUM               16              /*  Maximum number of lamp ctrl type count */
#define NETDEV_LAMP_CTRL_MODE_MAX_NUM               16              /*  Maximum number of lamp ctrl mode count */
#define NETDEV_EXPOSURE_MODE_MAX_NUM                16              /*  Maximum number of exposure mode count */
#define NETDEV_IRIS_RANGE_MAX_NUM                   16              /*   Maximum number of Iris Range count */
#define NETDEV_METERING_MODE_MAX_NUM                16              /*   Maximum number of Metering mode count */
#define NETDEV_SHUTTER_TIME_RANGE_MAX_NUM           28              /*   Maximum number of shutter Time Range count */
#define NETDEV_SLOW_SHUTTER_TIME_RANGE_MAX_NUM      16              /*  Maximum number of slow shutter Time Range count */
#define NETDEV_WIDE_DYNAMIC_MODE_MAX_NUM            16              /*  Maximum number of wide dynamic mode count */
#define NETDEV_DAY_NIGHT_MODE_MAX_NUM               16              /*  Maximum number of slow Day Night Mode count */
#define NETDEV_AUDIO_IN_MAX_NUM                     16              /*  Maximum number of Audio input count */
#define NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM            8               /*  Maximum number of Audio input mode count */
#define NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM       16              /*  Maximum number of Audio input encode format count */
#define NETDEV_AUDIO_SAMPLING_RATE_MAX_NUM          8               /*  Maximum number of Audio sampling rate count */
#define NETDEV_SERIAL_IN_MAX_NUM                    16              /*  Maximum number of serial input count */
#define NETDEV_SERIAL_IN_ENCODE_FORMAT_MAX_NUM      16              /*  Maximum number of serial input encode format count */
#define NETDEV_FACE_FEATURE_SIZE                    512             /*  512B */
#define NETDEV_FACE_FEATURE_VERSION_LEN             40              
#define NETDEV_FACE_FEATURE_LIST_FILE_LEN           256             
#define NETDEV_FACE_FEATURE_FILE_MD5_LEN            16              /* MD5 */
#define NETDEV_FACE_FEATURE_GALLEY_ID_LEN           20              /* ID */
#define NETDEV_FACE_FEATURE_MAX_NUM                 3               
#define NETDEV_OBJ_TRACK_MODE_NUM                   8               
#define NETDEV_STREAM_MAX_NUM                       3               
#define NETDEV_PLAN_DAY_NUM_AWEEK                   7               
#define NETDEV_PLAN_TIME_SECTION_NUM_ADAY           4               /*  Total number of plans allowed in a day*/
#define NETDEV_XW_SERIAL_NUM                        16              
#define NETDEV_DNS_LIST_NUM                         2               /* DNS */
#define NETDEV_NETWORK_MACNAME_LEN                  48              /* MAC */
#define NETDEV_LOG_QUERY_COND_NUM                   48              
#define NETDEV_FACE_DB_NAME_LEN                     256             
#define NETDEV_FACE_MEMBER_NAME_LEN                 256             
#define NETDEV_FACE_MEMBER_REGION_LEN               256             
#define NETDEV_FACE_MEMBER_CUSTOM_NUM               5               
#define NETDEV_FACE_MEMBER_CUSTOM_LEN               255             
#define NETDEV_FACE_IMAGE_MAX_LEN                   (2*1024*1024)   /* 2M   2097152*/
#define NETDEV_FACE_DB_TITLE_NAME_LEN               508             
#define NETDEV_FACE_MONITOR_RULE_NAME_LEN           508             
#define NETDEV_FACE_MONITOR_RULE_REASON_LEN         508             
#define NETDEV_FACE_ALARM_SRC_LEN                   256             
#define NETDEV_FACE_ANALYSIS_SKILL_NUM              16              
#define NETDEV_FACE_MEMBER_BIRTHDAY_LEN             31              
#define NETDEV_FACE_IDNUMBER_LEN                    128             
#define NETDEV_LABEL_ID_MAX_LEN                     32
#define NETDEV_TIME_RANGE_NUM                       8               
#define NETDEV_TIME_DURATION_NUM                    8               /* 8 */
#define NETDEV_HOLIDAY_INFO_NUM                     32              
#define NETDEV_AUDIO_MAX_NUM                        18              
#define NETDEV_CREATE_CONNECT_NUMBER                1               
#define NETDEV_EMERGENCY_BRLL_NAME_LEN              128             
#define NETDEV_EMERGENCY_BRLL_MAX_NUM               120             
#define NETDEV_VEHICLE_COMP_IMAGE_MAX_LEN           2097152         /*  2M*/
#define NETDEV_VEHICLE_IMAGE_MAX_LEN                4194304         /*  4M */
#define NETDEV_PIC_DATA_MAX_LEN                     (1024*1024)     

#define NETDEV_RES_CHANGE_INFO_LIST_NUM             64              /* LAPI */

#define NETDEV_OUTPUT_NI_RECV_CARD_MAX_NUM          64              
#define NETDEV_IMG_IN_MODE_LIST_MAX_NUM             16              
#define NETDEV_GAMMA_INFO_LIST_MAX_NUM              1024            

#define NETDEV_MAX_SERIAL_PROT_NUM                  1               /* 485 */  
#define NETDEV_MAX_TRANS_CHANEL_NUM                 1               /* 485 */

#define NETDEV_MAX_NIC_WORK_MODE_NUM                8                 
#define NETDEV_MAX_PORT_WORK_MODE_NUM               24                  
#define NETDEV_MAX_NET_WORK_CARD_NUM                8               
#define NETDEV_MAX_LINK_ACTION_NUM                  9               

#define NETDEV_IVA_REPORT_COORD_NUM                 16              

#define NETDEV_MAX_SCENE_INFO_NUM                   5               
#define NETDEV_MAX_TRIGGER_DETAIL_INFO_NUM          4               
#define NETDEV_MAX_ENV_PARAM_NUM                    2               
#define NETDEV_MAX_SCENE_TYPE_NUM                   16              
#define NETDEV_MAX_ENV_TYPE_NUM                     2               

#define NETDEV_INVALID_PARAM                        (0xffffff)

/*  */
#define NETDEV_VEH_PLATE_IMAGE_LEN              (1024*1024)

/*  */
#define NETDEV_VEH_PLATE_ENCODE_IMAGE_LEN       1400000

#define NETDEV_UINT32_INVALID                   0xFFFFFFFF               /* UINT32 */

/* BIT */
#ifndef BIT0
#define BIT0  (0x1 << 0)
#define BIT1  (0x1 << 1)
#define BIT2  (0x1 << 2)
#define BIT3  (0x1 << 3)
#define BIT4  (0x1 << 4)
#define BIT5  (0x1 << 5)
#define BIT6  (0x1 << 6)
#define BIT7  (0x1 << 7)
#define BIT8  (0x1 << 8)
#define BIT9  (0x1 << 9)
#define BIT10 (0x1 << 10)
#define BIT11 (0x1 << 11)
#define BIT12 (0x1 << 12)
#define BIT13 (0x1 << 13)
#define BIT14 (0x1 << 14)
#define BIT15 (0x1 << 15)
#define BIT16 (0x1 << 16)
#define BIT17 (0x1 << 17)
#define BIT18 (0x1 << 18)
#define BIT19 (0x1 << 19)
#define BIT20 (0x1 << 20)
#define BIT21 (0x1 << 21)
#define BIT22 (0x1 << 22)
#define BIT23 (0x1 << 23)
#define BIT24 (0x1 << 24)
#define BIT25 (0x1 << 25)
#define BIT26 (0x1 << 26)
#define BIT27 (0x1 << 27)
#define BIT28 (0x1 << 28)
#define BIT29 (0x1 << 29)
#define BIT30 (0x1 << 30)
#define BIT31 (0x1 << 31)

#define BIT(nr)     (1UL << (nr))
#endif  /* BIT */

#ifndef BIT32_MAX
    #define BIT32_MAX ((UINT32)(~0UL))
#endif



/* BEGIN****************************  Enum ************************************************************/

/**
* @enum tagNETDEVCommonErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVCommonErrCode
{
    NETDEV_E_FAILED                         = -1,           /*   Failed*/
    NETDEV_E_SUCCEED                        = 0,            /*   Succeeded*/
    NETDEV_E_SVC_FAILED                     = 1,            /*   Common Failed*/
    NETDEV_E_NO_USER                        = 5,            /*  User does not exist*/

    NETDEV_E_NO_RESULT                      = 11,           /*  No result */
    NETDEV_E_NOENOUGH_BUF                   = 12,           /* :   Buffer is too small for receiving device data */
    NETDEV_E_SDK_SOCKET_LSN_FAIL            = 13,           /* socket listen  Failed to create socket listen */
    NETDEV_E_INIT_MUTEX_FAIL                = 14,           /*   Failed to initialize lock */
    NETDEV_E_INIT_SEMA_FAIL                 = 15,           /*   Failed to initialize semaphore */
    NETDEV_E_ALLOC_RESOURCE_ERROR           = 16,           /* SDK  Error occurred during SDK resource allocation */
    NETDEV_E_HAVEDATA                       = 17,           /*    Data not all sent */
    NETDEV_E_NEEDMOREDATA                   = 18,           /*   More data required  */
    NETDEV_E_TRANSFILE_FAIL                 = 19,           /*   File transmission failed */
    NETDEV_E_DEVICE_TYPE_ERR                = 20,           /*  Device type that are not supported */
    NETDEV_E_NONCE_TIMEOUT                  = 21,           /* nonce Nonce expired */
    NETDEV_E_INNER_ERR                      = 22,           /*  System internal error */
    NETDEV_E_BINDNOTIFY_FAIL                = 24,           /*   Failed to bind alarms*/

    NETDEV_E_SYSCALL_FALIED                 = 100,          /* errno  Failed to call system function. See errno */
    NETDEV_E_NULL_POINT                     = 101,          /*   Null pointer */
    NETDEV_E_INVALID_PARAM                  = 102,          /*   Invalid parameter */
    NETDEV_E_INVALID_MODULEID               = 103,          /* ID  Invalid module ID */
    NETDEV_E_INVALID_HANDLE                 = 104,          /*  Invalid handle */
    NETDEV_E_NO_MEMORY                      = 105,          /*  Memory allocation failed */
    NETDEV_E_FILE_NO_EXIST                  = 106,          /*  File does not exist */
    NETDEV_E_NO_DEV                         = 107,          /*  Device does not exist*/
    NETDEV_E_NO_FIT_LOG                     = 108,          /*  Qualified logs do not exist*/
    NETDEV_E_BUSY                           = 109,          /* busy busy status */
    NETDEV_E_TIMER_REG_FAILED               = 110,          /*  Register timer failed */
    NETDEV_E_COMMON_FAILED                  = 111,          /*  General error */
    NETDEV_E_CMD_NOT_SUPPORT                = 112,          /*  Command does not support */
    NETDEV_E_NOT_SUPPORT                    = 113,          /*  The device does not support this function */
    NETDEV_E_TIMEOUT                        = 114,          /*  Overtime */
    NETDEV_E_MSG_ERR                        = 115,          /*  Message mismatch */
    NETDEV_E_MODULE_INEXIST                 = 116,          /*  Module does not exist */
    NETDEV_E_SOCKET_RECV_ERR                = 117,          /*  Message acceptance failure */
    NETDEV_E_DECODE_IE_FAILED               = 118,          /* IE Failure to get message IE */
    NETDEV_E_ENCODE_IE_FAILED               = 119,          /* IE Failed to add message IE */
    NETDEV_E_SDK_NOINTE_ERROR               = 120,          /* SDK SDK uninitialized */
    NETDEV_E_ALREDY_INIT_ERROR              = 121,          /* SDK SDK has been initialized */
    NETDEV_E_DEVICE_FACTURER_ERR            = 122,          /*  Unsupported equipment manufacturer */
    NETDEV_E_NAME_EXIST                     = 123,          /*  Name already exists */
    NETDEV_E_GET_CFG_FAILED                 = 124,          /*  Error acquiring configuration information */
    NETDEV_E_SET_CFG_FAILED                 = 125,          /*  Error setting configuration information */
    NETDEV_E_CHANNEL_OVER_SPEC              = 126,          /*  Channel number exceeding specification */
    NETDEV_E_CALL_DRV_COMMON                = 127,          /*  Call driver universal failure */
    NETDEV_E_TOTAL_QUOTA_FULL               = 128,          /*  Insufficient allocatable quota space */
    NETDEV_E_CALL_DB_COMMON                 = 129,          /*  Failure to invoke database universality */
    NETDEV_E_NEED_MORE_MEMORY               = 130,          /*  Insufficient memory allocation */
    NETDEV_E_T2U_CONNECT_FAILED             = 131,          /* T2U Failure of T2U connection */
    NETDEV_E_FUNC_IS_INITIALIZING           = 132,          /*  Functions are being initialized */

    NETDEV_E_CONNECT_ERROR                  = 200,          /*   Failed to create connection */
    NETDEV_E_SEND_MSG_ERROR                 = 201,          /*  Failed to send message */
    NETDEV_E_DECODE_RSP_ERROR               = 202,          /*   Failed to decode response message */
    NETDEV_E_NONSUPPORT                     = 203,          /*   Function not supported */
    NETDEV_E_JSON_ERROR                     = 204,          /* Json   Json common error */
    NETDEV_E_NORESULT                       = 205,          /*  The query result is empty */
    NETDEV_E_SOCKET_RECV_ERROR              = 206,          /* Socket  Socket failed to receive message */
    NETDEV_E_CREATE_THREAD_FAIL             = 207,          /*   Failed to create thread */
    NETDEV_E_RESCODE_NO_EXIST               = 208,          /*   Resource code not exist */
    NETDEV_E_MSG_DATA_INVALID               = 209,          /*   Incorrect message content */
    NETDEV_E_JSON_NO_IMAGE                  = 210,          /*  Picture data is empty */
    NETDEV_E_IMAGE_SIZE_BEYOND_THE_LIMIT    = 211,          /*  Image size beyond the limit*/


    NETDEV_E_MANAGETYPE_NONSUPPORT          = 403,          /* / The current platform is not support */
    NETDEV_E_PUBLICKEYFAIL                  = 60068         /*  Failed to match publickey*/

}NETDEV_COMMON_ECODE_E;

/**
* @enum tagNETDEVMediaErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVMediaErrCode
{
    NETDEV_E_PLAYER_FAIL                        = 1001,     /*  Execution failure */
    NETDEV_E_PLAYER_INVALID_PARAM               = 1002,     /*  Illegal input parameters */
    NETDEV_E_PLAYER_NO_MEMORY                   = 1003,     /*  Insufficient system memory */
    NETDEV_E_PLAYER_SOCKET_FAIL                 = 1004,     /* SOCKET Failure to create SOCKET */
    NETDEV_E_PLAYER_RECV_FAIL                   = 1005,     /*  Failure to receive */
    NETDEV_E_PLAYER_RECV_ZERO                   = 1006,     /*  Receive zero */
    NETDEV_E_PLAYER_NOT_SUPPORT                 = 1007,     /*  Function not supported for the time being */
    NETDEV_E_PLAYER_CREATETHREAD_FAILED         = 1008,     /*  Failed to create thread */
    NETDEV_E_PLAYER_OPENDL_FAILED               = 1009,     /*  Failure to load dynamic library */
    NETDEV_E_PLAYER_SYMDL_FAILED                = 1010,     /*  Failure to obtain dynamic methods */
    NETDEV_E_PLAYER_SEND_FAILED                 = 1011,     /*  Fail in send */
    NETDEV_E_PLAYER_EACCES                      = 1012,     /*  Insufficient permission to create files */
    NETDEV_E_PLAYER_FILE_NOT_FIND               = 1013,     /*  Reading file not found */
    NETDEV_E_PLAYER_LOG_CLOSE                   = 1014,     /*  Log closes */
    NETDEV_E_PLAYER_MEDIA_EXCEPTION             = 1017,     /*  Media exception  */
    NETDEV_E_PLAYER_SYS_FAIL                    = 1018,     
    NETDEV_E_PLAYER_INIT_DONE                   = 1019,     
    NETDEV_E_PLAYER_SYS_RES_FAILED              = 1020,     
    NETDEV_E_PLAYER_INVALID_IP                  = 1021,     /* IP */
    NETDEV_E_PLAYER_EZSTREAMER_FULL             = 1022,     /* EZStreamer  */
    NETDEV_E_PLAYER_VOD_OVER_ABILITY            = 1023,     
    NETDEV_E_PLAYER_STREAM_IN_PROCESS           = 1024,     
    NETDEV_E_PLAYER_NO_SPARE_SESSION            = 1025,     
    NETDEV_E_PLAYER_NEED_AUTHENTICATE           = 1026,     
    NETDEV_E_PLAYER_GET_AUTHENTICATE_FAID       = 1027,     
    NETDEV_E_PLAYER_MAKE_AUTHENTICATE_FAID      = 1028,     
    NETDEV_E_PLAYER_AUTHENTICATEINFO_DIFF       = 1029,     
    NETDEV_E_PLAYER_SESSION_CLOSED              = 1030,     

    /*********************** Player ********************************/
    NETDEV_E_FAIL_TO_INIT_EZPLAYER              = 1257,     /*  Initialization player failed */
    NETDEV_E_FAIL_TO_ALLOC_PORT_RES             = 1258,     /*  Failed to allocate playback channel resources */
    NETDEV_E_FAIL_TO_GET_PORT_RES               = 1259,     /*  Failed to obtain playback channel resources*/
    NETDEV_E_BUFFER_QUEUE_FULL                  = 1260,     /*  Cache queue full */
    NETDEV_E_BUFFER_QUEUE_EMPTY                 = 1261,     /*  Cache queue empty */
    NETDEV_E_OPEN_FILE_FAILED                   = 1262,     /*  Fail to open file */
    NETDEV_E_FILE_READ_END                      = 1263,     /*  The file has been read out */
    NETDEV_E_FILE_DISKSPACE_FULL                = 1264,     /*  Disk space is full */
    NETDEV_E_FILE_READ_FAIL                     = 1265,     /*  Read failure */
    NETDEV_E_MCM_MIC_NOT_EXIST                  = 1266,     /*  Microphone does not exist */
    NETDEV_E_TS_PACKET_IN_THE_ROUGH             = 1267,     /* TS TS packaging not completed */
    NETDEV_E_FILE_RECORD_FINISH                 = 1268,     /*  The video has been saved.*/
    NETDEV_E_VIDEO_RESOLUTION_CHANGE            = 1269,     /*  Resolution changed */

    NETDEV_E_FAIL_TO_OPEN_STREAM                = 1513,     /*  Failed to start media stream playback */
    NETDEV_E_FAIL_TO_CLOSE_STREAM               = 1514,     /*  Failed to shut down media stream playback */
    NETDEV_E_FAIL_TO_RECV_DATA                  = 1515,     /*  Failure of receiving data due to network failure */
    NETDEV_E_FAIL_TO_PROCESS_MEDIA_DATA         = 1516,     /*  Media data processing failure */
    NETDEV_E_NOT_START_PLAY                     = 1517,     /*  Play channel did not start playback operation */
    NETDEV_E_FAIL_TO_INPUT_DATA                 = 1518,     /*  Input media streaming data failed */
    NETDEV_E_INPUTDATA_BUFFER_FULL              = 1519,     /*  Input data cached full */
    NETDEV_E_FAIL_TO_SET_PROCESS_DATA_CB        = 1520,     /*  Failed to set media stream data callback function */
    NETDEV_E_VOICE_RUNNING                      = 1521,     /*  Errors in Voice Service Operation */
    NETDEV_E_FAIL_TO_OPEN_VOICE_SVC             = 1522,     /*  Failure to start voice service */
    NETDEV_E_FAIL_TO_CLOSE_VOICE_SVC            = 1523,     /*  Failed to shut down voice service */
    NETDEV_E_UNKNOWN_STREAM_TYPE                = 1524,     /*  Unknown media stream */
    NETDEV_E_PACKET_LOSE                        = 1525,     /*  Packet loss */
    NETDEV_E_NEED_MORE_PACKET                   = 1526,     /*  Packing is not completed, more packages are needed */
    NETDEV_E_FAIL_TO_CREATE_DECODE              = 1527,     /*  Failed to create decoder */
    NETDEV_E_FAIL_TO_DECODE                     = 1528,     /*  Decoding failure */
    NETDEV_E_RECV_DATA_NOTENOUGH                = 1529,     /*  Insufficient data received */
    NETDEV_E_RENDER_RES_FULL                    = 1530,     /*  Display full resources */
    NETDEV_E_RENDER_RES_NOT_EXIST               = 1531,     /*  Show that resources do not exist */
    NETDEV_E_CREATE_DEV_FAILED                  = 1532,     /*  Resource creation failed */
    NETDEV_E_AUDIO_RES_NOT_EXIST                = 1533,     /*  Audio resources do not exist */
    NETDEV_E_IHW265D_NEED_MORE_BITS             = 1534,     /*  Decoder needs more data */
    NETDEV_E_FAIL_TO_CREATE_ENCODE              = 1535,     /*  Failure to create encoder */
    NETDEV_E_CAPTURE_RES_EXIST                  = 1536,     /*  Collection resources do not exist */
    NETDEV_E_RECORD_STARTED                     = 1537,     /*  The video has been turned on */
    NETDEV_E_NEED_WAIT_DECODEC                  = 1538,     /*  Undecoded, need to wait */
    NETDEV_E_MORE_DATA_NEED_PACKET              = 1539,     /*  There's too much data to pack. */
    NETDEV_E_AAC_LC_DECODE_FAIL                 = 1540,     /* AAC_LC AAC_LC decode failure*/
    NETDEV_E_RENDER_SURFACELOST                 = 1541,     
    NETDEV_E_FILE_ENCRYPED                      = 1543,     
    NETDEV_E_SCRAMBLING_INFO_FAILED             = 1544,     

    
    NETDEV_E_LIVE_EXISTED                       = 2000,     /*  Live business has been established */
    NETDEV_E_LIVE_INPUT_NOT_READY               = 2001,     /*  Media streaming is not ready */
    NETDEV_E_LIVE_OUTPUT_BUSY                   = 2002,     /*  Live business display resources busy */
    NETDEV_E_LIVE_CB_NOTEXIST                   = 2003,     /*  Real-time control block does not exist */
    NETDEV_E_LIVE_STREAM_FULL                   = 2004,     /*  Real-time flow resources are full */
    NETDEV_E_LIVE_NET_FAILED                    = 2005,     
    NETDEV_E_LIVE_NET_TIMEOUT                   = 2006,     
    NETDEV_E_LIVE_SHAKE_FAILED                  = 2007,     
    NETDEV_E_LIVE_AUTH_FAILED                   = 2008,     
    NETDEV_E_LIVE_INNER_ERROR                   = 2009,     
    NETDEV_E_LIVE_INNER_TIMEOUT                 = 2010,     
    NETDEV_E_LIVE_KEEP_ALIVE_FAILED             = 2011,     
    NETDEV_E_LIVE_SESSION_NOT_EXIST             = 2012,     
    NETDEV_E_LIVE_NOT_ENOUGH_BANDWIDTH2         = 2013,     
    NETDEV_E_LIVE_REALPLAY_ESTABLISHED          = 2014,     
    NETDEV_E_LIVE_REALPLAY_RES_BUSY             = 2015,     
    NETDEV_E_LIVE_MULTICAST_DISABLED            = 2016,     
    NETDEV_E_LIVE_MULTICAST_PORT_OCCUPIED       = 2017,     
    NETDEV_E_LIVE_MULTICAST_PORT_EXHAUSTED      = 2018,     
    NETDEV_E_LIVE_MULTICAST_USER_NOT_EXIST      = 2019,     
    NETDEV_E_LIVE_CHANNEL_NOT_ONLINE            = 2020,     
    NETDEV_E_LIVE_TALKBACK_ENCODED_INVALID      = 2021,     
    NETDEV_E_LIVE_VOICE_RES_USED_BY_TALKBACK    = 2022,     
    NETDEV_E_LIVE_TALKBACK_EXISTS               = 2023,     
    NETDEV_E_LIVE_VOICE_WORK_NOT_EXIST          = 2024,     
    NETDEV_E_LIVE_TALKBACK_TIMEOUT              = 2025,     
    NETDEV_E_LIVE_TALKBACK_ERROR                = 2026,     
    NETDEV_E_LIVE_UNDEFINED_ERROR               = 2027,     
    NETDEV_E_LIVE_BAD_REQUEST                   = 2028,     
    NETDEV_E_LIVE_UNAUTHORIZED                  = 2029,     
    NETDEV_E_LIVE_PAYMENT_REQUIRED              = 2030,     
    NETDEV_E_LIVE_FORIBIDDEN                    = 2031,     
    NETDEV_E_LIVE_METHOD_NOT_ALLOWED            = 2032,     
    NETDEV_E_LIVE_NOT_ACCEPTABLE                = 2033,     
    NETDEV_E_LIVE_PROXY_REQUIRED                = 2034,     
    NETDEV_E_LIVE_REQUEST_TIMEOUT               = 2035,     
    NETDEV_E_LIVE_GONE                          = 2036,     
    NETDEV_E_LIVE_LENGTH_REQUIRED               = 2037,     
    NETDEV_E_LIVE_PRECONDITION_FAILED           = 2038,     
    NETDEV_E_LIVE_ENTITY_TOO_LARGE              = 2039,     
    NETDEV_E_LIVE_URI_TOO_LARGE                 = 2040,     /* -URI */
    NETDEV_E_LIVE_UNSUPPORTED_TYPE              = 2041,     
    NETDEV_E_LIVE_NOT_UNDERSTOOD                = 2042,     
    NETDEV_E_LIVE_CONFERENCE_NOT_FOUND          = 2043,     
    NETDEV_E_LIVE_NOT_ENOUGH_BANDWIDTH          = 2044,     
    NETDEV_E_LIVE_SESSION_NOT_FOUND             = 2045,     
    NETDEV_E_LIVE_METHOD_NOT_VALID              = 2046,     
    NETDEV_E_LIVE_HEADER_NOT_VALID              = 2047,     
    NETDEV_E_LIVE_INVALID_RANGE                 = 2048,     
    NETDEV_E_LIVE_PARAMETER_READ_ONLY           = 2049,     
    NETDEV_E_LIVE_AO_NOT_ALLOWED                = 2050,     
    NETDEV_E_LIVE_ONLY_AO_ALLOWED               = 2051,     
    NETDEV_E_LIVE_UNSUPPORTED_TRANSPORT         = 2052,     
    NETDEV_E_LIVE_DESTINATION_UNREACHABLE       = 2053,     
    NETDEV_E_LIVE_INTERNAL_SERVER_ERROR         = 2054,     
    NETDEV_E_LIVE_NOT_IMPLEMENTED               = 2055,     
    NETDEV_E_LIVE_BAD_GATEWAY                   = 2056,     
    NETDEV_E_LIVE_SERVICE_UNAVAILABLE           = 2057,     
    NETDEV_E_LIVE_VERSION_NOT_SUPPORTED         = 2058,     /* RTSP */
    NETDEV_E_LIVE_GATEWAY_TIMEOUT               = 2059,     
    NETDEV_E_LIVE_OPTION_NOT_SUPPORTED          = 2060,     
    NETDEV_E_LIVE_MALLOC_FAIL                   = 2061,     
    NETDEV_E_LIVE_REALLOC_FAIL                  = 2062,     
    NETDEV_E_LIVE_DESCRIBE_TIMEOUT              = 2063,     /* describeGOP */
    NETDEV_E_LIVE_IPC_NOTBIND                   = 2064,     /* POEIPCPOEIPC */
    NETDEV_E_LIVE_DISK_ABNOMAL                  = 2065,     

    NETDEV_E_AUDIO_EXISTED                      = 2100,     /*  Speech intercom already exists */
    NETDEV_E_AUDIO_NO_EXISTED                   = 2101,     /*  Voice service does not exist */
    NETDEV_E_AUDIO_RESCODE_INVALID              = 2102,     /*  Invalid encoding of voice intercom resources */
    NETDEV_E_AUDIO_RES_USED_BY_TALK             = 2103,     /*   Audio resource is being used by two-way audio */
    NETDEV_E_AUDIO_FAILED                       = 2104,     /*  Speech intercom failure */
    NETDEV_E_AUDIO_AUDIOBCAST_FULL              = 2205,     /*   No more audio service allowed */

    NETDEV_E_CAPTURE_NO_SUPPORT_FORMAT          = 2200,     /*  Snapshot format does not support  */
    NETDEV_E_CAPTURE_NO_ENOUGH_CAPACITY         = 2201,     /*  Insufficient hard disk space */
    NETDEV_E_CAPTURE_NO_DECODED_PICTURE         = 2202,     /*  Undecoded pictures can be captured */
    NETDEV_E_CAPTURE_SINGLE_FAILED              = 2203,     /*  Single snap operation failed */

    NETDEV_E_OVER_ABILITY                       = 2301,     /*  Bit stream excess capability set */

    /*   Cloud media view exception report 2793~2809 */
    NETDEV_E_CLOUD_DOWNLOAD_FINISH              = 2793,     
    NETDEV_E_CLOUD_PARSE_DOMAIN_FAIL            = 2794,     
    NETDEV_E_CLOUD_CONNECT_FAIL                 = 2795,     
    NETDEV_E_CLOUD_CONNECT_TIMEOUT              = 2796,     
    NETDEV_E_CLOUD_DOWNLOAD_TIMEOUT             = 2797,     
    NETDEV_E_CLOUD_DOWNLOAD_FAIL                = 2798,     
    NETDEV_E_CLOUD_NETWORK_POOR                 = 2799,     
    NETDEV_E_CLOUD_PLAY_FINISH                  = 2800,     
    NETDEV_E_CLOUD_DISK_FULL                    = 2801,     
    NETDEV_E_CLOUD_AUTH_FAIL                    = 2802,     
    NETDEV_E_CLOUD_CURRENT_TIME                 = 2803,     
    NETDEV_E_CLOUD_PRIOR_DISK_FULL              = 2804,     
    NETDEV_E_CLOUD_NODE_NOT_EXIST               = 2805,     
    NETDEV_E_CLOUD_NO_CACHE_PATH                = 2806,     
    NETDEV_E_CLOUD_MSG_SEND_FAIL                = 2807,     
    NETDEV_E_CLOUD_TASK_CANCELLED               = 2808,     
    NETDEV_E_CLOUD_TASK_STREAM_CONTINUE         = 2809,     

    NETDEV_E_MEDIA_INPUT_NOT_READY              = 10000,    /*  Media streaming is not ready */
    NETDEV_E_CCB_STATR_INVALID                  = 10001,    /*  Control block state unavailable */
    NETDEV_E_MEDIA_OUTPUT_BUSY                  = 10002,    /*  Live business display resource busy */
    NETDEV_E_MEDIA_START_LOCAL_LIVE_ERR         = 10003,    /*  Live media streams are not ready */
    NETDEV_E_MEDIA_START_LOCAL_REPLAY_ERR       = 10004,    /*  Playback media streams are not ready */

    NETDEV_E_MEDIA_BW_RECV_NOT_ENOUGH           = 10007,    /*  Insufficient network reception bandwidth */
    NETDEV_E_MEDIA_BW_SEND_NOT_ENOUGH           = 10008,    /*  Insufficient network transmission bandwidth */
    NETDEV_E_MEDIA_AUDIO_BROADCAST_TO_LIMIT     = 10009,    /*  Voice broadcasting service has reached the upper limit */
    NETDEV_E_MEDIA_AUDIO_CHL_BING_USED          = 10010,    /*  Audio channel has been occupied */
    
    NETDEV_E_MEDIA_NOT_SUPPORT_ENCODETYPE       = 10012,    /*  Encode type Not supported */

    NETDEV_E_MEDIA_MAX                          = 10399     /*  Maximum Media Related Error Code */
}NETDEV_MEDIA_ECODE_E;

/**
* @enum tagNETDEVPtzErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPtzErrCode
{
    NETDEV_E_SET_PRESET_FAILED                  = 10400,    /*  Failure of preset setting */
    NETDEV_E_QUERY_PRESET_FAILED                = 10401,    /*  Failure of preset query */
    NETDEV_E_QUERY_TRACK_FAILED                 = 10402,    /*  Trajectory Query Failure */
    NETDEV_E_START_RECORD_TRACK_FAILED          = 10403,    /*  Failure to start recording trajectory */
    NETDEV_E_STOP_RECORD_TRACK_FAILED           = 10404,    /*  Failure to end recording trajectory */
    NETDEV_E_QUERY_CRUISE_FAILED                = 10405,    /*  Cruise line query failed */
    NETDEV_E_SET_CRUISE_FAILED                  = 10406,    /*  Failure to set up cruise routes */
    NETDEV_E_PTZ_COMMAND_FAILED                 = 10407,    /*  PTZ operation failed */
    NETDEV_E_PRESET_IN_CRUISE                   = 10408,    /* ,  Pre-positioning is used in cruise routes and cannot be deleted */
    NETDEV_E_CRUISEPOINT_ER                     = 10409,    /*  Setting Cruise Points Discontinuous */
    NETDEV_E_TRACK_ISUSED                       = 10410,    /*  Track is in use and cannot be deleted */
    NETDEV_E_SERIALMODE_MISMATCH                = 10411,    /*  Serial port mode mismatch */
    NETDEV_E_TRACK_NOT_EXIST                    = 10412,    /*  Trajectory does not exist */
    NETDEV_E_MODE_CRUISE_FULL                   = 10413,    /*  Number of path trajectory points of patterns is full*/
    NETDEV_E_PTZ_ISUSED                         = 10414,    /*  PTZ in use */
    NETDEV_E_PRESET_IN_GUARD                    = 10415,    /*  Prepositioning in Watch */
    NETDEV_E_CRUISE_PATH_IN_GUARD               = 10416,    /*  Cruise Path Used in Watch */

    NETDEV_E_PTZ_MAX                            = 10799     /*  Maximum error code of PTZ module */
}NETDEV_PTZ_ECODE_E;

/**
* @enum tagNETDEVVodErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVVodErrCode
{
    NETDEV_E_VOD_ABEND                          = 10800,    /*  Playback abnormal end */
    NETDEV_E_VOD_END                            = 10801,    /*  Playback end */
    NETDEV_E_VOD_CALL_DRV                       = 10802,    /*  Failed to call driver interface */
    NETDEV_E_VOD_CB_NOT_FIND                    = 10803,    /*  Control block not found */
    NETDEV_E_VOD_OVER_ABILITY                   = 10804,    /*  Exceeding playback capability */
    NETDEV_E_VOD_TAG_OVER_LIMIT                 = 10805,    /*  The number of labels exceeds the limit */
    NETDEV_E_VOD_NO_RECORDING                   = 10806,    /*    No recording */
    NETDEV_E_VOD_SMART_NOT_SUPPORT              = 10807,    /*  GB device does not support smart playback*/
    NETDEV_E_VOD_NO_REPLAYURL                   = 10808,    /* url   Cannot get the URL for playback*/

    NETDEV_E_VOD_MAX                            = 10999     /*  Maximum error code of playback module */
}NETDEV_VOD_ECODE_E;

/**
* @enum tagNETDEVStorErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVStorErrCode
{
    NETDEV_E_STOR_ABEND                         = 101000,   /*  Storage exception termination */
    NETDEV_E_ARRAY_NAME_EXITS                   = 11001,    /*  Array already exists */
    NETDEV_E_NOT_RAID_MODE                      = 11002,    /*  Non-array mode */
    NETDEV_E_NO_STORE_PLAN                      = 11003,    /*  The channel is not equipped with a video plan. */
    NETDEV_E_DISK_ZERO_OR_ABNORMAL              = 11022,    /*  No hard disk or hard disk abnormalities */
    NETDEV_E_SLOT_NOT_NORMAL                    = 11023,    /* 1 Slot 1 disk is out of order*/
    NETDEV_E_SLOT_RECONNECT                     = 11024,    /* 1 After opening the face, slot 1 is pulled out and inserted. It needs to be restarted. */
    NETDEV_E_BATTERY_STATUS_FAULT               = 11034,    /*  Abnormal battery status of equipment */
    NETDEV_E_CHL_QUOTA_EXIST                    = 11035,    
    NETDEV_E_RAIDLUN_ABNORMAL                   = 11036,    /* vms-ipsan */
    NETDEV_E_DATABASE_STATUS_ABNORMAL           = 11037,    /*  Database status abnormal */

    NETDEV_E_STOR_MAX                           = 11199     /*  Maximum error code of storage module */
}NETDEV_STOR_ECODE_E;

/**
* @enum tagNETDEVUserErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVUserErrCode
{
    NETDEV_E_USER_NOT_ONLINE                    = 101200,   /*  Users are not online */
    NETDEV_E_USER_WRONG_PASSWD                  = 11201,    /*  User password error */
    NETDEV_E_USER_NO_SUCH_USER                  = 11202,    /*  No user */
    NETDEV_E_USER_NO_AUTH                       = 11203,    /*  User has no privilege */
    NETDEV_E_USER_MAX_NUM                       = 11204,    /* - User cap - cannot be added */
    NETDEV_E_USER_EXIST                         = 11205,    /*  User already exists */
    NETDEV_E_USER_LOGIN_MAX_NUM                 = 11206,    /*  The number of users logged in has reached the upper limit. */
    NETDEV_E_USER_LOCKED                        = 11207,    /*  The user has been locked */
    NETDEV_E_USER_IS_ADMIN                      = 11208,    /*  This operation is not allowed. The user is the system administrator. */
    NETDEV_E_USER_NOT_VALID_PERIOD              = 11209,    /*  Not within the validity period */
    NETDEV_E_USER_ROLE_BEYOND_RANGE             = 11210,    /*  The number of user roles exceeds the upper limit */
    NETDEV_E_USER_SELOG_IP_LOCKED               = 11211,    /*  User security logon lock*/
    NETDEV_E_ROLE_EXIST                         = 11212,    /*  Roles already exist */
    NETDEV_E_USER_NOT_VALID_TIME                = 11213,    /*  Not in the valid period */
    NETDEV_E_USER_WEAK_PASSWD_LOGIN_FAIL        = 11214,    /* , Logon failed. Please try remote login again after changing the local network to a strong password. */
    NETDEV_E_USER_IS_TEMPPASSWD                 = 11217,    /*  Users log in with temporary passwords */
    NETDEV_E_USER_TEMPPASSWD_LOGIN_FAIL         = 11218,    /*  Temporary password of public network prohibits landing */
    NETDEV_E_USER_WEAK_PASSWD_MODIFY            = 11219,    /*  Force password modification */
    NETDEV_E_USER_IP_NO_AUTH                    = 11221,    /* IP Login IP has no permission */

    NETDEV_E_USER_MAX                           = 11599     /*  Maximum error code of user module*/
}NETDEV_USER_ECODE_E;

/**
* @enum tagNETDEVDevErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVDevErrCode
{
    NETDEV_E_DEV_NOT_ONLINE                     = 11600,    /*  The device is not online */
    NETDEV_E_DEV_WRONG_PASSWD                   = 11601,    /*  Device password error */
    NETDEV_E_DEV_REPEAT_DEV                     = 11602,    /*  Repetitive equipment */
    NETDEV_E_DEV_NO_SUCH_DEV                    = 11603,    /*  No equipment */
    NETDEV_E_DEV_NO_SUCH_CHL                    = 11604,    /*  No channel */
    NETDEV_E_DEV_MAX_NUM                        = 11605,    /* - VMS equipment upper limit - Can't be added anymore*/
    NETDEV_E_DEV_LOGIN_MAX_NUM                  = 11606,    /*  Upper limit of device logon number */
    NETDEV_E_DEV_COMMON_FAILED                  = 11607,    /*  Common errors returned by devices */
    NETDEV_E_DEV_NO_SUCH_DEV_OID                = 11608,    /* ID No device history ID exists */
    NETDEV_E_DEV_DEL_FORBID                     = 11609,    /*  Devices are not allowed to be deleted */
    NETDEV_E_CHL_OFFLINE                        = 11610,    /*  Channel not online */
    NETDEV_E_DEV_TYPE_UNMATCHED                 = 11611,    /*  Mismatch of device type added */
    NETDEV_E_DEV_REPEAT_DEV_NAME                = 11612,    /*  Duplicate device name */
    NETDEV_E_DEV_CFG_FAILED                     = 11613,    /*  Device configuration failure */
    NETDEV_E_DEV_NO_RESULT                      = 11614,    /*  Inquiries without results */
    NETDEV_E_DEV_DEC_OFFLINE                    = 11617,    /*   116151161611617 Decoding equipment offline 11615, 11616 error code integration machine has been used, so the new 11617 */

    NETDEV_E_DEV_VCA_ALARM_NO_PIC               = 11661,    /* VCA Failed to get VCA alarm picture */

    
    NETDEV_E_COMMON_FAIL_STAT                   = 11801,    /*  Failed to read file (directory) status */
    NETDEV_E_COMMON_FILE_NONEXIST               = 11802,    /*  File does not exist */
    NETDEV_E_COMMON_MKDIR_ERR                   = 11803,    /*  Failed to create directory */
    NETDEV_E_SUBSCRIBE_FULL                     = 11804,    /* ,  This user's subscription is full and the error code of the device side user's subscription is full cannot be returned. */
    NETDEV_E_UPGRADE_NOTADMIN                   = 11805,    /* admin Non-admin users cannot upgrade */
    NETDEV_E_UPGRADE_INVALID                    = 11806,    /*   Upgrade not started */
    NETDEV_E_UPGRADE_INPROCESS                  = 11807,    /*   Upgrade processing */
    NETDEV_E_UPGRADE_NOMEMORY                   = 11808,    /*   Insufficient upgrade memory space */
    NETDEV_E_UPGRADE_FILE_OPEN_ERR              = 11809,    /*   Upgrade error opening mirror file */
    NETDEV_E_UPGRADE_DEVICE_ERR                 = 11810,    /*  FLASH Error upgrading FLASH */
    NETDEV_E_UPGRADE_BUSY                       = 11811,    /*  Multiple upgrade processes cannot be loaded at the same time */
    NETDEV_E_UPGRADE_FAIL_TIMEOUT               = 11812,    /*  Upgrade timeout */
    NETDEV_E_INVALID_CONFIGFILE                 = 11813,    /*  Invalid configuration file */
    NETDEV_E_STOR_RESOURCE_NOTINIT              = 11814,    /*  Unallocated storage resources */

    NETDEV_E_DEV_MAX                            = 11999     /*  Maximum error code of equipment module */

}NETDEV_DEV_ECODE_E;

/**
* @enum tagNETDEVOrgErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVOrgErrCode
{
    NETDEV_E_ORG_MAX_NUM                        = 12000,    /* - Organizational cap - cannot be added */
    NETDEV_E_ORG_MAX_LEVEL                      = 12001,    /*  Upper limit of organizational hierarchy */
    NETDEV_E_ORG_RESOURCE_EXIST                 = 12002,    /* - Organizational resources - cannot be deleted */
    NETDEV_E_ORG_EXIST                          = 12003,    /*  Organizations already exist under the same branch*/
    NETDEV_E_ORG_NO_SUCH_ORG                    = 12004,    /*  Organization does not exist */
    NETDEV_E_ORG_IS_ROOT                        = 12005,    /*  This operation is not allowed. The organization is the root organization.*/
    NETDEV_E_ORG_NO_SUCH_PORG                   = 12006,    /*  Paternal organization does not exist */
    NETDEV_E_ORG_SUB_EXIST                      = 12007,    /* , Organized, not deleted */

    NETDEV_E_ORG_MAX                            = 12399     /*  Maximum error code value of organization module*/
}NETDEV_ORG_ECODE_E;

/**
* @enum tagNETDEVTvwallErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVTvwallErrCode
{
    NETDEV_E_TVWALL_WND_NUMLIMITED              = 12400,    /*  The number of windows exceeds the limit */
    NETDEV_E_TVWALL_NUMLIMTED                   = 12401,    /*  The number of TV walls exceeds the limit */
    NETDEV_E_TVWALL_LED_NUMLIMTED               = 12402,    /* LED The number of virtual LEDs exceeds the limit */
    NETDEV_E_TVWALL_LED_LINELIMTED              = 12403,    /* LED Single virtual LED line number exceeding limit */
    NETDEV_E_TVWALL_SCENE_OVER_LIMIT            = 12404,    /*  The number of scenes of single TV Wall exceeds the limit */
    NETDEV_E_TVWALL_BASEPIC_NUMLIMITED          = 12405,    /*  The number of base diagrams that the device can store exceeds the limit */
    NETDEV_E_TVWALL_BASEPIC_SCENELIMITED        = 12406,    /*  The number of backgrounds that a single scene can bind exceeds the limit */
    NETDEV_E_TVWALL_DECODE_OUTRANGE             = 12407,    /*  Destination position super-decoding capability */
    NETDEV_E_TVWALL_WND_OUTRANGE                = 12408,    /*  The area of window opening has exceeded three times the area of window opening.*/
    NETDEV_E_TVWALL_WND_RANGELIMITED            = 12409,    /* / Window position/roaming position out of range */
    NETDEV_E_TVWALL_SCROLL_LED_NUMLIMITED       = 12410,    /* LED The number of Rolling virtual LEDs exceeds the limit */

    NETDEV_E_TVWALL_WND_LOCKED                  = 12430,    /*  The current window has been locked */
    NETDEV_E_TVWALL_LED_NOTEXIST                = 12431,    /* LED Virtual LED does not exist */
    NETDEV_E_TVWALL_SEQ_EXISTD                  = 12432,    /*  Rotary cutting already exists */
    NETDEV_E_TVWALL_WND_NOTEXIST                = 12433,    /*  Window does not exist */
    NETDEV_E_TVWALL_WND_EXIST                   = 12434,    /*  The window already exists */
    NETDEV_E_TVWALL_SPILT_NOTEXIST              = 12435,    /*  The split screen in the window does not exist */
    NETDEV_E_TVWALL_WND_NOSPILT                 = 12436,    /*  Windows cannot be split */
    NETDEV_E_TVWALL_CHANNEL_UESED               = 12437,    /*  Decoding channel occupied by other TV wall */
    NETDEV_E_TVWALL_WINDEXIST                   = 12438,    /*  TV Wall Existence Window */
    NETDEV_E_TVWALL_NOTEXIST                    = 12439,    /*  TV wall information does not exist */
    NETDEV_E_TVWALL_SPLIT_INFOERR               = 12440,    /*  Error splitting type */
    NETDEV_E_TVWALL_CHANNEL_NUMERR              = 12411,    /*  Error in channel number */
    NETDEV_E_TVWALL_ENC_ERR                     = 12442,    /*  Media streaming is not ready */
    NETDEV_E_TVWALL_PERSCREEN_NUMLIMITED        = 12443,    /* VO The number of windows exceeds the limit*/
    NETDEV_E_TVWALL_FILE_PROCESSING             = 12444,    
    NETDEV_E_TVWALL_STREAM_CANNOT_REPEAT        = 12445,    
    NETDEV_E_TVWALL_EXCESS_AREA                 = 12446,    /* ,65 */
    NETDEV_E_TVWALL_DISPLAY_MODE_CONFLICT       = 12447,    
    NETDEV_E_TVWALL_SERIAL_MOD_ERR              = 12448,    /* web */
    NETDEV_E_TVWALL_MAX                         = 12799     /*  Maximum error code value of tv wall module*/
}NETDEV_TVWALL_ECODE_E;

/**
* @enum tagNETDEVNetErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVNetErrCode
{
    NETDEV_E_IPADDR_CONFLICT                    = 12800,    /* IP IP Address Conflict */
    NETDEV_E_UPNP_PORT_DISCARD                  = 12801,    /*  The mapped port is discarded */
    NETDEV_E_UPNP_PORT_EMPLOY                   = 12802,    /*  Port occupied */
    NETDEV_E_SET_VMP_PORT_FAILED                = 12803,    /* VMP Failed to set VMP port */
    NETDEV_E_SET_MEDIA_PORT_FAILED              = 12804,    /*  Failed to set media stream port */
    NETDEV_E_SET_RTSP_PORT_FAILED               = 12805,    /* RTSP Failed to set RTSP port */
    NETDEV_E_SET_ONVIF_PORT_FAILED              = 12806,    /* ONVIF Failed to set ONVIF port */
    NETDEV_E_SET_HTTPS_PORT_FAILED              = 12807,    /* HTTPS Failed to set HTTPS port */
    NETDEV_E_SET_HTTP_PORT_FAILED               = 12808,    /* HTTP Failed to set HTTP port */
    NETDEV_E_TEST_EMAIL                         = 12809,    /*  Failed to send test mail */
    NETDEV_E_DDNS_INIT                          = 12810,    /*  Initialize default values */
    NETDEV_E_DDNS_GOOD                          = 12811,    /*  Update completed*/
    NETDEV_E_DDNS_NOCHG                         = 12812,    /* ,ip The update is complete, but the IP address remains unchanged */
    NETDEV_E_DDNS_BADAUTH                       = 12813,    /*  Error username password */
    NETDEV_E_DDNS_DONATOR                       = 12814,    /* offline URL Special options require service fees similar to offline URLs */
    NETDEV_E_DDNS_NOTFQ                         = 12815,    /*  Host name format is not qualified */
    NETDEV_E_DDNS_NOHOST                        = 12816,    /*  The hostname account does not exist */
    NETDEV_E_DDNS_NUMHOST                       = 12817,    /* 20 More than 20 hosts are requested to update immediately */
    NETDEV_E_DDNS_ABUSE                         = 12818,    /*  Host name is disabled due to abuse */
    NETDEV_E_DDNS_BADAGENT                      = 12819,    /* HTTP The proxy sends the wrong HTTP request format */
    NETDEV_E_DDNS_GOOD_127                      = 12820,    /* 127.0.0.1http Unless the client wants to update 127.0.0.1, this information indicates an error in the HTTP request specification */
    NETDEV_E_DDNS_DNSERR                        = 12821,    /* DNSSupport DNS error, please contact Support*/
    NETDEV_E_DDNS_911                           = 12822,    /*  Service maintenance is being processed */
    NETDEV_E_DDNS_REQ                           = 12823,    /* DDNS DDNS request failed to send */
    NETDEV_E_DDNS_CHECK_KEY                     = 12824,    /*  Check code error */
    NETDEV_E_DDNS_BAD_NAME_FORMAT               = 12825,    /*  Domain name format is not qualified */
    NETDEV_E_DDNS_DOMAIN_CONFLICT               = 12826,    /*  Domain name conflict */
    NETDEV_E_DDNS_CLOSE                         = 12827,    /* ddnsddns Non-ddns server returns, only for closing DDNS record status */
    NETDEV_E_CREATE_CERT_FAILD                  = 12828,    /*  Certificate file generation failed */
    NETDEV_E_GET_CERT_FAILD                     = 12829,    /*  It is illegal to upload certificate files */
    NETDEV_E_TEST_EMAIL_CHECKSERVER_INFO        = 12830,    /*  Error in username or password of authentication server */
    NETDEV_E_TEST_EMAIL_COMM                    = 12831,    /* , Mail delivery failed. Check network and mail configuration */
    NETDEV_E_TEST_EMAIL_TIMEOUT                 = 12832,    /*  Mail Delivery Timeout */
    NETDEV_E_CLOUD_REPEAT_USER                  = 12833,    /*  The cloud account is logged in */
    NETDEV_E_CLOUD_DEV_ADD_FAIL                 = 12834,    /*  Failed to add cloud device information */
    NETDEV_E_CLOUD_ORG_NULL                     = 12835,    /*  Cloud organizational information is empty */
    NETDEV_E_GET_CLOUD_ORG                      = 12836,    /*  Cloud information cannot be obtained. Check network configuration */
    NETDEV_E_NO_SUCH_CLOUD_USER                 = 12837,    /*  Cloud account does not exist */

    NETDEV_E_NET_MAX                            = 13199     /*  Maximum Error Code Value of Network Module */
}NETDEV_NET_ECODE_E;

/**
* @enum tagNETDEVXMLCfgErrCode
* @brief CFG - XML
* @attention  None
*/
typedef enum tagNETDEVXMLCfgErrCode
{
    NETDEV_E_CONF_FILE_INVALID                  = 13200,    /*  Illegal configuration file */
    NETDEV_E_LOAD_XML_FAIL                      = 13201,    /* XML Failed to export XML file */
    NETDEV_E_SAVE_XML_FAIL                      = 13202,    /* XML Failed to generate XML file */
    NETDEV_E_XML_ATTR_INEXIST                   = 13203,    /* XML XML attribute information does not exist */
    NETDEV_E_XML_SYNC_CFG_FAILED                = 13204,    /* , Configuration area synchronization error to save configuration synchronously when system restart */
    NETDEV_E_SIMPLE_RECOVER_CFG_FAILED          = 13205,    /*  Simple Recovery Configuration Error */
    NETDEV_E_RECOVER_CFG_FAILED                 = 13206,    /*  Complete Recovery Configuration Error */
    NETDEV_E_CONF_FORBID_WRITE                  = 13207,    /*  Disable Writing Configuration */

    NETDEV_E_XML_MAX                            = 13599     /* XML Maximum Error Code Value of XML Module */
}NETDEV_XML_ECODE_E;

/**
* @enum tagNETDEVPlanErrCode
* @brief plan
* @attention  None
*/
typedef enum tagNETDEVPlanErrCode
{
    NETDEV_E_PLAN_TEMPLATE_BUSY                 = 13600,    /*  Template is being used */
    NETDEV_E_PLAN_TEMPLATE_NOT_EXIST            = 13601,    /*  Time template node does not exist */
    NETDEV_E_PLAN_INVALID_HOLIDAY_TIME          = 13602,    /*  Illegal Holiday Time */
    NETDEV_E_PLAN_NO_PLAN                       = 13603,    /*  No plan */
    NETDEV_E_PLAN_NOT_IN_PLAN                   = 13604,    /*  Not planned */
    NETDEV_E_PLAN_IN_PLAN                       = 13605,    /*  Within the plan */

    NETDEV_E_PLAN_MAX                           = 13699     /* Plan Maximum Error Code Value of Plan Module */
}NETDEV_PLAN_ECODE_E;

/**
* @enum tagNETDEVMTErrCode
* @brief MT  -  
* @attention  None
*/
typedef enum tagNETDEVMTErrCode
{
    NETDEV_E_UPDATE_VERSION_FAIL                = 13700,    /*  Equipment upgrade, version number mismatch */
    NETDEV_E_UPDATE_BOARDTYPE_NOT_MATCH         = 13701,    /*  Equipment upgrade, equipment type mismatch */
    NETDEV_E_FILE_CHECK_FAILED                  = 13702,    /*  Document Check Error */
    NETDEV_E_EXPORT_CFG_FAILED                  = 13703,    /*  Export configuration error */
    NETDEV_E_IMPORT_CFG_FAILED                  = 13704,    /*  Import configuration error */
    NETDEV_E_UPDATE_OTHER_REASON                = 13705,    /*  Device upgrade, memory application or other reasons may fail */
    NETDEV_E_MAINTAIN_EXPORT_RUNNING            = 13706,    /*  Maintenance information is being exported */

    NETDEV_E_MT_MAX                             = 13799     /* MT Maximum error code value of MT module */
}NETDEV_MT_ECODE_E;

/**
* @enum tagNETDEVLinkageErrCode
* @brief LINKAGE  -  
* @attention  None
*/
typedef enum tagNETDEVLinkageErrCode
{
    NETDEV_E_LINKAGE_GUARD_PRO_ALREADY_EXIT     = 13800,    /*  Preventive clothing plan already exists */
    NETDEV_E_LINKAGE_GUARD_PRO_NOT_EXIST        = 13801,    /*  The designated deployment plan does not exist */
    NETDEV_E_LINKAGE_LINK_RULE_NOT_EXIST        = 13802,    /*  The specified linkage rule does not exist */

    NETDEV_E_LINKAGE_MAX                        = 13899    /* Linkage Maximum Error Code Value of Linkage Module */
}NETDEV_LINKAGE_ECODE_E;

/**
* @enum tagNETDEVAlarmErrCode
* @brief alarm
* @attention  None
*/
typedef enum tagNETDEVAlarmErrCode
{
    NETDEV_E_ALARM_RESTRAIN                     = 13900     /*  Alarm suppression */
}NETDEV_ALARM_ECODE_E;

/**
* @enum tagNETDEVEMaprrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVEMaprrCode
{
    NETDEV_E_EMAP_PIC_MAX_NUM                   = 15000,    /*  The number of pictures reached the upper limit and could not be added. */
    NETDEV_E_EMAP_DIR_EXIST                     = 15001,    /*  The root directory already exists in the electronic map */
    NETDEV_E_EMAP_MAX                           = 15099     /*  Maximum Error Code Value of Electronic Map Module */
}NETDEV_EMAP_ECODE_E;

/**
* @enum tagNETDEVPASCErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPASCErrCode
{
    NETDEV_E_PACS_PERSON_NO_EXIST               = 17000,    /*  No entrance guards exist */
    NETDEV_E_PACS_PERSON_EXIST                  = 17001,    /*  Access guards already exist */
    NETDEV_E_PACS_PERSON_CARD_EXIST             = 17002,    /*  Access card already exists */
    NETDEV_E_PACS_PERSON_CARD_NO_EXIST          = 17003,    /*  No access card exists*/
    NETDEV_E_PACS_PERSON_CARD_REACH_LIMIT       = 17004,    /*  The number of access cards has reached the upper limit. */
    NETDEV_E_PACS_ACCESS_RECORD_NO_EXIST        = 17005,    /*  Personnel access records do not exist*/
    NETDEV_E_PACS_CHL_NO_EXIST                  = 17006,    /*  Access control channel does not exist*/
    NETDEV_E_PACS_PRMISS_ID_EXIST               = 17007,    /*   Personnel with access control authority do not exist*/
    NETDEV_E_PACS_PERSON_DEPT_ID_NO_EXIST       = 17008,    /* ID Personnel Departmental ID of Access Control Personnel does not exist*/
    NETDEV_E_PACS_PERSON_RECORD_ID_NO_EXIST     = 17009,    /* ID Personnel access record ID does not exist*/
    NETDEV_E_PACS_DEPT_ID_PREMISSIONED          = 17010,    /*   Departmental authority already exists*/
    NETDEV_E_PACS_PERMISSION_EXIT_PERSON        = 17011,    /*  The permission group has Person and cannot be deleted. */
    NETDEV_E_PACS_BLACKLIST_PERSON_EXIST        = 17012,    /*  Existing blacklist Persons . */
    NETDEV_E_PACS_BLACKLIST_NOT_ADD             = 17013,    /*  Blacklist visitors cannot be added. */
    NETDEV_E_PACS_MAX                           = 17999     /* PACS Maximum Error Code of PACS Module */
}NETDEV_PACS_ECODE_E;

/**
* @enum tagFaceSmartModeErrCode
* @brief 
* @attention  None
*/
typedef enum tagFaceSmartModeErrCode
{
    NETDEV_E_FACE_BD_NO_MEMBER                  = 19000,    /*  No member in face database */
    NETDEV_E_FACE_GUARD_NO_EXIST                = 19001,    /*  Control task does not exist */
    NETDEV_E_FACE_ALARM_LOG_NO_EXIST            = 19002,    /*  There is no alarm record for face recognition */
    NETDEV_E_SMART_GET_FACE_IMAGE_FAIL          = 19003,    /*  Failure in capturing face images */
    NETDEV_E_NO_UID_AVAILABLE                   = 19004,    /* Uid No Uid is available */

    NETDEV_E_FACE_LIB_COUNT_MAX                 = 19005,    /*  Maximum number of face databases */
    NETDEV_E_FACE_GUARD_COUNT_MAX               = 19006,    /*  The number of control tasks in the face database has reached the maximum. */
    NETDEV_E_FACE_MEMBER_COUNT_MAX              = 19007,    /*  The maximum number of face members has been achieved in this face database. */
    NETDEV_E_FACE_IDENTI_NUM_EXIST              = 19008,    /*  Document number already exists */
    NETDEV_E_FACE_FEAT_VERTION_UNMATCH          = 19009,    /*  Version mismatch of device face recognition algorithm */
    NETDEV_E_VEHICLE_GUARD_NO_EXIST             = 19010,    /*  Vehicle control tasks do not exist */
    NETDEV_E_SLAVE_PLATE_IMAGE_GET_FAIL         = 19011,    /*  Failure to obtain license plate image */
    NETDEV_E_VEHICLE_LOG_NO_EXIST               = 19012,    /*  Vehicle records do not exist */
    NETDEV_E_GET_SLAVE_PIC_FAIL                 = 19013,    /*  Failed to get slave picture */
    NETDEV_E_GUARD_DEV_VIID_OFFLINE             = 19014,    /*  Out-of-line status of view Library of distribution control equipment */
    NETDEV_E_GUARD_GUARD_DEV_NOW                = 19015,    /*  In Distribution Control Equipment */
    NETDEV_E_GUARD_GUARD_NOT_ENABLE             = 19020,    /*  This control task is not enabled */
    NETDEV_E_GUARD_GUARD_NOW                    = 19021,    /*  In charge control */
    NETDEV_E_GUARD_DIFFERENT_IMAGE_PROTOCOL     = 19022,    
    NETDEV_E_ROOT_LIB_HAS_MONITORED_MEMBER      = 19023,    
    NETDEV_E_CAN_NOT_CANCEL_SORT                = 19024,    
    NETDEV_E_SMART_MAX                          = 19999     /*  Maximum Error Code of Intelligent Module */
}NETDEV_FACE_SMART_ERR_CODE_E;

/**
* @enum tagMonitorErrCode
* @brief 
* @attention  None
*/
typedef enum tagMonitorErrCode
{
    NETDEV_E_VIID_DISPOSE_DEV_BUSY                  = 25006,  /*  View library layout control error, equipment busy */
    NETDEV_E_VIID_DISPOSE_DATABASE_FULL             = 25007,  /* , View database layout control error, face database has reached the upper limit */
    NETDEV_E_VIID_DISPOSE_MEMBER_FULL               = 25008,  /* , View database layout control error, face members have reached the upper limit */
    NETDEV_E_VIID_DISPOSE_NO_SMARTBAR               = 25009,  /* , View Library Layout Control Error, Device Smart Bar does not exist */
    NETDEV_E_VIID_DISPOSE_VIID_OFFLINE              = 25010   /* , View Library Layout Error, Device View Library Not Connected */
}NETDEV_MONITOR_ERR_CODE_E;

/**
* @enum tagCloudRemoteErrCode
* @brief 
* @attention  None
*/
typedef enum tagCloudRemoteErrCode
{
    NETDEV_E_CLOUD_REGISTER_BY_OTHER                = 20000,  /*  Not your device */
    NETDEV_E_CLOUD_CHL_NOT_EXIST                    = 20001,  /*  Channel does not exist */
    NETDEV_E_CLOUD_SREAMID_NOT_EXIST                = 20002,  /* ID Flow ID does not exist */
    NETDEV_E_CLOUD_BITRATE_UNEXPECTED               = 20003,  /*  Excessive request rate */
    NETDEV_E_CLOUD_LIVEID_NOT_EXIST                 = 20004,  /* ID Live ID does not exist */
    NETDEV_E_CLOUD_PROTO_TYPE_ILLEGAL               = 20005,  /*  Request Flow Protocol does not support */
    NETDEV_E_CLOUD_CLIENTID_NOT_EXIST               = 20006,  /* ID Client ID does not exist */
    NETDEV_E_CLOUD_REQUESTID_NOT_EXIST              = 20007,  /* RequestID RequestID does not exist */
    NETDEV_E_CLOUD_VISITOR_TOTAL_UNEXPECTED         = 20008,  /*  Too many current online users */
    NETDEV_E_GET_RTMP_URL_FAIL                      = 20009,  /* RTMPURL Failed to obtain RTMP pull URL */
    NETDEV_E_GET_PUSH_STREAM_STATE_FAIL             = 20010,  /*  Failure to acquire push-flow status*/
    NETDEV_E_START_PULL_STREAM_FAIL                 = 20011,  /*  Start-up pull-out failure */
    NETDEV_E_GET_CLOUD_DEV_LIST_FAIL                = 20012,  /*  Failed to get the list of cloud devices */
    NETDEV_E_GET_DEV_INFO_FAILED                    = 20013,  /*  Failed to obtain cloud device information */
    NETDEV_E_GET_NAT_TYPE_FAIL                      = 20014,  /* NAT Failed to get NAT type */
    NETDEV_E_MODIFT_CLOUD_DEV_NAME_FAIL             = 20015,  /*  Failed to update cloud device name */
    NETDEV_E_DELETE_CLOUD_DEVICE_FAIL               = 20016,  /*  Failed to delete cloud devices */
    NETDEV_E_STOP_PULL_STREAM_FAIL                  = 20017,  /*  Stop pulling and lose */
    NETDEV_E_KEEP_ALIVE_PULL_STREAM_FAIL            = 20018,  /*  Failure of Pushing Flow to Preserve Life */
    NETDEV_E_KEEP_ALIVE_LIST_EMPTY                  = 20019,  /*  The live list is empty */
    NETDEV_E_GET_LIVE_ID_FAIL                       = 20020,  /* ID Failed to get live ID */
    NETDEV_E_CLOUD_INVALID_FORMAT                   = 20021,  /*  Illegal format */
    NETDEV_E_CLOUD_NOT_REGISTER                     = 20022,  /*  The device is not registered */
    NETDEV_E_CLOUD_INVALID_REG_CODE                 = 20023,  /*  Registration code does not exist */
    NETDEV_E_CLOUD_NOT_SHARE_TO_SELF                = 20024,  /*  Can't share with oneself */
    NETDEV_E_ADD_CLOUD_DEVICE_FAIL                  = 20025,  /*  Failed to add cloud devices */
    NETDEV_E_GET_CLOUD_DDNS_FAIL                    = 20026,    /* DDNS Failed to obtain DDNS information */
    NETDEV_E_GET_CLOUD_ORG_LIST_FAIL                = 20027,    /*  Failed to retrieve cloud organization list */
    NETDEV_E_FIND_SHARE_DEVLIST_ERROR               = 20028,    /*  Failed to get shared device list */
    NETDEV_E_START_DEVICE_SHARE_FAIL                = 20029,    /*  Failure to start device sharing */
    NETDEV_E_STOP_DEVICE_SHARE_FAIL                 = 20030,    /*  Failure to Stop Cloud Device Sharing */
    NETDEV_E_GET_SHARE_RECORD_INFO_FAIL             = 20031,    /*  Failed to obtain cloud shared record information */
    NETDEV_E_GET_CLOUD_DEV_POPULATION               = 20032,    /*  Failed to obtain cloud account device statistics */
    NETDEV_E_ADD_CLOUD_ORG_FAIL                     = 20033,    /*  Increasing cloud Organizational Failure */
    NETDEV_E_MODIFY_CLOUD_ORG_FAIL                  = 20034,    /*  Failure to modify cloud organization */
    NETDEV_E_DELETE_CLOUD_ORG_FAIL                  = 20035,    /*  Failed to delete cloud organizations */
    NETDEV_E_ADD_DEV_TO_CLOUD_ORG_FAIL              = 20036,    /*  Failure to add devices to cloud organizations */
    NETDEV_E_GET_CLOUD_DEV_CHANNEL_LIST_FAIL        = 20037,    /*  Failure to access cloud device channel */
    NETDEV_E_GET_CLOUD_VIDEO_TIME_FAIL              = 20038,    /*  Failed to get cloud video time information */
    NETDEV_E_GET_CLOUD_VIDEO_M3U8_FAIL              = 20039     /* M3u8 Failed to get cloud video M3u8 information */
}NETDEV_CLOUD_REMOTE_ERR_CODE_E;

/**
* @enum tagNETDEVSnapshotErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVSnapshotErrCode
{
    NETDEV_E_SNAPSHOT_PIC_FAILED                    = 27000,     
    NETDEV_E_SNAPSHOT_QRY_PIC_FAILED                = 27001,     
    NETDEV_E_SNAPSHOT_MAX                           = 27999      
}NETDEV_SNAPSHOT_ERR_CODE_E;

/**
* @enum tagNETDEVSmartLockErrCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVSmartLockErrCode
{
    NETDEV_SLOCK_ROOM_DUPLICATE                     = 29006,    
    NETDEV_ROOM_PERSON_DUPLICATE                    = 29007,    
    NETDEV_SLOCK_DEV_BINDED                         = 29008,    
    NETDEV_SLOCK_MAX                                = 29999     
}NETDEV_SMARTLOCK_ERR_CODE_E;

/* END*********************   Error codes *********************************************************** */

/* BEGIN:******************   Enumeration value ***************************************************** */
/**
 * @enum tagNETDEVChannelStatus
 * @brief   Channel status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelStatus
{
    NETDEV_CHL_STATUS_OFFLINE   = 0,             /*   Channel offline */
    NETDEV_CHL_STATUS_ONLINE    = 1,             /*   Channel online */
    NETDEV_CHL_STATUS_UNBIND    = 2,             /*   Channel unbind */
    NETDEV_CHL_STATUS_INVALID
}NETDEV_CHANNEL_STATUS_E;

/**
 * @enum tagNETDEVChannelType
 * @brief   Channel type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelType
{
    NETDEV_CHL_TYPE_DIGITAL = 0,            /*   Digital Channel */
    NETDEV_CHL_TYPE_ANALOG  = 1,            /*   analog Channel */
    NETDEV_CHL_TYPE_INVALID
}NETDEV_CHANNEL_TYPE_E;

/**
 * @enum tagNETDEVChannelCameraType
 * @brief (2018-07-26 NVR)  Channel device type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelCameraType
{
    NETDEV_CHL_CAMERA_TYPE_FIXED        = 0,        /*   fixed camera */
    NETDEV_CHL_CAMERA_TYPE_PTZ          = 1,        /*   PTZ camera */
    NETDEV_CHL_CAMERA_TYPE_FISH_EYE     = 2,        /* +fish-eye camera */
    NETDEV_CHL_CAMERA_TYPE_WIDE_ANGLE   = 3,        /*   wide-Angle camera*/
    NETDEV_CHL_CAMERA_TYPE_INVALID      = 0xff
}NETDEV_CHANNEL_CAMERA_TYPE_E;

/**
 * @enum tagNETDEVVideoStandard
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVVideoStandard
{
    NETDEV_VIDEO_STANDARD_PAL       = 0,        /* PAL */
    NETDEV_VIDEO_STANDARD_NTSC      = 1,        /* NTSC */
    NETDEV_VIDEO_STANDARD_INVALID   = 0xFF      /*   Invalid value */
}NETDEV_VIDEO_STANDARD_E;

/**
 * @enum tagNETDEVCameraType
 * @brief   Camera type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCameraType
{
    NETDEV_CAMERA_TYPE_FIX         = 0,            /*   Fixed camera */
    NETDEV_CAMERA_TYPE_PTZ         = 1,            /*   PTZ camera */
    NETDEV_CAMERA_TYPE_INVALID     = 0xFF          /*   Invalid value */
}NETDEV_CAMERA_TYPE_E;

/**
 * @enum tagNETDEVLiveStreamIndex
 * @brief    Live stream index Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLiveStreamIndex
{
    NETDEV_LIVE_STREAM_INDEX_MAIN       = 0,    /*   Main stream */
    NETDEV_LIVE_STREAM_INDEX_AUX        = 1,    /*   Sub stream */
    NETDEV_LIVE_STREAM_INDEX_THIRD      = 2,    /*   Third stream */
    NETDEV_LIVE_STREAM_INDEX_ADAPTIVE   = 10,   /*   Adaptive stream */
    NETDEV_LIVE_STREAM_INDEX_INVALID    = 0xFF  /*   Invalid value */
}NETDEV_LIVE_STREAM_INDEX_E;

/**
 * @enum tagNETDEStreamDataCBType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEStreamDataCBType
{
    NETDEV_STREAM_CB_TYPE_PARSE                    = 1,        /* / */
    NETDEV_STREAM_CB_TYPE_DECODE                   = 2,        /* / */
    NETDEV_STREAM_CB_TYPE_DECODE_V30               = 3,        /* /,GPU */
    NETDEV_STREAM_CB_TYPE_INVALID                  = 0xff      
}NETDEV_STREAM_DATA_CB_TYPE_E;

/**
 * @enum tagHOSTType
 * @brief IP   Protocol type Enumeration definition
 * @attention  None
 */
typedef enum tagHOSTType
{
    NETDEV_NETWORK_HOSTTYPE_IPV4        = 0,        /* IPv4 */
    NETDEV_NETWORK_HOSTTYPE_IPV6        = 1,        /* IPv6 */
    NETDEV_NETWORK_HOSTTYPE_DNS         = 2,        
    NETDEV_NETWORK_HOSTTYPE_INVALID     = 0xFF      /*   Invalid value */
}NETDEV_HOSTTYPE_E;

/**
 * @enum tagNETDEVProtocal
 * @brief    Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVProtocal
{
    NETDEV_TRANSPROTOCAL_RTPUDP     = 0,    /* UDP */
    NETDEV_TRANSPROTOCAL_RTPTCP     = 1     /* TCP */
}NETDEV_PROTOCAL_E;

/**
 * @enum tagNETDEVStreamMode
 * @brief    start stream mode Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVStreamMode
{
    NETDEV_STREAM_MODE_ALL      = 0x0000,   /*  +  audio & Video */
    NETDEV_STREAM_MODE_VIDEO    = 0x8000    /*  only video */
}NETDEV_STREAM_MODE_E;

/**
 * @enum tagNETDEVMediaFileFormat
 * @brief    Media file format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVMediaFileFormat
{
    NETDEV_MEDIA_FILE_MP4                   = 0,    /* MP4(+)  mp4 media file (Audio + Video) */
    NETDEV_MEDIA_FILE_TS                    = 1,    /* TS(+)   TS media file (Audio + Video) */
    NETDEV_MEDIA_FILE_MP4_ADD_TIME          = 2,    /* MP4(+) ,  MP4 media file with time in file name (Audio + Video) */
    NETDEV_MEDIA_FILE_TS_ADD_TIME           = 3,    /* TS(+) ,  TS media file with time in file name (Audio + Video) */
    NETDEV_MEDIA_FILE_AUDIO_TS              = 4,    /* TS()   TS audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_MP4             = 5,    /* MP4()   MP4 audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_TS_ADD_TIME     = 6,    /* TS(),  TS audio file with time in file name (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_TIME    = 7,    /* MP4(),  MP4 audio file with time in file name (Only audio) */
    NETDEV_MEDIA_FILE_MP4_ADD_RCD_TIME      = 8,    /* MP4(+)  MP4 media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_TS_ADD_RCD_TIME       = 9,    /* TS(+)  TS media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_RCD_TIME= 10,   /* MP4()  MP4 audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_AUDIO_TS_ADD_RCD_TIME = 11,   /* TS()  TS audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_VIDEO_MP4_ADD_RCD_TIME= 12,   /* MP4()  mp4 media file (Only video) */
    NETDEV_MEDIA_FILE_VIDEO_TS_ADD_RCD_TIME = 13,   /* TS()  ts media file (Only video) */
    NETDEV_MEDIA_FILE_AVI                   = 14,   /* AVI(+)   AVI media file (Audio + Video) */
    NETDEV_MEDIA_FILE_AVI_ADD_TIME          = 15,   /* AVI(+)  AVI media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_AVI             = 16,   /* AVI()   AVI audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_TIME    = 17,   /* AVI(),  AVI audio file with time in file name (Only audio)*/
    NETDEV_MEDIA_FILE_AVI_ADD_RCD_TIME      = 18,   /* AVI(+)  AVI audio file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_RCD_TIME= 19,   /* AVI()  AVI audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_VIDEO_AVI_ADD_RCD_TIME= 20,   /* AVI()  AVI media file (Only video) */
    NETDEV_MEDIA_FILE_INVALID
}NETDEV_MEDIA_FILE_FORMAT_E;

/**
 * @enum tagNETDEVPlayerVideoCodeType
 * @brief    Player Video encoding format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPlayerVideoCodeType
{
    NETDEV_PLAYER_VIDEO_CODE_MPEG2     = 0,          /* MPEG-2 */
    NETDEV_PLAYER_VIDEO_CODE_MPEG4     = 1,          /* MPEG-4 */
    NETDEV_PLAYER_VIDEO_CODE_H264      = 2,          /* H.264 */
    NETDEV_PLAYER_VIDEO_CODE_MJPEG     = 3,          /* MJPEG */
    NETDEV_PLAYER_VIDEO_CODE_H265      = 4,          /* H.265 */
    NETDEV_PLAYER_VIDEO_CODE_INVALID
}NETDEV_PLAYER_VIDEO_CODE_TYPE_E;

/**
 * @enum tagNETDEVVideoCodeType
 * @brief    Video encoding format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoCodeType
{
    NETDEV_VIDEO_CODE_MJPEG     = 0,          /* MJPEG */
    NETDEV_VIDEO_CODE_H264      = 1,          /* H.264 */
    NETDEV_VIDEO_CODE_H265      = 2,          /* H.265 */
    NETDEV_VIDEO_CODE_INVALID
}NETDEV_VIDEO_CODE_TYPE_E;

/**
 * @enum tagNETDEVVideoFrameType
 * @brief    Video frame type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoFrameType
{
    NETDEV_VIDEO_FRAME_I    = 0,               /* I-frame */
    NETDEV_VIDEO_FRAME_P    = 1,               /* P-frame */
    NETDEV_VIDEO_FRAME_B    = 2                /* B-frame */
}NETDEV_VIDEO_FRAME_TYPE_E;

/**
 * @enum tagNetDEVAudioEncodeType
 * @brief  Audio encode type
 * @attention  None
*/
typedef enum tagNetDEVAudioEncodeType
{
    NETDEV_AUDIO_ENCODE_G711U   = 0,          /* G.711U Audio up to G.711U-law standard*/
    NETDEV_AUDIO_ENCODE_MP2     = 1,          /* MP2 Audio up to MP2 standard */
    NETDEV_AUDIO_ENCODE_AAC     = 2,          /* AAC Audio up to AAC standard*/
    NETDEV_AUDIO_ENCODE_G711A   = 3,          /* G.711A Audio up to G.711A-law standard*/
    NETDEV_AUDIO_ENCODE_PCM     = 4,          /* PCM Audio up to PCM law standard*/
    NETDEV_AUDIO_ENCODE_NULL    = 5           /*  No audio */
}NETDEV_AUDIO_ENCODE_TYPE_E;

/**
 * @enum tagNetDEVWaveFormatInfo
* @brief  Wave format info
* @attention   None
*/
typedef enum tagNetDEVWaveFormatInfo
{
    NETDEV_WAVE_FORMAT_PCM8M16        = 0,        /* PCM,8K,,16 PCM,8k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM16M16       = 1,        /* PCM,16K,,16 PCM,16k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM441M16      = 2,        /* PCM,44.1K,,16 PCM,44.1k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM11025M16    = 3,        /* PCM,11.025K,,16 PCM,11.025k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM8_RIGHT     = 4,        /* PCM8K PCM,8k sampling rate,right channel*/
    NETDEV_WAVE_FORMAT_PCM_NORMAL     = 5,        /* PCM PCM,general mode*/
    NETDEV_WAVE_FORMAT_PCM48000M16    = 6,        /* PCM48.0KM16 PCM,48.0k sampling rate,single track,16 bit sampling*/
    NETDEV_WAVE_FORMAT_UNKNOWN
}NETDEV_WAVE_FORMAT_INFO_E;

/**
 * @enum tagNETDEVRenderScale
 * @brief    Video display ratio Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVRenderScale
{
    NETDEV_RENDER_SCALE_FULL        = 0,                  /*   Stretch */
    NETDEV_RENDER_SCALE_PROPORTION  = 1,                  /*   Scale */
    NETDEV_RENDER_SCALE_INVALID     = 0xFF
}NETDEV_RENDER_SCALE_E;

/**
 * @enum tagNETDEVPictureFormat
 * @brief   Picture type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureFormat
{
    NETDEV_PICTURE_BMP = 0,                  /* bmp  Picture format is bmp */
    NETDEV_PICTURE_JPG = 1,                  /* jpg  Picture format is jpg */
    NETDEV_PICTURE_INVALID
}NETDEV_PICTURE_FORMAT_E;

/**
 * @enum tagNETDEVVideoQuality
 * @brief    Video image quality Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoQuality
{
    NETDEV_VQ_L0            = 0,                    /*   Highest */
    NETDEV_VQ_L1            = 1,
    NETDEV_VQ_L2            = 4,                    /*   Higher */
    NETDEV_VQ_L3            = 8,
    NETDEV_VQ_L4            = 12,                   /*   Medium */
    NETDEV_VQ_L5            = 16,
    NETDEV_VQ_L6            = 20,                   /*   Low */
    NETDEV_VQ_L7            = 24,
    NETDEV_VQ_L8            = 28,                   /*   Lower */
    NETDEV_VQ_L9            = 31,                   /*   Lowest */
    NETDEV_VQ_LEVEL_INVALID = -1                    /*   Valid */
}NETDEV_VIDEO_QUALITY_E;

/**
 * @enum tagNETDEVPictureSize
 * @brief   Image resolution Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureSize
{
    NETDEV_PICTURE_SIZE_D1     = 0,           /* D1 */
    NETDEV_PICTURE_SIZE_4CIF   = 1,           /* 4CIF */
    NETDEV_PICTURE_SIZE_2CIF   = 2,           /* 2CIF */
    NETDEV_PICTURE_SIZE_CIF    = 3,           /* CIF */
    NETDEV_PICTURE_SIZE_960H   = 4,           /* 960H */
    NETDEV_PICTURE_SIZE_QCIF   = 5,           /* QCIF */
    NETDEV_PICTURE_SIZE_HALFD1 = 6,           /* HALFD1 */
    NETDEV_PICTURE_SIZE_720    = 7,           /* 720 */
    NETDEV_PICTURE_SIZE_1080   = 8,           /* 1080 */
    NETDEV_PICTURE_SIZE_XGA    = 9,           /* 1024*768 */
    NETDEV_PICTURE_SIZE_SXGA   = 10,          /* 1280*1024 */
    NETDEV_PICTURE_SIZE_INVALID               /*   Invalid value */
}NETDEV_PICTURE_SIZE_E;

/**
 * @enum tagNETDEVPtzCmdEnum
 * @brief   PTZ commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPtzCmdEnum
{
    NETDEV_PTZ_IRISCLOSE_STOP       =0x0101,        /*   Iris close stop */
    NETDEV_PTZ_IRISCLOSE            =0x0102,        /*   Iris close */
    NETDEV_PTZ_IRISOPEN_STOP        =0x0103,        /*   Iris open stop */
    NETDEV_PTZ_IRISOPEN             =0x0104,        /*   Iris open */

    NETDEV_PTZ_FOCUSNEAR_STOP       =0x0201,        /*   Focus near stop */
    NETDEV_PTZ_FOCUSNEAR            =0x0202,        /*   Focus near */
    NETDEV_PTZ_FOCUSFAR_STOP        =0x0203,        /*   Focus far stop */
    NETDEV_PTZ_FOCUSFAR             =0x0204,        /*   Focus far */

    NETDEV_PTZ_ZOOMTELE_STOP        = 0x0301,       /*   Zoom in stop */
    NETDEV_PTZ_ZOOMTELE             = 0x0302,       /*   Zoom in */
    NETDEV_PTZ_ZOOMWIDE_STOP        = 0x0303,       /*   Zoom out stop */
    NETDEV_PTZ_ZOOMWIDE             = 0x0304,       /*   Zoom out */
    NETDEV_PTZ_TILTUP               = 0x0402,       /*   Tilt up */
    NETDEV_PTZ_TILTDOWN             = 0x0404,       /*   Tilt down */
    NETDEV_PTZ_PANRIGHT             = 0x0502,       /*   Pan right */
    NETDEV_PTZ_PANLEFT              = 0x0504,       /*   Pan left */
    NETDEV_PTZ_LEFTUP               = 0x0702,       /*   Move up left */
    NETDEV_PTZ_LEFTDOWN             = 0x0704,       /*   Move down left */
    NETDEV_PTZ_RIGHTUP              = 0x0802,       /*   Move up right */
    NETDEV_PTZ_RIGHTDOWN            = 0x0804,       /*   Move down right */

#if 0
    NETDEV_PTZ_PRESAVE              = 0x0601,       /*   Save preset */
    NETDEV_PTZ_PRECALL              = 0x0602,       /*   Call preset */
    NETDEV_PTZ_PREDEL               = 0x0603,       /*   Delete preset */
#endif

    NETDEV_PTZ_ALLSTOP              = 0x0901,       /*   All-stop command word */
    NETDEV_PTZ_FOCUS_AND_IRIS_STOP  = 0x0907,       /* .  Focus & Iris-stop command word */
    NETDEV_PTZ_MOVE_STOP            = 0x0908,       /*   move stop command word */
    NETDEV_PTZ_ZOOM_STOP            = 0x0909,       /*   zoom stop command word */

    NETDEV_PTZ_TRACKCRUISE          = 0x1001,       /*   Start route patrol*/
    NETDEV_PTZ_TRACKCRUISESTOP      = 0x1002,       /*   Stop route patrol*/
    NETDEV_PTZ_TRACKCRUISEREC       = 0x1003,       /*   Start recording route */
    NETDEV_PTZ_TRACKCRUISERECSTOP   = 0x1004,       /*   Stop recording route */
    NETDEV_PTZ_TRACKCRUISEADD       = 0x1005,       /*   Add patrol route */
    NETDEV_PTZ_TRACKCRUISEDEL       = 0x1006,       /*   Delete patrol route */

    NETDEV_PTZ_AREAZOOMIN           = 0x1101,       /*   Zoom in area */
    NETDEV_PTZ_AREAZOOMOUT          = 0x1102,       /*   Zoom out area */
    NETDEV_PTZ_AREAZOOM3D           = 0x1103,       /* 3D  3D positioning */

    NETDEV_PTZ_BRUSHON              = 0x0A01,       /*   Wiper on */
    NETDEV_PTZ_BRUSHOFF             = 0x0A02,       /*   Wiper off */

    NETDEV_PTZ_LIGHTON              = 0x0B01,       /*   Lamp on */
    NETDEV_PTZ_LIGHTOFF             = 0x0B02,       /*   Lamp off */

    NETDEV_PTZ_HEATON               = 0x0C01,       /*   Heater on */
    NETDEV_PTZ_HEATOFF              = 0x0C02,       /*   Heater off */

    NETDEV_PTZ_SNOWREMOINGON        = 0x01301,       /*   Snowremoval on */
    NETDEV_PTZ_SNOWREMOINGOFF       = 0x01302,       /*   Snowremoval off  */

    NETDEV_PTZ_INFRAREDON           = 0x0D01,       /*   IR on */
    NETDEV_PTZ_INFRAREDOFF          = 0x0D02,       /*   IR off */

    NETDEV_PTZ_SELF_CHECKING        = 0x1801,       /* :dwSpeed1,;0,, */

#if 0
    NETDEV_PTZ_ABSPOSITION          = 0x0902,       /*   Set absolute position of camera */
    NETDEV_PTZ_GUARD                = 0x0903,       /* ,  Return to home position (this command is not implemented on the PTZ template) */
    NETDEV_PTZ_SPEEDSET             = 0x0904,       /*   Set speed */

    NETDEV_PTZ_PRESETCRUISE         = 0x1001,       /*  ,  Preset-based PTZ patrol (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_PRESETCRUISESTOP     = 0x1002,       /* ,  Preset-based PTZ patrol stop (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_CRUISEDEL            = 0X1003,       /*   Delete route */
    NETDEV_PTZ_CRUISEADDPRESET      = 0x1004,       /*   Add preset to route */
    NETDEV_PTZ_CRUISEADDSTART       = 0x1005,       /*   Start adding preset to route */
    NETDEV_PTZ_CRUISEADDSTOP        = 0x1006,       /*   Stop adding preset to route */
#endif

    NETDEV_PTZ_INVALID

} NETDEV_PTZ_E;

/**
 * @enum tagNETDEVPtzPresetCmd
 * @brief   PTZ preset operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPtzPresetCmd
{
    NETDEV_PTZ_SET_PRESET   = 0,            /*   Set preset */
    NETDEV_PTZ_CLE_PRESET   = 1,            /*   Clear preset */
    NETDEV_PTZ_GOTO_PRESET  = 2             /*   Go to preset */
}NETDEV_PTZ_PRESETCMD_E;

/**
 * @enum tagNETDEVPTZCruiseCmd
 * @brief   PTZ patrol operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPTZCruiseCmd
{
    NETDEV_PTZ_ADD_CRUISE      = 0,         /*    Add patrol route */
    NETDEV_PTZ_MODIFY_CRUISE   = 1,         /*   Edit patrol route */
    NETDEV_PTZ_DEL_CRUISE      = 2,         /*   Delete patrol route */
    NETDEV_PTZ_RUN_CRUISE      = 3,         /*   Start patrol */
    NETDEV_PTZ_STOP_CRUISE     = 4,         /*   Stop patrol */
    NETDEV_PTZ_GET_CRUISE      = 5              /* Get patrol route */
}NETDEV_PTZ_CRUISECMD_E;

/**
 * @enum tagNETDEVPlayControl
 * @brief   Playback control commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPlayControl
{
    NETDEV_PLAY_CTRL_PLAY                       = 0,        /*   Play */
    NETDEV_PLAY_CTRL_PAUSE                      = 1,        /*   Pause */
    NETDEV_PLAY_CTRL_RESUME                     = 2,        /*   Resume */
    NETDEV_PLAY_CTRL_GETPLAYTIME                = 3,        /*   Obtain playing time */
    NETDEV_PLAY_CTRL_SETPLAYTIME                = 4,        /*   Configure playing time */
    NETDEV_PLAY_CTRL_GETPLAYSPEED               = 5,        /*   Obtain playing speed */
    NETDEV_PLAY_CTRL_SETPLAYSPEED               = 6,        /*   Configure playing speed */
    NETDEV_PLAY_CTRL_SET_SINGLE_FRAME_SPEED     = 7,        /*   Configure single frame playing speed */
    NETDEV_PLAY_CTRL_UPDATE_M3U8URL             = 8         /* M3u8URL  urlUpdate M3u8 url */
}NETDEV_VOD_PLAY_CTRL_E;

/**
 * @enum tagNETDEVVodPlayStatus
 * @brief .  Playback and download status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVodPlayStatus
{
    /**   Play status */
    NETDEV_PLAY_STATUS_16_BACKWARD          = 0,            /* 16  Backward at 16x speed */
    NETDEV_PLAY_STATUS_8_BACKWARD           = 1,            /* 8  Backward at 8x speed */
    NETDEV_PLAY_STATUS_4_BACKWARD           = 2,            /* 4  Backward at 4x speed */
    NETDEV_PLAY_STATUS_2_BACKWARD           = 3,            /* 2  Backward at 2x speed */
    NETDEV_PLAY_STATUS_1_BACKWARD           = 4,            /*   Backward at normal speed */
    NETDEV_PLAY_STATUS_HALF_BACKWARD        = 5,            /* 1/2  Backward at 1/2 speed */
    NETDEV_PLAY_STATUS_QUARTER_BACKWARD     = 6,            /* 1/4  Backward at 1/4 speed */
    NETDEV_PLAY_STATUS_QUARTER_FORWARD      = 7,            /* 1/4  Play at 1/4 speed */
    NETDEV_PLAY_STATUS_HALF_FORWARD         = 8,            /* 1/2  Play at 1/2 speed */
    NETDEV_PLAY_STATUS_1_FORWARD            = 9,            /*   Forward at normal speed */
    NETDEV_PLAY_STATUS_2_FORWARD            = 10,           /* 2  Forward at 2x speed */
    NETDEV_PLAY_STATUS_4_FORWARD            = 11,           /* 4  Forward at 4x speed */
    NETDEV_PLAY_STATUS_8_FORWARD            = 12,           /* 8  Forward at 8x speed */
    NETDEV_PLAY_STATUS_16_FORWARD           = 13,           /* 16  Forward at 16x speed */
    NETDEV_PLAY_STATUS_2_FORWARD_IFRAME     = 14,           /* 2(I) Forward at 2x speed(I frame) */
    NETDEV_PLAY_STATUS_4_FORWARD_IFRAME     = 15,           /* 4(I) Forward at 4x speed(I frame) */
    NETDEV_PLAY_STATUS_8_FORWARD_IFRAME     = 16,           /* 8(I) Forward at 8x speed(I frame) */
    NETDEV_PLAY_STATUS_16_FORWARD_IFRAME    = 17,           /* 16(I) Forward at 16x speed(I frame) */
    NETDEV_PLAY_STATUS_2_BACKWARD_IFRAME    = 18,           /* 2(I) Backward at 2x speed(I frame) */
    NETDEV_PLAY_STATUS_4_BACKWARD_IFRAME    = 19,           /* 4(I) Backward at 4x speed(I frame) */
    NETDEV_PLAY_STATUS_8_BACKWARD_IFRAME    = 20,           /* 8(I) Backward at 8x speed(I frame) */
    NETDEV_PLAY_STATUS_16_BACKWARD_IFRAME   = 21,           /* 16(I) Backward at 16x speed(I frame) */
    NETDEV_PLAY_STATUS_INTELLIGENT_FORWARD  = 22,           /*  Intelligent forward */
    NETDEV_PLAY_STATUS_1_FRAME_FORWD        = 23,           /*   Forward at 1 frame speed */
    NETDEV_PLAY_STATUS_1_FRAME_BACK         = 24,           /*  Backward at 1 frame speed */
    NETDEV_PLAY_STATUS_40_FORWARD           = 25,           /* 40 Forward at 40x speed*/
    NETDEV_PLAY_STATUS_32_FORWARD_IFRAME    = 26,           /* 32 Forward at 32x speed(I frame)*/
    NETDEV_PLAY_STATUS_32_BACKWARD_IFRAME   = 27,           /* 32 Backward at 32x speed(I frame)*/
    NETDEV_PLAY_STATUS_64_FORWARD_IFRAME    = 28,           /* 64 Forward at 64x speed(I frame)*/
    NETDEV_PLAY_STATUS_64_BACKWARD_IFRAME   = 29,           /* 64 Backward at 64x speed(I frame)*/
    NETDEV_PLAY_STATUS_128_FORWARD_IFRAME   = 30,           /* 128 Forward at 128x speed(I frame)*/
    NETDEV_PLAY_STATUS_128_BACKWARD_IFRAME  = 31,           /* 128 Backward at 128x speed(I frame)*/
    NETDEV_PLAY_STATUS_256_FORWARD_IFRAME   = 32,           /* 256 Forward at 256x speed(I frame)*/
    NETDEV_PLAY_STATUS_256_BACKWARD_IFRAME  = 33,           /* 256 Backward at 256x speed(I frame)*/
    NETDEV_PLAY_STATUS_32_FORWARD           = 34,           /* 32 */
    NETDEV_PLAY_STATUS_32_BACKWARD          = 35,           /* 32 */
    NETDEV_PLAY_STATUS_INVALID
}NETDEV_VOD_PLAY_STATUS_E;

/**
 * @enum tagNETDEVDownloadSpeed
 * @brief   Recording download speed
 * @attention  None
 */
typedef enum tagNETDEVDownloadSpeed
{
    NETDEV_DOWNLOAD_SPEED_ONE           = 0,            
    NETDEV_DOWNLOAD_SPEED_TWO           = 1,            
    NETDEV_DOWNLOAD_SPEED_FOUR          = 2,            
    NETDEV_DOWNLOAD_SPEED_EIGHT         = 3,            
    NETDEV_DOWNLOAD_SPEED_TWO_IFRAME    = 4,            /* I */
    NETDEV_DOWNLOAD_SPEED_FOUR_IFRAME   = 5,            /* I */
    NETDEV_DOWNLOAD_SPEED_EIGHT_IFRAME  = 6,            /* I */
    NETDEV_DOWNLOAD_SPEED_HALF          = 7,            /* 1/2  1/2x */
    NETDEV_DOWNLOAD_SPEED_FORTY         = 8,            /* 40 40x */
    NETDEV_DOWNLOAD_SEPPD_SIXTEEN       = 9,            
    NETDEV_DOWNLOAD_SPEED_INVALID       = 0xFF          
}NETDEV_E_DOWNLOAD_SPEED_E;

/**
 * @enum tagNETDEVStoreType
 * @brief   Recording storage type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVStoreType
{
    NETDEV_TYPE_STORE_TYPE_ALL                  = 0,            /*   All */
    NETDEV_EVENT_STORE_TYPE_NORMAL              = 1,            /* ,  All */
    NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION     = 4,            /*   Motion detection */
    NETDEV_EVENT_STORE_TYPE_DIGITALINPUT        = 5,            /*   Digital input */
    NETDEV_EVENT_STORE_TYPE_VIDEOLOSS           = 7,            /*   Video loss */
    NETDEV_TYPE_STORE_TYPE_INVALID              = 0xFF          /*   Invalid value */
}NETDEV_PLAN_STORE_TYPE_E;

/**
 * @enum tagNetDevAudioSampleFormatType
 * @brief 
 * @attention 
*/
typedef enum tagNetDevAudioSampleFormatType
{
    NETDEV_AUDIO_SAMPLE_FMT_NONE    = -1,
    NETDEV_AUDIO_SAMPLE_FMT_U8      = 0,            /* 8 */
    NETDEV_AUDIO_SAMPLE_FMT_S16     = 1,            /* 16 */
    NETDEV_AUDIO_SAMPLE_FMT_S32     = 2,            /* 32 */
    NETDEV_AUDIO_SAMPLE_FMT_FLT     = 3,            
    NETDEV_AUDIO_SAMPLE_FMT_DBL     = 4             /* double */
}NETDEV_AUDIO_SAMPLE_FORMAT_E;

/**
 * @enum tagNETDEVException
 * @brief   Exception callback message types Enumeration definition 
 * @attention  None
 */
typedef enum tagNETDEVException
{
    NETDEV_EXCEPTION_REPORT_REMUXING_FINISH     = 284,          

    /*   Playback exceptions report 300~399 */
    NETDEV_EXCEPTION_REPORT_VOD_END             = 300,          /*   Playback ended*/
    NETDEV_EXCEPTION_REPORT_VOD_ABEND           = 301,          /*   Playback exception occured */
    NETDEV_EXCEPTION_REPORT_BACKUP_END          = 302,          /*   Backup ended */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_OUT     = 303,          /*   Disk removed */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_FULL    = 304,          /*   Disk full */
    NETDEV_EXCEPTION_REPORT_BACKUP_ABEND        = 305,          /*    Backup failure caused by other reasons */

    NETDEV_EXCEPTION_EXCHANGE                   = 0x8000,       /*   Exception occurred during user interaction (keep-alive timeout) */
    NETDEV_EXCEPTION_REPORT_ALARM_INTERRUPT     = 0x8001,       /*   Failure to report abnormal termination of life preservation or disconnection of long connection */

    NETDEV_EXCEPTION_REPORT_MAX,                                /*   Maximum value */
    NETDEV_EXCEPTION_REPORT_NOT_VALID_PERIOD,                   /*  Not Valid period */
    NETDEV_EXCEPTION_REPORT_NOT_VALID_TIME,                     /*  Not Valid Time */

    NETDEV_EXCEPTION_REPORT_INVALID             = 0xFFFF        /*   Invalid value */
}NETDEV_EXCEPTION_TYPE_E;

/**
 * @enum tagNETDEVAlarmTypeEn
 * @brief    Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeEn
{
    NETDEV_ALARM_MOVE_DETECT                = 1,        /*   Motion detection alarm */
    NETDEV_ALARM_MOVE_DETECT_RECOVER        = 2,        /*   Motion detection alarm recover */
    NETDEV_ALARM_VIDEO_LOST                 = 3,        /*   Video loss alarm */
    NETDEV_ALARM_VIDEO_LOST_RECOVER         = 4,        /*   Video loss alarm recover */
    NETDEV_ALARM_VIDEO_TAMPER_DETECT        = 5,        /*   Tampering detection alarm */
    NETDEV_ALARM_VIDEO_TAMPER_RECOVER       = 6,        /*   Tampering detection alarm recover */
    NETDEV_ALARM_INPUT_SWITCH               = 7,        /*   boolean input alarm */
    NETDEV_ALARM_INPUT_SWITCH_RECOVER       = 8,        /*   Boolean input alarm recover */
    NETDEV_ALARM_TEMPERATURE_HIGH           = 9,        /*   High temperature alarm */
    NETDEV_ALARM_TEMPERATURE_LOW            = 10,       /*   Low temperature alarm */
    NETDEV_ALARM_TEMPERATURE_RECOVER        = 11,       /*   Temperature alarm recover */
    NETDEV_ALARM_AUDIO_DETECT               = 12,       /*   Audio detection alarm */
    NETDEV_ALARM_AUDIO_DETECT_RECOVER       = 13,       /*   Audio detection alarm recover */
    NETDEV_ALARM_SERVER_FAULT               = 18,       
    NETDEV_ALARM_SERVER_NORMAL              = 19,       
    

    NETDEV_ALARM_REPORT_DEV_ONLINE          = 201,       
    NETDEV_ALARM_REPORT_DEV_OFFLINE         = 202,       
    NETDEV_ALARM_REPORT_DEV_REBOOT          = 203,       /*   Device restart */
    NETDEV_ALARM_REPORT_DEV_SERVICE_REBOOT  = 204,       /*   Service restart */
    NETDEV_ALARM_REPORT_DEV_CHL_ONLINE      = 205,       /* :  */
    NETDEV_ALARM_REPORT_DEV_CHL_OFFLINE     = 206,       /* :  */
    NETDEV_ALARM_REPORT_DEV_DELETE_CHL      = 207,       /* :  */

    NETDEV_ALARM_DEVICE_HIGHTEMP            = 246,       /*  */
    NETDEV_ALARM_DEVICE_LOWTEMP             = 247,       /*  */
    NETDEV_ALARM_FAN_FAULT                  = 248,       /*  */
    NETDEV_ALARM_LEDBOX_HIGHTEMP            = 249,       /*  */
    NETDEV_ALARM_LEDBOX_SMOKE               = 250,       /*  */
    NETDEV_ALARM_DEVICE_HIGHTEMP_RECOVER    = 251,       /* : */
    NETDEV_ALARM_DEVICE_LOWTEMP_RECOVER     = 252,       /* : */
    NETDEV_ALARM_FAN_FAULT_RECOVER          = 253,       /* : */
    NETDEV_ALARM_LEDBOX_HIGHTEMP_RECOVER    = 254,       /* : */
    NETDEV_ALARM_LEDBOX_SMOKE_RECOVER       = 255,       /* : */
    /* VMS  */
    NETDEV_ALARM_THERM_HIGH_TEMPERATURE     = 256,       /*  High Temperature Alarm */
    NETDEV_ALARM_THERM_LOW_TEMPERATURE      = 257,       /*  Low Temperature Alarm */
    NETDEV_ALARM_THERM_ABNORMAL_TEMPERATURE = 258,       /*  Abnormal Temperature Alarm */

    /* ND  */
    NETDEV_ALARM_NET_FAILED                 = 401,      /*  Network error */
    NETDEV_ALARM_NET_TIMEOUT                = 402,      /*  Network timeout */
    NETDEV_ALARM_SHAKE_FAILED               = 403,      /*  Interaction error */
    NETDEV_ALARM_STREAMNUM_FULL             = 404,      /*  Stream full */
    NETDEV_ALARM_STREAM_THIRDSTOP           = 405,      /*  Third party stream stopped */
    NETDEV_ALARM_FILE_END                   = 406,      /*  File ended */
    NETDEV_ALARM_RTMP_CONNECT_FAIL          = 407,      /* RTMP */
    NETDEV_ALARM_RTMP_INIT_FAIL             = 408,      /* RTMP*/
    NETDEV_ALARM_STREAM_DOWNLOAD_OVER       = 409,      
    NETDEV_ALARM_PLAYBACK_FINISH            = 410,      
    NETDEV_ALARM_VIDEO_RECORD_PART          = 411,      
    NETDEV_ALARM_FISHEYE_STREAM_EXIST       = 412,      /* , */
    NETDEV_ALARM_FISHEYE_STREAM_NOT_EXIST   = 413,      /* , */
    NETDEV_ALARM_PTZ_RESOUCE_FAIL           = 414,      /* ptz */
    NETDEV_ALARM_PTZ_STREAM_EXIST           = 415,      /* ptz */
    NETDEV_ALARM_STREAM_NOT_EXIST           = 416,      /* ptz */
    NETDEV_ALARM_INNER_TIMEOUT              = 417,      
    NETDEV_ALARM_STREAM_NOT_READY           = 418,      
    NETDEV_ALARM_KEEP_ALIVE_FAILED          = 419,      
    NETDEV_ALARM_OVER_ABILITY               = 420,      
    NETDEV_ALARM_UNAUTHORIZED               = 421,      
    NETDEV_ALARM_FORIBIDDEN                 = 422,      
    NETDEV_ALARM_METHOD_NOT_ALLOWED         = 423,      
    NETDEV_ALARM_PRECONDITION_FAILED        = 424,      
    NETDEV_ALARM_SESSION_NOT_FOUND          = 425,      
    NETDEV_ALARM_NOT_ENOUGH_BANDWIDTH2      = 426,      /* (RTSP) */
    NETDEV_ALARM_REALPLAY_ESTABLISHED       = 427,      
    NETDEV_ALARM_REALPLAY_RES_BUSY          = 428,      
    NETDEV_ALARM_MULTICAST_DISABLED         = 429,      
    NETDEV_ALARM_MULTICAST_PORT_OCCUPIED    = 430,      
    NETDEV_ALARM_MULTICAST_PORT_EXHAUSTED   = 431,      
    NETDEV_ALARM_MULTICAST_USER_NOT_EXIST   = 432,      
    NETDEV_ALARM_CHANNEL_NOT_ONLINE         = 433,      
    NETDEV_ALARM_TALKBACK_ENCODED_INVALID   = 434,      
    NETDEV_ALARM_VOICE_RES_USED_BY_TALKBACK = 435,      
    NETDEV_ALARM_TALKBACK_EXISTS            = 436,      
    NETDEV_ALARM_VOICE_WORK_NOT_EXIST       = 437,      
    NETDEV_ALARM_TALKBACK_TIMEOUT           = 438,      
    NETDEV_ALARM_TALKBACK_ERROR             = 439,      
    NETDEV_ALARM_INNER_ERROR                = 440,      
    NETDEV_ALARM_BAD_REQUEST                = 441,      
    NETDEV_ALARM_PAYMENT_REQUIRED           = 442,      
    NETDEV_ALARM_NOT_FOUND                  = 443,      
    NETDEV_ALARM_NOT_ACCEPTABLE             = 444,      
    NETDEV_ALARM_PROXY_REQUIRED             = 445,      
    NETDEV_ALARM_REQUEST_TIMEOUT            = 446,      
    NETDEV_ALARM_GONE                       = 447,      
    NETDEV_ALARM_LENGTH_REQUIRED            = 448,      
    NETDEV_ALARM_ENTITY_TOO_LARGE           = 449,      
    NETDEV_ALARM_URI_TOO_LARGE              = 450,      /* -URI */
    NETDEV_ALARM_UNSUPPORTED_TYPE           = 451,      
    NETDEV_ALARM_NOT_UNDERSTOOD             = 452,      
    NETDEV_ALARM_CONFERENCE_NOT_FOUND       = 453,      
    NETDEV_ALARM_NOT_ENOUGH_BANDWIDTH       = 454,      /* (RTSP) */
    NETDEV_ALARM_METHOD_NOT_VALID           = 455,      
    NETDEV_ALARM_HEADER_NOT_VALID           = 456,      
    NETDEV_ALARM_INVALID_RANGE              = 457,      
    NETDEV_ALARM_PARAMETER_READ_ONLY        = 458,      
    NETDEV_ALARM_AO_NOT_ALLOWED             = 459,      
    NETDEV_ALARM_ONLY_AO_ALLOWED            = 460,      
    NETDEV_ALARM_UNSUPPORTED_TRANSPORT      = 461,      
    NETDEV_ALARM_DESTINATION_UNREACHABLE    = 462,      
    NETDEV_ALARM_INTERNAL_SERVER_ERROR      = 463,      
    NETDEV_ALARM_NOT_IMPLEMENTED            = 464,      
    NETDEV_ALARM_BAD_GATEWAY                = 465,      
    NETDEV_ALARM_SERVICE_UNAVAILABLE        = 466,      
    NETDEV_ALARM_GATEWAY_TIMEOUT            = 467,      
    NETDEV_ALARM_VERSION_NOT_SUPPORTED      = 468,      /* RTSP */
    NETDEV_ALARM_OPTION_NOT_SUPPORTED       = 469,      
    NETDEV_ALARM_SESSION_NOT_EXIST          = 470,      
    NETDEV_ALARM_UNDEFINED_ERROR            = 471,      


    NETDEV_ALARM_DISK_ERROR                         = 601,      /*   Disk error */
    NETDEV_ALARM_SYS_DISK_ERROR                     = 602,      /*   Disk error */
    NETDEV_ALARM_DISK_ONLINE                        = 603,      /*  Disk online */
    NETDEV_ALARM_SYS_DISK_ONLINE                    = 604,      /*  Disk online */
    NETDEV_ALARM_DISK_OFFLINE                       = 605,      
    NETDEV_ALARM_SYS_DISK_OFFLINE                   = 606,      
    NETDEV_ALARM_DISK_ABNORMAL                      = 607,      /*  Disk abnormal */
    NETDEV_ALARM_DISK_ABNORMAL_RECOVER              = 608,      /*  Disk abnormal recover */
    NETDEV_ALARM_DISK_STORAGE_WILL_FULL             = 609,      /*  Disk StorageGoingfull */
    NETDEV_ALARM_DISK_STORAGE_WILL_FULL_RECOVER     = 610,      /*  Disk StorageGoingfull recover */
    NETDEV_ALARM_DISK_STORAGE_IS_FULL               = 611,      /*  StorageIsfull */
    NETDEV_ALARM_SYS_DISK_STORAGE_IS_FULL           = 612,      /*  StorageIsfull */
    NETDEV_ALARM_DISK_STORAGE_IS_FULL_RECOVER       = 613,      /*  StorageIsfull recover */
    NETDEV_ALARM_DISK_RAID_DISABLED_RECOVER         = 614,      /*  RAIDDisabled recover */
    NETDEV_ALARM_DISK_RAID_DEGRADED                 = 615,      /*  RAIDDegraded */
    NETDEV_ALARM_SYS_DISK_RAID_DEGRADED             = 616,      /*  RAIDDegraded */
    NETDEV_ALARM_DISK_RAID_DISABLED                 = 617,      /*  RAIDDisabled */
    NETDEV_ALARM_SYS_DISK_RAID_DISABLED             = 618,      /*  RAIDDisabled */
    NETDEV_ALARM_DISK_RAID_DEGRADED_RECOVER         = 619,      /*  RAIDDegraded recover */
    NETDEV_ALARM_STOR_GO_FULL                       = 620,      
    NETDEV_ALARM_SYS_STOR_GO_FULL                   = 621,      
    NETDEV_ALARM_ARRAY_NORMAL                       = 622,      
    NETDEV_ALARM_SYS_ARRAY_NORMAL                   = 623,      
    NETDEV_ALARM_DISK_RAID_RECOVERED                = 624,      /*  RAIDDegraded */
    NETDEV_ALARM_STOR_ERR                           = 625,      /*   Storage error */
    NETDEV_ALARM_SYS_STOR_ERR                       = 626,      /*   Storage error */
    NETDEV_ALARM_STOR_ERR_RECOVER                   = 627,      /*   Storage error recover */
    NETDEV_ALARM_STOR_DISOBEY_PLAN                  = 628,      /*   Not stored as planned */
    NETDEV_ALARM_STOR_DISOBEY_PLAN_RECOVER          = 629,      /*   Not stored as planned recover */

    NETDEV_ALARM_BANDWITH_CHANGE                    = 801,      
    NETDEV_ALARM_VIDEOENCODER_CHANGE                = 802,      
    NETDEV_ALARM_IP_CONFLICT                        = 803,      /* IP IP conflict exception alarm*/
    NETDEV_ALARM_IP_CONFLICT_CLEARED                = 804,      /* IPIP conflict exception alarm recovery */
    NETDEV_ALARM_NET_OFF                            = 805,      
    NETDEV_ALARM_NET_RESUME_ON                      = 806,      

    NETDEV_ALRAM_CONFLAG_DETECT                     = 920,      /*  Conflagration detection alarm */
    NETDEV_ALARM_NO_MASK                            = 921,      /*  NoMaskmAlarm */
    NETDEV_ALARM_BODY_TEMPERATURE                   = 922,      /*  BodyTemperatureAlarm */
    NETDEV_ALARM_AREA_PEOPLE_COUNT                  = 923,      /*  Area people count alarm */
    NETDEV_ALARM_AREA_PEOPLE_COUNT_RECOVER          = 924,      /*  Area people count alarm recover */

    NETDEV_ALARM_ILLEGAL_ACCESS                     = 1001,          /*   Illegal access */
    NETDEV_ALARM_SYS_ILLEGAL_ACCESS                 = 1002,          /*   Illegal access */
    NETDEV_ALARM_LINE_CROSS                         = 1003,          /*   Line cross */
    NETDEV_ALARM_OBJECTS_INSIDE                     = 1004,          /*   Objects inside */
    NETDEV_ALARM_FACE_RECOGNIZE                     = 1005,          /*   Face recognize */
    NETDEV_ALARM_IMAGE_BLURRY                       = 1006,          /*   Image blurry */
    NETDEV_ALARM_SCENE_CHANGE                       = 1007,          /*   Scene change */
    NETDEV_ALARM_SMART_TRACK                        = 1008,          /*   Smart track */
    NETDEV_ALARM_LOITERING_DETECTOR                 = 1009,          /*   Loitering Detector */
    NETDEV_ALARM_BANDWIDTH_CHANGE                   = 1010,          /*   Bandwidth change */
    NETDEV_ALARM_ALLTIME_FLAG_END                   = 1011,          /*   End marker of alarm without arming schedule */
    NETDEV_ALARM_MEDIA_CONFIG_CHANGE                = 1012,          /*  media configurationchanged */
    NETDEV_ALARM_REMAIN_ARTICLE                     = 1013,          /*   Remain article*/
    NETDEV_ALARM_PEOPLE_GATHER                      = 1014,          /*  People gather alarm*/
    NETDEV_ALARM_ENTER_AREA                         = 1015,          /*  Enter area*/
    NETDEV_ALARM_LEAVE_AREA                         = 1016,          /*  Leave area*/
    NETDEV_ALARM_ARTICLE_MOVE                       = 1017,          /*  Article move*/
    NETDEV_ALARM_SMART_FACE_MATCH_LIST              = 1018,          
    NETDEV_ALARM_SMART_FACE_MATCH_LIST_RECOVER      = 1019,          
    NETDEV_ALARM_SMART_FACE_MISMATCH_LIST           = 1020,          
    NETDEV_ALARM_SMART_FACE_MISMATCH_LIST_RECOVER   = 1021,          
    NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST           = 1022,          
    NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST_RECOVER   = 1023,          
    NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST        = 1024,          
    NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST_RECOVER= 1025,          
    NETDEV_ALARM_IMAGE_BLURRY_RECOVER               = 1026,          /*   Image blurry recover */
    NETDEV_ALARM_SMART_TRACK_RECOVER                = 1027,          /*   Smart track recover */
    NETDEV_ALARM_SMART_READ_ERROR_RATE              = 1028,          /* Error reding the underlying data */
    NETDEV_ALARM_SMART_SPIN_UP_TIME                 = 1029,          /*   Rotation time of spindle */
    NETDEV_ALARM_SMART_START_STOP_COUNT             = 1030,          /*  Rev. Stop counting*/
    NETDEV_ALARM_SMART_REALLOCATED_SECTOR_COUNT     = 1031,          /*   Remap sector count*/
    NETDEV_ALARM_SMART_SEEK_ERROR_RATE              = 1032,          /*  Trace error rate*/
    NETDEV_ALARM_SMART_POWER_ON_HOURS               = 1033,          
    NETDEV_ALARM_SMART_SPIN_RETRY_COUNT             = 1034,          
    NETDEV_ALARM_SMART_CALIBRATION_RETRY_COUNT      = 1035,          
    NETDEV_ALARM_SMART_POWER_CYCLE_COUNT            = 1036,          
    NETDEV_ALARM_SMART_POWEROFF_RETRACT_COUNT       = 1037,          
    NETDEV_ALARM_SMART_LOAD_CYCLE_COUNT             = 1038,          
    NETDEV_ALARM_SMART_TEMPERATURE_CELSIUS          = 1039,          
    NETDEV_ALARM_SMART_REALLOCATED_EVENT_COUNT      = 1040,          
    NETDEV_ALARM_SMART_CURRENT_PENDING_SECTOR       = 1041,          
    NETDEV_ALARM_SMART_OFFLINE_UNCORRECTABLE        = 1042,          
    NETDEV_ALARM_SMART_UDMA_CRC_ERROR_COUNT         = 1043,          
    NETDEV_ALARM_SMART_MULTI_ZONE_ERROR_RATE        = 1044,          
    NETDEV_ALARM_RESOLUTION_CHANGE                  = 1045,          
    NETDEV_ALARM_MANUAL                             = 1401,          
    NETDEV_ALARM_ALARMHOST_COMMON                   = 1402,          
    NETDEV_ALARM_DOORHOST_COMMON                    = 1403,          
    NETDEV_ALARM_FACE_NOT_MATCH                     = 1411,          
    NETDEV_ALARM_FACE_MATCH_SUCCEED                 = 1412,          
    NETDEV_ALARM_VIDEO_CHL_REACH_UPPER_LIMIT        = 1413,          

    NETDEV_ALARM_VEHICLE_BLACK_LIST                 = 1420,         
    NETDEV_ALARM_HUMAN_SHAPE_DETECTION              = 1421,         
    NETDEV_ALARM_HUMAN_SHAPE_DETECTION_RECOVER      = 1422,         
    NETDEV_ALARM_NOT_WORN_SAFETYHELMET              = 1423,         
    NETDEV_ALARM_NOT_WORN_WORKCLOTHES               = 1424,         
    NETDEV_ALARM_FAST_MOVING                        = 1425,         
    NETDEV_ALARM_NOT_WORN_CHEFHAT                   = 1426,         
    NETDEV_ALARM_TELEPHONING                        = 1427,         
    NETDEV_ALARM_SMOKING                            = 1428,         
    NETDEV_ALARM_CROWD_DENSITY_MINOR                = 1429,         
    NETDEV_ALARM_CROWD_DENSITY_MINOR_CLEARED        = 1430,         
    NETDEV_ALARM_CROWD_DENSITY_MAJOR                = 1431,         
    NETDEV_ALARM_CROWD_DENSITY_MAJOR_CLEARED        = 1432,         
    NETDEV_ALARM_CROWD_DENSITY_CRITICAL             = 1433,         
    NETDEV_ALARM_CROWD_DENSITY_CRITICAL_CLEARED     = 1434,         
    NETDEV_ALARM_ACCESS_ELEVATOR                    = 1435,         
    NETDEV_ALARM_ACCESS_ELEVATOR_CLEARED            = 1436,         

    NETDEV_ALARM_INVALID                            = 0xFFFF        /*   Invalid value */
}NETDEV_ALARM_TYPE_E;

/**
* @enum tagNETDEVPlayerRunInfoType
* @brief 
* @attention 
*/
typedef enum tagNETDEVPlayerRunInfoType
{
    NETDEV_PLAYER_RUN_INFO_RECORD_VIDEO        = 1,        /**<  */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PROCESS       = 2,        /**<  */
    NETDEV_PLAYER_RUN_INFO_SERIES_SNATCH       = 3,        /**<  */
    NETDEV_PLAYER_RUN_INFO_MEDIA_VOICE         = 4,        /**<  */
    NETDEV_PLAYER_RUN_INFO_MEDIA_NOT_IDENTIFY  = 5,        /**<  */
    NETDEV_PLAYER_RUN_INFO_RECV_PACKET_NUM     = 6,        /**<  */
    NETDEV_PLAYER_RUN_INFO_RECV_BYTE_NUM       = 7,        /**<  */
    NETDEV_PLAYER_RUN_INFO_VIDEO_FRAME_NUM     = 8,        /**<  */
    NETDEV_PLAYER_RUN_INFO_AUDIO_FRAME_NUM     = 9,        /**<  */
    NETDEV_PLAYER_RUN_INFO_LOST_PACKET_RATIO   = 10,       /**< 0.01% */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_PROGRESS = 11,       /**<  */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_END      = 12,       /**<  */
    NETDEV_PLAYER_RUN_INFO_MEDIA_ABNORMAL      = 13,       /**<  */
    NETDEV_PLAYER_RUN_INFO_CODEC               = 14,       /**<  */
    NETDEV_PLAYER_RUN_INFO_STREAM              = 15,       /**<  */
    NETDEV_PLAYER_RUN_INFO_PLAYBACK_FINISH     = 16,       /**<  */
    NETDEV_PLAYER_RUN_INFO_SNATCH              = 17,       /**<  */
    NETDEV_PLAYER_RUN_INFO_INVALID             = 0xff      
}NETDEV_PLAYER_RUN_INFO_TYPE_E;

/**
 * @enum tagNETDEVAlarmSrcTypeEn
 * @brief    Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmSrcTypeEn
{
    NETDEV_ALARM_SRC_LOCAL_HARD_DISK                            = 0,        
    NETDEV_ALARM_SRC_EX_CABINET_1_STORAGE_DISK                  = 1,        /*-1*/
    NETDEV_ALARM_SRC_EX_CABINET_2_STORAGE_DISK                  = 2,        /*-2*/
    NETDEV_ALARM_SRC_ARRAY_STORAGE_DISK                         = 3,        
    NETDEV_ALARM_SRC_NAS_STORAGE_DISK                           = 4,        /*NAS*/
    NETDEV_ALARM_SRC_SAN_STORAGE_DISK                           = 5,        /*SAN*/
    NETDEV_ALARM_SRC_ESATA_STORAGE_DISK                         = 6,        /*eSATA*/
    NETDEV_ALARM_SRC_SD_STORAGE_DISK                            = 7,        /*SD*/
    NETDEV_ALARM_SRC_VIDEO_CHANNEL                              = 8,        
    NETDEV_ALARM_SRC_ALARM_INPUT_CHANNEL                        = 9,        
    NETDEV_ALARM_SRC_SYSTEM                                     = 10,       
    NETDEV_ALARM_SRC_AUDIO_CHANNEL                              = 11,       
    NETDEV_ALARM_SRC_DECODE_CHANNEL                             = 12,       
    NETDEV_ALARM_SRC_ALARM_OUTPUT_CHANNEL                       = 13,       
    NETDEV_ALARM_SRC_ACCESS_CONTROL_CHANNEL                     = 14,       
    NETDEV_ALARM_SRC_ALARM_POINT_CHANNEL                        = 15,       
    NETDEV_ALARM_SRC_EMERGENCY_BELL_CHANNEL                     = 16,       
    NETDEV_ALARM_SRC_DEV                                        = 17,       
    NETDEV_ALARM_SRC_INVALID                                    = 0xFFFF    /*   Invalid value */
}NETDEV_ALARM_SRC_TYPE_E;

/**
 * @enum tagNETDEVResChangeSubeventType
 * @brief   Type of resource change subevent
 * @attention  None
 */
typedef enum tagNETDEVResChangeSubeventType
{
    NETDEV_RES_CHANGE_SUBEVENT_ADD                                  = 0,             
    NETDEV_RES_CHANGE_SUBEVENT_DELETE                               = 1,             
    NETDEV_RES_CHANGE_SUBEVENT_MODIFY                               = 2,             
    NETDEV_RES_CHANGE_SUBEVENT_UP_LINE                              = 3,             
    NETDEV_RES_CHANGE_SUBEVENT_OFFLINE                              = 4,             
    NETDEV_RES_CHANGE_SUBEVENT_EMAP_ALARM_REPORT                    = 5,             /* Emap */
    NETDEV_RES_CHANGE_SUBEVENT_INVALID                              = 0xff           /*   Invalid value */
}NETDEV_RES_CHANGE_SUBEVENT_TYPE_E;

/**
 * @enum tagNETDEVResType
 * @brief   Type of resource change
 * @attention  None
 */
typedef enum tagNETDEVResType
{
    NETDEV_RES_USER_RESOURCE                                 = 0,             
    NETDEV_RES_EQUIPMENT_RESOURCE                            = 1,             
    NETDEV_RES_CHANNEL_RESOURCE                              = 2,             
    NETDEV_RES_USER_PERMISSION_RESOURCES                     = 3,             
    NETDEV_RES_ROUND_TOUR_RESOURCES                          = 4,             
    NETDEV_RES_HOT_RESOURCES                                 = 5,             
    NETDEV_RES_GEOTHERMAL_RESOURCES                          = 6,             
    NETDEV_RES_ALARM_RESOURCES                               = 7,             
    NETDEV_RES_TIME_TEMPLATE                                 = 8,             
    NETDEV_RES_SYSTEM_PERMISSION_RESOURCES                   = 9,             
    NETDEV_RES_DEVICE_PERMISSION_RESOURCES                   = 10,            
    NETDEV_RES_ORGANIZE_RESOURCES                            = 11,            
    NETDEV_RES_ALARM_TASK_RESOURCES                          = 12,            
    NETDEV_RES_MASTER_SLAVE_RESOURCES                        = 13,            
    NETDEV_RES_TV_WALL_INFO                                  = 14,            
    NETDEV_RES_TV_WALL_SCENE_RESOURCES                       = 15,            
    NETDEV_RES_TV_WALL_WINDOW_RESOURCES                      = 16,            
    NETDEV_RES_TV_WALL_VIRTUAL_LED_RESOURCES                 = 17,            /* LED */
    NETDEV_RES_BROADCAST_GROUP_INFOR_CHANGES                 = 18,            
    NETDEV_RES_VIRTUAL_ORGANIZATION_RESOURCES                = 19,            
    NETDEV_RES_USER_ROLE_RESOURCES                           = 20,            
    NETDEV_RES_ROLE_ORGANIZE_SDHOW_TREE_RESOURCES            = 21,            
    NETDEV_RES_IMAGE_RESOURCES                               = 22,            
    NETDEV_RES_CRUISE_RESOURCES                              = 23,            
    NETDEV_RES_RECORD_TRACE_RESOURCES                        = 24,            
    NETDEV_RES_ACCESS_CONTROL_PERSONNEL_RESOURCES            = 25,            
    NETDEV_RES_ACCESS_CONTROL_CARD_RESOURCES                 = 26,            
    NETDEV_RES_TV_WALL_LIST                                  = 27,            
    NETDEV_RES_TV_WALL_SCENE_SWITCHING                       = 28,            
    NETDEV_RES_FACE_DATABASE_RESOURCES                       = 29,            
    NETDEV_RES_FACE_DATABASE_CUSTOM_ATTRIBUTE                = 30,            
    NETDEV_RES_FACE_MEMBER_RESOURCES                         = 31,            
    NETDEV_RES_FACE_CONTROL_RESOURCES                        = 32,            
    NETDEV_RES_INTELLIGENT_DETECTION_RESOURCES               = 33,            
    NETDEV_RES_INVALID                                       = 0xff           /*   Invalid value */
}NETDEV_RES_CHANGE_TYPE_E;

/**
 * @enum tagNETDEVLogMainType
 * @brief   Major types of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogMainType
{
    /* NVR */
    NETDEV_LOG_MAIN_TYPE_ALL                                        = 0,                /*  NVR Logs of all types */
    NETDEV_LOG_MAIN_TYPE_ALARM                                      = 1,                /*   Alarms */
    NETDEV_LOG_MAIN_TYPE_EXCEPTION                                  = 2,                /*   Exceptions */
    NETDEV_LOG_MAIN_TYPE_OPERATION                                  = 3,                /*   Operations */
    NETDEV_LOG_MAIN_TYPE_MESSAGE                                    = 4,                /*   Messages */

    /* VMS*/
    NETDEV_LOG_MAIN_TYPE_VMS_ALL                                    =  90,              /*  VMS Logs of all types */
    NETDEV_LOG_MAIN_TYPE_LOGIN                                      =  91,              /*  Login */

    NETDEV_LOG_MAIN_TYPE_ORGANIZATION_CONFIG                        = 100,              /*  Organization Config */
    NETDEV_LOG_MAIN_TYPE_USER_CONFIG                                = 101,              /*  User Config */
    NETDEV_LOG_MAIN_TYPE_ROLE_CONFIG                                = 102,              /*  Role Config */
    NETDEV_LOG_MAIN_TYPE_DEVICE_CONFIG                              = 103,              /*  Device Config */
    NETDEV_LOG_MAIN_TYPE_CHANNE_LCONFIG                             = 104,              /*  Channel Config */
    NETDEV_LOG_MAIN_TYPE_SERVER_CONFIG                              = 105,              /*  Server Config */
    NETDEV_LOG_MAIN_TYPE_PTZ_CONFIG                                 = 106,              /*  PTZ Config */
    NETDEV_LOG_MAIN_TYPE_VIDEOWALL_CONFIG                           = 107,              /*  Video Wall Config */
    NETDEV_LOG_MAIN_TYPE_EMAP_CONFIG                                = 108,              /*  EMap Config */
    NETDEV_LOG_MAIN_TYPE_SYSTEM_CONFIG                              = 109,              /* () System Config */
    NETDEV_LOG_MAIN_TYPE_SEQUENCE_PLAN_CONFIG                       = 110,              /*  Sequence Plan Config */
    NETDEV_LOG_MAIN_TYPE_NETWORK_KEYPAD_CONFIG                      = 111,              /*  Network Keypad Config */
    NETDEV_LOG_MAIN_TYPE_SEQUENCE_RESOURCE_CONFIG                   = 112,              /*  Sequence Resource Config */
    NETDEV_LOG_MAIN_TYPE_HOT_SPOT_AND_ZONE_CONFIG                   = 113,              /*  Hot Spot And Zone Config */
    NETDEV_LOG_MAIN_TYPE_USER_TIME_TEMPLATE_CONFIG                  = 114,              /*  User Time Template Config */
    NETDEV_LOG_MAIN_TYPE_SERVER_WORK_MODE                           = 115,              /*  Server Work Mode */
    NETDEV_LOG_MAIN_TYPE_PERMISSION_TIME_TEMPLATE_CONFIG            = 116,              /*  Permission Time Template Config */
    NETDEV_LOG_MAIN_TYPE_TIME_CONFIG                                = 117,              /*  Time Config */
    NETDEV_LOG_MAIN_TYPE_TIMESYNC_CONFIG                            = 118,              /*  Time Sync Config */
    NETDEV_LOG_MAIN_TYPE_HOLIDAY_CONFIG                             = 119,              /*  Holiday Config */
    NETDEV_LOG_MAIN_TYPE_NTPTIME_CONFIG                             = 120,              /* NTP NTP Time Config */
    NETDEV_LOG_MAIN_TYPE_DST_CONFIG                                 = 121,              /*  DST Config */
    NETDEV_LOG_MAIN_TYPE_RESRELATION_CONFIG                         = 122,              /*  Resource Relation Config */
    NETDEV_LOG_MAIN_TYPE_DEVICE_TIME_SYNC                           = 123,              /*  Device Time Sync */
    NETDEV_LOG_MAIN_TYPE_TCPIP_CONFIG                               = 124,              /* tcp/ip TCP/IP Config */
    NETDEV_LOG_MAIN_TYPE_EZCLOUD_CONFIG                             = 125,              /*  EZCloud Config */
    NETDEV_LOG_MAIN_TYPE_DDNS_CONFIG                                = 126,              /* DDNS DDNS Config */
    NETDEV_LOG_MAIN_TYPE_PORT_CONFIG                                = 127,              /*  Port Config */
    NETDEV_LOG_MAIN_TYPE_PORTMAPPING_CONFIG                         = 128,              /*  Port Mapping Config */
    NETDEV_LOG_MAIN_TYPE_EMAIL_CONFIG                               = 129,              /*  Email Config */
    NETDEV_LOG_MAIN_TYPE_GBSERVER_CONFIG                            = 130,              /*  GB Server Config */
    NETDEV_LOG_MAIN_TYPE_GBT28181_LOCAL_CONFIG                      = 131,              /*  GBT28181 Local Config */
    NETDEV_LOG_MAIN_TYPE_UNP_CLIENT_CONFIG                          = 132,              /* UNP UNP Client Config */
    NETDEV_LOG_MAIN_TYPE_UNP_SERVER_CONFIG                          = 133,              /* UNP UNP Server Config */
    NETDEV_LOG_MAIN_TYPE_STATIC_ROUTE_CONFIG                        = 134,              /*  Static Route Config */
    NETDEV_LOG_MAIN_TYPE_802DOT1X_CONFIG                            = 135,              /* 8021X 802Dot1x Config" */
    NETDEV_LOG_MAIN_TYPE_ARP_CONFIG                                 = 136,              /* ARP ARP Config */
    NETDEV_LOG_MAIN_TYPE_HTTPS_CONFIG                               = 137,              /* https HTTPS Config */
    NETDEV_LOG_MAIN_TYPE_TELNET_CONFIG                              = 138,              /* telnet Telnet Config */
    NETDEV_LOG_MAIN_TYPE_SECURITY_PSW_CONFIG                        = 139,              /*  Security Passwd Config */
    NETDEV_LOG_MAIN_TYPE_IP_FILTER_RULE_CONFIG                      = 140,              /* IP IP Filter Rule Config */
    NETDEV_LOG_MAIN_TYPE_MAINTENANCE_CONFIG                         = 141,              /*  Maintenance Config */
    NETDEV_LOG_MAIN_TYPE_SET_MAX_LOG_RETENTION_TIME                 = 142,              /*  Set Max Log Retention Time */
    NETDEV_LOG_MAIN_TYPE_STREAM_TRANSMISSION_POLICY_CONFIG          = 143,              /*  Stream Transmission Policy Config */
    NETDEV_LOG_MAIN_TYPE_BATCH_CONFIG                               = 144,              /*  Batch Config */
    NETDEV_LOG_MAIN_TYPE_RAIDMODE_CONFIG                            = 145,              /* RAID RAID Mode Config */
    NETDEV_LOG_MAIN_TYPE_ARRAY_CONFIG                               = 146,              /*  Array Config */
    NETDEV_LOG_MAIN_TYPE_DISK_MANAGEMENT_CONFIG                     = 147,              /*  Disk Management Config */
    NETDEV_LOG_MAIN_TYPE_CHANNEL_SPACE_CONFIG                       = 148,              /*  Channel Space Config */
    NETDEV_LOG_MAIN_TYPE_OVER_WRITE_POLICY_CONFIG                   = 149,              /*  Overwrite Policy Config */
    NETDEV_LOG_MAIN_TYPE_DISKTEST_CONFIG                            = 150,              /*  Disk Test Config */
    NETDEV_LOG_MAIN_TYPE_NET_DISK_CONFIG                            = 151,              /*  Net Disk Config */
    NETDEV_LOG_MAIN_TYPE_RECORDING_SCHEDULE_CONFIG                  = 152,              /*  Recording Schedule Config */
    NETDEV_LOG_MAIN_TYPE_RECORDING_TIME_TEMPLATE_CONFIG             = 153,              /*  Recording Time Template Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_CONFIG                               = 154,              /*  Alarm Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_TIMETEMPLATE_CONFIG                  = 155,              /*  Alarm Time Template Config */
    NETDEV_LOG_MAIN_TYPE_CONTACT_CONFIG                             = 156,              /*  Contact Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL_CONFIG                 = 157,              /*  Alarmto Video Wall Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_SCENE_CONFIG                    = 158,              /*  Video Wall Scene Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_WINDOW_CONFIG                   = 159,              /*  Video Wall Window Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_VIRTUALLED_CONFIG               = 160,              /* LED Video Wall Virtual LED Config */
    NETDEV_LOG_MAIN_TYPE_EXTERNAL_ALARM_CONFIG                      = 161,              /*   External Alarm Config */
    NETDEV_LOG_MAIN_TYPE_DISK_GROUP_CONFIG                          = 162,              /*  Disk Group Config */
    NETDEV_LOG_MAIN_TYPE_BK_PLAN_CONFIG                             = 163,              /*  BK Plan Config */
    NETDEV_LOG_MAIN_TYPE_BK_TASK_CONFIG                             = 164,              /*  BK Task Config */
    NETDEV_LOG_MAIN_TYPE_LOCAL_BK_TASKCONFIG                        = 165,              /*  Local BK Task Config */
    NETDEV_LOG_MAIN_TYPE_TVWALL_AUDIO_CONFIG                        = 166,              /*  Tvwall Audio Config */
    NETDEV_LOG_MAIN_TYPE_LIVEVIEW                                   = 167,              /*  Live View */
    NETDEV_LOG_MAIN_TYPE_PLAYBACK                                   = 168,              /*  Playback */
    NETDEV_LOG_MAIN_TYPE_TWO_WAY_AUDIO                              = 169,              /*  Two Way Audio */
    NETDEV_LOG_MAIN_TYPE_PTZ                                        = 170,              /*  PTZ */
    NETDEV_LOG_MAIN_TYPE_DOWNLOAD                                   = 171,              /*  Download */
    NETDEV_LOG_MAIN_TYPE_LIVEVIEW_ON_VIDEO_WALL                     = 172,              /*  Live Viewon Video Wall */
    NETDEV_LOG_MAIN_TYPE_PLAYBACK_ON_VIDEO_WALL                     = 173,              /*  Playback On Video Wall */
    NETDEV_LOG_MAIN_TYPE_EMAP_OPERATION                             = 174,              /*  EMap Operation */
    NETDEV_LOG_MAIN_TYPE_DC_SEQUENCE_OPERATION                      = 175,              /* DC DC Sequence Operation */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_PLAYING_BY_NETWROK_KEYPAD       = 176,              /*  Video Wall Playing by Netwrok Keypad */
    NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL                        = 177,              /*  Alarm to Video Wall */
    NETDEV_LOG_MAIN_TYPE_ALARM_SUBSCRIPTION                         = 178,              /*  Alarm Subscription */
    NETDEV_LOG_MAIN_TYPE_PRESET_PATROL_CONFIG                       = 179,              /*  Preset Patrol Config */
    NETDEV_LOG_MAIN_TYPE_AUTOGUARD_CONFIG                           = 180,              /*  Auto Guard Config */
    NETDEV_LOG_MAIN_TYPE_RECORDED_PATROL_CONFIG                     = 181,              /*  Recorded Patrol Config */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_PERSONNEL_MANAGEMENT        = 182,              /*  Access Control Personnel Management */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_CARD_MANAGEMENT             = 183,              /*  Access Control Card Management */
    NETDEV_LOG_MAIN_TYPE_ZONE_OPERATION                             = 184,              /*  Zone Operation */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_DOOR                        = 185,              /*  Access Control Door */
    NETDEV_LOG_MAIN_TYPE_TRIGGER_ALARMOUTPUT                        = 186,              /*  Trigger Alarm Output */
    NETDEV_LOG_MAIN_TYPE_CENTER_RECORD                              = 187,              /*  Center Record */
    NETDEV_LOG_MAIN_TYPE_FACE_LIBRARY_OPERATION                     = 188,              /*  Face Library Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_OPERATION                      = 189,              /*  Face Member Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_CUSTOM_OPERATION                      = 190,              /*  Face Custom Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_SORT_OPERATION                 = 191,              /*  Face Member Sort Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MONITORING_TASKO_PERATION             = 192,              /*  Face Monitoring Task Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_LIBRARY_OPERATION                  = 193,              /*  Vehicle Library Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_SORT_OPERATION              = 194,              /*  Vehicle Member Sort Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_OPERATION                   = 195,              /*  Vehicle Member Operation */
    NETDEV_LOG_MAIN_TYPE_CAP_PAC_TASK                               = 196,              /*  Cap Pac Task */
    NETDEV_LOG_MAIN_TYPE_RECORD_BK_CONFIG                           = 197,              /*  Record BK Config */
    NETDEV_LOG_MAIN_TYPE_USB_OPERATION                              = 198,              /* U USB Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MONITORING_TASK_OPERATION          = 199,              /*  Vehicle Monitoring Task Operation */
    NETDEV_LOG_MAIN_TYPE_PERMISSION_ASSIGNMENT_OPERATION            = 200,              /*  Permission Assignment Operation */
    NETDEV_LOG_MAIN_TYPE_INVALID                                    = 0xFFFF            /*   Invalid value */
}NETDEV_LOG_MAIN_TYPE_E;

/**
 * @enum tagNETDEVLogSubType
 * @brief ID  Minor type IDs of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogSubType
{
    NETDEV_LOG_ALL_SUB_TYPES                     = 0x0101,          /*   All information logs */

    /*   Information logs */
    NETDEV_LOG_MSG_HDD_INFO                     = 300,              /*   HDD information */
    NETDEV_LOG_MSG_SMART_INFO                   = 301,              /* S.M.A.R.T  S.M.A.R.T information */
    NETDEV_LOG_MSG_REC_OVERDUE                  = 302,              /*   Expired recording deletion */
    NETDEV_LOG_MSG_PIC_REC_OVERDUE              = 303,              /*   Expired image deletion */

    /*   notification logs */
    NETDEV_LOG_NOTICE_IPC_ONLINE                = 310,              /*   Device online */
    NETDEV_LOG_NOTICE_IPC_OFFLINE               = 311,              /*   Device offline */
    NETDEV_LOG_NOTICE_ARRAY_RECOVER             = 312,              /*   arrayRecover */
    NETDEV_LOG_NOTICE_INIT_ARRARY               = 313,              /*   initializeArray */
    NETDEV_LOG_NOTICE_REBUILD_ARRARY            = 314,              /*   rebuildArray */
    NETDEV_LOG_NOTICE_POE_PORT_STATUS           = 315,              /* PoE  poePortStatus */
    NETDEV_LOG_NOTICE_NETWORK_PORT_STATUS       = 316,              /*  networkPortStatus */
    NETDEV_LOG_NOTICE_DISK_ONLINE               = 317,              /*   Disk online */

    /* ID  Sub type log ID of alarm logs */
    NETDEV_LOG_ALARM_MOTION_DETECT              = 350,              /*   Motion detection alarm */
    NETDEV_LOG_ALARM_MOTION_DETECT_RESUME       = 351,              /*   Motion detection alarm recover */
    NETDEV_LOG_ALARM_VIDEO_LOST                 = 352,              /*   Video loss alarm */
    NETDEV_LOG_ALARM_VIDEO_LOST_RESUME          = 353,              /*   Video loss alarm recover */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_DETECT        = 354,              /*   Tampering detection alarm */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_RESUME        = 355,              /*   Tampering detection alarm recover */
    NETDEV_LOG_ALARM_INPUT_SW                   = 356,              /*   Boolean input alarm */
    NETDEV_LOG_ALARM_INPUT_SW_RESUME            = 357,              /*   Boolean input alarm recover */
    NETDEV_LOG_ALARM_IPC_ONLINE                 = 358,              /*   Device online */
    NETDEV_LOG_ALARM_IPC_OFFLINE                = 359,              /*   Device offline */
    
    NETDEV_LOG_ALARM_AUDIO_DETECTION_START      = 360,              /*   Audio detection start */
    NETDEV_LOG_ALARM_AUDIO_DETECTION_END        = 361,              /*   Audio detection end */
    NETDEV_LOG_ALARM_CROSS_LINE_DETECT          = 362,              /*   CrossLine detection */
    NETDEV_LOG_ALARM_FACE_DETECT                = 363,              /*   Face Detection */
    NETDEV_LOG_ALARM_INTRUSION_DETECT           = 364,              /*   Intrusion Detection */
    NETDEV_LOG_ALARM_POS                        = 365,              /* POS  POS Alarm */
    NETDEV_LOG_ALARM_IMAGETOOBLURRY_ON          = 366,              /*   Defocus detection started*/
    NETDEV_LOG_ALARM_IMAGETOOBLURRY_OFF         = 367,              /*   Defocus detection ended*/
    NETDEV_LOG_ALARM_GLOBAL_SCENE_CHANGE        = 368,              /*   Scene change detection*/
    NETDEV_LOG_ALARM_AUTO_TRACK_ON              = 369,              /*   Auto tracking started*/
    NETDEV_LOG_ALARM_AUTO_TRACK_OFF             = 370,              /*   Auto tracking ended*/
    NETDEV_LOG_ALARM_CONFLAGRATION_ON           = 371,              
    NETDEV_LOG_ALARM_CONFLAGRATION_OFF          = 372,              
    NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_ON      = 373,              
    NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_OFF     = 374,              
    NETDEV_LOG_ALARM_ENTERAREA                  = 375,              
    NETDEV_LOG_ALARM_LEAVEAREA                  = 376,              

    /* ID  Sub type log ID of exception logs */
    NETDEV_LOG_EXCEP_DISK_ONLINE                = 400,              /*   Disk online */
    NETDEV_LOG_EXCEP_DISK_OFFLINE               = 401,              /*   Disk offline */
    NETDEV_LOG_EXCEP_DISK_ERR                   = 402,              /*   Disk exception */
    NETDEV_LOG_EXCEP_STOR_ERR                   = 403,              /*   Storage error */
    NETDEV_LOG_EXCEP_STOR_ERR_RECOVER           = 404,              /*   Storage error recover */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN          = 405,              /*   Not stored as planned */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN_RECOVER  = 406,              /*   Not stored as planned recover */
    NETDEV_LOG_EXCEP_ILLEGAL_ACCESS             = 407,              /*   Illegal access */
    NETDEV_LOG_EXCEP_IP_CONFLICT                = 408,              /* IP  IP address conflict */
    NETDEV_LOG_EXCEP_NET_BROKEN                 = 409,              /*   Network disconnection */
    NETDEV_LOG_EXCEP_PIC_REC_ERR                = 410,              /* ,  Failed to get captured image */
    NETDEV_LOG_EXCEP_VIDEO_EXCEPTION            = 411,              /* ()  Video input exception (for analog channel only) */
    NETDEV_LOG_EXCEP_VIDEO_MISMATCH             = 412,              /*    Video standards do not match */
    NETDEV_LOG_EXCEP_RESO_MISMATCH              = 413,              /*   Encoding resolution and front-end resolution do not match */
    NETDEV_LOG_EXCEP_TEMP_EXCE                  = 414,              /*   Temperature exception */
    NETDEV_LOG_EXCEP_RUNOUT_RECORD_SPACE        = 415,              /*   runOutOfRecordSpace */
    NETDEV_LOG_EXCEP_RUNOUT_IMAGE_SPACE         = 416,              /*   runOutOfImageSpace */
    NETDEV_LOG_EXCEP_OUT_RECORD_SPACE           = 417,              /*   recordSpaceUsedUp */
    NETDEV_LOG_EXCEP_OUT_IMAGE_SPACE            = 418,              /*   imageSpaceUsedUp */
    NETDEV_LOG_EXCEP_ANRIDISASSEMBLY            = 419,              /*   antiDisassembly Alarm */
    NETDEV_LOG_EXCEP_ANRIDISASSEMBLY_RECOVER    = 420,              /*  antiDisassembly AlarmClear*/
    NETDEV_LOG_EXCEP_ARRAY_DAMAGE               = 421,              /*   arrayDamage */
    NETDEV_LOG_EXCEP_ARRAY_DEGRADE              = 422,              /*   arrayDegrade */
    NETDEV_LOG_EXCEP_RECORD_SNAPSHOT_ABNOR      = 423,              /* /  recordSnapshotAbnormal */
    NETDEV_LOG_EXCEP_NET_BROKEN_RECOVER         = 424,              /*   networkDisconnectClear */
    NETDEV_LOG_EXCEP_IP_CONFLICT_RECOVER        = 425,              /* IP  ipConflictClear */
    NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP            = 426,              /*   High Temperature */
    NETDEV_LOG_EXCEP_DEVICE_LOWTEMP             = 427,              /*   Low Temperature */
    NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP_RECOVER    = 428,              /*   High Temperature Cleared */
    NETDEV_LOG_EXCEP_DEVICE_LOWTEMP_RECOVER     = 429,              /*   Low Temperature Cleared */
    NETDEV_LOG_EXCEP_FAN_FAULT                  = 430,              /*   Fan Failure */
    NETDEV_LOG_EXCEP_FAN_FAULT_RECOVER          = 431,              /*   Fan Failure Cleared */
    NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP            = 432,              /*   LED Distribution Box High Temperature */
    NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP_RECOVER    = 433,              /*   LED Distribution Box High Temperature Cleared */
    NETDEV_LOG_EXCEP_LEDBOX_SMOKE               = 434,              /*   LED Distribution Box Smoke Alarm */
    NETDEV_LOG_EXCEP_LEDBOX_SMOKE_RECOVER       = 435,              /*   LED Distribution Box Smoke Alarm Cleared */

    /* ID  Sub type log ID of operation logs */
    /*   Services */
    NETDEV_LOG_OPSET_LOGIN                      = 450,              /*   User login */
    NETDEV_LOG_OPSET_LOGOUT                     = 451,              /*   Log out */
    NETDEV_LOG_OPSET_USER_ADD                   = 452,              /*   Add user */
    NETDEV_LOG_OPSET_USER_DEL                   = 453,              /*   Delete user */
    NETDEV_LOG_OPSET_USER_MODIFY                = 454,              /*   Modify user */
    NETDEV_LOG_OPSET_START_REC                  = 455,              /*   Start recording */
    NETDEV_LOG_OPSET_STOP_REC                   = 456,              /*   Stop recording */
    NETDEV_LOG_OPSETR_PLAY_DOWNLOAD             = 457,              /* /  Playback and download */
    NETDEV_LOG_OPSET_DOWNLOAD                   = 458,              /*   Download */
    NETDEV_LOG_OPSET_PTZCTRL                    = 459,              /*   PTZ control */
    NETDEV_LOG_OPSET_PREVIEW                    = 460,              /*   Live preview */
    NETDEV_LOG_OPSET_REC_TRACK_START            = 461,              /*   Start recording route */
    NETDEV_LOG_OPSET_REC_TRACK_STOP             = 462,              /*   Stop recording route */
    NETDEV_LOG_OPSET_START_TALKBACK             = 463,              /*   Start two-way audio */
    NETDEV_LOG_OPSET_STOP_TALKBACK              = 464,              /*   Stop two-way audio */
    NETDEV_LOG_OPSET_IPC_ADD                    = 465,              /* IPC  Add IP camera */
    NETDEV_LOG_OPSET_IPC_DEL                    = 466,              /* IPC  Delete IP camera */
    NETDEV_LOG_OPSET_IPC_SET                    = 467,              /* IPC  Modify IP camera */
    NETDEV_LOG_OPSET_IPC_QUICK_ADD              = 468,              /* IPC  quickAddIpc*/
    NETDEV_LOG_OPSET_IPC_ADD_BY_NETWORK         = 469,              /* IPC  addIpcByNetwork */
    NETDEV_LOG_OPSET_IPC_MOD_IP                 = 470,              /* IPC  modifyIpcAddr */

    /*   Configurations */
    NETDEV_LOG_OPSET_DEV_BAS_CFG                = 500,              /*   Basic device information */
    NETDEV_LOG_OPSET_TIME_CFG                   = 501,              /*   Device time */
    NETDEV_LOG_OPSET_SERIAL_CFG                 = 502,              /*   Device serial port */
    NETDEV_LOG_OPSET_CHL_BAS_CFG                = 503,              /*   Basic channel configuration */
    NETDEV_LOG_OPSET_CHL_NAME_CFG               = 504,              /*   Channel name configuration */
    NETDEV_LOG_OPSET_CHL_ENC_VIDEO              = 505,              /*   Video encoding configuration */
    NETDEV_LOG_OPSET_CHL_DIS_VIDEO              = 506,              /*   Video display configuration */
    NETDEV_LOG_OPSET_PTZ_CFG                    = 507,              /*   PTZ configuration */
    NETDEV_LOG_OPSET_CRUISE_CFG                 = 508,              /*   Patrol route configuration */
    NETDEV_LOG_OPSET_PRESET_CFG                 = 509,              /*   Preset configuration */
    NETDEV_LOG_OPSET_VIDPLAN_CFG                = 510,              /*   Recording schedule configuration */
    NETDEV_LOG_OPSET_MOTION_CFG                 = 511,              /*   Motion detection configuration */
    NETDEV_LOG_OPSET_VIDLOSS_CFG                = 512,              /*   Video loss configuration */
    NETDEV_LOG_OPSET_COVER_CFG                  = 513,              /*   Tampering detection configuration */
    NETDEV_LOG_OPSET_MASK_CFG                   = 514,              /*   Privacy mask configuration */
    NETDEV_LOG_OPSET_SCREEN_OSD_CFG             = 515,              /* OSD  OSD overlay configuration */
    NETDEV_LOG_OPSET_ALARMIN_CFG                = 516,              /*   Alarm input configuration */
    NETDEV_LOG_OPSET_ALARMOUT_CFG               = 517,              /*   Alarm output configuration */
    NETDEV_LOG_OPSET_ALARMOUT_OPEN_MAN          = 518,              /* ,  Manually enable alarm output, GUI */
    NETDEV_LOG_OPSET_ALARMOUT_CLOSE_MAN         = 519,              /* ,  Manually disable alarm input, GUI */
    NETDEV_LOG_OPSET_ABNORMAL_CFG               = 520,              /*   Exception configuration */
    NETDEV_LOG_OPSET_HDD_CFG                    = 521,              /*   HDD configuration */
    NETDEV_LOG_OPSET_NET_IP_CFG                 = 522 ,             /* TCP/IP  TCP/IP configuration */
    NETDEV_LOG_OPSET_NET_PPPOE_CFG              = 523,              /* PPPOE  PPPOE configuration */
    NETDEV_LOG_OPSET_NET_PORT_CFG               = 524,              /*   Port configuration */
    NETDEV_LOG_OPSET_NET_DDNS_CFG               = 525,              /* DDNS  DDNS configuration */
    NETDEV_LOG_OPSET_AUDIO_DETECT               = 527,              /*   searchExtendDisk */
    NETDEV_LOG_OPSET_SEARCH_EX_DISK             = 528,              /*   searchExtendDisk */
    NETDEV_LOG_OPSET_ADD_EX_DISK                = 529 ,             /*   addExtendDisk */
    NETDEV_LOG_OPSET_DEL_EX_DISK                = 530,              /*   deleteExtendDisk */
    NETDEV_LOG_OPSET_SET_EX_DISK                = 531,              /*   setExtendDisk */
    NETDEV_LOG_OPSET_LIVE_BY_MULTICAST          = 532,              /*   liveViewByMulticast */
    NETDEV_LOG_OPSET_BISC_DEV_INFO              = 533,              /*   setBasicDeviceInfo */
    NETDEV_LOG_OPSET_PREVIEW_CFG                = 534,              /*   SetPreviewOnNvr */
    NETDEV_LOG_OPSET_SET_EMAIL                  = 535,              /*   setEmail */
    NETDEV_LOG_OPSET_TEST_EMAIL                 = 536,              /*   testEmail */
    NETDEV_LOG_OPSET_SET_IPCONTROL              = 537,              /* IP  setIPControl */
    NETDEV_LOG_OPSET_PORT_MAP                   = 538 ,             /*   setPortMap */
    NETDEV_LOG_OPSET_ADD_TAG                    = 539,              /*   addTag */
    NETDEV_LOG_OPSET_DEL_TAG                    = 540,              /*   deleteTag */
    NETDEV_LOG_OPSET_MOD_TAG                    = 541,              /*   modifyTag */
    NETDEV_LOG_OPSET_LOCK_RECORD                = 542,              /*   lockRecord */
    NETDEV_LOG_OPSET_UNLOCK_RECORD              = 543,              /*   unlockRecord */
    NETDEV_LOG_OPSET_DDNS_UPDATE_SUCCESS        = 545,              /* DDNS  DDNSUpdateSuccess */
    NETDEV_LOG_OPSET_DDNS_INCORRECT_ID          = 546,              /* DDNS  DDNSUpdateFailedIncorrectUsernamePassword */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_NAME_NOT_EXIST = 547,              /* DDNS  DDNSUpdateFailedDomainNameNotExist */
    NETDEV_LOG_OPSET_DDNS_UPDATE_FAIL           = 548,              /* DDNS  DDNSUpdateFailed */
    NETDEV_LOG_OPSET_HTTP_CFG                   = 549,              /* HTTPS  setHttps */
    NETDEV_LOG_OPSET_IP_OFFLINE_ALARM_CFG       = 550,              /* IPC  testDDNSDomain */
    NETDEV_LOG_OPSET_TELNET_CFG                 = 551,              /* Telnet  setTelnet */
    NETDEV_LOG_OPSET_TEST_DDNS_DOMAIN           = 552,              /* DDNS  testDDNSDomain */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_CONFLICT       = 553,              /* DDNS  DDNSDomainInvalid */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_INVALID        = 554,              /* DDNS  setDDNS */
    NETDEV_LOG_OPSET_DEL_PRESET                 = 555,              /*   deletePreset */
    NETDEV_LOG_OPSET_PTZ_3D_POSITION            = 556,              /* 3D  ptz3DPosition */
    NETDEV_LOG_OPSET_SNAPSHOT_SCHEDULE_CFG      = 557,              /*   setSnapshotSchedule */
    NETDEV_LOG_OPSET_IMAGE_UPLOAD_SCHEDULE_CFG  = 558,              /*   setImageUploadSchedule */
    NETDEV_LOG_OPSET_FTP_CFG                    = 559,              /* FTP  setFtpServer */
    NETDEV_LOG_OPSET_TEST_FTP_SERVER            = 560,              /* FTP  testFtpServer */
    NETDEV_LOG_OPSET_START_MANUAL_SNAPSHOT      = 561,              /*   startManualSnapshot */
    NETDEV_LOG_OPSET_CLOSE_MANUAL_SNAPSHOT      = 562,              /*   endManualSnapshot */
    NETDEV_LOG_OPSET_SNAPSHOT_CFG               = 563,              /*   setSnapshot */
    NETDEV_LOG_OPSET_ADD_HOLIDAY                = 564,              /*   addHoliday */
    NETDEV_LOG_OPSET_DEL_HOLIDAY                = 565,              /*   deleteHoliday */
    NETDEV_LOG_OPSET_MOD_HOLIDAY                = 566,              /*   modifyHoliday */
    NETDEV_LOG_OPSET_ONOFF_HOLIDAY              = 567,              /* /  enableDisableHoliday */
    NETDEV_LOG_OPSET_ALLOCATE_SPACE             = 568,              /*   allocateSpace */
    NETDEV_LOG_OPSET_HDD_FULL_POLICY_CFG        = 569,              /*   setHddFullPolicy */
    NETDEV_LOG_OPSET_AUDIO_STREAM_CFG           = 570,              /*   setAudioStream */
    NETDEV_LOG_OPSET_ARRAY_PROPERTY_CFG         = 571,              /*   setArrayProperty */
    NETDEV_LOG_OPSET_HOT_SPACE_DISK_CFG         = 572,              /*   setHotSpaceDisk */
    NETDEV_LOG_OPSET_CREAT_ARRAY                = 573,              /*   createArray */
    NETDEV_LOG_OPSET_ONE_CLICK_CREAT_ARRAY      = 574,              /*   oneClickCreateArray */
    NETDEV_LOG_OPSET_REBUILD_ARRAY              = 575,              /*   rebuildArray */
    NETDEV_LOG_OPSET_DEL_ARRAY                  = 576,              /*   deleteArray */
    NETDEV_LOG_OPSET_ENABLE_RAID                = 577,              /* RAID  enableRaid */
    NETDEV_LOG_OPSET_DISABLE_RAID               = 578,              /* RAID  disableRaid */
    NETDEV_LOG_OPSET_TEST_SMART                 = 579,              /* S.M.A.R.T  testSmart */
    NETDEV_LOG_OPSET_SMART_CFG                  = 580,              /* S.M.A.R.T  setSmart */
    NETDEV_LOG_OPSET_BAD_SECTOR_DETECT          = 581,              /*   badSectorDetect */
    NETDEV_LOG_OPSET_AUDIO_ALARM_DURATION       = 582,              /*   setAudioAlarmDuration */
    NETDEV_LOG_OPSET_CLR_AUDIO_ALARM            = 583,              /*   clearAudioAlarm */
    NETDEV_LOG_OPSET_IPC_TIME_SYNC_CFG          = 584,              /*   setIpcTimeSync */
    NETDEV_LOG_OPSET_ENABLE_DISK_GROUP          = 585,              /*   enableDiskGroup */
    NETDEV_LOG_OPSET_DISABLE_DISK_GRRUOP        = 586,              /*   disableDiskGroup */
    NETDEV_LOG_OPSET_ONVIF_AUTH_CFG             = 587,              /* ONVIF  setOnvifAuth */
    NETDEV_LOG_OPSET_8021X_CFG                  = 588,              /* 802.1X  set8021x */
    NETDEV_LOG_OPSET_ARP_PROTECTION_CFG         = 589,              /* ARP  setArpProtection */
    NETDEV_LOG_OPSET_SMART_BASIC_INFO_CFG       = 590 ,             /*   setSmartBasicInfo */
    NETDEV_LOG_OPSET_CROSS_LINE_DETECT_CFG      = 591,              /*   setCrossLineDetection */
    NETDEV_LOG_OPSET_INSTRUSION_DETECT_CFG      = 592,              /*   setIntrusionDetection */
    NETDEV_LOG_OPSET_PEOPLE_COUNT_CFG           = 593,              /*   setPeopleCount */
    NETDEV_LOG_OPSET_FACE_DETECT_CFG            = 594,              /*   setFaceDetection */
    NETDEV_LOG_OPSET_FISHEYE_CFG                = 595,              /*   setFisheye */
    NETDEV_LOG_OPSET_CUSTOM_PROTOCOL_CFG        = 596,              /*   setCustomProtocol */
    NETDEV_LOG_OPSET_BEHAVIOR_SEARCH            = 597,              /*   behaviorSearch */
    NETDEV_LOG_OPSET_FACE_SEARCH                = 598,              /*   faceSearch */
    NETDEV_LOG_OPSET_PEOPLE_COUNT               = 599,              /*   peopleCount */
    /*  Maintenance */
    NETDEV_LOG_OPSET_START_DVR                  = 600,              /*   Start up*/
    NETDEV_LOG_OPSET_STOP_DVR                   = 601,              /*   Shut down */
    NETDEV_LOG_OPSET_REBOOT_DVR                 = 602,              /*   Restart device */
    NETDEV_LOG_OPSET_UPGRADE                    = 603,              /*   Version upgrade */
    NETDEV_LOG_OPSET_LOGFILE_EXPORT             = 604,              /*   Export log files */
    NETDEV_LOG_OPSET_CFGFILE_EXPORT             = 605,              /*   Export configuration files */
    NETDEV_LOG_OPSET_CFGFILE_IMPORT             = 606,              /*   Import configuration files */
    NETDEV_LOG_OPSET_CONF_SIMPLE_INIT           = 607,              /*   Export configuration files */
    NETDEV_LOG_OPSET_CONF_ALL_INIT              = 608,              /*   Restore to factory settings */

    NETDEV_LOG_OPSET_VCA_BACKUP                 = 700,              /*   vcaBackup */
    NETDEV_LOG_OPSET_3G4G_CFG                   = 701,              /* 3G/4G  set3g4g */
    NETDEV_LOG_OPSET_MOUNT_EXTENDED_DISK        = 702,              /*  Mount extended disk*/
    NETDEV_LOG_OPSET_UNMOUNT_EXTENDED_DISK      = 703,              /*  Unmount extended disk*/
    NETDEV_LOG_OPSET_FORCE_USER_OFFLINE         = 704,              /*  Force user off line*/

    NETDEV_LOG_OPSET_AUTO_FUNCTION              = 709,              /*   autoFunction */
    NETDEV_LOG_OPSET_IPC_UPRAGDE                = 710,              /*   ipcUpgrade */
    NETDEV_LOG_OPSET_RESTORE_IPC_DEFAULTS       = 711,              /*   restoreIpcDefaults */
    NETDEV_LOG_OPSET_ADD_TRANSACTION            = 712,              /*   addTransaction */
    NETDEV_LOG_OPSET_MOD_TRANSACTION            = 713,              /*   modifyTransaction */
    NETDEV_LOG_OPSET_DEL_TRANSACTION            = 714,              /*   deleteTransaction */
    NETDEV_LOG_OPSET_POS_OSD                    = 715,              /* POS  setPosOsd */
    NETDEV_LOG_OPSET_ADD_HOT_SPACE_DEV          = 716,              /*   addHotSpaceDevice */
    NETDEV_LOG_OPSET_DEL_HOT_SPACE_DEV          = 717,              /*   deleteHotSpaceDevice */
    NETDEV_LOG_OPSET_MOD_HOT_SPACE_DEV          = 718,              /*   modifyHotSpaceDevice */
    NETDEV_LOG_OPSET_DEL_WORK_DEV               = 719,              /*   deleteWorkDevice */
    NETDEV_LOG_OPSET_WORKMODE_TO_NORMAL_CFG     = 720,              /*   SetWorkModeToNormal */
    NETDEV_LOG_OPSET_WORKMODE_TO_HOTSPACE_CFG   = 721,              /*   SetWorkModeToHotSpace */
    NETDEV_LOG_OPSET_AUTO_GUARD_CFG             = 723,              /*   setAutoGuard */
    NETDEV_LOG_OPSET_MULTICAST_CFG              = 724,              /*   SetMulticast */
    NETDEV_LOG_OPSET_DEFOCUS_DETECT_CFG         = 725,              /*  Set defocus detection*/
    NETDEV_LOG_OPSET_SCENECHANGE_CFG            = 726,              /*  Set scene change detection*/
    NETDEV_LOG_OPSET_AUTO_TRCAK_CFG             = 727,              /*  Set auto tracking*/
    NETDEV_LOG_OPSET_SORT_CAMERA_CFG            = 728,              /*  Sort camera*/
    NETDEV_LOG_OPSET_WATER_MARK_CFG             = 729,              /*  Set watermark*/

    /* VMS */
    NETDEV_LOG_VMS_OPRERATE_SUB_ALL                     = 1000,    /*  All Sub Operate Log */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGIN              = 1001,    /*  User Login */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGOUT             = 1002,    /*  User Logout */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_START_OPERATION    = 1003,    /*  User Start Operation */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_STOP_OPERATION     = 1004,    /*  User Stop Operation */
    NETDEV_LOG_VMS_OPRERATE_SUB_NEW_CONFIG              = 1005,    /*  New Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_EDIT_CONFIG             = 1006,    /*  Edit Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CONFIG           = 1007,    /*  Delete Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_ENABLE_CONFIG           = 1008,    /*  Enable Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_DISABLE_CONFIG          = 1009,    /*  Disable Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_TEST_CONFIG             = 1010,    /*  Test Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_OPEN_DOOR               = 1011,    /*  Open Door */
    NETDEV_LOG_VMS_OPRERATE_SUB_CLOSE_DOOR              = 1012,    /*  Close Door */
    NETDEV_LOG_VMS_OPRERATE_SUB_SARM                    = 1013,    /*  Arm */
    NETDEV_LOG_VMS_OPRERATE_SUB_DISARM                  = 1014,    /*  Disarm */
    NETDEV_LOG_VMS_OPRERATE_SUB_BYPASS                  = 1015,    /*  Bypass */
    NETDEV_LOG_VMS_OPRERATE_SUB_UNBYPASS                = 1016,    /*  UnBypass */
    NETDEV_LOG_VMS_OPRERATE_SUB_SHARE_DEVICE            = 1017,    /*  Share Device */
    NETDEV_LOG_VMS_OPRERATE_SUB_UN_SHARE_DEVICE         = 1018,    /*  Un Share Device */
    NETDEV_LOG_VMS_OPRERATE_SUB_START_CAP_PAC_TASK      = 1019,    /*  Start Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_STOP_CAP_PAC_TASK       = 1020,    /*  Stop Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CAPPAC_TASK      = 1021,    /*  Delete Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_INSERT              = 1022,    /* USB USB Insert */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_PULL_OUT            = 1023,    /* USB USB Pull Out */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_FORMAT              = 1024,    /* USB USB Format */
    NETDEV_LOG_VMS_OPRERATE_SUB_SYNC_DEV_CHL_INFO       = 1025,    /*  Sync Dev Chl Info */
    NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_LOCK           = 1026,    /*  Playback Lock */
    NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_UNLOCK         = 1027     /*  Playback Unlock */
}NETDEV_LOG_SUB_TYPE_E;

/**
 * enum tagNETDEVDeviceType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDeviceType
{
    NETDEV_DTYPE_UNKNOWN                        = 0,            /* Unknown type */
    NETDEV_DTYPE_IPC                            = 1,            /* IPC range */
    NETDEV_DTYPE_IPC_FISHEYE                    = 2,            /* IPC Certain fisheye camera models*/
    NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE           = 3,            /* IPC Certain fisheye camera models*/
    NETDEV_DTYPE_IPC_ACS                        = 4,            /* IPC Person verification camera models*/
    NETDEV_DTYPE_NVR                            = 101,          /* NVR range */
    NETDEV_DTYPE_NVR_BACKUP                     = 102,          /* NVR  NVR back up */
    NETDEV_DTYPE_HNVR                           = 103,          /* NVR */
    NETDEV_DTYPE_DC                             = 201,          /* DC range */
    NETDEV_DTYPE_DC_ADU                         = 202,          /* ADU range */
    NETDEV_DTYPE_EC                             = 301,          /* EC range */
    NETDEV_DTYPE_VMS                            = 501,          /* VMS range */
    NETDEV_DTYPE_FG                             = 601,          /* FG range */
    NETDEV_DTYPE_IPM                            = 701,          /* IPM range */
    NETDEV_DTYPE_EDU                            = 801,          /* EDU range */
    NETDEV_DTYPE_INVALID                        = 0xFFFF        /*   Invalid value */
}NETDEV_DEVICE_TYPE_E;

/**
 * @enum tagNETDEVCfgCmd
 * @brief   Parameter configuration command words Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCfgCmd
{
    NETDEV_GET_DEVICECFG                = 100,              /* ,#NETDEV_DEVICE_BASICINFO_S  Get device information, see #NETDEV_DEVICE_BASICINFO_S */
    NETDEV_SET_DEVICECFG                = 101,              /*  Reserved */

    NETDEV_GET_NTPCFG                   = 110,              /* NTP,#NETDEV_SYSTEM_NTP_INFO_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */
    NETDEV_SET_NTPCFG                   = 111,              /* NTP,#NETDEV_SYSTEM_NTP_INFO_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */

    NETDEV_GET_NTPCFG_EX                = 112,              /* NTP(),#NETDEV_SYSTEM_NTP_INFO_LIST_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */
    NETDEV_SET_NTPCFG_EX                = 113,              /* NTP(),#NETDEV_SYSTEM_NTP_INFO_LIST_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */

    NETDEV_GET_STREAMCFG                = 120,              /* ,#NETDEV_VIDEO_STREAM_INFO_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
    NETDEV_SET_STREAMCFG                = 121,              /* ,#NETDEV_VIDEO_STREAM_INFO_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
    NETDEV_GET_STREAMCFG_EX             = 122,              /* (),#NETDEV_VIDEO_STREAM_INFO_LIST_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
    NETDEV_SET_STREAMCFG_EX             = 123,              /* (),#NETDEV_VIDEO_STREAM_INFO_LIST_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
    NETDEV_GET_VIDEOMODECFG             = 124,              /* #NETDEV_VIDEO_MODE_INFO_S */
    NETDEV_SET_VIDEOMODECFG             = 125,              /* #NETDEV_VIDEO_MODE_INFO_S */

    NETDEV_GET_OSDCFG                   = 140,              /* OSD,#NETDEV_VIDEO_OSD_CFG_S  Get OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
    NETDEV_SET_OSDCFG                   = 141,              /* OSD,#NETDEV_VIDEO_OSD_CFG_S  Set OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
    NETDEV_GET_OSDCFG_EX                = 142,              /* OSD,#NETDEV_CHL_OSD_CFG_LIST_S  Get OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
    NETDEV_SET_OSDCFG_EX                = 143,              /* OSD,#NETDEV_CHL_OSD_CFG_LIST_S  Set OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
    NETDEV_GET_OSD_CONTENT_CFG          = 144,              /* OSD(),#NETDEV_OSD_CONTENT_S  Get OSD configuration information, see #NETDEV_OSD_CONTENT_S */
    NETDEV_SET_OSD_CONTENT_CFG          = 145,              /* OSD(),#NETDEV_OSD_CONTENT_S  Set OSD configuration information, see #NETDEV_OSD_CONTENT_S */
    NETDEV_GET_OSD_CONTENT_STYLE_CFG    = 146,              /* OSD,#NETDEV_OSD_CONTENT_STYLE_S  Get OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */
    NETDEV_SET_OSD_CONTENT_STYLE_CFG    = 147,              /* OSD,#NETDEV_OSD_CONTENT_STYLE_S  Set OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */

    NETDEV_GET_ALARM_OUTPUTCFG          = 150,              /* ,#NETDEV_ALARM_OUTPUT_LIST_S  Get boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_SET_ALARM_OUTPUTCFG          = 151,              /* ,#NETDEV_ALARM_OUTPUT_LIST_S  Set boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_TRIGGER_ALARM_OUTPUT         = 152,              /* ,#NETDEV_TRIGGER_ALARM_OUTPUT_S        Trigger boolean, see #NETDEV_TRIGGER_ALARM_OUTPUT_S */
    NETDEV_GET_ALARM_INPUTCFG           = 153,              /* ,#NETDEV_ALARM_INPUT_LIST_S   Get the number of boolean inputs, see #NETDEV_ALARM_INPUT_LIST_S */
    NETDEV_GET_MANUAL_ALARM_CFG         = 154,              /* #NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S  Get manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S*/
    NETDEV_SET_MANUAL_ALARM_CFG         = 155,              /* #NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S  Set manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S */
    NETDEV_GET_INPUTSWITCH_LIST_CFG     = 156,              /* #NETDEV_INPUT_SWITCH_INFO_LIST_S  Get all input switch information, see #NETDEV_INPUT_SWITCH_INFO_LIST_S*/

    NETDEV_GET_IMAGECFG                 = 160,              /* ,#NETDEV_IMAGE_SETTING_S  Get image configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_SET_IMAGECFG                 = 161,              /* ,#NETDEV_IMAGE_SETTING_S  Set image configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_GET_IMAGE_EXPOSURE           = 162,              /* ,#NETDEV_IMAGE_EXPOSURE_S  get image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
    NETDEV_SET_IMAGE_EXPOSURE           = 163,              /* ,#NETDEV_IMAGE_EXPOSURE_S  Set image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
    NETDEV_GET_IMAGE_LAMP_CTRLCFG       = 164,              /* ,#NETDEV_LAMP_CTRL_INFO_S  get channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_SET_IMAGE_LAMP_CTRLCFG       = 165,              /* ,#NETDEV_LAMP_CTRL_INFO_S  set channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_GET_IMAGE_WHITE_BALANCE      = 166,              /* ,#NETDEV_WHITE_BALANCE_INFO_S  get image white balance param, see #NETDEV_WHITE_BALANCE_INFO_S */
    NETDEV_SET_IMAGE_WHITE_BALANCE      = 167,              /* ,#NETDEV_WHITE_BALANCE_INFO_S  set image white balance param, see #NETDEV_WHITE_BALANCE_INFO_S */
    NETDEV_SET_IMAGE_PARAM_RESET        = 168,              /*   0 set channel image param reset 0video image param */

    NETDEV_GET_NETWORKCFG               = 170,              /* ,#NETDEV_NETWORKCFG_S  Get network configuration information, see #NETDEV_NETWORKCFG_S */
    NETDEV_SET_NETWORKCFG               = 171,              /* ,#NETDEV_NETWORKCFG_S  Set network configuration information, see #NETDEV_NETWORKCFG_S */

    NETDEV_GET_VPN_CFG                  = 172,              /* VPN #NETDEV_VPN_CLIENT_INFO_S get the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
    NETDEV_SET_VPN_CFG                  = 173,              /* VPN #NETDEV_VPN_CLIENT_INFO_S set the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
    NETDEV_SET_DNS_CFG                  = 174,              /* DNS #NETDEV_DNS_INFO_S Set DNS info see #NETDEV_DNS_INFO_S*/
    NETDEV_GET_DNS_CFG                  = 175,              /* DNS #NETDEV_DNS_INFO_S Get DNS info see #NETDEV_DNS_INFO_S*/
    NETDEV_SET_NETWORK_CARDS            = 176,              /*  #NETDEV_NETWORK_CARD_INFO_S set device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/
    NETDEV_GET_NETWORK_CARDS            = 177,              /*  #NETDEV_NETWORK_CARD_INFO_S get device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/

    NETDEV_SET_NETWORK_PORTS            = 178,              /*  #NETDEV_NETWORK_PORTS_INFO_S set device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/ 
    NETDEV_GET_NETWORK_PORTS            = 179,              /*  #NETDEV_NETWORK_PORTS_INFO_S get device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/ 

    NETDEV_GET_PRIVACYMASKCFG           = 180,              /* ,#NETDEV_PRIVACY_MASK_CFG_S  Get privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
    NETDEV_SET_PRIVACYMASKCFG           = 181,              /* ,#NETDEV_PRIVACY_MASK_CFG_S  Set privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
    NETDEV_DELETE_PRIVACYMASKCFG        = 182,              /*   Delete privacy mask configuration information */

    NETDEV_GET_TAMPERALARM              = 190,              /*   #NETDEV_TAMPER_ALARM_INFO_S  Get tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */
    NETDEV_SET_TAMPERALARM              = 191,              /*   #NETDEV_TAMPER_ALARM_INFO_S  Set tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */

    NETDEV_GET_MOTIONALARM              = 200,              /*  #NETDEV_MOTION_ALARM_INFO_S  Get motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */
    NETDEV_SET_MOTIONALARM              = 201,              /*  #NETDEV_MOTION_ALARM_INFO_S  Set motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */

    NETDEV_GET_CROSSLINEALARM           = 202,              /*  NETDEV_CROSS_LINE_ALARM_INFO_S Get Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/
    NETDEV_SET_CROSSLINEALARM           = 203,              /*  NETDEV_CROSS_LINE_ALARM_INFO_S Set Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/

    NETDEV_GET_INTRUSIONALARM           = 204,              /*  NETDEV_INTRUSION_ALARM_INFO_S Get intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/
    NETDEV_SET_INTRUSIONALARM           = 205,              /*  NETDEV_INTRUSION_ALARM_INFO_S Set intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/

    NETDEV_GET_DISKSINFO                = 210,              /*  #NETDEV_DISK_INFO_LIST_S  Get disks information, see #NETDEV_DISK_INFO_LIST_S */
    NETDEV_SET_DISKSINFO                = 211,              

    NETDEV_GET_FOCUSINFO                = 230,              /*  #NETDEV_FOCUS_INFO_S Get focus info, see #NETDEV_FOCUS_INFO_S */
    NETDEV_SET_FOCUSINFO                = 231,              /*  #NETDEV_FOCUS_INFO_S Set focus info, see #NETDEV_FOCUS_INFO_S */
    NETDEV_GET_IRCUTFILTERINFO          = 232,              /*  #NETDEV_IRCUT_FILTER_INFO_S Get IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
    NETDEV_SET_IRCUTFILTERINFO          = 233,              /*  #NETDEV_IRCUT_FILTER_INFO_S Set IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
    NETDEV_GET_DEFOGGINGINFO            = 234,              /*  #NETDEV_DEFOGGING_INFO_S Get defogging info, see #NETDEV_DEFOGGING_INFO_S */
    NETDEV_SET_DEFOGGINGINFO            = 235,              /*  #NETDEV_DEFOGGING_INFO_S Set defogging info, see #NETDEV_DEFOGGING_INFO_S */
    NETDEV_SET_CHL_IMAGE_ENHANCE        = 236,              /* set channel image Enhance */
    NETDEV_GET_CHL_IMAGE_ENHANCE        = 237,              /* get channel image Enhance */

    NETDEV_GET_AUDIOIN_CFG              = 240,              /*  #NETDEV_AUDIO_INPUT_CFG_INFO_S get audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */
    NETDEV_SET_AUDIOIN_CFG              = 241,              /*  #NETDEV_AUDIO_INPUT_CFG_INFO_S set audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */

    NETDEV_GET_DST_CFG                  = 260,              /*  #NETDEV_DST_CFG_S Get defogging info, see #NETDEV_DST_CFG_S */
    NETDEV_SET_DST_CFG                  = 261,              /*  #NETDEV_DST_CFG_S Set defogging info, see #NETDEV_DST_CFG_S */

    NETDEV_GET_RECORDPLANINFO           = 270,              /*  NVR VMS #NETDEV_RECORD_PLAN_CFG_INFO_S */
    NETDEV_SET_RECORDPLANINFO           = 271,              /*  NVR VMS #NETDEV_RECORD_PLAN_CFG_INFO_S */
    NETDEV_SET_SNAPSHOT_CFG             = 272,              /*  #NETDEV_VIDEO_SNAPSHOT_S Set snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */
    NETDEV_GET_SNAPSHOT_CFG             = 273,              /*  #NETDEV_VIDEO_SNAPSHOT_S Get snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */

    NETDEV_GET_MOTIONDETECTION_WEEKPLAN     = 280,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_MOTIONDETECTION_WEEKPLAN     = 281,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_CROSSLINEDETECTION_WEEKPLAN  = 282,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_CROSSLINEDETECTION_WEEKPLAN  = 283,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_INTRUSIONDETECTION_WEEKPLAN  = 284,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_INTRUSIONDETECTION_WEEKPLAN  = 285,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_AUDIODETECTION_WEEKPLAN      = 286,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_AUDIODETECTION_WEEKPLAN      = 287,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_OBJTRACK_WEEKPLAN            = 288,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_OBJTRACK_WEEKPLAN            = 289,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_VIDEOLOSS_WEEKPLAN           = 290,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_VIDEOLOSS_WEEKPLAN           = 291,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_TAMPERDETECTION_WEEKPLAN     = 292,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_TAMPERDETECTION_WEEKPLAN     = 293,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_INPUTSWITCHES_WEEKPLAN       = 294,              /* ,#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Get InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_SET_INPUTSWITCHES_WEEKPLAN       = 295,              /* ,,#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Set InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_GET_OUTPUTSWITCHES_WEEKPLAN      = 296,              /* ,#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Get OutputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_SET_OUTPUTSWITCHES_WEEKPLAN      = 297,              /* ,,#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Set OutputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_GET_DEFOCUSDETECTION_WEEKPLAN    = 298,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_DEFOCUSDETECTION_WEEKPLAN    = 299,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_SCENECHANGE_WEEKPLAN         = 300,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_SCENECHANGE_WEEKPLAN         = 301,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_FACEDETECTION_WEEKPLAN       = 302,              /* ,#NETDEV_WEEK_PLAN_INFO_S  Get FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_FACEDETECTION_WEEKPLAN       = 303,              /* ,,#NETDEV_WEEK_PLAN_INFO_S  Set FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */

    NETDEV_GET_RECORD_STATUS                = 320,              /*  #NETDEV_RECORD_STATUS_LIST_S  Get video status information*/

    NETDEV_GET_SERIAL_CFG                   = 330,              /*  # NETDEV_SERIAL_PORTS_S Get serail info, see # NETDEV_SERIAL_PORTS_S */
    NETDEV_SET_SERIAL_CFG                   = 331,              /*  # NETDEV_SERIAL_PORTS_S Set serail info, see # NETDEV_SERIAL_PORTS_S */


    NETDEV_GET_AUDIO_DECODE_STATUS              = 340,          /*  #NETDEV_AUDIO_DECODE_STATUS_LIST_S */
    NETDEV_SET_AUDIO_DECODE_STATUS              = 341,          /*  #NETDEV_AUDIO_DECODE_STATUS_LIST_S */

    NETDEV_GET_VIDEO_LOSS_RULE_INFO             = 400,          /*  #NETDEV_VIDEO_LOSS_RULE_INFO_S */
    NETDEV_SET_VIDEO_LOSS_RULE_INFO             = 401,          /*  #NETDEV_VIDEO_LOSS_RULE_INFO_S */
    NETDEV_GET_VIDEO_LOSS_LINKAGE_ACTIONS       = 410,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_SET_VIDEO_LOSS_LINKAGE_ACTIONS       = 411,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_TAMPER_DETECTION_RULE_INFO       = 420,          /*  #NETDEV_TAMPER_DETECTION_RULE_INFO_S */
    NETDEV_SET_TAMPER_DETECTION_RULE_INFO       = 421,          /*  #NETDEV_TAMPER_DETECTION_RULE_INFO_S */
    NETDEV_GET_TAMPER_DETECTION_LINKAGE_ACTIONS = 430,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_SET_TAMPER_DETECTION_LINKAGE_ACTIONS = 431,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */

    NETDEV_GET_TEMP_DETECTION_RULE_INFO         = 432,          /*  # NETDEV_TEMP_DETECTION_RULE_INFO_S */
    NETDEV_SET_TEMP_DETECTION_RULE_INFO         = 433,          /*  # NETDEV_TEMP_DETECTION_RULE_INFO_S */
    NETDEV_GET_TEMP_DETECTION_BLACKBODY_INFO    = 434,          /*  # NETDEV_TEMP_DETECTION_BLACKBODY_INFO_S */
    NETDEV_SET_TEMP_DETECTION_BLACKBODY_INFO    = 435,          /*  # NETDEV_TEMP_DETECTION_BLACKBODY_INFO_S */
    NETDEV_GET_TEMP_DETECTION_CORRECT_INFO      = 436,          /*  # NETDEV_TEMP_DETECTION_CORRECT_INFO_S */
    NETDEV_SET_TEMP_DETECTION_CORRECT_INFO      = 437,          /*  # NETDEV_TEMP_DETECTION_CORRECT_INFO_S */
    NETDEV_GET_TEMP_DETECTION_UNIT_INFO         = 438,          /*  # NETDEV_TEMP_DETECTION_UNIT_INFO_S */
    NETDEV_SET_TEMP_DETECTION_UNIT_INFO         = 439,          /*  # NETDEV_TEMP_DETECTION_UNIT_INFO_S */

    NETDEV_GET_MOTION_DETECTION_AREA_TYPE       = 440,          /*  #NETDEV_MOTION_DETECTION_AREA_TYPE_S */
    NETDEV_SET_MOTION_DETECTION_AREA_TYPE       = 441,          /*  #NETDEV_MOTION_DETECTION_AREA_TYPE_S */
    NETDEV_GET_MOTION_DETECTION_AREA_GRID_INFO  = 442,          /*  #NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
    NETDEV_SET_MOTION_DETECTION_AREA_GRID_INFO  = 443,          /*  #NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
    NETDEV_GET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 444,    /*  #NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
    NETDEV_SET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 445,    /*  #NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
    NETDEV_GET_MOTION_DETECTION_LINKAGE_ACTIONS = 450,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_SET_MOTION_DETECTION_LINKAGE_ACTIONS = 451,          /*  #NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 460,          /*  #NETDEV_SWITCH_LINKAGE_ACTION_S */
    NETDEV_SET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 461,          /*  #NETDEV_SWITCH_LINKAGE_ACTION_S */

    NETDEV_GET_RAID_STATUS                      = 470,          /*  #NETDEV_RAID_STATUS_S */
    NETDEV_GET_RAID_STORAGE_CONTAINER_INFO_LIST = 471,          /* NETDEV_GET_RAID_STATUS #NETDEV_HDD_INFO_LIST_S */
    NETDEV_GET_STORAGE_CONTAINER_INFO_LIST      = 472,          /* NETDEV_GET_RAID_STATUS #NETDEV_STORAGE_CONTAINER_INFO_LIST_S */
    NETDEV_GET_HDD_SMART_INFO                   = 473,          /* Smart #NETDEV_HDD_SMART_INFO_S */
    NETDEV_SET_HDD_SMART_INFO                   = 474,          /* Smart #NETDEV_HDD_SMART_CHECK_INFO_S */
    NETDEV_GET_RAID_STATUS_V30                  = 475,          /*  VMS/NVR #NETDEV_RAID_STATUS_S */
    NETDEV_SET_RAID_STATUS_V30                  = 476,          /*  VMS/NVR #NETDEV_RAID_STATUS_S */

    NETDEV_GET_CLOUD_CONVENIENT_ACCS_STATUS     = 480,          /* Ezcloud  0 1 */
    NETDEV_SET_CLOUD_CONVENIENT_ACCS_STATUS     = 481,          /* Ezcloud  0 1 */
    
    NETDEV_GET_PHOTO_SERVER_INFO                = 482,          /*  # NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S */
    NETDEV_SET_PHOTO_SERVER_INFO                = 483,          /*  # NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S */

    NETDEV_GET_ENHANCED_CONFIG                  = 484,          /* ,# NETDEV_ENHANCED_CONFIG_INFO_S */
    NETDEV_SET_ENHANCED_CONFIG                  = 485,          /* ,# NETDEV_ENHANCED_CONFIG_INFO_S */

    NETDEV_GET_INTELLIGENT_SERVER_INFO          = 486,          /*  # NETDEV_DATA_SERVER_LIST */
    NETDEV_SET_INTELLIGENT_SERVER_INFO          = 487,          /*  # NETDEV_DATA_SERVER_LIST */

    NETDEV_GET_MOTION_INTERVAL_INFO             = 490,          /*   NETDEV_MOTION_INTERVAL_INFO_S */
    NETDEV_SET_MOTION_INTERVAL_INFO             = 491,          /*   NETDEV_MOTION_INTERVAL_INFO_S */

    NETDEV_GET_MANAGER_SERVER_INFO              = 492,          /*  # NETDEV_MANAGER_SERVER_LIST_S */
    NETDEV_SET_MANAGER_SERVER_INFO              = 493,          /*  # NETDEV_MANAGER_SERVER_LIST_S */

    NETDEV_GET_VISIBLE_RANGE_INFO               = 494,          /*  # NETDEV_VISIBLE_RANGE_INFO_S */
    NETDEV_SET_VISIBLE_RANGE_INFO               = 495,          /*  # NETDEV_VISIBLE_RANGE_INFO_S */

    NETDEV_GET_RESET_PWD_VERTIFY_INFO           = 496,          /*  #NETDEV_RESET_PWD_VERTIFY_INFO_S*/
    NETDEV_SET_RESET_PWD_VERTIFY_INFO           = 497,          /*  #NETDEV_RESET_PWD_VERTIFY_INFO_S*/

    NETDEV_GET_CHL_STORAGE_QUOTA_INFO           = 498,          /*  #NETDEV_STORAGE_QUOTA_INFO_S */
    NETDEV_SET_CHL_STORAGE_QUOTA_INFO           = 499,          /*  #NETDEV_STORAGE_QUOTA_INFO_S */

    NETDEV_GET_CUSTOM_PROTOCOL_INFO             = 501,          /*  # NETDEV_CUSTON_PROTOCOL_INFO_S */
    NETDEV_SET_CUSTOM_PROTOCOL_INFO             = 502,          /*  # NETDEV_CUSTON_PROTOCOL_INFO_S */
    NETDEV_GET_CUSTOM_PROTOCOL_INFOLIST         = 503,          /*  # NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S */

    NETDEV_GET_CHL_STORAGE_STRATEGY             = 504,          /*  #NETDEV_STORAGE_STRATEGY_S */
    NETDEV_SET_CHL_STORAGE_STRATEGY             = 505,          /*  #NETDEV_STORAGE_STRATEGY_S */

    NETDEV_SET_BACKFOCUS                        = 506,          /*  IPC # NETDEV_BACKFOCUS_INFO_S */
    
    NETDEV_GET_SMART_ATTR_MONITOR               = 508,          /* #  NETDEV_SMART_ATTR_CFG_S */
    NETDEV_SET_SMART_ATTR_MONITOR               = 509,          /* #  NETDEV_SMART_ATTR_CFG_S */

    NETDEV_GET_IMAGE_CORRECT_PARAM              = 510,          /*  # NETDEV_IMAGE_CORRECT_PARAM_S */

    NETDEV_GET_DEVICE_TIME_SYNCMODE                = 512,        /*  NETDEV_TIME_SYNCMODE_S */
    NETDEV_SET_DEVICE_TIME_SYNCMODE                = 513,        /*  NETDEV_TIME_SYNCMODE_S */  
    NETDEV_GET_IMAGE_SCENE_AUTO_SWITCH_INFO        = 514,        /*   NETDEV_SCENE_AUTO_SWITCH_INFO_S */
    NETDEV_SET_IMAGE_SCENE_AUTO_SWITCH_INFO        = 515,        /*   NETDEV_SCENE_AUTO_SWITCH_INFO_S */
    NETDEV_GET_IMAGE_CURRENT_SCENE_TEMPLATE_INFO   = 516,        /*   NETDEV_SCENE_TEMPLATE_INFO_S */
    NETDEV_SET_IMAGE_CURRENT_SCENE_TEMPLATE_INFO   = 517,        /*   NETDEV_SCENE_TEMPLATE_INFO_S */
    NETDEV_GET_IMAGE_DEFAULT_SCENE_TEMPLATE_INFO   = 518,        /*   NETDEV_SCENE_TEMPLATE_INFO_S */
    NETDEV_SET_IMAGE_DEFAULT_SCENE_TEMPLATE_INFO   = 519,        /*   NETDEV_SCENE_TEMPLATE_INFO_S */
    NETDEV_GET_IMAGE_ALL_SCENE_INFO                = 520,        /*   NETDEV_SCENE_INFO_LIST_S */
    NETDEV_SET_IMAGE_ALL_SCENE_INFO                = 521,        /*   NETDEV_SCENE_INFO_LIST_S */
    NETDEV_GET_IMAGE_SPECIFIC_SCENE_INFO           = 522,        /*   NETDEV_SCENE_INFO_S */
    NETDEV_SET_IMAGE_SPECIFIC_SCENE_INFO           = 523,        /*   NETDEV_SCENE_INFO_S */
    NETDEV_GET_ATTR_COLLECT_INFO                   = 524,        /*  # NETDEV_ATTR_COLLECT_INFO_S */
    NETDEV_SET_ATTR_COLLECT_INFO                   = 525,        /*  # NETDEV_ATTR_COLLECT_INFO_S */
    NETDEV_GET_SYS_TIMECFG                         = 526,        /*   NETDEV_TIME_CFG_V30_S  URLNETDEV_INVALID_CHANNEL_ID */
    NETDEV_SET_SYS_TIMECFG                         = 527,        /*   NETDEV_TIME_CFG_V30_S  URLNETDEV_INVALID_CHANNEL_ID */
    NETDEV_GET_NTPCFG_V30                          = 528,        /* NTP  NETDEV_SYSTEM_NTP_INFO_LIST_S  URLNETDEV_INVALID_CHANNEL_ID */
    NETDEV_SET_NTPCFG_V30                          = 529,        /* NTP  NETDEV_SYSTEM_NTP_INFO_LIST_S  URLNETDEV_INVALID_CHANNEL_ID */
    NETDEV_GET_DEVICE_TIME_SYNCMODE_EX             = 530,        /*    NETDEV_TIME_SYNCMODE_S  URLNETDEV_INVALID_CHANNEL_ID */
    NETDEV_SET_DEVICE_TIME_SYNCMODE_EX             = 531,        /*    NETDEV_TIME_SYNCMODE_S  URLNETDEV_INVALID_CHANNEL_ID*/
    NETDEV_GET_AREA_PEOPLE_COUNT_RULE_INFO         = 532,        /*    NETDEV_AREA_PEOPLE_COUNT_RULE_INFO_S */
    NETDEV_SET_AREA_PEOPLE_COUNT_RULE_INFO         = 533,        /*    NETDEV_AREA_PEOPLE_COUNT_RULE_INFO_S */
    NETDEV_GET_LINE_PEOPLE_COUNT_RULE_INFO         = 534,        /*    NETDEV_LINE_PEOPLE_COUNT_RULE_INFO_S */
    NETDEV_SET_LINE_PEOPLE_COUNT_RULE_INFO         = 535,        /*    NETDEV_LINE_PEOPLE_COUNT_RULE_INFO_S */
    NETDEV_GET_LINE_PEOPLE_COUNT_RESET_INFO        = 536,        /*    NETDEV_LINE_PEOPLE_COUNT_RESET_INFO_S */
    NETDEV_SET_LINE_PEOPLE_COUNT_RESET_INFO        = 537,        /*    NETDEV_LINE_PEOPLE_COUNT_RESET_INFO_S */
    
    NETDEV_GET_CROWD_DENSITY_GROUPS_MINOR_LINKAGE_ACTIONS       = 538,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_CROWD_DENSITY_GROUP_MINOR_LINKAGE_ACTIONS        = 539,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_SET_CROWD_DENSITY_GROUP_MINOR_LINKAGE_ACTIONS        = 540,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_GET_CROWD_DENSITY_GROUPS_MAJOR_LINKAGE_ACTIONS       = 541,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_CROWD_DENSITY_GROUP_MAJOR_LINKAGE_ACTIONS        = 542,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_SET_CROWD_DENSITY_GROUP_MAJOR_LINKAGE_ACTIONS        = 543,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_GET_CROWD_DENSITY_GROUPS_CRITICAL_LINKAGE_ACTIONS    = 544,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_CROWD_DENSITY_GROUP_CRITICAL_LINKAGE_ACTIONS     = 545,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_SET_CROWD_DENSITY_GROUP_CRITICAL_LINKAGE_ACTIONS     = 546,  /*  #NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S */
    NETDEV_GET_BOX_DOME_LINKAGE_INFO                            = 547,  /*  # NETDEV_LINK_DOME_INFO_LIST_S */

    NETDEV_CFG_INVALID                             = 0xFFFF      /*   Invalid value */
}NETDEV_CONFIG_COMMAND_E;


/**
 * @enum tagNETDEVDateOSDFormateCap
 * @brief   OSD date format capabilities enumeration 
 * @attention  None
 */
typedef enum tagNETDEVDateOSDFormateCap
{
    NETDEV_OSD_DATE_FORMAT_CAP_MD_YYYY          = 0,        /* M/d/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_MMDD_YYYY        = 1,        /* MM/dd/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMM_YYYY        = 2,        /* dd/MM/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYY_MMDD        = 3,        /* yyyy/MM/dd */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYYMMDDB        = 4,        /* yyyy-MM-dd */
    NETDEV_OSD_DATE_FORMAT_CAP_XX_MMDD_YYYY     = 5,        /* dddd, MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_MMMMDD_YYYY      = 6,        /* MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMMMM_YYYY      = 7         /* dd MMMM, yyyy */
}NETDEV_OSD_DATE_FORMAT_CAP_E;

/**
 * @enum tagNETDEVTimeOSDFormateCap
 * @brief OSD OSD time format capabilities enumeration
 * @attention  None
 */
typedef enum tagNETDEVTimeOSDFormateCap
{
    NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS       = 0,                  /* HH:mm:ss */
    NETDEV_OSD_TIME_FORMAT_CAP_HH_MM_SS_PM  = 1                   /* hh:mm:ss tt */
}NETDEV_OSD_TIME_FORMAT_CAP_E;

/**
 * @enum tagNETDEVBooleanMode
 * @brief  Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVBooleanMode
{
    NETDEV_BOOLEAN_MODE_OPEN   = 1,                         /*   Always open */
    NETDEV_BOOLEAN_MODE_CLOSE  = 2,                         /*   Always closed */
    NETDEV_BOOLEAN_MODE_INVALID
}NETDEV_BOOLEAN_MODE_E;

/**
 * @enum tagNETDEVRelayOutPutState
 * @brief  Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVRelayOutPutState
{
    NETDEV_BOOLEAN_STATUS_ACTIVE    = 0,                /*   Triggered */
    NETDEV_BOOLEAN_STATUS_INACTIVE  = 1                 /*  Not triggered */
}NETDEV_RELAYOUTPUT_STATE_E;

/**
 * @enum tagNETDEVOutPutManualAlarmCmd
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOutPutManualAlarmCmd
{
    NETDEV_MANUAL_ALARM_CMD_CLOSE    = 0,                /*  close */
    NETDEV_MANUAL_ALARM_CMD_TRIGGER  = 1                 /*   Triggered */
}NETDEV_MANUAL_ALARM_CMD_E;

/**
 * @enum tagNETDEVMediaDataFormat
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVMediaDataFormat
{
    NETDEV_MEDIA_DATA_TS            = 0,            /* TS */
    NETDEV_MEDIA_DATA_RTP_ES        = 3             /* RTP + ES */
}NETDEV_MEDIA_DATA_FORMAT_E;

/**
 * @enum tagNETDEVProtocolType
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVProtocolType
{
    NETDEV_PROTOCOL_TYPE_HTTP  = 0,
    NETDEV_PROTOCOL_TYPE_HTTPS = 1,
    NETDEV_PROTOCOL_TYPE_RTSP  = 2
}NETDEV_PROTOCOL_TYPE_E;

/**
 * @enum tagNETDEVTimeZone
 * @brief  Time Zone
 * @attention  None
*/
typedef enum tagNETDEVTimeZone
{
    NETDEV_TIME_ZONE_W1200 = 0,              /* W12 */
    NETDEV_TIME_ZONE_W1100 = 1,              /* W11 */
    NETDEV_TIME_ZONE_W1000 = 2,              /* W10 */
    NETDEV_TIME_ZONE_W0900 = 3,              /* W9 */
    NETDEV_TIME_ZONE_W0800 = 4,              /* W8 */
    NETDEV_TIME_ZONE_W0700 = 5,              /* W7 */
    NETDEV_TIME_ZONE_W0600 = 6,              /* W6 */
    NETDEV_TIME_ZONE_W0500 = 7,              /* W5 */
    NETDEV_TIME_ZONE_W0430 = 8,              /* W4:30 */
    NETDEV_TIME_ZONE_W0400 = 9,              /* W4 */
    NETDEV_TIME_ZONE_W0330 = 10,             /* W3:30 */
    NETDEV_TIME_ZONE_W0300 = 11,             /* W3 */
    NETDEV_TIME_ZONE_W0200 = 12,             /* W2 */
    NETDEV_TIME_ZONE_W0100 = 13,             /* W1 */
    NETDEV_TIME_ZONE_0000  = 14,             /* W0 */
    NETDEV_TIME_ZONE_E0100 = 15,             /* E1 */
    NETDEV_TIME_ZONE_E0200 = 16,             /* E2 */
    NETDEV_TIME_ZONE_E0300 = 17,             /* E3 */
    NETDEV_TIME_ZONE_E0330 = 18,             /* E3:30 */
    NETDEV_TIME_ZONE_E0400 = 19,             /* E4 */
    NETDEV_TIME_ZONE_E0430 = 20,             /* E4:30 */
    NETDEV_TIME_ZONE_E0500 = 21,             /* E5 */
    NETDEV_TIME_ZONE_E0530 = 22,             /* E5:30 */
    NETDEV_TIME_ZONE_E0545 = 23,             /* E5:45 */
    NETDEV_TIME_ZONE_E0600 = 24,             /* E6 */
    NETDEV_TIME_ZONE_E0630 = 25,             /* E6:30 */
    NETDEV_TIME_ZONE_E0700 = 26,             /* E7 */
    NETDEV_TIME_ZONE_E0800 = 27,             /* E8 */
    NETDEV_TIME_ZONE_E0900 = 28,             /* E9 */
    NETDEV_TIME_ZONE_E0930 = 29,             /* E9:30 */
    NETDEV_TIME_ZONE_E1000 = 30,             /* E10 */
    NETDEV_TIME_ZONE_E1100 = 31,             /* E11 */
    NETDEV_TIME_ZONE_E1200 = 32,             /* E12 */
    NETDEV_TIME_ZONE_E1300 = 33,             /* E13 */
    NETDEV_TIME_ZONE_W0930 = 34,             /* W9:30 */
    NETDEV_TIME_ZONE_E0830 = 35,             /* E8:30 */
    NETDEV_TIME_ZONE_E0845 = 36,             /* E8:45 */
    NETDEV_TIME_ZONE_E1030 = 37,             /* E10:30 */
    NETDEV_TIME_ZONE_E1245 = 38,             /* E12:45 */
    NETDEV_TIME_ZONE_E1400 = 39,             /* E14 */

    NETDEV_TIME_ZONE_INVALID = 0xFF          /* Invalid value */
}NETDEV_TIME_ZONE_E;

/**
 * @enum tagNetDEVDayInWeek
 * @brief Week emnu
 * @attention 
*/
typedef enum tagNetDEVDayInWeek
{
    NETDEV_WEEK_SUNDAY                  = 0,                  /*   Sunday */
    NETDEV_WEEK_MONDAY                  = 1,                  /*   Monday */
    NETDEV_WEEK_TUESDAY                 = 2,                  /*   Tuesday */
    NETDEV_WEEK_WEDNESDAY               = 3,                  /*   Wednesday */
    NETDEV_WEEK_THURSDAY                = 4,                  /*   Thursday */
    NETDEV_WEEK_FRIDAY                  = 5,                  /*   Friday */
    NETDEV_WEEK_SATURDAY                = 6,                  /*   Saturday */
    NETDEV_WEEK_INVALID                 = 0xff                /*  Invalid value */
}NETDEV_DAY_IN_WEEK_E;

/**
 * @enum tagNetDEVDSTOffsetTime
 * @brief  DST offset time
 * @attention 
*/
typedef enum tagNetDEVDSTOffsetTime
{
    NETDEV_DST_OFFSET_TIME_30MIN                 = 30,          /* 30  30Minutes */
    NETDEV_DST_OFFSET_TIME_60MIN                 = 60,          /* 60  60Minutes */
    NETDEV_DST_OFFSET_TIME_90MIN                 = 90,          /* 90  90Minutes */
    NETDEV_DST_OFFSET_TIME_120MIN                = 120,         /* 120  120Minutes */
    NETDEV_DST_OFFSET_TIME_INVALID               = 0xff         /*  Invalid value */
}NETDEV_DST_OFFSET_TIME;

/**
 * @enum tagNETDEVDiskWorkStatus
 * @brief  Disk work status 
 * @attention  None
 */
typedef enum tagNETDEVDiskWorkStatus
{
    NETDEV_DISK_WORK_STATUS_EMPTY       = 0,            /*  Empty */
    NETDEV_DISK_WORK_STATUS_UNFORMAT    = 1,            /*  Unformat */
    NETDEV_DISK_WORK_STATUS_FORMATING   = 2,            /*  Formating */
    NETDEV_DISK_WORK_STATUS_RUNNING     = 3,            /*  Running */
    NETDEV_DISK_WORK_STATUS_HIBERNATE   = 4,            /*  Hibernate */
    NETDEV_DISK_WORK_STATUS_ABNORMAL    = 5,            /*  Abnormal */
    NETDEV_DISK_WORK_STATUS_UNKNOWN     = 6,            /*  Unknown */
    NETDEV_DISK_WORK_STATUS_INVALID                     /*  Invalid value */
}NETDEV_DISK_WORK_STATUS_E;

/**
* @enum tagNETDEVHDDType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVHDDType
{
    NETDEV_HDD_TYPE_LOCAL_HDD       = 0,            /* LocalHDD */
    NETDEV_HDD_TYPE_NO1_EXTEND_HDD  = 1,            /* No1ExtendCabinetHDD */
    NETDEV_HDD_TYPE_NO2_EXTEND_HDD  = 2,            /* No2ExtendCabinetHDD */
    NETDEV_HDD_TYPE_INVALID        = 0xFF           /* Invalid value */
}NETDEV_HDD_TYPE_E;

/**
* @enum tagNETDEVContainerType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVContainerType
{
    NETDEV_CONTAINER_TYPE_LOCAL_HDD       = 0,            /* LocalHDD */
    NETDEV_CONTAINER_TYPE_NO1_EXTEND_HDD  = 1,            /* No1ExtendCabinetHDD */
    NETDEV_CONTAINER_TYPE_NO2_EXTEND_HDD  = 2,            /* No2ExtendCabinetHDD */
    NETDEV_CONTAINER_TYPE_RAID            = 3,            /* RAID */
    NETDEV_CONTAINER_TYPE_NAS             = 4,            /* NAS */
    NETDEV_CONTAINER_TYPE_SAN             = 5,            /* SAN */
    NETDEV_CONTAINER_TYPE_eSATA           = 6,            /* eSATA */
    NETDEV_CONTAINER_TYPE_SD              = 7,            /* SD */
    NETDEV_CONTAINER_TYPE_INVALID         = 0xFF          /* Invalid value */
}NETDEV_CONTAINER_TYPE_E;

/**
* @enum tagNETDEVHDDWorkMode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVHDDWorkMode
{
    NETDEV_HDD_WORK_MODE_COMMON     = 0,        
    NETDEV_HDD_WORK_MODE_RAID       = 1,        
    NETDEV_HDD_WORK_MODE_HOT_BACKUP = 2,        
    NETDEV_HDD_WORK_MODE_INVALID    = 0xFF      /* Invalid value */
}NETDEV_HDD_WORK_MODE_E;

/**
* @enum tagNETDEVHDDStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVHDDStatus
{
    NETDEV_HDD_STATUS_NO        = 0,            
    NETDEV_HDD_STATUS_NORMAL    = 1,            
    NETDEV_HDD_STATUS_ABNORMAL  = 2,            
    NETDEV_HDD_STATUS_INVALID   = 0xFF          /* Invalid value */
}NETDEV_HDD_STATUS_E;

/**
* @enum tagNETDEVStorageContainerStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVStorageContainerStatus
{
    NETDEV_STORAGE_CONTAINER_STATUS_NO               = 0,            /* / */
    NETDEV_STORAGE_CONTAINER_STATUS_UNFORMATTED      = 1,            
    NETDEV_STORAGE_CONTAINER_STATUS_FORMATTING       = 2,            
    NETDEV_STORAGE_CONTAINER_STATUS_NORMAL           = 3,            
    NETDEV_STORAGE_CONTAINER_STATUS_SLEEP            = 4,            
    NETDEV_STORAGE_CONTAINER_STATUS_ABNORMAL         = 5,            
    NETDEV_STORAGE_CONTAINER_STATUS_SWITCH           = 6,            
    NETDEV_STORAGE_CONTAINER_STATUS_UNINSTALLED      = 7,            
    NETDEV_STORAGE_CONTAINER_STATUS_INVALID          = 0xFF          /* Invalid value */
}NETDEV_STORAGE_CONTAINER_STATUS_E;

/**
* @enum tagNETDEVStorageContainerProperty
* @brief 
* @attention  None
*/
typedef enum tagNETDEVStorageContainerProperty
{
    NETDEV_STORAGE_CONTAINER_PROPERTY_RW                = 0,            
    NETDEV_STORAGE_CONTAINER_PROPERTY_R                 = 1,            
    NETDEV_STORAGE_CONTAINER_PROPERTY_REDUNDANT         = 2,            
    NETDEV_STORAGE_CONTAINER_PROPERTY_INVALID           = 0xFF          /* Invalid value */
}NETDEV_STORAGE_CONTAINER_PROPERTY_E;

/**
* @enum tagNETDEVStorageContainerUsageType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVStorageContainerUsageType
{
    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_RECORD_CAPTURE   = 0,        /* / */
    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_BACKUP           = 1,        
    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_INVALID          = 0xFF      /* Invalid value */
}NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E;

/**
* @enum tagNETDEVHDDSmartCheckType
* @brief Smart
* @attention  None
*/
typedef enum tagNETDEVHDDSmartCheckType
{
    NETDEV_HDD_SMART_CHECK_TYPE_BRIEF          = 0,        
    NETDEV_HDD_SMART_CHECK_TYPE_EXTEND         = 1,        
    NETDEV_HDD_SMART_CHECK_TYPE_TRANSMISSION   = 2,        
    NETDEV_HDD_SMART_CHECK_TYPE_INVALID        = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_CHECK_TYPE_E;

/**
* @enum tagNETDEVPhotoServerProType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPhotoServerProType
{
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO1          = 0,        /* TCP: V1 */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO2          = 1,        /* TCP: V2tms */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO3          = 2,        /* TCP:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO4          = 3,        /* FTP:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO5          = 4,        /* FTP: FTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO6          = 5,        /* FTP:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO7          = 6,        /* webserver:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO8          = 7,        /* FTP:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO9          = 8,        /* FTP: 2 */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO10         = 9,        /* webserver FTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO11         = 10,       /* TCP: */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO12         = 11,       /* TCP FTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO31         = 12,       /* TCP: V2tms */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO34         = 13,       /* HTTP:  */
    NETDEV_PHOTO_SERVER_PRO_TYPE_INVALID       = 0xFF     /* Invalid value */
}NETDEV_PHOTO_SERVER_PRO_TYPE_E;

/**
* @enum tagNETDEVPhotoServerSubProtocolType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPhotoServerSubProType
{
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2011          = 0,        /* 2011 */
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2025          = 1,        /* 2025 */
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_6130          = 2,        /* 6130 */
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_INVALID       = 0xFF      /* Invalid value */
}NETDEV_PHOTO_SERVER_SUBPRO_TYPE_E;

/**
* @enum tagNETDEVHDDHealthAssessmentStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVHDDHealthAssessmentStatus
{
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_NORMAL           = 0,        
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_PART_DAMAGE      = 1,        
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_FAULT            = 2,        
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_INVALID          = 0xFF      /* Invalid value */
}NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E;

/**
* @enum tagNETDEVHDDSmartAssessmentStatus
* @brief Smart
* @attention  None
*/
typedef enum tagNETDEVHDDSmartAssessmentStatus
{
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_NORMAL       = 0,        
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_WARNING      = 1,        
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_FAULT        = 2,        
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_INVALID      = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_ASSESSMENT_STATUS_E;

/**
* @enum tagNETDEVHDDSmartCheckStatus
* @brief Smart
* @attention  None
*/
typedef enum tagNETDEVHDDSmartCheckStatus
{
    NETDEV_HDD_SMART_CHECK_STATUS_NOT                = 0,        
    NETDEV_HDD_SMART_CHECK_STATUS_IN_PORGRESS        = 1,        
    NETDEV_HDD_SMART_CHECK_STATUS_SUCCESS            = 2,        
    NETDEV_HDD_SMART_CHECK_STATUS_RECOGNITION_FAIL   = 3,        
    NETDEV_HDD_SMART_CHECK_STATUS_FAIL               = 4,        /* SMART */
    NETDEV_HDD_SMART_CHECK_STATUS_NOT_SUPPORT        = 5,        
    NETDEV_HDD_SMART_CHECK_STATUS_INVALID            = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_CHECK_STATUS_E;

/**
 * @enum tagNetDEVPictureFluency
 * @brief  Picture fluency
 * @attention 
*/
typedef enum tagNetDEVPictureFluency
{
    NETDEV_PICTURE_REAL                 = 0,                /*  Real-time first */
    NETDEV_PICTURE_FLUENCY              = 1,                /*  Fluency first */
    NETDEV_PICTURE_BALANCE_NEW          = 3,                /*  Balance */
    NETDEV_PICTURE_RTMP_FLUENCY         = 4,                /* RTMP RTMP fluency first */
    NETDEV_PICTURE_USER_DEFINED         = 5,                /* - */
    NETDEV_PICTURE_NETADJUST            = 6,                

    NETDEV_PICTURE_FLUENCY_INVALID      = 0xff              /*  Invalid value */
}NETDEV_PICTURE_FLUENCY_E;

/**
 * @enum tagNETDEVPtzHomePositionCmd
 * @brief   PTZ home position operation commands Enumeration Definition
 * @attention  None
*/
typedef enum tagNETDEVPtzHomePositionCmd
{
    NETDEV_PTZ_SET_HOMEPOSITION   = 0,            /*   Set home position */
    NETDEV_PTZ_GOTO_HOMEPOSITION  = 1             /*   Go to home position */
}NETDEV_PTZ_HOMEPOSITIONCMD_E;

/**
 * @enum tagNETDEVPTZMoveStatus
 * @brief  PTZ Move status
 * @attention  None
*/
typedef enum tagNETDEVPTZMoveStatus
{
    NETDEV_PTZ_MOVE_STATUS_IDLE     = 0,             /*  Free */
    NETDEV_PTZ_MOVE_STATUS_MOVING   = 1,             /*  Moving */
    NETDEV_PTZ_MOVE_STATUS_INVALID  = 0xff           /*  Invalid value */
}NETDEV_PTZ_MOVE_STATUS_E;

/**
 * @enum tagNETDEVIrCutFilterMode
 * @brief  IRCut filter mode
 * @attention  None
 */
typedef enum  tagNETDEVIrCutFilterMode
{
    NETDEV_IR_CUT_FILTER_ON     = 0,            /*  On */
    NETDEV_IR_CUT_FILTER_OFF    = 1,            /*  Off */
    NETDEV_IR_CUT_FILTER_AUTO   = 2             /*  Auto */
}NETDEV_IR_CUT_FILTER_MODE_E;

/**
 * @enum tagNETDEVDefoggingMode
 * @brief  Defogging mode
 * @attention  None
 */
typedef enum  tagNETDEVDefoggingMode
{
    NETDEV_DEFOGGING_ON = 0,            /*  On */
    NETDEV_DEFOGGING_OFF= 1             /*  Off */
}NETDEV_DEFOGGING_MODE_E;

/**
 * @enum tagNETDEVFocusMode
 * @brief  Focus mode
 * @attention  None
 */
typedef enum tagNETDEVFocusMode
{
    NETDEV_FOCUS_AUTO           = 1,            /*  Auto */
    NETDEV_FOCUS_MANUAL         = 2             /*  Manual */
}NETDEV_FOCUS_MODE_E;

/**
 * @enum tagNETDEVFocusNearlimit
 * @brief  Focus near limit
 * @attention  None
 */
typedef enum tagNETDEVFocusNearlimit
{
    NETDEV_FOCUS_NEARLIMIT_10       = 1,            /* 10cm */
    NETDEV_FOCUS_NEARLIMIT_100      = 2,            /* 100cm */
    NETDEV_FOCUS_NEARLIMIT_300      = 3,            /* 300cm */
    NETDEV_FOCUS_NEARLIMIT_1000     = 4,            /* 1000cm */
    NETDEV_FOCUS_NEARLIMI_INVALID   = 0xff          /*   Invalid value */
}NETDEV_FOCUS_NEARLIMIT_E;

/**
 * @enum tagNETDEVRecordType
 * @brief  Record Type
 * @attention 
*/
typedef enum tagNETDEVRecordType
{
    NETDEV_RECORD_TYPE_MANUAL  = 0,
    NETDEV_RECORD_TYPE_NORMAL  = 1
}NETDEV_RECORD_TYPE_E;

/**
 * @enum tagNETDEVVideoPosition
 * @brief  Video Position
 * @attention  None
 */
typedef enum tagNETDEVVideoPosition
{
    NETDEV_POSITION_LOCAL       = 1,            
    NETDEV_POSITION_CHANNEL     = 2,            
    NETDEV_POSITION_INVALID
}NETDEV_VIDEO_POSITION_E;

/**
 * @enum tagNETDEVVideoStatus
 * @brief  Video Status
 * @attention  None
 */
typedef enum tagNETDEVVideoStatus
{
    NETDEV_VIDEO_NONE       = 0,        /*  No video */
    NETDEV_VIDEO_EVENT      = 1,        /*  Event video */
    NETDEV_VIDEO_NORMAL     = 2,        /*  Normal video */
    NETDEV_VIDEO_INVALID
}NETDEV_VIDEO_STATUS_E;

/**
 * @enum tagNETDEVCapabilityCommond
 * @brief  Device capability commond
 * @attention 
*/
typedef enum tagNETDEVCapabilityCommond
{
    NETDEV_CAP_VIDEO_ENCODE         = 1,            /*  # NETDEV_VIDEO_STREAM_CAP_S Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_S for reference*/
    NETDEV_CAP_OSD                  = 2,            /* OSD # NETDEV_OSD_CAP_S OSD parameter capability. See # NETDEV_OSD_CAP_S for reference*/
    NETDEV_CAP_SMART                = 3,            /*  # NETDEV_SMART_CAP_S Smart capability. See # NETDEV_SMART_CAP_S for reference */
    NETDEV_CAP_VIDEO_ENCODE_EX      = 4,            /*  # NETDEV_VIDEO_STREAM_CAP_EX_S Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_EX_S for reference */
    NETDEV_CAP_IMAGE                = 5,            /*  #NETDEV_IMAGE_CAP_S Image capability See # NETDEV_IMAGE_CAP_S for reference*/
    NETDEV_CAP_AUDIO                = 6,            /*   NETDEV_AUDIO_CAP_S */
    NETDEV_CAP_VIDEO_SNAPSHOT       = 7,            /*  #NETDEV_VIDEO_SNAP_CAP_S Video snapshot capability. See # NETDEV_VIDEO_SNAP_CAP_S for reference   IPC*/
    NETDEV_CAP_FACE_RECOGNAZE       = 10,           /*  NVR, NETDEV_DEV_FACE_CAP_INFO_S */
    NETDEV_CAP_DEV_NIC              = 11,           /* , NETDEV_NIC_CAP_INFO_S */
    NETDEV_CAP_DEV_EXCEPTION_ALARM  = 12,           /* , # NETDEV_EXCP_ALARM_CAP_INFO_S */
    NETDEV_CAP_CHANNELS_ALARM       = 13,           /* ,  NETDEV_CHN_ALARM_CAP_INFO_S IPCSDK1IPCSDK1+IPCNVR */
    NETDEV_CAP_SYS                  = 14,           /*   NETDEV_SYS_CAPABILITY_S  */
    NETDEV_CAP_INVALID              = 0Xff
}NETDEV_CAPABILITY_COMMOND_E;

/**
 * @enum tagNETDEVVideoEncodeType
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVVideoEncodeType
{
    NETDEV_VIDEO_ENCODE_H264    = 1,
    NETDEV_VIDEO_ENCODE_MPEG4   = 2,
    NETDEV_VIDEO_ENCODE_JPEG    = 3,
    NETDEV_VIDEO_ENCODE_INVALID = 0XFF
}NETDEV_ENCODE_TYPE_E;

/**
 * @enum tagNETDEVTrafficStatisticsType
 * @brief  
 * @attention  None
*/
typedef enum tagNETDEVTrafficStatisticsType
{
    NETDEV_TRAFFIC_STATISTICS_TYPE_IN   = 0,        /*  Statistics type : Enter */
    NETDEV_TRAFFIC_STATISTICS_TYPE_OUT  = 1,        /*  Statistics type : Exit */
    NETDEV_TRAFFIC_STATISTICS_TYPE_ALL  = 2,        /*  Statistics type : All */
    NETDEV_TRAFFIC_STATISTICS_TYPE_BUTT
}NETDEV_TRAFFIC_STATISTICS_TYPE_E;

/**
 * @enum tagNETDEVFormType
 * @brief  
 * @attention  None
*/
typedef enum tagNETDEVFormType
{
    NETDEV_FORM_TYPE_DAY    = 0,            /*  Form type : Day */
    NETDEV_FORM_TYPE_WEEK   = 1,            /*  Form type : Week */
    NETDEV_FORM_TYPE_MONTH  = 2,            /*  Form type : Month */
    NETDEV_FORM_TYPE_YEAR   = 3,            /*  Form type : Year */
    NETDEV_FORM_TYPE_BUTT
}NETDEV_FORM_TYPE_E;

/**
 * @enum tagNETDEVAddrType
 * @brief  
 * @attention  None
*/
typedef enum tagNETDEVAddrType
{
    NETDEV_ADDR_TYPE_IPV4       = 0,             /* IPV4 */
    NETDEV_ADDR_TYPE_IPV6       = 1,             /* IPV6 */
    NETDEV_ADDR_TYPE_DOMAIN     = 2,             
    NETDEV_ADDR_TYPE_IPV4_IPV6  = 3,             /* IPV4IPV6 */
    NETDEV_ADDR_TYPE_INVALID    = 0XFFFF         
}NETDEV_ADDR_TYPE_E;

/**
 * @enum tagNETDEVSmartEncodeMode
 * @brief   Enumeration of smart image encoding mode
 * @attention  None
*/
typedef enum tagNETDEVSmartEncodeMode
{
    NETDEV_SMART_ENCODE_MODE_OFF      = 0,      /*  Off*/
    NETDEV_SMART_ENCODE_MODE_BASIC    = 1,      /*  Basic mode*/
    NETDEV_SMART_ENCODE_MODE_ADVANCED = 2       /*  Advanced mode*/
}NETDEV_SMART_ENCODE_MODE_E;

/**
 * @enum tagNETDEVBitRateType
 * @brief   Enumeration of bit rate mode
 * @attention  None
*/
typedef enum tagNETDEVBitRateType
{
    NETDEV_BIT_RATE_TYPE_CBR      = 0,         /* CBR CBR mode*/
    NETDEV_BIT_RATE_TYPE_VBR      = 1          /* VBR VBR mode*/
}NETDEV_BIT_RATE_TYPE_E;

/**
 * @enum tagNETDEVMainStreamType
 * @brief   Enumeration of main stream type
 * @attention  None
*/
typedef enum tagNETDEVMainStreamType
{
    NETDEV_MAIN_STREAM_TYPE_TIME     = 0,      /*  Scheduled main stream*/
    NETDEV_MAIN_STREAM_TYPE_EVENT    = 1       /*  Event main stream*/
}NETDEV_MAIN_STREAM_TYPE_E;

/**
 * @enum tagNETDEVGopType
 * @brief GOP  Enumeration of GOP type
 * @attention  None
*/
typedef enum tagNETDEVGopType
{
    NETDEV_GOP_TYPE_IP       = 0,      /* IP */
    NETDEV_GOP_TYPE_IBP      = 1,      /* IBP */
    NETDEV_GOP_TYPE_IBBP     = 2,      /* IBBP */
    NETDEV_GOP_TYPE_I        = 3       /* I */
}NETDEV_GOP_TYPE_E;

/**
 * @enum tagNETDEVOSDContentType
 * @brief OSD  Enumeration of content type
 * @attention  None
*/
typedef enum tagNETDEVOSDContentType
{
    NETDEV_OSD_CONTENT_TYPE_NOTUSE                      = 0,                    /*  Not used*/
    NETDEV_OSD_CONTENT_TYPE_CUSTOM                      = 1,                    /*  Custom*/
    NETDEV_OSD_CONTENT_TYPE_DATE_AND_TIME               = 2,                    /*  Time and date*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_CONTROLLER              = 3,                    /*  PTZ controller*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_COORDINATES             = 4,                    /*  PTZ Coordinates*/
    NETDEV_OSD_CONTENT_TYPE_CRUISE                      = 5,                    /*  Patrol*/
    NETDEV_OSD_CONTENT_TYPE_ZOOM                        = 6,                    /*  Zoom*/
    NETDEV_OSD_CONTENT_TYPE_PRESET                      = 7,                    /*   Preset*/
    NETDEV_OSD_CONTENT_TYPE_ALARM_INFO                  = 8,                    /*  Alarm */
    NETDEV_OSD_CONTENT_TYPE_ENCODE                      = 9,                    /*  Encoding*/
    NETDEV_OSD_CONTENT_TYPE_SERIAL_PORT                 = 10,                   /* OSD Serial Port OSD*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_ORIENTATION             = 11,                   /*  PZT direction*/
    NETDEV_OSD_CONTENT_TYPE_CHN_NAME                    = 12,                   /*  Channel name*/
    NETDEV_OSD_CONTENT_TYPE_DEBUG                       = 13,                   /* OSD  Debug OSD*/
    NETDEV_OSD_CONTENT_TYPE_PEOPLE_COUNTING             = 14,                   /* OSD People counting OSD*/
    NETDEV_OSD_CONTENT_TYPE_NETWORK_PORT                = 15,                   /* OSD Network Port OSD*/
    NETDEV_OSD_CONTENT_TYPE_TIME                        = 16,                   /*  Time*/
    NETDEV_OSD_CONTENT_TYPE_DATE                        = 17,                   /*  Date*/
    NETDEV_OSD_CONTENT_TYPE_SMART_CONTENT               = 18,                   /* OSD Sensing OSD*/
    NETDEV_OSD_CONTENT_TYPE_BATTERY                     = 19,                   /* OSD Battery OSD*/
    NETDEV_OSD_CONTENT_TYPE_SCROLL_OSD                  = 20,                   /* OSD Scroll text OSD*/
    NETDEV_OSD_CONTENT_TYPE_PICTURE_OVERLAY             = 21,                   /* LOGO OSD */
    NETDEV_OSD_CONTENT_TYPE_MOTOR_VEHICLE_NUM           = 22,                   /*  Vehicle flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_NON_MOTOR_VEHICLE_NUM       = 23,                   /*  Non-vehicle flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_PEOPLE_NUM                  = 24,                   /*  Pedestrian flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_INFOOSD_NUM                 = 25                    /* INFOOSD Number of INFOOSDtype*/
}NETDEV_OSD_CONTENT_TYPE_E;

/**
 * @enum tagNETDEVDateOSDFormate
 * @brief   Enumeration of date format
 * @attention  None
 */
typedef enum tagNETDEVDateOSDFormate
{
    NETDEV_OSD_DATE_FORMAT_YYYY_MMDD                = 0,           /* yyyy-MM-dd */
    NETDEV_OSD_DATE_FORMAT_MMDD_YYYY                = 1,           /* MM-dd-yyyy */
    NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD        = 2,           /* yyyyMMdd yyyy/MM/dd*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY        = 3,           /* MMddyyyy MM/dd/yyyy*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X       = 4,           /*  yyyyMMdd X dddd yyyy MM dd*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X      = 5,           /* MMddyyyy X dddd MM dd yyyy*/
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY        = 100,         /* dd/MM/yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY        = 101,         /* MM/dd/yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY      = 102,         /* dd MMMM, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY      = 103,         /* MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY  = 104,         /* dddd, dd MMMM, yyyy  */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY= 105,         /* dddd, MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD        = 106,         /*  yyyy/MM/dd */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD      = 107,         /*  yyyy, MMMM dd */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD      = 108          /*  dddd, yy, MM dd */
}NETDEV_OSD_DATE_FORMAT_E;

/**
 * @enum tagNETDEVTimeOSDFormate
 * @brief OSD Enumeration of OSD time format
 * @attention  None
 */
typedef enum tagNETDEVTimeOSDFormate
{
    NETDEV_OSD_TIME_FORMAT_HHMMSS         = 0,                  /* HH:mm:ss */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T     = 1,                  /* hh:mm:ss t.t. */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT    = 2,                  /* hh:mm:ss tt */
    NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS    = 3,                  /*  tt hh:mm:ss */
    NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS    = 4,                  /*  hh:mm:ss  P.M. hh:mm:ss*/
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX    = 5,                  /* HH:mm:ss.xxx */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT = 6                   /* hh:mm:ss.xxx tt */
}NETDEV_OSD_TIME_FORMAT_E;

/**
 * @enum tagNETDEVOSDFontStyle
 * @brief OSD Enumeration of OSD font style
 * @attention  None
 */
typedef enum tagNETDEVOSDFontStyle
{
    NETDEV_OSD_FONT_STYLE_BACKGROUND    = 0,                  /*  Background*/
    NETDEV_OSD_FONT_STYLE_STROKE        = 1,                  /*  Stroke*/
    NETDEV_OSD_FONT_STYLE_HOLLOW        = 2,                  /*  Hollow*/
    NETDEV_OSD_FONT_STYLE_NORMAL        = 3                   /*  Normal*/
}NETDEV_OSD_FONT_STYLE_E;

/**
 * @enum tagNETDEVOSDFontSize
 * @brief OSD Enumeration of OSD font size
 * @attention  None
 */
typedef enum tagNETDEVOSDFontSize
{
    NETDEV_OSD_FONT_SIZE_LARGE      = 0,                  /*  X-large*/
    NETDEV_OSD_FONT_SIZE_BIG        = 1,                  /*  Large*/
    NETDEV_OSD_FONT_SIZE_MEDIUM     = 2,                  /*  Medium*/
    NETDEV_OSD_FONT_SIZE_SMALL      = 3                   /*  Small*/
}NETDEV_OSD_FONT_SIZE_E;

/**
 * @enum tagNETDEVOSDMinMargin
 * @brief OSD Enumeration of OSD font size
 * @attention  None
 */
typedef enum tagNETDEVOSDMinMargin
{
    NETDEV_OSD_MIN_MARGIN_NONE    = 0,               /*  None*/
    NETDEV_OSD_MIN_MARGIN_SINGLE  = 1,               /*  One char width*/
    NETDEV_OSD_MIN_MARGIN_DOUBLE  = 2                /*  Two char width*/
}NETDEV_OSD_MIN_MARGIN_E;

/**
 * @enum tagNETDEVOSDAlign
 * @brief OSD Enumeration of OSD align
 * @attention  None
 */
typedef enum tagNETDEVOSDAlign
{
    NETDEV_OSD_ALIGN_LEFT       = 0,               /*  Left*/
    NETDEV_OSD_ALIGN_RIGHT      = 1                /*  Right*/
}NETDEV_OSD_ALIGN_E;

/**
 * @enum tagNETDEVPullStreamMode
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVPullStreamMode
{
    NETDEV_STREAM_MODE_SERVER_DISTRIBUTE    = 0,   
    NETDEV_STREAM_MODE_FORCE_CDN            = 1    
}NETDEV_PULL_STREAM_MODE_E;

/**
 * @enum tagNETDEVDistributeMode
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVDistributeMode
{
    NETDEV_DISTRIBUTE_MODE_AUTO       = 0,            
    NETDEV_DISTRIBUTE_MODE_FORCE      = 1             
}NETDEV_DISTRIBUTE_MODE_E;

/**
 * @enum tagNETDEVListenType
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVListenType
{
    NETDEV_FACE_SNAPSHOT_TYPE       = 1,    
    NETDEV_DISCOVERY_TYPE           = 2,    
    NETDEV_LISTEN_TYPE_INVALID      = 0xffff
}NETDEV_LISTEN_TYPE_E;

/**
 * @enum tagNETDEVLoginType
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVLoginType
{
    NETDEV_LOGIN_TYPE_LOCAL             = 0,          
    NETDEV_LOGIN_TYPE_DYNAMIC           = 1,          
    NETDEV_LOGIN_TYPE_LOCAL_ALL         = 2,          
    NETDEV_LOGIN_TYPE_CLOUD_DEVICE      = 3,          
    NETDEV_LOGIN_TYPE_CLOUD_DEVICE_SN   = 4           /* SN */
}NETDEV_LOGIN_TYPE_E;

/**
 * @enum tagNETDEVLoginProto
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVLoginProto
{
    NETDEV_LOGIN_PROTO_ONVIF             = 0,           /* ONVIF */
    NETDEV_LOGIN_PROTO_PRIVATE           = 1            
}NETDEV_LOGIN_PROTO_E;

/**
 * @enum tagNETDEVAlarmProtocol
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVAlarmProtocol
{
    NETDEV_ALARM_PROTOCOL_ONVIF   = 0X01,                   /* ONVIF */
    NETDEV_ALARM_PROTOCOL_PRIVATE = 0X02,                   /* private */
    NETDEV_ALARM_PROTOCOL_INVALID = 0XFF                    
}NETDEV_ALARM_PROTOCOL_E;

/**
 * @enum tagNETDEVSubscribeAlarmType
 * @brief BIT 
 * @attention  None
 */
typedef enum tagNETDEVSubscribeAlarmType
{
    NETDEV_SUBSCRIBE_ALARM_TYPE_COM             = 0X01,     
    NETDEV_SUBSCRIBE_ALARM_TYPE_SMART           = 0X02,     
    NETDEV_SUBSCRIBE_ALARM_TYPE_INTELLIGENTIPC  = 0X04      /* IPC */
}NETDEV_SUBSCRIBE_ALARM_TYPE_E;

/**
 * @enum tagNETDEVAlarmTypeV30
 * @brief V30
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeV30
{
    NETDEV_ALARM_RYPE_DEV_STATUS                            = BIT0,         
    NETDEV_ALARM_RYPE_COMM_ALARM                            = BIT1,         
    NETDEV_ALARM_RYPE_INTEL_ALARM                           = BIT2,         
    NETDEV_ALARM_RYPE_SMART_ALARM                           = BIT3,         
    NETDEV_ALARM_RYPE_FACE_RECOGNITION                      = BIT4,         /*  NETDEV_SetPersonAlarmCallBack */
    NETDEV_ALARM_RYPE_STRUCTURED_DATA                       = BIT5,         /*  NETDEV_SetStructAlarmCallBack */
    NETDEV_ALARM_RYPE_VEHICLE_RECOGNITION                   = BIT6,         /*  NETDEV_SetVehicleAlarmCallBack */
    NETDEV_ALARM_RYPE_TRAFFIC_DATA                          = BIT7,         
    NETDEV_ALARM_RYPE_HYPERSENSITIVE_DATA                   = BIT8,         
    NETDEV_ALARM_RYPE_RESOURCE_CHANGE                       = BIT9,         /*  NETDEV_SetResChangeEventCallBack */
    NETDEV_ALARM_RYPE_PERSON_VERIFICATION                   = BIT10,        /*  NETDEV_SetAlarmFGCallBack */
    NETDEV_ALARM_RYPE_PARKING_IDENTIFICATION                = BIT11,        /*  NETDEV_SetParkEventCallBack */
    NETDEV_ALARM_RYPE_FIREALARM_DATA                        = BIT12,        /*  NETDEV_SetConflagrationAlarmCallBack */
    NETDEV_ALARM_RYPE_ALARM_PICTURE_DATA                    = BIT13,        /*  NETDEV_SetPicAlarmCallBack */
    NETDEV_ALARM_RYPE_PEOPLE_COUNT                          = BIT14,        /*  NETDEV_SetPeopleCountAlarmCallBack */
    NETDEV_ALARM_RYPE_HEATMAP_DATA                          = BIT16,        
    NETDEV_ALARM_RYPE_PLAYBOX_STATUS                        = BIT17,        
    NETDEV_ALARM_RYPE_PLAYBOX_MANAGEMENT                    = BIT18,        /* ()... */
    NETDEV_ALARM_RYPE_INVALID                               = 0xFF
}NETDEV_ALARM_TYPE_V30_E;

/**
 * @enum tagNETDEVCtrlType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVCtrlType
{
    NETDEV_CTRL_TYPE_PAUSE  = 0,                                      
    NETDEV_CTRL_TYPE_RESUME = 1,                                      
    NETDEV_CTRL_TYPE_DRAG   = 2,                                      
    NETDEV_CTRL_TYPE_SPEED  = 3,                                      
    NETDEV_CTRL_TYPE_INVALID
}NETDEV_XW_CTRL_TYPE_E;

/**
 * @enum tagNETDEVLEDType
 * @brief LED
 * @attention  None
 */
typedef enum tagNETDEVLEDType
{
    NETDEV_LED_TYPE_STRING = 0,                                   
    NETDEV_LED_TYPE_TIME   = 1                                     
}NETDEV_XW_LED_TYPE_E;

/**
 * @enum tagNETDEVLEDFontFormat
 * @brief LED
 * @attention  None
 */
typedef enum tagNETDEVLEDFontFormat
{
    NETDEV_LED_FONT_SONG                    = 0,                            
    NETDEV_LED_FONT_FORMAT_SIMHEI           = 1,                            
    NETDEV_LED_FONT_FORMAT_KAITI            = 2,                            
    NETDEV_LED_FONT_FORMAT_Arial            = 3,                            /* Arial */
    NETDEV_LED_FONT_FORMAT_FANGSONG         = 4,                            
    NETDEV_LED_FONT_FORMAT_LISHU            = 5,                            
    NETDEV_LED_FONT_FORMAT_YOUYUAN          = 6                             
}NETDEV_XW_LED_FONT_FORMAT_E;

/**
 * @enum tagNETDEVXWLEDFontSize
 * @brief LED
 * @attention  None
 */
typedef enum tagNETDEVXWLEDFontSize
{
    NETDEV_LED_FONT_SIZE_48X48      = 0,                            /* 48X48 */
    NETDEV_LED_FONT_SIZE_64X64      = 1,                            /* 64X64 */
    NETDEV_LED_FONT_SIZE_96X96      = 2,                            /* 96X96 */
    NETDEV_LED_FONT_SIZE_128X128    = 3,                            /* 128X128 */
    NETDEV_LED_FONT_SIZE_192X192    = 4,                            /* 192X192 */
    NETDEV_LED_FONT_SIZE_256X256    = 5,                            /* 256X256 */
    NETDEV_LED_FONT_SIZE_512X512    = 6,                            /* 512X512 */
    NETDEV_FONT_SIZE_SELF_ADAPTION  = 7                             
}NETDEV_XW_LED_FONT_SIZE_E;

/**
 * @enum tagNETDEVXWLEDFontGap
 * @brief LED 2
 * @attention  None
 */
typedef enum tagNETDEVXWLEDFontGap
{
    NETDEV_LED_FONT_GAP_NORMAL         = 0,         
    NETDEV_LED_FONT_GAP_ONE            = 1,         /* 2/4 */
    NETDEV_LED_FONT_GAP_TWO            = 2,         /* 4/4 */
    NETDEV_LED_FONT_GAP_THREE          = 3,         /* 6/4 */
    NETDEV_LED_FONT_GAP_FOUR           = 4,         /* 8/4 */
    NETDEV_LED_FONT_GAP_FIVE           = 5,         /* 1/4 */
    NETDEV_LED_FONT_GAP_SIX            = 6,         /* 3/4 */
    NETDEV_LED_FONT_GAP_SEVEN          = 7,         /* 5/4 */
    NETDEV_LED_FONT_GAP_EIGHT          = 8,         /* 7/4 */
    NETDEV_LED_FONT_GAP_NINE           = 9,         /* 10/4 */
    NETDEV_LED_FONT_GAP_INVALID        = 0xFF       /* ()  Invalid value */
}NETDEV_XW_LED_FONT_GAP_E;

/**
 * @enum tagNETDEVLEDScrollingMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVLEDScrollingMode
{
    NETDEV_LED_SCROLL_STATIC            = 0,        
    NETDEV_LED_SCROLL_RIGHT_TO_LEFT     = 1,        
    NETDEV_LED_SCROLL_LEFT_TO_RIGHT     = 2,        
    NETDEV_LED_SCROLL_BOTTOM_TO_TOP     = 3,        
    NETDEV_LED_SCROLL_TOP_TO_BOTTOM     = 4,        
    NETDEV_LED_SCROLL_TWINKLE           = 5,        /*  (IPC) */
    NETDEV_LED_SCROLL_SCAN_UP_DOWN      = 6         /*  (IPC)*/
}NETDEV_XW_LED_SCROLLING_MODE_E;

/**
 * @enum tagNETDEVVerticalAlignMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVerticalAlignMode
{
    NETDEV_VERTICAL_ALIGN_TOP           = 0,        
    NETDEV_VERTICAL_ALIGN_MIDDLE        = 1,        
    NETDEV_VERTICAL_ALIGN_BOTTOM        = 2         
}NETDEV_XW_VERTICAL_ALIGN_MODE_E;

/**
 * @enum tagNETDEVHorizontalAlignMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVHorizontalAlignMode
{
    NETDEV_HORIZONTAL_ALIGN_LEFT        = 0,        
    NETDEV_HORIZONTAL_ALIGN_MIDDLE      = 1,        
    NETDEV_HORIZONTAL_ALIGN_RIGHT       = 2         
}NETDEV_XW_HORIZONTAL_ALIGN_MODE_E;

/**
 * @enum tagNETDEVContentPosition
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVContentPosition
{
    NETDEV_XW_CONTENT_POSITION_TOP           = 0,        
    NETDEV_XW_CONTENT_POSITION_MIDDLE        = 1,        
    NETDEV_XW_CONTENT_POSITION_BOTTOM        = 2         
}NETDEV_XW_CONTENT_POSITION_E;

/**
 * @enum tagNETDEVLedCmd
 * @brief LED
 * @attention  None
 */
typedef enum tagNETDEVLedCmd
{
    NETDEV_LED_ENABLE               = 0x0001,                   
    NETDEV_LED_TYPE                 = 0x0002,                   /* LED  */
    NETDEV_LED_AREA                 = 0x0004,                   /* LED */
    NETDEV_LED_BACKGROUND           = 0x0008,                   
    NETDEV_LED_FONTINFO             = 0x0010,                   
    NETDEV_LED_TEXT                 = 0x0020,                   
    NETDEV_LED_CLOCK                = 0x0030,                   
    NETDEV_LED_ALL                  = 0x00FF                    
} NETDEV_XW_LED_CMD_E;

/**
 * @enum tagNETDEVBaseType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVBaseType
{
    NETDEV_BASE_TYPE_JPEG = 1                                    /* JPEG */
}NETDEV_XW_BASE_TYPE_E;

/**
 * @enum tagNETDEVTransportProtocol
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVTransportProtocol
{
    NETDEV_TRANSPORT_PROTOCOL_UDP = 0,             /* UDP */
    NETDEV_TRANSPORT_PROTOCOL_TCP = 1,             /* TCP */
    NETDEV_TRANSPORT_PROTOCOL_RTSP= 2,             /* RTSP */
    NETDEV_TRANSPORT_PROTOCOL_HTTP= 3              /* HTTP */
}NETDEV_TRANSPORT_PROTOCOL_E;

/**
 * @enum tagNETDEVXWSequenceResStatus
 * @brief  
 * @attention  None
*/
typedef enum tagNETDEVXWSequenceResStatus
{
    NETDEV_XW_SEQUENCE_RES_STATUS_RUNNING   = 0,            
    NETDEV_XW_SEQUENCE_RES_STATUS_PAUSE     = 1,            
    NETDEV_XW_SEQUENCE_RES_STATUS_STOP      = 2,            
    NETDEV_XW_SEQUENCE_RES_STATUS_INVALID = 0xFF           
}NETDEV_XW_SEQUENCE_RES_STATUS_E;

/**
 * @enum tagNETDEVTMSPersionImageType
 * @brief 
 * @attention  None
 */
typedef enum  tagNETDEVTMSPersionImageType
{
    NETDEV_TMS_PERSION_IMAGE_TYPE_FULL_VIEW = 1,         
    NETDEV_TMS_PERSION_IMAGE_TYPE_FACE      = 2,         
    NETDEV_TMS_PERSION_IMAGE_TYPE_INVALID   = 0xFF       
}NETDEV_TMS_PERSION_IMAGE_TYPE_E;

/**
 * @enum tagNETDEVTMSPersionImageFormatType
 * @brief 
 * @attention  None
 */
typedef enum  tagNETDEVTMSPersionImageFormatType
{
    NETDEV_TMS_PERSION_IMAGE_FORMAT_JPG      = 1,            /* JPEG */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_BMP      = 2,            /* BMP */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_PNG      = 3,            /* PNG */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_GIF      = 4,            /* GIF */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_TIFF     = 5,            /* TIFF */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_INVALID  = 0xFF          
}NETDEV_TMS_PERSION_IMAGE_FORMAT_E;

/**
 * @enum tagNETDEVTMSCarPlateColor
 * @brief 
 * @attention  None
 */
typedef enum  tagNETDEVTMSCarPlateColor
{
    NETDEV_TMS_CAR_PLATE_COLOR_WHITE            = 0,            
    NETDEV_TMS_CAR_PLATE_COLOR_YELLOW           = 1,            
    NETDEV_TMS_CAR_PLATE_COLOR_BLUE             = 2,            
    NETDEV_TMS_CAR_PLATE_COLOR_BLACK            = 3,            
    NETDEV_TMS_CAR_PLATE_COLOR_OTHER            = 4,            
    NETDEV_TMS_CAR_PLATE_COLOR_GREEN            = 5,            
    NETDEV_TMS_CAR_PLATE_COLOR_RED              = 6,            
    NETDEV_TMS_CAR_PLATE_COLOR_YELLOW_AND_GREEN = 7,            
    NETDEV_TMS_CAR_PLATE_COLOR_GRADIENT_GREEN   = 8,            
    NETDEV_TMS_CAR_PLATE_COLOR_INVALID          = 0xFFFF        
}NETDEV_TMS_CAR_PLATE_COLOR_E;

/**
 * @enum tagNETDEVXWScreenCtrlType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWScreenCtrlType
{
    NETDEV_XW_SCREEN_CTRL_TYPE_TCP              = 0,          /* TCP */
    NETDEV_XW_SCREEN_CTRL_TYPE_UDP              = 1,          /* UDP */
    NETDEV_XW_SCREEN_CTRL_TYPE_COM              = 2,          
    NETDEV_XW_SCREEN_CTRL_TYPE_INVALID          = 0xFF        
}NETDEV_XW_SCREEN_CTRL_TYPE_E;

/**
 * @enum tagNETDEVXWScreenCtrlProtocolType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWScreenCtrlProtocolType
{
    NETDEV_XW_SCREEN_CTRL_PROT_LCD          = 0,          /* LCD */
    NETDEV_XW_SCREEN_CTRL_PROT_LED          = 1,          /* LED */
    NETDEV_XW_SCREEN_CTRL_PROT_MODBUS       = 2,          /* MODBUS */
    NETDEV_XW_SCREEN_CTRL_PROT_INVALID      = 0xFF        
}NETDEV_XW_SCREEN_CTRL_PROTOCOL_TYPE_E;

/**
 * @enum tagNETDEVXWScreenZoomdType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWScreenZoomdType
{
    NETDEV_XW_SCREEN_ZOOM_TYPE_PANE           = 0,           
    NETDEV_XW_SCREEN_ZOOM_TYPE_WIN            = 1,           
    NETDEV_XW_SCREEN_ZOOM_TYPE_INVALID        = 0xFF         
}NETDEV_XW_SCREEN_ZOOM_TYPE_E;

/**
 * @enum tagNETDEVXWScreenZoomdMode
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWScreenZoomdMode
{
    NETDEV_XW_SCREEN_ZOOM_MODE_OFF             = 0,          
    NETDEV_XW_SCREEN_ZOOM_MODE_ON              = 1,          
    NETDEV_XW_SCREEN_ZOOM_MODE_INVALID         = 0xFF        
}NETDEV_XW_SCREEN_ZOOM_MODE_E;

/**
 * @enum tagNETDEVPaneCap
 * @brief 
 * @attention
 */
typedef enum tagNETDEVPaneCap
{
    NETDEV_PANE_UNSUPPORT   = 0,        
    NETDEV_PANE_SAME_WND    = 1,        /* & */
    NETDEV_PANE_ANY_WND     = 2,        
    NETDEV_PANE_INVALID     = 0xFF      
}NETDEV_XW_PANE_CAP_E;

/**
 * @enum tagNETDEVRoamingCap
 * @brief 
 * @attention
 */
typedef enum tagNETDEVRoamingCap
{
    NETDEV_ROAMING_UNSUPPORT    = 0,        
    NETDEV_ROAMING_SINGLE_WND   = 1,        
    NETDEV_ROAMING_PANE_WND     = 2,        
    NETDEV_ROAMING_INVALID      = 0xFF      
}NETDEV_XW_ROAMING_CAP_E;

/**
 * @enum tagNETDEVWndCap
 * @brief 
 * @attention
 */
typedef enum tagNETDEVWndCap
{
    NETDEV_WINDOWS_UNSUPPORT    = 0,        
    NETDEV_WINDOWS_SINGLE_WND   = 1,        /* & */
    NETDEV_WINDOWS_MULTI_WND    = 2,        
    NETDEV_WINDOWS_ANY_WND      = 3,        
    NETDEV_WINDOWS_INVALID      = 0xff      
}NETDEV_XW_WND_CAP_E;

/**
 * @enum tagNETDEVXWSceneModifyType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWSceneModifyType
{
    NETDEV_XW_SCENE_MODIFY_TYPE_NAME        = 0,            
    NETDEV_XW_SCENE_MODIFY_TYPE_SAVE_AS     = 1,            /* , */
    NETDEV_XW_SCENE_MODIFY_TYPE_INVALID     = 0xff          
}NETDEV_XW_SCENE_MODIFY_TYPE_E;

/**
 * @enum tagNETDEVWeekInfo
 * @brief 
 * @attention
 */
typedef enum tagNETDEVWeekInfo
{
    NETDEV_LAPI_WEEK_MONDAY                  = 1,                  /*   Monday */
    NETDEV_LAPI_WEEK_TUESDAY                 = 2,                  /*   Tuesday */
    NETDEV_LAPI_WEEK_WEDNESDAY               = 3,                  /*   Wednesday */
    NETDEV_LAPI_WEEK_THURSDAY                = 4,                  /*   Thursday */
    NETDEV_LAPI_WEEK_FRIDAY                  = 5,                  /*   Friday */
    NETDEV_LAPI_WEEK_SATURDAY                = 6,                  /*   Saturday */
    NETDEV_LAPI_WEEK_SUNDAY                  = 7,                  /*   Sunday */
    NETDEV_LAPI_WEEK_HOLIDAY                 = 8,                  /*  Holiday */
    NETDEV_LAPI_WEEK_INVALID                 = 0xff                
}NETDEV_LAPI_WEEK_INFO_E;

/**
 * @enum tagNETDEVWndCommond
 * @brief 
 * @attention
 */
typedef enum tagNETDEVWndCommond
{
    NETDEV_WND_PANE_MOD         = 0x0001,       
    NETDEV_WND_LAYER            = 0x0002,       
    NETDEV_WND_TRANSPARENCY     = 0x0004,       
    NETDEV_WND_AREA             = 0x0008,       
    NETDEV_WND_NAME             = 0x0010,       
    NETDEV_WND_STATUS           = 0x0020,       
    NETDEV_WND_WND_TYPE         = 0x0040,       
    NETDEV_WND_DC_CHI_ID        = 0x0080,       /* DCID */
    NETDEV_WND_ZOOM_TYPE        = 0x0100,       
    NETDEV_WND_SPLIT_INDEX      = 0x0200,       
    NETDEV_WND_SCHEME_RES_ID    = 0x0400,       
    NETDEV_WND_SEQ_STATUS       = 0x0800,       
    NETDEV_WND_PANE_INFO_NUM    = 0x1000,       
    NETDEV_WND_SCALE_STATUS     = 0x2000,       
    NETDEV_WND_ALL              = 0xFFFF        
} NETDEV_XW_WND_CMD_E;

/**
 * @enum tagNETDEVZoomType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVZoomType
{
    NETDEV_XW_ZOOM_TYPE_NO          = 0x00,     /*  NO enlarge */
    NETDEV_XW_ZOOM_TYPE_SPLIT       = 0x01,     /*  split enlarge */
    NETDEV_XW_ZOOM_TYPE_WND         = 0x02,     /*  window enlarge */
    NETDEV_XW_ZOOM_TYPE_INVALID     = 0xFF      /*  invalid vule */
}NETDEV_XW_ZOOM_TYPE_E;

/**
 * @enum tagNETDEVVideoEncoding
 * @brief 
 * @attention
 */
typedef enum tagNETDEVVideoEncoding
{
    NETDEV_VIDEOENCODING_H264     = 0,         /* H264 */
    NETDEV_VIDEOENCODING_H265     = 1,         /* H265 */
    NETDEV_VIDEOENCODING_MPEG4    = 2,         /* MPEG4 */
    NETDEV_VIDEOENCODING_MPEG2    = 3,         /* MPEG2 */
    NETDEV_VIDEOENCODING_MJPEG    = 4          /* MJPEG */
}NETDEV_XW_VIDEOENCODING_E;

/**
 * @enum tagNetDevAuthModel
 * @brief 
 * @attention
 */
typedef enum tagNetDevAuthModel
{
    NETDEV_AUTH_MODEL_RSA_10       = 0,    /* RSA E10*/
    NETDEV_AUTH_MODEL_PRI          = 1,    
    NETDEV_AUTH_MODEL_RSA_16       = 2     /* RSAE16 */
}NETDEV_AUTH_MODEL_E;

/**
 * @enum tagNETDEVTransProtocol
* @brief  
* @attention  None
*/
typedef enum tagNETDEVTransProtocol
{
    NETDEV_TRANS_PROTOCOL_TCP = 0,              /* TCP */
    NETDEV_TRANS_PROTOCOL_UDP = 1               /* UDP */
}NETDEV_TRANS_PROTOCOL_E;

/**
 * @enum tagNETDEVDecodeType
 * @brief  
 * @attention
 */
typedef enum tagNETDEVDecodeType
{
    NETDEV_DECODE_TYPE_CLIENT = 0,      
    NETDEV_DECODE_TYPE_SERVER = 1       
}NETDEV_XW_DECODE_TYPE_E;

/**
 * @enum tagNETDEVRealPlayType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVRealPlayType
{
    NETDEV_TYPE_NORMAL  = 0,        
    NETDEV_TYPE_ALARM   = 1,        
    NETDEV_TYPE_LOCAL   = 2         
}NETDEV_XW_REALPLAY_TYPE_E;

 /**
 * @enum tagNETDEVAudioPortType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVAudioPortType
{
    NETDEV_AUDIO_PORT_SINGLE            = 0,                
    NETDEV_AUDIO_PORT_DOUBLE            = 1,                
    NETDEV_AUDIO_PORT_INVALID           = 0xff              
}NETDEV_AUDIO_PORT_TYPE_E;

/**
 * @enum tagNETDEVVideoPortType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVVideoPortType
{
    NETDEV_VIDEO_PORT_BNC            = 0,                /*  BNC */
    NETDEV_VIDEO_PORT_VGA            = 1,                /*  VGA */
    NETDEV_VIDEO_PORT_HDMI           = 2,                /*  HDMI */
    NETDEV_VIDEO_PORT_DVI_D          = 3,                /*  DVI_D */
    NETDEV_VIDEO_PORT_DVI_I          = 4,                /*  DVI_I */
    NETDEV_VIDEO_PORT_DP             = 5,                /*  DP */
    NETDEV_VIDEO_PORT_SDI            = 6,                /*  SDI */
    NETDEV_VIDEO_PORT_RJ45           = 7,                /*  RJ45 */
    NETDEV_VIDEO_PORT_INVALID        = 0xff              
}NETDEV_VIDEO_PORT_TYPE_E;

/**
 * @enum tagNETDEVXWLayoutNum
 * @brief  
 * @attention DC&&XW
*/
typedef enum tagNETDEVXWLayoutNum
{
    NETDEV_XW_LAYOUT_TYPE__SELF_ADAPT    = 0,                  
    NETDEV_XW_LAYOUT_TYPE_01             = 100,                /* 1 */
    NETDEV_XW_LAYOUT_TYPE_02             = 200,                /* 2 */
    NETDEV_XW_LAYOUT_TYPE_03             = 300,                /* 3 */
    NETDEV_XW_LAYOUT_TYPE_03_1           = 301,                /* 3 21*/
    NETDEV_XW_LAYOUT_TYPE_04             = 400,                /* 4 */
    NETDEV_XW_LAYOUT_TYPE_04_1           = 401,                /* 41+1+2 */
    NETDEV_XW_LAYOUT_TYPE_05             = 500,                /* 51+3+1 */
    NETDEV_XW_LAYOUT_TYPE_05_1           = 501,                /* 51+1+3 */
    NETDEV_XW_LAYOUT_TYPE_05_2           = 502,                /* 51+3+1 500 */
    NETDEV_XW_LAYOUT_TYPE_05_3           = 503,                /* 51+1+3 501 */
    NETDEV_XW_LAYOUT_TYPE_05_4           = 504,                /* 53+1+1*/
    NETDEV_XW_LAYOUT_TYPE_05_5           = 505,                /* 51+4*/
    NETDEV_XW_LAYOUT_TYPE_06             = 600,                /* 61+5 */
    NETDEV_XW_LAYOUT_TYPE_07             = 700,                /* 71+6 */
    NETDEV_XW_LAYOUT_TYPE_07_1           = 701,                /* 73+1+3 */
    NETDEV_XW_LAYOUT_TYPE_07_2           = 702,                /* 73+1+3(321) */
    NETDEV_XW_LAYOUT_TYPE_08             = 800,                /* 81+7 */
    NETDEV_XW_LAYOUT_TYPE_09             = 900,                /* 9 */
    NETDEV_XW_LAYOUT_TYPE_10             = 1000,               /* 101+9 */
    NETDEV_XW_LAYOUT_TYPE_10_1           = 1001,               /* 102+8 */
    NETDEV_XW_LAYOUT_TYPE_13             = 1300,               /* 131+12 */
    NETDEV_XW_LAYOUT_TYPE_13_1           = 1301,               /* 131+12 1300 */
    NETDEV_XW_LAYOUT_TYPE_16             = 1600,               /* 16 */
    NETDEV_XW_LAYOUT_TYPE_17             = 1700,               /* 171+16 */
    NETDEV_XW_LAYOUT_TYPE_25             = 2500,               /* 25 */
    NETDEV_XW_LAYOUT_TYPE_32             = 3200,               /* 323+1+28 */
    NETDEV_XW_LAYOUT_TYPE_36             = 3600,               /* 36 */
    NETDEV_XW_LAYOUT_TYPE_64             = 6400,               /* 64 */
    NETDEV_XW_LAYOUT_TYPE_10001          = 10001,              
    NETDEV_XW_LAYOUT_TYPE_10002          = 10002,              
    NETDEV_XW_LAYOUT_TYPE_10003          = 10003,              
    NETDEV_XW_LAYOUT_TYPE_10004          = 10004,              
    NETDEV_XW_LAYOUT_TYPE_10005          = 10005,              
    NETDEV_XW_LAYOUT_TYPE_10006          = 10006,              
    NETDEV_XW_LAYOUT_TYPE_10007          = 10007,              
    NETDEV_XW_LAYOUT_TYPE_10008          = 10008,              
    NETDEV_XW_LAYOUT_TYPE_INVALID        = 0xffff
}NETDEV_XW_LAYOUT_NUM_E;

/**
 * @enum tagNETDEVVideoFormat
 * @brief  
 * @attention DC&&XW
*/
typedef enum tagNETDEVVideoFormat
{
    NETDEV_VIDEO_FORMAT_720P24          = 2,            /* 1280x720@24 */
    NETDEV_VIDEO_FORMAT_720P25          = 3,            /* 1280x720@25 */
    NETDEV_VIDEO_FORMAT_720P30          = 4,            /* 1280x720@30 */
    NETDEV_VIDEO_FORMAT_720P50          = 5,            /* 1280x720@50 */
    NETDEV_VIDEO_FORMAT_720P60          = 6,            /* 1280x720@60 */
    NETDEV_VIDEO_FORMAT_1080P24         = 10,           /* 1920x1080@24 */
    NETDEV_VIDEO_FORMAT_1080P25         = 11,           /* 1920x1080@25 */
    NETDEV_VIDEO_FORMAT_1080P30         = 12,           /* 1920x1080@30 */
    NETDEV_VIDEO_FORMAT_1080P50         = 13,           /* 1920x1080@50 */
    NETDEV_VIDEO_FORMAT_1080P60         = 14,           /* 1920x1080@60 */
    NETDEV_VIDEO_FORMAT_XGA60           = 15,           /* 1024x768@60 */
    NETDEV_VIDEO_FORMAT_SXGA60          = 16,           /* 1280x1024@60 */
    NETDEV_VIDEO_FORMAT_UXGA60          = 17,           /* 1600x1200@60 */
    NETDEV_VIDEO_FORMAT_SXGAP60HZ       = 18,
    NETDEV_VIDEO_FORMAT_WXGAP60HZ       = 19,           /* 1366x768@60 */
    NETDEV_VIDEO_FORMAT_WSXGA60HZ       = 20,           /* 1440x900@60 */
    NETDEV_VIDEO_FORMAT_4K30            = 21,           /* 3840x2160@30 */
    NETDEV_VIDEO_FORMAT_4K60            = 22,           /* 3840x2160@60 */
    NETDEV_VIDEO_FORMAT_MUXGA60HZ       = 23,           /* 1920x1200@60 */
    NETDEV_VIDEO_FORMAT_CUSTOM          = 100,          
    NETDEV_VIDEO_FORMAT_INVALID         = 0xFF
}NETDEV_VIDEO_FORMAT_E;

/**
 * @enum tagNETDEVStreamType
 * @brief  
 * @attention  None
*/
typedef enum tagNETDEVStreamType
{
    NETDEV_STREAM_TYPE_RTP_UNICAST   = 0,         
    NETDEV_STREAM_TYPE_RTP_MULTICAST = 1,         
    NETDEV_STREAM_TYPE_RTP_INVALID   = 0xFF       
}NETDEV_STREAM_TYPE_E;

/**
 * @enum tagNETDEVAlarmSnapShotType
 * @brief 
 * @attention  None
*/
typedef enum tagNETDEVAlarmSnapShotType
{
    NETDEV_ALARM_SNAPSHOT_MOTION_DETECT                     = 0,            
    NETDEV_ALARM_SNAPSHOT_VIDEO_LOST                        = 1,            
    NETDEV_ALARM_SNAPSHOT_AUDIO_DETECTION                   = 2,            
    NETDEV_ALARM_SNAPSHOT_INPUT_SWITCH                      = 3,            
    NETDEV_ALARM_SNAPSHOT_IPC_OFFLINE                       = 4,            /* IPC */
    NETDEV_ALARM_SNAPSHOT_TAMPER_DETECT                     = 5,            
    NETDEV_ALARM_SNAPSHOT_CROSS_LINE                        = 6,            
    NETDEV_ALARM_SNAPSHOT_INTROSION_ZONE                    = 7,            
    NETDEV_ALARM_SNAPSHOT_FACE_DETECT                       = 8,            
    NETDEV_ALARM_SNAPSHOT_SCENCECHANGE                      = 9,            
    NETDEV_ALARM_SNAPSHOT_OUT_FOCUS                         = 10,           
    NETDEV_ALARM_SNAPSHOT_FACE_MATCH                        = 11,           
    NETDEV_ALARM_SNAPSHOT_FACE_NOT_MATCH                    = 12,           
    NETDEV_ALARM_SNAPSHOT_GATHER                            = 13,           
    NETDEV_ALARM_SNAPSHOT_REMAIN_ARTICLE                    = 14,           
    NETDEV_ALARM_SNAPSHOT_SMART_TRACK                       = 15,           
    NETDEV_ALARM_SNAPSHOT_LOITERING_DETECTOR                = 16,           
    NETDEV_ALARM_SNAPSHOT_VEHICLE_MATCH                     = 17,           
    NETDEV_ALARM_SNAPSHOT_VEHICLE_NOT_MATCH                 = 18,           
    NETDEV_ALARM_SNAPSHOT_ENTER_AREA                        = 19,           
    NETDEV_ALARM_SNAPSHOT_LEAVE_AREA                        = 20,           
    NETDEV_ALARM_SNAPSHOT_ARTICLE_MOVE                      = 21,           
    NETDEV_ALARM_SNAPSHOT_DURESS                            = 22,           
    NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY                   = 23,           
    NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY_RECOVER           = 24,           
    NETDEV_ALARM_SNAPSHOT_BYPASS_OPERATION                  = 25,           
    NETDEV_ALARM_SNAPSHOT_CF_BJ_EMBNAM_ZONE                 = 26,           /* . */
    NETDEV_ALARM_SNAPSHOT_CONFLAGRATION                     = 27,           
    NETDEV_ALARM_SNAPSHOT_HUMAN_SHAPE_DETECT                = 28,           
    NETDEV_ALARM_SNAPSHOT_INVALID                           = 0xFFFF        /*   Invalid value */
}NETDEV_ALARM_SNAPSHOT_TYPE_E;

/**
 * @enum tagNETDEVPreRecordTime
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVPreRecordTime
{
    NETDEV_PRE_RECORD_TIME_ZERO   = 0,            /* 0 */
    NETDEV_PRE_RECORD_TIME_FIVE   = 5,            /* 5 */
    NETDEV_PRE_RECORD_TIME_TEN    = 10,           /* 10 */
    NETDEV_PRE_RECORD_TIME_TWENTY = 20,           /* 20 */
    NETDEV_PRE_RECORD_TIME_THIRTY = 30,           /* 30 */
    NETDEV_PRE_RECORD_TIME_SIXTY  = 60            /* 60 */
}NETDEV_PRE_RECORD_TIME_E;

/**
 * @enum tagNETDEVPreRecordTime
 * @brief   PostRecordTime Enumeration definition
 * @attention 
*/
typedef enum tagNETDEVPostRecordTime
{
    NETDEV_POST_RECORD_TIME_FIVE                   = 5,             /* 5 */
    NETDEV_POST_RECORD_TIME_TEN                    = 10,            /* 10  */
    NETDEV_POST_RECORD_TIME_THIRTY                 = 30,            /* 30  */
    NETDEV_POST_RECORD_TIME_SIXTY                  = 60,            /* 60  */
    NETDEV_POST_RECORD_TIME_ONE_HUNDRED_AND_TWENTY = 120,           /* 120 */
    NETDEV_POST_RECORD_TIME_THREE_HUNDRED          = 300,           /* 300 */
    NETDEV_POST_RECORD_TIME_SIX_HUNDRED =            600            /* 600 */
}NETDEV_POST_RECORD_TIME_E;

/**
 * @enum tagNETDEVDefencePlanEnable
 * @brief    Defence Plan Enable Enumeration definition
 * @attention  None
*/
typedef enum tagNETDEVDefencePlanEnable
{
    NETDEV_DEFENCE_PLAN_DISABLE     = 0,        
    NETDEV_DEFENCE_PLAN_ENABLE      = 1         
}NETDEV_DEFENCE_PLAN_ENABLE_E;

/**
 * @enum tagNETDEVArmingType
 * @brief   Alarm And Defence Type Enumeration definition
 * @attention /IPC
*/
typedef enum tagNETDEVArmingType
{
    NETDEV_ARMING_TYPE_TIMING                   = 0,        
    NETDEV_ARMING_TYPE_MOTIONDETEC              = 1,        
    NETDEV_ARMING_TYPE_ALARM                    = 2,        
    NETDEV_ARMING_TYPE_MOTIONDETEC_AND_ALARM    = 3,        
    NETDEV_ARMING_TYPE_MOTIONDETEC_OR_ALARM     = 4,        
    NETDEV_ARMING_TYPE_NO_PLAN                  = 5,        
    NETDEV_ARMING_TYPE_EVENT                    = 10        
}NETDEV_ARMING_TYPE_E;

/**
 * @enum tagNETDEVDistributeCloud
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVDistributeCloud
{
    NETDEV_DISTRIBUTE_CLOUD_NONE      = 0,            
    NETDEV_DISTRIBUTE_CLOUD_KS        = 1,            
    NETDEV_DISTRIBUTE_CLOUD_UN        = 2,            
    NETDEV_DISTRIBUTE_CLOUD_TEN       = 3             
}NETDEV_DISTRIBUTE_CLOUD_SRV_E;

/**
 * @enum tagNETDevNetWorkMode
 * @brief 
 * @attention 
*/
typedef enum tagNETDevNetWorkMode
{
    NETDEV_NETMODE_LAN          = 0,        /* LAN , */
    NETDEV_NETMODE_WAN          = 1,        /* WAN ,NAT */
    NETDEV_NETMODE_MULTINAT     = 2,        /* NAT, */
    NETDEV_NETMODE_P2P          = 3,        /* NAT, */
    NETDEV_NETMODE_TURN         = 4         /* NAT, */
}NETDEV_NETWORK_MODE_E;

/**
 * @enum tagNETDEVReportType
 * @brief /
 * @attention  None
 */
typedef enum tagNETDEVReportType
{
    NETDEV_REPORT_TYPE_ALARM            = 0,                /*  */
    NETDEV_REPORT_TYPE_EVENT            = 1,                /*  */
    NETDEV_REPORT_TYPE_INVALID          = 0xFF              
}NETDEV_REPORT_TYPE_E;

/**
* @enum tagNETDEVAlarmSubType
* @brief 
* @attention 
*/
typedef enum tagNETDEVAlarmSubType
{
    NETDEV_ALARM_SUB_TYPE_NOT_CONFIGURED       = 0,                                         

    NETDEV_DEV_TYPE_BASE                       = (100000UL),                                
    NETDEV_DEV_TROUBLE                         = (NETDEV_DEV_TYPE_BASE + 1),                
    NETDEV_DEV_ALARM_EMERGENCY                 = (NETDEV_DEV_TYPE_BASE + 2),                

    
    NETDEV_ALARM_EVENT_BASE                    = (100200UL),                                
    NETDEV_ALARM_EVENT_FIRE_ALARM              = (NETDEV_ALARM_EVENT_BASE + 1),             
    NETDEV_ALARM_EVENT_KEYPADFIRE              = (NETDEV_ALARM_EVENT_BASE + 2),             
    NETDEV_ALARM_EVENT_KEYPADEMERGENCY         = (NETDEV_ALARM_EVENT_BASE + 3),             
    NETDEV_ALARM_EVENT_KEYPADMEDICAL           = (NETDEV_ALARM_EVENT_BASE + 4),             
    NETDEV_ALARM_EVENT_DURESSCODEUSED          = (NETDEV_ALARM_EVENT_BASE + 5),             
    NETDEV_ALARM_EVENT_UNAUTHORIZEDENTRY       = (NETDEV_ALARM_EVENT_BASE + 6),             
    NETDEV_ALARM_EVENT_BURGLARPOINTALARM       = (NETDEV_ALARM_EVENT_BASE + 7),             
    NETDEV_ALARM_EVENT_SUPERVISORY             = (NETDEV_ALARM_EVENT_BASE + 8),             
    NETDEV_ALARM_EVENT_FIRETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 9),             
    NETDEV_ALARM_EVENT_FIREPOINTTROUBLE        = (NETDEV_ALARM_EVENT_BASE + 10),            
    NETDEV_ALARM_EVENT_BURGLARPOINTTROUBLE     = (NETDEV_ALARM_EVENT_BASE + 11),            
    NETDEV_ALARM_EVENT_CANCELALARM             = (NETDEV_ALARM_EVENT_BASE + 12),            
    NETDEV_ALARM_EVENT_DISARM                  = (NETDEV_ALARM_EVENT_BASE + 13),            
    NETDEV_ALARM_EVENT_ARM                     = (NETDEV_ALARM_EVENT_BASE + 14),            
    NETDEV_ALARM_EVENT_FORCEDBYPASS            = (NETDEV_ALARM_EVENT_BASE + 15),            
    NETDEV_ALARM_EVENT_BYPASS                  = (NETDEV_ALARM_EVENT_BASE + 16),            
    NETDEV_ALARM_EVENT_POINTRESTORAL           = (NETDEV_ALARM_EVENT_BASE + 17),            
    NETDEV_ALARM_EVENT_FAILTOCLOSE             = (NETDEV_ALARM_EVENT_BASE + 18),            
    NETDEV_ALARM_EVENT_FAILTOOPEN              = (NETDEV_ALARM_EVENT_BASE + 19),            
    NETDEV_ALARM_EVENT_HISTORYBUFFERDUMP       = (NETDEV_ALARM_EVENT_BASE + 20),            
    NETDEV_ALARM_EVENT_TESTMSG                 = (NETDEV_ALARM_EVENT_BASE + 21),            
    NETDEV_ALARM_EVENT_ZONETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 22),            
    NETDEV_ALARM_EVENT_ZONETROUBLERESTORE      = (NETDEV_ALARM_EVENT_BASE + 23),            
    NETDEV_ALARM_EVENT_ZONESHORT               = (NETDEV_ALARM_EVENT_BASE + 24),            
    NETDEV_ALARM_EVENT_ZONEOPEN                = (NETDEV_ALARM_EVENT_BASE + 25),            
    NETDEV_ALARM_EVENT_ZONENORMAL              = (NETDEV_ALARM_EVENT_BASE + 26),            
    NETDEV_ALARM_EVENT_MXDEVCLOSE              = (NETDEV_ALARM_EVENT_BASE + 27),            /* MX */
    NETDEV_ALARM_EVENT_MXDEVOPEN               = (NETDEV_ALARM_EVENT_BASE + 28),            /* MX */
    NETDEV_ALARM_EVENT_MXDEV1ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 29),            /* MX1 */
    NETDEV_ALARM_EVENT_MXDEV2ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 30),            /* MX2 */
    NETDEV_ALARM_EVENT_MXDEV3ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 31),            /* MX3 */
    NETDEV_ALARM_EVENT_MXDEV1ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 32),            /* MX1 */
    NETDEV_ALARM_EVENT_MXDEV2ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 33),            /* MX2 */
    NETDEV_ALARM_EVENT_MXDEV3ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 34),            /* MX3 */
    NETDEV_ALARM_EVENT_TROUBLE_AC              = (NETDEV_ALARM_EVENT_BASE + 35),            
    NETDEV_ALARM_EVENT_TROUBLE_BATTERY         = (NETDEV_ALARM_EVENT_BASE + 36),            
    NETDEV_ALARM_EVENT_TROUBLE_SNDREPORT       = (NETDEV_ALARM_EVENT_BASE + 37),            
    NETDEV_ALARM_EVENT_TROUBLE_CONTROL         = (NETDEV_ALARM_EVENT_BASE + 38),            
    NETDEV_ALARM_EVENT_TROUBLE_MXBUS           = (NETDEV_ALARM_EVENT_BASE + 39),            /* MPX */
    NETDEV_ALARM_EVENT_TROUBLE_RADIOSND        = (NETDEV_ALARM_EVENT_BASE + 40),            
    NETDEV_ALARM_EVENT_TROUBLE_ASSISTPOWER     = (NETDEV_ALARM_EVENT_BASE + 41),            
    NETDEV_ALARM_EVENT_TROUBLE_OPTION          = (NETDEV_ALARM_EVENT_BASE + 42),            /* option */
    NETDEV_ALARM_EVENT_LINK_BREAK              = (NETDEV_ALARM_EVENT_BASE + 43),            
    NETDEV_ALARM_EVENT_LINK_RESUME             = (NETDEV_ALARM_EVENT_BASE + 44),            
    NETDEV_ALARM_EVENT_VOLTAGE_ALARM           = (NETDEV_ALARM_EVENT_BASE + 45),            
    NETDEV_ALARM_EVENT_EXTERNDEV_TROUBLE       = (NETDEV_ALARM_EVENT_BASE + 46),            
    NETDEV_ALARM_EVENT_EXTERNDEV_RESUME        = (NETDEV_ALARM_EVENT_BASE + 47),            
    NETDEV_ALARM_EVENT_POINT_DISARM            = (NETDEV_ALARM_EVENT_BASE + 48),            
    NETDEV_ALARM_EVENT_POINT_ARM               = (NETDEV_ALARM_EVENT_BASE + 49),            
    NETDEV_ALARM_EVENT_FORCE_OPEN              = (NETDEV_ALARM_EVENT_BASE + 50),            
    NETDEV_ALARM_EVENT_BYPASS_FAILED           = (NETDEV_ALARM_EVENT_BASE + 51),            
    NETDEV_ALARM_EVENT_RESET_FAILED            = (NETDEV_ALARM_EVENT_BASE + 52),            
    NETDEV_ALARM_EVENT_POINT_FIRETROUBLE       = (NETDEV_ALARM_EVENT_BASE + 53),            
    NETDEV_ALARM_EVENT_POINT_SEPARATE          = (NETDEV_ALARM_EVENT_BASE + 54),            
    NETDEV_ALARM_EVENT_POINT_ACTION            = (NETDEV_ALARM_EVENT_BASE + 55),            
    NETDEV_ALARM_EVENT_POINT_RESUME            = (NETDEV_ALARM_EVENT_BASE + 56),            
    NETDEV_ALARM_EVENT_ROB_ACTION              = (NETDEV_ALARM_EVENT_BASE + 57),            

    
    NETDEV_ALARM_EVENT_MISSED_ARM              = (NETDEV_ALARM_EVENT_BASE + 60),            
    NETDEV_ALARM_EVENT_MISSED_DISARM           = (NETDEV_ALARM_EVENT_BASE + 61),            
    NETDEV_ALARM_EVENT_AUXILARY_RST            = (NETDEV_ALARM_EVENT_BASE + 62),            
    NETDEV_ALARM_EVENT_AUXILARY                = (NETDEV_ALARM_EVENT_BASE + 63),            
    NETDEV_ALARM_EVENT_BURGLARY_RST            = (NETDEV_ALARM_EVENT_BASE + 64),            
    NETDEV_ALARM_EVENT_BURGLARY                = (NETDEV_ALARM_EVENT_BASE + 65),            
    NETDEV_ALARM_EVENT_BYPASS_RST              = (NETDEV_ALARM_EVENT_BASE + 66),            
    NETDEV_ALARM_EVENT_CANCEL                  = (NETDEV_ALARM_EVENT_BASE + 67),            
    NETDEV_ALARM_EVENT_DUPLICATE               = (NETDEV_ALARM_EVENT_BASE + 68),            
    NETDEV_ALARM_EVENT_DURESS_RST              = (NETDEV_ALARM_EVENT_BASE + 69),            
    NETDEV_ALARM_EVENT_DURESS                  = (NETDEV_ALARM_EVENT_BASE + 70),            
    NETDEV_ALARM_EVENT_FIRE_RST                = (NETDEV_ALARM_EVENT_BASE + 71),            
    NETDEV_ALARM_EVENT_FIRE_TROUBLE            = (NETDEV_ALARM_EVENT_BASE + 72),            
    NETDEV_ALARM_EVENT_FIRE_TRB_RST            = (NETDEV_ALARM_EVENT_BASE + 73),            
    NETDEV_ALARM_EVENT_MED_RST                 = (NETDEV_ALARM_EVENT_BASE + 74),            
    NETDEV_ALARM_EVENT_PANIC                   = (NETDEV_ALARM_EVENT_BASE + 75),            
    NETDEV_ALARM_EVENT_PANIC_RST               = (NETDEV_ALARM_EVENT_BASE + 76),            
    NETDEV_ALARM_EVENT_RESET                   = (NETDEV_ALARM_EVENT_BASE + 77),            
    NETDEV_ALARM_EVENT_RELAY_SHORTED           = (NETDEV_ALARM_EVENT_BASE + 78),            
    NETDEV_ALARM_EVENT_RELAY_RST               = (NETDEV_ALARM_EVENT_BASE + 79),            
    NETDEV_ALARM_EVENT_RELAY_TROUBLE           = (NETDEV_ALARM_EVENT_BASE + 80),            
    NETDEV_ALARM_EVENT_TAMPER                  = (NETDEV_ALARM_EVENT_BASE + 81),            
    NETDEV_ALARM_EVENT_TAMPER_RST              = (NETDEV_ALARM_EVENT_BASE + 82),            
    NETDEV_ALARM_EVENT_TROUBLE                 = (NETDEV_ALARM_EVENT_BASE + 83),            
    NETDEV_ALARM_EVENT_TROUBLE_RST             = (NETDEV_ALARM_EVENT_BASE + 84),            

    /* DF8900 */
    NETDEV_ALARM_EVENT_DFE_REMOTE_CONTROL      = (NETDEV_ALARM_EVENT_BASE + 90),            
    NETDEV_ALARM_EVENT_DFE_SYNC                = (NETDEV_ALARM_EVENT_BASE + 91),            
    NETDEV_ALARM_EVENT_DFE_LIFTING             = (NETDEV_ALARM_EVENT_BASE + 92),            
    NETDEV_ALARM_EVENT_DFE_SWITCH_NORMAL       = (NETDEV_ALARM_EVENT_BASE + 93),            
    NETDEV_ALARM_EVENT_DFE_SWITCH_ACCIDENT     = (NETDEV_ALARM_EVENT_BASE + 94),            
    NETDEV_ALARM_EVENT_DFE_KINFE_GATE          = (NETDEV_ALARM_EVENT_BASE + 95),            

    
    NETDEV_ALARM_EVENT_ESCAPE                  = (NETDEV_ALARM_EVENT_BASE + 96),            
    NETDEV_ALARM_EVENT_ESCAPE_END              = (NETDEV_ALARM_EVENT_BASE + 97),            
    NETDEV_ALARM_EVENT_VIOLENCE                = (NETDEV_ALARM_EVENT_BASE + 98),            
    NETDEV_ALARM_EVENT_VIOLENCE_END            = (NETDEV_ALARM_EVENT_BASE + 99),            
    NETDEV_ALARM_EVENT_ATTACKED                = (NETDEV_ALARM_EVENT_BASE + 100),           
    NETDEV_ALARM_EVENT_ATTACKED_END            = (NETDEV_ALARM_EVENT_BASE + 101),           
    NETDEV_ALARM_EVENT_NATURAL_DISASTER        = (NETDEV_ALARM_EVENT_BASE + 102),           
    NETDEV_ALARM_EVENT_NATURAL_DISASTER_END    = (NETDEV_ALARM_EVENT_BASE + 103),           
    NETDEV_ALARM_EVENT_ONE_KEY_ALARM           = (NETDEV_ALARM_EVENT_BASE + 104),           
    NETDEV_ALARM_EVENT_ONE_KEY_ALARM_END       = (NETDEV_ALARM_EVENT_BASE + 105),           

    
    NETDEV_ALARM_EVENT_CERC_NORMAL             = (NETDEV_ALARM_EVENT_BASE + 106),           
    NETDEV_ALARM_EVENT_CERC_TOUCH              = (NETDEV_ALARM_EVENT_BASE + 107),           
    NETDEV_ALARM_EVENT_CERC_BREAK              = (NETDEV_ALARM_EVENT_BASE + 108),           
    NETDEV_ALARM_EVENT_CERC_SHORT              = (NETDEV_ALARM_EVENT_BASE + 109),           
    NETDEV_ALARM_EVENT_CERC_COMMU_ERR          = (NETDEV_ALARM_EVENT_BASE + 110),           

    
    NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM      = (NETDEV_ALARM_EVENT_BASE + 111),           
    NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM_RST  = (NETDEV_ALARM_EVENT_BASE + 112),           
    NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM       = (NETDEV_ALARM_EVENT_BASE + 113),           
    NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM_RST   = (NETDEV_ALARM_EVENT_BASE + 114),           

    
    NETDEV_ALARM_EVENT_UBI_ALARM               = (NETDEV_ALARM_EVENT_BASE + 115),           

    
    NETDEV_ALARM_EVENT_HXTECH_CABLE_ALARM      = (NETDEV_ALARM_EVENT_BASE + 116),           

    
    NETDEV_ALARM_EVENT_DEVICE_UNDER_VOLTAGE_RST            = (NETDEV_ALARM_EVENT_BASE + 117),    
    NETDEV_ALARM_EVENT_ZONE_NOT_READY                      = (NETDEV_ALARM_EVENT_BASE + 118),    
    NETDEV_ALARM_EVENT_ZONE_NOT_READY_RST                  = (NETDEV_ALARM_EVENT_BASE + 119),    
    NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT               = (NETDEV_ALARM_EVENT_BASE + 120),    
    NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT_RST           = (NETDEV_ALARM_EVENT_BASE + 121),    
    NETDEV_ALARM_EVENT_AC_POWER_FAULT                      = (NETDEV_ALARM_EVENT_BASE + 122),    

    
    NETDEV_ALARM_EVENT_ZONE_TOUCH                          = (NETDEV_ALARM_EVENT_BASE + 123),    
    NETDEV_ALARM_EVENT_ZONE_TOUCH_RESTORE                  = (NETDEV_ALARM_EVENT_BASE + 124),    
    NETDEV_ALARM_EVENT_CAPTIVE                             = (NETDEV_ALARM_EVENT_BASE + 125),    
    NETDEV_ALARM_EVENT_CAPTIVE_RST                         = (NETDEV_ALARM_EVENT_BASE + 126),    
    NETDEV_ALARM_EVENT_UNDERVOLTAGE                        = (NETDEV_ALARM_EVENT_BASE + 127),    
    NETDEV_ALARM_EVENT_UNDERVOLTAGE_RST                    = (NETDEV_ALARM_EVENT_BASE + 128),    
    NETDEV_ALARM_EVENT_TROUBLE_BATTERY_RST                 = (NETDEV_ALARM_EVENT_BASE + 129),    
    NETDEV_ALARM_EVENT_DEV_POWER_REBOOT                    = (NETDEV_ALARM_EVENT_BASE + 130),    
    NETDEV_ALARM_EVENT_TEST_FAILURE                        = (NETDEV_ALARM_EVENT_BASE + 131),    
    NETDEV_ALARM_EVENT_OPERATOR_TOUCH_LONG                 = (NETDEV_ALARM_EVENT_BASE + 132),    
    NETDEV_ALARM_EVENT_REMOTE_ARM                          = (NETDEV_ALARM_EVENT_BASE + 133),    
    NETDEV_ALARM_EVENT_REMOTE_DISARM                       = (NETDEV_ALARM_EVENT_BASE + 134),    
    NETDEV_ALARM_EVENT_REMOTE_STAY_ARM                     = (NETDEV_ALARM_EVENT_BASE + 135),    
    NETDEV_ALARM_EVENT_PWD_ARM                             = (NETDEV_ALARM_EVENT_BASE + 136),    
    NETDEV_ALARM_EVENT_PWD_DISARM                          = (NETDEV_ALARM_EVENT_BASE + 137),    
    NETDEV_ALARM_EVENT_PWD_STAY_DEV                        = (NETDEV_ALARM_EVENT_BASE + 138),    
    NETDEV_ALARM_EVENT_PWD_ARM_PART                        = (NETDEV_ALARM_EVENT_BASE + 139),    
    NETDEV_ALARM_EVENT_PWD_DISARM_PART                     = (NETDEV_ALARM_EVENT_BASE + 140),    
    NETDEV_ALARM_EVENT_PWD_STAY_PART                       = (NETDEV_ALARM_EVENT_BASE + 141),    
    NETDEV_ALARM_EVENT_PWD_ARM_ZONE                        = (NETDEV_ALARM_EVENT_BASE + 142),    
    NETDEV_ALARM_EVENT_PWD_DISARM_ZONE                     = (NETDEV_ALARM_EVENT_BASE + 143),    
    NETDEV_ALARM_EVENT_USER_ARM                            = (NETDEV_ALARM_EVENT_BASE + 144),    
    NETDEV_ALARM_EVENT_USER_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 145),    
    NETDEV_ALARM_EVENT_USER_STAY_DEV                       = (NETDEV_ALARM_EVENT_BASE + 146),    
    NETDEV_ALARM_EVENT_USER_CLEAN_ALARM                    = (NETDEV_ALARM_EVENT_BASE + 147),    
    NETDEV_ALARM_EVENT_PWD_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 148),    
    NETDEV_ALARM_EVENT_KEY_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 149),    
    NETDEV_ALARM_EVENT_REMOTE_OPEN_DOOR                    = (NETDEV_ALARM_EVENT_BASE + 150),    
    NETDEV_ALARM_EVENT_SWIPE_ARM                           = (NETDEV_ALARM_EVENT_BASE + 151),    
    NETDEV_ALARM_EVENT_SWIPE_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 152),    
    NETDEV_ALARM_EVENT_SWIPE_LOCK                          = (NETDEV_ALARM_EVENT_BASE + 153),    
    NETDEV_ALARM_EVENT_SWIPE_UNLOCK                        = (NETDEV_ALARM_EVENT_BASE + 154),    
    NETDEV_ALARM_EVENT_SWIPE_RECORD                        = (NETDEV_ALARM_EVENT_BASE + 155),    
    NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_IN                 = (NETDEV_ALARM_EVENT_BASE + 156),    
    NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_OUT                = (NETDEV_ALARM_EVENT_BASE + 157),    
    NETDEV_ALARM_EVENT_SWIPE_TURNON_LIGHT                  = (NETDEV_ALARM_EVENT_BASE + 158),    
    NETDEV_ALARM_EVENT_SWIPE_OFF_LIGHT                     = (NETDEV_ALARM_EVENT_BASE + 159),    
    NETDEV_ALARM_EVENT_SWIPE_CARD_NUM                      = (NETDEV_ALARM_EVENT_BASE + 160),    
    NETDEV_ALARM_EVENT_MANUAL_OPEN                         = (NETDEV_ALARM_EVENT_BASE + 161),    /* /  */
    NETDEV_ALARM_EVENT_ZONE_OPEN_DOOR                      = (NETDEV_ALARM_EVENT_BASE + 162),    
    NETDEV_ALARM_EVENT_ZONE_DOOR_LONGTIME                  = (NETDEV_ALARM_EVENT_BASE + 163),    
    NETDEV_ALARM_EVENT_ZONE_ARM                            = (NETDEV_ALARM_EVENT_BASE + 164),    
    NETDEV_ALARM_EVENT_ZONE_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 165),    
    NETDEV_ALARM_EVENT_TIMER_ARM                           = (NETDEV_ALARM_EVENT_BASE + 166),    
    NETDEV_ALARM_EVENT_TIMER_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 167),    
    NETDEV_ALARM_EVENT_CENTRAL_COMM_NORMAL                 = (NETDEV_ALARM_EVENT_BASE + 168),    
    NETDEV_ALARM_EVENT_CENTRAL_HANDSHAKE_FAILED            = (NETDEV_ALARM_EVENT_BASE + 169),    
    NETDEV_ALARM_EVENT_CENTRAL_RESPONSE_FAILED             = (NETDEV_ALARM_EVENT_BASE + 170),    
    NETDEV_ALARM_EVENT_USER_CONFIRMATION                   = (NETDEV_ALARM_EVENT_BASE + 171),    
    NETDEV_ALARM_EVENT_USER_TIMEOUT                        = (NETDEV_ALARM_EVENT_BASE + 172),    
    NETDEV_ALARM_EVENT_TELEP_RINGING                       = (NETDEV_ALARM_EVENT_BASE + 173),    
    NETDEV_ALARM_EVENT_TELEP_ARM                           = (NETDEV_ALARM_EVENT_BASE + 174),    
    NETDEV_ALARM_EVENT_TELEP_STATUS_OFFLINE                = (NETDEV_ALARM_EVENT_BASE + 175),    
    NETDEV_ALARM_EVENT_TELEP_STATUS_ONLINE                 = (NETDEV_ALARM_EVENT_BASE + 176),    
    NETDEV_ALARM_EVENT_MSG_SEND_SUCC                       = (NETDEV_ALARM_EVENT_BASE + 177),    
    NETDEV_ALARM_EVENT_MSG_SEND_FAILED                     = (NETDEV_ALARM_EVENT_BASE + 178),    
    NETDEV_ALARM_EVENT_SWITCH_CLOSE                        = (NETDEV_ALARM_EVENT_BASE + 179),    
    NETDEV_ALARM_EVENT_SWITCH_OFF                          = (NETDEV_ALARM_EVENT_BASE + 180),    
    NETDEV_ALARM_EVENT_TEMPER_CHANGE                       = (NETDEV_ALARM_EVENT_BASE + 181),    
    NETDEV_ALARM_EVENT_HUMIDITY_CHANGE                     = (NETDEV_ALARM_EVENT_BASE + 182),    
    NETDEV_ALARM_EVENT_DEVID_WRONG                         = (NETDEV_ALARM_EVENT_BASE + 183),    /* ID  */
    NETDEV_ALARM_EVENT_ELEC_HIGH_ARM                       = (NETDEV_ALARM_EVENT_BASE + 184),    
    NETDEV_ALARM_EVENT_ELEC_LOW_ARM                        = (NETDEV_ALARM_EVENT_BASE + 185),    
    NETDEV_ALARM_EVENT_ELEC_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE + 186),    
    NETDEV_ALARM_EVENT_ELEC_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 187),    
    NETDEV_ALARM_EVENT_ELEC_ARM                            = (NETDEV_ALARM_EVENT_BASE + 188),    
    NETDEV_ALARM_EVENT_KEY_ALARM_OVER                      = (NETDEV_ALARM_EVENT_BASE + 189),    
    NETDEV_ALARM_EVENT_KEY_PROL_TYPE                       = (NETDEV_ALARM_EVENT_BASE + 190),    
    NETDEV_ALARM_EVENT_MOD_DEV_ADDR                        = (NETDEV_ALARM_EVENT_BASE + 191),    
    NETDEV_ALARM_EVENT_FORWARD_CMD                         = (NETDEV_ALARM_EVENT_BASE + 192) ,   

    NETDEV_ALARM_EVENT_BASE_VALUE                          = (110000UL),                                    
    NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 1),           
    NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 2),           
    NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM              = (NETDEV_ALARM_EVENT_BASE_VALUE + 3),           /* 24 */
    NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM_RST          = (NETDEV_ALARM_EVENT_BASE_VALUE + 4),           /* 24 */
    NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 5),           /* 24 */
    NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM_RST             = (NETDEV_ALARM_EVENT_BASE_VALUE + 6),           /* 24 */
    NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 7),           
    NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 8),           
    NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 9),           
    NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 10),          
    NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 11),          
    NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 12),          
    NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 13),          
    NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 14),          
    NETDEV_ALARM_EVENT_OUTER_DISARMED                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 15),          
    NETDEV_ALARM_EVENT_OUTER_ARMED                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 16),          
    NETDEV_ALARM_EVENT_KEY_DISARMED                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 17),          
    NETDEV_ALARM_EVENT_KEY_ARMED                           = (NETDEV_ALARM_EVENT_BASE_VALUE + 18),          
    NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION         = (NETDEV_ALARM_EVENT_BASE_VALUE + 19),          
    NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION_RST     = (NETDEV_ALARM_EVENT_BASE_VALUE + 20),          
    NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 21),          
    NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK_RST            = (NETDEV_ALARM_EVENT_BASE_VALUE + 22),          
    NETDEV_ALARM_EVENT_SOFT_DEFEND_URGENCY_ALARM           = (NETDEV_ALARM_EVENT_BASE_VALUE + 23),          
    NETDEV_ALARM_EVENT_ARMED_STAY                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 24),          
    NETDEV_ALARM_EVENT_IMMEDIATELY_ARMED                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 25),          

    
    NETDEV_ALARM_EVENT_SMOKE_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 26),          
    NETDEV_ALARM_EVENT_SMOKE_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 27),          
    NETDEV_ALARM_EVENT_WATER_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 28),          
    NETDEV_ALARM_EVENT_WATER_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 29),          
    NETDEV_ALARM_EVENT_IO_ON                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 30),          /* . */
    NETDEV_ALARM_EVENT_IO_OFF                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 31),          /* . */

    
    NETDEV_ALARM_EVENT_TOUNCH_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 32),          
    NETDEV_ALARM_EVENT_INVADE_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 33),          
    NETDEV_ALARM_EVENT_BROKEN_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 34),          
    NETDEV_ALARM_EVENT_HELP                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 36),          
    NETDEV_ALARM_EVENT_DESTROY                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 37),          
    NETDEV_ALARM_EVENT_ACS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 38),          
    NETDEV_ALARM_EVENT_OTHERS                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 39),          
    NETDEV_ALARM_EVENT_ZONE_ALARM                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 40),          /* . */
    NETDEV_ALARM_EVENT_ZONE_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 41),          /* . */
    NETDEV_ALARM_EVENT_GATO_ALARM_FENCE                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 42),          
    NETDEV_ALARM_EVENT_GATO_ALARM_HOST                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 43),          
    NETDEV_ALARM_EVENT_GATO_ALARM_ETCZONE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 44),          
    NETDEV_ALARM_EVENT_GATO_ALARM_OFFLINE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 45),          
    NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH1                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 46),          /* 1 */
    NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH2                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 47),          /* 2 */
    NETDEV_ALARM_EVENT_STEAL                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 48),          
    NETDEV_ALARM_EVENT_GAS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 49),          
    NETDEV_ALARM_EVENT_SAVE                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 50),          
    NETDEV_ALARM_EVENT_INVADE_TROUBLE                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 51),          
    NETDEV_ALARM_EVENT_SYS_TROUBLE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 52),          
    NETDEV_ALARM_EVENT_OPTICAL_FIBER_TROUBLE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 53),          

    
    NETDEV_ALARM_EVENT_MOTION_DETECTION                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 62),          
    NETDEV_ALARM_EVENT_CALL_REMOVE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 63),          
    NETDEV_ALARM_EVENT_NOISE                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 64),          
    NETDEV_ALARM_EVENT_DELAYED                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 65),          
    NETDEV_ALARM_EVENT_ALARM_INPUT_ONE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 66),          /* 1 */
    NETDEV_ALARM_EVENT_ALARM_INPUT_TWO                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 67),          /* 2 */
    NETDEV_ALARM_EVENT_ALARM_CALL_EMERGENCY                = (NETDEV_ALARM_EVENT_BASE_VALUE + 68),          
    NETDEV_ALARM_EVENT_ALARM_CALL_CONSULTANT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 69),          
    NETDEV_ALARM_EVENT_DOOR_MAGNET_OPEN                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 70),          
    NETDEV_ALARM_EVENT_DOOR_MAGNET_CLOSE                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 71),          
    NETDEV_ALARM_EVENT_DOOR_LOCK_OPEN                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 72),          
    NETDEV_ALARM_EVENT_DOOR_LOCK_CLOSE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 73),          

    
    NETDEV_ALARM_EVENT_ALARM_PORT_ONE             = (NETDEV_ALARM_EVENT_BASE_VALUE + 74),          /* 1  Port 1 Alarm */
    NETDEV_ALARM_EVENT_ALARM_PORT_TWO             = (NETDEV_ALARM_EVENT_BASE_VALUE + 75),          /* 2  Port 2 Alarm */
    NETDEV_ALARM_EVENT_ALARM_PORTEX               = (NETDEV_ALARM_EVENT_BASE_VALUE + 76),          /*   Expansion Port Alarm */
    NETDEV_ALARM_EVENT_ALARM_TUMULT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 77),          /*   Tumult Alarm */
    NETDEV_ALARM_EVENT_ALARM_110                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 78),          /* 110  110 Alarm */
    NETDEV_ALARM_EVENT_ALARM_119                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 79),          /* 119  119 Alarm */
    NETDEV_ALARM_EVENT_ALARM_120                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 80),          /* 120  120 Alarm */

    
    NETDEV_ALARM_EVENT_ALARM_FINDERCONNECT_FAILED = (NETDEV_ALARM_EVENT_BASE_VALUE + 81),          
    NETDEV_ALARM_EVENT_ALARM_OUTAGE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 82),          
    NETDEV_ALARM_EVENT_ALARM_DISASSEMBLE          = (NETDEV_ALARM_EVENT_BASE_VALUE + 83),          
    NETDEV_ALARM_EVENT_ALARM_CIRCUIT              = (NETDEV_ALARM_EVENT_BASE_VALUE + 84),          
    NETDEV_ALARM_EVENT_ALARM_TOUCHNET             = (NETDEV_ALARM_EVENT_BASE_VALUE + 85),          
    NETDEV_ALARM_EVENT_ALARM_PREVENTCUT           = (NETDEV_ALARM_EVENT_BASE_VALUE + 86),          
    NETDEV_ALARM_EVENT_ALARM_COCKING              = (NETDEV_ALARM_EVENT_BASE_VALUE + 87),          
    NETDEV_ALARM_EVENT_ALARM_SLACK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 88),          
    NETDEV_ALARM_EVENT_ALARM_ZONE_FORBIDDEN       = (NETDEV_ALARM_EVENT_BASE_VALUE + 89),          

    
    NETDEV_ALARM_EVENT_HIGH_TEMP                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 90),           
    NETDEV_ALARM_EVENT_LOW_TEMP                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 91),           
    NETDEV_ALARM_EVENT_HIGH_HUMI                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 92),           
    NETDEV_ALARM_EVENT_LOW_HUMI                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 93),           
    NETDEV_ALARM_MONITOR_DEVICE_ONLINE            = (NETDEV_ALARM_EVENT_BASE_VALUE + 94),           
    NETDEV_ALARM_MONITOR_DEVICE_OFFLINE           = (NETDEV_ALARM_EVENT_BASE_VALUE + 95),           

    /* -- */
    NETDEV_ALARM_EVENT_ALARM_CALL_OUT_RING            = (NETDEV_ALARM_EVENT_BASE_VALUE + 110),          
    NETDEV_ALARM_EVENT_ALARM_CALL_IN                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 111),          
    NETDEV_ALARM_EVENT_ALARM_CALL_END                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 112),          
    NETDEV_ALARM_EVENT_ALARM_BROADCAST_TO_SLAVE_BEGIN = (NETDEV_ALARM_EVENT_BASE_VALUE + 113),          
    NETDEV_ALARM_EVENT_ALARM_BROADCAST_TO_MAST_BEGIN  = (NETDEV_ALARM_EVENT_BASE_VALUE + 114),          
    NETDEV_ALARM_EVENT_ALARM_BROADCAST_END            = (NETDEV_ALARM_EVENT_BASE_VALUE + 115),          
    NETDEV_ALARM_EVENT_ALARM_CALL_INTERPHONE          = (NETDEV_ALARM_EVENT_BASE_VALUE + 116),          


    
    NETDEV_DOOR_EVENT_BASE                         = (100400UL),                          

    NETDEV_DOOR_EVENT_DISCONNECT                   = (NETDEV_DOOR_EVENT_BASE + 1),        
    NETDEV_DOOR_EVENT_INFRARED_ALARM               = (NETDEV_DOOR_EVENT_BASE + 2),        
    NETDEV_DOOR_EVENT_ILLICIT_OPEN_DOOR            = (NETDEV_DOOR_EVENT_BASE + 3),        
    NETDEV_DOOR_EVENT_COERCE_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 4),        
    NETDEV_DOOR_EVENT_OPEN_TIMEOUT                 = (NETDEV_DOOR_EVENT_BASE + 5),        
    NETDEV_DOOR_EVENT_CLOSE_TIMEOUT                = (NETDEV_DOOR_EVENT_BASE + 6),        
    NETDEV_DOOR_EVENT_ANOMALOUS_CARD               = (NETDEV_DOOR_EVENT_BASE + 7),        
    NETDEV_DOOR_EVENT_CARD_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 8),        
    NETDEV_DOOR_EVENT_REMOTE_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 9),        
    NETDEV_DOOR_EVENT_MANUAL_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 10),       
    NETDEV_DOOR_EVENT_EMERGENCY_START              = (NETDEV_DOOR_EVENT_BASE + 11),       
    NETDEV_DOOR_EVENT_EMERGENCY_STOP               = (NETDEV_DOOR_EVENT_BASE + 12),       
    NETDEV_DOOR_EVENT_OPEN_SUCCESS                 = (NETDEV_DOOR_EVENT_BASE + 13),       
    NETDEV_DOOR_EVENT_OPEN_FAILED                  = (NETDEV_DOOR_EVENT_BASE + 14),       
    NETDEV_DOOR_EVENT_CLOSE                        = (NETDEV_DOOR_EVENT_BASE + 15),       
    NETDEV_DOOR_EVENT_CLOSE_FAILED                 = (NETDEV_DOOR_EVENT_BASE + 16),       
    NETDEV_DOOR_EVENT_CARD_NO_AUTH                 = (NETDEV_DOOR_EVENT_BASE + 17),       
    NETDEV_DOOR_EVENT_NO_DATE_LIMIT                = (NETDEV_DOOR_EVENT_BASE + 18),       
    NETDEV_DOOR_EVENT_CARD_ILLEGAL                 = (NETDEV_DOOR_EVENT_BASE + 19),       
    NETDEV_DOOR_EVENT_FIREPORTECT_ALRAM            = (NETDEV_DOOR_EVENT_BASE + 20),       
    NETDEV_DOOR_EVENT_CANCEL_FIREPORTECT           = (NETDEV_DOOR_EVENT_BASE + 21),       
    NETDEV_DOOR_EVENT_PRYING_RESIST_ALRAM          = (NETDEV_DOOR_EVENT_BASE + 22),       
    NETDEV_DOOR_EVENT_SUPERPASSWD_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 23),       
    NETDEV_DOOR_EVENT_COERCECODE_IN                = (NETDEV_DOOR_EVENT_BASE + 24),       
    NETDEV_DOOR_EVENT_DOOR_STATUS_OPEN             = (NETDEV_DOOR_EVENT_BASE + 25),       
    NETDEV_DOOR_EVENT_DOOR_STATUS_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 26),       
    NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN             = (NETDEV_DOOR_EVENT_BASE + 27),       
    NETDEV_DOOR_EVENT_DOOR_KEEP_OPEN               = (NETDEV_DOOR_EVENT_BASE + 28),       
    NETDEV_DOOR_EVENT_LOCK_FAILURE                 = (NETDEV_DOOR_EVENT_BASE + 29),       
    NETDEV_DOOR_EVENT_LOST_STOLEN_CARD             = (NETDEV_DOOR_EVENT_BASE + 30),       

    
    NETDEV_DOOR_EVENT_PASSWD_WRONG                 = (NETDEV_DOOR_EVENT_BASE + 31),       
    NETDEV_DOOR_EVENT_ALWAYS_CLOSED                = (NETDEV_DOOR_EVENT_BASE + 32),       
    NETDEV_DOOR_EVENT_CARD_PASSWD_ENTER            = (NETDEV_DOOR_EVENT_BASE + 33),       
    NETDEV_DOOR_EVENT_CARD_PASSWD_WRONG            = (NETDEV_DOOR_EVENT_BASE + 34),       
    NETDEV_DOOR_EVENT_MORE_CARD_OPEN               = (NETDEV_DOOR_EVENT_BASE + 35),       
    NETDEV_DOOR_EVENT_FIRST_CARD_OPEN              = (NETDEV_DOOR_EVENT_BASE + 36),       
    NETDEV_DOOR_EVENT_CARD_OUT_DATE                = (NETDEV_DOOR_EVENT_BASE + 37),       
    NETDEV_DOOR_EVENT_CARD_WATCH                   = (NETDEV_DOOR_EVENT_BASE + 38),       

     
    NETDEV_DOOR_EVENT_REMOTE_CLOSE_DOOR            = (NETDEV_DOOR_EVENT_BASE + 39),       
    NETDEV_DOOR_EVENT_REMOTE_ALWAYS_OPEN           = (NETDEV_DOOR_EVENT_BASE + 40),       
    NETDEV_DOOR_EVENT_REMOTE_ALWAYS_CLOSE          = (NETDEV_DOOR_EVENT_BASE + 41),       
    NETDEV_DOOR_EVENT_LEGAL_CARD_PASS              = (NETDEV_DOOR_EVENT_BASE + 42),       
    NETDEV_DOOR_EVENT_CARD_AND_PSW_PASS            = (NETDEV_DOOR_EVENT_BASE + 43),       
    NETDEV_DOOR_EVENT_CARD_AND_PSW_FAIL            = (NETDEV_DOOR_EVENT_BASE + 44),       
    NETDEV_DOOR_EVENT_CARD_AND_PSW_TIMEOUT         = (NETDEV_DOOR_EVENT_BASE + 45),       
    NETDEV_DOOR_EVENT_CARD_AND_PSW_OVER_TIME       = (NETDEV_DOOR_EVENT_BASE + 46),       
    NETDEV_DOOR_EVENT_INVALID_CARD                 = (NETDEV_DOOR_EVENT_BASE + 47),       
    NETDEV_DOOR_EVENT_DOOR_BUTTON_PRESS            = (NETDEV_DOOR_EVENT_BASE + 48),       
    NETDEV_DOOR_EVENT_DOOR_BUTTON_RELEASE          = (NETDEV_DOOR_EVENT_BASE + 49),       
    NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_ALARM  = (NETDEV_DOOR_EVENT_BASE + 50),       
    NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_RESUME = (NETDEV_DOOR_EVENT_BASE + 51),       
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN             = (NETDEV_DOOR_EVENT_BASE + 52),       
    NETDEV_DOOR_EVENT_DOOR_MAGNET_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 53),       
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_ABNORMAL    = (NETDEV_DOOR_EVENT_BASE + 54),       
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_TIMEOUT     = (NETDEV_DOOR_EVENT_BASE + 55),       
    NETDEV_DOOR_EVENT_ANTI_SNEAK_FAIL              = (NETDEV_DOOR_EVENT_BASE + 56),       
    NETDEV_DOOR_EVENT_INTERLOCK_DOOR_NOT_CLOSE     = (NETDEV_DOOR_EVENT_BASE + 57),       
    NETDEV_DOOR_EVENT_MULTI_VERIFY_SUCCESS         = (NETDEV_DOOR_EVENT_BASE + 58),       
    NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_BEGIN       = (NETDEV_DOOR_EVENT_BASE + 59),       
    NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_END         = (NETDEV_DOOR_EVENT_BASE + 60),       
    NETDEV_DOOR_EVENT_ALWAYS_OPEN_BEGIN            = (NETDEV_DOOR_EVENT_BASE + 61),       
    NETDEV_DOOR_EVENT_ALWAYS_OPEN_END              = (NETDEV_DOOR_EVENT_BASE + 62),       
    NETDEV_DOOR_EVENT_ALWAYS_CLOSE_BEGIN           = (NETDEV_DOOR_EVENT_BASE + 63),       
    NETDEV_DOOR_EVENT_ALWAYS_CLOSE_END             = (NETDEV_DOOR_EVENT_BASE + 64),       
    NETDEV_DOOR_EVENT_KEYPRESS_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 65),       

    
    NETDEV_DOOR_EVENT_COMMU_INTERRUPT              = (NETDEV_DOOR_EVENT_BASE + 81),       
    NETDEV_DOOR_EVENT_COMMU_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 82),       
    NETDEV_DOOR_EVENT_LEGAL_CREDIT_CARD            = (NETDEV_DOOR_EVENT_BASE + 83),       
    NETDEV_DOOR_EVENT_LEGAL_USER_ID                = (NETDEV_DOOR_EVENT_BASE + 84),       /* ID */
    NETDEV_DOOR_EVENT_CARD_NO_REG                  = (NETDEV_DOOR_EVENT_BASE + 85),       
    NETDEV_DOOR_EVENT_CARD_UNAUTH                  = (NETDEV_DOOR_EVENT_BASE + 86),       
    NETDEV_DOOR_EVENT_CARD_DISABLED                = (NETDEV_DOOR_EVENT_BASE + 87),       
    NETDEV_DOOR_EVENT_CARD_EXPIRED                 = (NETDEV_DOOR_EVENT_BASE + 88),       
    NETDEV_DOOR_EVENT_INVALID_TIME                 = (NETDEV_DOOR_EVENT_BASE + 89),       
    NETDEV_DOOR_EVENT_PSW_ERROR                    = (NETDEV_DOOR_EVENT_BASE + 90),       
    NETDEV_DOOR_EVENT_PROHIBITED                   = (NETDEV_DOOR_EVENT_BASE + 91),       
    NETDEV_DOOR_EVENT_REQ_CENTER_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 92),       
    NETDEV_DOOR_EVENT_LEGAL_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 93),       
    NETDEV_DOOR_EVENT_SUPER_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 94),       
    NETDEV_DOOR_EVENT_CENTER_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 96),       
    NETDEV_DOOR_EVENT_LINK_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 97),       
    NETDEV_DOOR_EVENT_FORCE_OPEN_DOOR              = (NETDEV_DOOR_EVENT_BASE + 98),       
    NETDEV_DOOR_EVENT_DOOR_IS_OPEN                 = (NETDEV_DOOR_EVENT_BASE + 99),       
    NETDEV_DOOR_EVENT_DOOR_IS_CLOSE                = (NETDEV_DOOR_EVENT_BASE + 100),      
    NETDEV_DOOR_EVENT_STRESS_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 103),      
    NETDEV_DOOR_EVENT_TRAILING_ALARM               = (NETDEV_DOOR_EVENT_BASE + 105),      
    NETDEV_DOOR_EVENT_DOOR_LOCK                    = (NETDEV_DOOR_EVENT_BASE + 106),      
    NETDEV_DOOR_EVENT_LIFT_DOOR_LOCK               = (NETDEV_DOOR_EVENT_BASE + 107),      
    NETDEV_DOOR_EVENT_DOOR_NOT_CLOSE               = (NETDEV_DOOR_EVENT_BASE + 108),      
    NETDEV_DOOR_EVENT_NEED_PSW                     = (NETDEV_DOOR_EVENT_BASE + 109),      
    NETDEV_DOOR_EVENT_NEED_FINGERPRINT             = (NETDEV_DOOR_EVENT_BASE + 110),      
    NETDEV_DOOR_EVENT_REQ_INTERCOM                 = (NETDEV_DOOR_EVENT_BASE + 111),      
    NETDEV_DOOR_EVENT_EMERGENCY                    = (NETDEV_DOOR_EVENT_BASE + 112),      
    NETDEV_DOOR_EVENT_PATROL_LEGAL_CREDIT_CARD     = (NETDEV_DOOR_EVENT_BASE + 113),      
    NETDEV_DOOR_EVENT_PATROL_LEGAL_FINGERPRINT     = (NETDEV_DOOR_EVENT_BASE + 114),      
    NETDEV_DOOR_EVENT_PATROL_CARD_NOT_REG          = (NETDEV_DOOR_EVENT_BASE + 115),      
    NETDEV_DOOR_EVENT_NOT_PATROL_CARD              = (NETDEV_DOOR_EVENT_BASE + 116),      
    NETDEV_DOOR_EVENT_NORMAL_PATROL                = (NETDEV_DOOR_EVENT_BASE + 117),      
    NETDEV_DOOR_EVENT_ADVANCE_PATROL               = (NETDEV_DOOR_EVENT_BASE + 118),      
    NETDEV_DOOR_EVENT_TIMEOUT_PATROL               = (NETDEV_DOOR_EVENT_BASE + 119),      
    NETDEV_DOOR_EVENT_INVALID_PATROL               = (NETDEV_DOOR_EVENT_BASE + 120),      
    NETDEV_DOOR_EVENT_NOT_PATROL                   = (NETDEV_DOOR_EVENT_BASE + 121),      
    NETDEV_DOOR_EVENT_TH_ALARM                     = (NETDEV_DOOR_EVENT_BASE + 122),      
    NETDEV_DOOR_EVENT_TH_RESTORE                   = (NETDEV_DOOR_EVENT_BASE + 123),      
    NETDEV_DOOR_EVENT_TH_RECORD                    = (NETDEV_DOOR_EVENT_BASE + 124),      
    NETDEV_DOOR_EVENT_SMOKE_ALARM                  = (NETDEV_DOOR_EVENT_BASE + 125),      
    NETDEV_DOOR_EVENT_SMOKE_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 126),      
    NETDEV_DOOR_EVENT_SMOKE_RECORD                 = (NETDEV_DOOR_EVENT_BASE + 127),      

    
    NETDEV_DOOR_EVENT_PC_CONTROL                   = (NETDEV_DOOR_EVENT_BASE + 128),      /*  */
    NETDEV_DOOR_EVENT_LIMITED_CARD_NUM             = (NETDEV_DOOR_EVENT_BASE + 129),      /*  */
    NETDEV_DOOR_EVENT_REASON_UNKNOWN               = (NETDEV_DOOR_EVENT_BASE + 130),      /*  */
    NETDEV_DOOR_EVENT_CONTROLLER_ON                = (NETDEV_DOOR_EVENT_BASE + 131),      
    NETDEV_DOOR_EVENT_CONTROLLER_RESERT            = (NETDEV_DOOR_EVENT_BASE + 132),      
    NETDEV_DOOR_EVENT_DOOR_FORCE_CLOSE             = (NETDEV_DOOR_EVENT_BASE + 133),      
    NETDEV_DOOR_EVENT_DOOR_OFFLINE                 = (NETDEV_DOOR_EVENT_BASE + 134),      
    NETDEV_DOOR_EVENT_FIRE                         = (NETDEV_DOOR_EVENT_BASE + 135),      
    NETDEV_DOOR_EVENT_CALL_EMERGENCY               = (NETDEV_DOOR_EVENT_BASE + 136),      
    NETDEV_DOOR_PERSON_FACE_DOOR                   = (NETDEV_DOOR_EVENT_BASE + 137),      
    NETDEV_DOOR_PERSON_INVALE_DOOR                 = (NETDEV_DOOR_EVENT_BASE + 138),      

    
    NETDEV_DOOR_EVENT_FINGERPRINT_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 153),      
    NETDEV_DOOR_EVENT_ANTI_SUBMARINE               = (NETDEV_DOOR_EVENT_BASE + 154),      
    NETDEV_DOOR_EVENT_PRESS_MISTAKE                = (NETDEV_DOOR_EVENT_BASE + 155),      
    NETDEV_DOOR_EVENT_PF_PW_RF_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 156),      

    
    NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN_CLEARED     = (NETDEV_DOOR_EVENT_BASE + 157),      

    
    NETDEV_DOOR_EVENT_BLACKLIST                    = (NETDEV_DOOR_EVENT_BASE + 158),      
    NETDEV_DOOR_EVENT_FAILED_SEND_CMD              = (NETDEV_DOOR_EVENT_BASE + 159),      
    NETDEV_DOOR_EVENT_FAILED_OPEN_DOOE_MU_CARD     = (NETDEV_DOOR_EVENT_BASE + 160),      
    NETDEV_DOOR_EVENT_CARD_INVALID_PERIOD          = (NETDEV_DOOR_EVENT_BASE + 161),       
    NETDEV_DOOR_EVENT_CARD_REPORT_LOST             = (NETDEV_DOOR_EVENT_BASE + 162),      
    NETDEV_DOOR_EVENT_TAMPER_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 163),       
    NETDEV_DOOR_EVENT_SWIPE_CARD_WHEN_NORMAL_OPEN  = (NETDEV_DOOR_EVENT_BASE + 164),       
    NETDEV_DOOR_EVENT_OPEN_DOOR_BY_EMERGENCY_PWD   = (NETDEV_DOOR_EVENT_BASE + 165),       
    NETDEV_DOOR_EVENT_OPEN_DOOR_WHEN_NORMAL_OPEN   = (NETDEV_DOOR_EVENT_BASE + 166),       
    NETDEV_DOOR_EVENT_EXIT_BUTTON_DURING_ILLEGAL_PERIOD  = (NETDEV_DOOR_EVENT_BASE + 167), 
    NETDEV_DOOR_EVENT_DOOR_ALREADY_OPEN            = (NETDEV_DOOR_EVENT_BASE + 168),       
    NETDEV_DOOR_EVENT_DOOR_ALREADY_CLOSE           = (NETDEV_DOOR_EVENT_BASE + 169),       
    NETDEV_DOOR_EVENT_ILLEGAL_PERIOD               = (NETDEV_DOOR_EVENT_BASE + 170),       
    NETDEV_DOOR_EVENT_OPEN_DOOR_BY_DURESS_PWD      = (NETDEV_DOOR_EVENT_BASE + 171),       
    NETDEV_DOOR_EVENT_NO_MASK                      = (NETDEV_DOOR_EVENT_BASE + 172),       
    NETDEV_DOOR_EVENT_BODY_TEMPERATURE             = (NETDEV_DOOR_EVENT_BASE + 173),       
    NETDEV_DOOR_EVENT_M0NITOR_INPUT_ACTIVATED      = (NETDEV_DOOR_EVENT_BASE + 174),       
    NETDEV_DOOR_EVENT_M0NITOR_INPUT_CLEAR          = (NETDEV_DOOR_EVENT_BASE + 175),       

    NETDEV_DOOR_EVENT_END                          = (NETDEV_DOOR_EVENT_BASE + 599),      

#define NETDEV_IS_DOOR_EVENT(x)    (NETDEV_DOOR_EVENT_BASE <= (x) && (x) < NETDEV_DOOR_EVENT_END)
    NETDEV_ALARM_SUB_TYPE_INVALID                  = 0x7FFFFFFF                           
}NETDEV_ALARM_SUBTYPE_E;

/**
 * @enum tagNETDEVEventResType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVEventResType
{
    NETDEV_EVENT_RES_TYPE_USER                = 0,                
    NETDEV_EVENT_RES_TYPE_DEVICE              = 1,                
    NETDEV_EVENT_RES_TYPE_CHANNEL             = 2,                
    NETDEV_EVENT_RES_TYPE_LOGOUT              = 3,                
    NETDEV_EVENT_RES_TYPE_SEQUENCE            = 4,                /* ID */
    NETDEV_EVENT_RES_TYPE_EMAP_HOTPOT         = 5,                /* ID */
    NETDEV_EVENT_RES_TYPE_EMAP_HOTAREA        = 6,                /* ID */
    NETDEV_EVENT_RES_TYPE_EMAP_ALARM          = 7,                /* ID */
    NETDEV_EVENT_RES_TYPE_TIMETEMPLATE        = 8,                /* ID */
    NETDEV_EVENT_RES_TYPE_SYSRIGHT            = 9,                
    NETDEV_EVENT_RES_TYPE_DEVRIGHT            = 10,               
    NETDEV_EVENT_RES_TYPE_ORG                 = 11,               
    NETDEV_EVENT_RES_TYPE_ALARM_TASK          = 12,               
    NETDEV_EVENT_RES_TYPE_SLAVE               = 13,               
    NETDEV_EVENT_RES_TYPE_TVWALL              = 14,               /* ID */
    NETDEV_EVENT_RES_TYPE_TVWALL_SCENE        = 15,               /* ID */
    NETDEV_EVENT_RES_TYPE_WND                 = 16,               /* ID */
    NETDEV_EVENT_RES_TYPE_VIRTUAL_LED         = 17,               /* LEDLED ID */
    NETDEV_EVENT_RES_TYPE_BROADCAST_CHANGE    = 18,               
    NETDEV_EVENT_RES_TYPE_LOGIC_ORG           = 19,               
    NETDEV_EVENT_RES_TYPE_USER_ROLE           = 20,               
    NETDEV_EVENT_RES_TYPE_ROLE_ORG            = 21,               
    NETDEV_EVENT_RES_TYPE_EMAP_PIC            = 22,               
    NETDEV_EVENT_RES_TYPE_PATROL              = 23,               
    NETDEV_EVENT_RES_TYPE_RECORD              = 24,               
    NETDEV_EVENT_RES_TYPE_ACS_PERSON          = 25,               /* ID */
    NETDEV_EVENT_RES_TYPE_ACS_PERSON_CARD     = 26,               /* ID */
    NETDEV_EVENT_RES_TYPE_TVWALL_LIST         = 27,               
    NETDEV_EVENT_RES_TYPE_TVWALL_SCENE_SWITCH = 28,               

    NETDEV_EVENT_RES_TYPE_FACE_LIB            = 29,               /* ID */
    NETDEV_EVENT_RES_TYPE_FACE_CUSTOM         = 30,               /* ID */
    NETDEV_EVENT_RES_TYPE_FACE_MEMBER         = 31,               /* ID */
    NETDEV_EVENT_RES_TYPE_FACE_GUARD          = 32,               /* ID */
    NETDEV_EVENT_RES_TYPE_SMART_DETECT        = 33,               /* :0 */
    NETDEV_EVENT_RES_TYPE_MANUAL_STATUS       = 34,               
    NETDEV_EVENT_RES_TYPE_VEHICLE_GUARD       = 38,               /* ID */
    NETDEV_EVENT_RES_TYPE_CDN_CHANNEL         = 39,               /* CDN */
    NETDEV_EVENT_RES_TYPE_FACE_MEMBER_SORT    = 40,               /* ID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_LIB         = 41,               /* ID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER_SORT = 42,               /* ID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER      = 43,               /* ID */

    NETDEV_EVENT_RES_TYPE_REMAIN_PARK_SPACE        = 44,          
    NETDEV_EVENT_RES_TYPE_ABNORMAL_CHARGE          = 45,          
    NETDEV_EVENT_RES_TYPE_PARK_RES_CHANGE          = 46,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_PERSON   = 47,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_CAR      = 48,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_BUILDING = 49,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_UNIT     = 50,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ROOM     = 51,          
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ORG      = 52,          
    NETDEV_EVENT_RES_TYPE_TEMP_VEHICLE_PAY_CHANGE  = 53,          
    NETDEV_EVENT_RES_TYPE_THIRDPART_PAYMENT        = 54,          
    NETDEV_EVENT_RES_TYPE_PAYMENT_WAIT             = 55,          
    NETDEV_EVENT_RES_TYPE_ENTRANCE_LIST            = 56,          
    NETDEV_EVENT_RES_TYPE_VIEWPLAN_RES             = 57,          /* ID */
    NETDEV_EVENT_RES_TYPE_SCENESPLAN_RES           = 58,          /* ID */
    NETDEV_EVENT_RES_TYPE_ACS_PERMISSION           = 59,          /* ,  */
    NETDEV_EVENT_RES_TYPE_ACS_GROUP                = 60,          
    NETDEV_EVENT_RES_TYPE_TVWALL_AUDIO             = 61,          
    NETDEV_EVENT_RES_TYPE_PAYMENT_RRULE            = 62,          
    NETDEV_EVENT_RES_TYPE_GIS                      = 63,          
    NETDEV_EVENT_RES_TYPE_INVALID                  = 0xFF         
}NETDEV_EVENT_RES_TYPE_E;

/**
 * @enum tagNETDEVRecordSearchType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVRecordSearchType
{
    NETDEV_RECORD_SEARCH_TYPE_ALL                       = 0x00000000,               
    NETDEV_RECORD_SEARCH_TYPE_MANUL                     = 0x00000001,               
    NETDEV_RECORD_SEARCH_TYPE_EVENT                     = 0x00000002,               /* NVR */
    NETDEV_RECORD_SEARCH_TYPE_MOTION                    = 0x00000004,               
    NETDEV_RECORD_SEARCH_TYPE_ALARMIN                   = 0x00000008,               
    NETDEV_RECORD_SEARCH_TYPE_VIDEO_LOSS                = 0x00000010,               
    NETDEV_RECORD_SEARCH_TYPE_AUDIO_DETECT              = 0x00000020,               

    NETDEV_RECORD_SEARCH_TYPE_COMMON                    = 0x00000080,               
    NETDEV_RECORD_SEARCH_TYPE_FACE_DETECT               = 0x00000100,               
    NETDEV_RECORD_SEARCH_TYPE_LINE_DETECT               = 0x00000200,               
    NETDEV_RECORD_SEARCH_TYPE_FIELD_DETECT              = 0x00000400,               
    NETDEV_RECORD_SEARCH_TYPE_FOCUS_DETECT              = 0x00000800,               
    NETDEV_RECORD_SEARCH_TYPE_SCENE_CHANGE              = 0x00001000,               
    NETDEV_RECORD_SEARCH_TYPE_SMART_TRACK               = 0x00002000,               

    NETDEV_RECORD_SEARCH_TYPE_URGENT_BELL               = 0x00004000,               
    NETDEV_RECORD_SEARCH_TYPE_REMAIN_ARTICLE            = 0x00020000,               
    NETDEV_RECORD_SEARCH_TYPE_MOVE_ARTICLE              = 0x00040000,               

    NETDEV_RECORD_SEARCH_TYPE_HUMAN_DETECT              = 0x00200000,               
    NETDEV_RECORD_SEARCH_TYPE_ELEVATOR_ENTRANCE_DETECT  = 0x20000000,               
    NETDEV_RECORD_SEARCH_TYPE_SMART_RECORD              = 0x20263F20,               /*   0010 0000 0010 0110 0011 1111 0010 0000*/

    NETDEV_RECORD_SEARCH_TYPE_INVALID                   = 0XFFFFFFFF                
}NETDEV_RECORD_SEARCH_TYPE_E;

/**
 * @enum tagNETDEVAddressType
 * @brief IP
 * @attention  None
 */
typedef enum tagNETDEVAddressType
{
    NETDEV_ADDRESS_TYPE_IPV4                    = 0,               /* IPV4 */
    NETDEV_ADDRESS_TYPE_IPV6                    = 1,               /* IPV6 */
    NETDEV_ADDRESS_TYPE_DOMAIN                  = 2,               
    NETDEV_ADDRESS_TYPE_IPV4_IPV6               = 3,               /* IPV4IPV6 */
    NETDEV_ADDRESS_TYPE_INVALID                 = 0xFF             
}NETDEV_ADDRESS_TYPE_E;

/**
* @enum tagNETDEVVehicleMonitorType
* @brief   monitor type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleMonitorType
{
    NETDEV_VEHICLE_MONITOR_TYPE_ROB_E         = 0,           
    NETDEV_VEHICLE_MONITOR_TYPE_STEAL_E       = 1,           
    NETDEV_VEHICLE_MONITOR_TYPE_SUSPICION_E   = 2,           
    NETDEV_VEHICLE_MONITOR_TYPE_ILLEGAL_E     = 3,           
    NETDEV_VEHICLE_MONITOR_TYPE_SUREILLANCE_E = 4,           
    NETDEV_VEHICLE_MONITOR_TYPE_ALL_E         = 255,         
    NETDEV_VEHICLE_MONITOR_TYPE_INVALID       = 0xFFFF       /*   Invalid value */
}NETDEV_VEHICLE_MONITOR_TYPE_E;

/**
* @enum tagNETDEVPlateColor
* @brief   plate color Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVPlateColor
{
    NETDEV_PLATE_COLOR_BLACK_E           = 0,           
    NETDEV_PLATE_COLOR_WHITE_E           = 1,           
    NETDEV_PLATE_COLOR_GRAY_E            = 2,           
    NETDEV_PLATE_COLOR_RED_E             = 3,           
    NETDEV_PLATE_COLOR_BLUE_E            = 4,           
    NETDEV_PLATE_COLOR_YELLOW_E          = 5,           
    NETDEV_PLATE_COLOR_ORANGE_E          = 6,           
    NETDEV_PLATE_COLOR_BROWN_E           = 7,           
    NETDEV_PLATE_COLOR_GREEN_E           = 8,           
    NETDEV_PLATE_COLOR_PURPLE_E          = 9,           
    NETDEV_PLATE_COLOR_CYAN_E            = 10,          
    NETDEV_PLATE_COLOR_PINK_E            = 11,          
    NETDEV_PLATE_COLOR_TRANSPARENT_E     = 12,          
    NETDEV_PLATE_COLOR_SILVERYWHITE_E    = 13,          
    NETDEV_PLATE_COLOR_DARK_E            = 14,          
    NETDEV_PLATE_COLOR_LIGHT_E           = 15,          
    NETDEV_PLATE_COLOR_COLOURLESS        = 16,          
    NETDEV_PLATE_COLOR_YELLOWGREEN       = 17,          
    NETDEV_PLATE_COLOR_GRADUALGREEN      = 18,          
    NETDEV_PLATE_COLOR_OTHER_E           = 99,          
    NETDEV_PLATE_COLOR_UNKNOW_E          = 100,         
    NETDEV_PLATE_COLOR_INVALID           = 0xFF         /*   Invalid value */
}NETDEV_PLATE_COLOR_E;

/**
* @enum tagNETDEVPlateType
* @brief   plate type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVPlateType
{
    NETDEV_PLATE_TYPE_BIG_CAR_E                   = 0,           
    NETDEV_PLATE_TYPE_MINI_CAR_E                  = 1,           
    NETDEV_PLATE_TYPE_EMBASSY_CAR_E               = 2,           
    NETDEV_PLATE_TYPE_CONSULATE_CAR_E             = 3,           
    NETDEV_PLATE_TYPE_OVERSEAS_CAR_E              = 4,           
    NETDEV_PLATE_TYPE_FOREIGN_CAR_E               = 5,           
    NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E          = 6,           
    NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E       = 7,           
    NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E         = 8,           
    NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E       = 9,           
    NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E        = 10,          
    NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E         = 11,          
    NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E             = 12,          
    NETDEV_PLATE_TYPE_TRACTOR_E                   = 13,          
    NETDEV_PLATE_TYPE_TRAILER_E                   = 14,          
    NETDEV_PLATE_TYPE_COACH_CAR_E                 = 15,          
    NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E           = 16,          
    NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E       = 17,          
    NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E = 18,          
    NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E         = 19,          
    NETDEV_PLATE_TYPE_POLICE_CAR_E                = 20,          
    NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E          = 21,          
    NETDEV_PLATE_TYPE_AGRICULTURAL_E              = 22,          
    NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E       = 23,          
    NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E          = 24,          
    NETDEV_PLATE_TYPE_ARMED_POLICE_E              = 25,          
    NETDEV_PLATE_TYPE_ARMY_E                      = 26,          
    NETDEV_PLATE_TYPE_OTHER_E                     = 99,          
    NETDEV_PLATE_TYPE_INVALID                     = 0xFF         
}NETDEV_PLATE_TYPE_E;

/**
* @enum tagNETDEVVehicleColor
* @brief   plate color Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleColor
{
    NETDEV_VEHICLE_COLOR_BLACK_E          = 0,        
    NETDEV_VEHICLE_COLOR_WHITE_E          = 1,        
    NETDEV_VEHICLE_COLOR_GRAY_E           = 2,        
    NETDEV_VEHICLE_COLOR_RED_E            = 3,        
    NETDEV_VEHICLE_COLOR_BLUE_E           = 4,        
    NETDEV_VEHICLE_COLOR_YELLOW_E         = 5,        
    NETDEV_VEHICLE_COLOR_ORANGE_E         = 6,        
    NETDEV_VEHICLE_COLOR_BROWN_E          = 7,        
    NETDEV_VEHICLE_COLOR_GREEN_E          = 8,        
    NETDEV_VEHICLE_COLOR_PURPLE_E         = 9,        
    NETDEV_VEHICLE_COLOR_CYAN_E           = 10,       
    NETDEV_VEHICLE_COLOR_PINK_E           = 11,       
    NETDEV_VEHICLE_COLOR_TRANSPARENT_E    = 12,       
    NETDEV_VEHICLE_COLOR_SILVERY_WHITE_E  = 13,       
    NETDEV_VEHICLE_COLOR_DARK_E           = 14,       
    NETDEV_VEHICLE_COLOR_TINT_E           = 15,       
    NETDEV_VEHICLE_COLOR_COLOURLESS_E     = 16,       
    NETDEV_VEHICLE_COLOR_OLIVINE_E        = 17,       
    NETDEV_VEHICLE_COLOR_GRADIENT_GREEN_E = 18,       
    NETDEV_VEHICLE_COLOR_OTHER_E          = 99,       
    NETDEV_VEHICLE_COLOR_UNKNOWN_E        = 100,      
    NETDEV_VEHICLE_COLOR_INVALID          = 0xFF      
}NETDEV_VEHICLE_COLOR_E;

/**
* @enum tagNETDEVVehicleType
* @brief   plate type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleType
{
    NETDEV_VEHICLE_TYPE_TRICYCLE_E       = 0,                
    NETDEV_VEHICLE_TYPE_MOTOR_BUS_E      = 1,                
    NETDEV_VEHICLE_TYPE_MIDDLE_E         = 2,                
    NETDEV_VEHICLE_TYPE_SMALL_E          = 3,                
    NETDEV_VEHICLE_TYPE_BIG_E            = 4,                
    NETDEV_VEHICLE_TYPE_TWOWHEELVEH      = 5,                
    NETDEV_VEHICLE_TYPE_MOTORCYCLE_E     = 6,                
    NETDEV_VEHICLE_TYPE_TRACTOR_E        = 7,                
    NETDEV_VEHICLE_TYPE_AGRICULTURAL_E   = 8,                
    NETDEV_VEHICLE_TYPE_SEADAN           = 9,                
    NETDEV_VEHICLE_TYPE_SUV_E            = 10,               /* SUV */
    NETDEV_VEHICLE_TYPE_VAN_E            = 11,               
    NETDEV_VEHICLE_TYPE_SMALLTRUCK_E     = 12,               
    NETDEV_VEHICLE_TYPE_MEDIUMCAR_E      = 13,               /* / */
    NETDEV_VEHICLE_TYPE_LARGEBUS_E       = 14,               /* / */
    NETDEV_VEHICLE_TYPE_LARGETRUCK_E     = 15,               /* / */
    NETDEV_VEHICLE_TYPE_PICKUPTRUCK_E    = 16,               
    NETDEV_VEHICLE_TYPE_BUSINESSVEH_E    = 17,               /* MPV  */
    NETDEV_VEHICLE_TYPE_SPORTSCAR_E      = 18,               
    NETDEV_VEHICLE_TYPE_MINICAR_E        = 19,               
    NETDEV_VEHICLE_TYPE_HATCHBACKCAR_E   = 20,               
    NETDEV_VEHICLE_TYPE_THREEBOX_E       = 21,               
    NETDEV_VEHICLE_TYPE_LIGHTBUS_E       = 22,               
    NETDEV_VEHICLE_TYPE_MEDIUNTRUCK_E    = 23,               
    NETDEV_VEHICLE_TYPE_TRAILER_E        = 24,               
    NETDEV_VEHICLE_TYPE_TANK_E           = 25,               
    NETDEV_VEHICLE_TYPE_WATERCAR_E       = 26,               
    NETDEV_VEHICLE_TYPE_OTHER_E          = 998,              
    NETDEV_VEHICLE_TYPE_UNKNOW_E         = 999,              
    NETDEV_VEHICLE_TYPE_INDISTINGUISH_E  = 1000,             
    NETDEV_VEHICLE_TYPE_INVALID          = 0xFFFF            
}NETDEV_VEHICLE_TYPE_E;

/**
* @enum tagNETDEVVehicleSpeedUnit
* @brief   vehicle speed unit Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleSpeedUnit
{
    NETDEV_VEHICLE_SPEED_UNIT_KPH_E   = 0,              /* / */
    NETDEV_VEHICLE_SPEED_UNIT_MPH_E   = 1,              /* / */
    NETDEV_VEHICLE_SPEED_UNIT_INVALID = 0xFF            /*   Invalid value */
}NETDEV_VEHICLE_SPEED_UNIT_E;

/**
 * @enum tagNETDEVAlarmType
 * @brief    Alarm Type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeLAPI
{
/*               IPC&VMS                                           */
  NETDEV_MOTION_ALARM_ON                        = 0,    
  NETDEV_MOTION_ALARM_OFF                       = 1,    
  NETDEV_MASK_IMAGE_ALARM_ON                    = 2,    
  NETDEV_MASK_IMAGE_ALARM_OFF                   = 3,    
  NETDEV_ABNORMAL_AUDIO_ON                      = 4,    
  NETDEV_ABNORMAL_AUDIO_OFF                     = 5,    
  NETDEV_LINE_DETECTOR_CROSSED                  = 6,    
  NETDEV_FIELD_DETECTOR_OBJECTS_INSIDE          = 7,    
  NETDEV_OBJECT_IS_RECOGNIZED                   = 8,    
  NETDEV_GLOBAL_SCENE_CHANGE                    = 9,    
  NETDEV_IMAGE_TOO_BLURRY_ON                    = 10,   
  NETDEV_IMAGE_TOO_BLURRY_OFF                   = 11,   
  NETDEV_INPUT_ALARM_ON                         = 12,   
  NETDEV_INPUT_ALARM_OFF                        = 13,   

  NETDEV_ENTER_AREA                             = 100,  
  NETDEV_LEAVE_AREA                             = 101,  
  NETDEV_LOITERING                              = 102,  
  NETDEV_FENCE_CROSSING                         = 103,  
  NETDEV_OBJECT_REMOVED                         = 104,  
  NETDEV_OBJECT_LEFT_BEHIND                     = 105,  
  NETDEV_PEOPLE_GATHERING                       = 106,  
  NETDEV_PEOPLE_GATHERING_CLEARED               = 107,  
  NETDEV_FAST_MOVING                            = 108,  
  NETDEV_PARKING                                = 109,  
  NETDEV_HEAT_MAP                               = 110,  
  NETDEV_AUTO_SMART_TRACK_ON                    = 111,  
  NETDEV_AUTO_SMART_TRACK_OFF                   = 112,  

  NETDEV_DISK_OFFLINE                           = 201,  
  NETDEV_DISK_ABNORMAL                          = 202,  
  NETDEV_ILLEGAL_LOGIN                          = 203,  
  NETDEV_NETWORK_DISCONNECTED                   = 204,  
  NETDEV_NETWORK_DISCONNECTED_CLEARED           = 205,  
  NETDEV_IP_CONFLICT                            = 206,  /* IP */
  NETDEV_IP_CONFLICT_CLEARED                    = 207,  /* IP */
  NETDEV_STORAGE_FAILURE                        = 208,  
  NETDEV_RUNNING_OUT_OF_RECORDING_SPACE         = 209,  
  NETDEV_RECORDING_SAPCE_USED_UP                = 210,  
  NETDEV_DEVICE_ONLINE                          = 211,  
  NETDEV_DEVICE_OFFLINE                         = 212,  
  NETDEV_RAID_DISABLED                          = 213,  
  NETDEV_DISK_ONLINE                            = 214,  
  NETDEV_RAID_DEGRADED                          = 215,  
  NETDEV_RAID_RECOVERED                         = 216,  
  NETDEV_MANUAL_ALARM                           = 217,  
  NETDEV_VIDEO_LOSS_ALARM_ON                    = 218,  
  NETDEV_VIDEO_LOSS_ALARM_OFF                   = 219,  
  NETDEV_SCHEDULED_RECORDING_FAILURE            = 220,  
  NETDEV_SCHEDULED_RECORDING_FAILURE_CLEARED    = 221,  
  NETDEV_IPC_ONLINE                             = 222,  
  NETDEV_IPC_OFFLINE                            = 223,  
  NETDEV_CHANNEL_DELETED                        = 224,  
  NETDEV_CONTROL_PANEL_ALARM                    = 225,  
  NETDEV_ACCESS_CONTROL_ALARM                   = 226,  
  /* Smart */
  NETDEV_SMART_READ_ERROR_RATE                  = 227,  
  NETDEV_SMART_SPIN_UP_TIME                     = 228,  
  NETDEV_SMART_START_STOP_COUNT                 = 229,  
  NETDEV_SMART_REALLOCATED_SECTOR_COUNT         = 230,  
  NETDEV_SMART_SEEK_ERROR_RATE                  = 231,  
  NETDEV_SMART_POWER_ON_HOURS                   = 232,  
  NETDEV_SMART_SPIN_RETRY_COUNT                 = 233,  
  NETDEV_SMART_CALIBRATION_RETRY_COUNT          = 234,  
  NETDEV_SMART_POWER_CYCLE_COUNT                = 235,  
  NETDEV_SMART_POWEROFF_RETRACT_COUNT           = 236,  
  NETDEV_SMART_LOAD_CYCLE_COUNT                 = 237,  
  NETDEV_SMART_TEMPERATURE_CELSIUS              = 238,  
  NETDEV_SMART_REALLOCATED_EVENT_COUNT          = 239,  
  NETDEV_SMART_CURRENT_PENDING_SECTOR           = 240,  
  NETDEV_SMART_OFFLINE_UNCORRECTABLE            = 241,  
  NETDEV_SMART_UDMA_CRC_ERROR_COUNT             = 242,  
  NETDEV_SMART_MULTI_ZONE_ERROR_RATE            = 243,  
  NETDEV_SMART_FACE_NOT_MATCH_ALARM             = 244,  
  NETDEV_SMART_FACE_MATCH_ALARM                 = 245,  
  NETDEV_DEVICE_HIGHTEMP_ALARM                  = 246,  /*  */
  NETDEV_DEVICE_LOWTEMP_ALARM                   = 247,  /*  */
  NETDEV_FAN_FAULT_ALARM                        = 248,  /*  */
  NETDEV_LEDBOX_HIGHTEMP_ALARM                  = 249,  /*  */
  NETDEV_LEDBOX_SMOKE_ALARM                     = 250,  /*  */
  NETDEV_DEVICE_HIGHTEMP_RECOVER_ALARM          = 251,  /* : */
  NETDEV_DEVICE_LOWTEMP_RECOVER                 = 252,  /* : */
  NETDEV_FAN_FAULT_RECOVER                      = 253,  /* : */
  NETDEV_LEDBOX_HIGHTEMP_RECOVER                = 254,  /* : */
  NETDEV_LEDBOX_SMOKE_RECOVER                   = 255,  /* : */
  NETDEV_SMART_BODY_TEMPERATURE                 = 256,  
  NETDEV_SMART_NO_MASK                          = 257,  
  NETDEV_AREA_PEOPLE_COUNT_ALARM                = 258,  
  NETDEV_AREA_PEOPLE_COUNT_RECOVER_ALARM        = 259,  

  NETDEV_UNKOWN_TYPE_ALARM                      =0xFFFF 
}NETDEV_ALARM_TYPE_LAPI_E;

/**
* @enum tagNETDEVVideoCodeMode
* @brief    Video encoding Mode Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVideoCodeMode
{
    NETDEV_VIDEO_CODE_MODE_CBR = 0,             
    NETDEV_VIDEO_CODE_MODE_VBR = 1              
}NETDEV_VIDEO_CODE_MODE_E;

/**
* @enum tagNETDEVRecordPlanEnable
* @brief NVR     NVR Record Plan Enable Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVRecordPlanEnable
{
    NETDEV_RECORD_Plan_DISABLE = 0,             
    NETDEV_RECORD_Plan_ENABLE  = 1              
}NETDEV_RECORD_Plan_ENABLE_E;

/**
* @enum tagNETDEVRedundantStorage
* @brief NVR     NVR Redundant Storage Plan Enable Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVRedundantStorage
{
    NETDEV_REDUNDANT_STORAGE_DISABLE = 0,             
    NETDEV_REDUNDANT_STORAGE_ENABLE  = 1              
}NETDEV_REDUNDANT_STORAGE_ENABLE_E; 

/**
* @enum tagNETDEVMemResolution
* @brief 
* @attention   player_sdk_func.h PLAYER_DECODE_RESOLUTION_E  
*/
typedef enum tagNETDEVMemResolution
{
    NETDEV_MEM_RESOLUTION_CIF       = 0,                        /* CIF */
    NETDEV_MEM_RESOLUTION_2CIF      = 1,                        /* 2CIF */
    NETDEV_MEM_RESOLUTION_D1        = 2,                        /* D1 */
    NETDEV_MEM_RESOLUTION_720P      = 3,                        /* 720P */
    NETDEV_MEM_RESOLUTION_1080P     = 4,                        /* 1080P */
    NETDEV_MEM_RESOLUTION_4M        = 5,                        /* 4M */
    NETDEV_MEM_RESOLUTION_8M        = 6,                        /* 8M */
    NETDEV_MEM_RESOLUTION_12M       = 7,                        /* 12M */
    NETDEV_MEM_RESOLUTION_MAX
}NETDEV_MEM_RESOLUTION_E;

/**
* @enum tagNETDEVMemPayload
* @brief 
* @attention  player_sdk_func.h PLAYER_DECODE_PAYLOAD_E  
*/
typedef enum tagNETDEVMemPayload
{
    NETDEV_MEM_PAYLOAD_H264         = 0,                           /* H264 */
    NETDEV_MEM_PAYLOAD_H265         = 1,                           /* H265 */
    NETDEV_MEM_PAYLOAD_INVALID      = 0xff
}NETDEV_MEM_PAYLOAD_E;

/**
 * @enum tagNETDEVPLanStoreType
 * @brief   Recording storage type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPLanStoreType
{
    NETDEV_STORE_TYPE_COMMON                        = 0,                  
    NETDEV_STORE_TYPE_DIGITIALINPUT                 = 1,                
    NETDEV_STORE_TYPE_MANUL                         = 2,                
    NETDEV_STORE_TYPE_AUDIODETECT                   = 3,                
    NETDEV_STORE_TYPE_MOTION                        = 4,                
    NETDEV_STORE_TYPE_DIGITALINPUT                  = 5,                /*   Digital input */
    NETDEV_STORE_TYPE_FACEDETECT                    = 6,                
    NETDEV_STORE_TYPE_VIDEO_LOSS                    = 7,                
    NETDEV_STORE_TYPE_LINEDETECT                    = 8,                
    NETDEV_STORE_TYPE_FIELDDETECT                   = 9,                
    NETDEV_STORE_TYPE_FOCUSDETECT                   = 10,               
    NETDEV_STORE_TYPE_SCENECHANGE                   = 11,               
    NETDEV_STORE_TYPE_ALARM                         = 12,               
    NETDEV_STORE_TYPE_ALARM_AND_MOTION              = 13,               
    NETDEV_STORE_TYPE_ALARM_OR_MOTION               = 14,               
    NETDEV_STORE_TYPE_CAMERA_DISCONNECT             = 15,               
    NETDEV_STORE_TYPE_THIRD_STREAM                  = 16,               
    NETDEV_STORE_TYPE_EVENT_ALL_ALARM               = 17,               
    NETDEV_STORE_TYPE_EVENT_ALL_TYPE                = 18,               
    NETDEV_PLAN_STORE_TYPE_EVENT_WITHOUT_RESUME     = 19,               
    NETDEV_STORE_TYPE_SMART_TRACK                   = 20,               
    NETDEV_STORE_TYPE_URGENT_BELL                   = 21,               
    NETDEV_STORE_TYPE_REMAIN_ARTICLE                = 22,               
    NETDEV_STORE_TYPE_MOVE_ARTICLE                  = 23,               
    NETDEV_STORE_TYPE_SMART_RECORD                  = 24,               
    NETDEV_PLAN_STORE_TYPE_MAX                      = 25,               
    NETDEV_STORE_TYPE_HUMAN_DETECT                  = 26,               
    NETDEV_STORE_TYPE_ELEVATOR_ENTRANCE_DETECT      = 27,               
    NETDEV_STORE_TYPE_INVALID                       = 0xFF              
}NETDEV_STORE_TYPE_E;

/**
* @enum tagNETDEVMenSystem
* @brief 
* @attention  player_sdk_func.h PLAYER_DECODE_SYSTYPE_E  
*/
typedef enum tagNETDEVMenSystem
{
    NETDEV_SYSTEM_WIN7      = 0,                    /* WIN7 */
    NETDEV_SYSTEM_WIN8      = 1,                    /* WIN8 */
    NETDEV_SYSTEM_WIN10     = 2                     /* WIN10 */
}NETDEV_MEM_SYSTEM_E;

/**
* @enum tagNETDEVEventStoreType
* @brief  
* @attention gaRecordType
*/
typedef enum tagNETDEVEventStoreType
{
    NETDEV_EVENT_STORE_FIND_TYPE_NORMAL             = 1,      
    NETDEV_EVENT_STORE_FIND_TYPE_MOTIONDETEC        = 2,      
    NETDEV_EVENT_STORE_FIND_TYPE_DIGITIALINPUT      = 3,      
    NETDEV_EVENT_STORE_FIND_TYPE_MANUAL             = 4,      
    NETDEV_EVENT_STORE_FIND_TYPE_SIGNALLOSS         = 5,      
    NETDEV_EVENT_STORE_FIND_TYPE_AUDIODETECT        = 6,      
    NETDEV_EVENT_STORE_FIND_TYPE_FACEDETECT         = 7,      
    NETDEV_EVENT_STORE_FIND_TYPE_LINEDETECT         = 8,      
    NETDEV_EVENT_STORE_FIND_TYPE_FIELDDETECT        = 9,      
    NETDEV_EVENT_STORE_FIND_TYPE_FOCUSDETECT        = 10,     
    NETDEV_EVENT_STORE_FIND_TYPE_SCENECHANGE        = 11,     
    NETDEV_EVENT_STORE_FIND_TYPE_SMARTTRACK         = 12,     
    NETDEV_EVENT_STORE_FIND_TYPE_REMAIN_ARTICLE     = 13,     
    NETDEV_EVENT_STORE_FIND_TYPE_ARTICLE_MOVE       = 14,     
    NETDEV_EVENT_STORE_FIND_TYPE_BUTT
}NETDEV_EVENT_STORE_TYPE_E;

/**
* @enum tagNETDEVSmartStoreType
* @brief  
* @attention NETDEV_EVENT_STORE_TYPE_E
*/
typedef enum tagNETDEVSmartStoreType
{
    NETDEV_SMART_STORE_FIND_TYPE_MOTIONSMART      = 100,   
    NETDEV_SMART_STORE_FIND_TYPE_BUTT
}NETDEV_SMART_STORE_TYPE_E;

/**
* @enum tagNETDEVEventFindLogic
* @brief  
* @attention  None
*/
typedef enum tagNETDEVEventFindLogic
{
    NETDEV_EVENT_FIND_LOGIC_AND = 0,     
    NETDEV_EVENT_FIND_LOGIC_OR  = 1,     
    NETDEV_EVENT_FIND_LOGIC_BUTT
}NETDEV_EVENT_FIND_LOGIC_E;

/**
* @enum tagNETDEVTransportModeType
* @brief  
* @attention 
*/
typedef enum tagNETDEVTransportModeType
{
    NETDEV_TRANSPROTOCAL_RTP_UNICAST    = 0,
    NETDEV_TRANSPROTOCAL_RTP_MULTICAST  = 1,
    NETDEV_TRANSPROTOCAL_RTP_STORE      = 2
}NETDEV_TRANSPORTMODE_E;

/**
* @enum tagNETDEVAudioFlag
* @brief   Audio data type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVAudioFlag
{
    NETDEV_AUDIO_LOCAL_GATHERED = 0,               /*   Locally collected data*/
    NETDEV_AUDIO_DEVICE_SEND    = 1                /*   Audio data sent from device */
} NETDEV_AUDIO_FLAG_E;

/**
* @enum tagNETDEVEventTypeMajor
* @brief   Major types of event Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVEventTypeMajor
{
    NETDEV_EVENT_TYPE_MAJOR_ALARM      = 0,          /*   CORECORE */
    NETDEV_EVENT_TYPE_MAJOR_SYS        = 1,          
    NETDEV_EVENT_TYPE_MAJOR_PERI_WARN  = 2,          /*  CORE */
    NETDEV_EVENT_TYPE_MAJOR_MEDIA      = 3,          
    NETDEV_EVENT_TYPE_MAJOR_BUTT
}NETDEV_EVENT_TYPE_MAJOR_E;

/**
* @enum tagNETDEVDecPaneNum
* @brief DC 
* @attention DC&&XW None
*/
typedef enum tagNETDEVDecPaneNum
{
    NETDEV_DEC_PANE_ONE             = 1,                /* 1 */
    NETDEV_DEC_PANE_TWO             = 2,                /* 2 */
    NETDEV_DEC_PANE_THREE           = 3,                /* 3 */
    NETDEV_DEC_PANE_FOUR            = 4,                /* 4 */
    NETDEV_DEC_PANE_FIVE            = 5,                /* 5 */
    NETDEV_DEC_PANE_SIX             = 6,                /* 6 */
    NETDEV_DEC_PANE_SEVEN           = 7,                /* 7 */
    NETDEV_DEC_PANE_EIGHT           = 8,                /* 8 */
    NETDEV_DEC_PANE_NINE            = 9,                /* 9 */
    NETDEV_DEC_PANE_TEN             = 10,               /* 10 */
    NETDEV_DEC_PANE_THIRTEEN        = 13,               /* 13 */
    NETDEV_DEC_PANE_SIXTEEN         = 16,               /* 16 */
    NETDEV_DEC_PANE_TWENTYFIVE      = 25,               /* 25 */
    NETDEV_DEC_PANE_THIRTYSIX       = 36,               /* 36 */
    NETDEV_DEC_PANE_SIXTYFOUR       = 64,               /* 64 */
    NETDEV_DEC_PANE_INVALID         = 0xffff
}NETDEV_PANE_NUM_E;

/**
 * @enum tagNETDEVOSDTextType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOSDTextType
{
    NETDEV_OSD_TEXT_DATAANDTIME = 0,            /* ., yyyy-MM-dd.HH:mm:ss, #NETDEV_OSD_DATE_FORMAT_CAP_E, #NETDEV_OSD_TIME_FORMAT_CAP_E */
    NETDEV_OSD_TEXT_PLAIN
}NETDEV_OSD_TEXT_TYPE_E;

/**
 * @enum tagNETDEVAlarmPortType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVAlarmPortType
{
    NETDEV_ALARM_PORT_TYPE_LOCAL = 0,            
    NETDEV_ALARM_PORT_TYPE_NAT   = 1             
}NETDEV_ALARM_PORT_TYPE_E;

/**
* @enum tagNETDEVFaceAnalysisSkill
* @brief  
* @attention 
*/
typedef enum tagNETDEVFaceAnalysisSkill
{
    NETDEV_FACE_ANALYSIS_SKILL_AGE                 = 0,            
    NETDEV_FACE_ANALYSIS_SKILL_GENGER              = 1,            
    NETDEV_FACE_ANALYSIS_SKILL_GLASSES             = 3,            
    NETDEV_FACE_ANALYSIS_SKILL_MASK                = 4,            
    NETDEV_FACE_ANALYSIS_SKILL_MUSTACHE            = 5,            
    NETDEV_FACE_ANALYSIS_SKILL_HAT                 = 6,            
    NETDEV_FACE_ANALYSIS_SKILL_HAIRSTYLE           = 7,            
    NETDEV_FACE_ANALYSIS_SKILL_EXPRESSION          = 8,            
    NETDEV_FACE_ANALYSIS_SKILL_FACE                = 9             
}NETDEV_FACE_ANALYSIS_SKILL_E;

/**
* @enum tagNETDEVFaceRecognitionType
* @brief  
* @attention 
*/
typedef enum tagNETDEVFaceRecognitionType
{
    NETDEV_FACE_RECOGNITION_TYPE_FRONT              = 0,            
    NETDEV_FACE_RECOGNITION_TYPE_CENTER             = 1             
}NETDEV_FACE_RECOGNITION_TYPE_E;

/**
* @enum tagNETDEVObjTracktModeType
* @brief  
* @attention 
*/
typedef enum tagNETDEVObjTracktModeType
{
    NETDEV_OBJ_TRACK_MODE_FULLVIEW  = 1,                
    NETDEV_OBJ_TRACK_MODE_CRUISE    = 2                 
}NETDEV_OBJ_TRACK_MODE_E;

/**
* @enum tagNETDEVDeviceUpgradeStatus
* @brief 
* @attention 
*/
typedef enum tagNETDEVDeviceUpgradeStatus
{
    NETDEV_UPGRADE_STATUS_INITING        = 0,       
    NETDEV_UPGRADE_STATUS_QUERYING       = 1,       
    NETDEV_UPGRADE_STATUS_DOWNLOADING    = 2,       
    NETDEV_UPGRADE_STATUS_TRANSMITTING   = 3,       
    NETDEV_UPGRADE_STATUS_UPGRATING      = 4,       
    NETDEV_UPGRADE_STATUS_UPGRATEERROR   = 5,       
    NETDEV_UPGRADE_STATUS_NEWEST         = 6,       
    NETDEV_UPGRADE_STATUS_HAVEHIGHTER    = 7,       
    NETDEV_UPGRADE_STATUS_UPGRADEOVER    = 8,       
    NETDEV_UPGRADE_STATUS_GETSTATUSFAIL  = 9,       
    NETDEV_UPGRADE_STATUS_NOTMATCH       = 10,      
    NETDEV_UPGRADE_STATUS_NOTMUTIPROCESS = 11,      
    NETDEV_UPGRADE_STATUS_UPGRADETIMEOUT = 12,      
    NETDEV_UPGRADE_STATUS_BUTT
}NETDEV_UPGRADE_STATUS_E;

/**
* @enum tagNETDEVUpgradeType
* @brief 
* @attention 
*/
typedef enum tagNETDEVUpgradeType
{
    NETDEV_UPGRADE_TYPE_CLOUD    = 1,               
    NETDEV_UPGRADE_TYPE_UDISK    = 2,               /* U */
    NETDEV_UPGRADE_TYPE_LOCAL    = 3,               
    NETDEV_UPGRADE_TYPE_BUTT
}NETDEV_UPGRADE_TYPE_E;

/**
* @enum tagNETDEVAudioEncodeFormatType
* @brief 
* @attention 
*/
typedef enum tagNETDEVAudioEncodeFormatType
{
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_MPEG1           = 0,       /* MPEG1 */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711A           = 1,       /* G.711A */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711U           = 2,       /* G.711U */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_ADPCM           = 3,       /* ADPCM */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_OGG             = 4,       /* OGG */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_Auto            = 5,       /* Auto */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_AACLC           = 6,       /* AAC-LC */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_INVALID         = 0xFF     
}NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E;

/**
* @enum tagNETDEVAudioSamplingRate
* @brief 
* @attention 
*/
typedef enum tagNETDEVAudioSamplingRate
{
    NETDEV_AUDIO_SAMPLING_RATE_8KHZ             = 0,       /* 8KHz */
    NETDEV_AUDIO_SAMPLING_RATE_16KHZ            = 1,       /* 16KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_22_05KHZ         = 2,       /* 22.05KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_24KHZ            = 3,       /* 24KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_32KHZ            = 4,       /* 32KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_44_1KHZ          = 5,       /* 44.1KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_48KHZ            = 6,       /* 48KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_96KHZ            = 7,       /* 96KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_INVALID          = 0xFF     
}NETDEV_AUDIO_SAMPLING_RATE_E;

/**
* @enum tagNETDEVAudioInChlMode
* @brief 
* @attention 
*/
typedef enum tagNETDEVAudioInChlMode
{
    NETDEV_AUDIO_CHL_MODE_LINE              = 0,        /* LINE */
    NETDEV_AUDIO_CHL_MODE_MIC               = 1,        /*  MIC */
    NETDEV_AUDIO_CHL_MODE_RS485             = 2,        /* RS485 */
    NETDEV_AUDIO_CHL_MODE_SPEAKER           = 3,        /* SpeaKer */
    NETDEV_AUDIO_CHL_MODE_INVALID           = 0xFF      
}NETDEV_AUDIO_CHL_MODE_E;

/**
* @enum tagNETDEVAudioCollectionPortType
* @brief 
* @attention 
*/
typedef enum tagNETDEVAudioCollectionPortType
{
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_IN              = 0,        
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_SERIAL_IN             = 1,        
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_INVALID               = 0xFF      
}NETDEV_AUDIO_COLLECTION_PORT_TYPE_E;

/**
 * @enum tagNETDEVWeekPlanEvent
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVWeekPlanEvent
{
    NETDEV_WEEK_PLAN_EVENT_MOTION_DETECT    = 1,               
    NETDEV_WEEK_PLAN_EVENT_AUDIO_DETECT     = 2,               
    NETDEV_WEEK_PLAN_EVENT_TAMPER_DETECT    = 3,               
    NETDEV_WEEK_PLAN_EVENT_INPUT_SWITCH     = 4,               
    NETDEV_WEEK_PLAN_EVENT_OUTPUT_SWITCH    = 5,               
    NETDEV_WEEK_PLAN_EVENT_CROSS_LINE       = 6,               
    NETDEV_WEEK_PLAN_EVENT_INTROSION_ZONE   = 7,               
    NETDEV_WEEK_PLAN_EVENT_ACCESS_ZONE      = 8,               
    NETDEV_WEEK_PLAN_EVENT_LEAVE_ZONE       = 9,               
    NETDEV_WEEK_PLAN_EVENT_HOVER_ZONE       = 10,              
    NETDEV_WEEK_PLAN_EVENT_CARE_ARTICLE     = 11,              
    NETDEV_WEEK_PLAN_EVENT_REMAIN_ARTICLE   = 12,              
    NETDEV_WEEK_PLAN_EVENT_GATHER           = 13,              
    NETDEV_WEEK_PLAN_EVENT_FASTMOVE         = 14,              
    NETDEV_WEEK_PLAN_EVENT_CAR_STOP         = 15,              
    NETDEV_WEEK_PLAN_EVENT_OUT_FOCUS        = 16,              
    NETDEV_WEEK_PLAN_EVENT_SCENCECHANGE     = 17,              
    NETDEV_WEEK_PLAN_EVENT_FACE_DETECT      = 18,              
    NETDEV_WEEK_PLAN_EVENT_ROAD_DETECT      = 19,              
    NETDEV_WEEK_PLAN_EVENT_PEOPLE_COUNT     = 20,              
    NETDEV_WEEK_PLAN_EVENT_HEATMAP          = 21,              
    NETDEV_WEEK_PLAN_EVENT_SD_STORAGE       = 22               /* SD */
}NETDEV_WEEK_PLAN_EVENT_E;

/**
* @enum tagNetDEVFishEyePtzMode
* @brief 
* @attention 
*/
typedef enum tagNetDEVFishEyePtzMode
{
    NETDEV_FISHEYE_MODE_ORIGINAL            = 0,                
    NETDEV_FISHEYE_MODE_180                 = 1,                /* 2*180 */
    NETDEV_FISHEYE_MODE_360_1PTZ            = 2,                /* 360+1PTZ */
    NETDEV_FISHEYE_MODE_360_6PTZ            = 3,                /* 360+6PTZ */
    NETDEV_FISHEYE_MODE_3PTZ                = 4,                /* +3PTZ */
    NETDEV_FISHEYE_MODE_MID_ON_4PTZ         = 5,                /* +4PTZ */
    NETDEV_FISHEYE_MODE_MID_OFF_4PTZ        = 6,                /* +4PTZ */
    NETDEV_FISHEYE_MODE_LEFT_4PTZ           = 7,                /* +4PTZ */
    NETDEV_FISHEYE_MODE_8PTZ                = 8,                /* +8PTZ */
    NETDEV_FISHEYE_MODE_PANORAMA            = 9,                
    NETDEV_FISHEYE_MODE_PR_3PTZ             = 10,               /* +3PTZ */
    NETDEV_FISHEYE_MODE_PR_4PTZ             = 11,               /* +4PTZ */
    NETDEV_FISHEYE_MODE_PR_8PTZ             = 12,               /* +8PTZ */
    NETDEV_FISHEYE_MODE_INVALID             = 0xFF              
}NETDEV_FISHEYE_PTZ_MODE_E;

/**
* @enum tagNETDEVfInstallMode
* @brief 
* @attention 
*/
typedef enum tagNETDEVfInstallMode
{
    NETDEV_INSTALL_MODE_TOP             = 0,            
    NETDEV_INSTALL_MODE_BOTTOM          = 1,            
    NETDEV_INSTALL_MODE_SIDE            = 2,            
    NETDEV_INSTALL_MODE_INVALID         = 0xFF          
}NETDEV_INSTALL_MODE_E;

/**
* @enum tagNETDEVfMouseMoveMode
* @brief 
* @attention 
*/
typedef enum tagNETDEVfMouseMoveMode
{
    NETDEV_MOUSE_MOVE                   = 0,            
    NETDEV_MOUSE_LEFT_BTN_DOWN          = 1,            
    NETDEV_MOUSE_LEFT_BTN_UP            = 2,            
    NETDEV_MOUSE_WHEEL                  = 3,            
    NETDEV_MOUSE_INVALID                = 0xFF          
}NETDEV_MOUSE_MOVE_MODE_E;

/**
 * @enum tagNETDEVFindAlarmTypeEn
 * @brief    Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVFindAlarmTypeEn
{
    NETDEV_FIND_ALARM_DISK_STORAGE_IS_FULL               = 1,            
    NETDEV_FIND_ALARM_DISK_STORAGE_WILL_FULL             = 2,            
    NETDEV_FIND_ALARM_STOR_ERR                           = 3,            
    NETDEV_FIND_ALARM_STOR_ERR_RECOVER                   = 4,            
    NETDEV_FIND_ALARM_MOVE_DETECT                        = 5,            
    NETDEV_FIND_ALARM_MOVE_DETECT_RECOVER                = 6,            
    NETDEV_FIND_ALARM_VIDEO_TAMPER_DETECT                = 7,            
    NETDEV_FIND_ALARM_VIDEO_TAMPER_RECOVER               = 8,            
    NETDEV_FIND_ALARM_INPUT_SWITCH                       = 9,            
    NETDEV_FIND_ALARM_INPUT_SWITCH_RECOVER               = 10,           
    NETDEV_FIND_ALARM_BAND_CHANGE                        = 11,           
    NETDEV_FIND_ALARM_IMAGE_BLURRY                       = 12,           
    NETDEV_FIND_ALARM_IMAGE_BLURRY_RECOVER               = 13,           
    NETDEV_FIND_ALARM_SCENE_CHANGE                       = 14,           
    NETDEV_FIND_ALARM_ILLEGAL_ACCESS                     = 15,           
    NETDEV_FIND_ALARM_REPORT_DEV_ONLINE                  = 16,           
    NETDEV_FIND_ALARM_REPORT_DEV_OFFLINE                 = 17,           
    NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS              = 18,           
    NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS_RECOVER      = 19,           
    NETDEV_FIND_ALARM_COUNT_PEOPLE                       = 20,           
    NETDEV_FIND_ALARM_HEAT_MAP                           = 21,           
    NETDEV_FIND_ALARM_LINE_DETECTOR                      = 22,           
    NETDEV_FIND_ALARM_CELL_MOTION                        = 23,           
    NETDEV_FIND_ALARM_LINE_CROSS                         = 24,           
    NETDEV_FIND_ALARM_OBJECTS_INSIDE                     = 25,           
    NETDEV_FIND_ALARM_ACCESSZONE                         = 26,           
    NETDEV_FIND_ALARM_LEAVE_ZONE                         = 27,           
    NETDEV_FIND_ALARM_HOVER_ZONE                         = 28,           
    NETDEV_FIND_ALARM_OVER_ZONE                          = 29,           
    NETDEV_FIND_ALARM_CARE_ARTICLE                       = 30,           
    NETDEV_FIND_ALARM_REMAIN_ARTICLE                     = 31,           
    NETDEV_FIND_ALARM_FACE_DETECTOR                      = 32,           
    NETDEV_FIND_ALARM_GATHER                             = 33,           
    NETDEV_FIND_ALARM_GATHER_RECOVER                     = 34,           
    NETDEV_FIND_ALARM_FAST_MOVE                          = 35,           
    NETDEV_FIND_ALARM_ILLEGAL_PARKED                     = 36,           
    NETDEV_FIND_ALARM_HUMAN_SHAPE_ON                     = 37,           
    NETDEV_FIND_ALARM_HUMAN_SHAPE_OFF                    = 38,           
    NETDEV_FIND_ALARM_BODY_TEMPERATURE                   = 39,           
    NETDEV_FIND_ALARM_NO_MASK                            = 40,           
    NETDEV_FIND_ALARM_METAL_DETECT_ON                    = 41,           
    NETDEV_FIND_ALARM_METAL_DETECT_OFF                   = 42,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_MINOR_ON             = 43,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_MINOR_OFF            = 44,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_MAJOR_ON             = 45,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_MAJOR_OFF            = 46,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_CRITICAL_ON          = 47,           
    NETDEV_FIND_ALARM_CROWD_DENSITY_CRITICAL_OFF         = 48,           
    NETDEV_FIND_ALARM_INVALID                            = 0xFFFF        /*   Invalid value */
}NETDEV_FIND_ALARM_TYPE_E;

/**
* @enum tagNETDEVWndNameDisplay
* @brief  
* @attention  None
*/
typedef enum tagNETDEVWndNameDisplay
{
    NETDEV_WND_NAME_HIDE    = 0,        
    NETDEV_WND_NAME_SHOW    = 1         
} NETDEV_WND_NAME_DISPLAY_E;

/**
* @enum tagNETDEVOperatedMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVOperatedMode
{
    NETDEV_SPLIT_SCREEN_RECOVER    = 0,               
    NETDEV_SPLIT_SCREEN_ZOOM       = 1                
} NETDEV_OPERATED_MODE_E;

 /**
 * @enum tagNETDEVNATType
 * @brief NAT 
 * @attention  None
 */
typedef enum tagNETDEVNATType
{
    NETDEV_STUN_TYPE_UNKNOWN                 = 0,       
    NETDEV_STUN_TYPE_FAILURE                 = 1,       
    NETDEV_STUN_TYPE_OPEN                    = 2,       /* NATIP */
    NETDEV_STUN_TYPE_BLOCKED                 = 3,       /* UDP */
    NETDEV_STUN_TYPE_CONE_NAT                = 4,       /* NAT */
    NETDEV_STUN_TYPE_RESTRICTED_NAT          = 5,       /* NAT */
    NETDEV_STUN_TYPE_PORT_RESTRICTED_NAT     = 6,       /* NAT */
    NETDEV_STUN_TYPE_SYM_NAT                 = 7,       /* NAT */
    NETDEV_STUN_TYPE_SYM_FIREWALL            = 8        /* NATIPUDP */
}NETDEV_NAT_TYPE_E;

/**
* @enum tagNetDevFaceIDLengthType
* @brief ID
* @attention 
*/
typedef enum tagNetDevFaceIDLengthType
{
    NETDEV_FACE_IDLENGTH_TYPE_0      = 0,            /*  0 */
    NETDEV_FACE_IDLENGTH_TYPE_2      = 2,            /*  2 */
    NETDEV_FACE_IDLENGTH_TYPE_4      = 4,            /*  4 */
    NETDEV_FACE_IDLENGTH_TYPE_8      = 8             /*  8 */
}NETDEV_FACE_IDLENGTH_TYPE_E;

/**
 * @enum tagNETDEVFaceDBType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVFaceDBType
{
    NETDEV_FACE_DB_TYPE_BLACK       = 0,        
    NETDEV_FACE_DB_TYPE_WHITE       = 1,        
    NETDEV_FACE_DB_TYPE_GRAY        = 2,        
    NETDEV_FACER_DB_TYPE_INVALID    = 0xFF      
}NETDEV_FACE_DB_TYPE_E;

/**
* @enum tagNETDEVImageRotationMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVImageRotationMode
{
    NETDEV_IMAGE_ROTATION_MODE_NORMAL       = 0,            
    NETDEV_IMAGE_ROTATION_MODE_V_FLIPPING   = 1,            
    NETDEV_IMAGE_ROTATION_MODE_H_FLIPPING   = 2,            
    NETDEV_IMAGE_ROTATION_MODE_HV           = 3,            /* + (180) */
    NETDEV_IMAGE_ROTATION_MODE_SPIN90_RIGHT = 4,            /* 90(90) */
    NETDEV_IMAGE_ROTATION_MODE_SPIN90_LEFT  = 5,            /* 90(270) */
    NETDEV_IMAGE_ROTATION_MODE_INVALID      = 0xFF          
}NETDEV_IMAGE_ROTATION_MODE_E;

/**
* @enum tagNETDEVExposureMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVExposureMode
{
    NETDEV_EXPOSURE_MODE_AUTOMATIC          = 0,               
    NETDEV_EXPOSURE_MODE_CUSTOM             = 1,               
    NETDEV_EXPOSURE_MODE_SHUTTER_PRIORITY   = 2,               
    NETDEV_EXPOSURE_MODE_APERTURE_PRIORITY  = 3,               
    NETDEV_EXPOSURE_MODE_GAIN_PRIORITY      = 4,               
    NETDEV_EXPOSURE_MODE_INDOOR_50_HZ       = 5,               /* 50Hz */
    NETDEV_EXPOSURE_MODE_INDOOR_60_HZ       = 6,               /* 60Hz */
    NETDEV_EXPOSURE_MODE_MANUAL_OPERATION   = 7,               
    NETDEV_EXPOSURE_MODE_LOWER_GHOSTING     = 8,               
    NETDEV_EXPOSURE_MODE_INVALID            = 0xFF             
}NETDEV_EXPOSURE_MODE_E;

/**
* @enum tagNETDEVLampType
* @brief  
* @attention  None
*/
typedef enum tagNETDEVLampType
{
    NETDEV_LAMP_TYPE_WITHOUT                     = 0,        
    NETDEV_LAMP_TYPE_WHITE                       = 1,        
    NETDEV_LAMP_TYPE_INFRARED                    = 2,        
    NETDEV_LAMP_TYPE_LASER_DEVICE                = 3,        
    NETDEV_LAMP_TYPE_INFRARED_SHIELD             = 4,        
    NETDEV_LAMP_TYPE_EXTERNAL_HEATING_LIGHT      = 5,        
    NETDEV_LAMP_TYPE_DOUBLE_LIGHT                = 6,        /* (+) */
    NETDEV_LAMP_TYPE_INVALID                     = 0xFF      
}NETDEV_LAMP_TYPE_E;

/**
* @enum tagNETDEVLampCtrlMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVLampCtrlMode
{
    NETDEV_LCM_GLOBAL_ATTENTION_AC      = 0,        
    NETDEV_LCM_OVEREXPOSE_INHIBIT_AC    = 1,        
    NETDEV_LCM_PRESET_RCM               = 2,        /* - */
    NETDEV_LCM_MANUAL_CM                = 3,        
    NETDEV_LCM_PRESET_PCM               = 4,        /* -*/
    NETDEV_LCM_PHOTOSENS_AM             = 5,        
    NETDEV_LCM_INDOOR_AM                = 6,        
    NETDEV_LCM_MANUAL_FOM               = 7,        /* -*/
    NETDEV_LCM_NIGHT_VIDEO_DET_MODE     = 8,        
    NETDEV_LCM_INVALID                  = 0xFF      
}NETDEV_LAMP_CTRL_MODE_E;

/**
* @enum tagNETDEVShutterTimeRange
* @brief  
* @attention  None
*/
typedef enum tagNETDEVShutterTimeRange
{
    NETDEV_SHUTTER_TIME_AUTOMATIC   = 0,            
    NETDEV_SHUTTER_TIME_1           = 1,            /* 1/1 */
    NETDEV_SHUTTER_TIME_1_2         = 2,            /* 1/2 */
    NETDEV_SHUTTER_TIME_1_3         = 3,            /* 1/3 */
    NETDEV_SHUTTER_TIME_1_4         = 4,            /* 1/4 */
    NETDEV_SHUTTER_TIME_1_6         = 6,            /* 1/6 */
    NETDEV_SHUTTER_TIME_1_8         = 8,            /* 1/8 */
    NETDEV_SHUTTER_TIME_1_10        = 10,           /* 1/10*/
    NETDEV_SHUTTER_TIME_1_12        = 12,           /* 1/12*/
    NETDEV_SHUTTER_TIME_1_15        = 15,           /* 1/15*/
    NETDEV_SHUTTER_TIME_1_20        = 20,           /* 1/20*/
    NETDEV_SHUTTER_TIME_1_25        = 25,           /* 1/25*/
    NETDEV_SHUTTER_TIME_1_30        = 30,           /* 1/30*/
    NETDEV_SHUTTER_TIME_1_50        = 50,           /* 1/50*/
    NETDEV_SHUTTER_TIME_1_60        = 60,           /* 1/60*/
    NETDEV_SHUTTER_TIME_1_100       = 100,          /* 1/100*/
    NETDEV_SHUTTER_TIME_1_120       = 120,          /* 1/120*/
    NETDEV_SHUTTER_TIME_1_150       = 150,          /* 1/150*/
    NETDEV_SHUTTER_TIME_1_180       = 180,          /* 1/180*/
    NETDEV_SHUTTER_TIME_1_200       = 200,          /* 1/200*/
    NETDEV_SHUTTER_TIME_1_250       = 250,          /* 1/250*/
    NETDEV_SHUTTER_TIME_1_500       = 500,          /* 1/500*/
    NETDEV_SHUTTER_TIME_1_1000      = 1000,         /* 1/1000*/
    NETDEV_SHUTTER_TIME_1_2000      = 2000,         /* 1/2000*/
    NETDEV_SHUTTER_TIME_1_4000      = 4000,         /* 1/4000*/
    NETDEV_SHUTTER_TIME_1_8000      = 8000,         /* 1/8000*/
    NETDEV_SHUTTER_TIME_1_50000     = 50000,        /* 1/50000*/
    NETDEV_SHUTTER_TIME_1_100000    = 100000,       /* 1/100000*/
    NETDEV_SHUTTER_TIME_INVALID     = 0xFF          
}NETDEV_SHUTTER_TIME_RANGE_E;

/**
* @enum tagNETDEVWideDynamicMode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVWideDynamicMode
{
    NETDEV_WDM_CLOSED   = 0,    
    NETDEV_WDM_OPEN     = 1,    
    NETDEV_WDM_AUTO     = 2,    
    NETDEV_WDM_INVALID  = 0xFF  
}NETDEV_WIDE_DYNAMIC_MODE_E;

/**
* @enum tagNETDEVMeteringMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVMeteringMode
{
    NETDEV_METER_MODE_CENTRAL_WEIGHT    = 0,        
    NETDEV_METER_MODE_AREA_METER        = 1,        
    NETDEV_METER_MODE_SLIGHT_INHIBIT    = 2,        
    NETDEV_METER_MODE_VEHICLE_METER     = 3,        
    NETDEV_METER_MODE_FACE_METER        = 4,        
    NETDEV_METER_MODE_SPOT_METER        = 5,        
    NETDEV_METER_MODE_INVALID           = 0xFF      
}NETDEV_METER_MODE_E;

/**
* @enum tagNETDEVDayNightMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVDayNightMode
{
    NETDEV_DNM_AUTO                     = 0,        
    NETDEV_DNM_DAY_COLOR                = 1,        /* -- */
    NETDEV_DNM_NIGHT_BAW                = 2,        /* -- */
    NETDEV_DNM_LINK_COLOR_TO_BLACK      = 3,        
    NETDEV_DNM_INVALID                  = 0xFF      
}NETDEV_DAY_NIGHT_MODE_E;

/**
* @enum tagNETDEVFocusModel
* @brief  
* @attention  None
*/
typedef enum tagNETDEVFocusModel
{
    NETDEV_FOCUS_MODEL_AUTO             = 0,        
    NETDEV_FOCUS_MODEL_MANUAL           = 1,        
    NETDEV_FOCUS_MODEL_A_KEY_FOCUS      = 2,        /*  */
    NETDEV_FOCUS_MODEL_INFRARED_NIGHT   = 3,        /* */
    NETDEV_FOCUS_MODEL_LOCK             = 4,        /* */
    NETDEV_FOCUS_MODEL_INVALID          = 0xFF      
}NETDEV_FOCUS_MODEL_E;

/**
* @enum tagNETDEVFocusScene
* @brief  
* @attention  None
*/
typedef enum tagNETDEVFocusScene
{
    NETDEV_FOCUS_SCENE_ROUTINE          = 0,        
    NETDEV_FOCUS_SCENE_LONG_OBJDIST     = 1,        
    NETDEV_FOCUS_SCENE_INDOOR_MODEL     = 2,        
    NETDEV_FOCUS_SCENE_INVALID          = 0xFF      
}NETDEV_FOCUS_SCENE_E;

/**
* @enum tagNETDEVWhiteBalance
* @brief  
* @attention  None
*/
typedef enum tagNETDEVWhiteBalance
{
    NETDEV_WBM_AUTO                         = 0,        
    NETDEV_WBM_TRIMMING                     = 1,        
    NETDEV_WBM_INDOOR                       = 2,        
    NETDEV_WBM_OUTDOOR                      = 3,        
    NETDEV_WBM_AUTO_MERCURY_LAMP            = 4,        
    NETDEV_WBM_NIGHT_TRIMMING               = 5,        
    NETDEV_WBM_AUTO_NA_LAMP                 = 6,        
    NETDEV_WBM_LOCK                         = 7,        
    NETDEV_WBM_SELF_ADAPT_NIGHT_TRIMMING    = 8,        
    NETDEV_WBM_AUTO_SECOND                  = 9,        /*2*/
    NETDEV_WBM_INVALID                      = 0xFF      
}NETDEV_WHITE_BALANCE_MODE_E;

/**
 * @enum tagNETDEVXWComType
 * @brief 
 * @attention  None      0  4
 */
typedef enum tagNETDEVXWComType
{
    NETDEV_XW_COM_TYPE_RS232                    = 0,               /* 232 */
    NETDEV_XW_COM_TYPE_RS422HALFDUPLEX          = 1,               /* 422  */
    NETDEV_XW_COM_TYPE_RS422FULLDUPLEX          = 2,               /* 422  */
    NETDEV_XW_COM_TYPE_RS485HALFDUPLEX          = 3,               /* 485  */
    NETDEV_XW_COM_TYPE_RS485FULLDUPLEX          = 4,
    NETDEV_XW_COM_TYPE_GENERIC                  = 5,               
    NETDEV_XW_COM_TYPE_INVALID                  = 0xFF             
}NETDEV_XW_COM_TYPE_E;

/**
 * @enum tagNETDEVVideoType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVVideoType
{
    NETDEV_PLAYBACK_REMOTE  = 0,        
    NETDEV_REALPLAY_REMOTE  = 1,        
    NETDEV_REALPLAY_LOCAL   = 2,        
    NETDEV_SEQUENCE_PANE    = 3,        
    NETDEV_SEQUENCE_WND     = 4,        
    NETDEV_REALPLAY_ALARM   = 5         
}NETDEV_XW_VIDEO_TYPE_E;

/**
 * @enum tagNETDEV_PASSIVEDECODE_CMD
 * @brief 
 * @attention 
 */
typedef enum tagNETDEV_PASSIVEDECODE_CMD
{
    PASSIVE_DEC_PAUSE       = 1,   
    PASSIVE_DEC_RESUME      = 2,   
    PASSIVE_DEC_FAST        = 3,   
    PASSIVE_DEC_SLOW        = 4,   
    PASSIVE_DEC_NORMAL      = 5,   
    PASSIVE_DEC_ONEBYONE    = 6,   
    PASSIVE_DEC_AUDIO_ON    = 7,   
    PASSIVE_DEC_AUDIO_OFF   = 8,   
    PASSIVE_DEC_RESETBUFFER = 9    
}NETDEV_PASSIVEDECODE_CMD_E;

/**
 * @enum tagNETDEVXWSequenceStatusType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVXWSequenceStatusType
{
    NETDEV_SEQUENCE_STATUS_RUNNING  = 0,         
    NETDEV_SEQUENCE_STATUS_PAUSE    = 1,         
    NETDEV_SEQUENCE_STATUS_INVALID  = 0xff      
}NETDEV_XW_SEQUENCE_STATUS_E;

/**
 * @enum tagNETDEVXWSequenceCtrlCmd
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVXWSequenceCtrlCmd
{
    NETDEV_SEQUENCE_CTRL_CMD_STOP       = 0,         
    NETDEV_SEQUENCE_CTRL_CMD_START      = 1,         
    NETDEV_SEQUENCE_CTRL_CMD_PAUSE      = 2,         
    NETDEV_SEQUENCE_CTRL_CMD_RECOVER    = 3,         
    NETDEV_SEQUENCE_CTRL_CMD_PREVIOUS   = 4,         
    NETDEV_SEQUENCE_CTRL_CMD_NEXT       = 5,         
    NETDEV_SEQUENCE_CTRL_CMD_INVALID    = 0xff      
}NETDEV_XW_SEQUENCE_CTRL_CMD_E;

/**
 * @enum tagNETDEVXWWndStreamStatus
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWWndStreamStatus
{
    NETDEV_XW_STREAM_STATUS_NO                  = 0,          
    NETDEV_XW_STREAM_STATUS_SUCCESS             = 1,          
    NETDEV_XW_STREAM_STATUS_STREAMING           = 2,          
    NETDEV_XW_STREAM_STATUS_RESTREAM            = 3,          
    NETDEV_XW_STREAM_STATUS_FAILED              = 4,          
    NETDEV_XW_STREAM_STATUS_CAP_NOT_ENOUGHT     = 5,          
    NETDEV_XW_STREAM_STATUS_INVALID             = 0xFF        
}NETDEV_XW_WND_STREAM_STATUS_E;

/**
* @enum tagNETDEVXWSequencePlayControlCmd
* @brief  
* @attention  None
*/
typedef enum tagNETDEVXWSequencePlayControlCmd
{
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_STOP       = 0,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_START      = 1,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAUSE      = 2,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_RESUME     = 3,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAGEUP     = 4,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAGEDOWN   = 5,        
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_INVALID    = 0xFF      
}NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E;

/**
* @enum tagNETDEVXWScenesPlanMode
* @brief  
* @attention  None
*/
typedef enum tagNETDEVXWScenesPlanMode
{
    NETDEV_XW_SCENES_PLAN_MODE_TIMER       = 0,            
    NETDEV_XW_SCENES_PLAN_MODE_TIME_TABLE  = 1,            /*  24 */
    NETDEV_XW_SCENES_PLAN_MODE_INVALID     = 0xFF          
}NETDEV_XW_SCENES_PLAN_MODE_E;

/**
* @enum tagNETDEVHDDStorageFullStrategy
* @brief 
* @attention 
*/
typedef enum tagNETDEVHDDStorageFullStrategy
{
    NETDEV_HDD_STORAGE_FULL_STRATEGY_COVER      = 0,        
    NETDEV_HDD_STORAGE_FULL_STRATEGY_STOP       = 1,        
    NETDEV_HDD_STORAGE_FULL_STRATEGY_INVALID    = 0XFF      
}NETDEV_HDD_STORAGE_FULL_STRATEGY_E;

/**
* @enum tagNETDEVCertificateType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVCertificateType
{
    NETDEV_CERTIFICATE_TYPE_ID                  = 0,        /*0: */
    NETDEV_CERTIFICATE_TYPE_IC                  = 1,        /* 1:IC */
    NETDEV_CERTIFICATE_TYPE_PASSPORT            = 2,        /* 2: */
    NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE     = 3,        /* 3: */
    NETDEV_CERTIFICATE_TYPE_OTHER               = 99,       /* 99: */
    NETDEV_CERTIFICATE_TYPE_INVALID             = 0xFF      
}NETDEV_ID_TYPE_E;

/**
* @enum tagNETDEVModelStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVModelStatus
{
    NETDEV_MODEL_STATUS_TYPE_UNMODELED                      = 0,        /*0: */
    NETDEV_MODEL_STATUS_TYPE_SUCCEED                        = 1,        /* 1: */
    NETDEV_MODEL_STATUS_TYPE_FAILED                         = 2,        /* 2: */
    NETDEV_MODEL_STATUS_TYPE_INVALID                        = 0xFF      
}NETDEV_MODEL_STATUS_E;

/**
* @enum tagNETDEVPeopleLibType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPeopleLibType
{
    NETDEV_PEOPLE_LIB_TYPE_DEFAULT      = 0,        
    NETDEV_PEOPLE_LIB_TYPE_BLACKLIST    = 1,        
    NETDEV_PEOPLE_LIB_TYPE_STRANGER     = 2,        /* / */
    NETDEV_PEOPLE_LIB_TYPE_STAFF        = 3,        
    NETDEV_PEOPLE_LIB_TYPE_VISITOR      = 4,        
    NETDEV_PEOPLE_LIB_TYPE_INVALID      = 0xFF      
}NETDEV_PEOPLE_LIB_TYPE_E;

/**
* @enum tagNETDEVSubType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVSubType
{
    NETDEV_SUB_TYPE_FACE_COLLECTION = 0,                             
    NETDEV_SUB_TYPE_PERSON_CHECK    = 1,                             
    NETDEV_SUB_TYPE_TYPE_INVALID    = 0xFF                           
}NETDEV_SUB_TYPE_E;

/**
* @enum tagNETDEVSmartAlarmType
* @brief 
* @attention 
*/
typedef enum tagNETDEVSmartAlarmType
{
    NETDEV_SMART_ALARM_TYPE_FACE_SNAP         = 0,             
    NETDEV_SMART_ALARM_TYPE_VEHICLE_SNAP      = 1,             
    NETDEV_SMART_ALARM_TYPE_VIDEO_STRUCT_SNAP = 3,             
    NETDEV_SMART_ALARM_TYPE_INVALID           = 0xFF           
}NETDEV_SMART_ALARM_TYPE_E;

/**
* @enum tagNETDEVSearchType
* @brief 
* @attention 
*/
typedef enum tagNETDEVSearchType
{
    NETDEV_SEARCH_TYPE_FACE                 = 0,    
    NETDEV_SEARCH_TYPE_FACE_COMPARE_SUCCESS = 1,    
    NETDEV_SEARCH_TYPE_FACE_COMPARE_FAIL    = 2,    
    NETDEV_SEARCH_TYPE_INVALID              = 0xff  
}NETDEV_SEARCH_TYPE_E;

/**
 * @enum tagNETDEVQueryCondType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVQueryCondType
{
    NETDEV_QUERYCOND_USERNAME          = 0,                /*  */
    NETDEV_QUERYCOND_ORGNAME           = 1,                /*  */
    NETDEV_QUERYCOND_DEVNAME           = 2,                /*  */
    NETDEV_QUERYCOND_CHNNAME           = 3,                /*  */
    NETDEV_QUERYCOND_TIME              = 4,                /*  */
    NETDEV_QUERYCOND_BUSINESSTYPE      = 5,                /*  */
    NETDEV_QUERYCOND_OPERATETYPE       = 6,                /*  */
    NETDEV_QUERYCOND_OPEROBJECT        = 7,                /*  */
    NETDEV_QUERYCOND_ALARMTYPE         = 8,                /*  NETDEV_ALARM_TYPE_E*/
    NETDEV_QUERYCOND_ALARMSRCNAME      = 9,                /*  */
    NETDEV_QUERYCOND_ALARMLEVEL        = 10,               /*  */
    NETDEV_QUERYCOND_ALARMCHECKED      = 11,               /*  */
    NETDEV_QUERYCOND_ALARMCHECKUSER    = 12,               /*  */
    NETDEV_QUERYCOND_ALARMCHECKTIME    = 13,               /*  */
    NETDEV_QUERYCOND_ALARM_DEVID       = 14,               /* ID */
    NETDEV_QUERYCOND_ALARM_CHNID       = 15,               /* ID */
    NETDEV_QUERYCOND_ALARM_SUBTYPE     = 16,               /*  */
    NETDEV_QUERYCOND_ALARM_SERVER      = 17,               /*  */
    NETDEV_QUERYCOND_DOOR_NUM          = 18,               /*  */
    NETDEV_QUERYCOND_CARD_NUM          = 19,               /*  */
    NETDEV_QUERYCOND_ALARM_GENDER      = 20,               /*  */
    NETDEV_QUERYCOND_ALARM_BIRTHDAY    = 21,               /*  */
    NETDEV_QUERYCOND_MONITOY_REASON    = 22,               /*  */
    NETDEV_QUERYCOND_PLATE_NUM         = 23,               /*  */
    NETDEV_QUERYCOND_VEHICLE_TYPE      = 24,               /*  */
    NETDEV_QUERYCOND_PLATE_COLOR       = 25,               /*  */
    NETDEV_QUERYCOND_VEHICLE_COLOR     = 26,               /*  */
    NETDEV_QUERYCOND_PERSON_NUMBER     = 27,               /* */
    NETDEV_QUERYCOND_PERSON_TYPE       = 28,               /* */
    NETDEV_QUERYCOND_DIRECT            = 29,               /* */
    NETDEV_QUERYCOND_ORGID             = 30,               /* ID */
    NETDEV_QUERYCOND_ORGPID            = 31,               /* PID */
    NETDEV_QUERYCOND_DEVICEID          = 32,               /* ID */
    NETDEV_QUERYCOND_DEVICE_TYPE       = 33,               
    NETDEV_QUERYCOND_DEVICE_SUBTYPE    = 34,               
    NETDEV_QUERYCOND_CHANNELID         = 35,               /* ID */
    NETDEV_QUERYCOND_CHANNEL_TYPE      = 36,               
    NETDEV_QUERYCOND_ONLINE_STATE      = 37,               
    NETDEV_DATABASE_ID                 = 38,               /* ID */
    NETDEV_QUERY_TYPE_PLATECLASS       = 39,               /*  */ 
    NETDEV_QUERYCOND_RANGE             = 40,               /*  01*/
    NETDEV_QUERYCOND_BEGIN_TIME          = 41,             /* */
    NETDEV_QUERYCOND_END_TIME            = 42,             /* */
    NETDEV_QUERYCOND_INTERVIEWEE_NAME    = 43,             /* */
    NETDEV_QUERYCOND_INTERVIEWEE_STATUS  = 44,             /* */
    NETDEV_QUERYCOND_PARK_NAME         = 45,               /*  */
    NETDEV_QUERYCOND_CONFIDENCE_LEVEL  = 46,               /*  */
    NETDEV_QUERYCOND_PARK_TIME         = 47,               /*  */
    NETDEV_QUERYCOND_CONTRACT_RULE     = 48,               /*  */
    NETDEV_QUERYCOND_PAYMENT_METHOD    = 49,               /*  */
    NETDEV_QUERYCOND_PASSING_DIRECTION = 50,               /*  */
    NETDEV_QUERYCOND_VEHICLE_ATTR      = 51,               /*  */
    NETDEV_QUERYCOND_STATISTICS_UNITS  = 52,               /*  */
    NETDEV_QUERYCOND_EXITENTRANCE_NAME = 53,               /*  */
    NETDEV_QUERYCOND_PICTURE_DATA      = 54,               /*  */
    NETDEV_QUERYCOND_PERSON_NAME       = 55,               /*  */
    NETDEV_QUERYCOND_SIMILARITY        = 56,               /*  */
    NETDEV_QUERYCOND_SEARCH_TYPE       = 57,               /*  NETDEV_SEARCH_TYPE_E */
    NETDEV_QUERYCOND_ID_NUMBER         = 58,               /*  */
    NETDEV_QUERYCOND_AGERANGE          = 59,               /*  */
    NETDEV_QUERYCOND_GLASSES_STYLE     = 61,               /*  */
    NETDEV_QUERYCOND_SLEEVES_LENGTH    = 62,               /*  */
    NETDEV_QUERYCOND_COAT_COLOR        = 63,               /*  */
    NETDEV_QUERYCOND_TROUSERS_STYLE    = 64,               /*  */
    NETDEV_QUERYCOND_TROUSERS_COLOR    = 65,               /*  */
    NETDEV_QUERYCOND_SNAP_TOWARD       = 66,               /*  */
    NETDEV_QUERYCOND_SHOES_TUBE_LENGTH = 67,               /*  */
    NETDEV_QUERYCOND_HAIR_LENGTH       = 68,               /*  */
    NETDEV_QUERYCOND_BAG_FLAG          = 69,               /*  */
    NETDEV_QUERYCOND_SPEED_TYPE        = 70,               /*  */
    NETDEV_QUERYCOND_NON_VEH_TYPE      = 71,               /*  */
    NETDEV_QUERYCOND_VEH_BRAND         = 72,               /*  */
    NETDEV_QUERYCOND_VEH_DATA_TYPE     = 73,               /* 01 */
    NETDEV_QUERYCOND_PROTOCOL_TYPE             = 74,       /*  */
    NETDEV_QUERYCOND_RELEVANT_ROOM             = 75,       /*  */
    NETDEV_QUERYCOND_LOCK_SIGNAL               = 76,       /*  */
    NETDEV_QUERYCOND_BIND_RELATION_DOORLOCK    = 77,       /*  */
    NETDEV_QUERYCOND_BIND_RELATION_PERSON_CARD = 78,       /*  */
    NETDEV_QUERYCOND_PERSONID                  = 79,       /* ID */
    NETDEV_QUERYCOND_PARKINGLOTID              = 80,       /* ID */
    NETDEV_QUERYCOND_ENTREXITID                = 81,       /* ID */
    NETDEV_QUERYCOND_RECORDID                  = 82,       /* ID */
    NETDEV_QUERYCOND_VEH_GROUPINGID            = 83,       /* ID */
    NETDEV_QUERYCOND_KEYWORD                   = 84,       /*  */
    NETDEV_QUERYCOND_PUBULISH_TYPE             = 85,       /*  (0, 1) */
    NETDEV_QUERYCOND_PROGRAM_NAME              = 86,       /*  */
    NETDEV_QUERYCOND_ORG_TYPE                  = 87,       /*   NETDEV_ORG_TYPE_E */
    NETDEV_QUERYCOND_VALID_DATE                = 88,       /*  */
    NETDEV_QUERYCOND_VALID_TIME                = 89,       /*  */
    NETDEV_QUERYCOND_VALID_WEEK                = 90,       /*  */
    NETDEV_QUERYCOND_MODEL_STATUS_TYPE         = 91,       /* ,  NETDEV_MODEL_STATUS_E */
    NETDEV_QUERYCOND_MASK_FLAG                 = 92,       /*   NETDEV_MASK_FLAG_E */
    NETDEV_QUERYCOND_TEMPERATURE               = 93,       /*  */

    NETDEV_QUERYCOND_SKINCOLOR_TYPE            = 95,       /*   NETDEV_SKINCOLOR_TYPE_E */
    NETDEV_QUERYCOND_BEARD_FLAG                = 96,       /*   NETDEV_BEARD_FLAG_E */
    NETDEV_QUERYCOND_OBJECT_TYPE               = 97,       /*   NETDEV_OBJECT_TYPE_E */

    NETDEV_QUERYCOND_INVALID           = 0xFF              
}NETDEV_QUERYCOND_TYPE_E;

/**
 * @enum tagNETDEVQueryCondLogic
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVQueryCondLogic
{
    NETDEV_QUERYCOND_LOGIC_EQUAL             = 0,                /*  */
    NETDEV_QUERYCOND_LOGIC_GREATER           = 1,                /*  */
    NETDEV_QUERYCOND_LOGIC_LESS              = 2,                /*  */
    NETDEV_QUERYCOND_LOGIC_NO_LESS           = 3,                /*  */
    NETDEV_QUERYCOND_LOGIC_NO_GREATER        = 4,                /*  */
    NETDEV_QUERYCOND_LOGIC_NO_EQUAL          = 5,                /*  */
    NETDEV_QUERYCOND_LOGIC_DIM_QUERY         = 6,                /*  */
    NETDEV_QUERYCOND_LOGIC_CONTAIN           = 7,                /*  */
    NETDEV_QUERYCOND_LOGIC_ASC_ORDER         = 8,                /*  */
    NETDEV_QUERYCOND_LOGIC_DESC_ORDER        = 9                 /*  */
}NETDEV_QUERYCOND_LOGICTYPE_E;

/**
* @enum tagNETDEVFaceMatchAlarmType
* @brief 
* @attention 
*/
typedef enum tagNETDEVFaceMatchAlarmType
{
    NETDEV_FACE_MATCH_TYPE_SNAPSHOT      = 1,               
    NETDEV_FACE_MATCH_ALARM              = 2,               
    NETDEV_FACE_NOT_MATCH_ALARM          = 4,               
    NETDEV_FACET_MATCH_TYPE_INVALID     = 0xFF              
}NETDEV_FACE_MATCH_ALARM_TYPE_E;

/**
* @enum tagNETDEVRecodeLabelResult
* @brief 
* @attention 
*/
typedef enum tagNETDEVRecodeLabelResult
{
    NETDEV_RECODE_LABEL_SUCCESS     = 0,        
    NETDEV_RECODE_LABEL_FAIL_MAX    = 1,        
    NETDEV_RECODE_LABEL_FAIL_OTHER  = 2         
}NETDEV_RECODE_LABEL_RESULT_E;

/**
* @enum tagNETDEVAccessProtocol
* @brief 
* @attention 
*/
typedef enum tagNETDEVAccessProtocol
{
    NETDEV_ACCESS_PROTOCOL_ONVIF                = 1,                /* onvif */
    NETDEV_ACCESS_PROTOCOL_PRIVATE              = 2,                
    NETDEV_ACCESS_PROTOCOL_GB                   = 3,                
    NETDEV_ACCESS_PROTOCOL_RTSP                 = 4,                /* RTSP */
    NETDEV_ACCESS_PROTOCOL_BAOXIN               = 5,                
    NETDEV_ACCESS_PROTOCOL_INVALID              = 0xFF              
}NETDEV_ACCESS_PROTOCOL_E;

/**
 * @enum tagNETDEVChnOffReason
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChnOffReason
{
    NETDEV_CHN_OFF_REASON_CONNECTING                = 0,                
    NETDEV_CHN_OFF_REASON_ONLINE                    = 1,                
    NETDEV_CHN_OFF_REASON_WRONG_PWD                 = 2,                
    NETDEV_CHN_OFF_REASON_NETWORK_ERROR             = 3,                
    NETDEV_CHN_OFF_REASON_SET_LIVE_STREAM_ERROR     = 4,                
    NETDEV_CHN_OFF_REASON_START_LIVE_STREAM_ERROR   = 5,                
    NETDEV_CHN_OFF_REASON_STREAM_INTERUP            = 6,                
    NETDEV_CHN_OFF_REASON_TIMEOUT                   = 7,                
    NETDEV_CHN_OFF_REASON_WAIT_REGIST               = 8,                /* IPC */
    NETDEV_CHN_OFF_REASON_MODIFY_LIVE_STREAM_ERROR  = 9,                /* IPC */
    NETDEV_CHN_OFF_REASON_POE_POWER_ERROR           = 10,               /* PoE */
    NETDEV_CHN_OFF_REASON_BW_RECV_NOT_ENOUGH        = 11,               
    NETDEV_CHN_OFF_REASON_WEAK_PWD_ERROR            = 12,               
    NETDEV_CHN_OFF_REASON_INVALID                   = 0xFF              
}NETDEV_CHN_OFF_REASON_E;

/**
 * @enum tagNETDEVPoEStatus
 * @brief POE
 * @attention  None
 */
typedef enum tagNETDEVPoEStatus
{
    NETDEV_POE_STATUS_NORMAL                = 1,                
    NETDEV_POE_STATUS_POWER_SHORTAGE        = 2,                
    NETDEV_POE_STATUS_POWER_OVERLOAP        = 4,                
    NETDEV_POE_STATUS_NONEED_POWER          = 8,                
    NETDEV_POE_STATUS_INVALID               = 0xFF              
}NETDEV_POE_STATUS_E;

/**
 * @enum tagNETDEVVideoChnFindType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVideoChnFindType
{
    NETDEV_VIDEO_CHN_FIND_TYPE_ALL              = 0,         
    NETDEV_VIDEO_CHN_FIND_TYPE_DEV_ORG_ID       = 1,         /* IDID */
    NETDEV_VIDEO_CHN_FIND_TYPE_DEV_ID           = 2,         /* ID */
    NETDEV_VIDEO_CHN_FIND_TYPE_ORG_ID           = 3,         /* ID */
    NETDEV_VIDEO_CHN_FIND_TYPE_INVALID          = 0XFF       
}NETDEV_VIDEO_CHN_FIND_TYPE_E;

/**
 * @enum tagNETDEVOrgFindMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOrgFindMode
{
    NETDEV_ORG_FIND_MODE_ID                 = 0,            /* ID */
    NETDEV_ORG_FIND_MODE_TYPE               = 1,            
    NETDEV_ORG_FIND_MODE_INVALID            = 0XFF          
}NETDEV_ORG_FIND_MODE_E;

/**
 * @enum tagNETDEVDeviceSubType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDeviceSubType
{
    NETDEV_DTYPE_SUB_NVR                = 0,                /* NVR */
    NETDEV_DTYPE_SUB_IPC                = 1,                /* IPC */
    NETDEV_DTYPE_SUB_DC_INNER           = 2,                /* DC */ 
    NETDEV_DTYPE_SUB_DC_EXT             = 3,                /* DC */
    NETDEV_DTYPE_SUB_EC                 = 4,                /* EC */
    NETDEV_DTYPE_SUB_VMS                = 5,                 
    NETDEV_DTYPE_SUB_DA                 = 6,                 
    NETDEV_DTYPE_SUB_ADU                = 7,                /* ADU */
    NETDEV_DTYPE_SUB_FISHEYE_IPC        = 8,                
    NETDEV_DTYPE_SUB_DECARD             = 9,                
    NETDEV_DTYPE_SUB_FACE_IPC           = 10,               
    NETDEV_DTYPE_SUB_ALARMHOST          = 11,               
    NETDEV_DTYPE_SUB_ACS                = 12,               
    NETDEV_DTYPE_SUB_FG                 = 13,               
    NETDEV_DTYPE_SUB_FACE_ACS           = 14,               
    NETDEV_DTYPE_SUB_PRIVATE_GENERAL_ACS= 15,               
    NETDEV_DTYPE_SUB_PRIVATE_ALARMHOST  = 16,               
    NETDEV_DTYPE_SUB_LOCK_WIFI          = 17,               /* WIFI */
    NETDEV_DTYPE_SUB_LOCK_NBIoT         = 18,               /* NBIoT */
    NETDEV_DTYPE_SUB_ID_RECOGNIZE       = 19,               
    NETDEV_DTYPE_SUB_UNKNOW             = 0xFF              
}NETDEV_DEVICE_SUB_TYPE_E;

/**
 * @enum tagNETDEVLayoutType
 * @brief /
 * @attention  None
 */
typedef enum tagNETDEVLayoutType
{
    /* Layout=aabb, aa bb */

    NETDEV_LAYOUT_TYPE_01          = 100,  /* 1      */
    NETDEV_LAYOUT_TYPE_02          = 200,  /* 2      */
    NETDEV_LAYOUT_TYPE_03          = 300,  /* 3      */
    NETDEV_LAYOUT_TYPE_04_1        = 400,  /* 4      */
    NETDEV_LAYOUT_TYPE_04_2        = 401,  /* 1+1+2  */
    NETDEV_LAYOUT_TYPE_05_1        = 500,  /* 1+3+1   */
    NETDEV_LAYOUT_TYPE_05_2        = 501,  /* 1+1+3   */
    NETDEV_LAYOUT_TYPE_06          = 600,  /* 1+5    */
    NETDEV_LAYOUT_TYPE_07          = 700,  /* 1+6    */
    NETDEV_LAYOUT_TYPE_08          = 800,  /* 1+7    */
    NETDEV_LAYOUT_TYPE_09          = 900,  /* 9      */
    NETDEV_LAYOUT_TYPE_10_1        = 1000, /* 1+9    */
    NETDEV_LAYOUT_TYPE_10_2        = 1001, /* 2+9    */
    NETDEV_LAYOUT_TYPE_13          = 1300, /* 1+12   */
    NETDEV_LAYOUT_TYPE_16          = 1600, /* 16     */
    NETDEV_LAYOUT_TYPE_17          = 1700, /* 1+16   */
    NETDEV_LAYOUT_TYPE_25          = 2500, /* 25     */
    NETDEV_LAYOUT_TYPE_32          = 3200, /* 3+1+28 */
    NETDEV_LAYOUT_TYPE_36          = 3600, /* 36     */
    NETDEV_LAYOUT_TYPE_64          = 6400, /* 64     */
    NETDEV_LAYOUT_TYPE_10001       = 10001,/* 1 */
    NETDEV_LAYOUT_TYPE_10002       = 10002,/* 2 */
    NETDEV_LAYOUT_TYPE_10003       = 10003,/* 3 */
    NETDEV_LAYOUT_TYPE_10004       = 10004,/* 4 */
    NETDEV_LAYOUT_TYPE_10005       = 10005,/* 5 */
    NETDEV_LAYOUT_TYPE_10006       = 10006,/* 6 */
    NETDEV_LAYOUT_TYPE_10007       = 10007,/* 7 */
    NETDEV_LAYOUT_TYPE_10008       = 10008,/* 8 */
    NETDEV_LAYOUT_TYPE_INVALID
}NETDEV_LAYOUT_TYPE_E;

/**
* @enum tagNETDEVDCSeqStatus
* @brief DC
* @attention  None
*/
typedef enum tagNETDEVDCSeqStatus
{
    NETDEV_DC_SEQSTATUS_START           = 0,            /*  */
    NETDEV_DC_SEQSTATUS_PAUSE           = 1,            /*  */
    NETDEV_DC_SEQSTATUS_STOP            = 2,            /*  */
    NETDEV_DC_SEQSTATUS_INVALID         = 0xff          
}NETDEV_DC_SEQ_STATUS_E;

/**
 * @enum tagNETDEVDCVideoFormat
 * @brief DC 
 * @attention  None
 */
typedef enum tagNETDEVDCVideoFormat
{
    NETDEV_DC_VF_PAL        = 0,
    NETDEV_DC_VF_NTSC       = 1,
    NETDEV_DC_VF_720P24     = 2,
    NETDEV_DC_VF_720P25     = 3,
    NETDEV_DC_VF_720P30     = 4,
    NETDEV_DC_VF_720P50     = 5,
    NETDEV_DC_VF_720P60     = 6,
    NETDEV_DC_VF_1080I48    = 7,
    NETDEV_DC_VF_1080I50    = 8,
    NETDEV_DC_VF_1080I60    = 9,
    NETDEV_DC_VF_1080P24    = 10,
    NETDEV_DC_VF_1080P25    = 11,
    NETDEV_DC_VF_1080P30    = 12,
    NETDEV_DC_VF_1080P50    = 13,
    NETDEV_DC_VF_1080P60    = 14,
    NETDEV_DC_VF_XGA60      = 15,
    NETDEV_DC_VF_SXGA60     = 16,
    NETDEV_DC_VF_UXGA60     = 17,
    NETDEV_DC_VF_SXGAP60HZ  = 18,
    NETDEV_DC_VF_WXGAP60HZ  = 19,
    NETDEV_DC_VF_WSXGA60HZ  = 20,
    NETDEV_DC_VF_4K30       = 21,
    NETDEV_DC_VF_4K60       = 22,
    NETDEV_DC_VF_MUXGA60HZ  = 23,
    NETDEV_DC_VF_QXGA60     = 41,
    NETDEV_DC_VF_WQXGA60    = 42,
    NETDEV_DC_VF_4M60       = 43,
    NETDEV_DC_VF_INVALID    = 0xff
}NETDEV_DC_VIDEOFORMAT_E;

/**
 * @enum tagNETDEVAlarmPlanType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVAlarmPlanType
{
    NETDEV_ALARM_PLAN_TYPE_STORE        = 0,            
    NETDEV_ALARM_PLAN_TYPE_BS           = 1,            /* B/S */
    NETDEV_ALARM_PLAN_TYPE_CS           = 2,            /* C/S */
    NETDEV_ALARM_PLAN_TYPE_INVALID      = 0xff          
}NETDEV_ALARM_PLAN_TYPE_E;

/**
 * @enum tagNETDEVPaneOperateType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVPaneOperateType
{
    NETDEV_PANE_OPERATE_TYPE_BIND_CHANNEL        = 0,            
    NETDEV_PANE_OPERATE_TYPE_UNBIND_CHANNEL      = 1,            
    NETDEV_PANE_OPERATE_TYPE_INVALID             = 0xff          
}NETDEV_PANE_OPERATE_TYPE_E;

/**
 * @enum tagNETDEVTimeTemplateType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVTimeTemplateType
{
    NETDEV_TIMETEMPLATE_TYPE_RECORD     = 0,                
    NETDEV_TIMETEMPLATE_TYPE_ALARM      = 1,                
    /* 23CSweb 2 3 */
    NETDEV_TIMETEMPLATE_TYPE_SEQUENCE   = 4,                
    NETDEV_TIMETEMPLATE_TYPE_ACS        = 5,                
    NETDEV_TIMETEMPLATE_TYPE_INVALID    = 0xFF              
}NETDEV_TIME_TEMPLATE_TYPE_E;

/**
 * @enum tagNETDEVAlarmLinkType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVAlarmLinkType
{
    NETDEV_ALARM_LINK_TYPE_STORE        = 0X01,         
    NETDEV_ALARM_LINK_TYPE_PRESET       = 0X02,         
    NETDEV_ALARM_LINK_TYPE_MONITOR      = 0X04,         
    NETDEV_ALARM_LINK_TYPE_SWITCHOUT    = 0X08,         
    NETDEV_ALARM_LINK_TYPE_EMAIL        = 0X10,         
    NETDEV_ALARM_LINK_TYPE_WALL         = 0X20,         
    NETDEV_ALARM_LINK_TYPE_BUZZER       = 0X40,         
    NETDEV_ALARM_LINK_TYPE_LOCALAUDIO   = 0X80,         
    NETDEV_ALARM_LINK_TYPE_INVALID      = 0xFF          
}NETDEV_ALARM_LINK_TYPE_E;

/**
 * @enum tagNETDEVEMapPicType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVEMapPicType
{
    NETDEV_EMAP_PIC_TYPE_MAP        = 0,                    
    NETDEV_EMAP_PIC_TYPE_MARKER     = 1,                    
    NETDEV_EMAP_PIC_TYPE_INVALID    = 0xFF                  
}NETDEV_EMAP_PIC_TYPE;

/**
 * @enum tagNETDEVEMapPicSubType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVEMapPicSubType
{
    NETDEV_EMAP_PIC_SUBTYPE_HOTAREA        = 0,                    
    NETDEV_EMAP_PIC_SUBTYPE_PTZ_IPC        = 1,                    
    NETDEV_EMAP_PIC_SUBTYPE_NON_PTZ_IPC    = 2,                    
    NETDEV_EMAP_PIC_SUBTYPE_ALARM          = 3,                    
    NETDEV_EMAP_PIC_SUBTYPE_ACS            = 4,                    
    NETDEV_EMAP_PIC_SUBTYPE_INVALID        = 0xFF                  
}NETDEV_EMAP_PIC_SUBTYPE;

/**
 * @enum tagNETDEVEMapMarkerType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVEMapMarkerType
{
    NETDEV_EMAP_MARKER_TYPE_HOTAREA       = 0,                    
    NETDEV_EMAP_MARKER_TYPE_VIDEO         = 1,                    
    NETDEV_EMAP_MARKER_TYPE_ALARMIN       = 2,                    
    NETDEV_EMAP_MARKER_TYPE_ACS           = 3,                    
    NETDEV_EMAP_MARKER_TYPE_INVALID       = 0xFF                  
}NETDEV_EMAP_MARKER_TYPE_E;

/**
 * @enum tagNETDEVEMapMarkerColor
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVEMapMarkerColor
{
    NETDEV_EMAP_MARKER_COLOR_GREEN       = 0,                    
    NETDEV_EMAP_MARKER_COLOR_WHITE       = 1,                    
    NETDEV_EMAP_MARKER_COLOR_RED         = 2,                    
    NETDEV_EMAP_MARKER_COLOR_YELLOW      = 3,                    
    NETDEV_EMAP_MARKER_COLOR_BLUE        = 4,                    
    NETDEV_EMAP_MARKER_COLOR_GRAY        = 5,                    
    NETDEV_EMAP_MARKER_COLOR_BLACK       = 6,                    
    NETDEV_EMAP_MARKER_COLOR_INVALID     = 0xFF                  
}NETDEV_EMAP_MARKER_COLOR_E;

/**
 * @enum tagNETDEVViewResType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVViewResType
{
    NETDEV_VIEW_TYPE_SCHEME     = 0,                        
    NETDEV_VIEW_TYPE_REALPLAY   = 1,                        
    NETDEV_VIEW_TYPE_INVALID    = 0xFF                      
}NETDEV_VIEW_TYPE_E;

/**
 * @enum tagNETDEVRoleMajorRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVRoleMajorRight
{
    
    NETDEV_MAJOR_DEV_VIDEO_CHANNEL                  = 1,               /*      NETDEV_MINOR_RIGHT_VIDEO_CHANNEL_E */
    NETDEV_MAJOR_DEV_AUDIO_CHANNEL                  = 2,               /*      NETDEV_MINOR_RIGHT_AUDIO_CHANNEL_E */
    NETDEV_MAJOR_DEV_ALARM_POINT_CHANNEL            = 5,               /*      NETDEV_MINOR_RIGHT_ALARM_POINT_CHANNEL_E */
    NETDEV_MAJOR_DEV_DOOR_CHANNEL                   = 6,               /*      NETDEV_MINOR_RIGHT_DOOR_CHANNEL_E */
    NETDEV_ROLE_MAJOR_DEV_TVWALL_RIGHT              = 7,               /*        NETDEV_MINOR_RIGHT_TVWALL_E */
    NETDEV_ROLE_MAJOR_DEV_PARKINGLOT_RIGHT          = 8,               /*        NETDEV_MINOR_RIGHT_PARKINGLOT_E */
    NETDEV_MAJOR_DEV_MAX                            = 9,

    
    NETDEV_MAJOR_OPER_PREVIEW                       = 100,              /*       NETDEV_MINOR_RIGHT_OPER_PREVIEW_E */
    NETDEV_MAJOR_OPER_ALARM                         = 101,              /*       NETDEV_MINOR_RIGHT_OPER_ALARM_E */
    NETDEV_MAJOR_OPER_EMAP                          = 102,              /*   NETDEV_MINOR_RIGHT_OPER_EMAP_E */
    NETDEV_MAJOR_OPER_VOICE                         = 103,              /*       NETDEV_MINOR_RIGHT_OPER_VOICE_E */
    NETDEV_MAJOR_OPER_TVWALL                        = 104,              /*     NETDEV_MINOR_RIGHT_OPER_TVWALL_E */
    NETDEV_MAJOR_OPER_MONITOR_SCHEME                = 105,              /*   NETDEV_MINOR_RIGHT_OPER_MONITOR_SCHEME_E */
    NETDEV_MAJOR_OPER_SEQUENCE_RESOURCE             = 106,              /*   NETDEV_MINOR_RIGHT_OPER_SEQUENCE_RESOURCE_E */
    NETDEV_MAJOR_OPER_INTELLIGENT                   = 107,              /*       NETDEV_MINOR_RIGHT_OPER_INTELLIGENT_E */
    NETDEV_MAJOR_OPER_ALARM_POINT_CONFIG            = 108,              
    NETDEV_MAJOR_OPER_DOOR_CONFIG                   = 109,              /*   NETDEV_MINOR_RIGHT_OPER_DOOR_CONFIG_E */
    NETDEV_MAJOR_OPER_FACE_RECOGNITION              = 110,              /*   NETDEV_MINOR_RIGHT_OPER_FACE_RECOGNITION_E */
    NETDEV_MAJOR_OPER_VEHICLE_RECOGNITION           = 111,              /*   NETDEV_MINOR_RIGHT_OPER_VEHICLE_RECOGNITION_E */
    NETDEV_MAJOR_OPER_MONITOR_VIEWPLAN              = 112,              /*   NETDEV_MINOR_RIGHT_OPER_VIEWPLAN_E */
    NETDEV_MAJOR_OPER_PARKINGLOT                    = 113,              /*     NETDEV_MINOR_RIGHT_OPER_PARKINGLOT */
    NETDEV_MAJOR_OPER_MONITOR_MIXEDDETECTION        = 114,              /*   NETDEV_MINOR_RIGHT_OPER_MIXEDDETECTION_E */
    NETDEV_MAJOR_OPER_MAX                           = 115,

    
    NETDEV_MAJOR_MGR_BAS_CONFIG                     = 200,              /*   NETDEV_MINOR_RIGHT_MGR_BASE_E */
    NETDEV_MAJOR_MGR_SVC_CONFIG                     = 201,              /*   NETDEV_MINOR_RIGHT_MGR_SVC_E */
    NETDEV_MAJOR_MGR_SYS_CONFIG                     = 202,              /*   NETDEV_MINOR_RIGHT_MGR_SYS_E */
    NETDEV_MAJOR_MGR_STATISTICS                     = 203,              /*   NETDEV_MINOR_RIGHT_MGR_STAT_E */
    NETDEV_ROLE_MAJOR_MGR_VIDEO_APPLICATION         = 204,              /*   NETDEV_MINOR_RIGHT_MGR_VIDEO_E */
    NETDEV_ROLE_MAJOR_MGR_ACS_CONFIG                = 205,              /*   NETDEV_MINOR_RIGHT_MGR_ACS_E */
    NETDEV_ROLE_MAJOR_MGR_PARKING_LOT               = 206,              /*     NETDEV_MINOR_RIGHT_MGR_PARK_LOT_CFG_E */
    NETDEV_MAJOR_MGR_MAX                            = 207,
    NETDEV_MAJOR_BULT                               = 300
}NETDEV_MAJOR_RIGHT_E;

/**
 * @enum tagNETDEVDevVChlRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDevVChlRight
{
    NETDEV_MINOR_VIDEO_CHANNEL_LIVE          = BIT0,            
    NETDEV_MINOR_VIDEO_CHANNEL_PLAYBACK      = BIT1,            
    NETDEV_MINOR_VIDEO_CHANNEL_DOWNLOAD      = BIT2,            
    NETDEV_MINOR_VIDEO_CHANNEL_PTZ           = BIT3,            
    NETDEV_MINOR_VIDEO_CHANNEL_CENTER_RECORD = BIT4,            
    NETDEV_MINOR_VIDEO_CHANNEL_ALL           = ((UINT32)(~0UL))
}NETDEV_MINOR_RIGHT_VIDEO_CHANNEL_E;

/**
 * @enum tagNETDEVDevAChlRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDevAChlRight
{
    NETDEV_MINOR_AUDIO_CHANNEL_TALK             = BIT0,        
    NETDEV_MINOR_AUDIO_CHANNEL_BROADCAST        = BIT1,        
    NETDEV_MINOR_AUDIO_CHANNEL_ASSOCIATEAUDIO   = BIT2,        
    NETDEV_MINOR_AUDIO_CHANNEL_ALL              = BIT32_MAX
}NETDEV_MINOR_RIGHT_AUDIO_CHANNEL_E;

/**
 * @enum tagNETDEVDevAPChlRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDevAPChlRightE
{
    NETDEV_MINOR_ALARM_POINT_CHANNEL_CONTROL = BIT0,      
    NETDEV_MINOR_ALARM_POINT_CHANNEL_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_ALARM_POINT_CHANNEL_E;

/**
 * @enum tagNETDEVDevDoorChlRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDevDoorChlRightE
{
    NETDEV_MINOR_DOOR_CHANNEL_CONTROL = BIT0,            
    NETDEV_MINOR_DOOR_CHANNEL_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_DOOR_CHANNEL_E;

/**
 * @enum tagNetDevTvwallRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevTvwallRightE
{
    NETDEV_ROLE_MINOR_TVWALL_CHANNEL_CONTROL         = BIT0, 
    NETDEV_ROLE_MINOR_TVWALL_CHANNEL_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_TVWALL_E;

/**
 * @enum tagNetDevParkingLotRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevParkingLotRightE
{
    NETDEV_ROLE_MINOR_PARKINGLOT_ENTRANCE_BIND      = BIT0, 
    NETDEV_ROLE_MINOR_PARKINGLOT_ALL = BIT32_MAX
}NETDEV_MINOR_RIGHT_PARKINGLOT_E;

/**
 * @enum tagNETDEVOperPreviewRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperPreviewRight
{
    NETDEV_MINOR_OPER_PREVIEW_LIVE          = BIT0,            
    NETDEV_MINOR_OPER_PREVIEW_PLAYBACK      = BIT1,            
    NETDEV_MINOR_OPER_PREVIEW_ALL           = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_PREVIEW_E;

/**
 * @enum tagNETDEVOperAlarmRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperAlarmRight
{
    NETDEV_MINOR_OPER_ALARM_CONFIG          = BIT0,            
    NETDEV_MINOR_OPER_ALARM_POP_UP_WINDOWS  = BIT1,            
    NETDEV_MINOR_OPER_ALARM_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_ALARM_E;

/**
 * @enum tagNETDEVOperEmapRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperEmapRight
{
    NETDEV_MINOR_OPER_EMAP_CONFIG           = BIT0,            
    NETDEV_MINOR_OPER_EMAP_OPERATE          = BIT1,            
    NETDEV_MINOR_OPER_EMAP_ALL              = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_EMAP_E;

/**
 * @enum tagNETDEVOperVoiceRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperVoiceRight
{
    NETDEV_MINOR_OPER_VOICE_TALK            = BIT0,            
    NETDEV_MINOR_OPER_VOICE_BROADCAST       = BIT1,            
    NETDEV_MINOR_OPER_VOICE_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_VOICE_E;

/**
 * @enum tagNETDEVOperTvwallRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperTvwallRight
{
    NETDEV_MINOR_OPER_TVWALL_CONFIG         = BIT0,            
    NETDEV_MINOR_OPER_TVWALL_OPERATE        = BIT1,            
    NETDEV_MINOR_OPER_TVWALL_ALL            = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_TVWALL_E;

/**
 * @enum tagNETDEVOperMonitorSchemeRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperMonitorSchemeRight
{
    NETDEV_MINOR_OPER_MONITOR_SCHEME_CONFIG  = BIT0,           
    NETDEV_MINOR_OPER_MONITOR_SCHEME_OPERATE = BIT1,           
    NETDEV_MINOR_OPER_MONITOR_SCHEME_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_MONITOR_SCHEME_E;

/**
 * @enum tagNETDEVOperSequenceResourceRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperSequenceResourceRight
{
    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_CONFIG  = BIT0,        
    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_OPERATE = BIT1,        
    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_SEQUENCE_RESOURCE_E;

/**
 * @enum tagNETDEVOperIntelligentRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperIntelligentRight
{
    NETDEV_MINOR_OPER_INTELLIGENT_PASSENGER_RFLOW   = BIT0,    
    NETDEV_MINOR_OPER_INTELLIGENT_VCA_ALARM_PIC     = BIT1,    
    NETDEV_MINOR_OPER_INTELLIGENT_ALL               = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_INTELLIGENT_E;

/**
 * @enum tagNETDEVOperDoorConfigRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperDoorConfigRightE
{
    NETDEV_MINOR_OPER_DOOR_CONFIG                              = BIT0,     
    NETDEV_MINOR_OPER_DOOR_ACCESS_RECORD_AND_ATTENDANCE_RECORD = BIT1,     
    NETDEV_MINOR_OPER_DOOR_PEOPLE_MANAGEMENT                   = BIT2,     
    NETDEV_MINOR_OPER_PERMISSION_GROUP_AND_VISITOR_BLACKLIST   = BIT3,     
    NETDEV_MINOR_OPER_DOOR_ALL                                 = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_DOOR_CONFIG_E;

/**
 * @enum tagNETDEVOperFaceRecognitionE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperFaceRecognitionE
{
    NETDEV_MINOR_OPER_REAL_TIME_MONITORING      = BIT0,     
    NETDEV_MINOR_OPER_DATABASE_MANAGE           = BIT1,     
    NETDEV_MINOR_OPER_DISPATCH_TASK             = BIT2,     
    NETDEV_MINOR_OPER_ALARM_RECORD              = BIT3,     
    NETDEV_MINOR_OPER_SMARTNVR_CONFIG           = BIT4,     /* NVR */
    NETDEV_MINOR_OPER_HISTORY_RECORD            = BIT5,     
    NETDEV_MINOR_OPER_FACE_RECOGNITION_ALL      = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_FACE_RECOGNITION_E;

/**
 * @enum tagNETDEVOperVehicleRecognitionE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOperVehicleRecognitionE
{
    NETDEV_MINOR_OPER_VEHICLE_REAL_TIME_MONITORING   = BIT0,          
    NETDEV_MINOR_OPER_VEHICLE_PASSING_RECORD         = BIT1,          
    NETDEV_MINOR_OPER_VEHICLE_DISPATCH_TASK          = BIT2,          
    NETDEV_MINOR_OPER_VEHICLE_HISTORY_RECORD         = BIT3,          
    NETDEV_MINOR_OPER_VEHICLE_DATABASE_MANAGE        = BIT4,          
    NETDEV_MINOR_OPER_VEHICLE_RECOGNITION_ALL       = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_VEHICLE_RECOGNITION_E;

/**
 * @enum tagNetDevOperSequencePlanRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevOperSequencePlanRightE
{
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_CONFIG  = BIT0,             
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_OPERATE = BIT1,             
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_ALL     = BIT32_MAX
} NETDEV_MINOR_RIGHT_OPER_VIEWPLAN_E;

/**
 * @enum tagNetDevOperParkingLotRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevOperParkingLotRightE
{
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_ENTRANCE_CHARGE     = BIT0,    
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_CHARGE_RECORD       = BIT1,    
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_PASSING_RECORD      = BIT2,    
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_ALL   = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_PARKINGLOT;

/**
 * @enum tagNetDevOperMixDetectionRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevOperMixDetectionRightE
{
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_REAL_TIME_MONITORING   = BIT0,    
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_PASSING_RECORD         = BIT1,    
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_ALL   = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_MIXEDDETECTION_E;

/**
 * @enum tagNETDEVMgrBaseRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMgrBaseRight
{
    NETDEV_MINOR_MGR_ORG                 = BIT0,             
    NETDEV_MINOR_MGR_USER                = BIT1,             
    NETDEV_MINOR_MGR_USER_ROLE           = BIT2,             
    NETDEV_MINOR_MGR_DEV                 = BIT3,             
    NETDEV_MINOR_MGR_DEV_CHANNEL         = BIT4,             
    NETDEV_MINOR_MGR_SERVER              = BIT5,             
    NETDEV_MINOR_MGR_LOGICORG            = BIT6,             
    NETDEV_MINOR_MGR_MGR_RES_RELATION    = BIT7,             
    NETDEV_MINOR_MGR_THIRD_ALARM         = BIT8,             
    NETDEV_MINOR_MGR_USER_TEMPLATE       = BIT9,             
    NETDEV_MINOR_MGR_BASE_ALL            = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_BASE_E;

/**
 * @enum tagNETDEVMgrSvcRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMgrSvcRight
{
    NETDEV_MINOR_MGR_RECORD_PLAN               = BIT0,          
    NETDEV_MINOR_MGR_RECORD_PLAN_TEMPLATE      = BIT1,          
    NETDEV_MINOR_MGR_ALARM_CONFIG              = BIT2,          
    NETDEV_MINOR_MGR_ALARM_PLAN_TEMPLATE       = BIT3,          
    NETDEV_MINOR_MGR_ALARM_CONTACTS            = BIT4,          
    NETDEV_MINOR_MGR_ALARM_NOTIFY_CONFIG       = BIT5,          
    NETDEV_MINOR_MGR_ALARM_LEVEL_CUSTOM        = BIT6,          
    NETDEV_MINOR_MGR_BACKUP_PLAN               = BIT7,          
    NETDEV_MINOR_MGR_USB_RECORD_BACKUP         = BIT8,          
    NETDEV_MINOR_MGR_SVC_ALL                   = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_SVC_E;

/**
 * @enum tagNETDEVMgrSysRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMgrSysRight
{
    NETDEV_MINOR_MGR_SYS_BASIC              = BIT0,            
    NETDEV_MINOR_MGR_SYS_DISK               = BIT1,            
    NETDEV_MINOR_MGR_SYS_NETWORK            = BIT2,            
    NETDEV_MINOR_MGR_SYS_MAINTAIN           = BIT3,            
    NETDEV_MINOR_MGR_SYS_SECURITY           = BIT4,            
    NETDEV_MINOR_MGR_SYS_BATCH              = BIT5,            
    NETDEV_MINOR_MGR_SYS_ALL                = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_SYS_E;

/**
 * @enum tagNETDEVMgrStatRight
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMgrStatRight
{
    NETDEV_MINOR_MGR_STAT_SERVER_DISK       = BIT0,         
    NETDEV_MINOR_MGR_STAT_SERVER_NETWORK    = BIT1,         
    NETDEV_MINOR_MGR_STAT_SERVER_USER       = BIT2,         
    NETDEV_MINOR_MGR_STAT_DEVICE            = BIT3,         
    NETDEV_MINOR_MGR_STAT_SYS_ALARM_LOG     = BIT4,         
    NETDEV_MINOR_MGR_STAT_DEVICE_RECORD     = BIT5,         
    NETDEV_MINOR_MGR_STAT_DEV_ALARM_LOG     = BIT6,         
    NETDEV_MINOR_MGR_STAT_OPER_LOG          = BIT7,         
    NETDEV_MINOR_MGR_STAT_PKTLOSS_RATE      = BIT8,         
    NETDEV_MINOR_MGR_STAT_DEVICE_RESOURCE   = BIT9,         
    NETDEV_MINOR_MGR_STAT_BACKUP_CAP        = BIT10,        
    NETDEV_MINOR_MGR_STAT_OVERVIEW          = BIT11,        
    NETDEV_MINOR_MGR_STAT_ALL               = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_STAT_E;

/**
 * @enum tagNetDevMgrVideoRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevMgrVideoRightE
{
    NETDEV_ROLE_MINOR_MGR_PREVIEW_LIVE        = BIT0,       
    NETDEV_ROLE_MINOR_MGR_PREVIEW_PLAYBACK    = BIT1,       
    NETDEV_ROLE_MINOR_MGR_PREVIEW_ALL         = BIT32_MAX
} NETDEV_MINOR_RIGHT_MGR_VIDEO_E;

/**
 * @enum tagNetDevMgrAcsMgrRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevMgrAcsMgrRightE
{
    NETDEV_ROLE_MINOR_MGR_PEOPLE_MANAGEMENT          = BIT0,     
    NETDEV_ROLE_MINOR_MGR_ROLETIME_TEMPLATE          = BIT1,     
    NETDEV_ROLE_MINOR_MGR_ACCESSROLE_GROUP           = BIT2,     
    NETDEV_ROLE_MINOR_MGR_AUTHORIZED_BY_PERSON       = BIT3,     
    NETDEV_ROLE_MINOR_MGR_AUTHORIZED_BY_DOOR         = BIT4,     
    NETDEV_ROLE_MINOR_MGR_CARD_MANAGEMENT            = BIT5,     
    NETDEV_ROLE_MINOR_MGR_ACS_ALL                    = BIT32_MAX
} NETDEV_MINOR_RIGHT_MGR_ACS_E;

/**
 * @enum tagNetDevMgrParkLotCfgRightE
 * @brief 
 * @attention  None
 */
typedef enum tagNetDevMgrParkLotCfgRightE
{
    NETDEV_ROLE_MINOR_MGR_PARKING_LOT             = BIT0,    
    NETDEV_ROLE_MINOR_MGR_REGULAR_VEHICLE         = BIT1,    
    NETDEV_ROLE_MINOR_MGR_VEHICLE_BLACK           = BIT2,    
    NETDEV_ROLE_MINOR_MGR_VEHICLE_FLOW            = BIT3,    
    NETDEV_ROLE_MINOR_MGR_CHARGE_STATISTIC        = BIT4,    
    NETDEV_ROLE_MINOR_MGR_PAYMENT_CONF            = BIT5,    /* -*/
    NETDEV_ROLE_MINOR_MGR_PARAM_CONF              = BIT6,    /* -*/
    NETDEV_ROLE_MINOR_MGR_GATE_SHIFT              = BIT7,    
    NETDEV_ROLE_MINOR_MGR_VEHICLE_INPARKINGLOT    = BIT8,    
    NETDEV_ROLE_MINOR_MGR_PARKING_PAY             = BIT9,    
    NETDEV_ROLE_MINOR_MGR_CHARGE_RULE             = BIT10,   
    NETDEV_ROLE_MINOR_MGR_TMP_CHARGE_RULE         = BIT11,       
    NETDEV_ROLE_MINOR_MGR_REG_CHARGE_RULE         = BIT12,   
    NETDEV_ROLE_MINOR_MGR_ABNORMAL_CHARGE_RULE    = BIT13,   
    NETDEV_ROLE_MINOR_MGR_VEHICLE_PASSRECORD      = BIT14,   
    NETDEV_ROLE_MINOR_MGR_TMPVEHICLE_CHARGE       = BIT15,   
    NETDEV_ROLE_MINOR_MGR_ALL                     = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_PARK_LOT_CFG_E;

/**
 * @enum tagNETDEVMinorOperViewplan
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMinorOperViewplan
{
    NETDEV_MONOR_OPER_MIXEDDETECTION_REAL_TIME_MONITORING   = 1,           
    NETDEV_MONOR_OPER_MIXEDDETECTION_PASSING_RECORD         = 2,           
    NETDEV_MONOR_OPER_MIXEDDETECTION_MIXEDDETECTION_ALL     = 0xff
}NETDEV_MONOR_OPER_VIEWPLAN_E;

/**
 * @enum tagNETDEVVmsHotStandbyModeE
 * @brief (0)
 * @attention  None
 */
typedef enum tagNETDEVVmsHotStandbyModeE
{
    NETDEV_HOTSTANDBY_MODE_DISABLE            = 0,    
    NETDEV_HOTSTANDBY_MODE_ACTIVITE           = 1,    
    NETDEV_HOTSTANDBY_MODE_BACKUP             = 2     
}NETDEV_VMS_HOTSTANDBYMODE_E;

/**
 * @enum tagNETDEVVmsStatusE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVmsStatusE
{
    NETDEV_VMS_OFFLINE               = 0,      
    NETDEV_VMS_ONLINE                = 1,      
    NETDEV_VMS_VERSION_INCONSISTENT  = 2,      
    NETDEV_VMS_SLAVE_REACH_LIMIT     = 3,      
    NETDEV_VMS_SLAVE_UNREGISTER      = 4,      
    NETDEV_VMS_IN_STANDBY_MODE       = 5       
}NETDEV_VMS_STATUS_E;

/**
 * @enum tagNETDEVVmsModeE
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVmsModeE
{
    NETDEV_VMS_MASTER      = 0,    
    NETDEV_VMS_SLAVE       = 1     
}NETDEV_VMS_MODE_E;

/**
 * @enum tagNETDEVAlarmLogCleanupFlagE
 * @brief ,1
 * @attention  None
 */
typedef enum tagNETDEVAlarmLogCleanupFlagE
{
    NETDEV_ALARM_LOG_CLEANUP      = 0,    
    NETDEV_ALARM_LOG_NOT_CLEANUP  = 1     
}NETDEV_ALARM_LOG_CLEANUP_FLAG_E;

/**
 * @enum tagNETDEVPTZCruiseCmd
 * @brief   PTZ patrol operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPTZTRACKCmd
{
    NETDEV_PTZ_TRACKCRUISE_START     = 0,      /*   Start route patrol*/
    NETDEV_PTZ_TRACKCRUISE_STOP      = 1,      /*   Stop route patrol*/
    NETDEV_PTZ_TRACKCRUISE_REC       = 2,      /*   Start recording route */
    NETDEV_PTZ_TRACKCRUISE_RECSTOP   = 3,      /*   Stop recording route */
    NETDEV_PTZ_TRACKCRUISE_ADD       = 4,      /*   Add patrol route  ID16 */
    NETDEV_PTZ_TRACKCRUISE_DEL       = 5       /*   Delete patrol route */
}NETDEV_PTZ_TRACKCMD_E;

/**
 * @enum tagNETDEVPTZGuardMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVPTZGuardMode
{
    NETDEV_PTZ_GUARD_MODE_PRESET    = 0,       
    NETDEV_PTZ_GUARD_MODE_CRUISE    = 1,       
    NETDEV_PTZ_GUARD_MODE_TRACK     = 2         
}NETDEV_PTZ_GUARD_MODE_E;

/**
 * @enum tagNETDEVPTZTrackStatus
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVPTZTrackStatus
{
    NETDEV_PTZ_TRACK_STATUS_FREE           = 0,                        /* ) */
    NETDEV_PTZ_TRACK_STATUS_RUN            = 1,                        
    NETDEV_PTZ_TRACK_STATUS_START_RECORD   = 2                         
}NETDEV_PTZ_TRACK_STATUS_E;

/**
 * @enum tagNETDEVPTZGuardCmd
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVPTZGuardCmd
{
    NETDEV_PTZ_GUARD_CMD_GET = 0,       
    NETDEV_PTZ_GUARD_CMD_SET = 1        
}NETDEV_PTZ_GUARD_CMD_E;

/**
 * @enum tagNETDEVOrgResponseStatus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOrgResponseStatus
{
    NETDEV_ORG_RESPONSE_SUCCESS           = 0,            
    NETDEV_ORG_RESPONSE_FAIL              = 1             
}NETDEV_ORG_RESPONSE_STAUTE_E;

/**
 * @enum tagNETDEVOrgType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOrgType
{
    NETDEV_ORG_TYPE_GENERAL            = 0,            
    NETDEV_ORG_TYPE_CLOUD              = 1,            
    NETDEV_ORG_TYPE_VIRTUAL            = 2,            
    NETDEV_ORG_TYPE_FAVORITES          = 3,            
    NETDEV_ORG_TYPE_DOMAIN             = 4,            
    NETDEV_ORG_TYPE_DOORGROUP          = 5,            
    NETDEV_ORG_TYPE_DEPT               = 6,            
    NETDEV_ORG_TYPE_APARTMENT          = 7,            
    NETDEV_ORG_TYPE_INVALID            = 0XFF          
}NETDEV_ORG_TYPE_E;

/**
 * @enum tagNETDEVPlansMode
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVPlansMode
{
    NETDEV_PLANS_MODE_TIMING            = 0,             
    NETDEV_PLANS_MODE_24HOUR            = 1,             /* 24 */
    NETDEV_PLANS_MODE_INVALID           = 0XFF           
}NETDEV_PLANS_MODE_E;

/**
 * @enum tagNETDEVTimeTemplatePlanType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVTimeTemplatePlanType
{
    NETDEV_TIME_TEMPLATE_PLAN_COMMON                        = 0,                  
    NETDEV_TIME_TEMPLATE_PLAN_MOTION                        = 1,                
    NETDEV_TIME_TEMPLATE_PLAN_ALARM                         = 2,                
    NETDEV_TIME_TEMPLATE_PLAN_MOTION_AND_ALARM              = 3,                
    NETDEV_TIME_TEMPLATE_PLAN_MOTION_OR_ALARM               = 4,                
    NETDEV_TIME_TEMPLATE_PLAN_MANUL                         = 5,                
    NETDEV_TIME_TEMPLATE_PLAN_DISCONNECT                    = 6,                
    NETDEV_TIME_TEMPLATE_PLAN_THIRD_STREAM                  = 7,                
    NETDEV_TIME_TEMPLATE_PLAN_VIDEO_LOSS                    = 8,                
    NETDEV_TIME_TEMPLATE_PLAN_AUDIODETECT                   = 9,                
    NETDEV_TIME_TEMPLATE_PLAN_EVENT_ALL_ALARM               = 10,               
    NETDEV_TIME_TEMPLATE_PLAN_ALL_RECORD_TYPE               = 11,               
    NETDEV_TIME_TEMPLATE_PLAN_INVALID                       = 0xFF              
}NETDEV_TIME_TEMPLATE_PLAN_TYPE_E;

/**
 * @enum tagNETDEVTVWallType
 * @brief XW
 * @attention  None
 */
typedef enum tagNETDEVTVWallType
{
    NETDEV_TVWALL_TYPE_DECODER = 0,                                 
    NETDEV_TVWALL_TYPE_SPLICER = 1,                                 
    NETDEV_TVWALL_TYPE_DECARD  = 2                                  
}NETDEV_TVWALL_TYPE_E;

/**
 * @enum tagNETDEVLeftRightAlignment
 * @brief 
 * @attention
 */
typedef enum tagNETDEVLeftRightAlignment
{
    NETDEV_FONT_LR_ALIGNMENT_LEFT     = 1,                  
    NETDEV_FONT_LR_ALIGNMENT_MID      = 2,                  
    NETDEV_FONT_LR_ALIGNMENT_RIGHT    = 3                   
}NETDEV_XW_LEFT_RIGHT_ALIGNMENT_E;

/**
 * @enum tagNETDEVUpDownAlignment
 * @brief 
 * @attention
 */
typedef enum tagNETDEVUpDownAlignment
{
    NETDEV_FONT_UD_ALIGNMENT_UP      = 1,                   
    NETDEV_FONT_UD_ALIGNMENT_MID     = 2,                   
    NETDEV_FONT_UD_ALIGNMENT_DOWN    = 3                    
}NETDEV_XW_UP_DOWN_ALIGNMENT_E;

/**
 * @enum tagNETDEVXWVirtualLEDInfo
 * @brief 
 * @attention
 */
typedef enum tagNETDEVSeqStatus
{
    NETDEV_SEQ_STATUS_EMPTY   = 0,                           
    NETDEV_SEQ_STATUS_RUNNING = 1,                           
    NETDEV_SEQ_STATUS_STOP    = 2,                           
    NETDEV_SEQ_STATUS_INVALID = 0xFF                         
}NETDEV_SEQ_STATUS_E;

/**
 * @enum tagNETDEVLapiTransProtocal
 * @brief    Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLapiTransProtocal
{
    NETDEV_LAPI_TRANS_PROTOCAL_TCP     = 0,              /* TCP */
    NETDEV_LAPI_TRANS_PROTOCAL_UDP     = 1               /* UDP */
}NETDEV_LAPI_TRANS_PROTOCAL_E;

 /**
 * @enum tagNETDEVXWVirtualLEDInfo
 * @brief 
 * @attention
 */
typedef enum tagNETDEVTVWallWndType
{
    NETDEV_WINDOWS_TYPE_NORMAL  = 0,                          
    NETDEV_WINDOWS_TYPE_ALARM   = 1,                          
    NETDEV_WINDOWS_TYPE_INVALID = 0xFF                        
}NETDEV_TVWALL_WND_TPYE_E;

/**
 * @enum tagNETDEVXWPlayBackCond
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWSeqCmd
{
    NETDEV_XW_SEQ_CMD_STOP     = 0,                          
    NETDEV_XW_SEQ_CMD_START    = 1,                          
    NETDEV_XW_SEQ_CMD_PAUSE    = 2,                          
    NETDEV_XW_SEQ_CMD_CONTINUE = 3,                          
    NETDEV_XW_SEQ_CMD_INVALID  = 0xFF                        
}NETDEV_XW_SEQ_CMD_E;

/**
 * @enum tagNETDEVXWSeqResourceType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWSeqResourceType
{
    NETDEV_XW_SEQ_RESOURCE_WND       = 0,                          
    NETDEV_XW_SEQ_RESOURCE_GROUP_WND = 1,                          
    NETDEV_XW_SEQ_RESOURCE_INVALID   = 0xFF                        
}NETDEV_XW_SEQ_RESOURCE_TYPE_E;

/**
 * @enum tagNETDEVLangType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVLangType
{
    NETDEV_LANG_TYPE_CHINESE             = 0,                           
    NETDEV_LANG_TYPE_ENGLISH             = 1,                           
    NETDEV_LANG_TYPE_TRADITIONAL_CHINESE = 2,                           
    NETDEV_LANG_TYPE_FRENCH              = 3,                           
    NETDEV_LANG_TYPE_GERMAN              = 4,                           
    NETDEV_LANG_TYPE_SPANISH             = 5,                           
    NETDEV_LANG_TYPE_ITALIAN             = 6,                           
    NETDEV_LANG_TYPE_PORTUGUESE          = 7,                           
    NETDEV_LANG_TYPE_RUSSIAN             = 8,                           
    NETDEV_LANG_TYPE_UKRAINIAN           = 9,                           
    NETDEV_LANG_TYPE_GRUANIAN            = 10,                          
    NETDEV_LANG_TYPE_DUTCH               = 11,                          
    NETDEV_LANG_TYPE_DANISH              = 12,                          
    NETDEV_LANG_TYPE_FINNISH             = 13,                          
    NETDEV_LANG_TYPE_SWEDISH             = 14,                          
    NETDEV_LANG_TYPE_NORWEGIAN           = 15,                          
    NETDEV_LANG_TYPE_LCELANDIC           = 16,                          
    NETDEV_LANG_TYPE_POLISH              = 17,                          
    NETDEV_LANG_TYPE_LITHUANIAN          = 18,                          
    NETDEV_LANG_TYPE_GREEK               = 19,                          
    NETDEV_LANG_TYPE_CZECH               = 20,                          
    NETDEV_LANG_TYPE_SLOVAK              = 21,                          
    NETDEV_LANG_TYPE_HUNGARIAN           = 22,                          
    NETDEV_LANG_TYPE_ROMAN               = 23,                          
    NETDEV_LANG_TYPE_SERBIAN             = 24,                          
    NETDEV_LANG_TYPE_CROATIAN            = 25,                          
    NETDEV_LANG_TYPE_SLOVENIAN           = 26,                          
    NETDEV_LANG_TYPE_BULGARIAN           = 27,                          
    NETDEV_LANG_TYPE_BELARUSIAN          = 28,                          
    NETDEV_LANG_TYPE_TURKISH             = 29,                          
    NETDEV_LANG_TYPE_ARABIC              = 30,                          
    NETDEV_LANG_TYPE_HEBREW              = 31,                          
    NETDEV_LANG_TYPE_HINDI               = 32,                          
    NETDEV_LANG_TYPE_BENGALI             = 33,                          
    NETDEV_LANG_TYPE_PERSIAN             = 34,                          
    NETDEV_LANG_TYPE_JAPANESE            = 35,                          
    NETDEV_LANG_TYPE_KOREAN              = 36,                          
    NETDEV_LANG_TYPE_THAI                = 37,                          
    NETDEV_LANG_TYPE_MALAYSIAN           = 38,                          
    NETDEV_LANG_TYPE_INDONESIAN          = 39,                          
    NETDEV_LANG_TYPE_FILIPINO            = 40,                          
    NETDEV_LANG_TYPE_LAO                 = 41,                          
    NETDEV_LANG_TYPE_VIETNAMESE          = 42,                          
    NETDEV_LANG_TYPE_MONGOLIAN           = 43,                          
    NETDEV_LANG_TYPE_ALBANIAN            = 44,                          
    NETDEV_LANG_TYPE_AZERBAIJANI         = 45,                          
    NETDEV_LANG_TYPE_GAELIC              = 46,                          
    NETDEV_LANG_TYPE_ESTONIAN            = 47,                          
    NETDEV_LANG_TYPE_BOSNIAN             = 48,                          
    NETDEV_LANG_TYPE_LOWLAND_SAXON       = 49,                          
    NETDEV_LANG_TYPE_PERUVIAN            = 50,                          
    NETDEV_LANG_TYPE_LATVIAN             = 51,                          
    NETDEV_LANG_TYPE_INVALID             = 0xFF                         
}NETDEV_LANG_TYPE_E;

/**
 * @enum tagNETDEVRegionType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVRegionType
{
    NETDEV_REGION_TYPE_ENGINEERING  = 0,                          
    NETDEV_REGION_TYPE_DISTRIBUTION = 1,                          
    NETDEV_REGION_TYPE_OVERSEAS     = 2,                          
    NETDEV_REGION_TYPE_INVALID      = 0xFF                        
}NETDEV_REGION_TYPE_E;

/**
 * @enum tagNETDEVCustomType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVCustomType
{
    NETDEV_CUSTOM_TYPE_GUARD   = 0,                               
    NETDEV_CUSTOM_TYPE_OLD 	   = 1,                               
    NETDEV_CUSTOM_TYPE_NEW     = 2,                               
    NETDEV_CUSTOM_TYPE_CUSTOM  = 3,                               
    NETDEV_CUSTOM_TYPE_INVALID = 0xFF                             
}NETDEV_CUSTOM_TYPE_E;

/**
 * @enum tagNETDEVManualRecordStatus
 * @brief 
 * @attention
 */
typedef enum tagNETDEVManualRecordStatus
{
    NETDEV_MANUAL_RECORD_STATUS_FREE       = 0,                            
    NETDEV_MANUAL_RECORD_STATUS_RECORDING  = 1,                      
    NETDEV_MANUAL_RECORD_STATUS_INVALID    = 0xFF                       
}NETDEV_MANUAL_RECORD_STATUS_E;

/**
 * @enum tagNETDEVXWSerialType
 * @brief 
 * @attention  None      
 */
typedef enum tagNETDEVXWSerialType
{
    NETDEV_XW_SERIAL_TYPE_RS232                    = 0,               /* 232 */
    NETDEV_XW_SERIAL_TYPE_RS422                    = 1,               /* 422 */
    NETDEV_XW_SERIAL_TYPE_RS485                    = 2,               /* 485 */
    NETDEV_XW_SERIAL_TYPE_INVALID                  = 0xFF             
}NETDEV_XW_SERIAL_TYPE_E;

/**
 * @enum tagNETDEVXWSerialMode
 * @brief 
 * @attention  None      
 */
typedef enum tagNETDEVXWSerialMode
{
    NETDEV_XW_SERIAL_MODE_BIG_CONTROL              = 0,               
    NETDEV_XW_SERIAL_MODE_CENTER_CONTROL           = 1,               
    NETDEV_XW_SERIAL_MODE_CONSOLE                  = 2,               /* Console */
    NETDEV_XW_SERIAL_MODE_INVALID                  = 0xFF             
}NETDEV_XW_SERIAL_MODE_E;

/**
 * @enum tagNETDEVXWWorkMode
 * @brief 
 * @attention  None      
 */
typedef enum tagNETDEVXWWorkMode
{
    NETDEV_XW_WORK_MODE_ALL                       = 0,               
    NETDEV_XW_WORK_MODE_SINGLE                    = 1,               
    NETDEV_XW_WORK_MODE_INVALID                   = 0xFF             
}NETDEV_XW_WORK_MODE_E;

/**
 * @enum tagNETDEVXWParityType
 * @brief  
 * @attention  None      
 */
typedef enum tagNETDEVXWParityType
{
    NETDEV_XW_PARITY_TYPE_NONE                    = 0,               
    NETDEV_XW_PARITY_TYPE_ODD                     = 1,               
    NETDEV_XW_PARITY_TYPE_EVEN                    = 2,               
    NETDEV_XW_PARITY_TYPE_INVALID                 = 0xFF             
}NETDEV_XW_PARITY_TYPE_E;

/**
 * @enum tagNETDEVXWFlowCtrl
 * @brief 
 * @attention  None      
 */
typedef enum tagNETDEVXWFlowCtrl
{
    NETDEV_XW_FLOW_CTRL_NONE                        = 0,               
    NETDEV_XW_FLOW_CTRL_SOFTWARE                    = 1,               
    NETDEV_XW_FLOW_CTRL_HARDWARE                    = 2,               
    NETDEV_XW_FLOW_CTRL_INVALID                     = 0xFF             
}NETDEV_XW_FLOW_CTRL_E;

/**
 * @enum tagNETDEVAlarmPointActionType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVAlarmPointActionType
{
    NETDEV_ALARMPOINT_ACTION_TYPE_ARM             = 0,                
    NETDEV_ALARMPOINT_ACTION_TYPE_DISARM          = 1,                
    NETDEV_ALARMPOINT_ACTION_TYPE_BYPASS          = 2,                
    NETDEV_ALARMPOINT_ACTION_TYPE_DISBYPASS       = 3,                
    NETDEV_ALARMPOINT_ACTION_TYPE_INVALID         = 0xFF              
}NETDEV_ALARMPOINT_ACTION_TYPE_E;

/**
 * @enum tagNETDEVAlarmPointActionType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVDoorCtrlActionType
{
    NETDEV_DOORCTRL_ACTION_TYPE_OPEN             = 0,                
    NETDEV_DOORCTRL_ACTION_TYPE_CLOSE            = 1,                
    NETDEV_DOORCTRL_ACTION_TYPE_INVALID          = 0xFF              
}NETDEV_DOORCTRL_ACTION_TYPE_E;

/**
 * @enum tagNETDEVACSPersonCommondType
 * @brief ()
 * @attention
 */
typedef enum tagNETDEVACSPersonCommondType
{
    NETDEV_ACS_PERSON_COMMOND_TYPE_GET            = 0,                
    NETDEV_ACS_PERSON_COMMOND_TYPE_MOD            = 1,                
    NETDEV_ACS_PERSON_COMMOND_TYPE_INVALID        = 0xFF              
}NETDEV_ACS_PERSON_COMMOND_TYPE_E;

/**
 * @enum tagNETDEVGenderType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVGenderType
{
    NETDEV_GENDER_TYPE_UNKNOW       = 0,        /* 0- */
    NETDEV_GENDER_TYPE_MAN          = 1,        /* 1- */
    NETDEV_GENDER_TYPE_WOMAN        = 2,        /* 2- */
    NETDEV_GENDER_TYPE_UNEXPLAINED  = 9,        /* 9- */
    NETDEV_GENDER_TYPE_INVALID      = 0xFF      
}NETDEV_GENDER_TYPE_E;

/**
 * @enum tagNETDEVFaceMemberIDType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVFaceMemberIDType
{
    NETDEV_FACE_MEMBER_ID_TYPE_ID_CARD                 = 0,               
    NETDEV_FACE_MEMBER_ID_TYPE_IC_CARD                 = 1,               /* IC */
    NETDEV_FACE_MEMBER_ID_TYPE_PASSPORT                = 2,               
    NETDEV_FACE_MEMBER_ID_TYPE_DRIVING                 = 3,               
    NETDEV_FACE_MEMBER_ID_TYPE_OTHER                   = 99,              
    NETDEV_FACE_MEMBER_ID_TYPE_INVALID                 = 0xFF             
}NETDEV_FACE_MEMBER_ID_TYPE_E;

/**
 * @enum tagNETDEVACSPersonType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVACSPersonType
{
    NETDEV_ACS_PERSON_TYPE_STAFF                      = 0,               
    NETDEV_ACS_PERSON_TYPE_VISITOR                    = 1,               
    NETDEV_ACS_PERSON_TYPE_STRANGER                   = 2,               
    NETDEV_ACS_PERSON_TYPE_BLACKLIST                  = 3,               
    NETDEV_ACS_PERSON_TYPE_INVALID                    = 0xFF             
}NETDEV_ACS_PERSON_TYPE_E;

/**
 * @enum tagNETDEVACSVisitStaus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVACSVisitStaus
{
    NETDEV_ACS_VISIT_STATUS_SCHEDULE                 = 0,               
    NETDEV_ACS_VISIT_STATUS_VISITING                 = 1,               
    NETDEV_ACS_VISIT_STATUS_LEAVE                    = 2,               
    NETDEV_ACS_VISIT_STATUS_SCHEDULE_CANCEL          = 3,               
    NETDEV_ACS_VISIT_STATUS_TIMEOUT                  = 4,               
    NETDEV_ACS_VISIT_STATUS_INVALID                  = 0xFF             
}NETDEV_ACS_VISIT_STATUS_E;

/**
 * @enum tagNETDEVAlarmActionType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVAlarmActionType
{
    NETDEV_ALARM_ACTION_TYPE_CLOSE            = 0,                
    NETDEV_ALARM_ACTION_TYPE_OPEN             = 1,                
    NETDEV_ALARM_ACTION_TYPE_INVALID          = 0xFF              
}NETDEV_ALARM_ACTION_TYPE_E;

/**
 * @enum tagNETDEVAlarmStatusType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVAlarmStatusType
{
    NETDEV_ALARM_STATUS_TYPE_INACTIVE           = 0,                
    NETDEV_ALARM_STATUS_TYPE_ACTIVE             = 1,                
    NETDEV_ALARM_STATUS_TYPE_INVALID            = 0xFF              
}NETDEV_ALARM_STATUS_TYPE_E;

/**
 * @enum tagNETDEVEmergencyBellType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVEmergencyBellType
{
    NETDEV_EMERGENCY_BELL_TYPE_SEHO    = 0,                          
    NETDEV_EMERGENCY_BELL_TYPE_HITEC   = 1,                          /* Hitec */
    NETDEV_EMERGENCY_BELL_TYPE_INVALID = 0xFF                        
}NETDEV_EMERGENCY_BELL_TYPE_E; 

/**
 * @enum tagNETDEVDiskModeType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDiskModeType
{
    NETDEV_DISK_MODE_TYPE_OLD            = 0,                
    NETDEV_DISK_MODE_TYPE_NEW            = 1,                
    NETDEV_DISK_MODE_TYPE_INVALID        = 0xFF              
}NETDEV_DISK_MODE_TYPE_E;

/**
 * @enum tagNETDEVEncodeChnStatus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChnStatus
{
    NETDEV_CHN_STATUS_OFFLINE          = 0,                /*  offline */
    NETDEV_CHN_STATUS_ONLINE           = 1,                /*  online */
    NETDEV_CHN_STATUS_VIDEO_LOSE       = 2,                /*  video lose */
    NETDEV_CHN_STATUS_INVALID          = 0xFF
}NETDEV_CHN_STATUS_E;

/**
 * @enum tagNETDEVChnAbnormalReason
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChnAbnormalReason
{
    NETDEV_CHN_ABNORMAL_REASON_PHYS_RSRC_NOT_EXIST         = 0,       
    NETDEV_CHN_ABNORMAL_REASON_NOT_CONNECTED_VIDEO_CABLE   = 1,       
    NETDEV_CHN_ABNORMAL_REASON_NO_INPUT_SIGNAL             = 2,       
    NETDEV_CHN_ABNORMAL_REASON_INVALID                     = 0xFF
}NETDEV_CHN_ABNORMAL_REASON_E;

/**
 * @enum tagNETDEVAlarmInChnStatus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVAlarmRunode
{
    NETDEV_ALARM_RUNMODE_OPEN       = 0,                /*   Always open */
    NETDEV_ALARM_RUNMODE_CLOSE      = 1,                /*   Always closed */
    NETDEV_ALARM_RUNMODE_INVALID    = 0xFF
}NETDEV_ALARM_RUNMODE_E;

/**
 * @enum tagNETDEVAlarmOutChnStatus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVAlarmOutChnStatus
{
    NETDEV_ALARMOUT_CHN_ACTIVE      = 0,
    NETDEV_ALARMOUT_CHN_INACTIVE    = 1,
    NETDEV_ALARMOUT_CHN_INVALID     = 0xFF
}NETDEV_ALARMOUT_CHN_STATUS_E;

/**
 * @enum tagNETDEVRecordLocation
 * @brief   Record location Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVRecordLocation
{
    NETDEV_RECORD_LOCATION_ALL                        = 0,                /*  */  
    NETDEV_RECORD_LOCATION_VMS                        = 1,                /* VMS */  
    NETDEV_RECORD_LOCATION_NVR                        = 2,                /* NVR */
    NETDEV_RECORD_LOCATION_BACKUP                     = 3,                /*  */
    NETDEV_RECORD_LOCATION_INVALID                    = 0xFF              
}NETDEV_RECORD_LOCATION_E;

/**
 * @enum tagNETDEVDeviceMainType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDeviceMainType
{
    NETDEV_DTYPE_MAIN_ENCODE            = 0,                
    NETDEV_DTYPE_MAIN_DECODE            = 1,                
    NETDEV_DTYPE_MAIN_VMS               = 2,                
    NETDEV_DTYPE_MAIN_DA                = 3,                
    NETDEV_DTYPE_MAIN_CLOUD             = 4,                
    NETDEV_DTYPE_MAIN_BAYONET           = 5,                
    NETDEV_DTYPE_MAIN_ACS               = 6,                
    NETDEV_DTYPE_MAIN_ALARMHOST         = 7,                
    NETDEV_DTYPE_MAIN_EXITENTRANCE      = 8,                
    NETDEV_DTYPE_MAIN_LOCK              = 9,                
    NETDEV_DTYPE_MAIN_PLAYER_MANAGER    = 10,               
    NETDEV_DTYPE_MAIN_PLAYER            = 11,               
    NETDEV_DTYPE_MAIN_UNKNOWN           = 0XFF              
}NETDEV_DEVICE_MAIN_TYPE_E;

/**
 * @enum tagNETDEVDeviceStatus
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDeviceStatus
{
    NETDEV_DEV_STATUS_OFFLINE                   = 0,                
    NETDEV_DEV_STATUS_ONLINE                    = 1,                
    NETDEV_DEV_STATUS_CONNECTING                = 2,                
    NETDEV_DEV_STATUS_PWD_ERROR                 = 3,                
    NETDEV_DEV_STATUS_NOT_SUPPORT               = 4,                
    NETDEV_DEV_STATUS_TIMEOUT                   = 5,                
    NETDEV_DEV_STATUS_WEAK_PWD_ERROR            = 6,                
    NETDEV_DEV_STATUS_NO_DYNAMIC_PWD            = 7,                
    NETDEV_DEV_STATUS_INVALID                   = 0XFF              
}NETDEV_DEVICE_STATUS_E;

/**
 * @enum tagNETDEVDeviceAccessMode
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVDeviceAccessMode
{
    NETDEV_DEV_ACCESS_MODE_IP_DOMAIN            = 0,                /* IP */ 
    NETDEV_DEV_ACCESS_MODE_P2P                  = 1,                /* P2P */
    NETDEV_DEV_ACCESS_MODE_UNP                  = 2,                /* UNP */
    NETDEV_DEV_ACCESS_MODE_INVALID              = 0XFF              
}NETDEV_DEVICE_ACCESS_MODE_E;

/**
 * @enum tagNETDEVChlType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChlType
{
    NETDEV_CHN_TYPE_ENCODE              = 0,                /* , NETDEV_CHN_STATUS_E  NETDEV_DEV_CHN_ENCODE_INFO_S*/
    NETDEV_CHN_TYPE_ALARMIN             = 1,                /* , NETDEV_ALARM_RUNMODE_E  NETDEV_DEV_CHN_ALARMIN_INFO_S */
    NETDEV_CHN_TYPE_ALARMOUT            = 2,                /* , NETDEV_ALARMOUT_CHN_STATUS_E  NETDEV_DEV_CHN_ALARMOUT_INFO_S*/
    NETDEV_CHN_TYPE_DECODE              = 3,                /*   NETDEV_DEV_CHN_DECODE_INFO_S*/
    NETDEV_CHN_TYPE_AUDIO               = 4,                /*   NETDEV_DEV_CHN_AUDIO_INFO_S */
    NETDEV_CHN_TYPE_NIC                 = 5,                
    NETDEV_CHN_TYPE_ALARMPOINT          = 6,                /*   NETDEV_DEV_CHN_DA_INFO_S*/
    NETDEV_CHN_TYPE_DOOR                = 7,                /*   NETDEV_DEV_CHN_DA_INFO_S*/
    NETDEV_CHN_TYPE_ADU_ENCODE          = 8,                /* ADU, NETDEV_CHN_STATUS_E #NETDEV_DEV_CHN_XW_ENCODE_INFO_S */
    NETDEV_CHN_TYPE_EMERGENCY           = 9,                /*   NETDEV_EMERGENCY_BELL_INFO_S */

    NETDEV_CHN_TYPE_INVALID             = 0xFF              
}NETDEV_CHN_TYPE_E;

/**
 * @enum tagNETDEVAlarmPointStatusType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVAlarmPointStatusType
{
    NETDEV_ALARM_POINT_STATUS_TYPE_UNKNOWN     = 0,             
    NETDEV_ALARM_POINT_STATUS_TYPE_ARM         = 1,             
    NETDEV_ALARM_POINT_STATUS_TYPE_DISARM      = 2,             
    NETDEV_ALARM_POINT_STATUS_TYPE_DISBYPASS   = 3,             
    NETDEV_ALARM_POINT_STATUS_TYPE_BYPASS      = 4,             
    NETDEV_ALARM_POINT_STATUS_TYPE_ZONEFAILURE = 5,             
    NETDEV_ALARM_POINT_STATUS_TYPE_INVALID     = 0xFF           
}NETDEV_ALARM_POINT_STATUS_TYPE_E;

/**
 * @enum tagNETDEVDoorStatusType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVDoorStatusType
{
    NETDEV_DOOR_STATUS_TYPE_UNKNOWN     = 0,             
    NETDEV_DOOR_STATUS_TYPE_CLOSE       = 1,             
    NETDEV_DOOR_STATUS_TYPE_OPEN        = 2,             
    NETDEV_DOOR_STATUS_TYPE_INVALID     = 0xFF           
}NETDEV_DOOR_STATUS_TYPE_E;

 /**
 * @enum tagNETDEVVideoSrcType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVVideoSrcType
{
    NETDEV_VIDEO_SRC_TYPE_BNC            = 0,                /* BNC*/
    NETDEV_VIDEO_SRC_TYPE_VGA            = 1,                /* VGA*/
    NETDEV_VIDEO_SRC_TYPE_HDMI           = 2,                /* HDMI */
    NETDEV_VIDEO_SRC_TYPE_DVI_D          = 3,                /* DVI_D*/
    NETDEV_VIDEO_SRC_TYPE_DVI_I          = 4,                /* DVI_I*/
    NETDEV_VIDEO_SRC_TYPE_DP             = 5,                /* DP*/
    NETDEV_VIDEO_SRC_TYPE_SDI            = 6,                /* SDI*/
    NETDEV_VIDEO_SRC_TYPE_INVALID        = 0xFF              
}NETDEV_VIDEO_SRC_TYPE_E;

/**
 *@enum tagNETDEVTrafficStatisticsFormType
 *@brief  
 *@attention  None
 */
typedef enum tagNETDEVTrafficStatisticsFormType
{
    NETDEV_TRAFFIC_STAT_FORM_BY_MINUTE  = 0,                  
    NETDEV_TRAFFIC_STAT_FORM_BY_HOUR    = 1,                  
    NETDEV_TRAFFIC_STAT_FORM_BY_DAY     = 2,                  
    NETDEV_TRAFFIC_STAT_FORM_BY_MONTH   = 3,                  
    NETDEV_TRAFFIC_STAT_FORM_BY_BUTT
}NETDEV_TRAFFIC_STATIC_FORM_TYPE_E;

/**
 *@enum tagNETDEVVehicleEventType
 *@brief 
 *@attention  None
 */
typedef enum tagNETDEVVehicleEventType
{
    NETDEV_VEHCILE_EVENT_TYPE_SNAPSHOT        = 0,       
    NETDEV_VEHCILE_EVENT_TYPE_MATCHALARM      = 1,       
    NETDEV_VEHCILE_EVENT_TYPE_MISMATCHALARM   = 2,       
    NETDEV_VEHCILE_EVENT_TYPE_BUTT            = 0xFF     
}NETDEV_VEHICLE_EVENT_TYPE_E;

/**
 *@enum tagNETDEVFaceEventType
 *@brief 
 *@attention  None
 */
typedef enum tagNETDEVFaceEventType
{
    NETDEV_FACE_EVENT_TYPE_SNAPSHOT       = 0,        
    NETDEV_FACE_EVENT_TYPE_MATCH_ALARM    = 1,        
    NETDEV_FACE_EVENT_TYPE_MISMATCH_ALARM = 2,        
    NETDEV_FACE_EVENT_TYPE_BUTT           = 0xFF      
}NETDEV_FACE_EVENT_TYPE_E;

/**
 * @enum tagNETDEVEventActionType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVEventActionType
{
    NETDEV_EVENT_ACTION_TYPE_ADD            = 0,                /*  */
    NETDEV_EVENT_ACTION_TYPE_DELETE         = 1,                /*  */
    NETDEV_EVENT_ACTION_TYPE_MODIFY         = 2,                /*  */
    NETDEV_EVENT_ACTION_TYPE_ONLINE         = 3,                /*  */
    NETDEV_EVENT_ACTION_TYPE_OFFLINE        = 4,                /*  */
    NETDEV_EVENT_ACTION_TYPE_EMAP_ALARM     = 5,                /*  */
    NETDEV_EVENT_ACTION_TYPE_INVALID        = 0xFF              
}NETDEV_EVENT_ACTION_TYPE_E;

/**
 * @enum tagNETDEVProtocal
 * @brief    Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVTransProtocal
{
    NETDEV_TRANS_PROTOCAL_UDP     = 0,            /* UDP */
    NETDEV_TRANS_PROTOCAL_TCP     = 1             /* TCP */
}NETDEV_TRANS_PROTOCAL_E;

/**
 * @enum tagNETDEVSessionType
 * @brief   
 * @attention  None
 */
typedef enum tagNETDEVSessionType
{
    NETDEV_SESSION_TYPE_FREE             = 0,             
    NETDEV_SESSION_TYPE_LIVE_ON_WALL     = 1,              
    NETDEV_SESSION_TYPE_PLAYBACK_ON_WALL = 2,              
    NETDEV_SESSION_TYPE_TURNING_ON_WALL  = 3               
}NETDEV_SESSION_TYPE_E;

/**
 * @enum tagNETDEVTransType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVTransType
{
    NETDEV_TRANS_TYPE_FORWORD     = 0,                        
    NETDEV_TRANS_TYPE_STRAIGHT    = 1                         
}NETDEV_TRANS_TYPE_E;

/**
*@enum tagNETDEVMyCloudOffErr
*@brief 
*@attention 
*/
typedef enum tagNETDEVMyCloudOffErr
{
    NETDEV_MYCLOUD_OFF_ERR_OK                                 = 0,      /* MyCloud */
    NETDEV_MYCLOUD_OFF_ERR_NOT_REGISTER                       = 1,      /* MyCloud */
    NETDEV_MYCLOUD_OFF_ERR_NET_UNREACHABLE                    = 2,      
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_ON_MSG_NO_RETURN           = 3,      /* UDP */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_ON_MSG_NO_SEND             = 4,      /* UDP */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_OFF_MSG_NO_RETURN          = 5,      /* UDP */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_OFF_MSG_NO_SEND            = 6,      /* UDP */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_EXCP_MSG_NO_RETURN         = 7,      /* UDP */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_EXCP_MSG_NO_SEND           = 8       /* UDP */
}NETDEV_MYCLOUD_OFF_ERR_E;

/**
*@enum tagNETDEVRegisterStatus
*@brief 
*@attention 
*/
typedef enum tagNETDEVRegisterStatus
{
    NETDEV_REGISTER_STATUS_OFFLINE            = 0,      
    NETDEV_REGISTER_STATUS_ONLINE             = 1,      
    NETDEV_REGISTER_STATUS_CANCELING          = 2,      
    NETDEV_REGISTER_STATUS_INVALID            = 0XFF    
}NETDEV_REGISTER_STATUS_E;

/**
*@enum tagNETDEVChnPermission
* @brief 
* @attention  3
*/
typedef enum tagNETDEVChnPermission
{
    NETDEV_CHN_PERMISSION_LIVE                  = BIT0,                 
    NETDEV_CHN_PERMISSION_PTZ                   = BIT1,                 
    NETDEV_CHN_PERMISSION_PLAYBACK              = BIT2,                 
    NETDEV_CHN_PERMISSION_MANU_RECORD           = BIT3,                 
    NETDEV_CHN_PERMISSION_LOCAL_BACK            = BIT4,                 
    NETDEV_CHN_PERMISSION_INVALID               = 0XFFFFFFFF            
}NETDEV_CHN_PERMISSION_TYPE_E;

/**
 * @enum tagNETDEVUserLevel
 * @brief ,
 * @attention 
*/
typedef enum tagNETDEVUserLevel
{
    NETDEV_USER_LEVEL_ADMINISTRATOR  = 0,           
    NETDEV_USER_LEVEL_OPERATOR       = 1,           
    NETDEV_USER_LEVEL_USER           = 2,           
    NETDEV_USER_LEVEL_Default        = 3,           
    NETDEV_USER_LEVEL_PUBLISH        = 4            
}NETDEV_USER_LEVEL_E;

/**
 * @enum tagNETDEVUserBasePermission
 * @brief 
 * @attention  
*/
typedef enum tagNETDEVUserBasePermission
{
    NETDEV_USER_BASE_PER_CONFIG           = BIT0,           
    NETDEV_USER_BASE_PER_UPGRADE          = BIT1,           
    NETDEV_USER_BASE_PER_LOG              = BIT2,           
    NETDEV_USER_BASE_PER_REBOOT           = BIT3            
}NETDEV_USER_BASE_PERMISSION_E;

/**
 * @ enum tagNETDEVFactoryResetModeType
 * @ brief 
 * @attention  None
 */
typedef enum tagNETDEVFactoryResetModeType
{
    NETDEV_FACTORY_RESET_SOFT             = 0,              
    NETDEV_FACTORY_RESET_HARD             = 1,              
    NETDEV_FACTORY_RESET_INVALID          = 0xFF            
}NETDEV_FACTORY_RESET_MODE_TYPE_E;

/**
* @enum tagNETDEVFileType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVFileType
{
    NETDEV_TYPE_FOLDER  = 0,    
    NETDEV_TYPE_FILE    = 1,    
    NETDEV_TYPE_INVALID = 0xff  
}NETDEV_FILE_TYPE_E;

/**
 * @enum tagNETDEVSeqResType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVSeqResType
{
    NETDEV_TYPE_SEQ_RES_REMOTE     = 0,             
    NETDEV_TYPE_SEQ_RES_LOCAL      = 1,             
    NETDEV_TYPE_SEQ_RES_INVALID    = 0xff           
}NETDEV_SEQ_RES_TYPE_E;

/**
* @enum tagNETDEVFacePassRecordType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVFacePassRecordType
{
    NETDEV_TYPE_FACE_PASS_SNAPSHOT          = 0,                
    NETDEV_TYPE_FACE_PASS_COM_SUCCESS       = 1,                
    NETDEV_TYPE_FACE_PASS_COM_FAIL          = 2,                
    NETDEV_TYPE_FACE_PASS_INVALID           = 0xff              
}NETDEV_FACE_PASS_RECORD_TYPE_E;

/**
* @enum tagNETDEVPersonResultCode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPersonResultCode
{
    NETDEV_PERSON_CODE_SUCCEED                        = 0,               
    NETDEV_PERSON_CODE_COMMON_FAIL                    = 1,               
    NETDEV_PERSON_CODE_SENDING                        = 2,               
    NETDEV_PERSON_CODE_DEV_NOT_SUPPORT                = 4,               
    NETDEV_PERSON_CODE_ARGORITHM_INIT_FAIL            = 1000,            
    NETDEV_PERSON_CODE_FACE_DETECT_FAIL               = 1001,            
    NETDEV_PERSON_CODE_PICTURE_NO_FACE                = 1002,            
    NETDEV_PERSON_CODE_JPEG_DECODE_FAIL               = 1003,            /* jpeg */
    NETDEV_PERSON_CODE_PICTURE_QUALITY_LOW            = 1004,            
    NETDEV_PERSON_CODE_PICTURE_ZOOM_FAIL              = 1005,            
    NETDEV_PERSON_CODE_INTELLECT_DISABLE              = 1006,            
    NETDEV_PERSON_CODE_PICTURE_TOO_SMALL              = 1007,            
    NETDEV_PERSON_CODE_PICTURE_TOO_LARGE              = 1008,            
    NETDEV_PERSON_CODE_RESOLUTION_TOO_LARGE           = 1009,            /* 1920*1080 */
    NETDEV_PERSON_CODE_PICTURE_NON_EXISTENT           = 1010,            
    NETDEV_PERSON_CODE_FACE_ELEMENTS_LIMIT            = 1011,            
    NETDEV_PERSON_CODE_INTELLECT_MODULE_MISMATCH      = 1012,            
    NETDEV_PERSON_CODE_DOCUMENT_ID_INVLID             = 1013,            
    NETDEV_PERSON_CODE_PICTURE_FORMAT_ERROR           = 1014,            
    NETDEV_PERSON_CODE_MONITOR_DEVICE_LIMIT           = 1015,            
    NETDEV_PERSON_CODE_FACE_LIBRARY_LOCKED            = 1016,            
    NETDEV_PERSON_CODE_FACE_LIBRARY_UPDATING          = 1017,            
    NETDEV_PERSON_CODE_JSON_DESERIALIZE_FAIL          = 1018,            /* Json */
    NETDEV_PERSON_CODE_BASE64_DECODE_FAIL             = 1019,            /* Base64 */
    NETDEV_PERSON_CODE_PICTURE_SIZE_MISMATCH          = 1020,            
    NETDEV_PERSON_CODE_DEV_PROTOCOL_DIFFER            = 1021,            
    NETDEV_PERSON_CODE_REACH_LIMIT                    = 1022,            
    NETDEV_PERSON_CODE_NO_SMART                       = 1023,            
    NETDEV_PERSON_CODE_DEV_BUSY                       = 1024,            
    NETDEV_PERSON_CODE_INVALID                        = 0xff             
}NETDEV_PERSON_RESULT_CODE_E;

/**
 * @enum tagNETDEVPersonMonitorOptResCode
 * @brief 
 * @attention VMS
 */
typedef enum tagNETDEVPersonMonitorOptResCode
{
    NETDEV_PERSON_MONITOR_CODE_INIT_DETECT_FAIL             = 11702,           
    NETDEV_PERSON_MONITOR_CODE_FACE_DETECT_FAIL             = 11703,           
    NETDEV_PERSON_MONITOR_CODE_IMAGE_NOT_FIND_FACE          = 11704,           
    NETDEV_PERSON_MONITOR_CODE_JPEG_PARSE_FAIL              = 11705,           /* jpeg */
    NETDEV_PERSON_MONITOR_CODE_IMAGE_MASS_NOT_ENOUGH        = 11706,           
    NETDEV_PERSON_MONITOR_CODE_IMAGE_ZOOM_FAIL              = 11707,           
    NETDEV_PERSON_MONITOR_CODE_NOT_START_SMART              = 11708,           
    NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_SMALL            = 11709,           
    NETDEV_PERSON_MONITOR_CODE_CREATE_FACE_LIB_FAIL         = 11710,           
    NETDEV_PERSON_MONITOR_CODE_CREATE_MONITOR_FAIL          = 11711,           
    NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_LARGE            = 11714,           
    NETDEV_PERSON_MONITOR_CODE_RESOLUTION_TOO_LARGE         = 11715,           /* 1920*1080 */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_NON_EXISTENT         = 11716,           
    NETDEV_PERSON_MONITOR_CODE_FACE_ELEMENTS_LIMIT          = 11717,           
    NETDEV_PERSON_MONITOR_CODE_INTELLECT_MODULE_MISMATCH    = 11718,           
    NETDEV_PERSON_MONITOR_CODE_DOCUMENT_ID_INVLID           = 11719,           
    NETDEV_PERSON_MONITOR_CODE_PICTURE_FORMAT_ERROR         = 11720,           
    NETDEV_PERSON_MONITOR_CODE_MONITOR_DEVICE_LIMIT         = 11721,           
    NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_LOCKED          = 11722,           
    NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_UPDATING        = 11723,           
    NETDEV_PERSON_MONITOR_CODE_JSON_DESERIALIZE_FAIL        = 11724,           /* Json */
    NETDEV_PERSON_MONITOR_CODE_BASE64_DECODE_FAIL           = 11725,           /* Base64 */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_SIZE_MISMATCH        = 11726            
}NETDEV_PERSON_MONITOR_OPT_RES_CODE_E;

/**
 * @enum tagNETDEVPTZDisplayMode
 * @brief 5ePTZ   5ePTZ display mode Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPTZDisplayMode
{
    NETDEV_PTZ_DISPLAY_ORIGINAL = 0,    
    NETDEV_PTZ_DISPLAY_5PTZ     = 1,    /*+5ePTZ*/
    NETDEV_PTZ_DISPLAY_INVALID  = 0xff  
}NETDEV_PTZ_DISPLAY_MODE_E;

/**
 * @enum tagNETDEVVehLaneType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVehLaneType
{
    NETDEV_VEH_LANE_TYPE_ENTRANCE                = 0,               
    NETDEV_VEH_LANE_TYPE_EXIT_NOCHARGE           = 1,               
    NETDEV_VEH_LANE_TYPE_EXITE_CHARGE            = 2,               
    NETDEV_VEH_LANE_TYPE_INVALID                 = 0xFF             
}NETDEV_VEH_LANE_TYPE_E;

/**
 * @enum tagNETDEVChgRuleType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChgRuleType
{
    NETDEV_CHG_RULE_TYPE_E_TEMPCHARGE              = 0,             
    NETDEV_CHG_RULE_TYPE_E_RECHARGE                = 1,             
    NETDEV_CHG_RULE_TYPE_E_ABNCHARGE               = 2,             
    NETDEV_CHG_RULE_TYPE_E_INVALID                 = 0xFF           
}NETDEV_CHG_RULE_TYPE_E;

/**
 * @enum tagNETDEVVehReleaseType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVehReleaseType
{
    NETDEV_VEH_RELEASE_TYPE_AUTO                 = 0,               
    NETDEV_VEH_RELEASE_TYPE_MANUAL               = 1,               
    NETDEV_VEH_RELEASE_TYPE_INVALID              = 0xFF             
}NETDEV_VEH_RELEASE_TYPE_E;

/**
 * @enum tagNETDEVVehAttrType
 * @brief ()
 * @attention  None
 */
typedef enum tagNETDEVVehAttrType
{
    NETDEV_VEH_ATTR_FIXED                         = 0,                
    NETDEV_VEH_ATTR_TEMPORARY                     = 1,                
    NETDEV_VEH_ATTR_FIXEDOVERDUE                  = 2,                
    NETDEV_VEH_ATTR_INVALID                       = 0xFF              
}NETDEV_VEH_ATTR_TYPE_E;

/**
 * @enum tagNETDEVChgType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVChgType
{
    NETDEV_CHG_TYPE_CASH                             = 0,                
    NETDEV_CHG_TYPE_ALIPY                            = 1,                
    NETDEV_CHG_TYPE_WECHAT                           = 2,                
    NETDEV_CHG_TYPE_UNIONPAY                         = 3,                
    NETDEV_CHG_TYPE_INVALID                          = 0xFF              
}NETDEV_CHG_TYPE_E;

/**
 * @enum tagNETDEVDateFormatType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVDateFormatType
{
    NETDEV_DATE_FORMAT_TYPE_YMD                     = 0,                
    NETDEV_DATE_FORMAT_TYPE_MDY                     = 1,                
    NETDEV_DATE_FORMAT_TYPE_DMY                     = 2,                
    NETDEV_DATE_FORMAT_TYPE_INVALID                 = 0xFF              
}NETDEV_DATE_FORMAT_TYPE_E;

/**
 * @enum tagNETDEVAgeRange
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVAgeRange
{
    NETDEV_AGE_RANGE_UNKNOW                                = 0,                
    NETDEV_AGE_RANGE_CHILD                                 = 1,                
    NETDEV_AGE_RANGE_JUVENILE                              = 2,                
    NETDEV_AGE_RANGE_Youth                                 = 3,                
    NETDEV_AGE_RANGE_MIDDLEAGE                             = 4,                
    NETDEV_AGE_RANGE_OLDAGE                                = 5,                
    NETDEV_AGE_RANGE_INVALID                               = 0xFF              
}NETDEV_AGE_RANGE_E;

/**
 * @enum tagNETDEVGlassFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVGlassFlag
{
    NETDEV_GLASS_FLAG_UNKNOW                              = 0,                 
    NETDEV_GLASS_FLAG_NO                                  = 1,                 
    NETDEV_GLASS_FLAG_YES                                 = 2,                 
    NETDEV_GLASS_FLAG_INVALID                             = 0xFF               
}NETDEV_GLASS_FLAG_E;

/**
 * @enum tagNETDEVGlassesStyle
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVGlassesStyle
{
    NETDEV_GLASSES_STYLE_UNKNOW                            = 0,                 
    NETDEV_GLASSES_STYLE_GENERAL                           = 1,                 
    NETDEV_GLASSES_STYLE_SUNLIGHT                          = 2,                 
    NETDEV_GLASSES_STYLE_OTHER                             = 99,                
    NETDEV_GLASSES_STYLE_INVALID                           = 0xFF               
}NETDEV_GLASSES_STYLE_E;

/**
 * @enum tagNETDEVMaskFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVMaskFlag
{
    NETDEV_MASK_FLAG_UNKNOW                        = 0,                 
    NETDEV_MASK_FLAG_NOT_WEAR                      = 1,                 
    NETDEV_MASK_FLAG_WEAR                          = 2,                 
    NETDEV_MASK_FLAG_INVALID                       = 0xFF               
}NETDEV_MASK_FLAG_E;

/**
 * @enum tagNETDEVSleevesLength
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVSleevesLength
{
    NETDEV_SLEEVES_LENGTH_UNKNOW                           = 0,                 
    NETDEV_SLEEVES_LENGTH_SHORT                            = 1,                 
    NETDEV_SLEEVES_LENGTH_LONG                             = 2,                 
    NETDEV_SLEEVES_LENGTH_INVALID                          = 0xFF               
}NETDEV_SLEEVES_LENGTH_E;

/**
 * @enum tagNETDEVTrousersLength
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVTrousersLength
{
    NETDEV_TROUSERS_LENGTH_UNKNOW                           = 0,                 
    NETDEV_TROUSERS_LENGTH_SHORT                            = 1,                 
    NETDEV_TROUSERS_LENGTH_LONG                             = 2,                 
    NETDEV_TROUSERS_LENGTH_INVALID                          = 0xFF               
}NETDEV_TROUSERS_LENGTH_E;

/**
 * @enum tagNETDEVBodyToward
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVBodyToward
{
    NETDEV_BODY_TOWARD_UNKNOW                              = 0,                 
    NETDEV_BODY_TOWARD_POSITIVE                            = 1,                 
    NETDEV_BODY_TOWARD_SIDE                                = 2,                 
    NETDEV_BODY_TOWARD_BACK                                = 3,                 
    NETDEV_BODY_TOWARD_INVALID                             = 0xFF               
}NETDEV_BODY_TOWARD_E;

/**
 * @enum tagNETDEVShoesTubeLength
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVShoesTubeLength
{
    NETDEV_SHOES_TUBE_LENGTH_UNKNOW                       = 0,                  
    NETDEV_SHOES_TUBE_LENGTH_LONG                         = 1,                  
    NETDEV_SHOES_TUBE_LENGTH_SHORT                        = 2,                  /* / */
    NETDEV_SHOES_TUBE_LENGTH_INVALID                      = 0xFF                
}NETDEV_SHOES_TUBE_LENGTH_E;

/**
 * @enum tagNETDEVHairLength
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVHairLength
{
    NETDEV_HAIR_LENGTH_UNKNOW                            = 0,                   
    NETDEV_HAIR_LENGTH_LONG                              = 1,                   
    NETDEV_HAIR_LENGTH_SHORT                             = 2,                   
    NETDEV_HAIR_LENGTH_INVALID                           = 0xFF                 
}NETDEV_HAIR_LENGTH_E;

/**
 * @enum tagNETDEVBagFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVBagFlag
{
    NETDEV_BAG_FLAG_NO                                   = 0,                   
    NETDEV_BAG_FLAG_CARRY                                = 1,                   
    NETDEV_BAG_FLAG_BACK                                 = 2,                   
    NETDEV_BAG_FLAG_INVALID                              = 0xFF                 
}NETDEV_BAG_FLAG_E;

/**
 * @enum tagNETDEVSpeedType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVSpeedType
{
    NETDEV_SPEED_TYPE_UNKNOW                             = 0,                   
    NETDEV_SPEED_TYPE_STATIC                             = 1,                   
    NETDEV_SPEED_TYPE_SLOW                               = 2,                   
    NETDEV_SPEED_TYPE_MEDIUM                             = 3,                   
    NETDEV_SPEED_TYPE_FAST                               = 4,                   
    NETDEV_SPEED_TYPE_INVALID                            = 0xFF                 
}NETDEV_SPEED_TYPE_E;

/**
 * @enum tagNETDEVImageDirection
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVImageDirection
{
    NETDEV_IMAGE_DIRECTION_UNKNOW                        = 0,                   
    NETDEV_IMAGE_DIRECTION_STATIC                        = 1,                   
    NETDEV_IMAGE_DIRECTION_UP                            = 2,                   
    NETDEV_IMAGE_DIRECTION_DOWN                          = 3,                   
    NETDEV_IMAGE_DIRECTION_LEFT                          = 4,                   
    NETDEV_IMAGE_DIRECTION_RIGHT                         = 5,                   
    NETDEV_IMAGE_DIRECTION_LEFTUP                        = 6,                   
    NETDEV_IMAGE_DIRECTION_LEFTDOWN                      = 7,                   
    NETDEV_IMAGE_DIRECTION_RIGHTUP                       = 8,                   
    NETDEV_IMAGE_DIRECTION_RIGHTDOWN                     = 9,                   
    NETDEV_IMAGE_DIRECTION_INVALID                       = 0xFF                 
}NETDEV_IMAGE_DIRECTION_E;

/**
 * @enum tagNETDEVNonVehType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVNonVehType
{
    NETDEV_NON_VEH_TYPE_UNKNOW                           = 0,                   
    NETDEV_NON_VEH_TYPE_BICYCLE                          = 1,                   
    NETDEV_NON_VEH_TYPE_TRIYCLE                          = 2,                   
    NETDEV_NON_VEH_TYPE_MOTORCYCLE                       = 3,                   
    NETDEV_NON_VEH_TYPE_ELECTRIC_BICYCLE                 = 4,                   
    NETDEV_NON_VEH_TYPE_TWOWHEEL_VEHICLE                 = 5,                   /* //) */
    NETDEV_NON_VEH_TYPE_INVALID                          = 0xFF                 
}NETDEV_NON_VEH_TYPE_E;

/**
 * @enum tagNETDEVImageFormat
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVImageFormat
{
    NETDEV_IMAGE_FORMAT_JPG                              = 0,                   /* JPG */
    NETDEV_IMAGE_FORMAT_BMP                              = 1,                   /* BMP */
    NETDEV_IMAGE_FORMAT_PNG                              = 2,                   /* PNG */
    NETDEV_IMAGE_FORMAT_GIF                              = 3,                   /* GIF */
    NETDEV_IMAGE_FORMAT_TIFF                             = 4,                   /* TIFF */
    NETDEV_IMAGE_FORMAT_INVALID                          = 0xFF                 
}NETDEV_IMAGE_FORMAT_E;

/**
* @enum tagNETDEVClothesColor
* @brief  
* @attention  None
*/
typedef enum tagNETDEVClothesColor
{
    NETDEV_CLOTHES_COLOR_BLACK_E          = 0,            
    NETDEV_CLOTHES_COLOR_WHITE_E           = 1,           
    NETDEV_CLOTHES_COLOR_GRAY_E            = 2,           
    NETDEV_CLOTHES_COLOR_RED_E             = 3,           
    NETDEV_CLOTHES_COLOR_BLUE_E            = 4,           
    NETDEV_CLOTHES_COLOR_YELLOW_E          = 5,           
    NETDEV_CLOTHES_COLOR_ORANGE_E          = 6,           
    NETDEV_CLOTHES_COLOR_BROWN_E           = 7,           
    NETDEV_CLOTHES_COLOR_GREEN_E           = 8,           
    NETDEV_CLOTHES_COLOR_PURPLE_E          = 9,           
    NETDEV_CLOTHES_COLOR_CYAN_E            = 10,          
    NETDEV_CLOTHES_COLOR_PINK_E            = 11,          
    NETDEV_CLOTHES_COLOR_TRANSPARENT_E     = 12,          
    NETDEV_CLOTHES_COLOR_SILVERYWHITE_E    = 13,          
    NETDEV_CLOTHES_COLOR_DARK_E            = 14,          
    NETDEV_CLOTHES_COLOR_LIGHT_E           = 15,          
    NETDEV_CLOTHES_COLOR_COLOURLESS        = 16,          
    NETDEV_CLOTHES_COLOR_YELLOWGREEN       = 17,          
    NETDEV_CLOTHES_COLOR_GRADUALGREEN      = 18,          
    NETDEV_CLOTHES_COLOR_OTHER_E           = 99,          
    NETDEV_CLOTHES_COLOR_UNKNOW_E          = 100,         
    NETDEV_CLOTHES_COLOR_INVALID           = 0xFF         /*   Invalid value */
}NETDEV_CLOTHES_COLOR_E;

/**
* @enum tagNETDEVSupBoxDomeLinkage
* @brief 
* @attention  None
*/
typedef enum tagNETDEVSupBoxDomeLinkage
{
    NETDEV_SUP_BOX_DOME_LINKAGE_NO        = 0,          
    NETDEV_SUP_BOX_DOME_LINKAGE_GUN       = 1,          
    NETDEV_SUP_BOX_DOME_LINKAGE_DOME      = 2,          
    NETDEV_SUP_BOX_DOME_LINKAGE_INVALID   = 0xFF        
}NETDEV_SUP_BOX_DOME_LINKAGE_E;

/**
* @enum tagNETDEVlinkageType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVlinkageType
{
    NETDEV_LINKAGE_TYPE_CLICK_TRACK           = 0,          
    NETDEV_LINKAGE_TYPE_ENLARGE_FRAME         = 1,          
    NETDEV_LINKAGE_TYPE_3D_LOCATE             = 2,          /* 3D */
    NETDEV_LINKAGE_TYPE_INVALID               = 0xFF        
}NETDEV_LINKAGE_TYPE_E;

/**
* @enum tagNETDEVMasterSlaveLinkage
* @brief 
* @attention  None
*/
typedef enum tagNETDEVMasterSlaveLinkage
{
    NETDEV_MASTER_SLAVE_LINKAGE_NO           = 0,           
    NETDEV_MASTER_SLAVE_LINKAGE_HOST         = 1,           
    NETDEV_MASTER_SLAVE_LINKAGE_SLAVE        = 2,           
    NETDEV_MASTER_SLAVE_LINKAGE_INVALID      = 0xFF         
}NETDEV_MASTER_SLAVE_LINKAGE_E;

/**
* @enum  tagNETDEVMotionDetectAreaType
* @brief  motion detection area type emnu
* @attention 
*/
typedef enum tagNETDEVMotionDetectAreaType
{
    NETDEV_MOTION_DETECTION_AREA_TYPE_RECTANGLE         = 0,        /*   rectangle */
    NETDEV_MOTION_DETECTION_AREA_TYPE_MB                = 1,        /*   macro block */
    NETDEV_MOTION_DETECTION_AREA_TYPE_INVALID           = 0xff      /*  Invalid value */
}NETDEV_MOTION_DETECTION_AREA_TYPE_E;

/**
* @enum tagNETDEVNotificationType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVNotificationType
{
    NETDEV_NOTIFICATION_TYPE_REALTIME        = 0,           
    NETDEV_NOTIFICATION_TYPE_HISTORY         = 1,           
    NETDEV_NOTIFICATION_TYPE_EARLYWARN       = 2,           
    NETDEV_NOTIFICATION_TYPE_INVALID         = 0xFF         
}NETDEV_NOTIFICATION_TYPE_E;

/**
* @enum  tagNETDEVNICWorkMode
* @brief 
* @attention 
*/
typedef enum tagNETDEVNICWorkMode
{
    NETDEV_NIC_WORK_MODE_MULTI_ADDR_SET                 = 0,        
    NETDEV_NIC_WORK_MODE_LOAD_BALANCE                   = 1,        
    NETDEV_NIC_WORK_MODE_NETWORK_FAULT_TOLERANCE        = 2,        
    NETDEV_NIC_WORK_MODE_INVALID                        = 0xff      
}NETDEV_NIC_WORK_MODE_E;

/**
* @enum  tagNETDEVPortWorkMode
* @brief 
* @attention 
*/
typedef enum tagNETDEVPortWorkMode
{
    NETDEV_PORT_WORK_MODE_SELF_NEGOTIATION           = 0,        
    NETDEV_PORT_WORK_MODE_10M_FULL                   = 1,        /* 10M FULL */
    NETDEV_PORT_WORK_MODE_10M_HALF                   = 2,        /* 10M HALF */
    NETDEV_PORT_WORK_MODE_100M_FULL                  = 3,        /* 100M FULL */
    NETDEV_PORT_WORK_MODE_100M_HALF                  = 4,        /* 100M HALF */
    NETDEV_PORT_WORK_MODE_1000M_FULL                 = 5,        /* 1000M FULL */
    NETDEV_PORT_WORK_MODE_10M_AUTO                   = 6,        /* 10M AUTO */
    NETDEV_PORT_WORK_MODE_100M_AUTO                  = 7,        /* 100M AUTO */
    NETDEV_PORT_WORK_MODE_1000M_AUTO                 = 8,        /* 1000M AUTO */

    NETDEV_PORT_WORK_MODE_WIFI_NORMAL                = 20,       /* WiFi normal */
    NETDEV_PORT_WORK_MODE_WIFI_SOFTAP                = 21,       /* WiFi softAP */
    NETDEV_PORT_WORK_MODE_WIFI_SNIFFER               = 22,       /* WiFi sniffer */

    NETDEV_PORT_WORK_MODE_4G_NORMAL                  = 31,       /* 4G normal */
    NETDEV_PORT_WORK_MODE_INVALID                    = 0xff      
}NETDEV_PORT_WORK_MODE_E;

/**
* @enum tagNETDEVCapSrc
* @brief 
* @attention  None
*/
typedef enum tagNETDEVCapSrc
{
    NETDEV_CAP_SRC_FACE                      = 1,          
    NETDEV_CAP_SRC_ENTRANCE_GUARDCARD        = 2,          
    NETDEV_CAP_SRC_ID                        = 3,          
    NETDEV_CAP_SRC_GATE                      = 4,          
    NETDEV_CAP_SRC_INVALID                   = 0xff        /*  Invalid value */
}NETDEV_CAP_SRC_E;

/**
* @enum tagNETDEVMatchStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVMatchStatus
{
    NETDEV_MATCH_STATUS_SUCCESS               = 1,          
    NETDEV_MATCH_STATUS_FAIL                  = 2,          /* ) */
    NETDEV_MATCH_STATUS_NO_MONITOR_TIME       = 3,          
    NETDEV_MATCH_STATUS_ATTR_ABNORMAL         = 10,         /* ) */
    NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_SUCC = 41,         
    NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_FAIL = 42,         
    NETDEV_MATCH_STATUS_INVALID               = 0xff        /*  Invalid value */
}NETDEV_MATCH_STATUS_E;

/**
* @enum tagNETDEVScaleEnabled
* @brief 
* @attention  None
*/
typedef enum tagNETDEVScaleEnabled
{
    NETDEV_SCALE_ENABLED_NO                  = 0,           
    NETDEV_SCALE_ENABLED_IN                  = 1,           
    NETDEV_SCALE_ENABLED_FULL                = 2,           
    NETDEV_SCALE_ENABLED_INVALID             = 0xFF         
}NETDEV_SCALE_ENABLED_E;

/**
* @enum  tagNETDEVRecordTypeEx
* @brief 
* @attention 
*/
typedef enum tagNETDEVRecordTypeEx
{
    NETDEV_RECORD_TYPE_MANUALEX                     = 0x01,            
    NETDEV_RECORD_TYPE_COMON                        = 0x02,            /* (NVR) */
    NETDEV_RECORD_TYPE_MOVE_DETECT                  = 0x04,            
    NETDEV_RECORD_TYPE_INPUT_SWITCH                 = 0x08,            
    NETDEV_RECORD_TYPE_VIDEO_LOSS                   = 0x10,            
    NETDEV_RECORD_TYPE_AUDIO_DETECTION              = 0x20,            
    NETDEV_RECORD_TYPE_TRADEINFO                    = 0x40,            /* (NVR) */
    NETDEV_RECORD_TYPE_PLANNED                      = 0x80,            
    NETDEV_RECORD_TYPE_FACE_DETECTION               = 0x100,           
    NETDEV_RECORD_TYPE_CROSS_LINE_DETECT            = 0x200,           
    NETDEV_RECORD_TYPE_INTRUSION_DETECT             = 0x400,           
    NETDEV_RECORD_TYPE_IMAGE_BLURRY                 = 0x800,           
    NETDEV_RECORD_TYPE_GLOBAL_SCENE_CHANGE          = 0x1000,          
    NETDEV_RECORD_TYPE_INTE_MOTION                  = 0x2000,          
    NETDEV_RECORD_TYPE_EMERGENCYBELL                = 0x4000,          
    NETDEV_RECORD_TYPE_FACEMATCH_BAACKLIST          = 0x8000,          /* (NVR) */
    NETDEV_RECORD_TYPE_FACEMATCH_WHITELIST          = 0x10000,         /* (NVR) */
    NETDEV_RECORD_TYPE_REMAIN_ARTICLE               = 0x20000,         
    NETDEV_RECORD_TYPE_ARTICLE_MOVE                 = 0x40000,         
    NETDEV_RECORD_TYPE_PLATEMATCH_BAACKLIST         = 0x80000,         /* (NVR) */
    NETDEV_RECORD_TYPE_PLATEMATCH_WHITELIST         = 0x100000,        /* (NVR) */
    NETDEV_RECORD_TYPE_HUMAN_DETECTION              = 0x200000,        
    NETDEV_RECORD_TYPE_INVALID                      = 0xffffffff       
}NETDEV_RECORD_TYPE_EX_E;

/**
* @enum  tagstNETDEVEventRecordType
* @brief 
* @attention 
*/
typedef enum tagstNETDEVEventRecordType
{
    NETDEV_EVENT_RECORD_TYPE_MOVE_DETECT               = 1,         
    NETDEV_EVENT_RECORD_TYPE_ALARM_INPUT               = 2,         
    NETDEV_EVENT_RECORD_TYPE_MA                        = 3,         /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_M_A                       = 4,         /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_MANUAL_STORAGE            = 5,         /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_BROKENNET                 = 6,         /* IPC(NVR) */
    NETDEV_EVENT_RECORD_TYPE_THIRDSTREAM_STORAGE       = 7,         /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_VIDEO_LOSS                = 8,         
    NETDEV_EVENT_RECORD_TYPE_AUDIO_DETECTION           = 9,         
    NETDEV_EVENT_RECORD_TYPE_FACE_DETECTION            = 12,        
    NETDEV_EVENT_RECORD_TYPE_CROSS_LINE_DETECT         = 13,        
    NETDEV_EVENT_RECORD_TYPE_INTRUSION_DETECT          = 14,        
    NETDEV_EVENT_RECORD_TYPE_ALL_ALARM                 = 15,        
    NETDEV_EVENT_RECORD_TYPE_POS_EVENT                 = 16,        /* POS(NVR) */
    NETDEV_EVENT_RECORD_TYPE_IMAGETOOBLURR             = 17,        
    NETDEV_EVENT_RECORD_TYPE_GLOBAL_SCENE_CHANGE       = 18,        
    NETDEV_EVENT_RECORD_TYPE_INTE_MOTION               = 19,        
    NETDEV_EVENT_RECORD_TYPE_EMERGENCYBELL             = 20,        
    NETDEV_EVENT_RECORD_TYPE_FACEMATCH_BAACKLIST       = 21,        /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_FACEMATCH_WHITELIST       = 22,        /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_REMAIN_ARTICLE            = 23,        
    NETDEV_EVENT_RECORD_TYPE_ARTICLE_MOVE              = 24,        
    NETDEV_EVENT_RECORD_TYPE_PLATEMATCH_BAACKLIST      = 25,        /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_PLATEMATCH_WHITELIST      = 26,        /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_NO_LIST_PLAN              = 27,        /* (NVR) */
    NETDEV_EVENT_RECORD_TYPE_HUMAN_DETECTION           = 28,        
    NETDEV_EVENT_RECORD_TYPE_INVALID                   = 0xff       
}NETDEV_EVENT_RECORD_TYPE_E;

/**
* @enum tagNETDEVMapType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVMapType
{
    NETDEV_MAP_TYPE_PICTURE        = 0,           
    NETDEV_MAP_TYPE_ONLINE         = 1,           
    NETDEV_MAP_TYPE_OFFLINE        = 2,           
    NETDEV_MAP_TYPE_INVALID        = 0xFF         
}NETDEV_MAP_TYPE_E;

/**
* @enum  tagNETDEVExcpAlarmCapType
* @brief 
* @attention 
*/
typedef enum tagNETDEVExcpAlarmCapType
{
    NETDEV_ALARM_TYPE_STOR_ERR                        = 201,          

    NETDEV_ALARM_TYPE_PREVENT_REMOVE                  = 203,          
    NETDEV_ALARM_TYPE_IP_CONFLICT                     = 204,          /* IP */
    NETDEV_ALARM_TYPE_NET_OFF                         = 205,          
    NETDEV_ALARM_TYPE_DISK_OFFLINE                    = 206,          

    NETDEV_ALARM_TYPE_CPU_HIGHTEMP                    = 208,          /* CPU */
    NETDEV_ALARM_TYPE_MAINBOARD_HIGHTEMP              = 209,          
    NETDEV_ALARM_TYPE_DEVICE_HIGHTEMP                 = 210,          
    NETDEV_ALARM_TYPE_DEVICE_LOWTEMP                  = 211,          
    NETDEV_ALARM_TYPE_FAN_FAULT                       = 212,          
    NETDEV_ALARM_TYPE_LEDBOX_HIGHTEMP                 = 213,          
    NETDEV_ALARM_TYPE_LEDBOX_SMOKE                    = 214,          

    NETDEV_ALARM_TYPE_DISK_ABNORMAL                   = 403,          
    NETDEV_ALARM_TYPE_ILLEGAL_ACCESS                  = 404,          

    NETDEV_ALARM_TYPE_STORAGE_WILL_FULL               = 410,          
    NETDEV_ALARM_TYPE_STORAGE_IS_FULL                 = 411,          

    NETDEV_ALARM_TYPE_VIDEO_CAPTURE_ABNORMAL          = 417           /* / */
}NETDEV_EXCP_ALARM_CAP_TYPE_E;

/**
* @enum tagNETDEVOrderStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVOrderStatus
{
    NETDEV_ORDER_STATUS_FINISH            = 0,        
    NETDEV_ORDER_STATUS_UNFINISH          = 1,        
    NETDEV_ORDER_STATUS_PREPAYMENT        = 2,        
    NETDEV_ORDER_STATUS_INVALID           = 0xff      /*  Invalid value */
}NETDEV_ORDER_STATUS_E;

/**
* @enum tagNETDEVPayType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVPayType
{
    NETDEV_PAY_TYPE_CASH              = 0,        
    NETDEV_PAY_TYPE_ALIPAY            = 1,        
    NETDEV_PAY_TYPE_WECHAT            = 2,        
    NETDEV_PAY_TYPE_INVALID           = 0xff      /*  Invalid value */
}NETDEV_PAY_TYPE_E;

/**
* @enum tagNETDEVLAPISubType
* @brief LAPI
* @attention  None
*/
typedef enum tagNETDEVLAPISubType
{
    NETDEV_LAPI_SUB_TYPE_PARKRECOGNIZE           = 2048,      
    NETDEV_LAPI_SUB_TYPE_INVALID                 = 0xffffffff /*  Invalid value */
}NETDEV_LAPI_SUB_TYPE_E;

/**
* @enum  tagNETDEVAlarmSrcBelongType
* @brief 
* @attention 
*/
typedef enum tagNETDEVAlarmSrcBelongType
{
    NETDEV_ALARM_SRC_BELONG_TYPE_OTHER                     = 0,            
    NETDEV_ALARM_SRC_BELONG_TYPE_CHL                       = 1,            
    NETDEV_ALARM_SRC_BELONG_TYPE_DEV                       = 2,            
    NETDEV_ALARM_SRC_BELONG_TYPE_INVALID                   = 0xffff        
}NETDEV_ALARM_SRC_BELONG_TYPE_E;

/**
 * @enum  tagNETDEVColorTemperature
 * @brief 
 * @attention
 */
typedef enum tagNETDEVColorTemperature
{
    NETDEV_COLOR_TEMPERATURE_STANDARD               = 0,           
    NETDEV_COLOR_TEMPERATURE_COOL                   = 1,           
    NETDEV_COLOR_TEMPERATURE_WARM                   = 2,           
    NETDEV_COLOR_TEMPERATURE_INVALID                = 0xff         
}NETDEV_COLOR_TEMPERATURE_E;

/**
 * @enum  tagNETDEVCascadeDirection
 * @brief 
 * @attention
 */
typedef enum tagNETDEVCascadeDirection
{
    NETDEV_CASCADE_DIRECTION_RIGHT_TO_LEFT     = 1,        
    NETDEV_CASCADE_DIRECTION_LEFT_TO_RIGHT     = 2,        
    NETDEV_CASCADE_DIRECTION_BOTTOM_TO_TOP     = 3,        
    NETDEV_CASCADE_DIRECTION_TOP_TO_BOTTOM     = 4,        
    NETDEV_CASCADE_DIRECTION_INVALID           = 0xff      
}NETDEV_CASCADE_DIRECTION_E;

/**
 * @enum  tagNETDEVBlankingMode
 * @brief 
 * @attention
 */
typedef enum tagNETDEVBlankingMode
{
    NETDEV_BLANKING_MODE_ENHANCE     = 0,        
    NETDEV_BLANKING_MODE_CLOSE       = 1,        
    NETDEV_BLANKING_MODE_DEFAULT     = 2,        
    NETDEV_BLANKING_MODE_WEAKEN      = 3,        
    NETDEV_BLANKING_MODE_WEAKEST     = 4,        
    NETDEV_BLANKING_MODE_INVALID     = 0xff      
}NETDEV_BLANKING_MODE_E;

/**
 * @enum  tagNETDEVPointCalStatus
 * @brief 
 * @attention
 */
typedef enum tagNETDEVPointCalStatus
{
    NETDEV_POINT_CAL_STATUS_CLOSE      = 0,           
    NETDEV_POINT_CAL_STATUS_BRIGHT     = 1,           
    NETDEV_POINT_CAL_STATUS_CHROMA     = 2,           
    NETDEV_POINT_CAL_STATUS_INVALID    = 0xff         
}NETDEV_POINT_CAL_STATUS_E;

/**
 * @enum  tagNETDEVRecvCardChipType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVRecvCardChipType
{
    NETDEV_RECV_CARD_CHIP_TYPE_LS9929  = 0,           /* LS9929 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2153 = 1,           /* ICN2153 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2065 = 2,           /* ICN2065 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2069 = 3,           /* ICN2069 */
    NETDEV_RECV_CARD_CHIP_TYPE_INVALID = 0xff         
}NETDEV_RECV_CARD_CHIP_TYPE_E;

/**
 * @enum  tagNETDEVSeamCalDisplayMode
 * @brief 
 * @attention
 */
typedef enum tagNETDEVSeamCalDisplayMode
{
    NETDEV_SEAM_CAL_DISPLAY_MODE_NORMAL    = 0,           
    NETDEV_SEAM_CAL_DISPLAY_MODE_PIECE     = 1,           
    NETDEV_SEAM_CAL_DISPLAY_MODE_INVALID   = 0xff         
}NETDEV_SEAM_CAL_DISPLAY_MODE_E;

/**
 * @enum  tagNETDEVSceneSessionMode
 * @brief 
 * @attention
*/
typedef enum tagNETDEVSceneSessionMode
{
    NETDEV_SCENE_SESSION_MODE_CLASSICS               = 0,           
    NETDEV_SCENE_SESSION_MODE_ADAPTIVE_IN_SIGNAL_SRC = 1,           
    NETDEV_SCENE_SESSION_MODE_INVALID                = 0xff         
}NETDEV_SCENE_SESSION_MODE_E;

/**
 * @enum  tagNETDEVClearBadPointType
 * @brief 
 * @attention
*/
typedef enum tagNETDEVClearBadPointType
{
    NETDEV_CLEAR_BAD_POINT_TYPE_CUSTOMED         = 0,     
    NETDEV_CLEAR_BAD_POINT_TYPE_COMMON           = 1,     
    NETDEV_CLEAR_BAD_POINT_TYPE_ENHANCED         = 2,     
    NETDEV_CLEAR_BAD_POINT_TYPE_INVALID          = 0xff   
}NETDEV_CLEAR_BAD_POINT_TYPE_E;

/**
 * @enum tagNETDEVStorageCapUnit
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVStorageCapUnit
{
    NETDEV_TYPE_STORAGE_CAP_UNIT_GB               = 0,        /* GB */
    NETDEV_TYPE_STORAGE_CAP_UNIT_MB               = 1,        /* MB */
    NETDEV_TYPE_STORAGE_CAP_UNIT_INVALID          = 0xff      
}NETDEV_STORAGE_CAP_UNIT_E;

/**
 * @enum tagNETDEVStorageResType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVStorageResType
{
    NETDEV_STORAGE_RES_TYPE_SD        = 0,     /* SD */
    NETDEV_STORAGE_RES_TYPE_NAS       = 1,     /* NAS */
    NETDEV_STORAGE_RES_TYPE_INVALID   = 0xff   
}NETDEV_STORAGE_RES_TYPE_E;

/**
 * @enum tagNETDEVPicStorageMode
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVPicStorageMode
{
    NETDEV_PIC_STORAGE_MODE_NORMAL             = 0,     /* SD */
    NETDEV_PIC_STORAGE_MODE_PERMANENT          = 1,     /* SD */
    NETDEV_PIC_STORAGE_MODE_RETAIN             = 2,     /* SD */
    NETDEV_PIC_STORAGE_MODE_INVALID            = 0xff   
}NETDEV_PIC_STORAGE_MODE_E;

/**
 * @enum tagNETDEVFullStrategyType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVFullStrategyType
{
    NETDEV_FULL_STRATEGY_TYPE_FULL_COVERAGE              = 0,       
    NETDEV_FULL_STRATEGY_TYPE_FULL_STOP                  = 1,       
    NETDEV_FULL_STRATEGY_TYPE_INVALIDP                   = 0xff     
}NETDEV_FULL_STRATEGY_TYPE_E;

/**
 * @enum tagNETDEVIVAShowRule
 * @brief 
 * @attention 
*/
typedef enum tagNETDEVIVAShowRule
{
    NETDEV_IVA_SHOW_RULE                    = 0x00000001,          
    NETDEV_IVA_SHOW_RESULT_TOUTH_RULE       = 0x00000002,          
    NETDEV_IVA_SHOW_RESULT_UNTOUTH_RULE     = 0x00000004,          
    NETDEV_IVA_SHOW_TRACK                   = 0x00000008           
}NETDEV_IVA_SHOW_RULE_E;

/**
 * @enum tagNETDEVBackFocusCmd
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVBackFocusCmd
{
    NETDEV_BACKFOCUS_CMD_RESET              = 0,     /*  Para1  */
    NETDEV_BACKFOCUS_CMD_AUTO               = 1,     /*  Para1:(ms) */
    NETDEV_BACKFOCUS_CMD_MANUAL             = 2,     /*  Para1:0-, 1-MBF+, 2-MBF- */
    NETDEV_BACKFOCUS_CMD_INVALID            = 0xffff 
}NETDEV_BACKFOCUS_CMD_E;

/**
* @enum tagNETDEVACSCardStatus
* @brief 
* @attention  None
*/
typedef enum tagNETDEVACSCardStatus
{
    NETDEV_ACS_CARD_STATUS_BLANK                 = 0,       
    NETDEV_ACS_CARD_STATUS_ACTIVATION            = 1,       
    NETDEV_ACS_CARD_STATUS_FROZEN                = 2,       
    NETDEV_ACS_CARD_STATUS_CANCELLATION          = 3,       
    NETDEV_ACS_CARD_STATUS_INVALID               = 0xff     
}NETDEV_ACS_CARD_STATUS_E;

/**
* @enum tagNETDEVAVSCardType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVAVSCardType
{
    NETDEV_ACS_CARD_TYPE_IC                 = 0,            /* IC */
    NETDEV_ACS_CARD_TYPE_M1                 = 1,            /* M1 */
    NETDEV_ACS_CARD_TYPE_ID                 = 2,            /* ID*/
    NETDEV_ACS_CARD_TYPE_INVALID            = 0xff          
}NETDEV_ACS_CARD_TYPE_E;

/**
* @enum tagNETDEVTimeSynmode
* @brief 
* @attention  None
*/
typedef enum tagNETDEVTimeSynmode
{
    NETDEV_TIME_SYNCMODE_ACCEPT_ALL_SERVER           = 0,           
    NETDEV_TIME_SYNCMODE_SYNC_COMPUTER_SYSTEM        = 1,           
    NETDEV_TIME_SYNCMODE_SYNC_PHOTO_SERVER           = 2,           
    NETDEV_TIME_SYNCMODE_SYNC_NTP_SERVER             = 3,           /* NTP */
    NETDEV_TIME_SYNCMODE_SYNC_MANAGE_SERVER          = 4,           /* Onvif */
    NETDEV_TIME_SYNCMODE_SYNC_MANAGE_SERVER_ONVIF    = 5,           /* Onvif */
    NETDEV_TIME_SYNCMODE_SYNC_CLOUD_SERVER           = 6,           
    NETDEV_TIME_SYNCMODE_INVALID                     = 0xFF         
}NETDEV_TIME_SYNCMODE_E;

/**
 * @enum tagNETDEVSceneType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVSceneType
{
    NETDEV_SCENE_TYPE_CUSTOM                             = 0,                   
    NETDEV_SCENE_TYPE_INDOOR                             = 1,                   
    NETDEV_SCENE_TYPE_COMMON                             = 2,                   
    NETDEV_SCENE_TYPE_PLATE                              = 3,                   
    NETDEV_SCENE_TYPE_STARLIGHT                          = 4,                   
    NETDEV_SCENE_TYPE_OBJECT                             = 5,                              
    NETDEV_SCENE_TYPE_HIGH_SENSITIVITY                   = 6,                     
    NETDEV_SCENE_TYPE_STRONGLIGHT_SUPPRESSION            = 7,                   
    NETDEV_SCENE_TYPE_WIDE_DYNAMIC                       = 8,                   
    NETDEV_SCENE_TYPE_STANDARD                           = 9,                   
    NETDEV_SCENE_TYPE_BRIGHT                             = 10,                  
    NETDEV_SCENE_TYPE_GORGEOUS                           = 11,                  
    NETDEV_SCENE_TYPE_PARK_STRONGLIGHT_SUPPRESSION       = 12,                  
    NETDEV_SCENE_TYPE_FACE                               = 13,                  
    NETDEV_SCENE_TYPE_TRANSPARENT                        = 14,                  
    NETDEV_SCENE_TYPE_MIXED_TRADE                        = 15,                  
    NETDEV_SCENE_TYPE_INVALID                            = 0xff                 
}NETDEV_SCENE_TYPE_E;

/**
 * @enum tagNETDEVEnvType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVEnvType
{
    NETDEV_ENV_TYPE_ENV_ILLUM                         = 0,                   
    NETDEV_ENV_TYPE_PTZ_TILT_ANGLE                    = 1,                   
    NETDEV_ENV_TYPE_INVALID                           = 0xff                 
}NETDEV_ENV_TYPE_E;

/**
 * @enum tagNETDEVMoveDirection
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVMoveDirection
{
    NETDEV_MOVE_DIRECTION_STATIC                        = 1,                   
    NETDEV_MOVE_DIRECTION_UP                            = 2,                   
    NETDEV_MOVE_DIRECTION_DOWN                          = 3,                   
    NETDEV_MOVE_DIRECTION_LEFT                          = 4,                   
    NETDEV_MOVE_DIRECTION_RIGHT                         = 5,                   
    NETDEV_MOVE_DIRECTION_LEFTUP                        = 6,                   
    NETDEV_MOVE_DIRECTION_LEFTDOWN                      = 7,                   
    NETDEV_MOVE_DIRECTION_RIGHTUP                       = 8,                   
    NETDEV_MOVE_DIRECTION_RIGHTDOWN                     = 9,                   
    NETDEV_MOVE_DIRECTION_UNKNOW                        = 255,                 
    NETDEV_MOVE_DIRECTION_INVALID                       = 0xFFFF               
}NETDEV_MOVE_DIRECTION_E;

/**
 * @enum tagNETDEVCoatTexture
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVCoatTexture
{
    NETDEV_CLOTHES_TEXTURE_NO_PATTERNS                  = 1,         
    NETDEV_CLOTHES_TEXTURE_EXIST_PATTERNS               = 2,         
    NETDEV_CLOTHES_TEXTURE_UNKNOW                       = 255,       
    NETDEV_CLOTHES_TEXTURE_INVALID                      = 0xFFFF     
}NETDEV_CLOTHES_TEXTURE_E;

/**
 * @enum tagNETDEVPersonMaskFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVPersonMaskFlag
{
    NETDEV_PERSON_MASK_FLAG_NOT_WEAR                      = 1,                 
    NETDEV_PERSON_MASK_FLAG_WEAR                          = 2,                 
    NETDEV_PERSON_MASK_FLAG_UNKNOW                        = 255,               
    NETDEV_PERSON_MASK_FLAG_INVALID                       = 0xFFFF             
}NETDEV_PERSON_MASK_FLAG_E;

/**
 * @enum tagNETDEVSkinColorType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVSkinColorType
{
    NETDEV_SKINCOLOR_TYPE_UNKNOW                           = 0,                    
    NETDEV_SKINCOLOR_TYPE_WHITE                            = 2011,                 
    NETDEV_SKINCOLOR_TYPE_BLACK                            = 2012,                 
    NETDEV_SKINCOLOR_TYPE_YELLOW                           = 2013,                 
    NETDEV_SKINCOLOR_TYPE_BROWN                            = 2014,                 
    NETDEV_SKINCOLOR_TYPE_INVALID                          = 0xFF                  
}NETDEV_SKINCOLOR_TYPE_E;

/**
 * @enum tagNETDEVBeardFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVBeardFlag
{
    NETDEV_BEARD_FLAG_UNKNOW                        = 0,                 
    NETDEV_BEARD_FLAG_UNEXIST                       = 1,                 
    NETDEV_BEARD_FLAG_EXIST                         = 2,                 
    NETDEV_BEARD_FLAG_INVALID                       = 0xFF               
}NETDEV_BEARD_FLAG_E;

/**
 * @enum tagNETDEVEmotionFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVEmotionFlag
{
    NETDEV_EMOTION_FLAG_UNKNOW                        = 0,                 
    NETDEV_EMOTION_FLAG_ANGER                         = 1,                 
    NETDEV_EMOTION_FLAG_CALM                          = 2,                 
    NETDEV_EMOTION_FLAG_CONFUSED                      = 3,                 
    NETDEV_EMOTION_FLAG_ABHORRENT                     = 4,                 
    NETDEV_EMOTION_FLAG_HAPPY                         = 5,                 
    NETDEV_EMOTION_FLAG_SAD                           = 6,                 
    NETDEV_EMOTION_FLAG_AFRAID                        = 7,                 
    NETDEV_EMOTION_FLAG_AMAZED                        = 8,                 
    NETDEV_EMOTION_FLAG_SQUINT                        = 9,                 
    NETDEV_EMOTION_FLAG_SCREAM                        = 10,                
    NETDEV_EMOTION_FLAG_OTHER                         = 11,                
    NETDEV_EMOTION_FLAG_INVALID                       = 0xFF               
}NETDEV_EMOTION_FLAG_E;

/**
 * @enum tagNETDEVSmileFlag
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVSmileFlag
{
    NETDEV_SMILE_FLAG_UNKNOW                        = 0,                 
    NETDEV_SMILE_FLAG_NO                            = 1,                 
    NETDEV_SMILE_FLAG_YES                           = 2,                 
    NETDEV_SMILE_FLAG_INVALID                       = 0xFF               
}NETDEV_SMILE_FLAG_E;

/**
* @enum tagPictureFluency
* @brief 
* @attention 
*/
typedef enum tagNetSDKMediaMode
{
    NETDEV_MEDIA_MODE_LOCAL             = 0,                        
    NETDEV_MEDIA_MODE_REALPLAY          = 1,                        
    NETDEV_MEDIA_MODE_PLAYBACK          = 2,                        
    NETDEV_MEDIA_MODE_DOWNLOAD          = 3,                        
    NETDEV_MEDIA_MODE_VOICECOM          = 4,                        
    NETDEV_MEDIA_MODE_VOICESRV          = 5,                        
    NETDEV_MEDIA_MODE_M3U8PLAY          = 6,                        /* M3u8 */
    NETDEV_MEDIA_MODE_UNKNOWN           = 0xff                      
}NETDEV_MEDIA_MODE_E;

/**
 * @brief IPM ID
 * @attention  None
 */
typedef enum tagNETDEVIPMModelID
{
    NETDEV_DEVICE_IPM_MODEL_EDU_B1XX          = 0,            /* EDU-B1XX */
    NETDEV_DEVICE_IPM_MODEL_C                 = 1,            /* C */
    NETDEV_DEVICE_IPM_MODEL_BX_6QX_YD         = 2,            /* BX-6QX-YD */
    NETDEV_DEVICE_IPM_MODEL_BX_5EX            = 3,            /* BX-5EX */

    NETDEV_DEVICE_IPM_MODEL_PSD_100           = 100,          /* PSD-100 */

    NETDEV_DEVICE_IPM_MODEL_UNKNOW            = 0xFF          
}NETDEV_DEVICE_IPM_MODEL_ID_E;

/**
 * @enum tagNETDEVStartStreamProt
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVStartStreamProt
{
    NETDEV_START_STREAM_PROT_UDP      =1,
    NETDEV_START_STREAM_PROT_TCP      =2,
    NETDEV_START_STREAM_PROT_RTSP     =3,
    NETDEV_START_STREAM_PROT_HTTP     =4,
    NETDEV_START_STREAM_PROT_INVALID  =0xff
}NETDEV_START_STREAM_PROT_E;

/**
 * @enum tagNETDEVPTZDireection
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVPTZDirection
{
    NETDEV_PTZ_DIRECTION_EAST           = 0,            /*  east */
    NETDEV_PTZ_DIRECTION_SOUTHEAST      = 1,            /*  southeast */
    NETDEV_PTZ_DIRECTION_SOUTH          = 2,            /*  south */
    NETDEV_PTZ_DIRECTION_SOUTHWEST      = 3,            /*  southwest */
    NETDEV_PTZ_DIRECTION_WEST           = 4,            /*  west */
    NETDEV_PTZ_DIRECTION_NORTHWEST      = 5,            /*  northwest */
    NETDEV_PTZ_DIRECTION_NORTH          = 6,            /*  north */
    NETDEV_PTZ_DIRECTION_NORTHEAST      = 7,            /*  northeast  */
    NETDEV_PTZ_DIRECTION_AUTO           = 8,            /*  auto */
    NETDEV_PTZ_DIRECTION_INVALID        = 0xFFFF        /*  invalid value */
}NETDEV_PTZ_DIRECTION_E;

/**
 * @enum tagNETDEVIVAReportRuleType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVIVAReportRuleType
{
    NETDEV_IVA_REPORT_RULE_LINE = 0,           
    NETDEV_IVA_REPORT_RULE_POLY = 1,           
    NETDEV_IVA_REPORT_RULE_BUT
}NETDEV_IVA_REPORT_RULE_TYPE_E;

/**
 * @enum tagNETDEVIVAReportTrigType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVIVAReportTrigType
{
    NETDEV_IVA_REPORT_TRIG_NONE = 0,           
    NETDEV_IVA_REPORT_TRIG_BOTH = 1,           
    NETDEV_IVA_REPORT_TRIG_CW   = 2,           
    NETDEV_IVA_REPORT_TRIG_CCW  = 3,           
    NETDEV_IVA_REPORT_TRIG_IN   = 4,           
    NETDEV_IVA_REPORT_TRIG_OUT  = 5,           
    NETDEV_IVA_REPORT_TRIG_BUT
}NETDEV_IVA_REPORT_TRIG_TYPE_E;

/**
 * @enum tagNETDEVIVAReportColorType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVIVAReportColorType
{
    NETDEV_IVA_REPORT_COLOR_NONE   = 0,          
    NETDEV_IVA_REPORT_COLOR_DEEP   = 1,          
    NETDEV_IVA_REPORT_COLOR_LIGHT  = 2,          
    NETDEV_IVA_REPORT_COLOR_WHITE  = 3,          
    NETDEV_IVA_REPORT_COLOR_BLACK  = 4,          
    NETDEV_IVA_REPORT_COLOR_RED    = 5,          
    NETDEV_IVA_REPORT_COLOR_GREEN  = 6,          
    NETDEV_IVA_REPORT_COLOR_BLUE   = 7,          
    NETDEV_IVA_REPORT_COLOR_ORANGE = 8,          
    NETDEV_IVA_REPORT_COLOR_PURPLE = 9,          
    NETDEV_IVA_REPORT_COLOR_PINK   = 10,         
    NETDEV_IVA_REPORT_COLOR_YELLOW = 11,         
    NETDEV_IVA_REPORT_COLOR_BROWN  = 12,         
    NETDEV_IVA_REPORT_COLOR_GRAY   = 13,         
    NETDEV_IVA_REPORT_COLOR_BUT
}NETDEV_IVA_REPORT_COLOR_E;

/**
 * @enum tagNETDEVXWManageType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVXWManageType
{
    NETDEV_XW_MANAGE_TYPE_OTHER   = 0,                                
    NETDEV_XW_MANAGE_TYPE_XWARE   = 1,                                
    NETDEV_XW_MANAGE_TYPE_INVALID = 0XFF                              /*  invalid */
}NETDEV_XW_MANAGE_TYPE_E;

/**
* @enum tagNETDEVAddChnType
* @brief  
* @attention  None
*/
typedef enum tagNETDEVAddChnType
{
    NETDEV_ADDCHN_ADDR_TYPE_IP                   = 0,           /* IP */
    NETDEV_ADDCHN_ADDR_TYPE_PLUG_PLAY            = 1,           
    NETDEV_ADDCHN_ADDR_TYPE_EZDDNS               = 2,           /* EZDDNS */
    NETDEV_ADDCHN_ADDR_TYPE_DOMAIN_NAME          = 3,           
    NETDEV_ADDCHN_ADDR_TYPE_INVALID              = 0xFF         /*   Invalid value */
}NETDEV_ADDCHN_ADD_TYPE_E;

/**
* @enum tagNETDEVDataServerProtocolType
* @brief  
* @attention  None
 */
typedef enum tagNETDEVDataServerProtocolType
{
    NETDEV_DATA_SERVER_PROTOCOL_TYPE_TCP         = 1,   /* TCP,V2tms */
    NETDEV_DATA_SERVER_PROTOCOL_TYPE_TFTP_COMMOM = 4,   /* FTP: FTP  */
    NETDEV_DATA_SERVER_PROTOCOL_TYPE_HTTP_GA     = 51   /* HTTP:  */
}NETDEV_DATA_SERVER_PROTOCOL_TYPE_E;

/**
* @enum tagNETDEVManagerServerProtocolType
* @brief  
* @attention  None
 */
typedef enum tagNETDEVManagerServerProtocolType
{
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_IMOS   = 0,  /* IMOS */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_GB     = 1,  
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_NONE   = 2,  
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_VISS   = 3,  /* VISS */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_LY     = 4   
}NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_E;

/**
 * @enum tagNETDEVAlarmActID
 * @brief 
 * @attention
 */
typedef enum tagNETDEVAlarmActID
{
    ALARM_ACTION_TYPE_NVR_PREVIEW                = 0,                    /* NVRActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_BUZZER                     = 1,                    /* IPC,NVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_E_MAIL                     = 2,                    /* E-MailIPCNVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_RECORD                     = 3,                    /* IPCNVR ActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_PRESET                     = 4,                    /* ActParam NETDEV_PRESET_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_OUTPUT_SWITCH              = 5,                    /* ActParam NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_SNAP                       = 6,                    /* IPCActParam NVR ActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_BOX                        = 7,                    /* IPCNVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_CENTER_RECORD              = 8,                    /* IPCActParamNVR */
    ALARM_ACTION_TYPE_START_LOCAL_RECORD         = 9,                    /* IPCActParamNVR */
    ALARM_ACTION_TYPE_STOP_LOCAL_RECORD          = 10,                   /* IPCActParamNVR */
    ALARM_ACTION_TYPE_SNAP_UP_FTP                = 11,                   /* FTPIPCActParamNVR */
    ALARM_ACTION_TYPE_SNAP_UP_EMAIL              = 12,                   /* EMailIPCActParamNVR */
    ALARM_ACTION_TYPE_SNAP_UP_FTP_AND_EMAIL      = 13,                   /* FTPEMailIPCActParamNVR */
    ALARM_ACTION_TYPE_SMART_SNAP_UP              = 14,                   /* IPCActParamNVR */
    ALARM_ACTION_TYPE_FACE_PIC_SNAP_UP           = 15,                   /* IPCActParamNVR */
    ALARM_ACTION_TYPE_ALARM_REPORT               = 16,                   /* IPCActParamNVR */
    ALARM_ACTION_TYPE_PTZ_ZOOM                   = 17,                   /* IPC  */
    ALARM_ACTION_TYPE_INVALID                    = 0xff                  
}NETDEV_ALARM_ACT_ID_E;

/**
 * @enum tagPersonCompareResult
 * @brief 
 * @attention  None
 */
typedef enum tagPersonCompareResult
{
    NETDEV_TYPE_COMPARE_SUCCESS  = 1,                 
    NETDEV_TYPE_COMPARE_FAILED   = 2,                 
    NETDEV_TYPE_COMPARE_INVALID  = 0xff               
}NETDEV_PERSON_COMPARE_RESULT_TYPE_E;

/**
 * @enum tagClientType
 * @brief 
 * @attention  None
 */
typedef enum tagClientType
{
    NETDEV_CLIENT_TYPE_EZVMS    = 0,             /*  EZVMS */
    NETDEV_CLIENT_TYPE_EZGATE   = 1,             /*  EZGATE */
    NETDEV_CLIENT_TYPE_EZASSIST = 2,             /*  EZASSIST */
    NETDEV_CLIENT_TYPE_IVALID   = 0xff           
}NETDEV_CLIENT_TYPE_E;

/**
 * @enum tagNETDEVObjectType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVObjectType
{
    NETDEV_OBJECT_TYPE_FACE                              = 1,       
    NETDEV_OBJECT_TYPE_PERSON                            = 2,       
    NETDEV_OBJECT_TYPE_NON_MOTOR                         = 3,       
    NETDEV_OBJECT_TYPE_MOTOR                             = 4,       
    NETDEV_OBJECT_TYPE_UNKNOWN                           = 255,     /* / */
    NETDEV_OBJECT_TYPE_INVALID                           = 0xffff   
}NETDEV_OBJECT_TYPE_E;

/**
 * @enum tagNETDEVRuleType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVRuleType
{
    NETDEV_RULE_TYPE_INTRUSION_DETECTION                    = 0,       
    NETDEV_RULE_TYPE_CROSSLINE_DETECTION                    = 1,       
    NETDEV_RULE_TYPE_LEAVE_ZONE                             = 2,       
    NETDEV_RULE_TYPE_ENTER_ZONE                             = 3,       
    NETDEV_RULE_TYPE_ELEVATOR_ENTRANCE_DETECTION            = 4,       
    NETDEV_RULE_TYPE_INVALID                                = 0xff     
}NETDEV_RULE_TYPE_E;

/**
 * @enum tagNETDEVRuleTriggerType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVRuleTriggerType
{
    NETDEV_RULE_TRIGGER_TYPE_NO_TRIGGER                          = 0,       
    NETDEV_RULE_TRIGGER_TYPE_DUPLEX                              = 1,       
    NETDEV_RULE_TRIGGER_TYPE_CLOCKWISE                           = 2,       
    NETDEV_RULE_TRIGGER_TYPE_ANTIC_CLOCKWISE                     = 3,       
    NETDEV_RULE_TRIGGER_TYPE_ACCESS                              = 4,       
    NETDEV_RULE_TRIGGER_TYPE_LEAVE                               = 5,       
    NETDEV_RULE_TRIGGER_TYPE_INVALID                             = 0xff     
}NETDEV_RULE_TRIGGER_TYPE_E;

/**
 * @enum tagNETDEVObjectRecordType
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVObjectRecordType
{
    NETDEV_OBJECT_RECORD_TYPE_CROSSLINE_DETECTION                    = 0,       
    NETDEV_OBJECT_RECORD_TYPE_INTRUSION_DETECTION                    = 1,       
    NETDEV_OBJECT_RECORD_TYPE_ENTER_ZONE                             = 2,       
    NETDEV_OBJECT_RECORD_TYPE_LEAVE_ZONE                             = 3,       
    NETDEV_OBJECT_RECORD_TYPE_INVALID                                = 0xff     
}NETDEV_OBJECT_RECORD_TYPE_E;

/**
 * @enum tagNETDEVStatisticType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVStatisticType
{
    NETDEV_STATISTIC_TYPE_ALL                           = 0,               
    NETDEV_STATISTIC_TYPE_ENTER                         = 1,               
    NETDEV_STATISTIC_TYPE_LEAVE                         = 2,               
    NETDEV_STATISTIC_TYPE_INVALID                       = 0xFFFF           
}NETDEV_STATISTIC_TYPE_E;

/**
 * @enum tagNETDEVPeopleCountAlarmType
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVPeopleCountAlarmType
{
    NETDEV_PEOPLE_COUNT_ALARM_TYPE_AREA_RULE        = 0,               
    NETDEV_PEOPLE_COUNT_ALARM_TYPE_LINE_RULE        = 1,               
    NETDEV_PEOPLE_COUNT_ALARM_TYPE_CROWD_DENSITY    = 2,               
    NETDEV_PEOPLE_COUNT_ALARM_TYPE_INVALID          = 0xFFFF           
}NETDEV_PEOPLE_COUNT_ALARM_TYPE_E;

/**
 * @enum tagNETDEVCrowdDensityStatisticType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVCrowdDensityStatisticType
{
    NETDEV_CROWD_DENSITY_STATISTIC_TYPE_DENSITY     = 1,    
    NETDEV_CROWD_DENSITY_STATISTIC_TYPE_STRANDED    = 2,    
    NETDEV_CROWD_DENSITY_STATISTIC_TYPE_INVALID     = 0xff  
}NETDEV_CROWD_DENSITY_STATISTIC_TYPE_E;


/**
*@enum tagNETDEVTimeScaleStyle
*@brief 
*@attention 
*/
typedef enum tagNETDEVTimeScaleStyle
{
    NETDEV_SCALE_CIRCULAR                       = 0,                        
    NETDEV_SCALE_RECTANGLE                      = 1,                        
    NETDEV_SCALE_ARRAY                          = 3,                        
    NETDEV_SCALE_ROME                           = 4,                        
    NETDEV_SCALE_LINE                           = 5,                        
    NETDEV_TIME_SCALE_STYLE_INVALID             = 0xFF                      
}NETDEV_TIME_SCALE_STYLE_E;

/**
 *@enum tagNETDEVDateStyle
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVDateStyle
{
    NETDEV_DATE_STYLE_YYYY_MM_DD                = 1,           /* yyyy-MM-dd */
    NETDEV_DATE_STYLE_MM_DD_YYYY                = 2,           /* MM/dd/yyyy */
    NETDEV_DATE_STYLE_D_MM_YYYY                 = 3,           /* d/MM/yyyy */
    NETDEV_DATE_STYLE_YYYYMMDD                  = 4,           /* yyyy MM dd */
    NETDEV_DATE_STYLE_YYYY_M_DD                 = 5,           /* yyyy/M/dd */
    NETDEV_DATE_STYLE_MMMMDD_YYYY               = 6,           /* MMMM dd,yyyy */
    NETDEV_DATE_STYLE_DD_MM_YYYY                = 7,           /* dd/MM/yyyy */
    NETDEV_DATE_STYLE_DD_M_YYYY                 = 8,           /* dd,M,yyyy */
    NETDEV_DATE_STYLE_DD_MYYYY                  = 9,           /* dd/M yyyy */
    NETDEV_DATE_STYLE_DDMMMYYYY                 = 10,          /* dd MMM.yyyy */
    NETDEV_DATE_STYLE_DD_MMM_YYYY               = 11,          /* dd-MMM-yyyy  */
    NETDEV_DATE_STYLE_YYYYMDD                   = 12,          /* yyyyMdd */
    NETDEV_DATE_STYLE_INVALID                   = 0xFF         
}NETDEV_DATE_STYLE_E;

/**
 * @enum tagNETDEVHatStyle
 * @brief  
 * @attention  None
 */
typedef enum tagNETDEVHatStyle
{
    NETDEV_HAT_STYLE_WOOLEN_HAT_E                                   = 1,        
    NETDEV_HAT_STYLE_BERET_E                                        = 2,        
    NETDEV_HAT_STYLE_BASEBALL_CAP_E                                 = 3,        
    NETDEV_HAT_STYLE_FLAT_HAT_E                                     = 4,        
    NETDEV_HAT_STYLE_BUCKET_HAT_E                                   = 5,        
    NETDEV_HAT_STYLE_SLEEVE_CAP_E                                   = 6,        
    NETDEV_HAT_STYLE_PEAKED_CAP_E                                   = 7,        
    NETDEV_HAT_STYLE_BRIMMED_HAT_E                                  = 8,        
    NETDEV_HAT_STYLE_OTHER_E                                        = 99,       
    NETDEV_HAT_STYLE_INVALID                                        = 0xff      
}NETDEV_HAT_STYLE_E;
/* END*************   Enumeration value *************************** */

/* BEGIN***********   Structure *********************************** */
/**
 * @struct tagNETDEVDeviceInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceInfo
{
    INT32   dwDevType;                          /* ,#NETDEV_DEVICE_TYPE_E  Device type, see enumeration # NETDEV_DEVICE_TYPE_E */
    INT16   wAlarmInPortNum;                    /*   Number of alarm inputs */
    INT16   wAlarmOutPortNum;                   /*   Number of alarm outputs */
    INT32   dwChannelNum;                       /*   Number of Channels */
    BYTE    byRes[48];                          /*   Reserved */
}NETDEV_DEVICE_INFO_S,*LPNETDEV_DEVICE_INFO_S;

/**
 * @struct tagNETDEVDeviceBasicInfo
 * @brief   Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceBasicInfo
{ 
    CHAR szDevModel[NETDEV_LEN_64];                     /*   Device model */
    CHAR szSerialNum[NETDEV_LEN_64];                    /*   Hardware serial number */
    CHAR szFirmwareVersion[NETDEV_LEN_64];              /*   Software version */
    CHAR szMacAddress[NETDEV_LEN_64];                   /* IPv4Mac  MAC address of IPv4 */
    CHAR szDeviceName[NETDEV_LEN_64];                   /*   Device name */
    CHAR szManufacturer[NETDEV_LEN_64];                 /*   Manufacturer */
    BYTE byRes[384];                                    /*   Reserved */
}NETDEV_DEVICE_BASICINFO_S, *LPNETDEV_DEVICE_BASICINFO_S;

/**
 * @struct tagNETDEVNetworkInterfaces
 * @brief   Network configuration information
 * @attention  None
 */
typedef struct tagNETDEVNetworkInterfaces
{
    INT32   dwMTU;                              /* MTU  MTU value */
    BOOL    bIPv4DHCP;                          /* IPv4DHCP  DHCP of IPv4 */
    CHAR    szIpv4Address[NETDEV_LEN_32];       /* IPv4IP  IP address of IPv4 */
    CHAR    szIPv4GateWay[NETDEV_LEN_32];       /* IPv4  Gateway of IPv4 */
    CHAR    szIPv4SubnetMask[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
    BYTE    byRes[480];                         /*   Reserved */
}NETDEV_NETWORKCFG_S, *LPNETDEV_NETWORKCFG_S;

/**
 * @struct tagNETDEVVPNClientInfo
 * @brief VPN
 * @attention  None
 */
typedef struct tagNETDEVVPNClientInfo
{
    UINT32   udwEnabled;                                   /*  0:  1:  Support UNP or nota switch that corresponds to a compatible format, enable 0:unable  1:enable*/
    UINT32   udwCompatibilityMode;                         /*  0: Unp1.0unp 1: Unp2.0 (softvpn). Corresponds to the set compatibility mode.0: Unp1.0unp 1: Unp2.0 (softvpn) */
    UINT32   udwAuthEnabled;                               /* Unp2.00 1 Authentication open or close, if is Unp2.0, must authentication and open. 0:close 1:open  */
    UINT32   udwEncryptEnabled;                            /* , Unp1.0 0 1 */
    UINT32   udwInterface;                                 /* IPC NVRVMS0 ,4G 1[0,1]*/
    CHAR     szLoginName[NETDEV_DOMAIN_LEN];               /* AuthEnable[0-63]*/
    CHAR     szPIN[NETDEV_LEN_256];                        /* AuthEnable[0,256],*/
    UINT32   udwAddressType;                               
    CHAR     szAddress[NETDEV_IPADDR_STR_MAX_LEN];         /* AddressTypeIP 0: IPv4 1: IPv6 2: 3: IPv4IPv6.IPv4*/
    UINT32   udwPort;                                      /* ;NVR VMS[1-65535]Unp1.01701Unp2.0 5555*/ 
    UINT32   udwUNPSuccessd;                               /* UNP  (UNPip,,)1 0 */
    CHAR     szUNPShareIPAddr[NETDEV_IPADDR_STR_MAX_LEN];  /* UNP  (,) */
    CHAR     szUNPShareMask[NETDEV_IPADDR_STR_MAX_LEN];    /* UNP (,) */ 
    CHAR     szUNPShareWayAddr[NETDEV_IPADDR_STR_MAX_LEN]; /* UNP (,) */
    BYTE     byRes[256];                                   /*   Reserved*/
}NETDEV_VPN_CLIENT_INFO_S, *LPNETDEV_VPN_CLIENT_INFO_S;

/**
 * @struct tagSysemIPAddr
 * @brief   Address Structure definition 
 * @attention  None
 */
typedef struct tagSysemIPAddr
{
    INT32   eIPType;                                   /* #NETDEV_HOSTTYPE_E  Protocol type, see enumeration # NETDEV_HOSTTYPE_E */
    CHAR    szIPAddr[NETDEV_LEN_132];                  /* IP  IP address */
}NETDEV_SYSTEM_IPADDR_S, *LPNETDEV_SYSTEM_IPADDR_S;

/**
 * @struct tagNETDEVSystemNTPInfo
 * @brief  NTP NTP parameter
 * @attention  None
 */
typedef struct tagNETDEVSystemNTPInfo
{
    BOOL bSupportDHCP;                                    /* DHCP  Support DHCP or not */
    NETDEV_SYSTEM_IPADDR_S stAddr;                        /* NTP   NTP information */
}NETDEV_SYSTEM_NTP_INFO_S, *LPNETDEV_SYSTEM_NTP_INFO_S;

/**
* @struct tagSysemIPAddrInfo
* @brief NTP NTP parameter
* @attention  None
*/
typedef struct tagSysemIPAddrInfo
{
    BOOL         bEnabled;                         /* NTP 0  1  NTP Server enable 0:unable  1:enable */
    INT64        ulAddressType;                    /*  0IPv4  1IPv6()  2: NVR Address type  0:IPv4  1:IPv6(Temporary does not support)  2:domain name(NVR and AIO support)*/
    CHAR         szIPAddress[NETDEV_LEN_64];       /* NTPIP[0, 64] AddressType 0
                                                      The IP address of the NTP server ,character length range [0,64]. When address type is 0,the node must be selected. */
    CHAR         szDomainName[NETDEV_LEN_64];      /* NTP[ [0 64] AddressType 2
                                                      The domain name of the NTP server ,character length range [0,64]. When address type is 2,the node must be selected.*/
    INT64        ulPort;                           /* NTP[1-65535]  IPC NTP Port ,the range of [1-65535]. IPC does not support this configuration. */
    INT64        ulSynchronizeInterval;            /*  NVRVMS 5/10/15/301/2/3/6/12h11IPC30-3600s
                                                      Synchronize Interval: The support range of NVR and VMS is 5/10/15/30 minutes ,1/2/3/6/12 hours ,1 day ,and 1 week.The support range of IPC is 30-3600 seconds.
                                                      All of the above time periods need to be converted to a time value in seconds.*/
    BYTE         byRes[128];                       /*   Reserved*/
}NETDEV_SYSTEM_IPADDR_INFO_S, *LPNETDEV_SYSTEM_IPADDR_INFO_S;

/**
* @struct tagNETDEVSystemNTPInfoList
* @brief NTP
* @attention  None
*/
typedef struct tagNETDEVSystemNTPInfoList
{
    INT64                              ulNum;                                             /*NTP  NTP Server Number*/
    NETDEV_SYSTEM_IPADDR_INFO_S        astNTPServerInfoList[NETDEV_NTP_SERVER_LIST_NUM];  /*NTPNTP The NTP server list currently supports only one NTP server.*/
    BYTE                               byRes[128];                                        /*   Reserved*/
}NETDEV_SYSTEM_NTP_INFO_LIST_S, *LPNETDEV_SYSTEM_NTP_INFO_LIST_S;

/**
 * @struct tagNETDEVPriviewInfo
 * @brief   Live view parameter Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPriviewInfo
{
    INT32   dwChannelID;                 /* ID  Channel ID */
    INT32   dwStreamType;                /* ,# NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwLinkMode;                  /* ,# NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                    /*  Play window handle */ 
    INT32   dwFluency;                   /* ,# NETDEV_PICTURE_FLUENCY_E */
    INT32   dwStreamMode;                /*  # NETDEV_STREAM_MODE_E  start stream mode see #NETDEV_STREAM_MODE_E*/
    INT32   dwLiveMode;                  /*  # NETDEV_PULL_STREAM_MODE_E */
    INT32   dwDisTributeCloud;           /*  # NETDEV_DISTRIBUTE_CLOUD_SRV_E */
    BOOL    dwallowDistribution;         
    INT32   dwTransType;                 /* # NETDEV_TRANS_TYPE_E */
    INT32   dwStreamProtocol;            /* # NETDEV_START_STREAM_PROT_E */
    BYTE    byRes[236];                  /*   Reserved */
}NETDEV_PREVIEWINFO_S, *LPNETDEV_PREVIEWINFO_S;

/**
 * @struct tagNETDEStreamDataCB
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEStreamDataCB
{
    BOOL        bDecode;                
    INT32       dwCBType;               /* # NETDEV_STREAM_DATA_CB_TYPE_E */
    LPVOID      lpVideoDataCB;          
    LPVOID      lpAudioDataCB;          
    LPVOID      lpUserData;             
    BYTE        byRes[512];             
}NETDEV_STREAM_DATA_CB_S, *LPNETDEV_STREAM_DATA_CB_S;

/**
 * @struct tagNETDEVVideoEffect
 * @brief   Live image information Structure definition
 * @attention 0-10,0-255 Gamma parameter range: 0-10, other parameters: 0-255
 */
typedef struct tagNETDEVVideoEffect
{
    INT32 dwContrast;                   /*   Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /*   Saturation */
    INT32 dwHue;                        /*   Hue */
    INT32 dwGamma;                      /*   Gamma */
    BYTE  byRes[16];                    /*   Reserved */
}NETDEV_VIDEO_EFFECT_S, *LPNETDEV_VIDEO_EFFECT_S;

/**
 * @struct tagNETDEVImagingSetting
 * @brief      Device image settings Structure definition
 * @attention 0-255     parameter range: 0-255
 */
typedef struct tagNETDEVImagingSetting
{
    INT32 dwContrast;                   /*   Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /*   Saturation */
    INT32 dwSharpness;                  /*   Sharpness */
    BYTE  byRes[252];                   /*   Reserved */
}NETDEV_IMAGE_SETTING_S, *LPNETDEV_IMAGE_SETTING_S;

/**
 * @struct tagNETDEVTimeSyncMode
 * @brief      Device Time SyncMode Structure definition
 * @attention 
 */
typedef struct tagNETDEVTimeSyncMode
{
    UINT32 udwMode;                     /*   Device Time SyncMode# NETDEV_TIME_SYNCMODE_E */
    BYTE   byRes[256];                  /*   Reserved */
}NETDEV_TIME_SYNCMODE_S, *LPNETDEV_TIME_SYNCMODE_S;

/************  Playback services***********************************************/

/**
 * @struct tagNETDEVFindCond
 * @brief   Recording query Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFindCond
{
    CHAR    szFileName[NETDEV_LEN_64];      /*   Recording file name */
    INT32   dwChannelID;                    /*   Channel ID */
    INT32   dwStreamType;                   /* ,# NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwFileType;                     /* ,# NETDEV_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_STORE_TYPE_E */
    INT64   tBeginTime;                     /*   Start time */
    INT64   tEndTime;                       /*   End time */
    INT32   dwRecordLocation;               /*  Record Position, # NETDEV_RECORD_LOCATION_E */
    UINT32  udwServerID;                    /* ID Video server ID */
    BYTE    byRes[28];                      /*   Reserved */
}NETDEV_FILECOND_S, *LPNETDEV_FILECOND_S;

/**
 * @struct tagNETDEVFindData
 * @brief   Recording query data Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFindData
{
    CHAR    szFileName[NETDEV_FILE_NAME_LEN];               /*   Recording file name */
    INT64   tBeginTime;                                     /*   Start time */
    INT64   tEndTime;                                       /*   End time */
    BYTE    byFileType;                                     /*   # NETDEV_STORE_TYPE_E Recording storage type #NETDEV_STORE_TYPE_E */
    UINT32  udwServerID;                                    /* ID */
    UINT32  udwFileSize;                                    /*  Recording file size */
    INT32   dwFileType;                                     /* # NETDEV_RECORD_SEARCH_TYPE_E  */
    BYTE    byRes[159];                                     /*   Reserved */
}NETDEV_FINDDATA_S,*LPNETDEV_FINDDATA_S;

/**
 * @struct tagNETDEVPlayBackInfo
 * @brief   Parameters of play back recordings by file name Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackInfo
{
    char    szName[NETDEV_LEN_260];         /*   Playback control block name*/
    INT64   tBeginTime;                     /*   Playback start time */
    INT64   tEndTime;                       /*   Playback end time */
    INT32   dwLinkMode;                     /* ,# NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                       /*   Play window handle */
    INT32   dwFileType;                     /* ,# NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
    INT32   dwDownloadSpeed;                /*  # NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
    INT32   dwStreamMode;                   /* # NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
    BYTE    byRes[252];                     /*   Reserved */
}NETDEV_PLAYBACKINFO_S, *LPNETDEV_PLAYBACKINFO_S;

/**
 * @struct tagNETDEVPictureData
 * @brief   Image data Structure definition
 *         Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVPictureData
{
    BYTE    *pucData[4];                /* pucData[0]:Y ,pucData[1]:U ,pucData[2]:V   pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
    INT32   dwLineSize[4];              /* ulLineSize[0]:Y, ulLineSize[1]:U, ulLineSize[2]:V  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
    INT32   dwPicHeight;                /*   Picture height */
    INT32   dwPicWidth;                 /*   Picture width */
    INT32   dwRenderTimeType;           /*   Time data type for rendering */
    INT64   tRenderTime;                /*   Time data for rendering */
}NETDEV_PICTURE_DATA_S, *LPNETDEV_PICTURE_DATA_S;

/**
 * @struct tagNETDEVRecordFindCond
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVRecordFindCond
{
    UINT32 udwChannelID;                    
    UINT32 udwBegin;                        /* UTC */
    UINT32 udwEnd;                          /* UTC */
    UINT32 udwTypes;                        /*  BIT BIT  0-31  NETDEV_RECORD_TYPE_EX_E*/
    UINT32 udwRelationOfTypes;              /*  0: 1:Types  */
    UINT32 udwPosition;                     /*  1: 2: VMS */
    UINT32 udwSessionID;                    /* IDVMS */
    UINT32 udwTransType;                    /* 0: 1: */
    BYTE    byRes[256];                     /*   Reserved */
}NETDEV_RECORD_FIND_COND_S,*LPNETDEV_RECORD_FIND_COND_S;

/**
*   Type of pointer to callback function for decoded video stream data 
* @param [IN] lpPlayHandle       Current live playing handle
* @param [IN] pstPictureData     Pointer to buffer that stores decoded video stream data
* @param [IN] lpUserParam       ,#NDPlayer_SetDecodeVideoDataCB User-set parameters, specified by users when they call the #NDPlayer_SetDecodeVideoDataCB function
* @return . None.
* @note
* -     1.,,.
* -     1. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
* -     2.yv12.Y0-Y1-......,U0-U1-......,V0-V1-......
* -     2. Video data is in yv12 format in sequence of Y0-Y1-......, U0-U1-......, V0-V1-......
*/
typedef void (STDCALL* NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                             IN const NETDEV_PICTURE_DATA_S *pstPictureData,
                                                             IN LPVOID lpUserParam);

/**
 * @struct tagNETDEVPlayBackCondition
 * @brief   Parameters of play back by time Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackCondition
{
    INT32                                dwChannelID;                /*   Playback channel */
    INT64                                tBeginTime;                 /*   Playback start time */
    INT64                                tEndTime;                   /*   Playback end time */
    INT32                                dwLinkMode;                 /* # NETDEV_TRANS_PROTOCAL_E */
    LPVOID                               hPlayWnd;                   /*   Play window handle */
    INT32                                dwFileType;                 /* # NETDEV_STORE_TYPE_E  */
    INT32                                dwDownloadSpeed;            /*  # NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
    INT32                                dwStreamMode;               /* # NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
    INT32                                dwStreamIndex;              /* , # NETDEV_LIVE_STREAM_INDEX_E */
    INT32                                dwRecordLocation;           /*  Record Position, # NETDEV_RECORD_LOCATION_E */
    INT32                                dwTransType;                /* # NETDEV_TRANS_TYPE_E */
    BOOL                                 bCloudStorage;              
    BOOL                                 bOneFrameEnable;            
    INT32                                dwPlaySpeed;                /* # NETDEV_VOD_PLAY_STATUS_E  Playback speed, see enumeration #NETDEV_VOD_PLAY_STATUS_E*/
    NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK;  /*  Decode data callback function */
    INT64                                tPlayTime;                  /*   Playback time */
    UINT32                               udwServerID;                /* ID Video server ID */
    BYTE                                 byRes[212];                 
}NETDEV_PLAYBACKCOND_S, *LPNETDEV_PLAYBACKCOND_S;

/**
 * @struct tagstNETDEVPtzPreset
 * @brief   PTZ preset information Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzPreset
{
    INT32   dwPresetID;                                 /* ID  Preset ID */
    CHAR    szPresetName[NETDEV_LEN_32];                /*   Preset name */
}NETDEV_PTZ_PRESET_S, *LPNETDEV_PTZ_PRESET_S;

/**
 * @struct tagstNETDEVPtzPresetV30
 * @brief   PTZ preset information Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzPresetV30
{
    INT32   dwPresetID;                                 /* ID  Preset ID */
    CHAR    szPresetName[NETDEV_LEN_128];               /*   Preset name */
    BYTE    byRes[512];                                 
}NETDEV_PTZ_PRESET_V30_S, *LPNETDEV_PTZ_PRESET_V30_S;

/**
 * @struct tagstNETDEVPtzAllPresets
 * @brief   All PTZ presets Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzAllPresets
{
    INT32               dwSize;                             /*   Total number of presets */
    NETDEV_PTZ_PRESET_S astPreset[NETDEV_MAX_PRESET_NUM];   /*   Structure of preset information */
}NETDEV_PTZ_ALLPRESETS_S, *LPNETDEV_PTZ_ALLPRESETS_S;

/**
 * @struct tagstNETDEVPtzAllPresetsV30
 * @brief   All PTZ presets Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzAllPresetsV30
{
    INT32                   dwSize;                             /*   Total number of presets */
    NETDEV_PTZ_PRESET_V30_S astPreset[NETDEV_MAX_PRESET_NUM];   /*   Structure of preset information */
    BYTE                    byRes[512];                         
}NETDEV_PTZ_ALLPRESETS_V30_S, *LPNETDEV_PTZ_ALLPRESETS_V30_S;

/**
 * @struct tagNETDEVCruisePoint
 * @brief   PTZ preset patrol point information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruisePoint
{
    INT32   dwPresetID;     /* ID  Preset ID */
    INT32   dwStayTime;     /*   Stay time */
    INT32   dwSpeed;        /* ,[1-10]  Speed [1-10] */
    INT32   dwID;           /* ID */
}NETDEV_CRUISE_POINT_S, *LPNETDEV_CRUISE_POINT_S;

/**
 * @struct tagNETDEVCruiseInfo
 * @brief   PTZ preset patrol route information Structure definition 
 * @attention  None
 */
typedef struct tagNETDEVCruiseInfo
{
    INT32                   dwCuriseID;                                     /* ID  Route ID */
    CHAR                    szCuriseName[NETDEV_LEN_32];                    /*   Route name */
    INT32                   dwSize;                                         /*   Number of presets included in the route */
    NETDEV_CRUISE_POINT_S   astCruisePoint[NETDEV_MAX_CRUISEPOINT_NUM];     /*    Information of presets included in the route */
}NETDEV_CRUISE_INFO_S, *LPNETDEV_CRUISE_INFO_S;

/**
 * @struct tagNETDEVCruiseList
 * @brief   PTZ preset patrol route list Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruiseList
{
    INT32                   dwSize;                                         /*   Number of patrol routes */
    NETDEV_CRUISE_INFO_S    astCruiseInfo[NETDEV_MAX_CRUISEROUTE_NUM];      /*   Information of patrol routes */
}NETDEV_CRUISE_LIST_S, *LPNETDEV_CRUISE_LIST_S;

/**
 * @struct tagNETDEVPtzTrackinfo
 * @brief   Route information of PTZ route patrol Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackinfo
{
    INT32 dwTrackNum;                                               /*   Number of existing patrol routes */
    CHAR  aszTrackName[NETDEV_TRACK_CRUISE_MAXNUM][NETDEV_LEN_64];  /*   Route name */
}NETDEV_PTZ_TRACK_INFO_S, *LPNETDEV_PTZ_TRACK_INFO_S;

/**
 * @struct tagNETDEVPtzTrackInfoV30
 * @brief   Route information of PTZ route patrol Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackInfoV30
{
    UINT32 udwTrackID;                                                   /* ID */
    CHAR   szTrackName[NETDEV_LEN_64];                                   /*   RouteID */
    BYTE   byRes[64];                                                    
}NETDEV_PTZ_TRACK_INFO_V30_S, *LPNETDEV_PTZ_TRACK_INFO_V30_S;

/**
 * @struct tagNETDEVPtzTrackListV30
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackListV30
{
    INT32                       dwTrackNum;                                     /*   Number of existing patrol routes */
    NETDEV_PTZ_TRACK_INFO_V30_S astTrackInfo[NETDEV_TRACK_CRUISE_MAXNUM];       /*   RouteID */
}NETDEV_PTZ_TRACK_LIST_V30_S, *LPNETDEV_PTZ_TRACK_LIST_V30_S;

/**
 * @struct tagNETDEVPTZStatus
 * @brief   PTZ status Structure definition
 * @attention 010180-10180360  Absolute horizontal coordinates correspond to angles: 0 to 1 correspond to 0 to 180 degrees, and -1 to 0 correspond 180 to 360 degrees 
              01090  Absolute vertical coordinates correspond to angles: 0 to 1 correspond to 0 to 90 degrees 
              010  Absolute multiples correspond to the actual multiples: 0 to 1, correspond to 0 to maximum multiples 
 */
typedef struct tagNETDEVPTZStatus
{
    FLOAT                       fPanTiltX;              /*   Absolute horizontal coordinates*/
    FLOAT                       fPanTiltY;              /*   Absolute vertical coordinates*/
    FLOAT                       fZoomX;                 /*   Absolute multiples*/
    NETDEV_PTZ_MOVE_STATUS_E    enPanTiltStatus;        /*   PTZ Status*/
    NETDEV_PTZ_MOVE_STATUS_E    enZoomStatus;           /*   Focus Status*/
}NETDEV_PTZ_STATUS_S, *LPNETDEV_PTZ_STATUS_S;

/**
 * @struct tagNETDEVPTZAbsoluteMove
 * @brief    Absolute coodinates Structure definition
 * @attention  010180-10180360  Absolute horizontal coordinates correspond to angles: 0 to 1 correspond to 0 to 180 degrees, and -1 to 0 correspond 180 to 360 degrees 
               01090  Absolute vertical coordinates correspond to angles: 0 to 1 correspond to 0 to 90 degrees 
               010  Absolute multiples correspond to the actual multiples: 0 to 1, correspond to 0 to maximum multiples 
 */
typedef struct tagNETDEVPTZAbsoluteMove
{
    FLOAT                       fPanTiltX;                          /*  Absolute horizontal coordinates*/
    FLOAT                       fPanTiltY;                          /*  Absolute vertical coordinates*/
    FLOAT                       fZoomX;                             /*  Absolute multiples*/
}NETDEV_PTZ_ABSOLUTE_MOVE_S, *LPNETDEV_PTZ_ABSOLUTE_MOVE_S;

/**
 * @struct tagNETDEVRect
 * @brief   Rectangle Area  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRect
{
    INT32   dwLeft;                               /* x[0,10000]  X axis left point value [0,10000] */
    INT32   dwTop;                                /* y[0,10000]  Y axis top point value [0,10000] */
    INT32   dwRight;                              /* x[0,10000]  X axis right point value [0,10000] */
    INT32   dwBottom;                             /* y[0,10000]  Y axis bottom point value [0,10000] */
}NETDEV_RECT_S, *LPNETDEV_RECT_S;

/**
 * @struct tagNETDEVPtzOperateAreaInfo
 * @brief   Image area information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzOperateAreaInfo
{
    INT32   dwBeginPointX;      /* X[0,10000]  Area start point X value [0,10000] */
    INT32   dwBeginPointY;      /* Y[0,10000]  Area start point Y value [0,10000] */
    INT32   dwEndPointX;        /* X[0,10000]  Area end point X value [0,10000] */
    INT32   dwEndPointY;        /* Y[0,10000]  Area end point Y value [0,10000] */
}NETDEV_PTZ_OPERATEAREA_S, *LPNETDEV_PTZ_OPERATEAREA_S;

/**
 * @struct tagNETDEVPTZZoomAreaInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPTZZoomAreaInfo
{
    UINT32      udwMidPointX;      
    UINT32      udwMidPointY;      
    UINT32      udwLengthX;        
    UINT32      udwLengthY;        
    UINT32      udwWidth;          
    UINT32      udwHeight;         
    BYTE        byRes[64];         
}NETDEV_PTZ_ZOOM_AREA_INFO_S, *LPNETDEV_PTZ_ZOOM_AREA_INFO_S;

/**
 * @struct tagNETDEVPTZTrackStatusInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPTZTrackStatusInfo
{
    INT32 dwStatus;         /*    NETDEV_PTZ_TRACK_STATUS_E */
    INT32 dwPatrolID;       
}NETDEV_PTZ_TRACK_STATUS_INFO_S, *LPNETDEV_PTZ_TRACK_STATUS_INFO_S;

/**
 * @struct tagNETDEVPTZGuardInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPTZGuardInfo
{
    BOOL             bEnabled;                          
    UINT32           udwMode;                           /*  NETDEV_PTZ_GUARD_MODE_E */
    UINT32           udwParam;                          /* ,Mode0Param1; Mode1Param0;Mode2Param0 */
    UINT32           udwTime;                           /* s */
    BYTE             byRes[32];                         
}NETDEV_PTZ_GUARD_INFO_S, *LPNETDEV_PTZ_GUARD_INFO_S;

/**
 * @struct tagNETDEVPTZOrientationInfo
 * @brief  
 * @attention  
 */
typedef struct tagNETDEVPTZOrientationInfo
{
    INT32   dwDirection;                /*   NETDEV_PTZ_DIRECTION_E  Direction Info see enumeration #NETDEV_PTZ_DIRECTION_E */
    BYTE    byRes[252];                 /*   Reserved */
}NETDEV_PTZ_ORIENTATION_INFO_S, *LPNETDEV_PTZ_ORIENTATION_INFO_S;

/**
 * @struct tagNETDEVPTPositionInfo
 * @brief  : 
 * @attention
 */
typedef struct tagNETDEVPTZPtPositionInfo
{
    FLOAT   fLongitude;                /* [0.00, 360.00] */
    FLOAT   fLatitude;                 
    BYTE    byRes[128];                /*   Reserved */
}NETDEV_PTZ_PT_POSITION_INFO_S, *LPNETDEV_PTZ_PT_POSITION_INFO_S;

/**
 * @struct tagNETDEVPTZLensAngle
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVPTZLensAngle
{
    FLOAT    fHorizontalAngle;         /*  [0.180] HorizontalAngle */
    FLOAT    fVerticalAngle;           /*  [0.180] VerticalAnglr */
    BYTE     byRes[256];               /*   Reserved */
}NETDEV_PTZ_LENSANGLE_S, *LPNETDEV_PTZ_LENSANGLE_S;

/**
 * @struct tagNETDEVAudioSampleParamType
 * @brief 
 * @attention 
*/
typedef struct tagNETDEVAudioSampleParamType
{
    INT32 dwChannels;                               /* ,1,2 */
    INT32 dwSampleRate;                             
    NETDEV_AUDIO_SAMPLE_FORMAT_E enSampleFormat;    
}NETDEV_AUDIO_SAMPLE_PARAM_S, *LPNETDEV_AUDIO_SAMPLE_PARAM_S;

/**
 * @struct tagNETDEVWaveData
 * @brief   Audio data Structure definition
 *         Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVWaveData
{
    CHAR  *pcData;                      /*   Audio data pointer */
    INT32 dwDataLen;                    /*   Audio data length */
    INT32 dwWaveFormat;                 /*   Format of decoded audio*/
}NETDEV_WAVE_DATA_S, *LPNETDEV_WAVE_DATA_S;

/**
 * @struct tagNETDEVParseAudioData
 * @brief 
 * @attention 
*/
typedef struct tagNETDEVParseAudioData
{
    BYTE   *pucData;                  /*  Audio data pointer */
    UINT32 udwDataLen;               /*  Audio data length */
    UINT32 udwAudioCodeFormat;       /* ,# NETDEV_AUDIO_ENCODE_TYPE_E */
    UINT32 udwWaveFormat;            /* , # NETDEV_WAVE_FORMAT_INFO_E */
    INT64  tTimeStamp;               /*  Time stamp (ms)*/
    BYTE   byRes[8];                 /*   Reserved */
}NETDEV_PARSE_AUDIO_DATA_S, *LPNETDEV_PARSE_AUDIO_DATA_S;

/**
 * @struct tagNETDEVParseVideoData
 * @brief   Video analytic data Structure definition
 *         Storing pointer and length of framed video data
 * @attention  None
 */
typedef struct tagNETDEVParseVideoData
{
    BYTE   *pucData;             /*   Pointer to video data */
    INT32  dwDataLen;            /*   Video data length */
    INT32  dwVideoFrameType;     /* ,# NETDEV_VIDEO_FRAME_TYPE_E  Frame type, see enumeration #NETDEV_VIDEO_FRAME_TYPE_E */
    INT32  dwVideoCodeFormat;    /* ,# NETDEV_VIDEO_CODE_TYPE_E  Video encoding format, see enumeration #NETDEV_VIDEO_CODE_TYPE_E  */
    INT32  dwHeight;             /*   Video image height */
    INT32  dwWidth;              /*   Video image width */
    INT64  tTimeStamp;           /*  Time stamp (ms) */
    INT64  tAbTime;              /* (unix) */
}NETDEV_PARSE_VIDEO_DATA_S, *LPNETDEV_PARSE_VIDEO_DATA_S;

/**
 * @struct tagNETDEVIVAReportRuleHeadV2S
 * @brief V2
 * @attention  None
 */
typedef struct tagNETDEVIVAReportRuleHeadV2S
{
    UINT32      udwChannel;                     
    BOOL        bEnable;                        
    UINT16      uwRuleNum;                      
    UINT16      uwDisplayHoldTime;              /*  ms */
}NETDEV_IVA_REPORT_RULE_HEAD_V2_S, *LPNETDEV_IVA_REPORT_RULE_HEAD_V2_S;

/**
 * @struct tagNETDEVIVAReportResultHeadV2S
 * @brief V2
 * @attention  None
 */
typedef struct tagNETDEVIVAReportResultHeadV2S
{
    UINT32              udwChannel;             
    BOOL                bEnable;                
    UINT16              uwTargetNum;            
    UINT16              uwDisplayHoldTime;      /*  ms */
}NETDEV_IVA_REPORT_RESULT_HEAD_V2_S, *LPNETDEV_IVA_REPORT_RESULT_HEAD_V2_S;

/**
 * @struct tagNETDEVIVAReportCoordInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVIVAReportCoordInfo
{
    UINT16              uwX;                    /* X  0-10000  */
    UINT16              uwY;                    /* Y  0-10000  */
}NETDEV_IVA_REPORT_COORD_S, *LPNETDEV_IVA_REPORT_COORD_S;

/**
 * @struct tagNETDEVIVAReportRuleInfoV2S
 * @brief V2
 * @attention  None
 */
typedef struct tagNETDEVIVAReportRuleInfoV2S
{
    UINT32                          udwRuleID;                              /* ID */
    UINT32                          udwTriggered;                           
    NETDEV_IVA_REPORT_RULE_TYPE_E   enRuleType;                             
    NETDEV_IVA_REPORT_TRIG_TYPE_E   enTrigType;                             
    NETDEV_IVA_REPORT_COORD_S       astCoord[NETDEV_IVA_REPORT_COORD_NUM];  
    UINT32                          udwCoordNum;                            
    NETDEV_IVA_REPORT_COLOR_E       enLineColor;                            
    NETDEV_IVA_REPORT_COLOR_E       enFillColor;                            
    UINT32                          udwLineAlpha;                           /*  0-100 */
    UINT32                          udwFillAlpha;                           /*  0-100 */
    UINT32                          udwAttachLen;                           
    UINT32                          udwAttachType;                          
}NETDEV_IVA_REPORT_RULE_INFO_V2_S, *LPNETDEV_IVA_REPORT_RULE_INFO_V2_S;

/**
 * @struct tagNETDEVIVAReportResultInfoV2ExS
 * @brief V2 
 * @attention  None
 */
typedef struct tagNETDEVIVAReportResultInfoV2ExS
{
    UINT32                          udwTargetID;                        /* ID*/
    UINT32                          udwlTrigRule;                       /*  1bit1 */
    NETDEV_IVA_REPORT_COORD_S       stStart;                            /* 0,0*/
    NETDEV_IVA_REPORT_COORD_S       stEnd;                              
    NETDEV_IVA_REPORT_COLOR_E       enLineColor;                        
    UINT32                          udwLineAlpha;                       /*  0-100 */ 
    UINT32                          udwTrailHoldTime;                   /*  ms */
    UINT32                          udwAttachLen;                       
    UINT32                          udwAttachType;                      /*  -0x01 */
    CHAR                            szMsgData[0];                       /* - */
}NETDEV_IVA_REPORT_RESULT_INFO_V2_EX_S, *LPNETDEV_IVA_REPORT_RESULT_INFO_V2_EX_S;

/**
 * @struct tagNETDEVVideoChlDetailInfo
 * @brief    Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailInfo
{
    INT32                       dwChannelID;                        /* ID  Channel ID */
    BOOL                        bPtzSupported;                      /*  Whether ptz is supported */
    NETDEV_CHANNEL_STATUS_E     enStatus;                           /*   Channel status NETDEV_CHANNEL_STATUS_E */
    INT32                       dwStreamNum;                        /*   Number of streams enStatusNETDEV_CHL_STATUS_UNBIND*/
    CHAR                        szChnName[NETDEV_LEN_64];           /*  Channel Name */
    BYTE                        byRes[4];                           /*   Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_INFO_S, *LPNETDEV_VIDEO_CHL_DETAIL_INFO_S;

/**
 * @struct tagNETDEVVideoChlDetailExtendInfo
 * @brief    Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailExtendInfo
{
    UINT32                                      udwIsPoEPort;                                   /* PoE, 0-, 1- */
    UINT32                                      udwPoEStatus;                                   /* PoE  NETDEV_POE_STATUS_E */
    CHAR                                        szAccessAddress[NETDEV_IPADDR_STR_MAX_LEN];     /* , [0, 63]NVR */
    CHAR                                        szMACAddress[NETDEV_IPADDR_STR_MAX_LEN];        /* MAC, [0, 63], NVR */
    CHAR                                        szDDNSAddress[NETDEV_IPADDR_STR_MAX_LEN];       /* DDNS[0,64] */
    UINT32                                      udwOffReason;                                   /*   NETDEV_CHN_OFF_REASON_E */
    UINT32                                      udwRemoteIndex;                                 
    CHAR                                        szGBID[NETDEV_LEN_32];                          /* [0, 31] */
    UINT32                                      udwAddType;                                     /* , 0-, 1-*/
    UINT32                                      udwOrgID;                                       /* ID, */
    UINT32                                      udwDevID;                                       /* ID, */
    CHAR                                        szDevName[NETDEV_LEN_64];                       /* [0, 64] */
    UINT32                                      udwChlIndex;                                    /* ID, */
    UINT32                                      udwAudioResID;                                  /* ID, */
    BYTE                                        byRes[512];                                     /*   Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S, *LPNETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S;

/**
 * @struct tagNETDEVVideoChlDetailInfoEx
 * @brief    Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailInfoEx
{
    INT32                                       dwChannelID;                        /* ID  Channel ID */
    BOOL                                        bPtzSupported;                      /*  Whether ptz is supported */
    NETDEV_CHANNEL_STATUS_E                     enStatus;                           /*   Channel status NETDEV_CHANNEL_STATUS_E */
    INT32                                       dwStreamNum;                        /*   Number of streams enStatus NETDEV_CHL_STATUS_UNBIND */
    NETDEV_CHANNEL_TYPE_E                       enChannelType;                      /* (note: NVR) */
    NETDEV_VIDEO_STANDARD_E                     enVideoFormat;                      /* ChannelType NETDEV_CHL_TYPE_DIGITAL  (note: NVR) */
    NETDEV_HOSTTYPE_E                           enAddressType;                      /* IP */
    CHAR                                        szIPAddr[NETDEV_IPADDR_STR_MAX_LEN];/* IP IP address*/
    INT32                                       dwPort;                             
    CHAR                                        szChnName[NETDEV_LEN_64];           /*  Channel Name */
    BOOL                                        allowDistribution;                  
    INT32                                       dwDeviceType;                       /*  NETDEV_CHANNEL_CAMERA_TYPE_E. Channel device Type see#NETDEV_CHANNEL_CAMERA_TYPE_E */
    CHAR                                        szManufacturer[NETDEV_LEN_32];      /* [0,31] */
    CHAR                                        szDeviceModel[NETDEV_LEN_32];       /* [0,31]  */
    UINT32                                      udwAccessProtocol;                  /* ,ONVIF:1 ,:2, :3 ,:, NETDEV_GetDevConfig/NETDEV_SetDevConfig  */
    LPNETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S     pstExtendedInformation ;            /* , */
    BYTE                                        byRes[16];                          /*   Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S, *LPNETDEV_VIDEO_CHL_DETAIL_INFO_EX_S;

/**
 * @struct tagNETDEVVideoResolution
 * @brief  Video resolution
 * @attention 
*/
typedef struct tagNETDEVVideoResolution
{
    INT32 dwWidth;                                             
    INT32 dwHeight;                                            
}NETDEV_VIDEO_RESOLUTION_S, *LPNETDEV_VIDEO_RESOLUTION_S;

/**
* @struct tagNETDEVXWAdvancedParameters
* @brief 
* @attention
*/
typedef struct tagNETDEVXWAdvancedParameters
{
    UINT32  udwHorizontalTotalPixets;           /*   px */
    UINT32  udwHorizontalSyncFrontier;          /* px */
    UINT32  udwHorizontalSyncWidth;             /* px */
    UINT32  udwHorizontalSyncPolarity;          
    UINT32  udwVerticalTotalPixets;             /*   px */
    UINT32  udwVerticalSyncFrontier;            /* px */
    UINT32  udwVerticalSyncWidth;               /* px */
    UINT32  udwVerticalSyncPolarity;            
    BYTE    byRes[64];                          
}NETDEV_XW_ADVENCE_PARAMETERS_INFO_S, *LPNETDEV_XW_ADVENCE_PARAMETERS_INFO_S;

/**
 * @struct tagNETDEVXWVideoResolution
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVideoResolution
{
    UINT32  udwWidth;       
    UINT32  udwHeight;      
}NETDEV_XW_RESOLUTION_S, *LPNETDEV_XW_RESOLUTION_S;

/**
 * @struct tagNETDEVTVWallScreen
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTVWallScreen
{
    UINT32                              udwRowNum;                          
    UINT32                              udwColNum;                          
    UINT32                              udwFormat;                          /*  NETDEV_VIDEO_FORMAT_E */
    CHAR                                szFormat[NETDEV_FORMAT_NAME_LEN];   
    NETDEV_XW_RESOLUTION_S              stResolution;                       
    BOOL                                bAdvancedParametersEffect;          /* 0:1: */
    NETDEV_XW_ADVENCE_PARAMETERS_INFO_S stAdvancedParameters;               
    BYTE                                byRes[256];                         
}NETDEV_TVWALL_SCREEN_S, *LPNETDEV_TVWALL_SCREEN_S;

/**
 * @struct tagNETDEVTVWallFORMATSPECList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTVWallFORMATSPECList
{
    UINT32                          udwScreenID;                        /* (1) */
    UINT32                          udwFormat;                          /*  NETDEV_VIDEO_FORMAT_E */
    CHAR                            szFormat[NETDEV_FORMAT_NAME_LEN];   
    BYTE                            byRes[32];                          
}NETDEV_TVWALL_FORMAT_SPEC_S, *LPNETDEV_TVWALL_FORMAT_SPEC_S;

/**
 * @struct tagNETDEVTVWallLEDSPECList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTVWallLEDSPECList
{
    UINT32                  udwScreenID;        /* (1) */
    NETDEV_XW_RESOLUTION_S  stResolution;       
    BYTE                    byRes[32];          
}NETDEV_TVWALL_LED_SPEC_S, *LPNETDEV_TVWALL_LED_SPEC_S;

/**
 * @struct tagNETDEVTVWallVOUTList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTVWallVOUTList
{
    UINT32  udwScreenID;        /* (1) */
    UINT32  udwVideoOutID;      /* ID */
    BYTE    byRes[32];          
}NETDEV_TVWALL_VIDED_OUT_S, *LPNETDEV_TVWALL_VIDED_OUT_S;

/**
 * @struct tagNETDEVXWTVWallCfgV30
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWTVWallCfgV30
{
    UINT32                          udwTVWallID;                                    /* ID */
    CHAR                            szTVWallCode[NETDEV_LEN_64];                    /* [1,64] */
    CHAR                            szName[NETDEV_TVWALL_NAME_LEN];                 
    UINT32                          udwOrderNo;                                     
    NETDEV_TVWALL_SCREEN_S          stScreenInfo;                                   
    UINT32                          udwFormatSpecNum;                               
    LPNETDEV_TVWALL_FORMAT_SPEC_S   pastFormatSpec;                                 /* , */
    UINT32                          udwLedSpecNum;                                  
    LPNETDEV_TVWALL_LED_SPEC_S      pastLedSpec;                                    /* , */
    UINT32                          udwVideoOutNum;                                 
    LPNETDEV_TVWALL_VIDED_OUT_S     pastVideoOut;                                   /* , */
    UINT32                          udwTVWallType;                                  
    INT32                           dwXWDeviceID;                                   /* -1DC>0ADUID */
    UINT32                          udwZoomEnabled;                                 /* 0:1: */
    BYTE                            byRes[512];                                     
}NETDEV_XW_TVWALL_CFG_V30_S, *LPNETDEV_XW_TVWALL_CFG_V30_S;

/**
* @struct tagNETDEVXWSpecialResolutionInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVXWSpecialResolutionInfo
{
    UINT32  udwWidth;                                                     /* px */
    UINT32  udwHeight;                                                    /* px */
    BYTE    byRes[64];                                                    
}NETDEV_XW_SPECIAL_RESOLUTION_INFO_S, *LPNETDEV_XW_SPECIAL_RESOLUTION_INFO_S;

/**
* @struct tagNETDEVXWImgInModeInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVXWImgInModeInfo
{
    UINT32                               udwVideoInputID;               /* ID */
    UINT32                               udwImageInMode;                /*  0 1 */
    NETDEV_XW_SPECIAL_RESOLUTION_INFO_S  stSpecialResolution;           /* ,udwImageInMode1 */
    UINT32                               udwFrameRate;                  
    BOOL                                 bAdvancedParametersEffect;     
    NETDEV_XW_ADVENCE_PARAMETERS_INFO_S  stAdvancedParameters;          
    BYTE                                 byRes[52];                     
}NETDEV_XW_IMG_IN_MODE_INFO_S, *LPNETDEV_XW_IMG_IN_MODE_INFO_S;

/**
* @struct tagNETDEVXWImgInModeInfoList
* @brief 
* @attention
*/
typedef struct tagNETDEVXWImgInModeInfoList
{
    UINT32                          udwNum;                                
    LPNETDEV_XW_IMG_IN_MODE_INFO_S  pstImgInModeInfoList;                  /* ,*/
    BYTE                            byRes[256];                            
}NETDEV_XW_IMG_IN_MODE_INFO_LIST_S, *LPNETDEV_XW_IMG_IN_MODE_INFO_LIST_S;

/**
* @struct tagNETDEVDevIDList
* @brief  ID
* @attention 
*/
typedef struct tagNETDEVDevIDList
{
    UINT32                  udwNum;                                          
    UINT32                  *pudwIDList;                                     /* ID */
    BYTE                    byRes[128];                                      /*   Reserved */
}NETDEV_DEV_ID_LIST_S, *LPNETDEV_DEV_ID_LIST_S;

/**
 * @struct tagNETDEVRange
 * @brief  Range
 * @attention 
*/
typedef struct tagNETDEVRange
{
    INT32   dwMin;                         
    INT32   dwMax;                         
}NETDEV_RANGE_S, *LPNETDEV_RANGE_S;

/**
 * @struct tagNETDEVVideoEncodeOption
 * @brief  Video encode option
 * @attention 
*/
typedef struct tagNETDEVVideoEncodeOption
{
    INT32                       dwEncodeType;                                       /*  NETDEV_VIDEO_CODE_TYPE_E */
    INT32                       dwResolutionSize;                                   /*  Resolution size */
    NETDEV_VIDEO_RESOLUTION_S   astResolution[NETDEV_RESOLUTION_NUM_MAX];           /*  Resolution */
    NETDEV_RANGE_S              stIFrameInterval;                                   /* I I frame interval */
    NETDEV_RANGE_S              stFrameRate;                                        /*  Frame rate */
    NETDEV_RANGE_S              stEncodingInterval;                                 /*  Encode interval */
    NETDEV_RANGE_S              stBitRate;                                          /*  Bit rate */
}NETDEV_VIDEO_ENCODE_OPTION_S, *LPNETDEV_VIDEO_ENCODE_OPTION_S;

/**
 * @struct tagNETDEVVideoStreamCap
 * @brief  Video stream Cap
 * @attention 
*/
typedef struct tagNETDEVVideoStreamCap
{
    INT32                           dwStreamType;                                   /*    NETDEV_LIVE_STREAM_INDEX_E */
    INT32                           dwEncodeCapSize;                                /*  Encode capability size */
    NETDEV_VIDEO_ENCODE_OPTION_S    astEncodeCap[NETDEV_VIDEO_ENCODE_TYPE_MAX];     /*  Encode capability */
    NETDEV_RANGE_S                  stQuality;                                      /*  Quality range */
}NETDEV_VIDEO_STREAM_CAP_S, *LPNETDEV_VIDEO_STREAM_CAP_S;

/**
 * @struct tagNETDEVFindLogCond
 * @brief   Log query condition Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFindLogCond
{
    INT32      dwMainType;         /* , # NETDEV_LOG_MAIN_TYPE_E  Log type. See #NETDEV_LOG_MAIN_TYPE_E for reference */
    INT32      dwSubType;          /* , # NETDEV_LOG_SUB_TYPE_E  Sub type. See #NETDEV_LOG_SUB_TYPE_E for reference */
    INT64      tBeginTime;         /*   Start time */
    INT64      tEndTime;           /*   End time */
    INT32      dwLimitNum;         /*  Number of each query*/
    INT32      dwOffset;           /* 0 Start search from No. X. X starts from 0*/
}NETDEV_FIND_LOG_COND_S, *LPNETDEV_FIND_LOG_COND_S;

/**
 * @struct tagNETDEVOptLogInfo
 * @brief   Definition of log info structure
 * @attention 
*/
typedef struct tagNETDEVOptLogInfo
{
    INT64       tTime;                                  /*  Log time*/
    INT32       dwMainType;                             /* ,  #NETDEV_LOG_MAIN_TYPE_E Main Type.See #NETDEV_LOG_MAIN_TYPE_E for reference*/
    INT32       dwSubType;                              /* ,  #NETDEV_LOG_SUB_TYPE_E Sub Type.See #NETDEV_LOG_SUB_TYPE_E for reference*/
    INT32       dwChannelID;                            /*  Log source*/
    CHAR        szUserName[NETDEV_NAME_MAX_LEN];        /*  Username*/
    CHAR        szUserAddr[NETDEV_IPADDR_STR_MAX_LEN];  /* IP User IP address*/
    CHAR        szDetailInfo[NETDEV_LEN_256];           /* [1,64] NVR Detail info[1,64] NVR Only */
    CHAR        szOperObject[NETDEV_LEN_256];           /* [1,64] VMS Opera object[1,64] VMS Only */
    UINT32      udwOperResult;                          /*  VMS Opera result VMS Only */
    CHAR        szDevName[NETDEV_LEN_256];              /* [1,64] Device name of operation[1,64] VMS Only*/
    CHAR        szOrgName[NETDEV_LEN_256];              /* [1,64] Org Name of operation[1,64] VMS Only */
    BYTE        bRes[256];                              /*  Reserved */
}NETDEV_LOG_INFO_S,*LPNETDEV_LOG_INFO_S;

/*****************   Alarm services**************************************************/
/**
 * @struct tagNETDEVAlarmInfo
 * @brief   Alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInfo
{
    INT32   dwAlarmType;                    /* ,# NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT64   tAlarmTime;                     /*   Alarm time */
    INT32   dwChannelID;                    /* ,NVR  Channel ID for NVR */
    UINT16  wIndex;                         /*   Index number,  index number */
    CHAR    *pszName;                       /* , Alarm source name, alarm input/output name */
    INT32   dwTotalBandWidth;               /* ,MBps  Current total bandwidth (in MBps) */
    INT32   dwUnusedBandwidth;              /* ,MBps  Bandwidth left (in MBps)*/
    INT32   dwTotalStreamNum;               /*  Total cameras*/
    INT32   dwFreeStreamNum;                /*  Cameras left */
    INT32   dwMediaMode;                    /* ,# NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32   dwReserved;                     
    INT32   dwEventCode;                    /* # NETDEV_PLAYER_RUN_INFO_TYPE_E */
    BYTE    byRes[2];                       /*   Reserved */
}NETDEV_ALARM_INFO_S, *LPNETDEV_ALARM_INFO_S;

/**
 * @struct tagNETDEVAlarmSubscribeInfo
 * @brief   Alarm subscribe information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmSubscribeInfo
{
    INT32   dwAlarmType;                    /*   NETDEV_SUBSCRIBE_ALARM_TYPE_E  */
    BYTE    byRes[44];                      /*   Reserved */
}NETDEV_ALARM_SUB_INFO_S, *LPNETDEV_ALARM_SUB_INFO_S;

/**
 * @struct tagNETDEVPullAlarmInfo
 * @brief    Get alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPullAlarmInfo
{
    NETDEV_ALARM_TYPE_E   enAlarm;                       /*   Alarm type */
    INT32                 dwChancelId;                   /* ,NVR  Channel ID for NVR */
}NETDEV_PULLALARM_INFO_S, *LPNETDEV_PULLALARM_INFO_S;

/**********************  Passenger flow statistic **************************/
/**
 * @struct tagNETDEVPassengerFlowStatisticData
 * @brief    Passenger flow statistic infomation Sturcture definition
 * @attention  None
 */
typedef struct tagNETDEVPassengerFlowStatisticData
{
    INT32   dwChannelID;            /*  Channel ID */
    INT64   tReportTime;            /* unix Report time */
    INT32   tInterval;              /*  Interval time */
    INT32   dwEnterNum;             /*  Enter num */
    INT32   dwExitNum;              /*  Exit num */
    INT32   dwTotalEnterNum;        /*  Total enter num */
    INT32   dwTotalExitNum;         /*  Total exit num */
}NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S, *LPNETDEV_PASSENGER_FLOW_STATISTIC_DATA_S;

/**
 * @struct tagNETDEVTmsConnectInfo
 * @brief socket
 * @attention
 */
typedef struct tagNETDEVTmsConnectInfo
{ 
    UINT32   udwPktVer;           
    UINT32   udwTmsProtoCmd;     /* Tms */
    CHAR     *pcRecvBuf;         /* socket */
    UINT32   udwBufMaxLen;       /* RecvBuf */
    UINT32   udwPktTotalLen;     
    BOOL     bHdrParsed;         
    BYTE     bRes[32];           /*  Reserved */
}NETDEV_TMS_CONNECT_INFO_S, *LPNETDEV_TMS_CONNECT_INFO_S;

/**
 * @struct tagNETDEVTMSPersonInfo
 * @brief 
 * @attention
 */
typedef  struct tagNETDEVTMSPersonInfo
{
    UINT32 udwFaceId;                                      /* ID0xml */
    CHAR   szCamerID[NETDEV_TMS_CAMER_ID_LEN];             
    CHAR   szRecordID[NETDEV_TMS_FACE_RECORD_ID_LEN];      /* ID */
    CHAR   szTollgateID[NETDEV_TMS_FACE_TOLLGATE_ID_LEN];  
    CHAR   szPassTime[NETDEV_TMS_PASSTIME_LEN];            
    BOOL   bFinishFlag;                                    
    BYTE   bRes[128];                                      /*  Reserved */
}NETDEV_TMS_PERSION_INFO_S, *LPNETDEV_TMS_PERSION_INFO_S;

/**
 * @struct tagNETDEVFacePositionInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVFacePositionInfo
{
    INT32   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
    BYTE    bRes[32];             /*  Reserved */
}NETDEV_FACE_POSITION_INFO_S, *LPNETDEV_FACE_POSITION_INFO_S;

/**
 * @struct tagNETDEVTMSPersionFaceInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSPersionFaceInfo
{ 
    UINT32 udwFaceId;                                /* ID */
    NETDEV_FACE_POSITION_INFO_S stFacePos;           /* ---0-10000 ;  "138,315,282,684" */
    BYTE   bRes[64];                                 /*  Reserved */
}NETDEV_TMS_PERSION_FACE_INFO_S, *LPNETDEV_TMS_PERSION_FACE_INFO_S;

/**
 * @struct tagNETDEVTMSPersionPicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSPersionPicInfo
{
    UINT32                              udwFaceId;                                  /* ID(Face) 0 */
    UINT32                              udwPiclen;                                  
    CHAR                                szPassTime[NETDEV_TMS_PASSTIME_LEN];        
    NETDEV_TMS_PERSION_FACE_INFO_S      stFaceInfo;                                 
    NETDEV_TMS_PERSION_IMAGE_TYPE_E     enImgType;                                  
    NETDEV_TMS_PERSION_IMAGE_FORMAT_E   enImgFormat;                                
    UINT32                              udwImageWidth;                              
    UINT32                              udwImageHeight;                              
    UINT32                              udwFaceNum;                                 
    BYTE                                bRes[252];                                  /*  Reserved*/
}NETDEV_TMS_PERSION_PIC_INFO_S, *LPNETDEV_TMS_PERSION_PIC_INFO_S;

/**
 * @struct tagNETDEVTMSFaceParseInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSFaceParseInfo
{ 
    UINT32                          udwFaceNum;                 
    UINT32                          udwImageNum;                /* pstTMSPersonPicInfo  */
    CHAR                            *pcPktPicDataPtr;           
    NETDEV_TMS_PERSION_INFO_S       stTMSPersonInfo;            
    LPNETDEV_TMS_PERSION_PIC_INFO_S pstTMSPersonPicInfo;        
    BYTE                            bRes[64];                   /*  Reserved */
}NETDEV_TMS_FACE_PARSE_INFO_S, *LPNETDEV_TMS_FACE_XML_INFO_S;

/**
 * @struct tagNETDEVTMSHeatMapXmlInfo
 * @brief XML
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapXmlInfo
{
    CHAR  szDevID[NETDEV_TMS_HEAT_MAP_DEVID_LEN];                           
    CHAR  szRecordID[NETDEV_TMS_HEAT_MAP_RECORD_ID_LEN];                    /* ID */
    CHAR  szCollectTime[NETDEV_TMS_HEAT_MAP_COllECT_TIME_LEN];              
    INT32 dwColumns;                                                        
    INT32 dwRows;                                                           
    INT32 dwIntervalTime;                                                   /*  min*/
    CHAR  szIPAddr[NETDEV_IPV4_LEN_MAX];                                    /* IP */
    BYTE  bRes[240];                                                        /*  Reserved */
}NETDEV_TMS_HEAT_MAP_XML_INFO_S, *LPNETDEV_TMS_HEAT_MAP_XML_INFO_S;

/**
 * @struct tagNETDEVTMSHeatMapPicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapPicInfo
{
    UINT32  udwPicSize;                                                     
    CHAR    *pcPicData;                                                     
}NETDEV_TMS_HEAT_MAP_PIC_INFO_S,*LPNETDEV_TMS_HEAT_MAP_PIC_INFO_S;

/**
 * @struct tagNETDEVTMSHeatMapInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapInfo
{
    UINT32                            udwPicNum;                                /*  Picture Number */
    NETDEV_TMS_HEAT_MAP_XML_INFO_S    stTmsXmlInfo;                             /* XML XML Information */
    NETDEV_TMS_HEAT_MAP_PIC_INFO_S    stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];  /*  Picture Message */
}NETDEV_TMS_HEAT_MAP_INFO_S,*LPNETDEV_TMS_HEAT_MAP_INFO_S;

/**
 * @struct tagNETDEVTMSCarPlateXmlInfo
 * @brief XML
 * @attention
 */
typedef struct tagNETDEVTMSCarPlateXmlInfo
{
    CHAR szCamID[NETDEV_TMS_CAR_PLATE_CAMID_LEN];                               
    CHAR szRecordID[NETDEV_TMS_CAR_PLATE_RECORDID_LEN];                         /* ID */
    CHAR szTollgateID[NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN];                       
    CHAR szPassTime[NETDEV_TMS_CAR_PLATE_PASSTIME_LEN];                         
    CHAR szLaneID[NETDEV_TMS_CAR_PLATE_LANEID_LEN];                             
    CHAR szCarPlate[NETDEV_TMS_CAR_PLATE_CARPLATE_LEN];                         
    CHAR szIPAddr[NETDEV_IPV4_LEN_MAX];                                         /* IP */
    INT32 dwCarPlateColor;                                                      /*  NETDEV_TMS_CAR_PLATE_COLOR_E */
    BYTE bRes[492];                                                             /*  Reserved */
}NETDEV_TMS_CAR_PLATE_XML_INFO_S, *LPNETDEV_TMS_CAR_PLATE_XML_INFO_S;

/**
 * @struct tagNETDEVTMSCarPlatePicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSCarPlatePicInfo
{
    UINT32  udwPicSize;                                                      
    CHAR    *pcPicData;                                                      
}NETDEV_TMS_CAR_PLATE_PIC_INFO_S,*LPNETDEV_TMS_CAR_PLATE_PIC_INFO_S;

/**
 * @struct tagNETDEVTMSCarPlateInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSCarPlateInfo
{
    UINT32                             udwPicNum;                                   /*  Picture Number */
    NETDEV_TMS_CAR_PLATE_XML_INFO_S    stTmsXmlInfo;                                /* XML XML Information */
    NETDEV_TMS_CAR_PLATE_PIC_INFO_S    stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];     /*  Picture Message */
}NETDEV_TMS_CAR_PLATE_INFO_S,*LPNETDEV_TMS_CAR_PLATE_INFO_S;

/**
 * @struct tagNETDEVTMSFaceSnapshotPicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSFaceSnapshotPicInfo
{
    UINT32                             udwFaceId;                                      /* ID */
    CHAR                               *pcPicBuff;                                     
    UINT32                             udwPicBuffLen;                                  
    NETDEV_TMS_PERSION_IMAGE_TYPE_E    enImgType;                                      /*  NETDEV_TMS_PERSION_IMAGE_TYPE_E */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_E  enImgFormat;                                    /*  NETDEV_TMS_PERSION_IMAGE_FORMAT_E */
    NETDEV_FACE_POSITION_INFO_S        stFacePos;                                      /* ---0-10000 ;  "138,315,282,684" */
    UINT32                             udwImageWidth;                                  
    UINT32                             udwImageHeight;                                 
    CHAR                               szCamerID[NETDEV_TMS_CAMER_ID_LEN];             
    CHAR                               szRecordID[NETDEV_TMS_FACE_RECORD_ID_LEN];      /* ID */
    CHAR                               szTollgateID[NETDEV_TMS_FACE_TOLLGATE_ID_LEN];  
    CHAR                               szPassTime[NETDEV_TMS_PASSTIME_LEN];            /* ,YYYYMMDDHHMMSSMMM24MMMMMMM */
    UINT32                             udwFaceNum;                                     
    CHAR                               szIPAddr[NETDEV_IPV4_LEN_MAX];                  /* IP */
    BYTE                               bRes[76];                                       /*  Reserved */
}NETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S, *LPNETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S;

/**
 * @struct tagNETDEVXWDelaySwitchPower
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWDelaySwitchPower
{
    UINT32            udwOperateType;                    /*  0: 1:*/
    UINT32            udwDelayTime;                      /*  :min   1~720*/
    BYTE              bRes[128];                         
}NETDEV_XW_DELAY_SWITCH_POWER_S, *LPNETDEV_XW_DELAY_SWITCH_POWER_S;

/**
 * @struct tagNETDEVXWTimingSwitchPower
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWTimingSwitchPower
{
    CHAR            szTVWallCode[NETDEV_LEN_64];         /* [1,64]*/
    BOOL            bPowerOnEnabled;                     /* 0: 1:*/
    BOOL            bPowerOffEnabled;                    /* 0: 1:*/
    CHAR            szPowerOnTime[NETDEV_LEN_16];        /* HH:MM:SS:: )*/
    CHAR            szPowerOffTime[NETDEV_LEN_16];       /* HH:MM:SS:: )*/
    BYTE            bRes[64];                           
}NETDEV_XW_TIMING_SWITCH_POWER_S, *LPNETDEV_XW_TIMING_SWITCH_POWER_S;

/**
 * @struct tagNETDEVXWManualSwitchPower
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWManualSwitchPower
{
    CHAR              szTVWallCode[NETDEV_LEN_64];       /* [1,64] */
    UINT32            udwOperateType;                    /*  0:   1:*/
    BYTE               bRes[64];                         
}NETDEV_XW_MANUAL_SWITCH_POWER_S, *LPNETDEV_XW_MANUAL_SWITCH_POWER_S;

/**
 * @struct tagNETDEVXWScreenCtrlParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWScreenCtrlParamInfo
{
    CHAR        szTVWallCode[NETDEV_LEN_64];              /* [1,64] */
    UINT32      udwCtrlType;                              /* , NETDEV_XW_SCREEN_CTRL_TYPE_E */
    UINT32      udwAddressType;                           /* IP, NETDEV_ADDR_TYPE_E  CtrlType01*/
    CHAR        szIPV4Address[NETDEV_IPADDR_STR_MAX_LEN]; /* IPV4 TCPUDPIPIPv4*/
    CHAR        szIPV6Address[NETDEV_IPADDR_STR_MAX_LEN]; /* IPV6 TCPUDPIPIPv6*/
    CHAR        szDomainAddress[NETDEV_DOMAIN_LEN];       /*  TCPUDPIP*/
    UINT32      udwPort;                                  /*  TCPUDP*/
    UINT32      udwComID;                                 /* ID */
    UINT32      udwProtocolType;                          /*   NETDEV_XW_SCREEN_CTRL_PROTOCOL_TYPE_E */
    CHAR        szProtocolCode[NETDEV_LEN_128];           /* [1,64] */
    BYTE        bRes[64];                                 
}NETDEV_XW_SCREEN_CTRL_PARAM_INFO_S, *LPNETDEV_XW_SCREEN_CTRL_PARAM_INFO_S;

/**
 * @struct tagNETDEVXWScreenZoomInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWScreenZoomInfo
{
    UINT32            uOperatedType;                    /* , NETDEV_XW_SCREEN_ZOOM_TYPE_E */
    UINT32            uOperatedMode;                    /* , NETDEV_XW_SCREEN_ZOOM_MODE_E */
    UINT32            uSplitScreenIndex;                /* ,uOperatedType0 & uOperatedMode=1 */
}NETDEV_XW_SCREEN_ZOOM_INFO_S, *LPNETDEV_XW_SCREEN_ZOOM_INFO_S;

/**
 * @struct tagNETDEVXWArea
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWArea
{
    UINT32  udwX;       /* X */
    UINT32  udwY;       /* Y */
}NETDEV_XW_COORD_S, *LPNETDEV_XW_COORD_S;

/**
 * @struct tagNETDEVXWVirtualLEDArea
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDArea
{
    NETDEV_XW_COORD_S   stTopLeft;          
    NETDEV_XW_COORD_S   stBottomRight;      
}NETDEV_XW_AREA_S, *LPNETDEV_XW_AREA_S;

/**
 * @struct tagNETDEVXWTVWallCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWTVWallCap
{
    UINT32      udwNumMax;                        
    UINT32      udwSceneMax;                      
    UINT32      udwRowMax;                        /* ,udwMaxPerTVWallVideoOutNum */
    UINT32      udwColumnMax;                     /* ,udwMaxPerTVWallVideoOutNum */
    UINT32      udwScenesPlanMax;                 
    UINT32      udwMaxPerTVWallVideoOutNum;       
    BYTE        byRes[56];                        
}NETDEV_XW_TVWALL_CAP_S, *LPNETDEV_XW_TVWALL_CAP_S;

/**
 * @struct tagNETDEVXWFormatList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWFormatList
{
    UINT32      udwSize;                                    
    UINT32      adwFormatList[NETDEV_VIDEO_FORMAT_MAX];     /*  NETDEV_VIDEO_FORMAT_E */
    BYTE        byRes[64];                                  
}NETDEV_XW_FORMAT_LIST_S, *LPNETDEV_XW_FORMAT_LIST_S;

/**
 * @struct tagNETDEVXWProtocolCode
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWProtocolCode
{
    CHAR        szScreenProtocols[NETDEV_LEN_32];         
    BYTE        byRes[64];                                
}NETDEV_XW_PROTOCOL_CODE_S, *LPNETDEV_XW_PROTOCOL_CODE_S;

/**
 * @struct tagNETDEVXWScreenProtocolCap
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWScreenProtocolCap
{
    UINT32                                 udwSize;                                  
    LPNETDEV_XW_PROTOCOL_CODE_S            pstScreenProtocols;                       /* , */
    BYTE                                   byRes[64];                                
}NETDEV_XW_SCREEN_PROTOCOL_CAP_S, *LPNETDEV_XW_SCREEN_PROTOCOL_CAP_S;

/**
 * @struct tagNETDEVXWWndCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWWndCap
{
    UINT32                  udwWndMaxPerScene;      
    UINT32                  udwAreaMax;             
    UINT32                  udwPaneMax;             
    NETDEV_XW_RESOLUTION_S  stResolutionMin;        
    BYTE                    byRes[64];              
}NETDEV_XW_Wnd_CAP_S, *LPNETDEV_XW_Wnd_CAP_S;

/**
 * @struct tagNETDEVXWBaseMapCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWBaseMapCap
{
    UINT32                      udwNumMax;                    
    UINT32                      udwNumMaxPerScene;            
    UINT32                      udwMaxBaseMapSize;            /*  MB  */
    NETDEV_XW_RESOLUTION_S      stResolutionMax;              
    NETDEV_XW_RESOLUTION_S      stResolutionMin;              
    CHAR                        szBaseMapType[NETDEV_LEN_40]; 
    BYTE                        byRes[16];                    
}NETDEV_XW_BASEMAP_CAP_S, *LPNETDEV_XW_BASEMAP_CAP_S;

/**
 * @struct tagNETDEVXWVirtualLEDCap
 * @brief "XW"LED
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDCap
{
    UINT32  udwNumMaxPerScene;           /* LED */
    UINT32  udwRowMax;                   /* LED */
    UINT32  udwCharMaxPerRow;            
    UINT32  udwRollingNumPerSceneMax;    /* LED */
    UINT32  udwTextHightMax;             
    UINT32  udwGapMax;                   
    UINT32  udwCharsMax;                 
    UINT32  udwSupVirtualLEDDifColors;   /* LED 0 1 */
    UINT32  udwMaxPerSceneTimeLEDNum;    /* LED */
    BYTE    byRes[40];                   
}NETDEV_XW_VIRTUALLED_CAP_S, *LPNETDEV_XW_VIRTUALLED_CAP_S;

/**
 * @struct tagNETDEVXWSequenceCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWSequenceCap
{
    UINT32  udwSrcNumMax;                
    UINT32  udwPaneNumMax;               
    UINT32  udwWndNumMax;                
    UINT32  udwSceneNumMax;              
    UINT32  udwVideoSourceMax;           
    UINT32  udwSeqResourceInSceneMax;    
    BYTE    byRes[56];                   
}NETDEV_XW_SEQUENCE_CAP_S, *LPNETDEV_XW_SEQUENCE_CAP_S;

/**
 * @struct tagNETDEVXWPaneType
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWPaneType
{
    UINT32                          udwSize;                     
    UINT32                          *pudwPaneType;               /*  NETDEV_XW_LAYOUT_NUM_E */
}NETDEV_XW_PANE_TYPE_S, *LPNETDEV_XW_PANE_TYPE_S;

/**
 * @struct tagNETDEVXWSupportCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWSupportCap
{
    UINT32                  udwPane;                      /*  NETDEV_XW_PANE_CAP_E */
    UINT32                  udwWndRoaming;                /*  NETDEV_XW_ROAMING_CAP_E */
    UINT32                  udwWnd;                       /*  NETDEV_XW_WND_CAP_E */
    BOOL                    bBackToShow;                  /*  0: 1: */
    BOOL                    bWndOverlay;                  /*  0: 1: */
    BOOL                    bTopWndSetTransp;             /*  0: 1: */
    UINT32                  udwMaxWinNumPerScreen;        
    NETDEV_XW_PANE_TYPE_S   stPaneType;                   
    UINT32                  udwMaxEncodeDevicesNum;       
    UINT32                  udwMaxVideoSourceNum;         
    UINT32                  udwSupportWindowTypeNum;      
    UINT32                  *paudwWindowType;             /*  # NETDEV_XW_LAYOUT_NUM_E ,*/
    BOOL                    bAutoSelectSignalSrc;         /*  0: 1: */
    BOOL                    bSupportCustomizeOutputFormat;/*  0: 1: */
    BOOL                    bSupportCustomizeInputFormat; /* EDID, 0:1 */
    BYTE                    byRes[36];                    
}NETDEV_XW_SUPPORT_CAP_S, *LPNETDEV_XW_SUPPORT_CAP_S;

/**
 * @struct tagNETDEVXWFormatListEx
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWFormatListEx
{
    UINT32      udwVideoOutID;                             /*ID,VideoOutID*/
    UINT32      udwFormatNum;                              
    UINT32      adwFormatList[NETDEV_VIDEO_FORMAT_MAX];    /*  NETDEV_VIDEO_FORMAT_E */
    BYTE        byRes[64];                                 
}NETDEV_XW_FORMAT_EX_LIST_S, *LPNETDEV_XW_FORMAT_EX_LIST_S;

/**
 * @struct tagNETDEVXWAlarmCap
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWAlarmCap
{
    UINT32      udwSupportOSD;                              /*  0 1 */
    BYTE        byRes[128];                                 
}NETDEV_XW_ALARM_CAP_S, *LPNETDEV_XW_ALARM_CAP_S;

/**
 * @struct tagNETDEVXWCAPINFO
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWCAPINFO
{
    NETDEV_XW_TVWALL_CAP_S          stTVWall;                  
    NETDEV_XW_FORMAT_LIST_S         stVideoFormats;            
    NETDEV_XW_Wnd_CAP_S             stWnd;                     
    NETDEV_XW_BASEMAP_CAP_S         stBaseMap;                 
    NETDEV_XW_VIRTUALLED_CAP_S      stVirtualLED;              /* LED */
    NETDEV_XW_SEQUENCE_CAP_S        stSequence;                
    NETDEV_XW_SUPPORT_CAP_S         stSupport;                 
    BOOL                            bIsRSASupported;           /* RSA */
    BOOL                            bIsDevMgrSupported;        
    BOOL                            bIsDecodeSupported;        
    BOOL                            bIsChromaCalSupported;     
    UINT32                          udwSuggestVideoFormat;     /*  # NETDEV_VIDEO_FORMAT_E */
    UINT32                          udwSupportExVideoFormatNum;
    LPNETDEV_XW_FORMAT_EX_LIST_S    pstVideoFormatsEx;         /*  ,udwSupportExVideoFormatNum*/
    UINT32                          udwBatchCapabilities;      /* Bit Bit1: Bit2: Bit3: Bit4: */
    BOOL                            bIsOrderNOSupported;       
    LPNETDEV_XW_ALARM_CAP_S         pstAlarmCap;               
    UINT32                          udwDeviceID;               /* IDVMS */
    LPNETDEV_XW_SCREEN_PROTOCOL_CAP_S pstScreenProtocols;      
    BOOL                            bSupportAdaptiveStream;    /*  0: 1: */
    BYTE                            byRes[16];                 
}NETDEV_XW_CAP_INFO_S, *LPNETDEV_XW_CAP_INFO_S;

/**
* @struct tagNETDEVXWVideoInChlCapInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVXWVideoInChlCapInfo
{
    UINT32 udwVideoInID;                                /* ID,ID */
    UINT32 udwMaxWidth;                                 
    UINT32 udwMaxHeight;                                
    UINT32 udwMaxDataBandwidth;                         /* ,** */
    UINT32 udwMinWidth;                                 
    UINT32 udwMinHeight;                                
    UINT32 udwMaxResolution;                            
    BYTE   byRes[244];                                  /*   Reserved */
}NETDEV_XW_VIDEO_IN_CHL_CAP_INFO_S, *LPNETDEV_XW_VIDEO_IN_CHL_CAP_INFO_S;

/**
* @struct tagNETDEVXWInputChlCapInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVXWInputChlCapInfo
{
    UINT32                               udwVideoInNum;                     
    LPNETDEV_XW_VIDEO_IN_CHL_CAP_INFO_S  pstXWVideoInCapInfoList;           /* , */
    BYTE                                 byRes[256];                        /*   Reserved */
}NETDEV_XW_INPUT_CHL_CAP_INFO_S, *LPNETDEV_XW_INPUT_CHL_CAP_INFO_S;

/**
* @struct tagNETDEVXWVideoOutChlCapInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVXWVideoOutChlCapInfo
{
    UINT32  udwVideoOutID;                              /* ID,ID */
    UINT32  udwMaxWidth;                                
    UINT32  udwMaxHeight;                               
    UINT32  udwMinWidth;                                /* ,  */
    UINT32  udwMinHeight;                               /* , */
    UINT32  udwMaxResolution;                           /* , **/
    UINT32  udwMaxDataBandwidth;                        /* ,** */
    BYTE    byRes[256];                                 /*   Reserved */
}NETDEV_XW_VIDEO_OUT_CHL_CAP_INFO_S, *LPNETDEV_XW_VIDEO_OUT_CHL_CAP_INFO_S;

/**
* @struct tagNETDEVXWOutputChlCapInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVXWOutputChlCapInfo
{
    UINT32                                udwVideoOutNum;                   
    LPNETDEV_XW_VIDEO_OUT_CHL_CAP_INFO_S  pstXWVideoOutCapInfoList;         /* , */
    BYTE                                  byRes[256];                       /*   Reserved */
}NETDEV_XW_OUTPUT_CHL_CAP_INFO_S, *LPNETDEV_XW_OUTPUT_CHL_CAP_INFO_S;

/**
 * @struct tagNETDEVXWVideoOutInfo
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWVideoOutInfo
{
    INT32   dwChannelID;                   /* ID */
    INT32   dwSlotID;                      /* ID */
    INT32   dwIndex;                       
    UINT32  udwVideoPortType;              /*  NETDEV_VIDEO_PORT_TYPE_E */
    UINT32  udwStatus;                     /*   NETDEV_CHN_STATUS_E */
    CHAR    szChannelName[NETDEV_LEN_64];  /* [1,64] */
    BYTE    byRes[128];                    
}NETDEV_XW_VIDEO_OUT_INFO_S, *LPNETDEV_XW_VIDEO_OUT_INFO_S;

/**
 * @struct tagNETDEVXWTVWallCfg
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWTVWallCfg
{
    UINT32                          udwTVWallID;                                    /* ID */
    CHAR                            szTVWallCode[NETDEV_LEN_64];                    /* [1,64] */
    CHAR                            szName[NETDEV_TVWALL_NAME_LEN];                 
    UINT32                          udwOrderNo;                                     
    NETDEV_TVWALL_SCREEN_S          stScreenInfo;                                   
    UINT32                          udwFormatSpecNum;                               
    NETDEV_TVWALL_FORMAT_SPEC_S     astFormatSpec[NETDEV_FORMAT_SPEC_MAX];          
    UINT32                          udwLedSpecNum;                                  
    NETDEV_TVWALL_LED_SPEC_S        astLedSpec[NETDEV_LED_SPEC_MAX];                
    UINT32                          udwVideoOutNum;                                 
    NETDEV_TVWALL_VIDED_OUT_S       astVideoOut[NETDEV_VIDEO_OUT_MAX];              
    UINT32                          udwTVWallType;                                  
    INT32                           dwXWDeviceID;                                   /* -1DC>0ADUID */
    UINT32                          udwZoomEnabled;                                 /* 0:1: */
    BYTE                            byRes[176];                                     
}NETDEV_XW_TVWALL_CFG_S, *LPNETDEV_XW_TVWALL_CFG_S;

/**
 * @struct tagNETDEVXWSceneInfoBase
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoBase
{
    UINT32  udwSceneID;                         /* ID */
    CHAR    szName[NETDEV_SCENE_NAME_LEN];      
    UINT32  udwOrderNo;                         
    UINT32  udwTVWallID;                        /* ID */
    UINT32  udwStatus;                          /* 01 */
    BYTE    byRes[20];                          
}NETDEV_XW_SCENE_INFO_BASE_S, *LPNETDEV_XW_SCENE_INFO_BASE_S;

/**
 * @struct tagNETDEVXWSceneModifyInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneModifyInfo
{
    NETDEV_XW_SCENE_INFO_BASE_S     stSceneBaseInfo;             
    INT32                           dwModifyType;                /*  NETDEV_XW_SCENE_MODIFY_TYPE_E modify type see #NETDEV_XW_SCENE_MODIFY_TYPE_E */
    BYTE                            byRes[128];                  
}NETDEV_XW_SCENE_MODIFY_INFO_S, *LPNETDEV_XW_SCENE_MODIFY_INFO_S;

/**
 * @struct tagNETDEVXWSceneInfoShort
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoShort
{
    NETDEV_XW_SCENE_INFO_BASE_S     stSceneBase;        
    UINT32                          udwIsCurrent;       /*  0: 1: */
    BYTE                            byRes[64];          
}NETDEV_XW_SCENE_INFO_BASIC_S, *LPNETDEV_XW_SCENE_INFO_BASIC_S;

/**
 * @struct tagNETDEVXWCfgTime
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWCfgTime
{
    CHAR    szBeginTime[NETDEV_TIME_LEN];   /*  00:00:00 */
    CHAR    szEndTime[NETDEV_TIME_LEN];     /*  24:00:00 */
    UINT32  udwSceneID;                     /* ID */
}NETDEV_XW_CFG_TIME_S, *LPNETDEV_XW_CFG_TIME_S;

/**
 * @struct tagNETDEVXWPlanCfg
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWPlanCfg
{
    UINT32                  udwDayOfWeek;                       /*  NETDEV_DAY_IN_WEEK_E */
    UINT32                  udwSize;                            
    NETDEV_XW_CFG_TIME_S    stTime[NETDEV_PLAN_SECTION_NUM];    
}NETDEV_XW_PLAN_CFG_S, *LPNETDEV_XW_PLAN_CFG_S;

/**
 * @struct tagNETDEVXWScenePlan
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWScenePlan
{
    UINT32                  udwPlanID;                          /* ID */
    BOOL                    bIsEnabled;                         
    NETDEV_XW_PLAN_CFG_S    astConfig[NETDEV_PLAN_NUM_AWEEK];   
    BYTE                    byRes[64];                          
}NETDEV_XW_SCENE_PLAN_S, *LPNETDEV_XW_SCENE_PLAN_S;

/**
 * @struct tagNETDEVXWPaneInfo
 * @brief XW
 * @attention
 */
typedef struct tagNETDEVXWPaneInfo
{
    UINT32      udwPaneID;              
    INT32       dwChannelID;            /* ID */
    UINT32      udwStreamIndex;         
    UINT32      udwTaskNo;              
    UINT32      udwTransProtocal;       /*   NETDEV_TRANS_PROTOCAL_E */
    UINT32      udwSessionType;         /*   NETDEV_SESSION_TYPE_E */
}NETDEV_XW_PANE_INFO_S, *LPNETDEV_XW_PANE_INFO_S;

/**
 * @struct tagNETDEVXWSceneWndInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneWndInfo
{
    UINT32                  udwWndID;                                  /* ID */
    UINT32                  udwModifyCmd;                              /*  NETDEV_XW_WND_CMD_E */
    CHAR                    szWndName[NETDEV_WND_NAME_LEN];            
    UINT32                  udwPaneMod;                                /* ,1 NETDEV_XW_LAYOUT_NUM_E */
    UINT32                  udwLayer;                                  
    UINT32                  udwTransparency;                           /* 0 ,100  0-100*/
    NETDEV_XW_AREA_S        stArea;                                    
    UINT32                  udwZoomType;                               /*   NETDEV_XW_ZOOM_TYPE_E zoom Type see NETDEV_XW_ZOOM_TYPE_E */
    UINT32                  udwSplitIndex;                             /*  udwZoomType NETDEV_XW_ZOOM_TYPE_SPLIT  */
    UINT32                  udwSchemeResID;                            /* ID */
    UINT32                  udwSeqStatus;                              /*  NETDEV_SEQ_STATUS_E */
    UINT32                  udwPaneSize;                               
    NETDEV_XW_PANE_INFO_S   astPaneInfoList[NETDEV_XW_MAX_PANE_NUM];   
    UINT32                  udwWndType;                                /*   NETDEV_TVWALL_WND_TPYE_E */
    UINT32                  udwDChlID;                                 /* DCID */
    UINT32                  udwStatus;                                 /* 01 */
    UINT32                  udwScaleEnabled;                           /*   NETDEV_SCALE_ENABLED_E LED */
    BYTE                    byRes[240];                                
}NETDEV_XW_SCENE_WND_INFO_S, *LPNETDEV_XW_SCENE_WND_INFO_S;

/**
 * @struct tagNETDEVAuthentication
 * @brief 
 * @attention
 */
typedef struct tagNETDEVAuthentication
{
    BOOL                            bIsNeedAuthentication;                   
    CHAR                            szUserName[NETDEV_USER_NAME_ENCRYPT_LEN];
    CHAR                            szPassword[NETDEV_PASSWORD_ENCRYPT_LEN]; 
    NETDEV_AUTH_MODEL_E             enAuthModel;                             /*  # NETDEV_AUTH_MODEL_E */
    BYTE                            byRes[64];                               
}NETDEV_AUTHENTICATION_S, *LPNETDEV_AUTHENTICATION_S;

/**
 * @struct tagNETDEVXWChannels
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWChannels
{
    UINT32                      udwVideoInID;                       /* ID */
    CHAR                        szReplayURL[NETDEV_MAX_URL_LEN];    /* URL */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   
    UINT32                      udwTransProtocol;                   /*  NETDEV_TRANS_PROTOCOL_E */
    UINT32                      udwMulticast;                       /*  NETDEV_STREAM_TYPE_E */
    INT64                       tBeginTime;                         
    INT64                       tEndTime;                           
    UINT32                      udwManageType;                      /*  NETDEV_XW_MANAGE_TYPE_E  */
    UINT32                      udwSessionID;                       /* XwareRTSPSessionIDManageType=1 */
    BYTE                        byRes[56];                          
}NETDEV_XW_CHANNELS_S, *LPNETDEV_XW_CHANNELS_S;

/**
 * @struct tagNETDEVXWDisplayerID
 * @brief "XW"ID
 * @attention
 */
typedef struct tagNETDEVXWDisplayerID
{
    UINT32  udwTVWallID;    /* ID */
    UINT32  udwWndID;       /* ID */
    UINT32  udwPaneID;      
    BYTE    byRes[16];      
}NETDEV_XW_DISPLAYER_ID_S, *LPNETDEV_XW_DISPLAYER_ID_S;

/**
 * @struct tagNETDEVXWVideoSourceBase
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVideoSourceBase
{
    UINT32                      udwVideoInID;                       /* ID */
    CHAR                        szRealplayURL[NETDEV_MAX_URL_LEN];  /* URL */
    UINT32                      udwStreamID;                        /*  NETDEV_LIVE_STREAM_INDEX_E */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   
    UINT32                      udwTransProtocol;                   /*  NETDEV_TRANS_PROTOCOL_E */
    UINT32                      udwMulticast;                       /*  NETDEV_STREAM_TYPE_E */
    UINT32                      udwType;                            /*   NETDEV_XW_REALPLAY_TYPE_E */
    UINT32                      udwManageType;                      /*  NETDEV_XW_MANAGE_TYPE_E  */
    BYTE                        byRes[28];                          
}NETDEV_XW_VIDEO_SOURCE_BASE_S, *LPNETDEV_XW_VIDEO_SOURCE_BASE_S;

/**
 * @struct tagNETDEVXWContentInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWContentInfo
{
    CHAR  szContent[NETDEV_LEN_260];   
    UINT32  udwFontType;               /*  # NETDEV_XW_LED_FONT_FORMAT_E */
    UINT32  udwFontSize;               /*  048-1024: */
    UINT32  udwColor;                  /* RGB 0xABCDEFABR00~FFCDG00~FFEFB00~FF0xFF0000*/
    UINT32  udwPosition;               /*  # NETDEV_XW_CONTENT_POSITION_E*/
    BYTE    byRes[128];                
}NETDEV_XW_CONTENT_INFO_S, *LPNETDEV_XW_CONTENT_INFO_S;

/**
 * @struct tagNETDEVXWVideoSource
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVideoSource
{
    NETDEV_XW_DISPLAYER_ID_S    stDisplayerID;                      /* ID */
    UINT32                      udwVideoInID;                       /* ID */
    CHAR                        szRealplayURL[NETDEV_MAX_URL_LEN];  /* URL */
    UINT32                      udwStreamID;                        /*  NETDEV_LIVE_STREAM_INDEX_E */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   
    UINT32                      udwTransProtocol;                   /*  NETDEV_TRANS_PROTOCOL_E */
    UINT32                      udwMulticast;                       /*  NETDEV_STREAM_TYPE_E */
    UINT32                      udwType;                            /*   NETDEV_XW_REALPLAY_TYPE_E */
    UINT32                      udwDecodeType;                      /*   NETDEV_XW_DECODE_TYPE_E */
    UINT32                      udwManageType;                      /*  NETDEV_XW_MANAGE_TYPE_E  */
    LPNETDEV_XW_CONTENT_INFO_S  pstContentInfo;                     
    BYTE                        byRes[56];                          
}NETDEV_XW_VIDEO_SOURCE_S, *LPNETDEV_XW_VIDEO_SOURCE_S;

/**
 * @struct tagNETDEVXWPlaybackParam
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWPlaybackParam
{
    UINT32                          udwTaskNo;                   
    UINT32                          udwControlType;              /*   NETDEV_XW_CTRL_TYPE_E */
    UINT32                          udwControlParam;             /*   #-NETDEV_VOD_PLAY_STATUS_E (0-13) */
    BYTE                            byRes[64];                   
}NETDEV_XW_PLAYBACK_PARAM_S, *LPNETDEV_XW_PLAYBACK_PARAM_S;

/**
 * @struct tagNETDEVXWVideoInSource
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVideoInSource
{
    UINT32                      udwVideoInChlID;            /* ID */
    UINT32                      udwStreamID;                
    CHAR                        szURL[NETDEV_MAX_URL_LEN];  /* URL */
    NETDEV_AUTHENTICATION_S     stAuthentication;           
    UINT32                      udwSeqIntervalSec;          /*   */
    UINT32                      udwPreset;                  
    BYTE                        byRes[32];                  
}NETDEV_XW_VIDEO_IN_SOURCE_S, *LPNETDEV_XW_VIDEO_IN_SOURCE_S;

/**
 * @struct tagNETDEVXWVideoInChannelInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWVideoInChannelInfo
{
    UINT32                          udwWndID;                                   /* ID */
    UINT32                          udwPaneID;                                  /*  0*/
    UINT32                          udwSourceSize;                              
    NETDEV_XW_VIDEO_IN_SOURCE_S     astVideoInSource[NETDEV_SEQUENCE_SRC_MAX];  
    BYTE                            byRes[32];                                  
}NETDEV_XW_VIDEO_IN_CHANNEL_INFO_S, *LPNETDEV_XW_VIDEO_IN_CHANNEL_INFO_S;

/**
 * @struct tagNETDEVXWBackground
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBackground
{
    UINT32  udwTransparency;    /*  0 50- ,100 */
    UINT32  udwBaseColor;       /*  RGB:0xABCDEF ABR 00~FF;CDG 00~FF;EFB 00~FF;0xFFFFFF*/
    BYTE    byRes[16];          
}NETDEV_XW_BACKGROUND_S, *LPNETDEV_XW_BACKGROUND_S;

/**
 * @struct tagNETDEVXWFontInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWFontInfo
{
    UINT32  udwFont;                /*  NETDEV_XW_LED_FONT_FORMAT_E */
    UINT32  udwSize;                /*  07NETDEV_XW_LED_FONT_SIZE_E,[48,1024]  */
    UINT32  udwReferFontSize;       /*  udwSize Size*/ 
    UINT32  udwGap;                 /*    NETDEV_XW_LED_FONT_GAP_E */
    UINT32  udwHorizontalAlign;     /*  NETDEV_XW_HORIZONTAL_ALIGN_MODE_E */
    UINT32  udwVerticalAlign;       /*  NETDEV_XW_VERTICAL_ALIGN_MODE_E */
    UINT32  udwColor;               /*  RGB:0xABCDEF ABR 00~FF;CDG 00~FF;EFB 00~FF;0xFFFFFF*/
    UINT32  udwScrollMode;          /*  NETDEV_XW_LED_SCROLLING_MODE_E  */
    UINT32  udwScrollRateSec;       /* ,ScrollingMode11 1x10x1x 2/3/4/5*/
    UINT32  udwReferFontGap;        /* ,udwGap0~1024 */
    BOOL    bVoiceBroadcast;        /*  0 1 */
    BOOL    bBold;                  /*   0:, 1: */
    BOOL    bSlope;                 /*   0:, 1: */ 
    BOOL    bUnderline;             /*   0:, 1: */
    UINT32  udwLineSpace;           
    BYTE    byRes[8];               
}NETDEV_XW_FONT_INFO_S, *LPNETDEV_XW_FONT_INFO_S;/* LED */

/**
* @struct tagNETDEVAnalogClockHandleStyle
* @brief 
* @attention
*/
typedef struct tagNETDEVAnalogClockHandleStyle
{
    BOOL                            bEnabledClockHandle;                    /*  FALSE,TURE*/
    UINT32                          udwColor;                               /*  RGB0xABCDEF,ABR,00~FF,CDG,00~FF,EFB,00~FF,0xFFFFFF*/
    BYTE                            byRes[256];                             /*   Reserved */
}NETDEV_ANALOG_CLOCK_HANDLE_STYLE_S, *LPNETDEV_ANALOG_CLOCK_HANDLE_STYLE_S;

/**
* @struct tagNETDEVAnalogClockScaleStyle
* @brief 
* @attention
*/
typedef struct tagNETDEVAnalogClockScaleStyle
{
    BOOL                            bEnabledScale;                          /*  FALSE,TURE*/
    UINT32                          udwScaleType;                           /*  NETDEV_TIME_SCALE_STYLE_E */
    UINT32                          udwThickness;                           /*  0: ,1~1024 */
    UINT32                          udwColor;                               /*  RGB0xABCDEF,ABR,00~FF,CDG,00~FF,EFB,00~FF,0xFFFFFF*/
    BYTE                            byRes[256];                             /*   Reserved */
}NETDEV_ANALOG_CLOCK_SCALE_STYLE_S, *LPNETDEV_ANALOG_CLOCK_SCALE_STYLE_S;

/**
* @struct tagNETDEVDigitalClockStyle
* @brief 
* @attention
*/
typedef struct tagNETDEVDigitalClockStyle
{
    CHAR                            szDatetimeDisplayInfo[NETDEV_LEN_32];   
    UINT32                          udwDateStyle;                           /*  NETDEV_DATE_STYLE_E */
    UINT32                          udwTimeFormat;                          /* ,012,124 */
    UINT32                          udwShowMeridiem;                        /* /,0, 1 ,12 */
    BOOL                            bMultiLineMode;                         /* , 0, 1 */
    NETDEV_XW_FONT_INFO_S           stFontInfo;                             
    BYTE                            byRes[256];                             /*   Reserved */
}NETDEV_DIGITAL_CLOCK_STYLE_S, *LPNETDEV_DIGITAL_CLOCK_STYLE_S;

/**
* @struct tagNETDEVAnalogClockStyle
* @brief 
* @attention
*/
typedef struct tagNETDEVAnalogClockStyle
{   
    UINT32                              udwShape;                           /*  1,2 */
    NETDEV_ANALOG_CLOCK_SCALE_STYLE_S   stHourScaleInfo;                          
    NETDEV_ANALOG_CLOCK_SCALE_STYLE_S   stMinuteScaleInfo;                  
    NETDEV_ANALOG_CLOCK_HANDLE_STYLE_S  stHourHandInfo;                     
    NETDEV_ANALOG_CLOCK_HANDLE_STYLE_S  stMinuteHandInfo;                   
    NETDEV_ANALOG_CLOCK_HANDLE_STYLE_S  stSecondHandInfo;                   
    BOOL                                bShowDate;                          /*  FALSE: , TURE */
    BYTE                                byRes[256];                         /*   Reserved */
}NETDEV_ANALOG_CLOCK_STYLE_S, *LPNETDEV_ANALOG_CLOCK_STYLE_S;

/**
* @struct tagNETDEVClockStyle
* @brief 
* @attention
*/
typedef struct tagNETDEVClockStyle
{
    UINT32                          udwDisplayTimeZone;                     /* 01 */
    CHAR                            szTimeZone[NETDEV_LEN_256];             
    UINT32                          udwLanguage;                            /*  0,1 */
    UINT32                          udwClockType;                           /*  1: 2: */
    NETDEV_DIGITAL_CLOCK_STYLE_S    stDigitalClockStyle;                    /* ,udwClockType1 */
    NETDEV_ANALOG_CLOCK_STYLE_S     stAnalogClockStyle;                     /* ,udwClockType2 */
    NETDEV_XW_BACKGROUND_S          stBackground;                           
    BYTE                            byRes[512];                             /*   Reserved */
}NETDEV_CLOCK_STYLE_S, *LPNETDEV_CLOCK_STYLE_S;

/**
 * @struct tagNETDEVXWVirtualLEDInfo
 * @brief LED
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDInfo
{
    UINT32                  udwLEDID;                    /* LEDID */
    UINT32                  udwModifyCmd;                /*  NETDEV_XW_LED_CMD_E */
    UINT32                  udwEnable;                   /* LED 0 1 */
    UINT32                  udwType;                     /* LED NETDEV_XW_LED_TYPE_E */
    NETDEV_XW_AREA_S        stArea;                      /* LED */
    NETDEV_XW_BACKGROUND_S  stBackground;                
    NETDEV_XW_FONT_INFO_S   stFontInfo;                  
    CHAR                    szText[NETDEV_TEXT_LEN];     
    LPNETDEV_CLOCK_STYLE_S  pstClockStyle;               
    BYTE                    byRes[28];                   
}NETDEV_XW_VIRTUAL_LED_INFO_S, *LPNETDEV_XW_VIRTUAL_LED_INFO_S;

/**
 * @struct tagNETDEVXWLiveStreamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWLiveStreamInfo
{
    UINT32                 udwStreamID;                     
    BYTE                   byRes[256];                      
}NETDEV_XW_LIVE_STREAM_INFO_S, *LPNETDEV_XW_LIVE_STREAM_INFO_S;

/**
 * @struct tagNETDEVXWLiveInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWLiveInfo
{
    UINT32                         udwTaskNo;                     
    NETDEV_XW_LIVE_STREAM_INFO_S   stLiveStreamInfo;              
    BYTE                           byRes[256];                    
}NETDEV_XW_LIVE_INFO_S, *LPNETDEV_XW_LIVE_INFO_S;

/**
 * @struct tagNETDEVXWLiveBindInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWLiveBindInfo
{
    UINT32                         udwLastChange;                 
    NETDEV_XW_LIVE_STREAM_INFO_S   stLiveStreamInfo;              
    BYTE                           byRes[256];                    
}NETDEV_XW_LIVE_BIND_INFO_S, *LPNETDEV_XW_LIVE_BIND_INFO_S;

/*******************************Begin*****************************/
/**
 * @struct tagNETDEVXWSenceBatchWnd
 * @brief 
 * @attention
*/
typedef struct tagNETDEVXWSenceBatchWnd
{
    UINT32                          udwReqSeq;              
    NETDEV_XW_SCENE_WND_INFO_S      stSenceWndInfo;         
    BYTE                            byRes[32];              
}NETDEV_XW_SENCE_BATCH_WND_S, *LPNETDEV_XW_SENCE_BATCH_WND_S;

/**
 * @struct tagNETDEVXWBatchWindowInfoList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBatchWindowInfoList
{
    UINT32                          udwOperation;                 /* 0 1 */
    UINT32                          udwNum;                       
    LPNETDEV_XW_SENCE_BATCH_WND_S   pstSceneWinInfo;              
    BYTE                            byRes[256];                   
}NETDEV_XW_WND_INFO_LIST_S,*LPNETDEV_XW_WND_INFO_LIST_S;

/**
 * @struct tagNETDEVXWSenceBatchResultWnd
 * @brief 
 * @attention
*/
typedef struct tagNETDEVXWSenceBatchResultWnd
{
    UINT32  udwReqSeq;      
    UINT32  udwResuleCode;  
    UINT32  udwWinID;       /* ID */
}NETDEV_XW_BATCH_RESULT_WND_S, *LPNETDEV_XW_BATCH_RESULT_WND_S;

/**
 * @struct tagNETDEVXWSenceBatchResultList
 * @brief 
 * @attention
*/
typedef struct tagNETDEVXWSenceBatchResultList
{
    UINT32                              udwSize;            
    UINT32                              udwLastChange;      
    LPNETDEV_XW_BATCH_RESULT_WND_S      pstResultInfo;      /* , */
    BYTE                                byRes[32];          
}NETDEV_XW_BATCH_RESULT_LIST_S, *LPNETDEV_XW_BATCH_RESULT_LIST_S;

/**
 * @struct tagNETDEVXWSequenceSource
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSequenceSource
{
    UINT32                          udwInterval;                                
    UINT32                          udwPreset;                                  
    NETDEV_XW_VIDEO_SOURCE_BASE_S   stVideoSourceBase;                          
    BYTE                            byRes[32];                                  
}NETDEV_XW_SEQUENCE_SOURCE_S, *LPNETDEV_XW_SEQUENCE_SOURCE_S;

/**
 * @struct tagNETDEVXWSequenceSourceList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSequenceSourceList
{
    UINT32                          udwWndID;                                   /* ID */
    UINT32                          udwSourceSize;                              
    NETDEV_XW_SEQUENCE_SOURCE_S     astSequenceSource[NETDEV_SEQUENCE_SRC_MAX]; 
    BYTE                            byRes[32];                                  
}NETDEV_XW_SEQUENCE_SOURCE_LIST_S, *LPNETDEV_XW_SEQUENCE_SOURCE_LIST_S;

/**
 * @struct tagNETDEVXWBaseMapInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBaseMapInfo
{
    UINT32      udwBaseMapID;                                     /* ID */
    UINT32      udwEnabled;                                       /*  0 1 */
    CHAR        szName[NETDEV_LEN_128];                           /* ,[1, 64] */
    UINT32      udwThumbnailSize;                                 /* base64,,8*1024*1024 */
    CHAR*       pcThumbnailPicData;                               /* base64, */
    UINT32      udwPictureSize;                                   /* base64,,32*1024*1024 */
    CHAR*       pcPictureData;                                    /* base64, */
    BYTE        byRes[256];                                       
}NETDEV_XW_BASE_MAP_INFO_S, *LPNETDEV_XW_BASE_MAP_INFO_S;

/**
 * @struct tagNETDEVXWBaseMapList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBaseMapList
{
    UINT32                      udwNum;                           
    LPNETDEV_XW_BASE_MAP_INFO_S pstBaseMapInfoList;              
    BYTE                        byRes[256];                      
}NETDEV_XW_BASE_MAP_LIST_S, *LPNETDEV_XW_BASE_MAP_LIST_S;

/**
 * @struct tagNETDEVXWSequenceResourceBindBaseInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSequenceResourceBindBaseInfo
{
    UINT32          udwID;                                  /* ID, */
    UINT32          udwSequenceResID;                       /* ID */
    UINT32          udwIntervalTime;                        /*  */
    UINT32          udwStatus;                              /*  NETDEV_XW_SEQUENCE_RES_STATUS_E */
    UINT32          udwWndNum;                              
    UINT32          audwWndIDList[NETDEV_SEQ_RES_WIN_MAX];  /* ID */
    BYTE            byRes[256];                             
}NETDEV_XW_SEQUENCE_RES_BIND_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_BIND_INFO_S;

/**
 * @struct tagNETDEVXWSceneInfoDetail
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoDetail
{
    CHAR                                    szName[NETDEV_SCENE_NAME_LEN];      
    UINT32                                  udwTVWallID;                        /* ID */
    CHAR                                    szTVWallCode[NETDEV_LEN_64];        /* [1,64] */
    NETDEV_XW_BASE_MAP_INFO_S               stBaseMapInfo;                      
    UINT32                                  udwVirtualLedNum;                   /* LED */
    LPNETDEV_XW_VIRTUAL_LED_INFO_S          pstVirtualLedInfo;                  /* LED */
    UINT32                                  udwWndNum;                          
    LPNETDEV_XW_SCENE_WND_INFO_S            pstWndInfo;                         
    UINT32                                  udwLiveBindNum;                     
    LPNETDEV_XW_VIDEO_SOURCE_S              pstVideoSource;                     
    UINT32                                  udwSequenceBindNum;                 
    LPNETDEV_XW_SEQUENCE_SOURCE_LIST_S      pstSequenceSourceList;              
    UINT32                                  udwWindowsSequenceBindNum;          
    LPNETDEV_XW_SEQUENCE_RES_BIND_INFO_S    pstWindowsSequenceBindList;         
    UINT32                                  udwLinkedSceneID;                   /* ID */
    UINT32                                  udwLinkedSceneOrderNo;              
    UINT32                                  udwSceneSessionMode;                /*  # NETDEV_SCENE_SESSION_MODE_E*/
    BYTE                                    byRes[172];                         
}NETDEV_XW_SCENE_INFO_DETAIL_S, *LPNETDEV_XW_SCENE_INFO_DETAIL_S;

/**
 * @struct tagNETDEVXWChannelsNum
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWChannelsNum
{
    UINT32  udwVideoInNum;               
    UINT32  udwVideoOutNum;              
    UINT32  udwAudioInNum;               
    UINT32  udwAudioOutNum;              
    BYTE    byRes[64];                  
}NETDEV_XW_CHANNELS_NUM_S, *LPNETDEV_XW_CHANNELS_NUM_S;

/**
 * @struct tagNETDEVXWVideoInInfo
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWVideoInInfo
{
    INT32   dwChannelID;                   /* ID */
    INT32   dwIndex;                       
    UINT32  udwVideoPortType;              /*  NETDEV_VIDEO_PORT_TYPE_E */
    UINT32  udwStatus;                     /*   NETDEV_CHN_STATUS_E */
    UINT32  udwAbnormalReason;             /*   NETDEV_CHN_ABNORMAL_REASON_E */
    CHAR    szChannelName[NETDEV_LEN_64];  /* [1,64] */
    BYTE    byRes[128];                    
}NETDEV_XW_VIDEO_IN_INFO_S, *LPNETDEV_XW_VIDEO_IN_INFO_S;

/**
 * @struct tagNETDEVXWAudioOutInfo
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWAudioOutInfo
{
    INT32   dwChannelID;                   /* ID */
    UINT32  udwAudioPortType;              /*  NETDEV_AUDIO_PORT_TYPE_E */
    UINT32  udwIndex;                      
    UINT32  udwStatus;                     /*   NETDEV_CHN_STATUS_E */
    CHAR    szChannelName[NETDEV_LEN_64];  /* [1,64] */
    BYTE    byRes[128];                    
}NETDEV_XW_AUDIO_OUT_INFO_S, *LPNETDEV_XW_AUDIO_OUT_INFO_S;

/**
 * @struct tagNETDEVXWAudioInInfo
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWAudioInInfo
{
    INT32   dwChannelID;                   /* ID */
    UINT32  udwAudioPortType;              /*  NETDEV_AUDIO_PORT_TYPE_E */
    UINT32  udwIndex;                      
    UINT32  udwStatus;                     /*   NETDEV_CHN_STATUS_E */
    CHAR    szChannelName[NETDEV_LEN_64];  /* [1,64] */
    BYTE    byRes[128];                    
}NETDEV_XW_AUDIO_IN_INFO_S, *LPNETDEV_XW_AUDIO_IN_INFO_S;

/**
 * @struct tagNETDEVXWSerialInfo
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWSerialInfo
{
    INT32   dwChannelID;            /* ID */
    INT32   dwIndex;                
    UINT32  udwSerialPortType;      /*  NETDEV_XW_SERIAL_TYPE_E */
    UINT32  udwStatus;              /*   NETDEV_CHN_STATUS_E */
    BYTE    byRes[60];              
}NETDEV_XW_SERIAL_INFO_S, *LPNETDEV_XW_SERIAL_INFO_S;

/**
 * @struct tagNETDEVXWChannelsList
 * @brief "XW"
 * @attention
 */
typedef struct tagNETDEVXWChannelsList
{
    UINT32                          udwVideoInNum;                  /*  ADU/CDU */
    LPNETDEV_XW_VIDEO_IN_INFO_S     pstVideoIn;                     /* ,udwVideoInNum  */
    UINT32                          udwVideoOutNum;                 /*  ADU/CDU*/
    LPNETDEV_XW_VIDEO_OUT_INFO_S    pstVideoOut;                    /* ,udwVideoOutNum  */
    UINT32                          udwAudioInNum;                  /*  ADU/CDU*/
    LPNETDEV_XW_AUDIO_IN_INFO_S     pstAudioIn;                     /* ,udwAudioInNum  */
    UINT32                          udwAudioOutNum;                 /*  ADU/CDU*/
    LPNETDEV_XW_AUDIO_OUT_INFO_S    pstAudioOut;                    /* ,udwAudioOutNum */
    UINT32                          udwSerialNum;                   /*  ADU/CDU*/
    LPNETDEV_XW_SERIAL_INFO_S       pstSerialInfo;                  /* ,udwSerialNum */
    BYTE                            byRes[56];                      
}NETDEV_XW_CHANNELS_LIST_S, *LPNETDEV_XW_CHANNELS_LIST_S;

/**
 * @struct tagNETDEVPassiveDecodeSend
* @brief    
* @attention  None
*/
typedef struct tagNETDEVPassiveDecodeSend
{
    INT32 dwTransType;          
    INT32 dwBufSize;            
    CHAR *pszBuffer;            
    BYTE byRes[128];            
}NETDEV_PASSIVE_SEND_S, *LPNETDEV_PASSIVE_SEND_S;

/**
 * @struct tagNETDEVSmartEncodeInfo
 * @brief  Smart image encoding mode
 * @attention
 */
typedef struct tagNETDEVSmartEncodeInfo 
{
    UINT32 udwH264SmartEncodeModeNum;                                              /* H.264 Number of smart image encoding in H.264*/
    UINT32 audwH264SmartEncodeModeList[NETDEV_SMART_ENCODE_MODEL_MAX_NUM];         /* H.265 NETDEV_SMART_ENCODE_MODE_E  List of smart image encoding in H.265. See NETDEV_SMART_ENCODE_MODE_E for reference*/
    UINT32 udwH265SmartEncodeModeNum;                                              /* H.264 Number of smart image encoding in H.264*/
    UINT32 audwH265SmartEncodeModeList[NETDEV_SMART_ENCODE_MODEL_MAX_NUM];         /* H.265 NETDEV_SMART_ENCODE_MODE_E  List of smart image encoding in H.265. See NETDEV_SMART_ENCODE_MODE_E for reference */
}NETDEV_SMART_ENCODE_S,*LPNETDEV_SMART_ENCODE_S;

/**
 * @struct tagNETDEVResolutionCapability
 * @brief  Resolution details
 * @attention
 */
typedef struct tagNETDEVResolutionCapability
{
    UINT32 udwWidth;                                                                  /*  Image width*/
    UINT32 udwHeight;                                                                 /*  Image height*/
    UINT32 udwMinBitRate;                                                             /*  Minimum bit rate*/
    UINT32 udwMaxBitRate;                                                             /*  Maximum bit rate*/
    UINT32 udwDefaultBitRate;                                                         /*  Default bit rate*/
}NETDEV_RESOLUTION_CAPABILITY_S,*LPNETDEV_RESOLUTION_CAPABILITY_S;

/**
 * @struct tagNETDEVStreamCapability
 * @brief  Stream capability
 * @attention
 */
typedef struct tagNETDEVStreamCapability
{
    UINT32 udwstreamID;                                                             /*  NETDEV_LIVE_STREAM_INDEX_E  Stream index. For enumeration, seeNETDEV_LIVE_STREAM_INDEX_E */
    UINT32 udwResolutionNum;                                                        /*  Number of resolution*/
    UINT32 udwFrameRateNum;                                                         /*  Number of frame rate*/
    UINT32 udwMaxFrameRate;                                                         /*  Number of frame rate*/
    UINT32 udwMaxMJPEGFrameRate;                                                    /* MJPEG Maximum MJPEG frame rate of current stream*/
    UINT32 audwFrameRateList[NETDEV_LEN_16];                                        /*  Frame rate array*/
    NETDEV_RESOLUTION_CAPABILITY_S astResolutionCapabilityList[NETDEV_LEN_32];      /*   List of resolution*/
    NETDEV_SMART_ENCODE_S stSmartEncode;                                            /*  Smart image encoding mode*/
}NETDEV_STREAM_CAP_S,*LPNETDEV_STREAM_CAPABILITY_S;

/**
 * @struct tagNETDEVVideoModeInfo
 * @brief  Video mode capability
 * @attention
 */
typedef struct tagNETDEVVideoModeInfo 
{
    UINT32 udwWidth;                                      /*  Image width*/
    UINT32 udwHeight;                                     /*  Image height*/
    UINT32 udwFrameRate;                                  /*  Image frame rate*/
}NETDEV_VIDEO_MODE_INFO_S,*LPNETDEV_VIDEO_MODE_INFO_S;

/**
* @struct tagNETDEVRecordStatus
* @brief 
* @attention 
*/
typedef struct tagNETDEVRecordStatus
{
    INT32   dwChannelID;                    /*   Channel ID */
    INT32   dwRecordType;                   /*  0:1:2:3:4:*/
    INT32   dwRecordStatus;                 /*  0:1:2:3:*/
    BYTE    byRes[128];                     
}NETDEV_RECORD_STATUS, *LPNETDEV_RECORD_STATUS;

/**
* @struct tagNETDEVRecordStatusList
* @brief 
* @attention 
*/
typedef struct tagNETDEVRecordStatusList
{
    UINT32                  udwSize;                                 
    NETDEV_RECORD_STATUS    astRecordStatus[NETDEV_CHANNEL_MAX];     
}NETDEV_RECORD_STATUS_LIST_S, *LPNETDEV_RECORD_STATUS_LIST_S;

/**
 * @struct tagNETDEVVideoCapInfo
 * @brief  Encoding parameter capability
 * @attention
 */
typedef struct tagNETDEVVideoCapInfo
{
    BOOL                     bIsSupportCfg;                                              /* ,0: , 1:  Support configuration or not. 0-No, 1-Yes*/
    BOOL                     bIsSupportSmoothLevel;                                      /* ,0: , 1:  Support smoothing or not. 0-No, 1-Yes*/
    BOOL                     bIsSupportImageFormat;                                      /* ,0: , 1:  Support configuration of image mode or not. 0-No, 1-Yes*/
    UINT32                   udwEncodeFormatNum;                                         /*  Number of video compression*/
    UINT32                   audwEncodeFormatList[NETDEV_ENCODE_FORMAT_MAX_NUM];         /*  NETDEV_VIDEO_CODE_TYPE_E  Video compression list. See NETDEV_VIDEO_CODE_TYPE_E for reference */
    UINT32                   udwMinIFrameInterval;                                       /* I Minimum value of I Frame Interval*/
    UINT32                   udwMaxIFrameInterval;                                       /* I Maximum value of I Frame Interval*/
    UINT32                   udwGOPTypeNum;                                              /* GOP Number of GOP type*/
    UINT32                   audwGOPTypeList[NETDEV_GOP_TYPE_MAX_NUM];                   /* GOP List of GOP type*/
    UINT32                   udwVideoModeNum;                                            /*  Number of video mode*/
    NETDEV_VIDEO_MODE_INFO_S astVideoModeList[NETDEV_LEN_16];                            /*  List of video mode capability*/
    UINT32                   udwStreamCapNum;                                            /*  Number of stream*/
    NETDEV_STREAM_CAP_S      astStreamCapList[NETDEV_LEN_16];                            /*  List of stream capability*/
    BOOL                     bIsSupportScrambled;                                        /* 0: , 1:  */
    BYTE                     byRes[256];                                                 
}NETDEV_VIDEO_STREAM_CAP_EX_S,*LPNETDEV_VIDEO_STREAM_CAP_EX_S;

/**
 * @struct tagNETDEVVideoEncodeInfo
 * @brief  Video encoding parameter
 * @attention
 */
typedef struct tagNETDEVVideoEncodeInfo
{
    BOOL   bEnableSVCMode;                      /* SVC,0,1 SVC configuration. 0-Off, 1-On*/
    UINT32 udwEncodeFormat;                     /*  NETDEV_VIDEO_CODE_TYPE_E   Video Compression. For enumeration, seeNETDEV_VIDEO_CODE_TYPE_E*/
    UINT32 udwWidth;                            /*  Image width*/
    UINT32 udwHeight;                           /*  Image height*/
    UINT32 udwBitrate;                          /*  Bit rate*/
    UINT32 udwBitrateType;                      /*  NETDEV_BIT_RATE_TYPE_E  Bitrate type. See NETDEV_BIT_RATE_TYPE_E for reference */
    UINT32 udwFrameRate;                        /*  Frame rate*/
    UINT32 udwGopType;                          /* Gop, NETDEV_GOP_TYPE_E  GOP mode. See NETDEV_GOP_TYPE_E for reference */
    UINT32 udwIFrameInterval;                   /* I I Frame Interval. The range depends on capability*/
    UINT32 udwImageQuality;                     /* [1, 9]9 Image quality, ranges from 1 to 9. 9 means the highest quality*/
    UINT32 udwSmoothLevel;                      /* [1,9]1 Smoothing level, ranges from 1 to 9. 1 means the lowest level*/
    UINT32 udwSmartEncodeMode;                  /*  NETDEV_SMART_ENCODE_MODE_E  Smart encoding mode. See NETDEV_SMART_ENCODE_MODE_E for reference*/
}NETDEV_VIDEO_ENCODE_INFO_S,*LPNETDEV_VIDEO_ENCODE_INFO_S;

/**
 * @struct tagNETDEVVideoStreamInfoLapi
 * @brief (LAPI) Video stream info(LAPI)
 * @attention
 */
typedef struct tagNETDEVVideoStreamInfoLapi 
{
    BOOL                       bEnabled;                               /*  Enable encoding for video stream or not*/
    UINT32                     udwStreamID;                            /*  NETDEV_LIVE_STREAM_INDEX_E  Stream index. For enumeration, seeNETDEV_LIVE_STREAM_INDEX_E*/
    UINT32                     udwMainStreamType;                      /*  NETDEV_MAIN_STREAM_TYPE_E  Main stream. See NETDEV_MAIN_STREAM_TYPE_E for reference */
    NETDEV_VIDEO_ENCODE_INFO_S stVideoEncodeInfo;                      /*  Video encoding parameter*/
}NETDEV_VIDEO_STREAM_INFO_EX_S,*LPNETDEV_VIDEO_STREAM_INFO_EX_S;

/**
 * @struct tagNETDEVVideoStreamInfoList
 * @brief  Video stream list
 * @attention
 */
typedef struct tagNETDEVVideoStreamInfoList 
{
    UINT32                        udwNum;                                       /*  Number of video stream*/
    NETDEV_VIDEO_STREAM_INFO_EX_S astVideoStreamInfoList[NETDEV_LEN_16];        /*  Video stream list*/
}NETDEV_VIDEO_STREAM_INFO_LIST_S,*LPNETDEV_VIDEO_STREAM_INFO_LIST_S;

/***********************   Boolean configuration***************************** */

/**
 * @struct tagNETDEVAlarmInputInfo
 * @brief     Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfo
{
    CHAR  szName[NETDEV_LEN_64];                          /*  Name of input alarm */
}NETDEV_ALARM_INPUT_INFO_S, *LPNETDEV_ALARM_INPUT_INFO_S;

/**
 * @struct tagNETDEVAlarmInputInfoList
 * @brief     All Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfoList
{
    INT32                        dwSize;                                           /*   Number of input alarms */
    NETDEV_ALARM_INPUT_INFO_S    astAlarmInputInfo[NETDEV_MAX_ALARM_IN_NUM];       /*   Configuration information of input alarms */
}NETDEV_ALARM_INPUT_LIST_S, *LPNETDEV_ALARM_INPUT_LIST_S;

/**
 * @struct tagNETDEVInputSwitchesInfo
 * @brief     input switch quantity alert information
 * @attention  None
 */
typedef struct tagNETDEVInputSwitchesInfo
{
    INT32                        dwChancelId;                   /*  Channel ID */
    INT32                        dwInputSwitchIndex;            /*   Input Switch Index*/
    CHAR                         szName[NETDEV_LEN_64];         /*    Name of input alarm */
    CHAR                         szGBID[NETDEV_LEN_32];         /* ,IPC   International Standard Resource Coding, supported by IPC only */
    INT32                        dwRunMode;                     /*  1: 2  Alarm Type 1: Open 2: Closed*/
    INT32                        dwEnabled;                     /*  0: 1  Alarm Enabling 0: No Enabling 1: Enabling*/
    INT32                        dwVideoResID;                  /* ID,VMS */
    BYTE                         bRes[124];                     /*  Reserved */
}NETDEV_INPUT_SWITCH_INFO_S, *LPNETDEV_INPUT_SWITCH_INFO_S;

/**
 * @struct tagNETDEVInputSwitchesInfoList
 * @brief     enter switch quantity alert configuration information list
 * @attention  None
 */
typedef struct tagNETDEVInputSwitchesInfoList
{
    INT32                        udwNum;                                /*    Number of input switches  */
    NETDEV_INPUT_SWITCH_INFO_S   astInputSwitchesInfo[NETDEV_LEN_1024]; /*   input switches configuration information */
}NETDEV_INPUT_SWITCH_INFO_LIST_S, *LPNETDEV_INPUT_SWITCH_INFO_LIST_S;

/**
 * @struct tagNETDEVAlarmOutputInfo
 * @brief    Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputInfo
{   
    CHAR    szName[NETDEV_LEN_64];                  /*   Boolean name */
    INT32   dwChancelId;                            /*  Channel ID */
    INT32   enDefaultStatus;                        /*  # NETDEV_BOOLEAN_MODE_E  Default status of boolean output, see enumeration #NETDEV_BOOLEAN_MODE_E */
    INT32   dwDurationSec;                          /*   S  Alarm duration (s) */
    INT32   dwOutputNum;                            /*  Alarm output serial number */
} NETDEV_ALARM_OUTPUT_INFO_S, *LPNETDEV_ALARM_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVInputSwitchesInfoList
 * @brief    All Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputList
{   
    INT32                       dwSize;                                                 /*    Number of booleans  */
    NETDEV_ALARM_OUTPUT_INFO_S  astAlarmOutputInfo[NETDEV_MAX_ALARM_OUT_NUM];           /*   Boolean configuration information */
} NETDEV_ALARM_OUTPUT_LIST_S, *LPNETDEV_ALARM_OUTPUT_LIST_S;

/**
 * @struct tagNETDEVOutputSwitchesAlarmStatus
 * @brief  ()
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesAlarmStatus
{
    INT32   dwBooleanId;                            /*   Boolean ID */
    INT32   dwChannelId;                            /* ID,0 */
    INT32   enAlarmStatus;                          /*  #NETDEV_RELAYOUTPUT_STATE_E */
} NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S, *LPNETDEV_OUTPUT_SWITCH_ALARM_STATUS_S;

/**
 * @struct tagNETDEVOutputSwitchesAlarmStatusList
 * @brief  ()
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesAlarmStatusList
{   
    INT32                                dwSize;                                                       /*    Number of booleans  */
    NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S  astOutputAlarmStatusInfo[NETDEV_MAX_ALARM_OUT_NUM];           /*  Output switches alarm status list*/
    BYTE                                 bRes[128];                                                    /*  Reserved */
} NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S, *LPNETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S;

/**
 * @struct tagNETDEVOutputSwitchesManualAlarmInfo
 * @brief  ()
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesManualAlarmInfo
{   
    INT32                               dwSize;                                    /*    Number of booleans  */
    INT32                               dwIDList[NETDEV_MAX_ALARM_OUT_NUM];        /*  booleans ID list */
    NETDEV_MANUAL_ALARM_CMD_E           dwAlarmAction;                             /*  NETDEV_MANUAL_ALARM_CMD_E */
    BYTE                                bRes[128];                                 /*  Reserved */
} NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S, *LPNETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S;

/**
 * @struct tagNETDEVTriggerAlarmOutput
 * @brief    Trigger boolean output alarm Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTriggerAlarmOutput
{   
    CHAR                        szName[NETDEV_LEN_64];          /*   Boolean name */
    NETDEV_RELAYOUTPUT_STATE_E  enOutputState;                  /* ,# NETDEV_RELAYOUTPUT_STATE_E  Trigger status, see enumeration #NETDEV_RELAYOUTPUT_STATE_E */
} NETDEV_TRIGGER_ALARM_OUTPUT_S, *LPNETDEV_TRIGGER_ALARM_OUTPUT_S;

/**
 * @struct tagNETDEVTimeSectionInfo
 * @brief   Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTimeSectionInfo
{
    CHAR    szBeginTime[NETDEV_LEN_32];              /*   Begin time */
    CHAR    szEndTime[NETDEV_LEN_32];                /*   End time */
    UINT32  udwArmingType;                           /* 0:  1:  2:  3:  4: 5: 10:   Distribution Type 0: Timing 1: Motive Inspection 2: Alarm 3: Motive Inspection and Alarm 4: Motive Inspection or Alarm 5: Unplanned 10: Event*/
}NETDEV_TIME_SECTION_INFO_S, *LPNETDEV_TIME_SECTION_INFO_S;

/**
 * @struct tagNETDEVDayPlanInfo
 * @brief   Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDayPlanInfo
{
    UINT32                      udwID;                                           /*1;2345678  Weekly Index 1: Monday; 2: Tuesday; 3: Wednesday; 4: Thursday; 5: Friday; 6: Saturday; 7: Sunday; 8: Holidays;*/
    UINT32                      udwNum;                                          /* NVR8IPC4  The maximum number of NVRs per day is 8; IPC maximum 4 paragraphs*/
    NETDEV_TIME_SECTION_INFO_S  astTimeSection[NETDEV_MAX_TIME_SECTION_NUM];     /*   Time Sections */
}NETDEV_DAY_PLAN_INFO_S, *LPNETDEV_DAY_PLAN_INFO_S;

/**
 * @struct tagNETDEVPlanWeekInfo
 * @brief   Play (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlanWeekInfo
{
    BOOL                        bEnabled;                                           /* ,IPC  Enabling,IPC only*/
    UINT32                      udwNum;                                             /* NVR8()IPC7()  Planned days, NVR up to 8(7 days a week and holidays) IPC up to 7(7 days a week)*/
    NETDEV_DAY_PLAN_INFO_S      astDayPlanInfo[NETDEV_MAX_DAY_NUM];                 /*   List of deployment plans for each day of the week*/
    BYTE                        byRes[512];                                         /*   Reserved */
}NETDEV_WEEK_PLAN_INFO_S, *LPNETDEV_WEEK_PLAN_INFO_S;

/**
 * @struct tagNETDEVSwitchWeekPlanInfo
 * @brief   Plan (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVSwitchWeekPlanInfo
{
    UINT32                      udwSwitchIndex;                 
    NETDEV_WEEK_PLAN_INFO_S     astWeekPlanInfo;                
    BYTE                        byRes[128];                     /*   Reserved */
}NETDEV_SWITCH_WEEK_PLAN_INFO_S, *LPNETDEV_SWITCH_WEEK_PLAN_INFO_S;

/************************************************ OSD********************************************************/

/**
 * @struct tagNETDEVAreaScope
 * @brief   Area
 * @attention  None
 */
typedef struct tagNETDEVAreaScope
{
    INT32  dwLocateX;             /** x[0,10000] * Coordinates of top point x [0,10000] */
    INT32  dwLocateY;             /** y[0,10000] * Coordinates of top point y [0,10000] */
}NETDEV_AREA_SCOPE_S, *LPNETDEV_AREA_SCOPE_S;

/**
 * @struct tagNETDEVOsdTime
 * @brief OSD OSD time configuration information
 * @attention  None
 */
typedef struct tagNETDEVOsdTime
{
    BOOL                    bEnableFlag;        /** OSD, BOOL_TRUE,BOOL_FALSE * Enable time OSD, BOOL_TRUE means enable and BOOL_FALSE means disable */
    BOOL                    bWeekEnableFlag;    /** () * Display week or not (reserved) */
    NETDEV_AREA_SCOPE_S     stAreaScope;        /**  * Area coordinates */
    UINT32                  udwTimeFormat;      /** OSD, NETDEV_OSD_TIME_FORMAT_CAP_E * Time OSD format, see NETDEV_OSD_TIME_FORMAT_E */
    UINT32                  udwDateFormat;      /** OSD, NETDEV_OSD_DATE_FORMAT_CAP_E * Date OSD format, see NETDEV_OSD_TIME_FORMAT_E */
}NETDEV_OSD_TIME_S, *LPNETDEV_OSD_TIME_S;

/**
 * @struct tagNETDEVOsdTextOverlay
 * @brief OSD OSD text overlay information
 * @attention
 */
typedef struct tagNETDEVOsdTextOverlay
{
    BOOL                    bEnableFlag;                           /** OSD, BOOL_TRUE,BOOL_FALSE * Enable OSD text overlay, BOOL_TRUE means enable and BOOL_FALSE means disable */
    NETDEV_AREA_SCOPE_S     stAreaScope;                           /** OSD * OSD text overlay area coordinates */
    CHAR                    szOSDText[NETDEV_OSD_TEXT_MAX_LEN];    /** OSD * OSD text overlay name strings */
    BYTE                    byRes[4];                              /*   Reserved */
}NETDEV_OSD_TEXT_OVERLAY_S, *LPNETDEV_OSD_TEXT_OVERLAY_S;

/**
 * @struct tagNETDEVOsdCfgInfo
 * @brief OSD Basic channel OSD information
 * @attention
 */
typedef struct tagNETDEVOsdCfgInfo
{
    NETDEV_OSD_TIME_S         stTimeOSD;                                    /* OSD  Information of channel time OSD */
    NETDEV_OSD_TEXT_OVERLAY_S stNameOSD;                                    /* OSD  Information of channel name OSD */
    INT16                     wTextNum;                                     /* OSD  Text OSD number */
    NETDEV_OSD_TEXT_OVERLAY_S astTextOverlay[NETDEV_OSD_TEXTOVERLAY_NUM];   /* OSD  Information of channel OSD text overlay */
}NETDEV_VIDEO_OSD_CFG_S, *LPNETDEV_VIDEO_OSD_CFG_S;

/**
 * @struct tagAreaInfo
 * @brief  Definition of area configuration structure 
 * @attention
 */
typedef struct tagAreaInfo
{
    INT32   bIsEanbled;           /*   Enable or not. */
    INT32   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
    INT32   dwIndex;              /*   Index. */
}NETDEV_PRIVACY_MASK_AREA_INFO_S;

/**
 * @struct tagPrivacyMaskPara
 * @brief  Privacy mask configuration information
 * @attention
 */
typedef struct tagPrivacyMaskPara
{
    INT32                                  dwSize;                                     /*   Mask area number */ 
    NETDEV_PRIVACY_MASK_AREA_INFO_S        astArea[NETDEV_MAX_PRIVACY_MASK_AREA_NUM];  /*   Mask area parameters */
}NETDEV_PRIVACY_MASK_CFG_S, *LPNETDEV_PRIVACY_MASK_CFG_S;

/**
 * @struct tagNETDEVOsdCapabilities
 * @brief OSD OSD Capabilities
 * @attention
 */
typedef struct tagNETDEVOsdCapabilities
{
    BOOL     bIsSupportCfg;                                                     /* ,0 1 Support configuration or not. 0-No, 1-Ye*/
    BOOL     bIsSupportFontSizeCfg;                                             /* OSD Support configuration of OSD size or not*/ 
    BOOL     bIsSupportFontColorCfg;                                            /* OSD upport configuration of OSD color or not*/ 
    UINT32   udwMaxAreaNum;                                                     /* OSD Maximum number of OSD area*/ 
    UINT32   udwMaxOSDNum;                                                      /* OSD Maximum number of OSD*/ 
    UINT32   udwMaxPerAreaOSDNum;                                               /* OSD Maximum number of OSD in each area*/ 
    UINT32   udwSupportedOSDTypeNum;                                            /* OSD Number of OSD content type*/ 
    UINT32   udwSupportedTimeFormatNum;                                         /* OSD Number of OSD time format*/ 
    UINT32   udwSupportedDateFormatNum;                                         /* OSD Number of OSD date format*/ 
    UINT32   aduwSupportedDateFormatList[NETDEV_OSD_DATE_FORMAT_MAX_NUM];       /* OSD NETDEV_OSD_DATE_FORMAT_E */ 
    UINT32   audwSupportedTimeFormatList[NETDEV_OSD_TIME_FORMAT_MAX_NUM];       /* OSD NETDEV_OSD_TIME_FORMAT_E */ 
    UINT32   audwSupportedOSDTypeList[NETDEV_OSD_TYPE_MAX_NUM];                 /* OSD NETDEV_OSD_CONTENT_TYPE_E */ 
    UINT32   udwSupportedFontSizeNum;                                           /* OSD Number of OSD font size */ 
    UINT32   udwSupportedFontStyleNum;                                          /* OSD Number of OSD font style */ 
    UINT32   audwSupportedFontSizeList[NETDEV_OSD_FONT_SIZE_TYPE_MAX_NUM];      /* OSD NETDEV_OSD_FONT_SIZE_E */ 
    UINT32   audwSupportedFontStyleList[NETDEV_OSD_FONT_STYLE_TYPE_MAX_NUM];    /* OSD NETDEV_OSD_FONT_STYLE_E */ 
    BYTE     byRes[512];                                                        /*   Reserved */
}NETDEV_OSD_CAP_S, *LPNETDEV_OSD_CAP_S;

/**
 * @struct tagNETDEVOsdContentStyle
 * @brief OSD Display Style of channel OSD
 * @attention
 */
typedef struct tagNETDEVOsdContentStyle
{
    UINT32 udwFontStyle;                         /*  NETDEV_OSD_FONT_STYLE_E   Font style. For enumeration, seeNETDEV_OSD_FONT_STYLE_E*/
    UINT32 udwFontSize;                          /*  NETDEV_OSD_FONT_SIZE_E   Font Size. For enumeration, seeNETDEV_OSD_FONT_SIZE_E*/
    UINT32 udwColor;                             /*  Color*/
    UINT32 udwDateFormat;                        /*  NETDEV_OSD_DATE_FORMAT_E   Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
    UINT32 udwTimeFormat;                        /*  NETDEV_OSD_TIME_FORMAT_E   Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
    UINT32 audwFontAlignList[NETDEV_LEN_8];      /* 8IPC, NETDEV_OSD_ALIGN_E   Font align in area, 8 areasfixed, IPcamera supported. For enumeration, seeNETDEV_OSD_ALIGN_E */
    UINT32 udwMargin;                            /* IPC NETDEV_OSD_MIN_MARGIN_E   Number of character with margin, IP camera supported. For enumeration, seeNETDEV_OSD_MIN_MARGIN_E */
}NETDEV_OSD_CONTENT_STYLE_S,*LPNETDEV_OSD_CONTENT_STYLE_S;

/**
 * @struct tagNETDEVContentInfo
 * @brief  Content
 * @attention
 */
typedef struct tagNETDEVContentInfo
{
    UINT32 udwContentType;                        /* OSD, NETDEV_OSD_CONTENT_TYPE_E OSD content type. For enumeration, see NETDEV_OSD_CONTENT_TYPE_E*/
    CHAR   szOSDText[NETDEV_OSD_TEXT_MAX_LEN];    /* OSD OSD text*/
}NETDEV_CONTENT_INFO_S,*LPNETDEV_CONTENT_INFO_S;

/**
 * @struct tagNETDEVOSDContentInfo
 * @brief OSD Channel OSD content
 * @attention
 */
typedef struct tagNETDEVOSDContentInfo
{
    BOOL                  bEnabled;                         /* OSD Enable OSD area*/
    UINT32                udwOSDID;                         /* OSD[0,7] Area No., ranges from 0 to 7.*/
    UINT32                udwAreaOSDNum;                    /* OSD Number of OSD in current area*/
    UINT32                udwTopLeftX;                      /* OSD,[0,9999] X-axis of OSD area, ranges from 0 to 999*/
    UINT32                udwTopLeftY;                      /* OSD,[0,9999] Y-axisof OSD area, ranges from 0 to 999*/
    NETDEV_CONTENT_INFO_S astContentInfo[NETDEV_LEN_8];     /* OSD OSD content in current area*/
}NETDEV_OSD_CONTENT_INFO_S,*LPNETDEV_OSD_CONTENT_INFO_S;

/**
 * @struct tagNETDEVOsdContent
 * @brief OSD All contents of channel OSD
 * @attention
 */
typedef struct tagNETDEVOsdContent
{
    UINT32                    udwNum;                          /* OSD Number of OSD area*/
    NETDEV_OSD_CONTENT_INFO_S astContentList[NETDEV_LEN_32];   /* OSD Content list of OSD area*/
}NETDEV_OSD_CONTENT_S,*LPNETDEV_OSD_CONTENT_S;

/************************************************ ********************************************************/

/**
 * @struct tagNETDEVTamperAlarmInfo
 * @brief  Tampering detection analysis info
 * @attention  None
 */
typedef struct tagNETDEVTamperAlarmInfo
{
    INT32  dwSensitivity;                               /*   Sensitivity */
    BYTE   byRes[256];                                  /*   Reserved */
}NETDEV_TAMPER_ALARM_INFO_S, *LPNETDEV_TAMPER_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionAlarmInfo
 * @brief  Motion detection analysis info
 * @attention  None
 */
typedef struct tagNETDEVMotionAlarmInfo
{
    INT32  dwSensitivity;                                                     /*   Sensitivity */
    INT32  dwObjectSize;                                                      /*   Objection Size */
    INT32  dwHistory;                                                         /*   History */
    INT16  awScreenInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];   /*   Screen Info */
    BYTE   byRes[64];                                                         /*   Reserved */
}NETDEV_MOTION_ALARM_INFO_S, *LPNETDEV_MOTION_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaGridInfo
 * @brief  Motion detection area grid info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaGridInfo
{
    BOOL    bEnabled;                                                        
    UINT32  udwSensitivity;                                                  /* [1,100]  Sensitivity */
    INT16   awGridInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];   /*   Grid Info */
    BYTE    byRes[256];                                                      /*   Reserved */
}NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S, *LPNETDEV_MOTION_DETECTION_AREA_GRID_INFO_S;

/**
 * @struct tagNETDEVRectAreaInfo
 * @brief   Rectangle Area info  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRectAreaInfo
{
    UINT32   udwTopLeftX;                       /* x X axis left point value */
    UINT32   udwTopLeftY;                       /* y Y axis top point value */
    UINT32   udwBottomRightX;                   /* x X axis right point value */
    UINT32   udwBottomRightY;                   /* y Y axis bottom point value */
}NETDEV_RECT_AREA_INFO_S, *LPNETDEV_RECT_AREA_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaRectangleInfo
 * @brief  Motion detection area rectangle info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaRectangleInfo
{
    UINT32                    udwID;            
    BOOL                      bEnabled;         
    UINT32                    udwSensitivity;   /* [1,100]  Sensitivity */
    UINT32                    udwDuration;      /* [1,100] */
    UINT32                    udwTargetSize;    /* [1,100] */
    NETDEV_RECT_AREA_INFO_S   stRectAreaInfo;   /* ,[0,9999]  rectangle area Info [0,9999] */
    BYTE                      byRes[128];       /*   Reserved */
}NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S, *LPNETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaRectangleInfoList
 * @brief  Motion detection area rectangle info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaRectangleInfoList
{
    UINT32                                          udwNum;                                 
    NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S   astRectangleAreaInfoList[NETDEV_LEN_8]; 
    BYTE                                            byRes[128];                             /*   Reserved */
}NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S, *LPNETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S;

/**
* @struct tagNETDEVMotionDetectionAreaType
* @brief   motion detection area type
* @attention 
*/
typedef struct tagNETDEVMotionDetectionAreaType
{
    UINT32  udwAreaType;                    /*  # NETDEV_MOTION_DETECTION_AREA_TYPE_E */
    BYTE    byRes[128];                     
}NETDEV_MOTION_DETECTION_AREA_TYPE_S, *LPNETDEV_MOTION_DETECTION_AREA_TYPE_S;

/**
* @struct tagNETDEVCrossLinePointInfo
* @brief  
* @attention 
*/
typedef struct tagNETDEVCrossLinePointInfo
{
    BOOL    bEnable;              /*   Supported or not */
    INT32   dwSensitivity;        /*   Sensitivity */
    INT32   dwDirection;          /*  trigger Direction */
    INT32   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
}NETDEV_CROSS_LINE_POINT_INFO_S, *LPNETDEV_CROSS_LINE_POINT_INFO_S;

/**
 * @struct tagNETDEVCrossLineAlarmInfo
 * @brief 
 * @attention  None
*/
typedef struct tagNETDEVCrossLineAlarmInfo
{
    BOOL                           bEnable;                             /*   Supported or not */
    NETDEV_CROSS_LINE_POINT_INFO_S stAreaInfo[4];                       /*  area info */
    BYTE                           byRes[64];                           /*   Reserved */
}NETDEV_CROSS_LINE_ALARM_INFO_S, *LPNETDEV_CROSS_LINE_ALARM_INFO_S;

/**
 * @struct tagNETDEVIntrusionPointInfo
 * @brief 
 * @attention  None
*/
typedef struct tagNETDEVIntrusionPointInfo
{
    INT32   dwPointX;           /* X [0, 10000]*/
    INT32   dwPointY;           /* Y [0, 10000]*/
}NETDEV_INTRUSION_POINT_INFO_S, *LPNETDEV_INTRUSION_POINT_INFO_S;

/**
 * @struct tagNETDEVIntrusionAreaInfo
 * @brief 
 * @attention  None
*/
typedef struct tagNETDEVIntrusionAreaInfo
{
    BOOL                            bEnable;                    /*   Supported or not */
    INT32                           dwSensitivity;              /* 1-100  Sensitivity */
    INT32                           dwTimeThreshold;            /*  1-10*/
    INT32                           percentage;                 /*  1-100 */
    INT32                           dwPointCount;               /* 3-6*/
    NETDEV_INTRUSION_POINT_INFO_S   stPointInfo[NETDEV_LEN_6];  
    BYTE                            byRes[64];                  /*   Reserved */
}NETDEV_INTRUSION_AREA_INFO_S, *LPNETDEV_INTRUSION_AREA_INFO_S;

/**
 * @struct tagNETDEVIntrusionAlarmInfo
 * @brief 
 * @attention  None
*/
typedef struct tagNETDEVIntrusionAlarmInfo
{
    BOOL    bEnable;                                                  /*   Supported or not */
    NETDEV_INTRUSION_AREA_INFO_S stAreaInfo[NETDEV_LEN_4];            /*  4 area info */
    BYTE   byRes[64];                                                 /*   Reserved */
}NETDEV_INTRUSION_ALARM_INFO_S, *LPNETDEV_INTRUSION_ALARM_INFO_S;

/**
 * @struct tagNETDEVUpnpPortState
 * @brief   Protocol info
 * @attention  None
 */
typedef struct tagNETDEVUpnpPortState
{
    NETDEV_PROTOCOL_TYPE_E   eType;                            /* # NETDEV_PROTOCOL_TYPE_E  Protocol type, see enumeration #NETDEV_PROTOCOL_TYPE_E */
    BOOL                     bEnbale;                          /*   Supported or not */
    INT32                    dwPort;                           /*   Port number */
    BYTE                     byRes[128];                       /*   Reserved */
}NETDEV_UPNP_PORT_STATE_S, *LPNETDEV_UPNP_PORT_STATE_S;

/**
 * @struct tagNETDEVUpnpNatState
 * @brief   Protocol info list
 * @attention  None
 */
typedef struct tagNETDEVUpnpNatState
{
    INT32   dwSize;                                            /*   Number of protocols */
    NETDEV_UPNP_PORT_STATE_S  astUpnpPort[NETDEV_LEN_16];      /*   Protocol info */
}NETDEV_UPNP_NAT_STATE_S, *LPNETDEV_UPNP_NAT_STATE_S;

/**
 * @struct tagNetDEVDiscoveryDevInfo
 * @brief   Info of discovered device
 * @attention  None
 */
typedef struct tagNetDEVDiscoveryDevInfo
{
    CHAR                  szDevAddr[NETDEV_LEN_64];                            /*   Device address */
    CHAR                  szDevModule[NETDEV_LEN_64];                          /*   Device model */
    CHAR                  szDevSerailNum[NETDEV_LEN_64];                       /*   Device serial number */
    CHAR                  szDevMac[NETDEV_LEN_64];                             /* MAC  Device MAC address */
    CHAR                  szDevName[NETDEV_LEN_64];                            /*   Device name */
    CHAR                  szDevVersion[NETDEV_LEN_64];                         /*   Device version */
    NETDEV_DEVICE_TYPE_E  enDevType;                                           /*   Device type */
    INT32                 dwDevPort;                                           /*   Device port number */
    CHAR                  szManuFacturer[NETDEV_LEN_64];                       /*  Device manufacture */
    CHAR                  szActiveCode[NETDEV_LEN_64];                         /*  activeCode */
    CHAR                  szCloudUserName[NETDEV_LEN_64];                      /*  cloudUserName */
    BYTE                  byRes[68];                                           /*   Reserved */
}NETDEV_DISCOVERY_DEVINFO_S, *LPNETDEV_DISCOVERY_DEVINFO_S;

/**
 * @struct tagNETDEVTime
 * @brief   Time parameter Structure definition
 * @attention  None
*/
typedef struct tagNETDEVTime
{
    INT32   dwYear;                       /*   Year */
    INT32   dwMonth;                      /*   Month */
    INT32   dwDay;                        /*   Day */
    INT32   dwHour;                       /*   Hour */
    INT32   dwMinute;                     /*   Minute */
    INT32   dwSecond;                     /*   Second */
}NETDEV_TIME_S, *LPNETDEV_TIME_S;

/**
 * @struct tagNETDEVSystemTimeDST
 * @brief   Time configuration structure definition
 * @attention
*/
typedef struct tagNETDEVSystemTimeDST
{
    INT32 dwMonth;              /* (1~12)  Month(1~12)*/
    INT32 dwWeekInMonth;        /* N1~5  1 for the first week and 5 for the last week in the month */
    INT32 dwDayInWeek;          /*  #NETDEV_DAY_IN_WEEK_E  0 for Sunday and 6 for Saturday see enumeration NETDEV_DAY_IN_WEEK_E */
    INT32 dwHour;               /*   Hour */
}NETDEV_TIME_DST_S, *LPNETDEV_TIME_DST_S;

/**
 * @struct tagNETDEVSystemTimeDSTCfg
 * @brief   Time configuration structure definition
 * @attention
*/
typedef struct tagNETDEVSystemTimeDSTCfg
{
    NETDEV_TIME_DST_S   stBeginTime;        /*  DST begin time */
    NETDEV_TIME_DST_S   stEndTime;          /*  DST end time */
    INT32               dwOffsetTime;       /*  # NETDEV_DST_OFFSET_TIME  DST saving time see enumeration NETDEV_DST_OFFSET_TIME */
}NETDEV_TIME_DST_CFG_S, *LPNETDEV_TIME_DST_CFG_S;

/**
 * @struct tagNETDEVSystemTimeInfo
 * @brief   Time configuration structure definition
 * @attention
*/
typedef struct tagNETDEVSystemTimeInfo
{
    NETDEV_TIME_ZONE_E      dwTimeZone;             /*  # NETDEV_TIME_ZONE_E  Time zone, see enumeration #NETDEV_TIME_ZONE_E */
    NETDEV_TIME_S           stTime;                 /*   Time */
    BOOL                    bEnableDST;             /*  DST enable */
    NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /*  DST time config*/
    UINT32                  udwDateFormat;          /*  0YYYY-MM-DD  1MM-DD-YYYY  2DD-MM-YYYY */
    UINT32                  udwHourFormat;          /*  0 12  1:24 */
    BYTE                    byRes[212];             /*   Reserved */
}NETDEV_TIME_CFG_S, *LPNETDEV_TIME_CFG_S;

/**
 * @struct tagNETDEVSystemTimeCfgV30
 * @brief   Time configuration structure definition
 * @attention
*/
typedef struct tagNETDEVSystemTimeCfgV30
{
    NETDEV_TIME_ZONE_E      dwTimeZone;             /*  # NETDEV_TIME_ZONE_E  Time zone, see enumeration #NETDEV_TIME_ZONE_E */
    INT64                   tUtcTime;               /* UTC */
    UINT32                  udwDateFormat;          /*  0YYYY-MM-DD  1MM-DD-YYYY  2DD-MM-YYYY */
    UINT32                  udwHourFormat;          /*  0 12  1:24 */
    BYTE                    byRes[212];             /*   Reserved */
}NETDEV_TIME_CFG_V30_S, *LPNETDEV_TIME_CFG_V30_S;

/**
 * @struct tagNETDEVDSTCfgInfo
 * @brief   DST configuration structure definition
 * @attention
*/
typedef struct tagNETDEVDSTCfgInfo
{
    BOOL                    bEnableDST;             /*  DST enable */
    NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /*  DST time config*/
    BYTE                    byRes[128];             /*   Reserved */
}NETDEV_DST_CFG_S, *LPNETDEV_DST_CFG_S;

/**
 * @struct tagNETDEVRevTimeout
 * @brief    Timeout structure definition
 * @attention
*/
typedef struct tagNETDEVRevTimeout
{
    INT32   dwRevTimeOut;                 /*  Set timeout for receiving */
    INT32   dwFileReportTimeOut;          /*  Set timeout for file operation */
    BYTE    byRes[128];                   /*   Reserved */
}NETDEV_REV_TIMEOUT_S, *LPNETDEV_REV_TIMEOUT_S;

/**
 * @struct tagNETDEVDiskInfo
 * @brief  Disk info
 * @attention  None
 */
typedef struct tagNETDEVDiskInfo
{
    INT32                     dwDiskCabinetIndex;                
    INT32                     dwSlotIndex;                       /*  Slot Index */
    INT32                     dwTotalCapacity;                   /*  Total Capacity */
    INT32                     dwUsedCapacity;                    /*  Used Capacity */
    NETDEV_DISK_WORK_STATUS_E enStatus;                          /*  Status */
    CHAR                      szManufacturer[NETDEV_LEN_32];     /*  Manufacturer */
}NETDEV_DISK_INFO_S,*LPNETDEV_DISK_INFO_S;

/**
 * @struct tagNETDEVDiskInfoList
 * @brief  Disk info list
 * @attention  None
 */
typedef struct tagNETDEVDiskInfoList
{
    INT32 dwSize;                                             /*  Disk number */
    NETDEV_DISK_INFO_S astDisksInfo[NETDEV_DISK_MAX_NUM];     /*  Disk info */
}NETDEV_DISK_INFO_LIST_S,*LPNETDEV_DISK_INFO_LIST_S;

/**
 * @struct tagNETDEVDefoggingInfo
 * @brief  Defogging info
 * @attention
*/
typedef struct tagNETDEVDefoggingInfo
{
    NETDEV_DEFOGGING_MODE_E  enDefoggingMode;           /*  Defogging mode */
    FLOAT                    fDefoggingLevel;           /*  Defogging level (0.0, 1.0) */
    BYTE                     bRes[64];                  /*  Reserved */
}NETDEV_DEFOGGING_INFO_S, *LPNETDEV_DEFOGGING_INFO_S;

/**
 * @struct tagNETDEVFocusInfo
 * @brief  Focus Info
 * @attention
*/
typedef struct tagNETDEVFocusInfo
{
    NETDEV_FOCUS_MODE_E     enFocusMode;                /*  Defogging mode */
    BYTE                    bRes[16];                   /*  Reserved */
}NETDEV_FOCUS_INFO_S, *LPNETDEV_FOCUS_INFO_S;

/**
 * @struct tagNETDEVIrFilterInfo
 * @brief  IrCut filter info
 * @attention
*/
typedef struct tagNETDEVIrFilterInfo
{
    NETDEV_IR_CUT_FILTER_MODE_E enIrCutFilterMode;      /*  IrCut Filter mode */
    BYTE                        bRes[16];               /*  Reserved */
}NETDEV_IRCUT_FILTER_INFO_S, *LPNETDEV_IRCUT_FILTER_INFO_S;

/**
 * @struct tagNETDEVManualRecordcfg
 * @brief   Manual Record structure definition
 * @attention
*/
typedef struct tagNETDEVManualRecordcfg
{
    INT32                   dwChannelID;        /*   ChannelID */
    NETDEV_RECORD_TYPE_E    enRecordType;       /*  Record type # NETDEV_RECORD_TYPE_E */
    BYTE                    byRes[64];          /*   Reserved */
}NETDEV_MANUAL_RECORD_CFG_S, *LPNETDEV_MANUAL_RECORD_CFG_S;

/**
 * @struct tagNETDEVMonthInfo
 * @brief   get video by Month Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonthInfo
{
    UINT32  udwYear;        /*   year*/
    UINT32  udwMonth;       /*   month */
    UINT32  udwPosition;    /*  NETDEV_VIDEO_POSITION_E video query location */
}NETDEV_MONTH_INFO_S, *LPNETDEV_MONTH_INFO_S;

/**
 * @struct tagNETDEVMonthStatus
 * @brief   video status Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonthStatus
{
    UINT32  udwDayNumInMonth;                       /*  The number of a month's days */
    UINT32  szVideoStatus[NETDEV_MONTH_DAY_MAX];    /*  video status list, see in NETDEV_VIDEO_STATUS_E */
}NETDEV_MONTH_STATUS_S, *LPNETDEV_MONTH_STATUS_S;

/**
 * @struct tagNETDEVChannels
 * @brief   multichannel Structure definition
 * @attention  None
 */
typedef struct tagNETDEVChannels
{
    UINT32  udwSize;                            /*  Channel size */
    INT32   dwChannelIDs[NETDEV_CHANNEL_MAX];   /*  Channel ID list[1,2,3,4] */
}NETDEV_CHANNELS_S, *LPNETDEV_CHANNELS_S;

/**
 * @struct tagNETDEVTrafficStatisticsCond
 * @brief   Command of Passenger flow statistic Structure definition
 * @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsCond
{
    INT32       dwChannelID;            /*  Channel ID */
    INT32       dwStatisticsType;       /*  # NETDEV_TRAFFIC_STATISTICS_TYPE_E Statistics type */
    INT32       dwFormType;             /*  # NETDEV_FORM_TYPE_E Form type */
    INT64       tBeginTime;             /*  Begin time */
    INT64       tEndTime;               /*  End time */
}NETDEV_TRAFFIC_STATISTICS_COND_S, *LPNETDEV_TRAFFIC_STATISTICS_COND_S;

/**
 * @struct tagNETDEVTrafficStatisticsData
 * @brief   Passenger flow statistic Structure definition
 * @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsData
{
    INT32  dwSize;                                          
    INT32  adwEnterCount[NETDEV_PEOPLE_CNT_MAX_NUM];        
    INT32  adwExitCount[NETDEV_PEOPLE_CNT_MAX_NUM];         
}NETDEV_TRAFFIC_STATISTICS_DATA_S, *LPNETDEV_TRAFFIC_STATISTICS_DATA_S;

/**
 * @struct tagNETDEVGeolocationInfo
 * @brief   Geolocation info Structure definition
 * @attention  None
*/
typedef struct tagNETDEVGeolocationInfo 
{
    FLOAT fLongitude;       /*  Longitude */
    FLOAT fLatitude;        /*  Latitude */
}NETDEV_GEOLACATION_INFO_S, *LPNETDEV_GEOLACATION_INFO_S;

/**
 * @struct tagNETDEVWiFiSnifferMacInfo
 * @brief WIFISnifferMac   WIFISnifferMac info Structure definition 
 * @attention  None
*/
typedef struct tagNETDEVWiFiSnifferMacInfo
{
    CHAR  aszMACInfo[NETDEV_WIFISNIFFER_MAC_MAX_NUM];     /* WiFi sniffer mac  WiFi sniffer mac address*/
    INT16 wMaxSig;                                        /* Mac,dBm Mac address corresponding max signal strength (in dBm) */
    CHAR  aszMaxSigTime[NETDEV_MAX_DATE_STRING_LEN];      /* Mac Time to obtain Mac address corresponding max signal strength*/
}NETDEV_WIFISNIFFER_MAC_INFO_S, *LPNETDEV_WIFISNIFFER_MAC_INFO_S;

/**
 * @struct tagNETDEVWiFiSnifferMacList
 * @brief WIFISnifferMac  WIFISnifferMac array Structure definition  
 * @attention  None
*/
typedef struct tagNETDEVWiFiSnifferMacList
{
    INT32                          dwSize;
    NETDEV_WIFISNIFFER_MAC_INFO_S  astMACList[NETDEV_WIFISNIFFER_MAC_ARRY_MAX_NUM];
}NETDEV_WIFISNIFFER_MAC_LIST_S, *LPNETDEV_WIFISNIFFER_MAC_LIST_S;

/**
* @struct tagNETDEVAlarmSnapShotCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVAlarmSnapShotCond
{
    INT32                           dwChannelID;                                /*   Channel number  *100+0*/
    INT64                           tAlarmTime;                                 
    NETDEV_ALARM_SNAPSHOT_TYPE_E    enAlarmType;                                
    BYTE                            byRes[244];                                 /*   Reserved */
}NETDEV_ALARM_SNAPSHOT_COND_S,*LPNETDEV_ALARM_SNAPSHOT_COND_S;

/**
* @struct tagNETDEVAlarmSnapShotPicInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVAlarmSnapShotPicInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];  /* URL */
    CHAR    szName[NETDEV_LEN_64];      
    INT32   dwSize;                     
    BYTE    byRes[256];                 /*   Reserved */
}NETDEV_ALARM_SNAPSHOT_PIC_S,*LPNETDEV_ALARM_SNAPSHOT_PIC_S;

/**
* @struct tagNETDEVSnapShotFileInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVSnapShotFileInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];         /* URL */
    BOOL    bSaveLocal;                        /* TUREFALSE */
    CHAR    szFileName[NETDEV_LEN_260];        
    CHAR*   pcBuffer;                          /* ,dwSize */
    INT32   dwSize;                            
    INT32   dwCaptureMode;                     /* ,#NETDEV_PICTURE_FORMAT_E*/
    BYTE    byRes[252];                        /*   Reserved */
}NETDEV_PIC_FILE_INFO_S, *LPNETDEV_PIC_FILE_INFO_S;


/*                       NVR                                  */


/**
 * @struct tagNETDEVVideoTimeSection
 * @brief   Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoTimeSection
{
    CHAR    szBeginTime[NETDEV_LEN_64];              /*   Begin time */
    CHAR    szEndTime[NETDEV_LEN_64];                /*   End time */
    UINT32  udArmingType;                            /*    ArmingType NETDEV_ARMING_TYPE_E */
}NETDEV_VIDEO_TIME_SECTION_S, *LPNETDEV_VIDEO_TIME_SECTION_S;

/**
 * @struct tagNETDEVVideoDayPlan
 * @brief   Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoDayPlan
{
    UINT32                         udwIndex;                                                  /* ,NETDEV_LAPI_WEEK_INFO_E  day index */
    UINT32                         udwSectionNum;                                             /*   Section Num NVR8,IPC4 */
    NETDEV_VIDEO_TIME_SECTION_S    astTimeSection[NETDEV_MAX_TIME_SECTION_NUM];               /*   Time Sections */
}NETDEV_VIDEO_DAY_PLAN_S, *LPNETDEV_VIDEO_DAY_PLAN_S;

/**
 * @struct tagNETDEVVideoPlanWeek
 * @brief     Plan (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoPlanWeek
{
    BOOL                        bEnabled;                                            /* ,IPC VMS NVR;NETDEV_DEFENCE_PLAN_ENABLE_E */
    UINT32                      udwDayNum;                                           /* ,NVR8();IPC7() */
    NETDEV_VIDEO_DAY_PLAN_S     astDayPlan[NETDEV_MAX_DAY_NUM];                      
    BYTE                        byRes[32];                                           
}NETDEV_VIDEO_WEEK_PLAN_S, *LPNETDEV_VIDEO_WEEK_PLAN_S;

/**
 * @struct tagNETDEVRecordRule
 * @brief      Record Rule Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRecordRule
{
    UINT32                      udwPreRecordTime;                                  /* , NETDEV_PRE_RECORD_TIME_E */
    UINT32                      udwPostRecordTime;                                 /* , NETDEV_POST_RECORD_TIME_E */
    BYTE                        byRes[32];                                         
}NETDEV_RECORD_RULE_S, *LPNETDEV_RECORD_RULE_S;

/**
 * @struct tagstNETDEVTimeTemplate
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTimeTemplate
{
    CHAR    szTamplateName[NETDEV_NAME_MAX_LEN];        
    CHAR    szTamplateDesc[NETDEV_DESCRIBE_MAX_LEN];    
    INT32   dwTamplateID;                               /* ID */
}NETDEV_TIME_TEMPLATE_S, *LPNETDEV_TIME_TEMPLATE_S;

/**
 * @struct tagNETDEVRecordPlanCfgInfo
 * @brief      Record plan config info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRecordPlanCfgInfo
{
    BOOL                       bPlanEnable;                                        
    BOOL                       bRedundantStorage;                                  /*  NVR */
    NETDEV_RECORD_RULE_S       stRecordRule;                                       /*  NVR */
    NETDEV_VIDEO_WEEK_PLAN_S   stWeekPlan;                                         /*  NVR */
    UINT32                     udwChlID;                                           /*  / */
    UINT32                     udwReqSeq;                                          /*  [1, 50] VMS Post */
    UINT32                     udwTamplateID;                                      /* ID VMS */
    CHAR                       szTamplateName[NETDEV_NAME_MAX_LEN];                /*  VMS Get */
    BYTE                       byRes[116];                                         
}NETDEV_RECORD_PLAN_CFG_INFO_S, *LPNETDEV_RECORD_PLAN_CFG_INFO_S;

/**
 * @struct tagNETDEVRecordPlanCfgList
 * @brief      Record plan config info Structure definition list
 * @attention  None
 */
typedef struct tagNETDEVRecordPlanCfgList
{
    UINT32                              udwNum;                             
    LPNETDEV_RECORD_PLAN_CFG_INFO_S     pstRecordScheduleList;              /*  Malloc */
    BYTE                                byRes[256];                         
}NETDEV_RECORD_PLAN_CFG_LIST_S, *LPNETDEV_RECORD_PLAN_CFG_LIST_S;

/**
 * @struct tagNETDEVAlarmInfoEx
 * @brief      Object List
 * @attention  None
 */
typedef struct tagNETDEVObjectList
{
    UINT32                      udwObjectType;                      /*   NETDEV_OBJECT_TYPE_E */
    UINT32                      udwObjectID;                        /* ID */
    BYTE                        byRes[256];                         
}NETDEV_OBJECT_LIST_S, *LPNETDEV_OBJECT_LIST_S;

/**
 * @brief    Alarm infomation Sturcture definition
 * @attention  None
 note:
 1. dwAlarmSrcType NETDEV_ALARM_SRC_LOCAL_HARD_DISK  NETDEV_ALARM_SRC_SD_STORAGE_DISK dwChannelID
 2. dwAlarmSrcType8dwChannelID
 3. dwAlarmSrcType9dwChannelIDdwInputSwitchID
 4. dwAlarmSrcType10,dwChannelID0,
 */
typedef struct tagNETDEVAlarmInfoEx
{ 
    INT32                  dwAlarmType;                        /* ,# NETDEV_ALARM_TYPE_E  Alarm type, see enumeration # NETDEV_ALARM_TYPE_E */
    INT64                  tAlarmTime;                         /*   Alarm time */
    INT32                  dwChannelID;                        
    INT32                  dwAlarmSrcType;                     /*  # NETDEV_ALARM_SRC_TYPE_E */
    CHAR                   szAlarmSrcName[NETDEV_LEN_132];     /* , NETDEV_ALARM_SRC_INVALID  */
    UINT16                 wIndex;                             /*   Index number, index number */
    INT32                  dwTotalBandWidth;                   /* ,MBps  Current total bandwidth (in MBps) */
    INT32                  dwUnusedBandwidth;                  /* ,MBps  Bandwidth left (in MBps)*/
    INT32                  dwTotalStreamNum;                   /*  Total cameras*/
    INT32                  dwFreeStreamNum;                    /*  Cameras left */
    INT32                  dwMediaMode;                        /* ,# NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32                  dwAlarmLevel;                       /* 0: 1: 2: 3: 4:  , */
    INT32                  dwAlarmSeq;                         
    INT32                  dwEventCode;                        /* ,#NETDEV_PLAYER_RUN_INFO_TYPE_E */
    CHAR                   szDeviceID[NETDEV_LEN_64];          /* ID[1,32]IPCVM */
    CHAR                   szRelatedID[NETDEV_LEN_32];         /* ID,15. */
    INT32                  dwObjectNum;                        /*   Object Num */
    LPNETDEV_OBJECT_LIST_S pstObjectList;                      /*  Object List dwObjectNum */
    BYTE                   byRes[140];                         
}NETDEV_ALARM_INFO_EX_S, *LPNETDEV_ALARM_INFO_EX_S;

/**
* @struct tagNETDEVLapiSubInfo
* @brief Lapi
* @attention  None
*/
typedef struct tagNETDEVLapiSubInfo
{
    UINT32 udwType;                          /*   NETDEV_ALARM_TYPE_V30_E */
    UINT32 udwLibIDNum;                      /* ID LibIDNum0xffff  */
    UINT32 audwLibIDList[NETDEV_LEN_32];     /* ID */
    BYTE   byRes[132];                       
}NETDEV_LAPI_SUB_INFO_S,*LPNETDEV_LAPI_SUB_INFO_S;

/**
* @struct tagNETDEVSubscribeSuccInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVSubscribeSuccInfo
{
    UINT32 udwID;                      /* ID */
    UINT32 udwCurrrntTime;             /* UTC1970110 */
    UINT32 udwTerminationTime;         /* UTC1970110 */
    UINT32 udwSupportAlarmType;        /* 0 */
    CHAR   szReference[NETDEV_LEN_260];/*  URL */
    BYTE   byRes[124];                 
}NETDEV_SUBSCRIBE_SUCC_INFO_S,*LPNETDEV_SUBSCRIBE_SUCC_INFO_S;

/**
* @struct tagNETDEVResInfo
* @brief  
* @attention 
*/
typedef struct tagNETDEVResInfo
{
    UINT32   udwResType;                              /* , # NETDEV_EVENT_RES_TYPE_E */
    UINT32   udwResID;                                /* ID */
    BYTE     byRes[256];                              /*   Reserved */
}NETDEV_RES_CHANGE_INFO_S, *LPNETDEV_RES_CHANGE_INFO_S;

/**
* @struct tagNETDEVResChangeEventInfo
* @brief  
* @attention 
*/
typedef struct tagNETDEVResChangeEventInfo
{
    CHAR                       szReference[NETDEV_LEN_260];         /* url
                                                                     <SubscribersID>:IPport*/
    UINT32                     udwAction;                           /* , # NETDEV_RES_CHANGE_SUBEVENT_TYPE_E */
    UINT32                     udwNum;                              
    NETDEV_RES_CHANGE_INFO_S   audwResInfos[NETDEV_CHANNEL_MAX];    
    BYTE                       byRes[256];                          /*   Reserved */
}NETDEV_RES_CHANGE_EVENT_INFO_S, *LPNETDEV_RES_CHANGE_EVENT_INFO_S;

/**
 * @struct tagNETDEVVideoStreamInfo
 * @brief   Channel video stream information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoStreamInfo
{
    NETDEV_LIVE_STREAM_INDEX_E  enStreamType;       /*   Stream index */
    INT32                       bEnableFlag;        /*   Enable or not */
    INT32                       dwHeight;           /* -Height  Video encoding resolution - Height */
    INT32                       dwWidth;            /* -Width  Video encoding resolution - Width */
    INT32                       dwFrameRate;        /*   Video encoding configuration frame rate */
    INT32                       dwBitRate;          /*   Bit rate */
    NETDEV_VIDEO_CODE_TYPE_E    enCodeType;         /*   Video encoding format */
    NETDEV_VIDEO_QUALITY_E      enQuality;          /*   Image quality */
    INT32                       dwGop;              /* I  I-frame interval */
    BOOL                        bConstantBitRate;   /*  0: 1: Constant Bit Rate or Variable bit rate;0:Variable 1:Constant*/
    BYTE                        byRes[28];          /*   Reserved */
}NETDEV_VIDEO_STREAM_INFO_S, *LPNETDEV_VIDEO_STREAM_INFO_S;

/**
 * @struct tagstNETDEVSELogInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVSELogInfo
{
    INT32  dwSELogCount;    
    INT32  dwSELogTime;     
    BYTE   byRes[64];       
}NETDEV_SELOG_INFO_S, *LPNETDEV_SELOG_INFO_S;

/**
 * @struct tagstNETDEVLoginInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDeviceLoginInfo
{    
    CHAR    szIPAddr[NETDEV_LEN_260];       /* IP/ */
    INT32   dwPort;                         
    CHAR    szUserName[NETDEV_LEN_132];     
    CHAR    szPassword[NETDEV_LEN_128];     
    INT32   dwLoginProto;                   /* ,  NETDEV_LOGIN_PROTO_E */
    INT32   dwDeviceType;                   /* ,  NETDEV_DEVICE_TYPE_E */
    BYTE    byRes[256];                     
}NETDEV_DEVICE_LOGIN_INFO_S, *LPNETDEV_DEVICE_LOGIN_INFO_S;

/**
 * @struct tagNETDEVAlarmInfo
 * @brief   Alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInfoV30
{
    INT32                  dwAlarmType;                                  /* # NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT32                  dwAlarmSubType;                               /*  NETDEV_ALARM_SUBTYPE_E */
    INT32                  dwAlarmLevel;                                 /* 151 */
    INT64                  tAlarmTimeStamp;                              /*   Alarm occurrence time */
    INT32                  dwChannelID;                                  /* ID,  Channel ID */
    INT32                  dwAlarmID;                                    /* ID */
    INT32                  dwAlarmSrcID;                                 /* ID # NETDEV_ALARM_SRC_TYPE_E */
    CHAR                   szAlarmSrc[NETDEV_ALARM_SOURCE_MAX_LEN];      
    BOOL                   IsAlarmSnapExisted;                           /*  0 1  vms*/
    UINT16                 wIndex;                                       /*   Index number, index number */
    INT32                  dwTotalBandWidth;                             /* ,MBps  Current total bandwidth (in MBps) */
    INT32                  dwUnusedBandwidth;                            /* ,MBps  Bandwidth left (in MBps)*/
    INT32                  dwTotalStreamNum;                             /*  Total cameras*/
    INT32                  dwFreeStreamNum;                              /*  Cameras left */
    INT32                  dwMediaMode;                                  /* ,# NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32                  dwEventCode;                                  /* # NETDEV_PLAYER_RUN_INFO_TYPE_E */
    INT32                  dwReserved;                                   
    CHAR                   szFileName[NETDEV_LEN_256];                   /* ND */
    CHAR                   szDeviceID[NETDEV_LEN_64];                    /* ID[1,32]IPCVM */
    CHAR                   szRelatedID[NETDEV_LEN_32];                   /* ID,15. */
    INT32                  dwObjectNum;                                  /*   Object Num */
    LPNETDEV_OBJECT_LIST_S pstObjectList;                                /*  Object List dwObjectNum */
    BYTE                   byRes[144];                                   
}NETDEV_ALARM_INFO_V30_S, *LPNETDEV_ALARM_INFO_V30_S;

/**
 * @struct tagNETDEVEventRes
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVEventRes
{
    INT32   dwResType;                          /* # NETDEV_EVENT_RES_TYPE_E */
    INT32   dwResID;                            /* ID */
    INT32   dwFirstSubResID;                    /* ID */
    INT32   dwSecondSubResID;                   /* ID IDIDIDIDIDID*/
    BYTE    byRes[16];                          
}NETDEV_EVENT_RES_S, *LPNETDEV_EVENT_RES_S;

/**
 * @struct tagNETDEVEventInfo
 * @brief   Alarm information Structure definition
 * @attention  NETDEV_MAX_EVENT_RES_SIZEpstEventRes
 */
typedef struct tagNETDEVEventInfo
{
    INT32                   dwSize;                                     
    NETDEV_EVENT_RES_S      astEventRes[NETDEV_MAX_EVENT_RES_SIZE];     
    INT32                   dwEventActionType;                          /* # NETDEV_EVENT_ACTION_TYPE_E */
    LPNETDEV_EVENT_RES_S    pstEventRes;                                /* NETDEV_MAX_EVENT_RES_SIZE */
    BYTE                    byRes[28];                                  
}NETDEV_EVENT_INFO_S, *LPNETDEV_EVENT_INFO_S;

/**
 * @struct tagNETDEVReportInfo
 * @brief /  
 * @attention  None
 */
typedef struct tagNETDEVReportInfo
{
    INT32                       dwReportType;       /* # NETDEV_REPORT_TYPE_E */
    NETDEV_ALARM_INFO_V30_S     stAlarmInfo;        /* dwReportTypeNETDEV_REPORT_TYPE_ALARM */
    NETDEV_EVENT_INFO_S         stEventInfo;        /* dwReportTypeNETDEV_REPORT_TYPE_EVENT */
}NETDEV_REPORT_INFO_S, *LPNETDEV_REPORT_INFO_S;

/**
 * @struct tagstNETDEVUserSimpleInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVUserSimpleInfo
{    
    CHAR szUserName[NETDEV_USERNAME_LEN];       
    CHAR szPassword[NETDEV_PASSWORD_LEN];       
    BYTE byRes[64];                             
}NETDEV_USER_SIMPLE_INFO_S, *LPNETDEV_USER_SIMPLE_INFO_S;

/**
 * @struct tagstNETDEVIPAddrInfo
 * @brief IP
 * @attention
 */
typedef struct tagstNETDEVIPAddrInfo
{
    INT32   dwType;                            /*  NETDEV_ADDR_TYPE_E */
    CHAR    szIPAddr[NETDEV_MAX_URL_LEN];      /* IP/ */
    INT32   dwPort;                            
    BYTE    byRes[60];                         
}NETDEV_IPADDR_INFO_S, *LPNETDEV_IPADDR_INFO_S;

/**
 * @struct tagstNETDEVOnvifInfo
 * @brief Onvif
 * @attention
*/
typedef struct tagstNETDEVOnvifInfo
{   
    UINT32   udwTransportMode;                          /*  NETDEV_TRANS_PROTOCOL_E */
    BYTE     byRes[128];                                /*   Reserved field*/
}NETDEV_ONVIF_INFO_S, *LPNETDEV_ONVIF_INFO_S;

/**
 * @struct tagNETDEVGBInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVGBInfo
{
    CHAR     szUniCode[NETDEV_LEN_32];      /* [1, 32]*/
    UINT32   udwTransport;                  /*  0: TCP 1: UDP*/
    BYTE     byRes[128];                    
}NETDEV_GBINFO_S, *LPNETDEV_GBINFO_S;

/**
 * @struct tagNETDEVSmartLockInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSmartLockInfo
{
    UINT32 udwType;                         /*  0: WIFI 1: NBIoT */
    UINT32 udwSignal;                       /*   NETDEV_LOCK_SIGNAL_E */
    UINT32 udwStatus;                       /*  0  1*/
    UINT32 udwBatteryPercent;               /* [0,100] */
    CHAR   szSN[NETDEV_LEN_64];             /* [0,20] */
    CHAR   szIMEI[NETDEV_LEN_64];           /*  Type1,[1,16] */
    CHAR   szVersion[NETDEV_LEN_256];       /*  [1,64] */
    CHAR   szRoomName[NETDEV_LEN_480];      /*  [1, 128]*/
    BYTE   byRes[128];                      
}NETDEV_SMART_LOCK_INFO_S,*LPNETDEV_SMART_LOCK_INFO_S;

/*
 * @struct tagNETDEVPlayerBasicInfo
 * @brief  
 * @attention  None
*/
typedef struct tagNETDEVIPMPlayerBasicInfo
{
    UINT32                          udwPlayerID;                            /* ID */
    UINT32                          udwVendor;                              
    UINT32                          udwModel;                               
    CHAR                            szPlayerName[NETDEV_LEN_128];           /*  [1,64] */
    UINT32                          udwOrgID;                               /* ID  */
    CHAR                            szOrgName[NETDEV_LEN_128];              /*  [1,64]  */
    CHAR                            szPlayerMngtServerName[NETDEV_LEN_128]; /*  [1, 64]  */
    CHAR                            szPlayerMngtServerIP[NETDEV_LEN_32];    /* IP  */
    NETDEV_XW_RESOLUTION_S          stResolution;                           
    BYTE                            byRes[256];                             
}NETDEV_IPM_PLAYER_BASIC_INFO_S,*LPNETDEV_IPM_PLAYER_BASIC_INFO_S;

/**
 * @struct tagstNETDEVDeviceBasicInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDeviceBasicInfo
{
    NETDEV_IPADDR_INFO_S stDevAddr;                         /* IP */
    NETDEV_USER_SIMPLE_INFO_S stDevUserInfo;                
    CHAR szDevName[NETDEV_NAME_MAX_LEN];                    
    CHAR szDevDesc[NETDEV_DESCRIBE_MAX_LEN];                
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];               
    INT32 dwDevID;                                          /* ID */
    INT32 dwDevStatus;                                      /* , # NETDEV_DEVICE_STATUS_E */
    INT32 dwDevType;                                        /* # NETDEV_DEVICE_MAIN_TYPE_E */
    INT32 dwDevSubType;                                     /* # NETDEV_DEVICE_SUB_TYPE_E */
    INT32 dwOrgID;                                          
    INT32 dwAccessProtocol;                                 /*  # NETDEV_ACCESS_PROTOCOL_E */
    INT32 dwAccessMode;                                     /*  # NETDEV_DEVICE_ACCESS_MODE_E*/
    INT32 dwServerID;                                       /* ID */
    INT32 dwAudioResID;                                     /* ID */
    INT32 dwIsPTZNeeded ;                                   /*  0:   1:   255:  */
    CHAR  szVIIDCode[NETDEV_VIID_CODE_LEN];                 /* , */
    INT32 dwVIIDStatus;                                     /* 0 1 */
    CHAR szSerialNum[NETDEV_LEN_64];                        
    CHAR szSoftVersion[NETDEV_LEN_128];                     
    CHAR szMacAddr[NETDEV_LEN_32];                          /* MAC*/
    INT32 dwStoreStatus;                                    /* 0:  1:  2: 3: */
    NETDEV_ONVIF_INFO_S stOnvifInfo;                        /* onvif */
    NETDEV_GBINFO_S stGBInfo;                               /*  AccessProtocol3*/
    LPNETDEV_SMART_LOCK_INFO_S pstSmartLockInfo;            
    CHAR szManufacture[NETDEV_LEN_64];                      
    CHAR szDeviceCode[NETDEV_LEN_32];                       /*  [1,32]   */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;        /*  Type11 malloc */
    UINT32  udwCustomProtocolID;                            /* IDAccessProtocol4 */
    UINT32  udwChlMaxNum;                                   /* AccessProtocol4 */
    UINT32  udwChlIndexNum;                                 /* AccessProtocol4256 */
    UINT32* pudwChlIndexList;                               /* 256 */
    INT32 dwImageProtocol;                                  /* Type5 1: 2: */
}NETDEV_DEV_BASIC_INFO_S, *LPNETDEV_DEV_BASIC_INFO_S;

/**
 * @struct tagstNETDEVDeviceFirmwareInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDeviceFirmwareInfo
{    
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];       
    CHAR szFireVersion[NETDEV_CODE_STR_MAX_LEN];    
    CHAR szSerialNum[NETDEV_CODE_STR_MAX_LEN];      
    BYTE byRes[128];                                
}NETDEV_DEV_FIREWARE_INFO_S, *LPNETDEV_DEV_FIREWARE_INFO_S;

/**
 * @struct tagstNETDEVDeviceDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDeviceDetailInfo
{    
    NETDEV_DEV_BASIC_INFO_S    stDevBasicInfo;          
    NETDEV_DEV_FIREWARE_INFO_S stDevFirewareInfo;       
}NETDEV_DEV_INFO_V30_S, *LPNETDEV_DEV_INFO_V30_S;

/**
 * @struct tagstNETDEVEncodeChnProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVEncodeChnProperty
{
    INT32   dwMaxStream;        
    BOOL    bSupportPTZ;        
    INT32   dwAudioResID;       /* ID */
    BYTE    byRes[64];          
}NETDEV_ENCODE_CHN_PROPERTY_S, *LPNETDEV_ENCODE_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVDecodeChnProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDecodeChnProperty
{
    INT32 dwVideoFmtCapSize;                                    
    INT32 adwVideoFormatCap[NETDEV_VIDEO_FORMAT_CAP_NUM];       
    INT32 dwLayoutCapSize;                                      
    INT32 adwLayoutCap[NETDEV_LAYOUT_CAP_NUM];                  
    BYTE  byRes[64];                                            
}NETDEV_DECODE_CHN_PROPERTY_S, *LPNETDEV_DECODE_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVAlarmOutChnProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmOutChnProperty
{
    INT32 dwRunMode;        /* /# NETDEV_BOOLEAN_MODE_E */
    INT32 dwDuration;       /* (ms) */
    BYTE byRes[64];         
}NETDEV_ALARMOUT_CHN_PROPERTY_S, *LPNETDEV_ALARMOUT_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVAlarmInChnProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmInChnProperty
{
    INT32 dwRunMode;        /* /# NETDEV_BOOLEAN_MODE_E */
    BOOL  bEnable;          /* / */
    BYTE byRes[64];         
}NETDEV_ALARMIN_CHN_PROPERTY_S, *LPNETDEV_ALARMIN_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVDAProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDAProperty
{
    CHAR   szPointCode[NETDEV_DA_POINT_CODE_LEN];         
    CHAR   szAreaCode[NETDEV_DA_AREA_CODE_LEN];           
    UINT32 udwPointStatus;                                /* # NETDEV_ALARM_POINT_STATUS_TYPE_E  #NETDEV_DOOR_STATUS_TYPE_E */
    BYTE   byRes[64];                                     
}NETDEV_DA_CHN_PROPERTY_S, *LPNETDEV_DA_CHN_PROPERTY_S;

/**
* @struct tagNETDEVTrafficStatisticsInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsInfo
{
    BOOL    bIsSuccess;                                    
    INT32   dwChannelID;                                   
    UINT32  udwSize;                                       
    UINT32  audwEnterCount[NETDEV_PEOPLE_CNT_MAX_NUM];     
    UINT32  audwExitCount[NETDEV_PEOPLE_CNT_MAX_NUM];      
    BYTE    byRes[6];                                      
}NETDEV_TRAFFIC_STATISTICS_INFO_S, *LPNETDEV_TRAFFIC_STATISTICS_INFO_S;

/**
 * @struct tagstNETDEVOrgChnInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVOrgChnInfo
{
    INT32 dwOrgID;                              /* ID */
    INT32 dwChannelID;                          /* ID */
    CHAR szChnName[NETDEV_NAME_MAX_LEN];        
    INT32 dwChnIndex;                           
    INT32 dwChnType;                            
    INT32 dwChnStatus;                          
    INT32 dwDevID;                              /* ID */
    CHAR szDevName[NETDEV_NAME_MAX_LEN];        
    BYTE  byRes[128];                           
}NETDEV_ORG_CHN_INFO_S, *LPNETDEV_ORG_CHN_INFO_S;

/**
 * @struct tagstNETDEVOrgDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVOrgDetailInfo
{    
    INT32  dwOrgID;                               /* ID */
    INT32  dwParentID;                            /* ID */
    INT32  dwType;                                /*   NETDEV_ORG_TYPE_E */
    CHAR   szNodeName[NETDEV_NAME_MAX_LEN];       
    CHAR   szDesc[NETDEV_DESCRIBE_MAX_LEN];       
    UINT32 udwTime;                               /* UTC */
    CHAR   szUserName[NETDEV_LEN_64];             /*  [1,64] */
    BYTE   byRes[60];                             
}NETDEV_ORG_INFO_S, *LPNETDEV_ORG_INFO_S;

/**
* @struct tagNETDEVMemSize
* @brief 
* @attention 
*/
typedef struct tagNETDEVMemSize
{
    UINT32 udwDecodePayload;        /*  NETDEV_MEM_PAYLOAD_E */
    UINT32 udwResolution;           /*  NETDEV_MEM_RESOLUTION_E  */
    UINT32 udwMemSize;              
}NETDEV_MEM_SIZE_S, *LPNETDEV_MEM_SIZE_S;

/**
* @struct tagMallocInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVMemTable
{
    UINT32            udwSize;                                          
    NETDEV_MEM_SIZE_S szVirtualMem[NETDEV_VIRTUAL_MEM_TABLE_MAX];       
}NETDEV_MEM_TABLE_S, *LPNETDEV_MEM_TABLE_S;

/**
 * @struct tagNETDEVTMSStrutPicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSStrutPicInfo
{
    UINT32  udwPicSize;         
    CHAR    *pcPicData;         
    BYTE    bRes[256];          /*  Reserved */
}NETDEV_TMS_STRUT_PIC_INFO_S,*LPNETDEV_TMS_STRUT_PIC_INFO_S;

/**
 * @struct tagstNETDEVStructCommonInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVStructCommonInfo
{
    CHAR szPlaceCode[NETDEV_LEN_32];            
    CHAR szPlaceName[NETDEV_LEN_128];           
    CHAR szLaneDirection[NETDEV_LEN_32];        
    CHAR szDirection[NETDEV_LEN_32];            
    CHAR szDirectionName[NETDEV_LEN_32];        
    CHAR szDevID[NETDEV_LEN_32];                
    CHAR szLaneID[NETDEV_LEN_32];               
    CHAR szLaneType[NETDEV_LEN_32];             
    CHAR szLaneDescription[NETDEV_LEN_128];     
    BYTE bRes[128];                             /*  Reserved */
}NETDEV_STRUCT_COMMON_INFO_S,*LPNETDEV_STRUCT_COMMON_INFO_S;

/**
 * @struct tagstNETDEVStructVeh
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVStructVehInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];           
    CHAR szDisAppearTime[NETDEV_LEN_32];        
    CHAR szRedLightStartTime[NETDEV_LEN_32];    
    CHAR szRedLightEndTime[NETDEV_LEN_32];      
    CHAR szRedLightTime[NETDEV_LEN_32];         
    CHAR szIdentifyTime[NETDEV_LEN_32];         
    CHAR szCorrectTime[NETDEV_LEN_32];          
    CHAR szLimitedSpeed[NETDEV_LEN_32];         
    CHAR szMarkedSpeed[NETDEV_LEN_32];          
    CHAR szVehicleSpeed[NETDEV_LEN_32];         
    CHAR szVehicleType[NETDEV_LEN_32];          
    CHAR szLogoAreaPosition[NETDEV_LEN_32];     
    CHAR szVehicleColor[NETDEV_LEN_32];         
    CHAR szDriSunVisStat[NETDEV_LEN_32];        
    CHAR szCodriSunVisStat[NETDEV_LEN_32];      
    CHAR szDriSeatBeltStat[NETDEV_LEN_32];      
    CHAR szCodriSeatBeltStat[NETDEV_LEN_32];    
    CHAR szDriMobileStat[NETDEV_LEN_32];        
    CHAR szYlwPlateMarkStat[NETDEV_LEN_32];     
    CHAR szPendantStatus[NETDEV_LEN_32];        
    CHAR szAimStatus[NETDEV_LEN_32];            
    CHAR szDangerGoodsMarkStat[NETDEV_LEN_32];  
    CHAR szLaneQueueLength[NETDEV_LEN_32];      
    BYTE bRes[128];                             /*  Reserved */
}NETDEV_STRUCT_VEH_INFO_S,*LPNETDEV_STRUCT_VEH_INFO_S;

/**
 * @struct tagstNETDEVStructNonVeh
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVStructNonVehInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];       
    CHAR szDisAppearTime[NETDEV_LEN_32];    
    CHAR szDirectionType[NETDEV_LEN_32];    
    CHAR szSpeed[NETDEV_LEN_32];            
    BYTE bRes[128];                         /*  Reserved */
}NETDEV_STRUCT_NON_VEH_INFO_S,*LPNETDEV_STRUCT_NON_VEH_INFO_S;

/**
 * @struct tagstNETDEVStructPerson
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVStructPersonInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];           
    CHAR szDisAppearTime[NETDEV_LEN_32];        
    CHAR szMovingDirection[NETDEV_LEN_32];      
    BYTE bRes[128];                             /*  Reserved */
}NETDEV_STRUCT_PERSON_INFO_S,*LPNETDEV_STRUCT_PERSON_INFO_S;

/**
 * @struct tagstNETDEVStructFace
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVStructFaceInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];       
    CHAR szDisAppearTime[NETDEV_LEN_32];    
    BYTE bRes[128];                         /*  Reserved */
}NETDEV_STRUCT_FACE_INFO_S,*LPNETDEV_STRUCT_FACE_INFO_S;

/**
 * @struct tagstNETDEVStructInfo
 * @brief XML
 * @attention
 */
typedef struct tagstNETDEVStructInfo
{
    NETDEV_STRUCT_COMMON_INFO_S    stCommonInfo;                      
    UINT32                         udwVehicleNum;                     
    LPNETDEV_STRUCT_VEH_INFO_S     pstVehInfo;                        
    UINT32                         udwNonVehicleNum;                  
    LPNETDEV_STRUCT_NON_VEH_INFO_S pstNonVehInfo;                     
    UINT32                         udwPersonNum;                      
    LPNETDEV_STRUCT_PERSON_INFO_S  pstPersonInfo;                     
    UINT32                         udwFaceNum;                        
    LPNETDEV_STRUCT_FACE_INFO_S    pstFaceInfo;                       
    CHAR                           szIPAddr[NETDEV_IPV4_LEN_MAX];     /* IP */
    BYTE                           bRes[112];                         /*  Reserved */
}NETDEV_STRUCT_INFO_S,*LPNETDEV_STRUCT_INFO_S;

/**
 * @struct tagNETDEVTMSStrutInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVTMSStrutInfo
{
    UINT32                             udwPicNum;                                   /*  Picture Number */
    NETDEV_STRUCT_INFO_S               stTmsXmlInfo;                                /* XML XML Information */
    NETDEV_TMS_STRUT_PIC_INFO_S        stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];     /*  Picture Message */
}NETDEV_TMS_STRUT_INFO_S,*LPNETDEV_TMS_STRUT_INFO_S;

/**
 * @struct tagNETDEVTMSInterface 
 * @brief TMS
 * @attention
 */
typedef struct tagNETDEVTMSInterface
{
    NETDEV_TMS_CONNECT_INFO_S    stTmsConnectInfo;                 /* Socket */
    NETDEV_TMS_FACE_PARSE_INFO_S stTmsFaceParseInfo;               
    NETDEV_TMS_HEAT_MAP_INFO_S   stTmsHeatMapInfo;                 
    NETDEV_TMS_CAR_PLATE_INFO_S  stTmsCarPlateInfo;                
    NETDEV_TMS_STRUT_INFO_S      stTmsStrutInfo;                   
    CHAR                         szIPAddr[NETDEV_IPV4_LEN_MAX];    /* IP */
    BYTE                         bRes[240];                        /*  Reserved */
}NETDEV_TMS_INTERFACE_S, *LPNETDEV_TMS_INTERFACE_S;

/**
* @struct tagNETDEVBaseFindCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVBaseFindCond
{
    INT32   dwChannelID;    /*   Channel number */
    INT64   tBeginTime;     /*   Start time */
    INT64   tEndTime;       /*   End time */
    INT32   dwStreamType;   /*  # NETDEV_STREAM_TYPE_E */
    BYTE    byRes[32];      /*   Reserved */
}NETDEV_BASE_FIND_COND_S, *LPNETDEV_BASE_FIND_COND_S;

/**
* @struct tagNETDEVEventFindCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVEventFindCond
{
    INT32                   dwFindLogic;                                        /*  # NETDEV_EVENT_FIND_LOGIC_E */
    INT32                   dwEventFileTypeSize;                                
    INT32                   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];      /* ,# NETDEV_EVENT_STORE_TYPE_E */
    NETDEV_BASE_FIND_COND_S stBaseCond;                                         
    INT32                   dwStreamType;                                       /*  # NETDEV_STREAM_TYPE_E */
    BYTE                    byRes[128];                                         /*   Reserved */
}NETDEV_EVENT_FIND_COND_S, *LPNETDEV_EVENT_FIND_COND_S;

/**
* @struct tagNETDEVSmartFindCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVSmartFindCond
{
    INT32                   dwSensitivity;                                                      /* ,1-8 */
    NETDEV_BASE_FIND_COND_S stBaseCond;                                                         
    UCHAR                   awSmartBlock[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];    /* ,1,0  */
    BYTE                    byRes[124];                                                         /*   Reserved */
}NETDEV_SMART_FIND_COND_S, *LPNETDEV_SMART_FIND_COND_S;

/**
* @struct tagNETDEVSmartEventFindCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVSmartEventFindCond
{
    INT32                   dwColumn;                                                           
    INT32                   dwRow;                                                              
    INT32                   dwSensitivity;                                                      
    UCHAR                   awSmartBlock[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];    /* ,1,0 */
    INT32                   dwFindLogic;                                                        /*  # NETDEV_EVENT_FIND_LOGIC_E */
    INT32                   dwEventFileTypeSize;                                                
    INT32                   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];                      /* ,# NETDEV_EVENT_STORE_TYPE_E */
    NETDEV_BASE_FIND_COND_S stBaseCond;                                                         
    BYTE                    byRes[128];                                                         /*   Reserved */
}NETDEV_SMART_EVENT_FIND_COND_S, *LPNETDEV_SMART_EVENT_FIND_COND_S;

/**
 * @struct tagNETDEVEventFindData
 * @brief   
 *         
 * @attention  None
 */
typedef struct tagNETDEVEventFindData
{
    INT32   dwEventFileTypeSize;                                
    INT32   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];      /* ,# NETDEV_EVENT_STORE_TYPE_E */
    INT64   tBeginTime;                                         /*   Start time */
    INT64   tEndTime;                                           /*   End time */
    CHAR    szFileName[NETDEV_LEN_64];                          
    UINT32  udwFileSize;                                        
    BYTE    byRes[124];                                         /*   Reserved */
}NETDEV_EVENT_FIND_DATA_S,*LPNETDEV_EVENT_FIND_DATA_S;

/**
* @struct tagNETDEVQueryPageInfo
* @brief  
* @attention
* , 0, # NETDEV_PAGE_QUERY_ROW_MAX_NUM
*/
typedef struct tagNETDEVQueryPageInfo
{
    INT32   dwPageRowNum;           
    INT32   dwPageCnt;              
}NETDEV_QUERY_PAGE_INFO_S;

/**
* @struct tagNETDEVQueryPageInfo
* @brief  
* @attention 
*/
typedef struct tagNETDEVRspPageInfo
{
    INT32   dwRowNum;           
    INT32   dwTotalRowNum;      
}NETDEV_RSP_PAGE_INFO_S;

/**
* @struct tagNETDEVPortMappingInfo
* @brief  
* @attention
* ,0
*/
typedef struct tagNETDEVPortMappingInfo
{
    INT32   dwHttpLocal;                /* HTTP */
    INT32   dwHttpNat;                  /* HTTP */
    INT32   dwSdkLocal;                 /* SDK */
    INT32   dwSdkNat;                   /* SDK */
    INT32   dwMediaLocal;               /* Media */
    INT32   dwMediaNat;                 /* Media */
    INT32   dwRTSPLocal;                /* RTSP */
    INT32   dwRTSPNat;                  /* RTSP */
    INT32   dwRes[8];                   
}NETDEV_PORT_MAPPING_INFO_S, *LPNETDEV_PORT_MAPPING_INFO_S;

/**
* @struct tagNETDEVStreamInfo
* @brief ID 
* @attention
* ID,0
*/
typedef struct tagNETDEVStreamInfo
{
    INT32   dwChannelID;                    
    INT32   dwSize;                         
    BYTE    byID[NETDEV_STREAM_ID_LEN];     /* ID */
    BYTE    byRes[NETDEV_LEN_32];           
}NETDEV_STREAM_INFO_S,*LPNETDEV_STREAM_INFO_S;

/**
* @struct tagNETDEVParseVideoData
* @brief  
*        
* @attention 
*/
typedef struct tagNETDEVSourceDataExInfo
{
    BYTE szDecoderTag[NETDEV_CODE_STR_MAX_LEN];         
    BYTE szReserved[64];                                
}NETDEV_SOURCE_DATA_EX_INFO_S;

/**
* @struct tagNETDEVSdkAblity
* @brief SDK 
* @attention
* 0.
*/
typedef struct tagNETDEVSdkAblity
{
    INT32   dwMaxLoginNum;              
    INT32   dwMaxRealPlayNum;           
    INT32   dwMaxPlayBackNum;           
    INT32   dwMaxAlarmChanNum;          
    INT32   dwMaxFormatNum;             
    INT32   dwMaxFileSearchNum;         
    INT32   dwMaxLogSearchNum;          
    INT32   dwMaxSerialNum;             
    INT32   dwMaxUpgradeNum;            
    INT32   dwMaxVoiceComNum;           
    INT32   dwMaxBroadCastNum;          
    INT32   dwRes[10];                  
}NETDEV_SDKABILITY_S,*LPNETDEV_SDKABILITY_S;

/**
* @struct tagNETDEVSdkState
* @brief SDK 
* @attention
* 0.
*/
typedef struct tagNETDEVSdkState
{
    INT32   dwTotalLoginNum;                
    INT32   dwTotalRealPlayNum;             
    INT32   dwTotalPlayBackNum;             
    INT32   dwTotalAlarmChanNum;            
    INT32   dwTotalFormatNum;               
    INT32   dwTotalFileSearchNum;           
    INT32   dwTotalLogSearchNum;            
    INT32   dwTotalSerialNum;               
    INT32   dwTotalUpgradeNum;              
    INT32   dwTotalVoiceComNum;             
    INT32   dwTotalBroadCastNum;            
    INT32   dwRes[10];                      
}NETDEV_SDKSTATE_S,*LPNETDEV_SDKSTATE_S;

/**
* @struct tagPrivacyMaskPara
* @brief  Privacy mask capabilities
* @attention
*/
typedef struct tagPrivacyMaskAbility
{
    INT32 dwSupportCnt;                    /*  Number of supported privacy mask areas */
}NETDEV_PRIVACY_MASK_ABILITY_S, *LPNETDEV_PRIVACY_MASK_ABILITY_S;

/**
* @struct tagNETDEVOsdAbilityInfo
* @brief OSD
* @attention
*/
typedef struct tagNETDEVOsdAbilityInfo
{
    INT32   bIsSupportTimeOSD;          
    INT32   bIsSupportNameOSD;          
    UINT32  u32OSDMaxNum;               /* OSD */
    UINT32  u32NameMLen;                
    UINT32  u32TimeOSDFormat;           /* OSD  NETDEV_OSD_TIME_FORMAT_CAP_E */
    UINT32  u32DateOSDFormat;           /* OSD  NETDEV_OSD_DATE_FORMAT_CAP_E */
    BYTE    byRes[32];                  
}NETDEV_VIDEO_OSD_ABILITY_S, *LPNETDEV_VIDEO_OSD_ABILITY_S;

/**
* @struct tagNETDEVVideoOutChlprofiles
* @brief VideoOut
* @attention None
*/
typedef struct tagNETDEVVideoOutChlprofiles
{
    INT32   dwDefaultPane;                              
    INT32   dwSupportedMaxPane;                         
    INT32   adwSupportedPane[NETDEV_LEN_32];            /* ,# NETDEV_PANE_NUM_E */
    INT32   dwDefaultVideoFormat;                       
    INT32   dwSupportedPaneNum;                         
    INT32   adwSupportedVideoFormat[NETDEV_LEN_32];     /* ,# NETDEV_VIDEO_FORMAT_E */
}NETDEV_VIDEOOUT_CHL_PROFILES_S, *LPNETDEV_VIDEOOUT_CHL_PROFILES_S;

/**
* @struct tagNETDEVVideoOutALLprofiles
* @brief VideoOut
* @attention None
*/
typedef struct tagNETDEVVideoOutALLprofiles
{
    INT32                            dwChlNum;          
    LPNETDEV_VIDEOOUT_CHL_PROFILES_S pstDCProfiles;     
}NETDEV_VIDEOOUT_ALL_PROFILES_S, *LPNETDEV_VIDEOOUT_ALL_PROFILES_S;

/**
* @struct tagNETDEVPriviewTVWallInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPriviewTVWallInfo
{
    UINT16  dwChannelID;                /* ID  Channel ID */
    UINT16  dwPaneIndex;                /* (1) */
    INT32   dwStreamType;               /* ,# NETDEV_STREAM_TYPE_E */
    CHAR    szUrl[NETDEV_LEN_260];      /* Url */
    INT32   dwTransProto;               /* ,# NETDEV_TRANSPORT_PROTOCOL_E */
    BYTE    byRes[256];                 /*   Reserved */
}NETDEV_PREVIEW_TVWALLINFO_S, *LPNETDEV_PREVIEW_TVWALLINFO_S;

/**
 * @struct tagNETDEVReceiverInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVReceiverInfo
{
    UINT16 dwPaneIndex;             /* receiver(1) */
    INT32 dwReceiverMode;           /* receiver */
    INT32 dwStreamType;             
    INT32 dwTransportProtocol;      
    CHAR  szUrl[NETDEV_LEN_260];    /* url */
    BYTE  byRes[64];                
}NETDEV_RECEIVER_INFO_S, *LPNETDEV_RECEIVER_INFO_S;

/**
 * @struct tagNETDEVReceiverInfoList
 * @brief ID
 * @attention 
 */
typedef struct tagNETDEVReceiverInfoList
{
    INT32                   dwSize;                                         
    NETDEV_RECEIVER_INFO_S  astReceiverInfoList[NETDEV_MAX_PANE_NUM];       
}NETDEV_RECEIVER_INFO_LIST_S, *LPNETDEV_RECEIVER_INFO_LIST_S;

/**
 * @struct tagNETDEVDevLoginParamInfo
 * @brief   Device information Structure definition
 * @attention  None   
 */
typedef struct tagNETDEVDevLoginParamInfo
{
    NETDEV_NETWORK_MODE_E   eNetWorkMode;   /* ,# NETDEV_NETWORK_MODE_E */
    BYTE                    byRes[48];      /*   Reserved */
}NETDEV_DEV_LOGIN_PARAM_INFO_S,*LPNETDEV_DEV_LOGIN_PARAM_INFO_S;

/**
 * @struct tagNETDEVChlOsdCfg
 * @brief OSD
 * @attention
 */
typedef struct tagNETDEVChlOsdCfg
{
    INT32                  dwOsdID;                                /* OSD ID */
    NETDEV_OSD_TEXT_TYPE_E enOsdTextType;                          /* OSD */
    NETDEV_AREA_SCOPE_S    stAreaScope;                            /* OSD */
    CHAR                   szTextInfo[NETDEV_OSD_TEXT_MAX_LEN];    /* OSD */
}NETDEV_CHL_OSD_CFG_S, *LPNETDEV_CHL_OSD_CFG_S;

/**
 * @struct tagNETDEVChlOsdCfgList
 * @brief OSD
 * @attention
 */
typedef struct tagNETDEVChlOsdCfgList
{
    INT32                dwSize;                                /* OSD */
    NETDEV_CHL_OSD_CFG_S stChlOsdCfg[NETDEV_OSD_MAX_NUM_EX];    /* OSD */
}NETDEV_CHL_OSD_CFG_LIST_S, *LPNETDEV_CHL_OSD_CFG_LIST_S;

/**
 * @struct tagNETDEVNetworkInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNetworkInfo
{
    CHAR    szIPAddress[NETDEV_LEN_32];         /* IP  */
    INT32   dwHttpPort;                         /* Http */
    INT32   dwRtspPort;                         /* Rtsp */
}NETDEV_NETWORKINFO_S, *LPNETDEV_NETWORKINFO_S;

 /**
 * @struct tagNETDEVNetworkPortsInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNetworkPortsInfo
{
    UINT32   udwHttpPort;                         /* Http */
    UINT32   udwHttpsPort;                        /* Https */
    UINT32   udwRtspPort;                         /* Rtsp */
    BYTE     byRes[64];                           /*   Reserved field */
}NETDEV_NETWORK_PORTS_INFO_S, *LPNETDEV_NETWORK_PORTS_INFO_S;

/**
 * @struct tagstNETDEVBandWith
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVBandWith
{
    UINT32 udwTotal;                
    UINT32 udwLive;                 
    UINT32 udwReplayAndDown;        /*/*/
    UINT32 udwResidual;             
}NETDEV_NETWORK_BANDWIDTH_S, *LPNETDEV_NETWORK_BANDWIDTH_S;

/**
* @struct tagsNETDEVStreamNum
* @brief 
* @attention
*/
typedef struct tagNETDEVStreamNum
{
    INT32   dwCurrent;              /* , */
    INT32   dwTotal;                
}NETDEV_STREAM_NUM_S, *LPNETDEV_STREAM_NUM_S;

/**
 * @struct tagstNETDEVBandWithInfo
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVBandWithInfo
{
    NETDEV_NETWORK_BANDWIDTH_S stInputBandWidth;               
    NETDEV_NETWORK_BANDWIDTH_S stOutputBandWidth;              
    NETDEV_STREAM_NUM_S        stStreamNum;                    
}NETDEV_NETWORK_BANDWIDTH_INFO_S, *LPNETDEV_NETWORK_BANDWIDTH_INFO_S;

/**
 * @struct tagstNETDEVOperateInfo
 * @brief 
 * @attention dwIDdwReturnCode
 */
typedef struct tagNETDEVOperateInfo
{
    INT32   dwID;                   /* ID */
    INT32   dwReturnCode;           
    BYTE    byRes[64];              
}NETDEV_OPERATE_INFO_S, *LPNETDEV_OPERATE_INFO_S;

/**
 * @struct tagstNETDEVOperateList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVOperateList
{
    INT32                     dwSize;                
    LPNETDEV_OPERATE_INFO_S   pstOperateInfo;        
}NETDEV_OPERATE_LIST_S, *LPNETDEV_OPERATE_LIST_S;

/**
* @struct tagNETDEVMultiTrafficStatisticsCond
* @brief  
* @attention  None
*/
typedef struct tagNETDEVMultiTrafficStatisticsCond
{
    NETDEV_OPERATE_LIST_S   stChannelIDs;               /* ID */
    UINT32                  udwStatisticsType;          /*  NETDEV_TRAFFIC_STATISTICS_TYPE_E */
    UINT32                  udwFormType;                /*  NETDEV_TRAFFIC_STATIC_FORM_TYPE_E */
    INT64                   tBeginTime;                 
    INT64                   tEndTime;                   
    BYTE                    byRes[256];                 
}NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S, *LPNETDEV_MULTI_TRAFFIC_STATISTICS_COND_S;

/**
* @struct tagNETDEVFaceDetectionCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVFaceDetectionCapInfo 
{
    BOOL bIsSupport;                                                    /* Smart */
    BOOL bQualityAnalysisIsSupport;                                     
    INT32 dwFaceQualityAnalysisType;                                    /* ,  NETDEV_FACE_ANALYSIS_SKILL_E */
    BOOL bAttributeAnalysisIsSupport;                                   
    INT32 adwAttributeAnalysisSkills[NETDEV_FACE_ANALYSIS_SKILL_NUM];   /*  0 */
    BOOL bFeatureIsSupport;                                             
    BOOL bRecognitionIsSupport;                                         
    INT32 dwFaceRecognitionType;                                        /*, NETDEV_FACE_RECOGNITION_TYPE_E */
    BOOL bPersonSnapshotSupport;                                        /*  0:  1:  */
    BYTE byRes[256];                                                    
}NETDEV_FACE_DETEC_CAP_S, *LPNETDEV_FACE_DETEC_CAP_S;

/**
* @struct tagNETDEVIntrusionDetectionCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVIntrusionDetectionCapInfo 
{
    BOOL  bIsSupport;                        
    INT32  dwPecentMin;                      /* (Percentages),  */
    INT32  dwPecentMax;                      /* (Percentages),  */
    INT32  dwTimeThresholdMin;               /* (TimeThreshold),  */
    INT32  dwTimeThresholdMax;               /* (TimeThreshold),  */
    UINT32 udwSmartMode;                     /*  0 1 */
    BYTE   bRes[28];                         
}NETDEV_INTRUSION_DETEC_CAP_S, *LPNETDEV_INTRUSION_DETEC_CAP_S;

/**
* @struct tagNETDEVCrossLineDetectionCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVCrossLineDetectionCapInfo
{
    BOOL   bIsSupport;                
    UINT32 udwSmartMode;              /*  0 1 */
    BYTE   bRes[28];                  
}NETDEV_CROSS_LINE_DETEC_CAP_S, *LPNETDEV_CROSS_LINE_DETEC_CAP_S;

/**
* @struct tagNETDEVPassengerFlowCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVPassengerFlowCapInfo
{
    BOOL bIsSupport;                
    BYTE bRes[32];                  
}NETDEV_PASSENGER_FLOW_CAP_S, *LPNETDEV_PASSENGER_FLOW_CAP_S;

/**
* @struct tagNETDEVAudioDetectionCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVAudioDetectionCapInfo
{
    BOOL   bIsSupport;  
    INT32 dwDiffMin;    /* /,  */
    INT32 dwDiffMax;    /* /,   */
}NETDEV_AUDIO_DETEC_CAP_S, *LPNETDEV_AUDIO_DETEC_CAP_S;

/**
* @struct tagNETDEVObjTrackCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVObjTrackCapInfo
{
    BOOL  bIsSupport;                               
    INT32 adwMode[NETDEV_OBJ_TRACK_MODE_NUM];       /* , NETDEV_OBJ_TRACK_MODE_E  */
    INT32 dwTrackTimeMin;                           /* s NETDEV_OBJ_TRACK_MODE_FULLVIEW  */
    INT32 dwTrackTimeMax;                           /* s NETDEV_OBJ_TRACK_MODE_FULLVIEW  */
}NETDEV_OBJ_TRACK_CAP_S, *LPNETDEV_OBJ_TRACK_CAP_S;

/**
* @struct tagNETDEVMixDetectionCapInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVMixDetectionCapInfo
{
    BOOL bIsSupported;                               /*  0:  1:  */
    BYTE bRes[128];                                  
}NETDEV_MIX_DETECTION_INFO_S,*LPNETDEV_MIX_DETECTION_INFO_S;

/**
* @struct tagNETDEVMasterSlaveLinkCapInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVMasterSlaveLinkCapInfo
{
    UINT32 udwSupportMode;                          /*   NETDEV_MASTER_SLAVE_LINKAGE_E */
    BYTE   bRes[32];                                
}NETDEV_MASTER_SLAVE_LINK_CAP_S,*LPNETDEV_MASTER_SLAVE_LINK_CAP_S;

/**
* @struct tagNETDEVObjAttrOverlayCapInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVObjAttrOverlayCap
{
    BOOL bSupportAttrOverlay;                       /* FALSE:TRUE: */
    BYTE bRes[32];                                  
}NETDEV_OBJ_ATTR_OVERLAY_CAP_S,*LPNETDEV_OBJ_ATTR_OVERLAY_CAP_S;


/**
* @struct tagNETDEVAccessZoneCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVAccessZoneCapInfo
{
    BOOL    bIsSupport;             /*  0 1 */
    UINT32  udwSmartMode;           /*  0 1 */
    BYTE    bRes[16];               
}NETDEV_ACCESS_ZONE_CAP_S, *LPNETDEV_ACCESS_ZONE_CAP_S;

/**
* @struct tagNETDEVLeaveZoneCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVLeaveZoneCapInfo
{
    BOOL    bIsSupport;             /*  0 1 */
    UINT32  udwSmartMode;           /*  0 1 */
    BYTE    bRes[16];              
}NETDEV_LEAVE_ZONE_CAP_S, *LPNETDEV_LEAVE_ZONE_CAP_S;

/**
* @struct tagNETDEVAreaPeopleCountCap
* @brief 
* @attention  None
*/
typedef struct tagNETDEVAreaPeopleCountCap
{
    BOOL   bSupportAreaPeopleCount;                 /* FALSE:TRUE: */
    UINT32 udwMaxAreaNum;                           
    BYTE   bRes[32];                                
}NETDEV_AREA_PEOPLE_COUNT_CAP_S,*LPNETDEV_AREA_PEOPLE_COUNT_CAP_S;

/**
* @struct tagNETDEVLinePeopleCountCap
* @brief 
* @attention  None
*/
typedef struct tagNETDEVLinePeopleCountCap
{
    BOOL   bSupportLinePeopleCount;                 /* FALSE:TRUE: */
    UINT32 udwMaxLineNum;                           
    BYTE   bRes[32];                                
}NETDEV_LINE_PEOPLE_COUNT_CAP_S,*LPNETDEV_LINE_PEOPLE_COUNT_CAP_S;

/**
* @struct tagNETDEVCrowdDensityCap
* @brief 
* @attention  None
*/
typedef struct tagNETDEVCrowdDensityCap
{
    BOOL   bSupportCrowdDensity;            /* FALSE: TRUE: */
    BYTE   bRes[32];                        
}NETDEV_CROWD_DENSITY_CAP_S,*LPNETDEV_CROWD_DENSITY_CAP_S;

/**
* @struct tagNETDEVAccessElevatorCapInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVAccessElevatorCapInfo
{
    BOOL    bIsSupport;             /*  0 1 */
    BYTE    bRes[16];               
}NETDEV_ACCESS_ELEVATOR_CAP_S, *LPNETDEV_ACCESS_ELEVATOR_CAP_S;

/**
* @struct tagNETDEVSmartCapInfo
* @brief smart 
* @attention  None
*/
typedef struct tagNETDEVSmartCapInfo
{
    NETDEV_FACE_DETEC_CAP_S         stFaceDetecCap;                 
    NETDEV_INTRUSION_DETEC_CAP_S    stIntrusionDetecCap;            
    NETDEV_CROSS_LINE_DETEC_CAP_S   stCrossLineDetecCap;            
    NETDEV_PASSENGER_FLOW_CAP_S     stPassengerFlowCap;             
    NETDEV_AUDIO_DETEC_CAP_S        stAudioDetecCap;                
    NETDEV_OBJ_TRACK_CAP_S          stObjTrackCap;                  
    NETDEV_MIX_DETECTION_INFO_S     stMixDetectionCap;              
    NETDEV_MASTER_SLAVE_LINK_CAP_S  stMasterSlaveCap;               
    NETDEV_OBJ_ATTR_OVERLAY_CAP_S   stObjAttrOverlayCap;            
    NETDEV_ACCESS_ZONE_CAP_S        stAccessZoneCap;                
    NETDEV_LEAVE_ZONE_CAP_S         stLeaveZoneCap;                 
    NETDEV_LINE_PEOPLE_COUNT_CAP_S  stLinePeopleCountCap;           
    NETDEV_AREA_PEOPLE_COUNT_CAP_S  stAreaPeopleCountCap;           
    NETDEV_CROWD_DENSITY_CAP_S      stCrowdDensityCap;              
    NETDEV_ACCESS_ELEVATOR_CAP_S    stAccessElevatorCap;            
    BYTE                            byRes[292];                     
}NETDEV_SMART_CAP_S, *LPNETDEV_SMART_CAP_S;

/**
* @struct tagNETDEVTrafficStatisticsReportTime
* @brief 
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsReportTime
{
    UINT32  udwReportTimeInterval;      
    BOOL    bEnable;                    
}NETDEV_TRAFFIC_STATISTICS_REPORT_TIME_S, *LPNETDEV_TRAFFIC_STATISTICS_REPORT_TIME_S;

/**
 * @struct tagNETDEVChlDeviceInfo
 * @brief   Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVChlDeviceInfo
{
    INT32 dwChannelID;                                   
    CHAR  szDevModel[NETDEV_LEN_64];                     /*   Device model */
    CHAR  szSerialNum[NETDEV_LEN_64];                    /*   Hardware serial number */
    CHAR  szFirmwareVersion[NETDEV_LEN_64];              /*   Software version */
    CHAR  szHardewareID[NETDEV_LEN_64];                  
    CHAR  szUbootVersion[NETDEV_LEN_64];                 /* UBOOT */
    BYTE  byRes[512];                                    /*   Reserved */
}NETDEV_DEVICE_CHL_INFO_S, *LPNETDEV_DEVICE_CHL_INFO_S;

/**
 * @struct tagNETDEVNewVersionDateInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVNewVersionDateInfo
{
    UINT32 udwYear;         /*   Year */
    UINT32 udwMonth;        /*   Month */
    UINT32 udwDay;          /*   Day */
    UINT32 udwHour;         /*   Hour */
    UINT32 udwMinute;       /*   Minute */
    BYTE   byRes[64];       
}NETDEV_NEW_VERSION_DATE_INFO_S, *LPNETDEV_NEW_VERSION_DATE_INFO_S;

/**
 * @struct tagNETDEVUpgradeInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVUpgradeInfo
{
    BOOL                            bHasNewVersion;                             /*  0: 1:*/
    CHAR                            szNewFirmwareVersion[NETDEV_LEN_64];        /*  bHasNewVersion0*/
    UINT32                          udwID;                                      /* ID0*/
    NETDEV_NEW_VERSION_DATE_INFO_S  stNewVersionDateInfo;                       /* HasNewVersion0NVR#NETDEV_NEW_VERSION_DATE_INFO_S*/
    CHAR                            szVersionDescription[NETDEV_LEN_1024];      
    BYTE                            byRes[256];                                 
}NETDEV_UPGRADE_INFO_S, *LPNETDEV_UPGRADE_INFO_S;

/**
 * @struct tagNETDEVUpgradeDevice
 * @brief   Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVUpgradeDevice
{
    INT32 dwUpgradeType;                    /*  #NETDEV_UPGRADE_TYPE_E */
    INT32 dwSize;                           /*  ,0NVR */
    INT32 adwChannelID[NETDEV_CHANNEL_MAX]; 
    CHAR  szPath[NETDEV_PATH_LEN];          
    BYTE  byRes[256];                       /*   Reserved */
}NETDEV_UPGRADE_DEVICE_S, *LPNETDEV_UPGRADE_DEVICE_S;

/**
 * @struct tagNETDEVUpgradeStatus
 * @brief   Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVUpgradeStatus
{
    INT32 dwStatus;             /* ,# NETDEV_UPGRADE_STATUS_E */
    INT32 dwPercent;            
    INT32 dwChannelID;          
    BYTE  byRes[256];           
}NETDEV_UPGRADE_STATUS_S, *LPNETDEV_UPGRADE_STATUS_S;

/**
 * @struct tagNETDEVChannelsBasicInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVChannelsBasicInfo
{
    UINT32                      udwAddType;                                     /* ,  NETDEV_ADDCHN_ADD_TYPE_E */
    UINT32                      udwAddressType;                                 /* IP, .udwAddType23, 2. NETDEV_HOSTTYPE_E */
    CHAR                        szAddress[NETDEV_IPADDR_STR_MAX_LEN];           /* IP, [0,64]*/
    CHAR                        szDDNSAdress[NETDEV_DOMAIN_LEN];                /* DDNS, [0,64], udwAddType2, . */
    UINT32                      udwPort;                                        /* ,[1, 65535]udwAddType03, */ 
    CHAR                        szLoginName[NETDEV_NAME_MAX_LEN];               /* , [0,20]*/
    CHAR                        szPIN[NETDEV_LEN_256];                          /* , , , ; , , */
    UINT32                      udwAccessProtocol;                              /* ,  1-ONVIF, 2-, 3-, [100-131]- */
    UINT16                      udwNum;                                         /* , [0, 16] */
    UINT32                      audwRemoteIndexList[NETDEV_CHANNEL_MAX];        /* , Num0 */
    UINT32                      udwRemoteIndex;                                  
    NETDEV_GBINFO_S             stGBInfo;                                       /*  udwAccessProtocol3, */
    UINT32                      udwIsPTZNeeded;                                 /* : 0-, 1-, 2- */
    BOOL                        bLongHaulEnabled;                               /* 0: ; 1: ; udwAddType1, ()*/
    BYTE                        byRes[256];                                     
}NETDEV_CHANNEL_BASIC_INFO_S, *LPNETDEV_CHANNEL_BASIC_INFO_S;

/**
 * @struct tagNETDEVChannelsInfos
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVChannelsInfos
{
    UINT32   udwNum;                                    /* , 0*/
    UINT32   audwChannelList[NETDEV_CHANNEL_MAX];       
    BYTE     byRes[128];                                
}NETDEV_CHANNEL_LIST_S, *LPNETDEV_CHANNEL_LIST_S;

/**
 * @struct tagNETDEVAudioDecodeStatus
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioDecodeStatus
{
    INT32 dwStreamID;       
    BOOL  bDecodeAudio;     
}NETDEV_AUDIO_DECODE_STATUS_S, *LPNETDEV_AUDIO_DECODE_STATUS_S;

/**
 * @struct tagNETDEVAudioDecodeStatusList
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioDecodeStatusList
{
    INT32                        dwSize;                                    
    NETDEV_AUDIO_DECODE_STATUS_S astAudioDecStatus[NETDEV_STREAM_MAX_NUM];  
}NETDEV_AUDIO_DECODE_STATUS_LIST_S, *LPNETDEV_AUDIO_DECODE_STATUS_LIST_S;

/**
* @struct tagNETDEVAudioInputEncodeFormatInfo
* @brief 
* attention None
*/
typedef struct tagNETDEVAudioInputEncodeFormatInfo
{
    UINT32 udwType;                                                         /* # NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
    UINT32 udwSamplingRateNum;                                              
    UINT32 audwSamplingRateList[NETDEV_AUDIO_SAMPLING_RATE_MAX_NUM];        /*  # NETDEV_AUDIO_SAMPLING_RATE_E */
    BYTE   byRes[128];                                                      
}NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S, *LPNETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S;

/**
* @struct tagNETDEVAudioInputModeInfo
* @brief 
* attention None
*/
typedef struct tagNETDEVAudioInputModeInfo
{
    INT32  dwChannelID;                                         
    UINT32 udwModeNum;                                          
    UINT32 audwModeList[NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM];      /*  # NETDEV_AUDIO_CHL_MODE_E */
    BYTE   byRes[128];                                          
}NETDEV_AUDIO_IN_MODE_INFO_S, *LPNETDEV_AUDIO_IN_MODE_INFO_S;

/**
 * @struct tagNETDEVAudioCapInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioCapInfo
{
    INT32                                   dwAudioInNum;                                                   
    NETDEV_AUDIO_IN_MODE_INFO_S             astAudioInModeList[NETDEV_AUDIO_IN_MAX_NUM];                    
    INT32                                   dwAudioInEncFmtNum;                                             
    NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S    astAudioInEncFmtList[NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM];    
    INT32                                   dwSerialInNum;                                                  
    NETDEV_AUDIO_IN_MODE_INFO_S             astSerialInModeList[NETDEV_SERIAL_IN_MAX_NUM];                  
    INT32                                   dwSerialInEncFmtNum;                                            
    NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S    astSerialInEncFmtList[NETDEV_SERIAL_IN_ENCODE_FORMAT_MAX_NUM];  
    INT32                                   dwAudioOutTypeNum;                                              
    INT32                                   audwAudioOutTypeList[NETDEV_LEN_4];                             /*   NETDEV_AUDIO_CHL_MODE_E */
    BOOL                                    bSupportAudioOutGain;                                           /*  0 1 */
    BYTE                                    byRes[232];                                                     
}NETDEV_AUDIO_CAP_S, *LPNETDEV_AUDIO_CAP_S;

/**
* @struct tagNETDEVAudioInputInfo
* @brief 
* attention None
*/
typedef struct tagNETDEVAudioInputInfo
{
    INT32  dwChannelID;     
    UINT32 udwEnabled;      
    UINT32 udwMode;         /*  # NETDEV_AUDIO_CHL_MODE_E */
    BYTE   byRes[128];      
}NETDEV_AUDIO_INPUT_INFO_S, *LPNETDEV_AUDIO_INPUT_INFO_S;

/**
 * @struct tagNETDEVAudioInputCfgInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioInputCfgInfo
{
    BOOL bIsMute;                                                                   /*  01  */
    UINT32 udwType;                                                                 /*  # NETDEV_AUDIO_COLLECTION_PORT_TYPE_E */
    UINT32 udwEncodeFormat;                                                         /*  # NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
    UINT32 udwSampleRate;                                                           /*  # NETDEV_AUDIO_SAMPLING_RATE_E */
    UINT32 udwInputGain;                                                            /* [0,255] */
    BOOL bNoiseReductionEnabled;                                                    /*  01 */
    INT32 dwAudioInNum;                                                             
    NETDEV_AUDIO_INPUT_INFO_S astAudioInputInfoList[NETDEV_AUDIO_IN_MAX_NUM];       /*  NETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_IN  */
    INT32 dwSerialInNum;                                                            
    NETDEV_AUDIO_INPUT_INFO_S astSerialInputInfoList[NETDEV_SERIAL_IN_MAX_NUM];     
    BYTE  byRes[256];                                                               
}NETDEV_AUDIO_INPUT_CFG_INFO_S, *LPNETDEV_AUDIO_INPUT_CFG_INFO_S;

/**
 * @struct tagNETDEVTimeSection
 * @brief   Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTimeSection
{
    CHAR    szBeginTime[NETDEV_LEN_64];              /*   Begin time */
    CHAR    szEndTime[NETDEV_LEN_64];                /*   End time */
}NETDEV_TIME_SECTION_S, *LPNETDEV_TIME_SECTION_S;

/**
 * @struct tagNETDEVDayPlan
 * @brief   Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDayPlan
{
    UINT32                       udwIndex;                                                  /*   day index */
    UINT32                       udwSectionNum;                                             /*   Section Num */
    NETDEV_TIME_SECTION_S        astTimeSection[NETDEV_PLAN_TIME_SECTION_NUM_ADAY];         /*   Time Sections */
}NETDEV_DAY_PLAN_S, *LPNETDEV_DAY_PLAN_S;

/**
 * @struct tagNETDEVPlanWeek
 * @brief   Play (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlanWeek
{
    UINT32              udwDayNum;                                  /*   day num*/
    NETDEV_DAY_PLAN_S   astDayPlan[NETDEV_PLAN_DAY_NUM_AWEEK];      /*   days */
}NETDEV_WEEK_PLAN_S, *LPNETDEV_WEEK_PLAN_S;

/**
 * @struct tagNETDEVPointS
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPointS
{
    INT32 dwPointX;     /* , */
    INT32 dwPointY;     /* , */
}NETDEV_POINT_S, *LPNETDEV_POINT_S;

/**
 * @struct tagNETDEVCustomFileInfo
 * @brief   Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCustomFileInfo
{
    CHAR  szCustomFilePath[NETDEV_PATH_LEN];              
    CHAR  szMd5Data[NETDEV_LEN_64];                       /* Md5 */
    BYTE  byRes[256];                                     /*   Reserved */
}NETDEV_CUSTOM_FILE_INFO_S, *LPNETDEV_CUSTOM_FILE_INFO_S;

/**
 * @struct tagNETDEVNetworkDiagnosis
 * @brief  Network Diagnosis
 * @attention  None
 */  
typedef struct tagNETDEVNetworkDiagnosis
{
    UINT32    dwPacketSize;             /* (:byte) */
    UINT32    dwPacketNum;              
    UINT32    dwDuration;               /* (:s) */
    CHAR      szUrl[NETDEV_LEN_260];    /* URL */
} NETDEV_NETWORK_DIAGNOSIS_S, *LPNETDEV_NETWORK_DIAGNOSIS_S;

/**
* @struct tagNETDEVAlarmFindConds
* @brief  
* @attention 
*/
typedef struct tagNETDEVAlarmFindConds
{
    INT32   dwChannelID;      /* ID */
    INT64   tBeginTime;       
    INT64   tEndTime;         
    BYTE    byRes[128];       /*   Reserved */
}NETDEV_FIND_ALARM_COND_S, *LPNETDEV_FIND_ALARM_COND_S;

/**
* @struct tagNETDEVFindAlarmInfo
* @brief  
* @attention 
*/
typedef struct tagNETDEVFindAlarmInfo
{
    INT64    tAlarmTime;        
    INT32    dwAlarmType;       /* , # NETDEV_FIND_ALARM_TYPE_E */
    BYTE     byRes[256];        /*   Reserved */
}NETDEV_FIND_ALARM_INFO_S, *LPNETDEV_FIND_ALARM_INFO_S;

/**
 * @struct tagNETDEVSDKInfo
 * @brief SDK
 * @attention  None
 */
typedef struct tagNETDEVSDKInfo
{
    CHAR szSDKType[NETDEV_LEN_64];                   /* SDK */
    CHAR szSDKVersion[NETDEV_LEN_64];                /* SDK */
}NETDEV_SDK_INFO_S, *LPNETDEV_SDK_INFO_S;

/**
 * @struct tagNETDEVSplitScreenInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSplitScreenInfo
{
    INT32 dwOperatedMode;           /* , NETDEV_OPERATED_MODE_E */
    INT32 dwSplitScreenIndex;       
}NETDEV_SPLIT_SCREEN_INFO_S, *LPNETDEV_SPLIT_SCREEN_INFO_S;

/**
 * @struct tagNETDEVAlarmDeviceInfo
 * @brief   Alarm device information Structure definition
 * @attention   
 1.,dwChannelID0,
 2. NETDEV_ALARM_SRC_TYPE_E  NETDEV_ALARM_LISTEN_INFO_S dwAlarmSrcID
 */
typedef struct tagNETDEVAlarmDeviceInfo
{
    CHAR    pszIP[16];      /* IP device IP */
    INT32   dwChannelID;    
    BYTE    byRes[128];     /*   Reserved */
}NETDEV_ALARM_DEVICE_INFO_S, *LPNETDEV_ALARM_DEVICE_INFO_S;

/**
 * @struct tagNETDEVAlarmListenInfo
 * @brief   Alarm device information Structure definition
 * @attention  
 ID 
 1. AlarmSrcType0-7AlarmSrcID
 2. AlarmSrcType8AlarmSrcID
 3. AlarmSrcType9AlarmSrcID
 4.AlarmSrcType10,AlarmSrcID0, 
 */
typedef struct tagNETDEVAlarmListenInfo
{
    INT32   dwAlarmType;                /* # NETDEV_ALARM_TYPE_E */
    INT32   dwAlarmSrcType;             /* # NETDEV_ALARM_SRC_TYPE_E */
    INT64   tAlarmTime;                 /*   Alarm time */
    INT32   dwAlarmSrcID;               /* ID */
    CHAR    szAlarmSrcName[128];        /* VMS*/
    INT32   dwAlarmSeq;                 /* IPC & VMS*/
    BYTE    byRes[128];                 /*   Reserved */
}NETDEV_ALARM_LISTEN_INFO_S,*LPNETDEV_ALARM_LISTEN_INFO_S;

/**
 * @struct tagNETDEVDiagnosisInfoURL
 * @brief URL
 * @attention
 */
typedef struct tagNETDEVDiagnosisInfoURL
{
    CHAR   szURL[NETDEV_LEN_256];      /* URL */
}NETDEV_DIAGNOSIS_INFO_URL_S, *LPNETDEV_DIAGNOSIS_INFO_URL_S;

/**
 * @struct tagNETDEVDiagnosisInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVDiagnosisInfo
{
    INT32    dwTime;                          
    CHAR     szFileName[NETDEV_LEN_64];       
    INT32    dwSize;                          
}NETDEV_DIAGNOSIS_INFO_S, *LPNETDEV_DIAGNOSIS_INFO_S;

/**
 * @struct tagNETDEVDownDiagnosisFileInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVDownDiagnosisFileInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];         /* URL */
    BOOL    bSaveLocal;                        /* TUREFALSE*/
    CHAR    szFileName[NETDEV_LEN_260];        
    CHAR*   pcBuffer;                          /* ,dwSize*/
    INT32   dwSize;                            
    BYTE    byRes[256];                        /*  Reserved */
}NETDEV_DIAGNOSIS_FILE_INFO_S, *LPNETDEV_DIAGNOSIS_FILE_INFO_S;

/**
* @struct tagNETDEVFaceGalleyInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVFaceGalleyInfo
{
    CHAR    szGalleyID[NETDEV_FACE_FEATURE_GALLEY_ID_LEN];          /* ID */
    UINT32  udwGalleyType;                                          /*   NETDEV_FACE_DB_TYPE_E */
    UINT32  udwFeatureDataLen;                                      
    CHAR    szFeatureVersion[NETDEV_FACE_FEATURE_VERSION_LEN];      /*  char[40]*/
    CHAR    szFeatureFileMD5[NETDEV_FACE_FEATURE_FILE_MD5_LEN];     /* MD5 128*/
    BYTE    byRes[128];                                             /*   Reserved */
}NETDEV_FACE_GALLEY_INFO_S, *LPNETDEV_FACE_GALLEY_INFO_S;

/**
* @struct tagNETDEVFaceDBImportNumInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVFaceDBImportNumInfo
{
    UINT32  udwMaxNum;      
    UINT32  udwImportSum;   
    UINT32  udwFaceDBNum;   
    BYTE    byRes[128];     /*   Reserved */
}NETDEV_FACE_DB_IMPORT_NUM_INFO_S, *LPNETDEV_FACE_DB_IMPORT_NUM_INFO_S;

/**
* @struct tagNETDEVFaceDBMemberImportInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVFaceDBMemberImportInfo
{
    UINT32  udwFaceDBID;            /* ID*/
    UINT32  udwFaceDBMemberNum;     
    BYTE    byRes[128];             /*   Reserved */
}NETDEV_FACEDB_MEMBER_IMPORT_INFO_S, *LPNETDEV_FACEDB_MEMBER_IMPORT_INFO_S;

/**
 * @struct tagNETDEVModifyPasswordInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVModifyPasswordInfo
{
    CHAR szUserName[NETDEV_LEN_260];    
    CHAR szNewPIN[NETDEV_LEN_256];      
    CHAR szCurrentPIN[NETDEV_LEN_256];  
    BYTE byRes[128];                    
}NETDEV_MODIFY_PASSWORD_INFO_S,*LPNETDEV_MODIFY_PASSWORD_INFO_S;

/**
 * @struct tagNETDEVDevManageInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVDevManageInfo
{
    CHAR    szSerailNum[NETDEV_LEN_64];     
    CHAR    szActiveCode[NETDEV_LEN_64];    
}NETDEV_DEV_MANAGE_INFO_S, *LPNETDEV_DEV_MANAGE_INFO_S;

/**
 * @struct tagNETDEVEnvParamInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVEnvParamInfo
{
    UINT32    udwType;                            
    UINT32    udwMin;                             
    UINT32    udwMax;                             
    BYTE      byRes[256];                         /*   Reserved */
}NETDEV_ENV_PARAM_INFO_S, *LPNETDEV_ENV_PARAM_INFO_S;

/**
 * @struct tagNETDEVTriggerDetailInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVTriggerDetailInfo
{
    CHAR                       szBegin[NETDEV_LEN_16];                         
    CHAR                       szEnd[NETDEV_LEN_16];                           
    UINT32                     udwEnvironmentNum;                              
    NETDEV_ENV_PARAM_INFO_S    astEnvironmentInfo[NETDEV_MAX_ENV_PARAM_NUM];   
    BYTE                       byRes[256];                                     /*   Reserved */
}NETDEV_TRIGGER_DETAIL_INFO_S, *LPNETDEV_TRIGGER_DETAIL_INFO_S;

/**
 * @struct tagNETDEVSceneInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSceneInfo
{
    CHAR                          szName[NETDEV_LEN_128];                             
    BOOL                          bAutoSwitchEnable;                                  /*  0 1 */
    UINT32                        udwID;                                              
    UINT32                        udwType;                                            
    UINT32                        udwPriority;                                        /* [1, SceneTemplateNum] */
    UINT32                        udwTriggerNum;                                      
    NETDEV_TRIGGER_DETAIL_INFO_S  astTriggerInfo[NETDEV_MAX_TRIGGER_DETAIL_INFO_NUM]; 
    BYTE                          byRes[256];                                         /*   Reserved */
}NETDEV_SCENE_INFO_S, *LPNETDEV_SCENE_INFO_S;

/**
 * @struct tagNETDEVSceneInfoList
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSceneInfoList
{
    UINT32               udwNum;                                      
    NETDEV_SCENE_INFO_S  astSceneInfo[NETDEV_MAX_SCENE_INFO_NUM];     
    BYTE                 byRes[256];                                  /*   Reserved */
}NETDEV_SCENE_INFO_LIST_S, *LPNETDEV_SCENE_INFO_LIST_S;

/**
 * @struct tagNETDEVSceneAutoSwitchInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSceneAutoSwitchInfo
{
    BOOL                 bAutoSwitchEnable;        /*  0 1 */
    BYTE                 byRes[256];               /*   Reserved */
}NETDEV_SCENE_AUTO_SWITCH_INFO_S, *LPNETDEV_SCENE_AUTO_SWITCH_INFO_S;

/**
 * @struct tagNETDEVSceneTemplateInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSceneTemplateInfo
{
    UINT32                 udwID;            /* 0 */
    BYTE                   byRes[256];       /*   Reserved */
}NETDEV_SCENE_TEMPLATE_INFO_S, *LPNETDEV_SCENE_TEMPLATE_INFO_S;

/**
 * @struct tagNETDEVImagingEnhance
 * @brief      Device image settings Structure definition
 * @attention udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce 0-255    
              udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce parameter range: 0-255
 */
typedef struct tagNETDEVImagingEnhance
{
    UINT32 udwBrightness;                 /*   Brightness */
    UINT32 udwContrast;                   /*   Contrast */
    UINT32 udwSaturation;                 /*   Saturation */
    UINT32 udwSharpness;                  /*   Sharpness */
    UINT32 udwImageRotation;              
    UINT32 udw2DNoiseReduce;              /* 2D */
    UINT32 udw3DNoiseReduce;              /* 3D */
    BYTE   byRes[252];                    /*   Reserved */
}NETDEV_IMAGE_ENHANCE_S, *LPNETDEV_IMAGE_ENHANCE_S;

/**
 * @struct tagNETDEVEnhanceCapabilitiesInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVEnhanceCapabilitiesInfo
{
    UINT32 udwImageRotationModeNum;                                          
    UINT32 udwImageRotationModeList[NETDEV_IMAGE_ROTATION_MODE_MAX_NUM];     /* ,# NETDEV_IMAGE_ROTATION_MODE_E */
    BOOL   bSupportSharpness;                                                /* 0,1,*/
    BOOL   bSupport2DNoiseReduce;                                            /* 2D0,1, */
    BOOL   bSupport3DNoiseReduce;                                            /* 3D0,1, */
    BYTE   byRes[512];                                                       /*   Reserved */
}NETDEV_IMAGE_ENHANCE_CAP_INFO_S, *LPNETDEV_IMAGE_ENHANCE_CAP_INFO_S;

/**
 * @struct tagNETDEVFocusCapabilitiesInfo
 * @brief  IPC 
 * @attention
 */
typedef struct tagNETDEVFocusCapabilitiesInfo 
{
    BOOL   bSupportFocusCfg;                                                 /* 0,1,*/
    UINT32 udwFocusModeNum;                                                  
    UINT32 udwFocusModeList[NETDEV_FOCUS_MODE_MAX_NUM];                      /* ,# NETDEV_FOCUS_MODEL_E */
    UINT32 udwFocusSceneNum;                                                 
    UINT32 udwFocusSceneList[NETDEV_FOCUS_SCENE_MAX_NUM];                    /* ,# NETDEV_FOCUS_SCENE_E */
    BYTE   byRes[512];                                                       /*   Reserved */
}NETDEV_FOCUS_CAP_INFO_S, *LPNETDEV_FOCUS_CAP_INFO_S;

/**
 * @struct tagNETDEVWhiteBalanceCapabilitiesInfo
 * @brief  IPC 
 * @attention
 */
typedef struct tagNETDEVWhiteBalanceCapabilitiesInfo 
{
    UINT32 udwWhiteBalanceModeNum;                                            
    UINT32 audwWhiteBalanceModeList[NETDEV_WHITE_BALANCE_MODE_MAX_NUM];       /* ,# NETDEV_WHITE_BALANCE_MODE_E */
    BYTE   byRes[512];                                                        /*   Reserved */
}NETDEV_WHITE_BALANCE_CAP_INFO_S, *LPNETDEV_WHITE_BALANCE_CAP_INFO_S;

/**
 * @struct tagNETDEVLampInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVLampInfo
{
    UINT32 udwLampType;                                             /*   NETDEV_LAMP_TYPE_E */
    UINT32 udwLampCtrlModeListNum;                                  /* */
    UINT32 audwLampCtrlModeList[NETDEV_LAMP_CTRL_MODE_MAX_NUM];     /* # NETDEV_LAMP_CTRL_MODE_E */
    BOOL   bSupportNearLampCfg;                                     /* 0 1*/
    BOOL   bSupportMiddleLampCfg;                                   /* 0 1*/
    BOOL   bSupportFarLampCfg;                                      /* 0 1*/
    BOOL   bSupportSuperFarLampCfg;                                 /* 0 1*/
    BOOL   bSupportLaserAngleCfg;                                   /* 0 1*/
    UINT32 udwLaserAngleMin;                                        /* bSupportLaserAngleCfg0*/
    UINT32 udwLaserAngleMax;                                        /* bSupportLaserAngleCfg0*/
    BYTE   byRes[512];                                              /*   Reserved */
}NETDEV_LAMP_INFO_S, *LPNETDEV_LAMP_INFO_S;

/**
 * @struct tagNETDEVLampCtrlCapabilitiesInfo
 * @brief  IPC 
 * @attention
 */
typedef struct tagNETDEVLampCtrlCapabilitiesInfo
{
    UINT32              udwLampNum;                                     /* 0*/
    NETDEV_LAMP_INFO_S  astLampInfos[NETDEV_LAMP_CTRL_TYPE_MAX_NUM];    /* ,LampNum0*/
    BYTE                byRes[512];                                     /*   Reserved */
}NETDEV_LAMPCTRL_CAP_INFO_S, *LPNETDEV_LAMPCTRL_CAP_INFO_S;

/**
 * @struct tagNETDEVShutterCapabilitiesInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVShutterCapabilitiesInfo
{
    BOOL   bSupportShutterTimeCfg;                                                  /* 0 1*/
    UINT32 udwShutterTimeUnit;                                                      /*   0 1*/
    UINT32 udwShutterTimeRangeNum;                                                  
    UINT32 audwShutterTimeRangeList[NETDEV_SHUTTER_TIME_RANGE_MAX_NUM];             /*  # NETDEV_SHUTTER_TIME_RANGE_E */
    BOOL   bSupportSlowShutterCfg;                                                  /* 0 1*/
    UINT32 udwSlowShutterTimeRangeNum;                                              
    UINT32 audwSlowShutterTimeRangeList[NETDEV_SLOW_SHUTTER_TIME_RANGE_MAX_NUM];    /*  # NETDEV_SHUTTER_TIME_RANGE_E 1/25*/
    BYTE   byRes[512];                                                              /*   Reserved */
}NETDEV_SHUTTER_CAP_INFO_S, *LPNETDEV_SHUTTER_CAP_INFO_S;

/**
 * @struct tagNETDEVWideDynamicCapabilitiesInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVWideDynamicCapabilitiesInfo
{
    BOOL   bSupportWideDynamicCfg;                                              /* 0 1*/
    UINT32 udwWideDynamicModeNum;                                               
    UINT32 audwWideDynamicModeList[NETDEV_SHUTTER_TIME_RANGE_MAX_NUM];          /*  # NETDEV_WIDE_DYNAMIC_MODE_E */
    BYTE   byRes[512];                                                          /*   Reserved */
}NETDEV_WIDE_DYNAMIC_CAP_INFO_S, *LPNETDEV_WIDE_DYNAMIC_CAP_INFO_S;

/**
 * @struct tagNETDEVDayNightCapabilitiesInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVDayNightCapabilitiesInfo
{
    BOOL   bSupportDayNightCfg;                                              /* 0 1*/
    UINT32 udwDayNightModeNum;                                               
    UINT32 audwDayNightModeList[NETDEV_DAY_NIGHT_MODE_MAX_NUM];              /*  # NETDEV_DAY_NIGHT_MODE_E */
    BOOL   bSupportSensibilityCfg;                                           /* 0 1*/
    BOOL   bSupportSwitchingCfg;                                             /* 0 1*/
    BYTE   byRes[512];                                                       /*   Reserved */
}NETDEV_DAY_NIGHT_CAP_INFO_S, *LPNETDEV_DAY_NIGHT_CAP_INFO_S;

/**
 * @struct tagNETDEVExposureCapabilitiesInfo
 * @brief IPC 
 * @attention
 */
typedef struct tagNETDEVExposureCapabilitiesInfo
{
    BOOL                            bSupportCompensationCfg;                                          /* 0 1*/
    UINT32                          udwExposureModeNum;                                               /* */
    UINT32                          audwExposureModeList[NETDEV_EXPOSURE_MODE_MAX_NUM];               /* # NETDEV_EXPOSURE_MODE_E */
    BOOL                            bSupportIrisCfg;                                                  /* 0 1*/
    UINT32                          udwIrisRangeNum;                                                  /* */
    UINT32                          audwIrisRangeList[NETDEV_IRIS_RANGE_MAX_NUM];                     /* :16020024028034040048056068080096011001400,1600,2200 IrisRangeNum0*/
    UINT32                          udwMinGain;                                                       /* */
    UINT32                          udwMaxGain;                                                       /* */
    BOOL                            bSupportHLCCfg;                                                   /* 0 1*/
    BOOL                            bSupportMeteringCfg;                                              /* 0 1*/
    BOOL                            bSupportSuperFarLampCfg;                                          /* 0 1*/
    UINT32                          udwMeteringModeNum;                                               /* */
    UINT32                          audwMeteringModeList[NETDEV_METERING_MODE_MAX_NUM];               /*  # NETDEV_EXPOSURE_MODE_E */
    NETDEV_SHUTTER_CAP_INFO_S       stShutterCapInfo;                                                 
    NETDEV_WIDE_DYNAMIC_CAP_INFO_S  stWideDynamicCapInfo;                                             
    NETDEV_DAY_NIGHT_CAP_INFO_S     stDayNightCapInfo;                                                
    BYTE                            byRes[512];                                                       /*   Reserved */
}NETDEV_EXPOSURE_CAP_INFO_S, *LPNETDEV_EXPOSURE_CAP_INFO_S;

/**
 * @struct tagNETDEVSceneCapabilities
 * @brief  
 * @attention   IPC
 */
typedef struct tagNETDEVSceneCapabilities
{
    BOOL   bSupportSceneCfg;                                          /* 0 1 */
    UINT32 udwSceneTemplateNum;                                       
    UINT32 udwSceneTypeNum;                                           
    UINT32 audwSceneTypeList[NETDEV_MAX_SCENE_TYPE_NUM];              /* # NETDEV_SCENE_TYPE_E */
    UINT32 udwTriggerNum;                                             
    UINT32 udwEnvironmentTypeNum;                                     
    UINT32 audwEnvironmentTypeList[NETDEV_MAX_ENV_TYPE_NUM];          /* # NETDEV_ENV_TYPE_E */
    BYTE   byRes[512];                                                /*   Reserved */
}NETDEV_SCENE_CAP_INFO_S, *LPNETDEV_SCENE_CAP_INFO_S;

/**
 * @struct tagNETDEVImageCapabilities
 * @brief      Device image Capabilities Structure definition
 * @attention
 */
typedef struct tagNETDEVImageCapabilities
{
    BOOL                            bSupportCfg;                                                       /*  0,1, */
    BOOL                             bIsSupportCorrectCfg;                                             /*  01 */
    INT32                            udwImageRotationModeNum;                                          
    INT32                            udwImageRotationModeList[NETDEV_IMAGE_ROTATION_MODE_MAX_NUM];     /* ,# NETDEV_IMAGE_ROTATION_MODE_E */
    BOOL                             bSupportSharpness;                                                /* 0,1,*/
    BOOL                             bSupport2DNoiseReduce;                                            /* 2D0,1, */
    BOOL                             bSupport3DNoiseReduce;                                            /* 3D0,1, */
    BOOL                             bSupportIlluminationCfg;                                          /* (IPC) 0,1, */
    BOOL                             bIsSupportEPTZ;                                                   /* 0,1, */
    NETDEV_FOCUS_CAP_INFO_S          stFocusCapInfo;                                                   /* ,IPC*/
    NETDEV_LAMPCTRL_CAP_INFO_S       stLampCtrlCapInfo;                                                /* ,IPC*/
    NETDEV_EXPOSURE_CAP_INFO_S       stExposureCapInfo;                                                /* ,IPC*/
    NETDEV_WHITE_BALANCE_CAP_INFO_S  stWhiteBalanceCapInfo;                                            /* ,IPC*/
    NETDEV_SCENE_CAP_INFO_S          stSceneCapInfo;                                                    
    BYTE                             byRes[412];                                                       /*   Reserved */
}NETDEV_IMAGE_CAP_S, *LPNETDEV_IMAGE_CAP_S;

/**
 * @struct tagNETDEVIrisInfo
 * @brief        IrisInfo
 * @attention
 */
typedef struct tagNETDEVIrisInfo
{
    UINT32 udwIris;         /* ,:160 200 240 280 340 400 480 560 680 800 960 11001400,  1600,  2200*/
    UINT32 udwMinIris;      /*   Iris*/
    UINT32 udwMaxIris;      /*   Iris*/
    BYTE  byRes[128];       /*   Reserved */
}NETDEV_IRIS_INFO_S, *LPNETDEV_IRIS_INFO_S;

/**
 * @struct tagNETDEVShutterInfo
 * @brief        ShutterInfo
 * @attention
 */
typedef struct tagNETDEVShutterInfo
{
    UINT32 udwShutterTime;                  /*  # NETDEV_SHUTTER_TIME_RANGE_E ,  0 1*/
    UINT32 udwMinShutterTime;               /*  MinShutter # NETDEV_SHUTTER_TIME_RANGE_E */
    UINT32 udwMaxShutterTime;               /*  MaxShutter # NETDEV_SHUTTER_TIME_RANGE_E */
    UINT32 udwIsEnableSlowShutter;          /* 0  1*/
    UINT32 udwSlowestShutter;               /* ,*/
    BYTE   byRes[128];                      /*   Reserved */
}NETDEV_SHUTTER_INFO_S, *LPNETDEV_SHUTTER_INFO_S;

/**
 * @struct tagNETDEVGainInfo
 * @brief        GainInfo
 * @attention
 */
typedef struct tagNETDEVGainInfo
{
    UINT32 udwGain;         /* :db[1,100]*/
    UINT32 udwMinGain;      /*  ,1*/
    UINT32 udwMaxGain;      /*  , 100*/
    BYTE   byRes[128];      /*   Reserved */
}NETDEV_GAIN_INFO_S, *LPNETDEV_GAIN_INFO_S;

/**
 * @struct tagNETDEVWideDynamicInfo
 * @brief        WideDynamicInfo
 * @attention
 */
typedef struct tagNETDEVWideDynamicInfo
{
    UINT32 udwWideDynamicMode;              /*  WideDynamicMode # NETDEV_WIDE_DYNAMIC_MODE_E */
    UINT32 udwWideDynamicLevel;             /* 50HZ60HZ[1, 9]*/
    UINT32 udwOpenSensitivity;              /* [1, 9]*/
    UINT32 udwCloseSensitivity;             /* [1, 9]*/
    UINT32 udwAntiFlicker;                  /* 0 1*/
    BYTE   byRes[128];                      /*   Reserved */
}NETDEV_WIDE_DYNAMIC_INFO_S, *LPNETDEV_WIDE_DYNAMIC_INFO_S;

/**
 * @struct tagNETDEVAreaTopLeft
 * @brief        Upper left Area
 * @attention
 */
typedef struct tagNETDEVAreaTopLeft
{
    UINT32  dwTopLeftX;     /* (): [0, 100]Upper left corner X [0, 100]  */
    UINT32  dwTopLeftY;     /* (): [0, 100]Upper left corner Y [0, 100]  */
    BYTE    byRes[128];     /*   Reserved */
}NETDEV_AREA_TOP_LEFT_S, *LPNETDEV_AREA_TOP_LEFT_S;

/**
 * @struct tagNETDEVAreaBotRight
 * @brief        Lower right Area
 * @attention
 */
typedef struct tagNETDEVAreaBotRight
{
    UINT32  dwBottomRightX;     /* (): [0, 100]  Lower right corner x [0, 100] */
    UINT32  dwBottomRightY;     /* (): [0, 100]  Lower right corner y [0, 100] */
    BYTE    byRes[128];         /*   Reserved */
}NETDEV_AREA_BOT_RIGHT_S, *LPNETDEV_AREA_BOT_RIGHT_S;

/**
 * @struct tagNETDEVMeteringArea
 * @brief       MeteringArea
 * @attention
 */
typedef struct tagNETDEVMeteringArea
{
    NETDEV_AREA_TOP_LEFT_S    stAreaTopLeft;           /*   # NETDEV_AREA_TOP_LEFT_S */
    NETDEV_AREA_BOT_RIGHT_S   stAreaBotRight;          /*   # NETDEV_AREA_BOT_RIGHT_S */
    BYTE  byRes[128];                                  /*   Reserved */
}NETDEV_METERING_AREA_S, *LPNETDEV_METERING_AREA_S;

/**
 * @struct tagNETDEVMeteringInfo
 * @brief        MeteringInfo
 * @attention
 */
typedef struct tagNETDEVMeteringInfo
{
    UINT32                 udwMeteringMode;                 /* ,# NETDEV_DAY_NIGHT_MODE_E */
    UINT32                 udwRefBrightness;                /* [0, 100]*/
    UINT32                 udwHoldTime;                     /* [0, 60]*/
    NETDEV_METERING_AREA_S stMeteringArea;                  /*  ,*/
    BYTE                   byRes[128];                      /*   Reserved */
}NETDEV_METERING_INFO_S, *LPNETDEV_METERING_INFO_S;

/**
 * @struct tagNETDEVDayNightInfo
 * @brief        MeteringInfo
 * @attention
 */
typedef struct tagNETDEVDayNightInfo
{
    UINT32 udwDayNightMode;                 /*  DayNightMode # NETDEV_DAY_NIGHT_MODE_E */
    UINT32 udwDayNightSensitivity;          /*  DayNightSensitivity [0, 9]*/
    UINT32 udwDayNightTime;                 /* [3, 120]*/
    BYTE   byRes[128];                      /*   Reserved */
}NETDEV_DAY_NIGHT_INFO_S, *LPNETDEV_DAY_NIGHT_INFO_S;

/**
 * @struct tagNETDEVImagingExposure
 * @brief      Device image Exposure Structure definition
 * @attention
 */
typedef struct tagNETDEVImagingExposure
{
    UINT32                      udwMode;                /*   Exposure Mode # NETDEV_EXPOSURE_MODE_E */
    INT32                       dwCompensationLevel;    /* ,[-100,100]. */
    UINT32                      udwHLCSensitivity;      /* ,[1,9]  */
    NETDEV_IRIS_INFO_S          stIrisInfo;             /* */
    NETDEV_SHUTTER_INFO_S       stShutterInfo;          /* */
    NETDEV_GAIN_INFO_S          stGainInfo;             /* */
    NETDEV_WIDE_DYNAMIC_INFO_S  stWideDynamicInfo;      /* */
    NETDEV_METERING_INFO_S      stMeteringInfo;         /* */
    NETDEV_DAY_NIGHT_INFO_S     stDayNightInfo;         /* */
    BYTE                        byRes[256];             /*   Reserved */
}NETDEV_IMAGE_EXPOSURE_S, *LPNETDEV_IMAGE_EXPOSURE_S;

/**
 * @struct tagNETDEVLampCtrlInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVLampCtrlInfo
{
    UINT32 udwEnabled;          /* 0 1 */
    UINT32 udwType;             /*   # NETDEV_LAMP_TYPE_E */
    UINT32 udwMode;             /*   # NETDEV_LAMP_CTRL_MODE_E */
    UINT32 udwNearLevel;        /* ,-,[0-1000]*/
    UINT32 udwMiddleLevel;      /* ,-[0-1000]*/
    UINT32 udwFarLevel;         /* ,-[0-1000]*/
    UINT32 udwSuperFarLevel;    /* ,-[0-1000]*/
    UINT32 udwLaserAngle;       /* -*/
    BYTE  byRes[256];           /*   Reserved */
}NETDEV_LAMP_CTRL_INFO_S, *LPNETDEV_LAMP_CTRL_INFO_S;

/**
 * @struct tagNETDEVWhiteBalanceInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVWhiteBalanceInfo
{
    UINT32 udwMode;              /*   # NETDEV_WHITE_BALANCE_MODE_E */
    INT32  dwRedOffset;          /* RedMode[1,5,8]*/
    INT32  dwBlueOffset;         /* BlueMode[1,5,8]*/
    BYTE   byRes[256];           /*   Reserved */
}NETDEV_WHITE_BALANCE_INFO_S, *LPNETDEV_WHITE_BALANCE_INFO_S;

/**
 * @struct tagNETDEVXWSteamInfoSrc
 * @brief  
 * @attention
 */
typedef struct tagNETDEVXWSteamInfoSrc
{
    UINT32  udwVideoInChlID;                /* ID */
    UINT32  udwStreamID;                    /*  NETDEV_LIVE_STREAM_INDEX_E */
    CHAR    szIPAddr[NETDEV_IPV4_LEN_MAX];  /* IP */
    UINT32  udwPort;                        
    BYTE    byRes[64];                      
}NETDEV_XW_STREAM_INFO_SRC_S, *LPNETDEV_XW_STREAM_INFO_SRC_S;

/**
 * @struct tagNETDEVXWSteamInfoDest
 * @brief  
 * @attention
 */
typedef struct tagNETDEVXWSteamInfoDest
{
    UINT32  udwWndID;                       /* ID */
    UINT32  udwPaneID;                      
    CHAR    szIPAddr[NETDEV_IPV4_LEN_MAX];  /* IP */
    UINT32  udwPort;                        
    BYTE    byRes[64];                      
}NETDEV_XW_STREAM_INFO_DEST_S, *LPNETDEV_XW_STREAM_INFO_DEST_S;

/**
 * @struct tagNETDEVXWStreamInfoMsg
 * @brief  
 * @attention
 */
typedef struct tagNETDEVXWStreamInfoMsg
{
    UINT32                  udwTransProtocol;           /*  NETDEV_TRANS_PROTOCOL_E */
    UINT32                  udwIsMulticast;             /*  NETDEV_STREAM_TYPE_E */
    NETDEV_XW_RESOLUTION_S  stResolution;               
    UINT32                  udwFrame;                   
    UINT32                  udwEncodeFormat;            
    UINT32                  udwIsInvalidAfterReboot;    /*  0 "XW"1 "XW"*/
    BYTE                    byRes[64];                  
}NETDEV_XW_STREAM_INFO_MSG_S, *LPNETDEV_XW_STREAM_INFO_MSG_S;

/**
 * @struct tagNETDEVXWSteamInfo
 * @brief  
 * @attention
 */
typedef struct tagNETDEVXWSteamInfo
{
    UINT32                          udwTaskNo;          
    UINT32                          udwType;            /*  NETDEV_XW_VIDEO_TYPE_E */
    NETDEV_XW_STREAM_INFO_SRC_S     stStreamInfoSrc;    
    NETDEV_XW_STREAM_INFO_DEST_S    stStreamInfoDest;   
    NETDEV_XW_STREAM_INFO_MSG_S     stStreamInfoMsg;    
}NETDEV_XW_STREAM_INFO_S, *LPNETDEV_XW_STREAM_INFO_S;

/**
 * @struct tagNETDEVXWAudioOutInfoList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWAudioOutInfoList
{
    UINT32                      udwAudioSize;                           
    NETDEV_XW_AUDIO_OUT_INFO_S  stAudioIDList[NETDEV_XW_AUDIO_NUM];     
    BYTE                        byRes[128];                             
}NETDEV_XW_AUDIO_OUT_INFO_LIST_S, *LPNETDEV_XW_AUDIO_OUT_INFO_LIST_S;

/**
 * @struct tagNETDEVXWSequenceStatus
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWSequenceStatus
{
    UINT32  udwWndID;       /* ID */
    UINT32  udwStatus;      /*  NETDEV_XW_SEQUENCE_STATUS_E */
    BYTE    byRes[64];      
}NETDEV_XW_SEQUENCE_STATUS_S, *LPNETDEV_XW_SEQUENCE_STATUS_S;

/**
 * @struct tagNETDEVXWSequenceResourceBaseInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWSequenceResourceBaseInfo
{
    UINT32  udwID;                          /* ID */
    CHAR    szName[NETDEV_LEN_64];          
    CHAR    szDescription[NETDEV_LEN_256];  
    BOOL    bEnabled;                       
    UINT32  udwOrderNO;                     /* , */
    BYTE    byRes[124];                     
}NETDEV_XW_SEQUENCE_RES_BASE_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_BASE_INFO_S;

/**
 * @struct tagNETDEVXWSeqVideoSrcInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWSeqVideoSrcInfo
{
    UINT32                              udwVideoSrcIndex;               
    NETDEV_XW_VIDEO_SOURCE_BASE_S       stVideoSrcBaseInfo;             
    UINT32                              udwPresetIndex;                 
    BYTE                                byRes[64];                      
}NETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S, *LPNETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S;

/**
 * @struct tagNETDEVXWSequenceResDeTailInfo
 * @brief  
           
 * @attention  None
 */
typedef struct tagNETDEVXWSequenceResDeTailInfo
{
    NETDEV_XW_SEQUENCE_RES_BASE_INFO_S      stSeqResBaseInfo;   
    UINT32                                  udwIntervalTime;    /*  */
    UINT32                                  udwVideoSrcNum;     
    LPNETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S    pstVideoInList;     /* ,,  */
    UINT32                                  udwManageType;      /*  NETDEV_XW_MANAGE_TYPE_E  */
    BYTE                                    byRes[124];         
}NETDEV_XW_SEQUENCE_RES_DETAIL_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_DETAIL_INFO_S;

/**
 * @struct tagNETDEVXWSequencePlayControlInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWSequencePlayControlInfo
{
    UINT32  udwSequenceResBindID;   /* ID */
    UINT32  udwOperation;           /*   NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E */
    BYTE    byRes[128];             
}NETDEV_XW_SEQUENCE_PLAY_CTRL_INFO_S, *LPNETDEV_XW_SEQUENCE_PLAY_CTRL_INFO_S;

/**
 * @struct tagNETDEVXWSequenceIntervalInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWSequenceIntervalInfo
{
    UINT32  udwSequenceResBindID;   /* ID */
    UINT32  udwIntervalTime;        /*   */
    BYTE    byRes[128];             
}NETDEV_XW_SEQUENCE_INTERVAL_INFO_S, *LPNETDEV_XW_SEQUENCE_INTERVAL_INFO_S;

/**
 * @struct tagNETDEVXWScenesPlanTimerInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWScenesPlanTimerInfo
{
    UINT32  udwIntervalTime;        /*   */
    UINT32  udwSceneNum;            
    UINT32* pudwSceneIDList;        /* ID */
    BYTE    byRes[64];              
}NETDEV_XW_SCENES_PLAN_TIMER_INFO_S, *LPNETDEV_XW_SCENES_PLAN_TIMER_INFO_S;

/**
 * @struct tagNETDEVXWTimeTableInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWTimeTableInfo
{
    UINT32  udwSceneID;                     /* ID */
    CHAR    szStartTime[NETDEV_LEN_16];     /*  hh:mm:ss */
    BYTE    byRes[64];                      
}NETDEV_XW_TIME_TABLE_INFO_S, *LPNETDEV_XW_TIME_TABLE_INFO_S;

/**
 * @struct tagNETDEVXWScenesPlanTimeTableInfo
 * @brief  ,24
 * @attention  None
 */
typedef struct tagNETDEVXWScenesPlanTimeTableInfo
{
    UINT32                          udwTimePeriodNum;               
    LPNETDEV_XW_TIME_TABLE_INFO_S   pstTimeTableList;               /* udwTimePeriodNum */
    BYTE                            byRes[64];                      
}NETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S, *LPNETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S;

/**
 * @struct tagNETDEVXWScenesPlanInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWScenesPlanInfo
{
    UINT32                                      udwID;                          /* ID */
    CHAR                                        szName[NETDEV_LEN_64];          
    UINT32                                      udwOrderNo;                     
    CHAR                                        szDescription[NETDEV_LEN_256];  
    UINT32                                      udwStatus;                      /*   NETDEV_XW_SEQUENCE_RES_STATUS_E */
    UINT32                                      udwMode;                        /*   NETDEV_XW_SCENES_PLAN_MODE_E */
    NETDEV_XW_SCENES_PLAN_TIMER_INFO_S          stTimerInfo;                    
    NETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S     stTimeTableInfo;                
    BYTE                                        byRes[124];                     
}NETDEV_XW_SCENES_PLAN_INFO_S, *LPNETDEV_XW_SCENES_PLAN_INFO_S;

/**
 * @struct tagNETDEVXWScenesSeqPlanPlayCtrlInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWScenesSeqPlanPlayCtrlInfo
{
    UINT32  udwScenesSeqPlanID;     /* ID */
    UINT32  udwOperation;           /*   NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E */
    BYTE    byRes[128];             
}NETDEV_XW_SCENES_PLAN_PLAY_CTRL_INFO_S, *LPNETDEV_XW_SCENES_PLAN_PLAY_CTRL_INFO_S;

/**
* @struct tagNETDEVXWSpecialResolutionInfo
* @brief 
* @attention
*/
typedef struct tagNETDEVXWResolutionInfo
{
    UINT32  udwWidth;               /* px */
    UINT32  udwHeight;              /* px */
    UINT32  udwFrameRate;           
    BYTE    byRes[64];              
}NETDEV_XW_RESOLUTION_INFO_S, *LPNETDEV_XW_RESOLUTION_INFO_S;

/**
 * @struct tagNETDEVDevFaceCapInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVDevFaceCapInfo
{
    BOOL   bIsFaceRecognitionSupported;     /*  0 1 */
    BYTE   byRes[255];                      
}NETDEV_DEV_FACE_CAP_INFO_S, *LPNETDEV_DEV_FACE_CAP_INFO_S;

/**
 * @struct tagNETDEVCIQuotaChannelInfoList
 * @brief   
 * @attention None
 */
typedef struct tagNETDEVCIQuotaChannelInfoList
{
    UINT32 udwNums;                            
    UINT32 audwChannels[NETDEV_LEN_1024];      /*ID*/
}NETDEV_QUOTA_CHANNE_INFO_S,*LPNETDEV_QUOTA_CHANNE_INFO_S;

/**
 * @struct tagNETDEVCISetQuotaInfo
 * @brief     
 * @attention None
 */
typedef struct tagNETDEVCISetQuotaInfo
{
    UINT32                     udwRecordQuota;                  /* (GB)*/
    UINT32                     udwPictureQuota;                 /* (GB)*/
    UINT32                     udwGroupID;                      /* ID*/
    NETDEV_QUOTA_CHANNE_INFO_S stCopyTo;                        
}NETDEV_SET_QUOTA_INFO_S,*LPNETDEV_SET_QUOTA_INFO_S;

/**
 * @struct tagNETDEVCIGetQuotainolist
 * @brief   
 * @attention None
 */
typedef struct tagNETDEVCIGetQuotaInfo
{
    UINT32 udwChannelID;                    /* ID*/  
    CHAR   szChannelName[NETDEV_LEN_64];    
    CHAR   szDeviceName[NETDEV_LEN_64];     
    UINT32 udwRecordQuota;                  /* (GB)*/
    UINT32 udwPictureQuota;                 /* (GB)*/
    UINT32 udwGroupID;                      /* ID*/
    UINT32 udwOrgID;                        /* ID*/
}NETDEV_QUOTA_INFO_S,*LPNETDEV_QUOTA_INFO_S;

/**
 * @struct tagNETDEVCIGetQuotainolist
 * @brief     
 * @attention None
 */
typedef struct tagNETDEVCIGetQuotainolist
{
    UINT32                  udwNums;                        
    NETDEV_QUOTA_INFO_S     astQuotas[NETDEV_LEN_1024];     
}NETDEV_GET_QUOTA_INFOLIST_S,*LPNETDEV_GET_QUOTA_INFOLIST_S;

/**
* @struct tagNETDEVRAIDStatus
* @brief  
* @attention 
*/
typedef struct tagNETDEVRAIDStatus
{
    BOOL    bEnabled;                   /*  0: 1: */
    BYTE    byRes[128];                 
}NETDEV_RAID_STATUS_S, *LPNETDEV_RAID_STATUS_S;

/**
 * @struct tagNETDEVHDDInfo
 * @brief  HDD info
 * @attention  None
 */
typedef struct tagNETDEVHDDInfo
{
    UINT32  udwID;                          
    UINT32  udwType;                        /*  # NETDEV_HDD_TYPE_E */
    UINT32  udwWorkMode;                    /*  # NETDEV_HDD_WORK_MODE_E */
    UINT32  udwTotalCapacity;               /* (MB) Total Capacity */
    CHAR    szRAIDName[NETDEV_LEN_64];      
    UINT32  udwStatus;                      /*  # NETDEV_HDD_STATUS_E */
    CHAR    szManufacturer[NETDEV_LEN_64];  
    BYTE    byRes[128];                     
}NETDEV_HDD_INFO_S,*LPNETDEV_HDD_INFO_S;

/**
 * @struct tagNETDEVHDDInfoList
 * @brief  Disk info list
 * @attention  None
 */
typedef struct tagNETDEVHDDInfoList
{
    INT32               dwSize;                             /*  Disk number */
    NETDEV_HDD_INFO_S   astHDDInfo[NETDEV_LEN_32];          /*  Disk info */
    BYTE                byRes[128];                         
}NETDEV_HDD_INFO_LIST_S,*LPNETDEV_HDD_INFO_LIST_S;

/**
 * @struct tagNETDEVStorageContainerInfo
 * @brief  Storage Container info
 * @attention  None
 */
typedef struct tagNETDEVStorageContainerInfo
{
    UINT32  udwID;                              
    UINT32  udwRemainCapacity;                  /* (MB) */
    UINT32  udwTotalCapacity;                   /* (MB) */
    CHAR    szManufacturer[NETDEV_LEN_64];      
    UINT32  udwStatus;                          /*  # NETDEV_STORAGE_CONTAINER_STATUS_E */
    UINT32  udwProperty;                        /* ,udwStatus0 # NETDEV_STORAGE_CONTAINER_PROPERTY_E */
    UINT32  udwFormatProgress;                  
    UINT32  udwGroupID;                         
    UINT32  udwTemperature;                     
    BYTE    byRes[124];                         
}NETDEV_STORAGE_CONTAINER_INFO_S,*LPNETDEV_STORAGE_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVExtendStorageContainerInfo
 * @brief  extend Storage Container info
 * @attention  None
 */
typedef struct tagNETDEVExtendStorageContainerInfo
{
    UINT32  udwID;                              
    UINT32  udwRemainCapacity;                  /* (MB) */
    UINT32  udwTotalCapacity;                   /* (MB) */
    UINT32  udwAddressType;                     /* IP,# NETDEV_ADDR_TYPE_E */
    CHAR    szIPAddress[NETDEV_LEN_64];         /* IP */
    CHAR    szPath[NETDEV_LEN_256];             /* NAS */
    UINT32  udwUsageType;                       /* ,# NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E */
    UINT32  udwStatus;                          /*  # NETDEV_STORAGE_CONTAINER_STATUS_E */
    UINT32  udwProperty;                        /* ,udwStatus0 # NETDEV_STORAGE_CONTAINER_PROPERTY_E */
    UINT32  udwFormatProgress;                  
    UINT32  udwGroupID;                         
    BYTE    byRes[128];                         
}NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S,*LPNETDEV_EXTEND_STORAGE_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVStorageContainerInfoList
 * @brief  Storage Container info List
 * @attention  None
 */
typedef struct tagNETDEVStorageContainerInfoList
{
    UINT32                                  udwLocalHDDNum;                                                 
    NETDEV_STORAGE_CONTAINER_INFO_S         astLocalHDDList[NETDEV_LOCAL_DISK_MAX_NUM];                     
    UINT32                                  udwSDNum;                                                       /* SD */
    NETDEV_STORAGE_CONTAINER_INFO_S         astSDList[NETDEV_SD_CARD_DISK_MAX_NUM];                         /* SD */
    UINT32                                  udwArrayNum;                                                    
    NETDEV_STORAGE_CONTAINER_INFO_S         astArrayList[NETDEV_ARRAY_MAX_NUM];                             
    UINT32                                  udwExtendCabinet1HDDNum;                                        /* -1 */
    NETDEV_STORAGE_CONTAINER_INFO_S         astExtendCabinet1HDDList[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* -1  */
    UINT32                                  udwExtendCabinet2HDDNum;                                        /* -2 */
    NETDEV_STORAGE_CONTAINER_INFO_S         astExtendCabinet2HDDList[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* -2  */
    UINT32                                  udwNASNum;                                                      /* NAS */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  astNASList[NETDEV_NAS_MAX_NUM];                                 /* NAS */
    UINT32                                  udweSATANum;                                                    /* eSATA */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  asteSATAList[NETDEV_ESATA_MAX_NUM];                             /* eSATA */
    UINT32                                  udwIPSANNum;                                                    /* IPSAN */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  astIPSANList[NETDEV_IPSAN_MAX_NUM];                             /* IPSAN */
    BYTE                                    byRes[256];                                                     
}NETDEV_STORAGE_CONTAINER_INFO_LIST_S,*LPNETDEV_STORAGE_CONTAINER_INFO_LIST_S;

/**
 * @struct tagNETDEVContainerInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVContainerInfo
{
    UINT32          udwID;                                                      
    UINT32          udwType;                                                    /*   NETDEV_CONTAINER_TYPE_E */
    BYTE            byRes[256];                                                 
}NETDEV_CONTAINER_INFO_S, *LPNETDEV_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVFormatContainerInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVFormatContainerInfo
{
    UINT32                              udwNum;                             
    LPNETDEV_CONTAINER_INFO_S           pstContainerList;                   
    BYTE                                byRes[256];                         
}NETDEV_FORMAT_CONTAINER_INFO_S, *LPNETDEV_FORMAT_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVHDDSmartDetailsInfo
 * @brief Smart
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartDetailsInfo
{
    UINT32  udwAttributeID;                     /* ID */
    CHAR    szAttributeName[NETDEV_LEN_64];     
    UINT32  udwStatus;                          /*  # NETDEV_HDD_SMART_ASSESSMENT_STATUS_E */
    UINT32  udwHex;                             
    UINT32  udwThresh;                          
    UINT32  udwCurrentValue;                    
    UINT32  udwWorstValue;                      
    UINT32  udwActualValue;                     
    BYTE    byRes[128];                         
}NETDEV_HDD_SMART_DETAILS_INFO_S,*LPNETDEV_HDD_SMART_DETAILS_INFO_S;

/**
 * @struct tagNETDEVHDDSmartCheckInfo
 * @brief Smart
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartCheckInfo
{
    UINT32                          udwID;                                  
    UINT32                          udwType;                                /*  # NETDEV_HDD_SMART_CHECK_TYPE_E */
    BYTE                            byRes[128];                             
}NETDEV_HDD_SMART_CHECK_INFO_S,*LPNETDEV_HDD_SMART_CHECK_INFO_S;

/**
 * @struct tagNETDEVPhotoServerCfgInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPhotoServerCfgInfo
{
    UINT32                          udwProtocol;                                          /*  : NETDEV_PHOTO_SERVER_PRO_TYPE_E */
    UINT32                          udwSubProtocol;                                       /*  : NETDEV_PHOTO_SERVER_SUBPRO_TYPE_E udwProtocol131*/
    UINT32                          udwPort;                                              /* TMS [0,65535] */
    CHAR                            szIPV4Address[NETDEV_IPADDR_STR_MAX_LEN];             /* TMSIPv4*/
    CHAR                            szTollgateID[NETDEV_LEN_64];                          /* (0, 36];  */
    CHAR                            szCameraID[NETDEV_LEN_64];                            /* (0, 36];*/
    BYTE                            byRes[128];                                           
}NETDEV_PHOTO_SERVER_CFG_INFO_S,* LPNETDEV_PHOTO_SERVER_CFG_INFO_S;

/**
 * @struct tagNETDEVPhotoServerCfgInfoList
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPhotoServerCfgInfoList
{
    UINT32                            udwNum;                                               /*  2 */
    NETDEV_PHOTO_SERVER_CFG_INFO_S    astPhotoServerList[NETDEV_PHOTO_SERVER_MAX_NUM];      
    BYTE                              byRes[512];                                           
}NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S,* LPNETDEV_PHOTO_SERVER_CFG_INFO_LIST_S;

/**
 * @struct tagNETDEVServerUserInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVServerUserInfo
{
    CHAR                            szUserName[NETDEV_USERNAME_LEN];    /* [1,32] */
    BOOL                            bModifyPasswd;                      /*  0: 1:*/
    CHAR                            szPasswd[NETDEV_PASSWORD_LEN];      /*  [0,32]  */
    BYTE                            byRes[256];                         
}NETDEV_SERVER_USER_INFO_S, *LPNETDEV_SERVER_USER_INFO_S;

/**
 * @struct tagNETDEVViidCfg
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVViidCfg
{
    UINT32              udwCoordinateType;                      /* 0:([0,9999])1: 2:(0~1) NETDEV_INVALID_PARAM */
    CHAR                szViidServerID[NETDEV_LEN_64];          /* [1,32]IPC */
    UINT32              udwConnectMode;                         /* 01NETDEV_INVALID_PARAM */
    UINT32              udwObjectType;                          /* BitBit01Bit0Bit1Bit2Bit3 */
    BYTE                byRes[32];                              
}NETDEV_VIID_CFG_S, *LPNETDEV_VIID_CFG_S;

/**
 * @struct tagNETDEVDataServerInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVDataServerInfo
{
    UINT32                          udwIndex;                                           /*  0 */
    BOOL                            bEnable;                                            
    UINT32                          udwProtocol;                                        /*   1:TCP(V2 TMS) # NETDEV_DATA_SERVER_PROTOCOL_TYPE_E */
    CHAR                            szCameraID[NETDEV_LEN_128];                         /* (0, 36] 0*/
    CHAR                            szTollgateID[NETDEV_LEN_128];                       /* (0, 36] 0 */
    CHAR                            szServerAddr[NETDEV_LEN_32];                        /* IPv4 */
    UINT32                          udwServerPort;                                      
    CHAR                            szDrivewayID[NETDEV_LEN_64];                        /*  IPC */
    CHAR                            szDirectionID[NETDEV_LEN_64];                       /*  IPC */
    CHAR                            szDeviceID[NETDEV_LEN_64];                          /*  IPC */
    CHAR                            szAreaId[NETDEV_LEN_64];                            /*  IPC */
    NETDEV_SERVER_USER_INFO_S       stServerUserInfo;                                   
    NETDEV_VIID_CFG_S               stViidCfg;                                          /* # NETDEV_VIID_CFG_S */
    BYTE                            byRes[148];                                         
}NETDEV_DATA_SERVER_INFO, *LPNETDEV_DATA_SERVER_INFO;

/**
 * @struct tagNETDEVDataServerList
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVDataServerList
{
    UINT32                          udwNum;                                               /*  2 */
    NETDEV_DATA_SERVER_INFO         astDataServerList[NETDEV_INTELLIGENT_SERVER_MAX_NUM]; 
    BYTE                            byRes[128];                                           
}NETDEV_DATA_SERVER_LIST, *LPNETDEV_DATA_SERVER_LIST;

/**
 * @struct tagNETDEVManagerServerInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVManagerServerInfo
{
    UINT32                          udwIndex;                                           /*  0 */
    UINT32                          udwMngProtocol;                                     /*  # NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_E */
    CHAR                            szDeviceID[NETDEV_LEN_64];                          /* ID[1, 32] */
    CHAR                            szServerID[NETDEV_LEN_64];                          /* ID [1, 32] */
    CHAR                            szDeviceName[NETDEV_DEV_NAME_LEN_MAX];              /* [0, 20] */
    CHAR                            szRegPassword[NETDEV_LEN_32];                       /* (0, 16] */
    CHAR                            szVideoChlID[NETDEV_LEN_64];                        /* ID[0,32] */
    CHAR                            szAudioChlID[NETDEV_LEN_64];                        /* ID[0,32] */
    UINT32                          udwExpire;                                          /* [3600,36000] */
    CHAR                            szAddress[NETDEV_IPADDR_STR_MAX_LEN];               /* IPv4 */
    UINT32                          udwPort;                                            
    BYTE                            byRes[256];                                         
}NETDEV_MANAGER_SERVER_INFO_S, *LPNETDEV_MANAGER_SERVER_INFO_S;

/**
 * @struct tagNETDEVManagerServerList
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVManagerServerList
{
    UINT32                          udwNum;                                               /*  2 */
    NETDEV_MANAGER_SERVER_INFO_S    astManagerServerList[NETDEV_MANAGER_SERVER_MAX_NUM];  
    BYTE                            byRes[128];                                           
}NETDEV_MANAGER_SERVER_LIST_S, *LPNETDEV_MANAGER_SERVER_LIST_S;

/*
* @struct tagNETDEVSmartAttrConfig
* @brief 
* @attention
*/
typedef struct tagNETDEVFaceConfig
{
    UINT32          udwCondition;   /* 0() 1 */
    BYTE            byRes[512];     
}NETDEV_FACE_CFG_S, LPNETDEV_FACE_CFG_S;

/*
* @struct tagNETDEVSmartAttrConfig
* @brief 
* @attention
*/
typedef struct tagNETDEVTempConfig
{
    UINT32          udwCondition;                 /* 012 */
    CHAR            szThreshold[NETDEV_LEN_64];   /*   2 */
    CHAR            szdwRange[NETDEV_LEN_64];     /*   2 [0.00, 10.00] */
    BYTE            byRes[512];                   
}NETDEV_TEMP_CFG_S, LPNETDEV_TEMP_CFG_S;

/*
* @struct tagNETDEVSmartAttrConfig
* @brief 
* @attention
*/
typedef struct tagNETDEVSmartAttrConfig
{
    NETDEV_FACE_CFG_S   stFaceCfg;             
    NETDEV_TEMP_CFG_S   stTempCfg;             
    BYTE                byRes[512];            
}NETDEV_SMART_ATTR_CFG_S, *LPNETDEV_SMART_ATTR_CFG_S;

/**
 * @struct tagNETDEVVisibleRangeInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVVisibleRangeInfo
{
    DOUBLE                          dAzimuthHorizontal;                                 /* : :[-1.0000,+1.0000] */
    DOUBLE                          dAzimuthVertical;                                   /* :4 :[-1.0000,+1.0000] */
    DOUBLE                          dInclinationHorizontal;                             /*  :4 :[-1.0000,+1.0000] */
    DOUBLE                          dAngelHorizontal;                                   /*  :4 */
    DOUBLE                          dAngelVertical;                                     /*  :4 */
    DOUBLE                          dDistance;                                          /*  :4 */
    DOUBLE                          dInstallationHeight;                                /*  4 */
    BYTE                            byRes[248];                                         
}NETDEV_VISIBLE_RANGE_INFO_S, *LPNETDEV_VISIBLE_RANGE_INFO_S;

/**
 * @struct tagNETDEVCustomProSimpleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCustomProSimpleInfo
{
    UINT32                                          udwProID;                                       /* ,  */
    CHAR                                            szProName[NETDEV_LEN_64];                       /* [0, 64] */
    BYTE                                            byRes[128];                                     
}NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S,* LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S;

/**
 * @struct tagNETDEVCustomProSimpleInfoList
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCustomProSimpleInfoList
{
    UINT32                                          udwNum;                                         /* , 64 */
    NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S            astCustomProSimpleList[NETDEV_LEN_64];          
    BYTE                                            byRes[512];                                     
}NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S,* LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S;

/*
 * @struct tagNETDEVCustomStreamInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCustomStreamInfo
{
    UINT32                                          udwEnable;                                      /* 1:; 0: */
    CHAR                                            szStreamURL[NETDEV_LEN_128];                    /* URL[0, 128] */
    CHAR                                            szPlaybackStreamURL[NETDEV_LEN_128];            /* URL[0, 128] */
    BYTE                                            byRes[384];                                     
}NETDEV_CUSTON_STREAM_INFO_S,* LPNETDEV_CUSTON_STREAM_INFO_S;

/**
 * @struct tagNETDEVCustomProInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCustomProInfo
{
    UINT32                                          udwTransport;                                   /* ,  NETDEV_TRANS_PROTOCOL_E */
    UINT32                                          udwPort;                                        
    NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S            stCustomProSimpleInfo;                          
    NETDEV_CUSTON_STREAM_INFO_S                     stMainStream;                                   
    NETDEV_CUSTON_STREAM_INFO_S                     stSubStream;                                    
    NETDEV_CUSTON_STREAM_INFO_S                     stThirdStream;                                  
    BYTE                                            byRes[512];                                     
}NETDEV_CUSTON_PROTOCOL_INFO_S,* LPNETDEV_CUSTON_PROTOCOL_INFO_S;

/**
 * @struct tagNETDEVHDDSmartInfo
 * @brief Smart
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartInfo
{
    UINT32                          udwID;                                              /* IN  */
    CHAR                            szManufacturer[NETDEV_LEN_64];                      
    UINT32                          udwTemperature;                                     /* () */
    CHAR                            szDeviceModel[NETDEV_LEN_64];                       
    UINT32                          udwUsedDays;                                        
    UINT32                          udwHealthAssessment;                                /*  # NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E */
    CHAR                            szFirmware[NETDEV_LEN_64];                          
    UINT32                          udwSmartNum;                                        /* Smart */
    NETDEV_HDD_SMART_DETAILS_INFO_S SmartDetailsInfoList[NETDEV_DISK_SMART_MAX_NUM];    /* Smart */
    BOOL                            bCheckResult;                                       /* , TRUE FALSE  */
    UINT32                          udwCheckPrograss;                                   /*  [0,100] */
    UINT32                          udwCheckStatus;                                     /*  # NETDEV_HDD_SMART_CHECK_STATUS_E */
    UINT32                          udwCheckType;                                       /*  # NETDEV_HDD_SMART_CHECK_TYPE_E */
    BYTE                            byRes[128];                                         
}NETDEV_HDD_SMART_INFO_S,*LPNETDEV_HDD_SMART_INFO_S;

/*
* @struct tagDNSAddress
* @brief DNS
* @attention  None
*/
typedef struct tagDNSAddress
{
    UINT32  udwAddressType;                 /*IP 0: IPv4  1: IPv6 3: IPv4IPv6 IPv4 */
    CHAR   szIPAddress[NETDEV_LEN_64];      /*IPv4*/
    CHAR   szIPv6Address[NETDEV_LEN_64];    /*IPv6*/
    BYTE   byRes[128];                      /*   Reserved */
}NETDEV_DNS_ADDRESS_S, *LPNETDEV_DNS_ADDRESS_S;

/*
* @struct tagNETDEVDNSInfo
* @brief DNS device DNS Info
* @attention  None
*/
typedef struct tagNETDEVDNSInfo
{
    UINT32                  udwNum;                             /*DNS*/
    NETDEV_DNS_ADDRESS_S    astDNSList[NETDEV_DNS_LIST_NUM];    /*DNS122*/
    BYTE                    byRes[128];                         /*   Reserved */
}NETDEV_DNS_INFO_S, *LPNETDEV_DNS_INFO_S;

/*
* @struct tagIpv6Addressinfo
* @brief IPV6
* @attention  None
*/
typedef struct tagIpv6Addressinfo
{
    UINT32  udwPrefixLenth;             /*[3,127]*/
    CHAR    szAddress[NETDEV_LEN_64];   /*IP*/
    CHAR    szGateway[NETDEV_LEN_64];   
}NETDEV_IPV6_ADDRESS_INFO_S, *LPNETDEV_IPV6_ADDRESS_INFO_S;

/*
* @struct tagNetWorkIpv6info
* @brief IPV6
* @attention  None
*/
typedef struct tagNetWorkIpv6info
{
    UINT32                      udwIPGetType;                           /*IP*/
    UINT32                      udwAddressNum;                          /*IP*/
    NETDEV_IPV6_ADDRESS_INFO_S  astIPv6AddressInfo[NETDEV_LEN_8];       /*IPv6IPv6*/
}NETDEV_NETWORK_IPV6_INFO_S, *LPNETDEV_NETWORK_IPV6_INFO_S;

/*
* @struct tagIpv4Addressinfo
* @brief IPV4
* @attention  None
*/
typedef struct tagIpv4Addressinfo
{
    CHAR   szAddress[NETDEV_LEN_64];                /*IP*/
    CHAR   szNetmask[NETDEV_LEN_64];                
    CHAR   szGateway[NETDEV_LEN_64];                
}NETDEV_IPV4_ADDRESS_INFO_S, *LPNETDEV_IPV4_ADDRESS_INFO_S;

/*
* @struct tagIpv4info
* @brief IPV4
* @attention  None
*/
typedef struct tagNetWorkIpv4info
{
    UINT32                      udwIPGetType;                       /*IP 0for static 1for PPPOE2for DHCP*/
    CHAR                        szLoginName[NETDEV_LEN_64];         /*PPPoE*/
    CHAR                        szPIN[NETDEV_LEN_128];              /*PPPOEMD5*/
    UINT32                      udwAddressNum;                      /*IP*/
    NETDEV_IPV4_ADDRESS_INFO_S  astIPv4AddressInfo[NETDEV_LEN_8];   /*IPv4IPv4*/
}NETDEV_NETWORK_IPV4_INFO_S, *LPNETDEV_NETWORK_IPV4_INFO_S;

/*
* @struct tagNETDEVNetworkInterfaceInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVNetworkInterfaceInfo
{
    UINT32                     udwID;                                             /*VMSIPC1 NVR*/
    CHAR                       szName[NETDEV_NAME_MAX_LEN];                       /*NVRIPC*/
    UINT32                     udwWorkMode;                                       /* 0 1  2*/
    BOOL                       bIsInnerNIC;                                       
    CHAR                       szInnerNICIPAddress[NETDEV_IPADDR_STR_MAX_LEN];    /*IP*/
    CHAR                       szInnerNICNetmask[NETDEV_IPADDR_STR_MAX_LEN];      
    CHAR                       szInnerNICName[NETDEV_NAME_MAX_LEN];               
    UINT32                     udwMTU;                                            /*MTU[576,1500]*/
    CHAR                       szMAC[NETDEV_NETWORK_MACNAME_LEN];                 /*MAC[0, 48]*/
    UINT32                     udwNegotiationMode;                                
    NETDEV_NETWORK_IPV4_INFO_S stIPV4Infos;                                       /*IPv4IPv4*/
    NETDEV_NETWORK_IPV6_INFO_S stIPV6Infos;                                       /*IPv6IPv6*/
    BYTE                       byRes[128];                                        /*   Reserved */
}NETDEV_NETWORK_INTERFACE_INFO_S, *LPNETDEV_NETWORK_INTERFACE_INFO_S;

/*
* @struct tagNETDEVNetworkCardsInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVNetworkCardsInfo
{
    UINT32                              udwNum;                                     
    UINT32                              udwDefaultRouteNIC;                         /*ID*/
    UINT32                              udwWorkMode;                                /* 0 1  2*/
    NETDEV_NETWORK_INTERFACE_INFO_S     astNetworkInterfaceList[NETDEV_LEN_8];      /*Num0*/
    BYTE                                byRes[128];                                 /*   Reserved */
}NETDEV_NETWORK_CARD_INFO_S, *LPNETDEV_NETWORK_CARD_INFO_S;

/**
* @struct tagNETDEVFGSubInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVFGSubInfo
{
    UINT32 udwType;                         /*   NETDEV_SUB_TYPE_E */
    UINT32 udwLibIDNum;                     /* ID LibIDNum16  */
    UINT32 audwLibIDList[NETDEV_LEN_32];    /* ID */
    BYTE   byRes[128];                      
}NETDEV_FG_SUB_INFO_S,*LPNETDEV_FG_SUB_INFO_S;

/**
* @struct tagNETDEVFGSubSuccInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVFGSubSuccInfo
{
    UINT32 udwID;                   /* ID */
    UINT32 udwCurrrntTime;          /* UTC */
    UINT32 udwTerminationTime;      /* UTC */
    BYTE   byRes[128];              
}NETDEV_FG_SUB_SUCC_INFO_S,*LPNETDEV_FG_SUB_SUCC_INFO_S;

/**
* @struct tagNETDEVFileInfo
* @brief 
* @attention udwSize0pcData,szUrl
*/
typedef struct tagNETDEVFileInfo
{
    CHAR   szName[NETDEV_LEN_64];   /*  [1, 16]*/
    UINT32 udwSize;                 /* [dataszurl(Base64)] */
    UINT32 dwFileType;              /* : NETDEV_FILE_TYPE_E */
    UINT32 udwLastChange;           /* UTCs */
    CHAR   *pcData;                 /*  Base64 udwSize */
    CHAR   szUrl[NETDEV_LEN_512];   /* URL[0,256] */
    BYTE   byRes[128];              
}NETDEV_FILE_INFO_S,*LPNETDEV_FILE_INFO_S;

/**
* @struct tagNETDEVFeatureInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVFeatureInfo
{
    CHAR    szFeatureVersion[NETDEV_LEN_32];        /*  [0, 20] */
    CHAR    szFeature[NETDEV_FACE_FEATURE_SIZE];    /*  512B */
    BYTE    byRes[128];                             
}NETDEV_FEATURE_INFO_S,*LPNETDEV_FEATURE_INFO_S;

/**
* @struct tagNETDEVRegionInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVRegionInfo
{
    CHAR szNation[NETDEV_LEN_128];          /* [1-63] */
    CHAR szProvince[NETDEV_LEN_128];        /* [1-63] */
    CHAR szCity[NETDEV_LEN_128];            /* [1-63] */
    BYTE byRes[256];                        
}NETDEV_REGION_INFO_S, *LPNETDEV_REGION_INFO_S;

/**
* @struct tagNETDEVPersonTimeTemplateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonTimeTemplateInfo
{
    UINT32 udwBeginTime;    /*  0 */
    UINT32 udwEndTime;      /*  4294967295(0xFFFFFFFF)*/
    UINT32 udwIndex;        
    BYTE   byRes[128];      
}NETDEV_PERSON_TIME_TEMPLATE_INFO_S,*LPNETDEV_PERSON_TIME_TEMPLATE_INFO_S;

/**
* @struct tagNETDEVIdentificationInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVIdentificationInfo
{
    UINT32 udwType;                     /*   NETDEV_ID_TYPE_E*/
    CHAR   szNumber[NETDEV_LEN_128];    /* :[1, 127] */
    BYTE   byRes[32];                  
}NETDEV_IDENTIFICATION_INFO_S,*LPNETDEV_IDENTIFICATION_INFO_S;

/**
* @struct tagNETDEVImageInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVImageInfo
{
    UINT32             udwFaceID;                   /* ID */
    NETDEV_FILE_INFO_S stFileInfo;                  
    UINT32             udwModelStatus;              /* ,: NETDEV_MODEL_STATUS_E  ModelStatus,See NETDEV_MODEL_STATUS_E for details*/
    BYTE               byRes[124];                  
}NETDEV_IMAGE_INFO_S,*LPNETDEV_IMAGE_INFO_S;

/**
 * @struct tagNETDEVCustomValue
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCustomValue
{
    UINT32  udwID;                                         /*  0*/
    CHAR    szValue[NETDEV_FACE_MEMBER_CUSTOM_LEN];        /*  [1,63]*/
    UINT32  udwModelStatus;                                /* ,: NETDEV_MODEL_STATUS_E  ModelStatus,See NETDEV_MODEL_STATUS_E for details*/
    BYTE    byRes[124];                                    /*   Reserved */
}NETDEV_CUSTOM_VALUE_S,*LPNETDEV_CUSTOM_VALUE_S;

/**
 * @struct tagNETDEVStaffInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVStaffInfo
{
    CHAR   szNumber[NETDEV_LEN_32];                       /*  [1, 16] */
    CHAR   szBirthday[NETDEV_LEN_32];                     /*  [1,31] */
    UINT32 udwDeptID;                                     /* ID */
    CHAR   szDeptName[NETDEV_LEN_256];                    /*   [1, 64] */
    BYTE   byRes[256];                                    /*   Reserved */
}NETDEV_STAFF_INFO_S,*LPNETDEV_STAFF_INFO_S;

/**
 * @struct tagNETDEVVisitorInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVVisitorInfo
{
    UINT32 udwVisitorCount;                               
    CHAR   szCompany[NETDEV_LEN_256];                     /*  [1, 64] */
    UINT32 udwIntervieweeID;                              /* ID */
    BYTE   byRes[256];                                    /*   Reserved */
}NETDEV_VISITOR_INFO_S,*LPNETDEV_VISITOR_INFO_S;

/**
* @struct tagNETDEVPersonInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonInfo
{
    UINT32                                  udwPersonID;                         /* ID */
    UINT32                                  udwLastChange;                       
    CHAR                                    szPersonName[NETDEV_LEN_256];        /*  :[1, 63] */
    UINT32                                  udwGender;                           /*   NETDEV_GENDER_TYPE_E */
    CHAR                                    szBirthday[NETDEV_LEN_64];           /* YYYYMMDD[1,31] */
    NETDEV_REGION_INFO_S                    stRegionInfo;                        
    UINT32                                  udwTimeTemplateNum;                  
    LPNETDEV_PERSON_TIME_TEMPLATE_INFO_S    pstTimeTemplateList;                 
    UINT32                                  udwIdentificationNum;                /*  :[0, 6]*/
    NETDEV_IDENTIFICATION_INFO_S            stIdentificationInfo[NETDEV_LEN_8];  
    UINT32                                  udwImageNum;                         /*  :[0, 6] */
    NETDEV_IMAGE_INFO_S                     stImageInfo[NETDEV_LEN_8];           
    UINT32                                  udwReqSeq;                           
    BOOL                                    bIsMonitored;                        /* VMS */
    UINT32                                  udwBelongLibNum;                     /* VMS */
    UINT32                                 *pudwBelongLibList;                   /* IDVMS */
    UINT32                                  udwCustomNum;                        /* 5VMS */
    LPNETDEV_CUSTOM_VALUE_S                 pstCustomValueList;                  /* Num0 */
    CHAR                                    szTelephone[NETDEV_LEN_64];          /*  [1,64] */
    CHAR                                    szAddress[NETDEV_LEN_256];           /*  [1, 64] */
    UINT32                                  udwCardNum;                          /*  [0,6],Get */
    UINT32                                  udwFingerprintNum;                   /* [0,10] */
    UINT32                                  udwType;                             /*  0 1 2*/
    NETDEV_STAFF_INFO_S                     stStaff;                             
    NETDEV_VISITOR_INFO_S                   stVisitor;                           
    CHAR                                    szDesc[NETDEV_LEN_480];              /*  [1, 128] */
    CHAR                                    szPersonCode[NETDEV_LEN_16];         /* :[1, 15] PTS */
    CHAR                                    szRemarks[NETDEV_LEN_64];            /*  :[1-63] PTS */
    BYTE                                    byRes[176];                          
}NETDEV_PERSON_INFO_S,*LPNETDEV_PERSON_INFO_S;

/**
* @struct tagNETDEVCtrlFaceInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVCtrlFaceInfo
{
    UINT32                      udwID;                      /* ID */
    UINT32                      udwTimestamp;               /*  UTC */
    UINT32                      udwCapSrc;                  /*   NETDEV_CAP_SRC_E FaceInfo1 */
    UINT32                      udwFeatureNum;              /*  [0, 2] */
    LPNETDEV_FEATURE_INFO_S     pstFeatureInfo;             
    NETDEV_FILE_INFO_S          stPanoImage;                
    NETDEV_FILE_INFO_S          stFaceImage;                
    NETDEV_FACE_POSITION_INFO_S stFaceArea;                 
    FLOAT                       fTemperature;               /*  1 */
    UINT32                      udwMaskFlag;                /* 012*/
    BYTE                        byRes[120];                 
}NETDEV_CTRL_FACE_INFO_S,*LPNETDEV_CTRL_FACE_INFO_S;

/**
* @struct tagNETDEVCtrlGateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVCtrlGateInfo
{
    UINT32 udwID;               /* ID */
    UINT32 udwTimestamp;        
    UINT32 udwCapSrc;           /*   NETDEV_CAP_SRC_E GateInfo4 */
    UINT32 udwInPersonCnt;      
    UINT32 udwOutPersonCnt;     
    BYTE   byRes[128];          
}NETDEV_CTRL_GATE_INFO_S,*LPNETDEV_CTRL_GATE_INFO_S;

/**
* @struct tafNETDEVCtrlCardInfo
* @brief 
* @attention  None
*/
typedef struct tafNETDEVCtrlCardInfo
{
    UINT32 udwID;                                       /* ID */
    UINT32 udwTimestamp;                                /*  UTC */
    UINT32 udwCapSrc;                                   /*   NETDEV_CAP_SRC_E CardInfo23*/
    UINT32 udwCardType;                                 /* 01 */
    CHAR   szCardID[NETDEV_LEN_32];                     /*  18*/
    UINT32 udwCardStatus;                               /*  */
    CHAR   szName[NETDEV_LEN_256];                      /*  [1,63] */
    UINT32 udwGender;                                   /*   NETDEV_GENDER_TYPE_E */
    CHAR   szBirthday[NETDEV_LEN_16];                   /*  YYYYMMDD */
    CHAR   szResidentialAddress[NETDEV_LEN_128];        /*  */
    CHAR   szIdentityNo[NETDEV_LEN_32];                 /*  */
    CHAR   szIssuingAuthority[NETDEV_LEN_128];          /*  */
    CHAR   szIssuingDate[NETDEV_LEN_16];                /*  YYYYMMDD */
    CHAR   szValidDateStart[NETDEV_LEN_16];             /*  */
    CHAR   szValidDateEnd[NETDEV_LEN_16];               /*  */
    NETDEV_FILE_INFO_S stIDImage;                       
    BYTE   byRes[132];                                  
}NETDEV_CTRL_CARD_INFO_S,*LPNETDEV_CTRL_CARD_INFO_S;

/**
* @struct tagNETDEVMatchPersonInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVMatchPersonInfo
{
    CHAR   szPersonName[NETDEV_LEN_256];        /*  [1,63] */
    UINT32 udwGender;                           /*   NETDEV_GENDER_TYPE_E */
    CHAR   szCardID[NETDEV_LEN_32];             
    CHAR   szIdentityNo[NETDEV_LEN_32];         
    CHAR   szPersonCode[NETDEV_LEN_64];         /*   :[1, 15] */
    BYTE   byRes[64];                           
}NETDEV_MATCH_PERSON_INFO_S,*LPNETDEV_MATCH_PERSON_INFO_S;

/**
* @struct tagNETDEVCtrlLibMatchInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVCtrlLibMatchInfo
{
    UINT32                     udwID;                                   /* ID */
    UINT32                     udwLibID;                                /* ID */
    UINT32                     udwLibType;                              
    UINT32                     udwMatchStatus;                          /*   NETDEV_MATCH_STATUS_E */
    UINT32                     udwMatchPersonID;                        /* ID */
    UINT32                     udwMatchFaceID;                          /* ID */
    NETDEV_MATCH_PERSON_INFO_S stMatchPersonInfo;                       
    BYTE                       byRes[128];                              
}NETDEV_CTRL_LIB_MATCH_INFO_S,*LPNETDEV_CTRL_LIB_MATCH_INFO_S;

/**
* @struct tagNETDEVCtrlTemperatureInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVCtrlTemperatureInfo
{
    UINT32          udwRelativeFaceID;          /* ID0xffffffff */
    FLOAT           fEnvTemperature;            /*   */
    FLOAT           fTemperatureThreshold;      /*  */
    FLOAT           fBodyTemperature;           /*  */
    BYTE            byRes[256];                 
}NETDEV_CTRL_TEMPERATURE_INFO, *LPNETDEV_CTRL_TEMPERATURE_INFO;

/**
* @struct tagNETDEVPersonVerification
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonVerification
{
    CHAR                            szReference[NETDEV_LEN_128];             /* url */
    UINT32                          udwSeq;                                  
    UINT32                          udwChannelID;                            /* ID VMS*/
    CHAR                            szChannelName[NETDEV_LEN_256];           /*  [1,64]VMS */
    UINT32                          udwTimestamp;                            /*  UTC*/
    UINT32                          udwNotificationType;                     /*  01 */
    UINT32                          udwFaceInfoNum;                          /*  [0, 1] */
    LPNETDEV_CTRL_FACE_INFO_S       pstCtrlFaceInfo;                         
    UINT32                          udwCardInfoNum;                          /*  [0, 1] */
    LPNETDEV_CTRL_CARD_INFO_S       pstCtrlCardInfo;                         
    UINT32                          udwGateInfoNum;                          /*  [0, 1] */
    LPNETDEV_CTRL_GATE_INFO_S       pstCtrlGateInfo;                         
    UINT32                          udwLibMatInfoNum;                        /*  [0, 16] */
    LPNETDEV_CTRL_LIB_MATCH_INFO_S  pstLibMatchInfo;                         
    UINT32                          udwTemperatureInfoNum;                   
    LPNETDEV_CTRL_TEMPERATURE_INFO  pstTemperatureInfo;                      
    BYTE                            byRes[120];                              
}NETDEV_PERSON_VERIFICATION_S,*LPNETDEV_PERSON_VERIFICATION_S;

/**
 * @struct tagNETDEVPersonAttr
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonAttr
{
    UINT32 udwGender;                                     /*   NETDEV_GENDER_TYPE_E */
    UINT32 udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
    UINT32 udwSleevesLength;                              /*   NETDEV_SLEEVES_LENGTH_E */
    UINT32 udwCoatColor;                                  /*   NETDEV_CLOTHES_COLOR_E */
    UINT32 udwTrousersLength;                             /*   NETDEV_TROUSERS_LENGTH_E */
    UINT32 udwTrousersColor;                              /*   NETDEV_CLOTHES_COLOR_E */
    UINT32 udwBodyToward;                                 /*   NETDEV_BODY_TOWARD_E */
    UINT32 udwShoesTubeLength;                            /*   NETDEV_SHOES_TUBE_LENGTH_E */
    UINT32 udwHairLength;                                 /*   NETDEV_HAIR_LENGTH_E */
    UINT32 udwBagFlag;                                    /*   NETDEV_BAG_FLAG_E */
    FLOAT  fTemperature;                                  /*   2 */
    UINT32 udwMask;                                       /*   NETDEV_PERSON_MASK_FLAG_E */
    UINT32 udwCoatTexture;                                /*   NETDEV_CLOTHES_TEXTURE_E */
    UINT32 udwMovingDirection;                            /*   NETDEV_MOVE_DIRECTION_E */
    BYTE   byRes[116];                                    
}NETDEV_PERSON_ATTR_S,*LPNETDEV_PERSON_ATTR_S;

/**
 * @struct tagNETDEVFaceAttr
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVFaceAttr
{
    UINT32 udwGender;                                     /*   NETDEV_GENDER_TYPE_E */
    UINT32 udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
    UINT32 udwGlassFlag;                                  /*   NETDEV_GLASS_FLAG_E */
    UINT32 udwGlassesStyle;                               /*   NETDEV_GLASSES_STYLE_E */
    UINT32 udwMask;                                       /*   NETDEV_MASK_FLAG_E */
    FLOAT fTemperature;                                   /*   2 */
    UINT32 udwEmotion;                                    /*   NETDEV_EMOTION_FLAG_E */
    UINT32 udwSmile;                                      /*   NETDEV_SMILE_FLAG_E */
    UINT32 udwAttractive;                                 /*  [0~100] */
    UINT32 udwSkinColor;                                  /*   NETDEV_SKINCOLOR_TYPE_E */
    UINT32 udwBeard;                                      /*   NETDEV_BEARD_FLAG_E */
    UINT32 udwHatStyle;                                   /*   NETDEV_HAT_STYLE_E */
    UINT32 udwHatColor;                                   /*   NETDEV_VEHICLE_COLOR_E */
    BYTE   byRes[104];                                    
}NETDEV_FACE_ATTR_S,*LPNETDEV_FACE_ATTR_S;

/**
* @struct tagNETDEVPersonCompareInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVPersonCompareInfo
{
    UINT32                      udwSimilarity;                                  
    NETDEV_PERSON_INFO_S        stPersonInfo;                                   
    NETDEV_FILE_INFO_S          stPanoImage;                                    
    NETDEV_FILE_INFO_S          stFaceImage;                                    
    NETDEV_FACE_POSITION_INFO_S stFaceArea;                                     
    UINT32                      udwCapSrc;                                      
    UINT32                      udwFeatureNum;                                  /*   PTS */
    LPNETDEV_FEATURE_INFO_S     pstFeatureInfo;                                 /*    PTS */
    NETDEV_FACE_ATTR_S          stFaceAttr;                                     
    NETDEV_PERSON_ATTR_S        stPersonAttr;                                   
    BYTE                        byRes[248];                                     
}NETDEV_PERSON_COMPARE_INFO_S, *LPNETDEV_PERSON_COMPARE_INFO_S;

/**
* @struct tagNETDEVFacePassRecordInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVFacePassRecordInfo
{
    UINT32                              udwRecordID;                        /* ID */
    UINT32                              udwType;                            /*  NETDEV_FACE_PASS_RECORD_TYPE_E */
    INT64                               tPassingTime;                       /* UTC */
    UINT32                              udwChannelID;                       /* ID */
    CHAR                                szChlName[NETDEV_LEN_128];          /* [1,63] */
    NETDEV_PERSON_COMPARE_INFO_S        stCompareInfo;                      
    BYTE                                byRes[256];                         
}NETDEV_FACE_PASS_RECORD_INFO_S, *LPNETDEV_FACE_PASS_RECORD_INFO_S;

/**
* @struct tagNETDEVPersonEventInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonEventInfo
{
    UINT32                          udwID;                                   /* ID */
    UINT32                          udwTimestamp;                            /*  UTC*/
    UINT32                          udwNotificationType;                     /*  01 */
    UINT32                          udwFaceInfoNum;                          /*  [0, 1] */
    NETDEV_FACE_PASS_RECORD_INFO_S  stCtrlFaceInfo[NETDEV_LEN_2];            /* FaceInfo */
    UINT32                          udwFinishFaceNum;                        /*  [0, 40] */
    UINT32                          audwFinishFaceList[NETDEV_LEN_40];       
    CHAR                            szReference[NETDEV_LEN_480];             
    BYTE                            byRes[92];                               
}NETDEV_PERSON_EVENT_INFO_S, *LPNETDEV_PERSON_EVENT_INFO_S;

/**
* @struct tagNETDEVUpdateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVUpdateInfo
{
    UINT32 udwID;               /* ID */
    UINT32 udwLastChange;       
    BYTE   byRes[128];          
}NETDEV_UPDATE_INFO_S,*LPNETDEV_UPDATE_INFO_S;

/**
* @struct tagNETDEVTimeTemplateUdateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVTimeTemplateUpdateInfo
{
    UINT32                udwNum;                                          /*  [0, 32] */
    NETDEV_UPDATE_INFO_S  stUpdateInfo[NETDEV_LEN_64];                     
    BYTE                  byRes[128];                                      
}NETDEV_TIME_TEMPLATE_UPDATE_INFO_S,*LPNETDEV_TIME_TEMPLATE_UPDATE_INFO_S;

/**
* @struct tagNETDEVExceptionDayInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVExceptionDayInfo
{
    UINT32                     udwID;                                        
    BOOL                       bEnabled;                                     
    CHAR                       szDate[NETDEV_LEN_16];                        /*  year-month-day */
    UINT32                     udwNum;                                       /*  NVR8 IPC/PTS4*/
    NETDEV_TIME_SECTION_INFO_S stTimeSectionInfo[NETDEV_LEN_16];             
    BYTE                       byRes[128];                                   
}NETDEV_EXCEPTION_DAY_INFO_S,*LPNETDEV_EXCEPTION_DAY_INFO_S;

/**
* @struct tagNETDEVExceptionInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVExceptionInfo
{
    BOOL                        bEnabled;                                    /*  0: 1 */
    UINT32                      udwNum;                                      /*  [0, 16] */
    NETDEV_EXCEPTION_DAY_INFO_S stExceptionDayInfo[NETDEV_LEN_32];           
    BYTE                        byRes[128];                                  
}NETDEV_EXCEPTION_INFO_S,*LPNETDEV_EXCEPTION_INFO_S;

/**
* @struct tagNETDEVTimeTemplateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVTimeTemplateInfo
{
    UINT32                  udwID;                  
    CHAR                    szName[NETDEV_LEN_256]; /*  [1, 63] */
    UINT32                  udwLastChange;          
    NETDEV_WEEK_PLAN_INFO_S stWeekPlanInfo;         
    NETDEV_EXCEPTION_INFO_S stExceptionInfo;        
    BYTE                    byRes[128];             
}NETDEV_TIME_TEMPLATE_INFO_S,*LPNETDEV_TIME_TEMPLATE_INFO_S;

/**
* @struct tagNETDEVSystemTimeTemplate
* @brief (PTS VMS)
* @attention  None
*/
typedef struct tagNETDEVSystemTimeTemplate
{
    UINT32                  udwTemplateID;                           /* ID */
    CHAR                    szTemplateName[NETDEV_LEN_256];          /*  [1, 63] */
    CHAR                    szTemplateDesc[NETDEV_LEN_512];          /*  [1, 128] */
    UINT32                  udwLastChange;                           
    NETDEV_WEEK_PLAN_INFO_S stWeekPlanInfo;                          
    NETDEV_EXCEPTION_INFO_S stExceptionInfo;                         
    BOOL                    bIsBuiltin;                              /*  VMS 1: 0: */
    UINT32                  udwTemplateType;                         /*  VMS 0: 1: 2: */
    BYTE                    byRes[128];                              
}NETDEV_SYSTEM_TIME_TEMPLATE_S,*LPNETDEV_SYSTEM_TIME_TEMPLATE_S;

/**
* @struct tagNETDEVSinglePersonUpdateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVSinglePersonUpdateInfo
{
    BOOL   bPersonExisted;      
    UINT32 udwLastChange;       
    BYTE   byRes[128];          
}NETDEV_SINGLE_PERSON_UPDATE_INFO_S,*LPNETDEV_SINGLE_PERSON_UPDATE_INFO_S;

/**
* @struct tagNETDEVPagedQueryInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPagedQueryInfo
{
    UINT32 udwLimit;        
    UINT32 udwOffset;       
    BYTE   byRes[128];      
}NETDEV_PAGED_QUERY_INFO_S,*LPNETDEV_PAGED_QUERY_INFO_S;

/**
* @struct tagNETDEVPersonUpdateInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonUpdateInfo
{
    UINT32 udwPersonID;         /* ID */
    UINT32 udwLastChange;       
    BYTE   byRes[128];          
}NETDEV_PERSON_UPDATE_INFO_S,*LPNETDEV_PERSON_UPDATE_INFO_S;

/**
* @struct tagNETDEVPersonUpdateInfoList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonUpdateInfoList
{
    UINT32 udwTotal;                                                
    UINT32 udwOffset;                                               
    UINT32 udwNum;                                                  /*  1000 */
    NETDEV_PERSON_UPDATE_INFO_S stPersonList[NETDEV_LEN_1024];      
    BYTE   byRes[128];                                              
}NETDEV_PERSON_UPDATE_INFO_LIST_S,*LPNETDEV_PERSON_UPDATE_INFO_LIST_S;

/**
* @struct tagNETDEVPersonInfoList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonInfoList
{
    UINT32                      udwNum;                   
    LPNETDEV_PERSON_INFO_S      pstPersonInfo;            /* , */
    BYTE                       byRes[128];                
}NETDEV_PERSON_INFO_LIST_S,*LPNETDEV_PERSON_INFO_LIST_S;

/**
* @struct tagNETDEVFaceInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVFaceInfo
{
    UINT32 udwFaceID;           /* ID */
    UINT32 udwResultCode;       /* # NETDEV_PERSON_RESULT_CODE_E */
    BYTE   byRes[128];          
}NETDEV_FACE_INFO_S,*LPNETDEV_FACE_INFO_S;

/**
* @struct tagNETDEVPersonList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonList
{
    UINT32             udwPersonID;                     /* ID */
    UINT32             udwFaceNum;                      /*  6 */
    NETDEV_FACE_INFO_S stFaceInfo[NETDEV_LEN_8];        
    UINT32             udwReqseq;                       /* ,VMS */
    BYTE               byRes[128];                      
}NETDEV_PERSON_LIST_S,*LPNETDEV_PERSON_LIST_S;

/**
* @struct tagNETDEVPersonResultList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonResultList
{
    UINT32                 udwNum;                          
    LPNETDEV_PERSON_LIST_S pstPersonList;                   /* , malloc by caller */
    BYTE                   byRes[128];                      
}NETDEV_PERSON_RESULT_LIST_S,*LPNETDEV_PERSON_RESULT_LIST_S;

/**
* @struct tagNETDEVLibInfo
* @brief 
* @attention 
*/
typedef struct tagNETDEVLibInfo
{
    UINT32 udwID;                           /* ID */
    CHAR   szName[NETDEV_LEN_256];          /*  [1,63] */
    UINT32 udwType;                         /*   NETDEV_PEOPLE_LIB_TYPE_E */
    UINT32 udwPersonNum;                    
    UINT32 udwFaceNum;                      
    UINT32 udwMemberNum;                    
    UINT32 udwLastChange;                   
    CHAR   szBelongIndex[NETDEV_LEN_256];   
    BOOL   bIsMonitored;                    
    BYTE   byRes[128];                      
}NETDEV_LIB_INFO_S,*LPNETDEV_LIB_INFO_S;

/**
* @struct tagNETDEVPersonLibList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPersonLibList
{
    UINT32              udwNum;                     
    LPNETDEV_LIB_INFO_S pstLibInfo;                 /* , */
    BYTE                byRes[128];                 
}NETDEV_PERSON_LIB_LIST_S,*LPNETDEV_PERSON_LIB_LIST_S;

/**
 * @struct tagstNETDEVSmartInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVSmartInfo
{
    INT32      dwChannelID;         /* ID */
    UINT32     udwSubscribeID;      /* ID */
    UINT32     udwCurrrntTime;      /* UTC */
    UINT32     udwEndTime;          /* UTC */
    UINT32     udwSubscribeType;    
    BYTE       byRes[124];          /*   Reserved */
}NETDEV_SMART_INFO_S, *LPNETDEV_SMART_INFO_S;

/**
 * @struct tagstNETDEVSubscribeSmartInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVSubscribeSmartInfo
{
    UINT32   udwNum;                
    UINT32   *pudwSmartType;        /*   NETDEV_SMART_ALARM_TYPE_E udwNum */
    BYTE     byRes[128];            /*   Reserved */
}NETDEV_SUBSCRIBE_SMART_INFO_S, *LPNETDEV_SUBSCRIBE_SMART_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogCond
 * @brief 
 * @attention  16
 */
typedef struct tagstNETDEVQueryInfo
{
    INT32   dwQueryType;                                /* # NETDEV_QUERYCOND_TYPE_E */
    INT32   dwLogicFlag;                                /* #NETDEV_QUERYCOND_LOGICTYPE_E */
    CHAR    szConditionData[NETDEV_CODE_STR_MAX_LEN];   
}NETDEV_QUERY_INFO_S, *LPNETDEV_QUERY_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogCondList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmLogCondList
{
    INT32               dwPageRow;                                          
    INT32               dwFirstRow;                                         
    INT32               dwCondSize;                                         
    NETDEV_QUERY_INFO_S astCondition[NETDEV_LOG_QUERY_COND_NUM];            
}NETDEV_ALARM_LOG_COND_LIST_S, *LPNETDEV_ALARM_LOG_COND_LIST_S;

/**
 * @struct tagstNETDEVAlarmLogInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmLogInfo
{
    INT32 dwAlarmID;                                            /* ID */
    INT32 dwAlarmType;                                          /*  # NETDEV_ALARM_TYPE_E*/
    INT32 dwAlarmSubType;                                       /* ,# NETDEV_ALARM_SUBTYPE_E */
    INT32 dwAlarmLevel;                                         /*  0 1 2 3 4 */
    INT32 dwServerID;                                           
    INT32 dwDevID;                                              /* ID */
    INT32 dwChannelID;                                          /* ID */
    CHAR  szAlarmSrc[NETDEV_NAME_MAX_LEN];                      
    INT64 tAlarmTime;                                           /*  UTC */
    BOOL  bAlarmChecked;                                        /* 0 1 */
    CHAR  szAlarmCheckUser[NETDEV_USERNAME_LEN];                
    INT64 tAlarmCheckTime;                                      /*  UTC */
    CHAR  szAlarmCheckDesc[NETDEV_DESCRIBE_MAX_LEN];            
    INT32 dwAlarmLinkType;                                      
    BOOL  IsAlarmSnapExisted;                                   /*  0 1*/
    INT32 dwAlarmSrcBelong;                                     /* #NETDEV_ALARM_SRC_BELONG_TYPE_E */
    CHAR  szAlarmDetail[NETDEV_DESCRIBE_MAX_LEN];               
    INT32 dwHasRelatedData;                                     /*  0 1 */
    BYTE  byRes[244];                                           
}NETDEV_ALARM_LOG_INFO_S, *LPNETDEV_ALARM_LOG_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogChecked
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmLogChecked
{
    INT32  dwSize;                                               
    INT32* pdwAlarmID;                                           /* IDsize  */
    CHAR   szAlarmDesc[NETDEV_DESCRIBE_MAX_LEN];                 
    BYTE   byRes[128];                                           /*   Reserved */
}NETDEV_ALARMLOG_CHECKED_S, *LPNETDEV_ALARMLOG_CHECKED_S;

/**
 * @struct tagstNETDEVAlarmLogCheckedList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmLogCheckedList
{
    INT32                       dwSize;                                   
    LPNETDEV_ALARMLOG_CHECKED_S pstAlarmLogChecked;                       /* size */
    BYTE                        byRes[128];                               /*   Reserved */
}NETDEV_ALARMLOG_CHECKED_LIST_S, *LPNETDEV_ALARMLOG_CHECKED_LIST_S;

/**
 * @struct tagNETDEVDatabaseInfo
 * @brief   face and Vehicle database information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDatabaseInfo
{
    UINT32   udwFaceDBID;                               
    UINT32   udwFaceDBType;                             /*  # NETDEV_FACE_DB_TYPE_E */
    CHAR     szFaceDBName[NETDEV_FACE_DB_NAME_LEN];     
    BOOL     bMonitored;                                
    UINT32   udwMemberNum;                              
    BYTE     byRes[128];                                /*   Reserved */
}NETDEV_DATABASE_INFO_S,*LPNETDEV_DATABASE_INFO_S;

/**
 * @struct tagstNETDEVAlarmPlanInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanInfo
{
    INT32   dwPlanType;                                         /* # NETDEV_ALARM_PLAN_TYPE_E */
    INT32   dwPlanID;                                           /* ID */
    CHAR    szPlanName[NETDEV_NAME_MAX_LEN];                    
    INT32   dwTimeTamplateID;                                   /* ID */
    CHAR    szTimeTamplateName[NETDEV_NAME_MAX_LEN];            
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];                    
    BOOL    bEnable;                                            
}NETDEV_ALARM_PLANINFO_S, *LPNETDEV_ALARM_PLANINFO_S;

/**
 * @struct tagNETDEVCustomAttrInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCustomAttrInfo
{
    UINT32   udwID;                                         
    BOOL     bEnabled;                                      /*  01*/
    CHAR     szName[NETDEV_FACE_DB_TITLE_NAME_LEN];         
    BYTE     byRes[128];                                    /*   Reserved */
}NETDEV_CUSTOM_ATTR_INFO_S,*LPNETDEV_CUSTOM_ATTR_INFO_S;

/**
 * @struct tagNETDEVMemberInfo
 * @brief / 
 * @attention  None
 */
typedef struct tagNETDEVMemberInfo
{
    UINT32  udwMemberID;                                        /* /ID */
    CHAR    szMemberName[NETDEV_LEN_260];                       /* /[1,63] */
    UINT32  udwStatus;                                          /*  : NETDEV_PERSON_RESULT_CODE_E */
    BYTE    byRes[124];                                         /*   Reserved */
}NETDEV_MEMBER_INFO_S,*LPNETDEV_MEMBER_INFO_S;

/**
 * @struct tagNETDEVMonitorRuleInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVMonitorRuleInfo
{
    BOOL                    bEnabled;                                              
    CHAR                    szName[NETDEV_FACE_MONITOR_RULE_NAME_LEN];             
    CHAR                    szReason[NETDEV_FACE_MONITOR_RULE_REASON_LEN];         
    UINT32                  udwLibNum;                                             /* ,16 */
    UINT32                  audwLibList[NETDEV_LEN_32];                            /* ID */
    UINT32                  udwMonitorType;                                        /* 0,1 */
    UINT32                  udwMultipleValue;                                      /* 1N */
    UINT32                  udwMonitorReason;                                      /*  0 1 2 3 4*/
    CHAR                    szMatchSucceedMsg[NETDEV_LEN_512];                     
    CHAR                    szMatchFailedMsg[NETDEV_LEN_512];                      
    UINT32                  udwMemberNum;                                          /*  [0-32](NVR ) */
    NETDEV_MEMBER_INFO_S    stMemberInfo[NETDEV_LEN_64];                           
    UINT32                  udwChannelNum;                                         
    UINT32                  *pudwMonitorChlIDList;                                 /*  udwChannelNum  */
    UINT32                  udwDevNum;                                             /*  ,VMS */
    UINT32                  audwMonitorDevIDList[NETDEV_LEN_16];                   /*  DevNum,VMS*/
    UINT32                  udwMonitorRuleType;                                    /* 0,1 */
    BYTE                    byRes[240];                                            /*   Reserved */
}NETDEV_MONITION_RULE_INFO_S,*LPNETDEV_MONITION_RULE_INFO_S;

/**
 * @struct tagNETDEVMonitorChlInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVMonitorChlInfo
{
    UINT32                          udwChannelID;                       /* ID IPCVMS */ 
    UINT32                          udwResultCode;                      /*  NETDEV_PERSON_RESULT_CODE_E */
    UINT32                          udwMonitorID;                       /* ID */ 
}NETDEV_MONITION_CHL_INFO_S,*LPNETDEV_MONITION_CHL_INFO_S;

/**
 * @struct tagNETDEVMonitorResultInfo
 * @brief  Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonitorResultInfo
{
    UINT32                              udwChannelNum;                  
    LPNETDEV_MONITION_CHL_INFO_S        pstMonitorChlInfos;             /*    malloc by caller*/
    BYTE                                byRes[250];                     /*   Reserved */
}NETDEV_MONITOR_RESULT_INFO_S,*LPNETDEV_MONITOR_RESULT_INFO_S;

/**
 * @struct tagNETDEVVideoLossRuleInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVVideoLossRuleInfo
{
    BOOL         bEnabled;            /* , 0: 1:*/
    BYTE         byRes[256];          
}NETDEV_VIDEO_LOSS_RULE_INFO_S, *LPNETDEV_VIDEO_LOSS_RULE_INFO_S;

/**
 * @struct tagNETDEVTamperDetectionRuleInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVTamperDetectionRuleInfo
{
    BOOL         bEnabled;              /* , 0: 1:*/
    UINT32       udwSensitivity;        /* [1,100] */
    UINT32       udwDuration;           /* [0, 10]IPC */
    BYTE         byRes[256];            
}NETDEV_TAMPER_DETECTION_RULE_INFO_S, *LPNETDEV_TAMPER_DETECTION_RULE_INFO_S;

/** 
 * @struct tagNETDEVTemperatureDetectionBasicRuleInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTemperatureDetectionBasicRuleInfo
{
    UINT32       udwType;               /* 0123410,12224 */
    INT32        dwCondition;           /* 012 */
    FLOAT        fThreshold;            /* [-20,150]02 */
    FLOAT        fChangeRate;           /* [-170,170]/ */
    FLOAT        fRange;                /* [0,10] */
    UINT32       udwDuration;           /* [1,100] */
    BYTE         byRes[512];            
}NETDEV_TEMP_DETECTION_BASE_RULE_INFO_S,*LPNETDEV_TEMP_DETECTION_BASE_RULE_INFO_S;

/**
 * @struct tagNETDEVTempDetectionCommonRuleInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionCommonRuleInfo
{
    UINT32                                      udwID;                          /* 0[0,5]GetPUT  */
    BOOL                                        bEnabled;                       /* 01 */
    CHAR                                        szName[NETDEV_LEN_512];         /* [0,20] */
    UINT32                                      udwAreaType;                    /*  0 47*/
    UINT32                                      udwAreaPointNum;                /* 1 2 3-6 */
    NETDEV_POINT_S                              astAreaPoint[NETDEV_LEN_16];    
    NETDEV_TEMP_DETECTION_BASE_RULE_INFO_S      stTempBaseInfo;                 
    BYTE                                        byRes[512];                     
}NETDEV_TEMP_DETECTION_COMM_RULE_INFO_S,*LPNETDEV_TEMP_DETECTION_COMM_RULE_INFO_S;

/**
 * @struct tagNETDEVTempDetectionCommonRuleList
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionCommonRuleList
{
    UINT32                                      udwNum;                               /* 0[0,12] */
    NETDEV_TEMP_DETECTION_COMM_RULE_INFO_S      astTempCommRuleInfo[NETDEV_LEN_16];   
    BYTE                                        byRes[512];                           
}NETDEV_TEMP_DETECTION_COMM_RULE_LIST_S,*LPNETDEV_TEMP_DETECTION_COMM_RULE_LIST_S;

/**
 * @struct tagNETDEVTempDetectionCompareRuleInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionCompareRuleInfo
{
    UINT32                                      udwID;                          /* 0[0,5]GetPUT  */
    BOOL                                        bEnabled;                       /* 01 */
    CHAR                                        szName[NETDEV_LEN_512];         /* [0,20] */
    UINT32                                      udwFirstCompareRuleID;          /* [1,12] */
    UINT32                                      udwSecondCompareRuleID;         /* [1,12] */
    NETDEV_TEMP_DETECTION_BASE_RULE_INFO_S      stTempBaseInfo;                 
    BYTE                                        byRes[512];                     
}NETDEV_TEMP_DETECTION_COMP_RULE_INFO_S,*LPNETDEV_TEMP_DETECTION_COMP_RULE_INFO_S;

/**
 * @struct tagNETDEVTempDetectionCompareRuleList
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionCompareRuleList
{
    UINT32                                      udwNum;                                  /* 0[0,12] */
    NETDEV_TEMP_DETECTION_COMP_RULE_INFO_S      astTempCompareRuleInfo[NETDEV_LEN_16];   
    BYTE                                        byRes[512];                              
}NETDEV_TEMP_DETECTION_COMP_RULE_LIST_S,*LPNETDEV_TEMP_DETECTION_COMP_RULE_LIST_S;

/**
 * @struct tagNETDEVTempDetectionRuleInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVTempDetectionRuleInfo
{
    UINT32                                      udwType;                            /*  0:  1:  2:  3:  */
    NETDEV_TEMP_DETECTION_BASE_RULE_INFO_S      stEntireImageRuleInfo;              /* Type0 */
    NETDEV_TEMP_DETECTION_COMM_RULE_LIST_S      stCommonRuleInfo;                   /* Type12 */
    NETDEV_TEMP_DETECTION_COMP_RULE_LIST_S      stCompareRuleInfo;                  /* Type2 */
    BYTE                                        byRes[512];                         
}NETDEV_TEMP_DETECTION_RULE_INFO_S, *LPNETDEV_TEMP_DETECTION_RULE_INFO_S;

/**
 * @struct tagNETDEVTempDetectionBlackBodyInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionBlackBodyInfo
{
    FLOAT                                       fTemperature;                       /* -40.00-150.002 */
    NETDEV_XW_AREA_S                            stAreaInfo;                         
    BYTE                                        byRes[512];                         
}NETDEV_TEMP_DETECTION_BLACKBODY_INFO_S,*LPNETDEV_TEMP_DETECTION_BLACKBODY_INFO_S;

/**
 * @struct tagNETDEVTempDetectionCorrectInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectionCorrectInfo
{
    INT32                                       dwMode;                             /* 0 1 */
    FLOAT                                       fCorrectionTemperature;             /* -10.00-10.002 */
    FLOAT                                       fEnvironmentTemperature;            /* -40.00-100.002 */
    BYTE                                        byRes[512];                         
}NETDEV_TEMP_DETECTION_CORRECT_INFO_S,*LPNETDEV_TEMP_DETECTION_CORRECT_INFO_S;

/**
 * @struct tagNETDEVTempDetectioUnitInfo
 * @brief 
 * @attention
*/
typedef struct  tagNETDEVTempDetectioUnitInfo
{
    INT32                                       dwUnit;                             /* 0 1H 2K */
    BYTE                                        byRes[512];                         
}NETDEV_TEMP_DETECTION_UNIT_INFO_S,*LPNETDEV_TEMP_DETECTION_UNIT_INFO_S;

/**
 * @struct tagNETDEVLinkDomeInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVLinkDomeInfo
{
    UINT32      udwDomeID;                  /* ID0 */
    CHAR        szIPAddr[NETDEV_LEN_64];    /* IP */
    CHAR        szUserName[NETDEV_LEN_64];  /* ,[0,64] */
    CHAR        szPIN[NETDEV_LEN_64];       /* ,[0,64] */
    UINT32      udwHttpPort;                /* HTTP */
    UINT32      udwZoomCoefficient;         /* : [1-10] */
    BYTE        byRes[128];                 
}NETDEV_LINK_DOME_INFO_S, *LPNETDEV_LINK_DOME_INFO_S;

/**
 * @struct tagNETDEVLinkDomeInfoList
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVLinkDomeInfoList
{
    UINT32                          udwLinkDomeNum;                         
    NETDEV_LINK_DOME_INFO_S         stLinkDomeInfoList[NETDEV_LEN_8];       
    BYTE                            byRes[128];                             
}NETDEV_LINK_DOME_INFO_LIST_S, *LPNETDEV_LINK_DOME_INFO_LIST_S;

/**
 * @struct tagNETDEVOutputSwitchActParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVOutputSwitchActParamInfo
{
    UINT32                              udwNum;                                                    
    NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S astOutputAlarmStatusInfo[NETDEV_MAX_ALARM_OUT_NUM];        
}NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S,*LPNETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVChannelActParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVChannelActParamInfo
{
    UINT32 udwNum;                                 
    INT32 adwChannelID[NETDEV_CHANNEL_MAX];        /* ID*/
}NETDEV_CHANNEL_ACT_PARAM_INFO_S,*LPNETDEV_CHANNEL_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVChannelPreset
 * @brief 
 * @attention
 */
typedef struct tagNETDEVChannelPreset
{
    INT32 dwChannelID;                              
    INT32 dwPresetID;                               
    BYTE  byRes[128];                               
}NETDEV_CHANNEL_PRESET_S,*LPNETDEV_CHANNEL_PRESET_S;

/**
 * @struct tagNETDEVPresetActParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPresetActParamInfo
{
    UINT32                  udwNum;                                     
    NETDEV_CHANNEL_PRESET_S stChannelPreset[NETDEV_CHANNEL_MAX];        
}NETDEV_PRESET_ACT_PARAM_INFO_S,*LPNETDEV_PRESET_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVEnabledActParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVEnabledActParamInfo
{
    BOOL    bEnabled;       
    BYTE    byRes[64];      
}NETDEV_ENABLED_ACT_PARAM_INFO_S, *LPNETDEV_ENABLED_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVLinkageActionList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVLinkageActionInfo 
{
    UINT32                               udwActID;                      /* ID NETDEV_ALARM_ACT_ID_E */
    NETDEV_ENABLED_ACT_PARAM_INFO_S       stEnabledInfo;                /* EMail */
    NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S stOutputSwitchActParamInfo;   
    NETDEV_CHANNEL_ACT_PARAM_INFO_S       stChannelActParamInfo;        /* NVR */
    NETDEV_PRESET_ACT_PARAM_INFO_S        stPresetActParamInfo;         
    BYTE                                  byRes[512];                   
}NETDEV_LINKAGE_ACTION_INFO_S,*LPNETDEV_LINKAGE_ACTION_INFO_S;

/**
 * @struct tagNETDEVLinkageActionList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVLinkageActionList
{
    UINT32                       udwNum;                                               
    NETDEV_LINKAGE_ACTION_INFO_S stActionInfo[NETDEV_MAX_LINK_ACTION_NUM];             
    BYTE                         byRes[256];                                           
}NETDEV_LINKAGE_ACTION_LIST_S,*LPNETDEV_LINKAGE_ACTION_LIST_S;

/**
 * @struct tagNETDEVSwitchLinkageAction
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVSwitchLinkageAction
{
    UINT32                          udwSwitchIndex;             
    NETDEV_LINKAGE_ACTION_LIST_S    stLinkageActionList;        
    BYTE                            byRes[256];                 
}NETDEV_SWITCH_LINKAGE_ACTION_S,*LPNETDEV_SWITCH_LINKAGE_ACTION_S;

/**
 * @struct tagNETDEVCrowdDensityLinkageAction
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVCrowdDensityLinkageAction
{
    UINT32                          udwGroupID;             /* ID */
    NETDEV_LINKAGE_ACTION_LIST_S    stLinkageActionList;    
    BYTE                            byRes[256];
}NETDEV_CROWD_DENSITY_LINKAGE_ACTION_S,*LPNETDEV_CROWD_DENSITY_LINKAGE_ACTION_S;

/**
 * @struct tagNETDEVCrowdDensityLinkageActionList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVCrowdDensityLinkageActionList
{
    UINT32                                  udwGroupNum;                        
    LPNETDEV_CROWD_DENSITY_LINKAGE_ACTION_S pstCrowdDensityLinkageActionList;   
    BYTE                                    byRes[256];
}NETDEV_CROWD_DENSITY_LINKAGE_ACTION_LIST_S,*LPNETDEV_CROWD_DENSITY_LINKAGE_ACTION_LIST_S;

/**
 * @struct tagLinkageStrategy
 * @brief  
 * @attention  None
 */
typedef struct tagLinkageStrategy
{
    UINT32                          udwType;                /* ,NETDEV_PERSON_COMPARE_RESULT_TYPE_E */
    NETDEV_LINKAGE_ACTION_LIST_S    stLintageActions;       
    BYTE                            byRes[512];             
}NETDEV_LINKAGE_STRATEGY_S, *LPNETDEV_LINKAGE_STRATEGY_S;

/**
 * @struct tagNETDEVLinkageActionListEx
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVLinkageActionListEx
{
    UINT32                         udwNum;                             
    LPNETDEV_LINKAGE_ACTION_INFO_S pstActionInfo;                      /*  NVR8*/
    BYTE                           byRes[256];                         
}NETDEV_LINKAGE_ACTION_LIST_EX_S,*LPNETDEV_LINKAGE_ACTION_LIST_EX_S;

/**
 * @struct tagLinkageStrategyEx
 * @brief  
 * @attention  None
 */
typedef struct tagLinkageStrategyEx
{
    UINT32                          udwType;                /* ,NETDEV_PERSON_COMPARE_RESULT_TYPE_E */
    NETDEV_LINKAGE_ACTION_LIST_EX_S stLintageActions;       
    BYTE                            byRes[512];             
}NETDEV_LINKAGE_STRATEGY_EX_S, *LPNETDEV_LINKAGE_STRATEGY_EX_S;

/**
 * @struct tagNETDEVMonitorDefenceInfo
 * @brief  
 * @attention PTS VMS
 */
typedef struct tagNETDEVMonitorDefenceInfo
{
    INT64      tBegin;                  /* (unix) */
    INT64      tEnd;                    /* (unix) */
    UINT32     udwTimeTemplateID;       /* 0 */
    BYTE       byRes[128];              
}NETDEV_MONITOR_DEFENCE_INFO_S, *LPNETDEV_MONITOR_DEFENCE_INFO_S;

/**
 * @struct tagNETDEVMonitorPlanInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVMonitorPlanInfo
{
    NETDEV_MONITOR_DEFENCE_INFO_S stMonitorDefence;        /*  NVR*/
    NETDEV_VIDEO_WEEK_PLAN_S      stWeekPlan;              
    BYTE                          byRes[256];              
}NETDEV_MONITOR_PLAN_INFO_S, *LPNETDEV_MONITOR_PLAN_INFO_S;

/**
 * @struct tagNETDEVFaceMonitorInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonitorInfo
{
    UINT32                              udwID;                        
    NETDEV_MONITION_RULE_INFO_S         stMonitorRuleInfo;            
    UINT32                              udwLinkStrategyNum;           
    LPNETDEV_LINKAGE_STRATEGY_S         pstLinkStrategyList;          
    NETDEV_VIDEO_WEEK_PLAN_S            stWeekPlan;                   /* ,NVR IPC */
    NETDEV_MONITOR_DEFENCE_INFO_S       stMonitorDefenceInfo;         /* PTS VMS */
    BYTE                                byRes[250];                   /*   Reserved */
}NETDEV_MONITION_INFO_S,*LPNETDEV_MONITION_INFO_S;

/**
 * @struct tagNETDEVFaceMonitorList
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceMonitorList
{
    UINT32 udwNum;                                                    
    LPNETDEV_MONITION_INFO_S pstMonitorList;                     
}NETDEV_FACE_MONITOR_LIST_S,*LPNETDEV_FACE_MONITOR_LIST_S;

/**
 * @struct tagstNETDEVFaceAlarmImageArea
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmImageArea
{
    UINT32   udwLeft;          
    UINT32   udwTop;           
    UINT32   udwRight;         
    UINT32   udwButtom;        
    BYTE     byRes[128];       /*   Reserved */
}NETDEV_FACE_ALARM_IMAGE_AREA_S, *LPNETDEV_FACE_ALARM_IMAGE_AREA_S;

/**
 * @struct tagstNETDEVFaceAlarmLogSnapImage
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmSnapImage
{
    NETDEV_FILE_INFO_S               stBigImage;                
    NETDEV_FILE_INFO_S               stSmallImage;              
    NETDEV_FACE_ALARM_IMAGE_AREA_S   stArea;                    
    BYTE                             byRes[128];                /*   Reserved */
}NETDEV_FACE_ALARM_SNAP_IMAGE_S, *LPNETDEV_FACE_ALARM_SNAP_IMAGE_S;

/**
* @struct tagNETDEVVehicleMonitorRuleInfo
* @brief  
* @attention  None
*/
typedef struct tagNETDEVVehicleMonitorRuleInfo
{
    CHAR                        szName[NETDEV_LEN_260];                              
    BOOL                        bEnabled;                                            
    INT64                       tBegin;                                              
    INT64                       tEnd;                                                
    UINT32                      udwMonitorReason;                                    /*   NETDEV_VEHICLE_MONITOR_TYPE_E */
    CHAR                        szDescription[NETDEV_FACE_MONITOR_RULE_REASON_LEN];  
    UINT32                      udwMonitorAlarmType;                                 /*   0 1*/
    UINT32                      udwDatabaseID;                                       /* ID */
    UINT32                      udwMemberNum;                                        /* [0~32] */
    NETDEV_MEMBER_INFO_S        stMemberInfo[NETDEV_LEN_64];                         
    BYTE                        byRes[128];                                          /*   Reserved */
}NETDEV_VEHICLE_MONITION_RULE_INFO_S, *LPNETDEV_VEHICLE_MONITION_RULE_INFO_S;

/**
* @struct tagNETDEVVehicleMonitorInfo
* @brief   Vehicle monitoring task information Structure definition
* @attention  None
*/
typedef struct tagNETDEVVehicleMonitorInfo
{
    UINT32                              udwMonitorID;                 
    NETDEV_VEHICLE_MONITION_RULE_INFO_S stMonitorRuleInfo;            
    BYTE                                byRes[128];                   /*   Reserved */
}NETDEV_VEHICLE_MONITION_INFO_S, *LPNETDEV_VEHICLE_MONITION_INFO_S;

/**
* @struct tagstNETDEVPlateAttrInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVPlateAttrInfo
{
    CHAR     szPlateNo[NETDEV_LEN_16];                        
    UINT32   udwColor;                                        /*   NETDEV_PLATE_COLOR_E */
    UINT32   udwType;                                         /*  NETDEV_PLATE_TYPE_E */
    BYTE     byRes[64];                                       /*   Reserved */
}NETDEV_PLATE_ATTR_INFO_S, *LPNETDEV_PLATE_ATTR_INFO_S;

/**
* @struct tagstNETDEVVehicleAttrInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVVehicleAttrInfo
{
    UINT32   udwColor;          /*   NETDEV_VEHICLE_COLOR_E */
    UINT32   udwType;           /*  NETDEV_VEHICLE_TYPE_E */
    FLOAT    udwSpeedValue;     /*  double */
    UINT32   udwSpeedUnit;      /*   NETDEV_VEHICLE_SPEED_UNIT_E */
    BYTE     byRes[64];         /*   Reserved */
}NETDEV_VEHICLE_ATTR_INFO_S, *LPNETDEV_VEHICLE_ATTR_INFO_S;

/**
 * @struct tagNETDEVVehAttr
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVVehAttr
{
    UINT32 udwType;                                       /*   NETDEV_VEHICLE_TYPE_E */
    UINT32 udwColor;                                      /*   NETDEV_PLATE_COLOR_E */
    UINT32 udwSpeedUnit;                                  /*  0/ 1/ */
    FLOAT  fSpeedValue;                                   
    UINT32 udwSpeedType;                                  /*   NETDEV_SPEED_TYPE_E */
    CHAR   szVehicleBrand[NETDEV_LEN_64];                 /* ) */
    UINT32 udwImageDirection;                             /*   NETDEV_IMAGE_DIRECTION_E */
    BYTE   byRes[128];                                    
}NETDEV_VEH_ATTR_S,*LPNETDEV_VEH_ATTR_S;

/**
 * @struct tagNETDEVVehicleMemberAttr
 * @brief (NETDEV_VEHICLE_DETAIL_INFO_S)
 * @attention  None
 */
typedef struct tagNETDEVVehicleMemberAttr
{
    UINT32             udwColor;                          /*   NETDEV_PLATE_COLOR_E */
    NETDEV_FILE_INFO_S stVehicleImage;                    /*  4M */
}NETDEV_VEHICLE_MEMBER_ATTR_S,*LPNETDEV_VEHICLE_MEMBER_ATTR_S;

/**
* @struct tagstNETDEVVehicleDetailInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVVehicleDetailInfo
{
    UINT32                       udwReqSeq;                         
    UINT32                       udwMemberID;                       /* ID */
    NETDEV_PLATE_ATTR_INFO_S     stPlateAttr;                       
    NETDEV_VEHICLE_MEMBER_ATTR_S stVehicleAttr;                     
    BOOL                         bIsMonitored;                      /*  0 1 */
    UINT32                       udwDBNum;                          
    UINT32                       audwDBIDList[NETDEV_LEN_16];       /* ID */
    BYTE                         byRes[124];                        /*   Reserved */
}NETDEV_VEHICLE_DETAIL_INFO_S, *LPNETDEV_VEHICLE_DETAIL_INFO_S;

/**
* @struct tagstNETDEVMonitorAlarmInfo
* @brief ( NETDEV_VEHICLE_RECORD_INFO_S )
* @attention
*/
typedef struct tagstNETDEVMonitorAlarmInfo
{
    UINT32 udwMonitorReason;                          
    UINT32 udwMonitorAlarmType;                       /*  0 1 */
    UINT32 udwMemberID;                               /* ID */
}NETDEV_MONITOR_ALARM_INFO_S,*LPNETDEV_MONITOR_ALARM_INFO_S;

/**
* @struct tagstNETDEVVehicleRcordInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVVehicleRcordInfo
{
    UINT32                      udwRecordID;                    /* ID */
    UINT32                      udwChannelID;                   /* ID */
    UINT32                      udwPassingTime;                 /* UTC*/
    CHAR                        szChannelName[NETDEV_LEN_260];  
    NETDEV_PLATE_ATTR_INFO_S    stPlateAttr;                    
    NETDEV_VEH_ATTR_S           stVehAttr;                      
    NETDEV_FILE_INFO_S          stPlateImage;                   /*  1M*/
    NETDEV_FILE_INFO_S          stVehicleImage;                 /*   1M*/
    NETDEV_FILE_INFO_S          stPanoImage;                    /*   URLsize/LAPI/V1.0/System/Picture*/
    NETDEV_MONITOR_ALARM_INFO_S stMonitorAlarmInfo;             
    BYTE                        byRes[132];                     /*   Reserved */
}NETDEV_VEHICLE_RECORD_INFO_S, *LPNETDEV_VEHICLE_RECORD_INFO_S;

/**
* @struct tagstVehicleEventInfo
* @brief 
* @attention
*/
typedef struct tagstVehicleEventInfo
{
    UINT32                         udwID;                             /* ID */
    UINT32                         udwTimestamp;                      /* UTC */
    UINT32                         udwNotificationType;               /*   NETDEV_NOTIFICATION_TYPE_E*/
    UINT32                         udwVehicleInfoNum;                 /*  [0, 1] */
    LPNETDEV_VEHICLE_RECORD_INFO_S pstVehicleRecordInfo;              
    BYTE                           byRes[256];                        /*   Reserved */
}NETDEV_VEHICLE_EVENT_INFO_S,*LPNETDEV_VEHICLE_EVENT_INFO_S;

/**
* @struct tagstNETDEVVehRecognitionEvent
* @brief 
* @attention
*/
typedef struct tagstNETDEVVehRecognitionEvent
{
    CHAR                        szReference[NETDEV_LEN_480];                        
    UINT32                      udwSrcID;                                           /* ID */
    NETDEV_VEHICLE_EVENT_INFO_S stVehicleEventInfo;                                 
    BYTE                        byRes[256];                                         /*   Reserved */
}NETDEV_VEH_RECOGNITION_EVENT_S, *LPNETDEV_VEH_RECOGNITION_EVENT_S;

/**
 * @struct tagNETDEVFaceMemberRegionInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberRegionInfo
{
    CHAR   szNation[NETDEV_FACE_MEMBER_REGION_LEN];                       
    CHAR   szProvince[NETDEV_FACE_MEMBER_REGION_LEN];                     
    CHAR   szCity[NETDEV_FACE_MEMBER_REGION_LEN];                         
    BYTE   byRes[256];                                                    /*   Reserved */
}NETDEV_FACE_MEMBER_REGION_INFO_S,*LPNETDEV_FACE_MEMBER_REGION_INFO_S;

/**
 * @struct tagNETDEVFaceMemberIDInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberIDInfo
{
    UINT32   udwType;                                       /*  NETDEV_FACE_MEMBER_ID_TYPE_E */
    CHAR     szNumber[NETDEV_FACE_IDNUMBER_LEN];            
    BYTE     byRes[128];                                    /*   Reserved */
}NETDEV_FACE_MEMBER_ID_INFO_S,*LPNETDEV_FACE_MEMBER_ID_INFO_S;

/**
 * @struct tagNETDEVFaceMemberInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberInfo
{
    UINT32                             udwReqSeq;                                                   
    UINT32                             udwMemberID;                                                 /*ID    post*/
    CHAR                               szMemberName[NETDEV_FACE_MEMBER_NAME_LEN];                   
    UINT32                             udwMemberGender;                                             /*   NETDEV_GENDER_TYPE_E */
    CHAR                               szMemberBirthday[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           
    NETDEV_FACE_MEMBER_REGION_INFO_S   stMemberRegionInfo;                                          
    NETDEV_FACE_MEMBER_ID_INFO_S       stMemberIDInfo;                                              
    NETDEV_FILE_INFO_S                 stMemberImageInfo;                                           
    NETDEV_FILE_INFO_S                 stMemberSemiInfo;                                            
    UINT32                             udwCustomNum;                                                
    NETDEV_CUSTOM_VALUE_S              stCustomValue[NETDEV_FACE_MEMBER_CUSTOM_NUM];                    
    BOOL                               bIsMonitored;                                                /*   01 */
    UINT32                             udwDBNum;                                                    
    UINT32                             audwDBIDList[NETDEV_LEN_16];                                 /* ID */
    BYTE                               byRes[128];                                                  /*   Reserved */
}NETDEV_FACE_MEMBER_INFO_S,*LPNETDEV_FACE_MEMBER_INFO_S;

/**
 * @struct tagstNETDEVFaceAlarmCmpInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmCmpInfo
{
    UINT32                           udwSimilarity;               
    NETDEV_FACE_MEMBER_INFO_S        stMemberInfo;                
    NETDEV_FACE_ALARM_SNAP_IMAGE_S   stSnapshotImage;             
    LPNETDEV_PERSON_INFO_S           pstPersonInfo;               /* (NVR) / malloc */
    LPNETDEV_FACE_ATTR_S             pstFaceAttr;                 
    LPNETDEV_PERSON_ATTR_S           pstPersonAttr;               
    BYTE                             byRes[116];                  /*   Reserved */
}NETDEV_FACE_ALARM_CMP_INFO_S, *LPNETDEV_FACE_ALARM_CMP_INFO_S;

/**
 * @struct tagstNETDEVFaceRecordSnapshotInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVFaceRecordSnapshotInfo
{
    UINT32                        udwRecordID;                                       /* ID */
    UINT32                        udwRecordType;                                     /*  # NETDEV_FACE_PASS_RECORD_TYPE_E */
    UINT32                        udwPassTime;                                       /*  UTC */
    UINT32                        udwEventType;                                      /*  BITBIT10BIT0:BIT1:BIT2:*/
    UINT32                        udwChannelID;                                      /* ID */
    UINT32                        udwMonitorRuleID;                                  /* ID */
    CHAR                          szChannelName[NETDEV_LEN_260];                     
    NETDEV_FACE_ALARM_CMP_INFO_S  stCompareInfo;                                     
    BYTE                          byRes[124];                                        /*   Reserved */
}NETDEV_FACE_RECORD_SNAPSHOT_INFO_S, *LPNETDEV_FACE_RECORD_SNAPSHOT_INFO_S;

/**
 * @struct tagstNETDEVFaceAlarmLogResultInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVSmartAlarmLogResultInfo
{
    UINT32   udwTotal;                     
    UINT32   udwOffset;                    
    UINT32   udwNum;                       
    BYTE     byRes[128];                   /*   Reserved */
}NETDEV_SMART_ALARM_LOG_RESULT_INFO_S, *LPNETDEV_SMART_ALARM_LOG_RESULT_INFO_S;

/**
* struct tagNETDEVSmartRecordCond
* @brief 
* @attention 
*/
typedef struct tagNETDEVSmartRecordCond
{
    INT32       dwChannelID;                              
    UINT32      udwPosition;                              /*  # NETDEV_RECORD_LOCATION_E */
    UINT32      udwGridEnable;                            /* 10 */
    BYTE        awGridAreas[NETDEV_GRID_AREAS_LEN];       
    INT64       tBeginTime;                               /* (unix) */
    INT64       tEndTime;                                 /* (unix) */
    UINT32      udwSensitivity;                           /* 1~8 */
    UINT32      udwServerID;                              /* ID Video server ID */
    BYTE        byRes[128];                               /*   Reserved */
}NETDEV_SMART_RECORD_COND_S, *LPNETDEV_SMART_RECORD_COND_S;

/**
 * @struct tagstNETDEV_VoiceBroadcastChlInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastChlInfo
{
    UINT32  dwChannelID;               /* ID */
    UINT32  dwResultCode;              
    UINT32  dwStatus;                  
}NETDEV_VOICE_BROADCAST_CHL_INFO_S, *LPNETDEV_VOICE_BROADCAST_CHL_INFO_S;

/**
 * @struct tagstNETDEV_VoiceBroadcastGroupInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastGroupInfo
{
    INT32                                  dwSize;                                                        
    NETDEV_VOICE_BROADCAST_CHL_INFO_S      astChlInfoList[NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX];        
}NETDEV_VOICE_BROADCAST_GROUP_INFO_S, *LPNETDEV_VOICE_BROADCAST_GROUP_INFO_S;

/**
 * @struct tagstNETDEV_ModifyVoiceBroadcastInfo
 * @brief 
 * @attention
 */
typedef struct NETDEV_ModifyVoiceBroadcastInfo
{
    LPNETDEV_OPERATE_LIST_S     pstAddChannelList;      
    LPNETDEV_OPERATE_LIST_S     pstDelChannelList;      
}NETDEV_MODIFY_VOICE_BROADCAST_INFO_S, *LPNETDEV_MODIFY_VOICE_BROADCAST_INFO_S;

/**
 * @struct tagstNETDEV_VoiceBroadcastCtrlInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastCtrlInfo
{
    INT32   dwChannelID;             /* ID */
    UINT32  udwStatus;               /* ,(1),(0) */
}NETDEV_VOICE_BROADCAST_CTRL_INFO_S, *LPNETDEV_VOICE_BROADCAST_CTRL_INFO_S;

/**
 * @struct tagNETDEVRecordLabel
 * @brief 
 * @attention
 */
typedef struct tagNETDEVRecordLabel
{
    INT32   dwChannelID;                            /* ID */
    UINT32  udwTime;                                
    CHAR    szLabelID[NETDEV_LABEL_ID_MAX_LEN];     /* ID */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];        
    UINT32  udwServerID;                            /* ID */
    BYTE    byRes[256];                             /*  Reserved */
}NETDEV_RECOED_LABEL_S, *LPNETDEV_RECOED_LABEL_S;

/**
 * @struct tagNETDEVLabelBase
 * @brief 
 * @attention
 */
typedef struct tagNETDEVLabelBase
{
    INT32   dwChannelID;                            /* ID */
    CHAR    szLabelID[NETDEV_LABEL_ID_MAX_LEN];     /* ID */
    UINT32  udwResult;                              /*   NETDEV_RECODE_LABEL_RESULT_E */
    UINT32  udwServerID;                            /* ID */
    BYTE    byRes[256];                             /*  Reserved */
}NETDEV_LABEL_BASE_S, *LPNETDEV_LABEL_BASE_S;

/**
 * @struct tagNETDEVLabelBaseList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVLabelBaseList
{
    UINT32                  udwPosition;              /*   NETDEV_RECORD_LOCATION_E */
    UINT32                  udwSize;                  
    LPNETDEV_LABEL_BASE_S   pstLabelBase;             
    UINT32                  udwLabelFailNum;          
}NETDEV_LABEL_BASE_LIST_S, *LPNETDEV_LABEL_BASE_LIST_S;

 /**
 * @struct tagNETDEVLabelFindData
 * @brief 
 * @attention
 */
typedef struct tagNETDEVLabelFindData
{
    UINT32  udwPosition;                        /*   NETDEV_RECORD_LOCATION_E */
    UINT32  udwChannelNum;                      
    INT32   *pdwChannelID;                      
    INT64   tBeginTime;                         /*   Start time */
    INT64   tEndTime;                           /*   End time */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];    
}NETDEV_LABEL_FINDDATA_S, *LPNETDEV_LABEL_FINDDATA_S;

/**
 * @struct tagRecordSectionInfo
 * @brief 
 * @attention
 */
typedef struct tagRecordSectionInfo
{
    CHAR    szLockDecs[NETDEV_RECORD_LOCK_DESC_LEN];                 
    INT64   tBeginTime;                                              /*   Start time */
    INT64   tEndTime;                                                /*   End time */
    UINT32  udwServerID;                                             /* ID */
    BYTE    byRes[256];                                              
}NETDEV_RECORD_SECTION_INFO_S,* LPNETDEV_RECORD_SECTION_INFO_S;

/**
 * @struct tagstNETDEVLockIDInfo
 * @brief ID
 * @attention
 */
typedef struct tagstNETDEVLockIDInfo
{
    CHAR    szLockIDInfo[NETDEV_RECORD_LOCK_ID_LEN];                  /* ID */
    UINT32  udwServerID;                                              /* ID */
    BYTE    byRes[256];                                               
}NETDEV_LOCK_ID_INFO_S, *LPNETDEV_LOCK_ID_INFO_S;

/**
 * @struct tagstNETDEVLockIDList
 * @brief ID
 * @attention
 */
typedef struct tagstNETDEVLockIDList
{
    INT32                       dwSize;             /* ID */
    LPNETDEV_LOCK_ID_INFO_S     pszLockIDInfo;      /* IDdwsize*/
}NETDEV_LOCK_ID_LIST_S, *LPNETDEV_LOCK_ID_LIST_S;

/**
 * @struct tagRecordLockQryInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVRecordLockQryInfo
{
    UINT32              udwPosition;        
    INT64               tBeginTime;         /*   Start time */
    INT64               tEndTime;           /*   End time */
    NETDEV_CHANNELS_S   stChannels;         /* ID */
    BYTE                byRes[256];         
}NETDEV_RECORD_LOCK_FIND_COND_S,* LPNETDEV_RECORD_LOCK_FIND_COND_S;

/**
 * @struct tagRecordLockInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVRecordLockInfo
{
    NETDEV_LOCK_ID_INFO_S           stLockIDInfo;               /* ID */
    INT32                           dwChannelID;                /* ID */
    NETDEV_RECORD_SECTION_INFO_S    stRecordSectionInfo;        
    BYTE                            byRes[256];                 
}NETDEV_RECORD_LOCK_INFO_S,* LPNETDEV_RECORD_LOCK_INFO_S;

/**
 * @struct tagNETDEVRecordTime
 * @brief 
 * @attention
 */
typedef struct tagNETDEVRecordTime
{
    UINT32          udwChlID;                   /*  Channel ID */
    INT64           tEarliestTime;              /*  Earliest Time */
    INT64           tLatestTime;                /*  Latest Time */
    BYTE            byRes[512];                 
}NETDEV_RECORD_TIME_S, *LPNETDEV_RECORD_TIME_S;

/**
 * @struct tagNETDEVRecordTimeList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVRecordTimeList
{
    UINT32                      udwNum;                     /* Record Times Num */
    LPNETDEV_RECORD_TIME_S      pstRecordTimes;             /*  Record Times List, need malloc by caller*/
    BYTE                        byRes[512];                 /*  Reserved */
}NETDEV_RECORD_TIME_LIST_S, *LPNETDEV_RECORD_TIME_LIST_S;

/** 
 * @struct tagNETDEVAddress
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVAddress
{
    UINT32  udwAddressType;                     /* ,# NETDEV_ADDRESS_TYPE_E */
    CHAR    szAddress[NETDEV_IP_ADDRESS_LEN];   
    BYTE    byRes[256];                         /*   Reserved */
}NETDEV_ADDRESS_S,*LPNETDEV_ADDRESS_S;

/** 
 * @struct tagNETDEVHotStandbyParam
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVHotStandbyParam
{
    UINT32              udwVirtualRouterID;                              /* ID */
    CHAR                szVirtualNETMask[NETDEV_IP_ADDRESS_LEN];         
    UINT32              udwCleanupFlag;                                  /* ,# NETDEV_ALARM_LOG_CLEANUP_FLAG_E */
    NETDEV_ADDRESS_S    stMasterAddress;                                 
    NETDEV_ADDRESS_S    stBackupAddress;                                 
    NETDEV_ADDRESS_S    stVirtualAddress;                                
    BYTE                byRes[256];                                      /*   Reserved */
}NETDEV_HOTSTANDBY_PARAM_S,*LPNETDEV_HOTSTANDBY_PARAM_S;

/**
 * @struct tagNETDEVMasterSlaveState
 * @brief   VMS Master_Slave State Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMasterSlaveState
{
    UINT32                      udwMode;                             /* ,# NETDEV_VMS_MODE_E */
    UINT32                      udwStatus;                           /* ,# NETDEV_VMS_STATUS_E */
    NETDEV_ADDRESS_S            stVMSAddress;                        
    UINT32                      udwHotStandbyMode;                   /* ,# NETDEV_VMS_HOTSTANDBYMODE_E */
    NETDEV_HOTSTANDBY_PARAM_S   stHotStandbyParam;                   
    UINT32                      udwOldHotStandbyMode;                /* ,# NETDEV_VMS_HOTSTANDBYMODE_E */
    BYTE                        byRes[256];                          
}NETDEV_MASTER_SLAVE_STATE_S,*LPNETDEV_MASTER_SLAVE_STATE_S;

/**
 * @struct tagNETDEVVodFile
 * @brief   Recording file Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVodFile
{
    CHAR                    szFileName[NETDEV_NAME_MAX_LEN];        /*   Recording file name */
    NETDEV_STORE_TYPE_E     enType;                                 /*   Recording storage type */
    INT64                   tBeginTime;                             /*   Start time */
    INT64                   tEndTime;                               /*   End time */
}NETDEV_VOD_FILE_S, *LPNETDEV_VOD_FILE_S;

/**
 * @struct tagNETDEVPictureDataEx
 * @brief   Image data Structure definition
 *         Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVPictureDataEx
{
    BYTE    *pucData[4];                /* pucData[0]:Y ,pucData[1]:U ,pucData[2]:V   pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
    INT32   dwLineSize[4];              /* ulLineSize[0]:Y, ulLineSize[1]:U, ulLineSize[2]:V  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
    INT32   dwPicHeight;                /*   Picture height */
    INT32   dwPicWidth;                 /*   Picture width */
    INT32   dwRenderTimeType;           /*   Time data type for rendering */
    INT64   tRenderTime;                /*   Time data for rendering */
    INT32   dwFrameRate;                
    BYTE    byRes[32];                  
}NETDEV_PICTURE_DATA_EX_S, *LPNETDEV_PICTURE_DATA_EX_S;

/**
* @struct tagstNETDEVGpuAbleState
* @brief GPU
* @attention 
*/
typedef struct tagstNETDEVGpuAbleState
{
    BOOL bGpuAbleH264;            /* GPU-H.264*/
    BOOL bGpuAbleH265;            /* GPU-H.265 */
    BOOL bGpuAbleMJPEG;           /* GPU-MJEGP */
    BOOL bGpuAbleMPEG2;           /* GPU-MPEG-2 */
    BOOL bGpuAbleMPEG4;           /* GPU-MPEG-4 */
    BOOL bReserved1;              /* 1 */
    BOOL bReserved2;              /* 2 */
    BOOL bReserved3;              /* 3 */
}NETDEV_GPU_ABLESTATE_S,*LPNETDEV_GPU_ABLESTATE_S;

/**
 * @struct tagstNETDEVXWEncodeChnProperty
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVXWEncodeChnProperty
{
    INT32 dwVideoSrc;              /*  NETDEV_VIDEO_SRC_TYPE_E */
    BYTE   byRes[512];             
}NETDEV_XW_ENCODE_CHN_PROPERTY_S, *LPNETDEV_XW_ENCODE_CHN_PROPERTY_S;

/**
 * @struct tagNETDEVLogFindCondV30
 * @brief   Log query condition Structure definition
 * @attention  None
 */
typedef struct tagNETDEVLogFindCondV30
{
    NETDEV_LOG_MAIN_TYPE_E  enMainType;         /*   Main type */
    NETDEV_LOG_SUB_TYPE_E   enSubType;          /*   Sub type */
    INT64                   tBeginTime;         /*   Start time */
    INT64                   tEndTime;           /*   End time */
}NETDEV_LOG_FIND_COND_V30_S, *LPNETDEV_LOG_FIND_V30_COND_S;

/**
 * @struct tagstNETDEVUserLogInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVUserLogInfo
{
    CHAR                   szUserName[NETDEV_USERNAME_LEN];     
    INT32                  dwUserHandle;                        /* ID() */
    NETDEV_IPADDR_INFO_S   stUserIPAddr;                        /* IP */
}NETDEV_USER_LOG_INFO_S, *LPNETDEV_USER_LOG_INFO_S;

/**
 * @struct tagstNETDEVUserEventType
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVUserEventType
{
    INT32 dwMajorType;                                  
    INT32 dwMinorType;                                  
}NETDEV_USER_EVENT_TYPE_S, *LPNETDEV_USER_EVENT_TYPE_S;

/**
 * @struct tagstNETDEVEventNotifyInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVEventNotifyInfo
{    
    NETDEV_USER_EVENT_TYPE_S    stEventType;            
    INT32                       dwParamLen;             
}NETDEV_EVENT_NOTIFY_TYPE_S, *LPNETDEV_EVENT_NOTIFY_TYPE_S;

/**
 * @struct tagstNETDEVDateInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDateInfo
{
    INT32     dwYear;                               
    INT32     dwMonth;                              
    INT32     dwDay;                                
    INT32     dwHour;                               
    INT32     dwMinute;                             
    BYTE      byRes[32];                            
}NETDEV_DATE_INFO_S, *LPNETDEV_DATE_INFO_S;

/**
 * @struct tagstNETDEVClientVersionsInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVClientVersionsInfo
{
    UINT32                              udwType;                                            /*  # NETDEV_CLIENT_TYPE_E */
    CHAR                                szVersion[NETDEV_LEN_256];                          /*  [0, 255] */
    BYTE                                byRes[32];                                          
}NETDEV_CLIENT_VERSION_INFO_S, *LPNETDEV_CLIENT_VERSION_INFO_S;

/**
 * @struct tagstNETDEVClientVersionsInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVClientVersionsInfoList
{
    UINT32                                  udwNum;                                          
    LPNETDEV_CLIENT_VERSION_INFO_S          pstClientVersionsInfo;                           
    BYTE                                    byRes[32];                                       
}NETDEV_CLIENT_VERSION_INFO_LIST_S, *LPNETDEV_CLIENT_VERSION_INFO_LIST_S;

/**
 * @struct tagNETDEVDeviceBaseInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVDeviceBaseInfo
{
    INT32 dwChlID;                                              /*   Video input channel ID */
    INT32 dwDeviceType;                                         /*   NETDEV_DEVICE_TYPE_E Device Type */
    INT32 dwDevCode;                                            /*   Device code */
    INT32 dwCurrentLang;                                        /*  # NETDEV_LANG_TYPE_E Current language NETDEV_LANG_TYPE_E*/
    NETDEV_DATE_INFO_S stBuildDate;                             /*   Release time */
    CHAR szSerialNum[NETDEV_LEN_32];                            /*   Device serial number */
    CHAR szMacAddress[NETDEV_LEN_64];                           /* IPv4Mac  MAC address of IPv4 */
    CHAR szDevName[NETDEV_CODE_STR_MAX_LEN];                    /*   Device name */
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];                   /*   Device model */
    CHAR szVIIDVersion[NETDEV_CODE_STR_MAX_LEN];                /*   VIIDVersion version */
    CHAR szSoftwareVersion[NETDEV_CODE_STR_MAX_LEN];            /*  Internal software version */
    CHAR szFirmwareVersion[NETDEV_CODE_STR_MAX_LEN];            /*   Software version */
    CHAR szHardewareID[NETDEV_CODE_STR_MAX_LEN];                /*   Hardware ID */
    CHAR szUbootVersion[NETDEV_CODE_STR_MAX_LEN];               /* UBOOT  UBOOT version */
    CHAR szManufacturer[NETDEV_LEN_64];                         /* [1,64]  Manufacturer */
    NETDEV_CLIENT_VERSION_INFO_LIST_S stClientVersionsInfo;     /*   Client Versions Infos */
    CHAR szProtoName[NETDEV_LEN_256];                           
    BYTE byRes[216];                                            /*  Reserved */
}NETDEV_DEVICE_BASE_INFO_S, *LPNETDEV_DEVICE_BASE_INFO_S;

/**
 * @struct tagNETDEVNetWorkCardDetailInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVNetWorkCardDetailInfo
{
    CHAR                          szNetCardName[NETDEV_LEN_32];                           /* [0,16] */
    UINT32                        udwInBoundRate;                                         /* Kbps */
    UINT32                        udwOutBoundRate;                                        /* Kbps */
    BYTE                          byRes[256];                                             /*  Reserved */
}NETDEV_NETWORK_CARD_DETAIL_INFO_S, *LPNETDEV_NETWORK_CARD_DETAIL_INFO_S;

/**
 * @struct tagNETDEVDeviceRunInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVDeviceRunInfo
{
    UINT32                            udwRuntime;                                                /* s */
    UINT32                            udwCPUUsage;                                               /* CPUVMS */
    UINT32                            udwMemUsage;                                               /* VMS */
    UINT32                            udwNetInterfaceNum;                                        /* VMS */
    NETDEV_NETWORK_CARD_DETAIL_INFO_S astNetInterfaceInfoList[NETDEV_MAX_NET_WORK_CARD_NUM];     /* NetCardNum0 */
    BYTE                              byRes[512];                                                /*  Reserved */
}NETDEV_DEVICE_RUN_INFO_S, *LPNETDEV_DEVICE_RUN_INFO_S;

/**
 * @struct tagNETDEVMotionIntervalInfo
 * @brief  Motion Interval Info
 * @attention  None
 */
typedef struct tagNETDEVMotionIntervalInfo
{
    UINT32    udwSuppressTime;                                     /* ,:,[5, 3600] */
    UINT32    udwClearTime;                                        /* ,:,[1,600] */
    BYTE      byRes[512];                                          /*   Reserved */
}NETDEV_MOTION_INTERVAL_INFO_S, *LPNETDEV_MOTION_INTERVAL_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogCondListV30
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVAlarmLogCondListV30
{
    UINT32              udwCondSize;                                                     
    UINT32              udwSincedID;                                                     /* IDIDSinceID */
    UINT32              udwDirection;                                                    /* 12 */
    UINT32              udwPageRow;                                                      /* 100 */
    NETDEV_QUERY_INFO_S astCondition[NETDEV_LOG_QUERY_COND_NUM];                         
    BYTE                byRes[512];                                                      /*  Reserved */
}NETDEV_ALARM_LOG_COND_LIST_V30_S, *LPNETDEV_ALARM_LOG_COND_LIST_V30_S;

/**
 * @struct tagNETDEVFaceAttrInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVFaceAttrInfo
{
    BOOL  bIsEnableGender;                         /*  0 1 */
    BOOL  bIsEnableAge;                            /*  0 1 */
    BOOL  bIsEnableGlasses;                        /*  0 1 */
    BOOL  bIsEnableMaskFlag;                       /*  0 1 */
    BOOL  bIsEnableTemp;                           /*  0 1 */
    BYTE  byRes[256];                              
}NETDEV_FACE_ATTR_INFO_S, *LPNETDEV_FACE_ATTR_INFO_S;

/**
 * @struct tagNETDEVPedAttrInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPedAttrInfo
{
    BOOL  bIsEnableGender;                         /*  0 1 */
    BOOL  bIsEnableAge;                            /*  0 1 */
    BOOL  bIsEnableMaskFlag;                       /*  0 1 */
    BOOL  bIsEnableUpperColor;                     /*  0 1 */
    BOOL  bIsEnableLowerColor;                     /*  0 1 */
    BOOL  bIsEnableUpClothesTexture;               /*  0 1 */
    BOOL  bIsEnableUpperClothingStyle;             /*  0 1 */
    BOOL  bIsEnableLowerClothingStyle;             /*  0 1 */
    BOOL  bIsEnableShoes;                          /*  0 1 */
    BOOL  bIsEnableBodyAngle;                      /*  0 1 */
    BOOL  bIsEnableBagInfo;                        /*  0 1 */
    BOOL  bIsEnableHairStyle;                      /*  0 1 */
    BOOL  bIsEnableDirection;                      /*  0 1 */
    BYTE  byRes[256];                              
}NETDEV_PED_ATTR_INFO_S, *LPNETDEV_PED_ATTR_INFO_S;

/**
 * @struct tagNETDEVNoMotorVehAttrInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNoMotorVehAttrInfo
{
    BOOL  bIsEnableGender;                         /*  0 1 */
    BOOL  bIsEnableAge;                            /*  0 1 */
    BOOL  bIsEnableUpperColor;                     /*  0 1 */
    BOOL  bIsEnableUpperClothingStyle;             /*  0 1 */
    BOOL  bIsEnableNonVehicleType;                 /*  0 1 */
    BOOL  bIsEnableDirection;                      /*  0 1 */
    BOOL  bIsEnableSpeed;                          /*  0 1 */
    BOOL  bEnablePlateNumber;                      /*  0 1 */
    BOOL  bEnablePlateType;                        /*  0 1 */
    BOOL  bEnablePlateColor;                       /*  0 1 */
    BOOL  bEnableLaneNo;                           /*  0 1 */
    BOOL  bEnablePeccancy;                         /*  0 1 */
    BYTE  byRes[256];                              
}NETDEV_NO_MOTOR_VEH_ATTR_INFO_S, *LPNETDEV_NO_MOTOR_VEH_ATTR_INFO_S;

/**
 * @struct tagNETDEVMotorVehAttrInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVMotorVehAttrInfo
{
    BOOL  bIsEnableLogo;                           /*  0 1 */
    BOOL  bIsEnableVehicleType;                    /*  0 1 */
    BOOL  bIsEnableVehicleColor;                   /*  0 1 */
    BOOL  bIsEnablePlateNumber;                    /*  0 1 */
    BOOL  bIsEnablePlateType;                      /*  0 1 */
    BOOL  bIsEnablePlateColor;                     /*  0 1 */
    BOOL  bIsEnableDirection;                      /*  0 1 */
    BOOL  bIsEnableSpeed;                          /*  0 1 */
    BOOL  bEnableSunVisor;                         /*  0 1 */
    BOOL  bEnableSeatBelt;                         /*  0 1 */
    BOOL  bEnableDriverMobile;                     /*  0 1 */
    BOOL  bEnableAim;                              /*  0 1 */
    BOOL  bEnablePendant;                          /*  0 1 */
    BOOL  bEnableLaneNo;                           /*  0 1 */
    BOOL  bEnablePeccancy;                         /*  0 1 */
    BOOL  bEnableYellowPlateMark;                  /*  0 1 */
    BOOL  bEnableVehicleBrandType;                 /*  0 1 */
    BOOL  bEnableDangerousGoodsMark;               /*  0 1 */
    BYTE  byRes[256];                              
}NETDEV_MOTOR_VEH_ATTR_INFO_S, *LPNETDEV_MOTOR_VEH_ATTR_INFO_S;

/**
 * @struct tagNETDEVAttrCollectInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAttrCollectInfo
{
    BOOL                             bAttributeAll;         /*  0 1 */
    NETDEV_FACE_ATTR_INFO_S          stFaceAttrInfo;        
    NETDEV_PED_ATTR_INFO_S           stPedAttrInfo;         
    NETDEV_NO_MOTOR_VEH_ATTR_INFO_S  stNoMotorVehAttrIofo;  
    NETDEV_MOTOR_VEH_ATTR_INFO_S     stMotorVehAttrInfo;    
    BYTE                             byRes[512];            
}NETDEV_ATTR_COLLECT_INFO_S, *LPNETDEV_ATTR_COLLECT_INFO_S;


/*                             ORG                                 */


/**
 * @struct tagstNETDEVOrgChnShortInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVOrgChnShortInfo
{
    INT32 dwOrgID;              /* ID */
    INT32 dwChannelsNum;        
    INT32 *pdwChnIDs;           /* ID   */
    BYTE  byRes[68];            /*   Reserved field*/
}NETDEV_ORG_CHN_SHORT_INFO_S, *LPNETDEV_ORG_CHN_SHORT_INFO_S;

/**
 * @struct tagstNETDEVOrgDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDelOrgDetailInfo
{    
    INT32 dwOrgNum;     
    INT32 *pdwOrgIDs;   /* IDdwOrgNum  */
    INT32 dwOrgType;    /*   NETDEV_ORG_TYPE_E */
    BYTE  byRes[64];    /*   Reserved field*/
}NETDEV_DEL_ORG_INFO_S, *LPNETDEV_DEL_ORG_INFO_S;

/**
 * @struct tagstNETDEVOrgDelDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVOrgDelDetailInfo
{    
    INT32                   dwStatus;                             /*   NETDEV_ORG_RESPONSE_STAUTE_E */
    INT32                   dwNum;                                
    LPNETDEV_OPERATE_INFO_S pstResultInfo;                        
    BYTE                    byRes[68];                            /*   Reserved field*/
}NETDEV_ORG_BATCH_DEL_INFO_S, *LPNETDEV_ORG_BATCH_DEL_INFO_S;

/**
 * @struct tagNETDEVDCPlaybackCond
 * @brief DC 
 * @attention  None
 */
typedef struct tagNETDEVDCPlaybackCond
{
    INT32   dwChannelID;                    /* ID  Channel ID */
    INT32   dwTVWallID;                     /* ID */
    INT32   dwWinIndex;                     
    INT32   dwSubWinIndex;                  
    INT32   dwStreamType;                   /* ,# NETDEV_STREAM_TYPE_E */
    INT64   tBeginTime;                     
    INT64   tEndTime;                       
    INT32   dwTransProto;                   /* ,# NETDEV_TRANSPORT_PROTOCOL_E */
    INT32   dwRecordType;                   /* ,.# NETDEV_STORE_TYPE_E */
    INT32   dwRecordLocation;               /* # NETDEV_RECORD_LOCATION_E */
    BOOL    bRealtimeSync;                  
    CHAR    szUrl[NETDEV_LEN_260];          /* Url */
    BYTE    byRes[196];                     /*   Reserved */
}NETDEV_DC_PLAYBACK_COND_S, *LPNETDEV_DC_PLAYBACK_COND_S;

/**
 * @struct tagNETDEVDCPlaybackCond
 * @brief DC 
 * @attention  None
 */
typedef struct tagNETDEVDCTransWinCond
{
    INT32   dwChannelID;                /* ID */
    UINT32  udwSessionID;               
    INT64   tBeginTime;                 
    INT64   tEndTime;                   
    INT32   dwLinkMode;                 /* # NETDEV_TRANS_PROTOCAL_E */
    LPVOID  hPlayWnd;                   
    INT32   dwTransType;                /* # NETDEV_TRANS_TYPE_E */
    BYTE    byRes[124];                 
}NETDEV_DC_TRANS_WIN_COND_S, *LPNETDEV_DC_TRANS_WIN_COND_S;

/**
 * @struct tagstNETDEVAlarmPlanAlarmSrcInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanAlarmSrcInfo
{
    INT32 dwAlarmType;          
    INT32 dwAlarmSubType;       
    INT32 dwAlarmSrcID;         /* ID */
}NETDEV_ALARM_PLAN_ALARMSRCINFO_S, *LPNETDEV_ALARM_PLAN_ALARMSRCINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkPreset
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkPreset
{
    INT32 dwChnID;      /* ID */
    INT32 dwPresetID;   
}NETDEV_ALARM_PLAN_LINKPRESET_S, *LPNETDEV_ALARM_PLAN_LINKPRESET_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkSwitchOut
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkSwitchOut
{
    INT32   dwSwitchOutChnID;          /* ID */
    BYTE    byRes[256];                
}NETDEV_ALARM_PLAN_LINKSWITCHOUT_S, *LPNETDEV_ALARM_PLAN_LINKSWITCHOUT_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkMonitor
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkMonitor
{
    INT32 dwChnID;                          /* ID */
    INT32 dwMonitorDelay;                   /*  s */
}NETDEV_ALARM_PLAN_LINKMONITOR_S, *LPNETDEV_ALARM_PLAN_LINKMONITOR_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkTvwall
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkTvwall
{
    INT32 dwTaskID;                          /* ID */
    INT32 dwTaskDelayTime;                   
}NETDEV_ALARM_PLAN_LINKTVWALL_S, *LPNETDEV_ALARM_PLAN_LINKTVWALL_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkRuleInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkRuleInfo
{
    INT32                             dwLinkType;                                         /* ()# NETDEV_ALARM_LINK_TYPE_E */
    INT32                             dwLinkPresetSize;                                   
    NETDEV_ALARM_PLAN_LINKPRESET_S    astLinkPreset[NETDEV_ALARM_LINK_PRESET_NUM];        
    INT32                             dwSwitchOutSize;                                    
    NETDEV_ALARM_PLAN_LINKSWITCHOUT_S astSwitchOut[NETDEV_ALARM_LINK_SWITCHOUT_NUM];      
    INT32                             dwLinkMonitorSize;                                  
    BOOL                              bIsMonitorLinkScr;                                  /*  0 1 */
    NETDEV_ALARM_PLAN_LINKMONITOR_S   astLinkMonitor[NETDEV_ALARM_LINK_MONITOR_NUM];      
    INT32                             dwLinkTVWallSize;                                   
    NETDEV_ALARM_PLAN_LINKTVWALL_S    astLinkTVWall[NETDEV_ALARM_LINK_TVWALL_NUM];        
    CHAR                              szLinkSoundInfo[NETDEV_ALARM_LINK_SOUND_LEN];       
    BYTE                              byRes[512];                                         /*   Reserved */
}NETDEV_ALARM_PLAN_LINKRULEINFO_S, *LPNETDEV_ALARM_PLAN_LINKRULEINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkInfo
{
    INT32                            dwLinkRuleID;                              /* ID */
    INT32                            dwAlarmSrcSize;                            
    NETDEV_ALARM_PLAN_ALARMSRCINFO_S astAlarmSrc[NETDEV_ALARM_SOURCE_NUM];      
    NETDEV_ALARM_PLAN_LINKRULEINFO_S stLinkRuleInfo;                            
}NETDEV_ALARM_PLAN_LINKINFO_S, *LPNETDEV_ALARM_PLAN_LINKINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanDetailInfo
{
    INT32                        dwPlanType;                                                 
    INT32                        dwPlanID;                                                   /* ID */
    CHAR                         szPlanName[NETDEV_NAME_MAX_LEN];                            
    INT32                        dwTimeTamplateID;                                           /* ID */
    CHAR                         szPlanDesc[NETDEV_DESCRIBE_MAX_LEN];                        
    BOOL                         bEnable;                                                    
    INT32                        dwLinkInfoSize;                                             
    NETDEV_ALARM_PLAN_LINKINFO_S astLinkInfo[NETDEV_ALARM_LINK_NUM];                         
}NETDEV_ALARM_PLAN_DETAILINFO_S, *LPNETDEV_ALARM_PLAN_DETAILINFO_S;

/**
 * @struct tagstNETDEVTimeTemplateList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTimeTemplateList
{
    INT32                  dwSize;                                          
    NETDEV_TIME_TEMPLATE_S astTimeTemplate[NETDEV_TIME_TEMPLATE_NUM];       
}NETDEV_TIME_TEMPLATE_LIST_S, *LPNETDEV_TIME_TEMPLATE_LIST_S;

/**
 * @struct tagstNETDEVViewBasicInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVViewBasicInfo
{
    INT32   dwPlanID;                                           /* ID */
    CHAR    szPlanName[NETDEV_NAME_MAX_LEN];                    
    INT32   dwOrderNo;                                          
    CHAR    szPlanDesc[NETDEV_DESCRIBE_MAX_LEN];                
    INT32   dwLayout;                                           /* , # NETDEV_LAYOUT_TYPE_E */
    BYTE    byRes[124];                                         /*   Reserved */
}NETDEV_VIEW_BASIC_INFO_S, *LPNETDEV_VIEW_BASIC_INFO_S;

/**
 * @struct tagstNETDEVScenesTimeTable
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVScenesTimeTable
{
    UINT32   udwScenseID;                             /* ID */
    CHAR     szStartTime[NETDEV_LEN_16];              /*  HH:MM  : 8*/
    BYTE     byRes[128];                              /*   Reserved */
}NETDEV_SCENES_TIME_TABLE_INFO_S, *LPNETDEV_SCENES_TIME_TABLE_INFO_S;

/**
 * @struct tagstNETDEVScenesPlanInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVScenesPlanInfo
{
    NETDEV_VIEW_BASIC_INFO_S          stScenesBasicInfo;                 
    UINT32                            udwStatus;                         /*   NETDEV_DC_SEQ_STATUS_E */
    UINT32                            udwPlanMode;                       /*   0 124  NETDEV_PLANS_MODE_E */
    UINT32                            udwInterval;                       /* ,  PlanMode0 */
    UINT32                            udwSceneNum;                       /*    PlanMode0*/
    UINT32                            audwSceneID[NETDEV_LEN_1024];      /* ID  PlanMode0*/
    UINT32                            udwTimeTableNum;                   
    NETDEV_SCENES_TIME_TABLE_INFO_S   astTimeTable[NETDEV_LEN_1024];     /*   PlanMode1*/
    BYTE                              byRes[128];                        /*   Reserved */
}NETDEV_SCENES_PLAN_INFO_S, *LPNETDEV_SCENES_PLAN_INFO_S;

/**
 * @struct tagstNETDEVResInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVResInfo
{
    INT32   dwWinIndex;                               
    INT32   dwResType;                                /*  # NETDEV_VIEW_TYPE_E */
    INT32   dwResID;                                  /* ID */
    INT32   dwStreamIndex;                            
    INT32   dwPresetID;                               /* ID */
}NETDEV_RES_INFO_S, *LPNETDEV_RES_INFO_S;

/**
 * @struct tagstNETDEVViewDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVViewDetailInfo
{
    NETDEV_VIEW_BASIC_INFO_S       stBasicInfo;                                      
    INT32                          dwViewResSize;                                    
    NETDEV_RES_INFO_S              astViewResInfo[NETDEV_VIEW_MAX_WIN_NUM];          
}NETDEV_VIEW_DETAIL_INFO_S, *LPNETDEV_VIEW_DETAIL_INFO_S;

/**
 * @struct tagstNETDEVViewPlanModeInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVViewPlanModeInfo
{
    UINT32   udwViewID;                                                  /* ID*/
    UINT32   udwInterval;                                                /*  */
    CHAR     szStartTime[NETDEV_LEN_16];                                 /*  HH:MM [1, 8]*/
    BYTE     byRes[128];                                                 /*   Reserved */
}NETDEV_VIEW_PLAN_MODE_INFO_S, *LPNETDEV_VIEW_PLAN_MODE_INFO_S;

/**
 * @struct tagstNETDEVViewPlanInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVViewPlanInfo
{
    NETDEV_VIEW_BASIC_INFO_S         stScenesBasicInfo;                       
    UINT32                           udwStatus;                               /*   NETDEV_DC_SEQ_STATUS_E*/
    UINT32                           udwPlanMode;                             /*   0 124,  NETDEV_PLANS_MODE_E */
    NETDEV_VIEW_PLAN_MODE_INFO_S     astViewPlanInfoList[NETDEV_LEN_1024];    /*  udwPlanMode */
    UINT32                           udwPlanNum;                              
    BYTE                             byRes[128];                              /*   Reserved */
}NETDEV_VIEW_PLAN_INFO_S, *LPNETDEV_VIEW_PLAN_INFO_S;

/**
 * @struct tagstNETDEVEMapPicInfo
 * @brief  
 * @attention 
 */
typedef struct tagstNETDEVEMapPicInfo
{
    UINT32  udwID;                                /* ID */
    CHAR    szName[NETDEV_LEN_128];               /* [0,127] */
    UINT32  udwType;                              /*   NETDEV_EMAP_PIC_TYPE */
    UINT32  udwSubType;                           /* 1SubType  NETDEV_EMAP_PIC_SUBTYPE */
    BOOL    bIsBuiltin;                           /*  1 0 */
    CHAR    szURL[NETDEV_LEN_128];                /* URL */
    BYTE    byRes[128];                           
}NETDEV_EMAP_PIC_INFO_S, *LPNETDEV_EMAP_PIC_INFO_S;

/**
 * @struct tagstNETDEVEEmapMarkerStyle
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVEEmapMarkerStyle
{
    UINT32  udwColor;       /*   NETDEV_EMAP_MARKER_COLOR_E */
    UINT32  udwPicID;       /* ID */
}NETDEV_EMAP_MARKER_STYLE_S;

/**
 * @struct tagstNETDEVEMapMarkerInfo
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVEMapMarkerInfo
{
    UINT32                     udwID;                                 /* ID  */
    UINT32                     udwPID;                                /* ID  */
    UINT32                     udwType;                               /* # NETDEV_EMAP_MARKER_TYPE_E */
    UINT32                     udwLinkID;                             /* IDID */
    NETDEV_EMAP_MARKER_STYLE_S stMarkerStyle;                         
    DOUBLE                     fPosX;                                 
    DOUBLE                     fPosY;                                 
    CHAR                       szName[NETDEV_LEN_128];                /* / */
}NETDEV_EMAP_MARKER_INFO_S, *LPNETDEV_EMAP_MARKER_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeResInfo
 * @brief DC
 * @attention 
 */
typedef struct tagstNETDEVDCSchemeResInfo
{
    INT32   dwResID;                                    /* ID  */
    BOOL    bEnable;                                    
    CHAR    szName[NETDEV_NAME_MAX_LEN];                
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];            
}NETDEV_DC_SCHEME_RES_INFO_S, *LPNETDEV_DC_SCHEME_RES_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeResChnInfo
 * @brief DC
 * @attention
 */
typedef struct tagstNETDEVDCSchemeResChnInfo
{
    INT32   dwIndex;                                            
    INT32   dwChannelID;                                        /* ID */
    INT32   dwStreamIndex;                                      
    INT32   dwPresetID;                                         /* ID */
}NETDEV_DC_SCHEME_RES_CHN_INFO_S, *LPNETDEV_DC_SCHEME_RES_CHN_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeRes
 * @brief DC
 * @attention 
 */
typedef struct tagstNETDEVDCSchemeResource
{
    NETDEV_DC_SCHEME_RES_INFO_S         stResInfo;                                          
    INT32                               dwIntervalTime;                                     /* (s) */
    INT32                               dwSize;                                             
    NETDEV_DC_SCHEME_RES_CHN_INFO_S     astChnInfo[NETDEV_DC_SCHEME_RES_CHN_MAX_NUM];       
}NETDEV_DC_SCHEME_RESOURCE_S, *LPNETDEV_DC_SCHEME_RESOURCE_S;

/**
 * @struct tagstNETDEVRoleRight
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVRoleRight
{
    UINT32 udwMajorRight;     /*   # NETDEV_MAJOR_RIGHT_E */
    UINT32 udwMinorRight;     /*   # NETDEV_MINOR_RIGHT_XXXX_E */
}NETDEV_ROLE_RIGHT_S, *LPNETDEV_ROLE_RIGHT_S;

/**
 * @struct tagstNETDEVOrgTreeList
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVOrgTreeList
{
    INT32 dwSize;                                               
    INT32 adwOrgRootID[NETDEV_MAX_ORG_ROOT_ID_NUM];             /* ID */
}NETDEV_ORG_TREE_S, *LPNETDEV_ORG_TREE_S;

/**
 * @struct tagstNETDEVRoleRightList
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVRoleRightList
{
    INT32               dwSize;                                         
    NETDEV_ROLE_RIGHT_S astRoleRight[NETDEV_MAX_ROLE_RIGHT_SIZE];       
    NETDEV_ORG_TREE_S   stOrgTreeInfo;                                  
}NETDEV_RIGHT_LIST_S, *LPNETDEV_RIGHT_LIST_S;

/**
 * @struct tagstNETDEVTimeDuration
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVTimeDuration
{
    INT64    tBeginTime;                              
    INT64    tEndTime;                                
    INT32    dwPlanType;                              /*  NETDEV_TIME_TEMPLATE_PLAN_TYPE_E */
}NETDEV_TIME_DURATION_S, *LPNETDEV_TIME_DURATION_S;

/**
 * @struct tagstNETDEVTimeDurationList
 * @brief 24
 * @attention 
 */
typedef struct tagstNETDEVTimeDurationList
{
    INT32                     dwSize;                                                      
    NETDEV_TIME_DURATION_S    astTimeDurationList[NETDEV_TIME_DURATION_NUM];               
}NETDEV_TIME_DURATION_LIST_S, *LPNETDEV_TIME_DURATION_LIST_S;

/**
 * @struct tagstNETDEVTimeRange
 * @brief 8
 * @attention
 */
typedef struct tagstNETDEVTimeRange
{
    INT32                            dwSize;                                         
    NETDEV_TIME_DURATION_LIST_S      astTimeRangeList[NETDEV_TIME_RANGE_NUM];        
}NETDEV_TIME_RANGE_S, *LPNETDEV_TIME_RANGE_S;

/**
 * @struct tagstNETDEVTimeTemplateInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTimeTemplateInfoV30
{
    CHAR                    szTamplateName[NETDEV_NAME_MAX_LEN];            
    CHAR                   szTamplateDesc[NETDEV_DESCRIBE_MAX_LEN];         
    INT32                  dwTemplateType;                                  /*   NETDEV_TIME_TEMPLATE_TYPE_E */
    NETDEV_TIME_RANGE_S    stTimeRange;                                     /* 8 */
}NETDEV_TIME_TEMPLATE_INFO_V30_S, *LPNETDEV_TIME_TEMPLATE_INFO_V30_S;

/**
 * @struct tagstNETDEVHolidayTimeInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVHolidayTimeInfo
{
    INT32     dwYear;                               
    INT32     dwMonth;                              
    INT32     dwDay;                                
    INT32     dwWeekOfMonth;                        
    INT32     dwWeekDay;                            
}NETDEV_HOLIDAY_TIME_INFO_S, *LPNETDEV_HOLIDAY_TIME_INFO_S;

/**
 * @struct tagstNETDEVHolidayInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVHolidayInfo
{
    INT32                         dwHolidayID;                            
    CHAR                          szHolidayName[NETDEV_NAME_MAX_LEN];     
    INT32                         dwStatus;                               /* (01) */
    INT32                         dwRepeatType;                           /* (01) */
    INT32                         dwHolidayType;                          /* (01) */
    NETDEV_HOLIDAY_TIME_INFO_S    stBeginTime;                            
    NETDEV_HOLIDAY_TIME_INFO_S    stEndTime;                              
}NETDEV_HOLIDAY_INFO_S, *LPNETDEV_HOLIDAY_INFO_S;

/**
 * @struct tagstNETDEVHolidayInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVHolidayInfoList
{
    INT32                        dwSize;                                        
    NETDEV_HOLIDAY_INFO_S        astHolidayInfoList[NETDEV_HOLIDAY_INFO_NUM];   
}NETDEV_HOLIDAY_INFO_LIST_S, *LPNETDEV_HOLIDAY_INFO_LIST_S;

/**
 * @struct tagNETDEVPaneBindInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPaneBindInfo
{
    UINT32  udwVideoInChannelID;              /* ID */
    UINT32  udwStreamID;                      /* ID */
}NETDEV_PANE_BIND_INFO_S, *LPNETDEV_PANE_BIND_INFO_S;

/**
 * @struct tagNETDEVPaneBindService
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPaneBindService
{
    UINT32                       udwTVWallID;                 /* ID */
    UINT32                       udwWindowID;                 /* ID */
    UINT32                       udwPaneID;                   /* ID */
    UINT32                       udwPaneOperateType;          /*   NETDEV_PANE_OPERATE_TYPE_E */
    NETDEV_PANE_BIND_INFO_S      udwPaneBindInfo;             
}NETDEV_PANE_BIND_SERVICE_S, *LPNETDEV_PANE_BIND_SERVICE_S;

/**
 * @struct tagNETDEVXWPaneInfo
 * @brief XW
 * @attention
 */
typedef struct tagNETDEVVideoInSource
{
    UINT32  udwPaneID;          
    INT32   dwChannelID;        /* ID */
    UINT32  udwStreamIndex;     
    UINT32  udwTaskNo;          
    UINT32  udwTransProtocal;   /*   NETDEV_LAPI_TRANS_PROTOCAL_E */
    UINT32  udwSessionType;     /*   NETDEV_SESSION_TYPE_E */
}NETDEV_VIDEO_IN_SOURCE_INFO_S, *LPNETDEV_VIDEO_IN_SOURCE_INFO_S;

/**
 * @struct tagNETDEVXWSceneWndInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVVideoInChnInfo
{
    UINT32                              udwWndID;                             /* ID */
    UINT32                              udwSeqResID;                          /* ID */
    UINT32                              udwSeqStatus;                         /*   NETDEV_SEQ_STATUS_E */
    NETDEV_VIDEO_IN_SOURCE_INFO_S       stVideoInSourceInfo;                  
}NETDEV_VIDEO_IN_CHN_INFO_S, *LPNETDEV_VIDEO_IN_CHN_INFO_S;

/**
 * @struct tagNETDEVSceneWndInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVSceneWndInfo
{
    UINT32              udwWndID;                            /* ID */
    UINT32              udwDChlID;                           /* DCID */
    CHAR                szName[NETDEV_WND_NAME_LEN];         
    UINT32              udwWndType;                          /*  NETDEV_TVWALL_WND_TPYE_E */
    UINT32              udwStatus;                           /* 01 */
    UINT32              udwPaneMod;                          /*   NETDEV_LAYOUT_TYPE_E */
    UINT32              udwZoomType;                         /*   NETDEV_XW_ZOOM_TYPE_E zoom Type see NETDEV_XW_ZOOM_TYPE_E */
    UINT32              udwSplitIndex;                       /*   ZoomType1*/
    UINT32              udwLayer;                            
    UINT32              udwTransparency;                     
    NETDEV_XW_AREA_S    stArea;                              
}NETDEV_SCENE_WND_INFO_S, *LPNETDEV_SCENE_WND_INFO_S;

/**
 * @struct tagstNETDEVResInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVGroupSeqInfo
{
    UINT32                      udwSeqID;           /* ID */
    BOOL                        bEnabled;           
    UINT32                      udwResourceID;      /* ID */
    UINT32                      udwStatus;          /*   NETDEV_SEQ_STATUS_E */
    UINT32                      udwWndNum;          
    LPNETDEV_SCENE_WND_INFO_S   audwWndIDList;      
}NETDEV_GROUP_SEQ_INFO_S, *LPNETDEV_GROUP_SEQ_INFO_S;

/**
 * @struct tagNETDEVXWSceneDetailInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSceneDetailInfoEx
{
    UINT32                              udwVirtualLedNum;       /* LED */
    LPNETDEV_XW_VIRTUAL_LED_INFO_S      pstVirtualLedInfo;      /* LED */
    UINT32                              udwWndNum;              
    LPNETDEV_SCENE_WND_INFO_S           pstWndInfo;             
    UINT32                              udwGroupSeqNums;        
    LPNETDEV_GROUP_SEQ_INFO_S           pstGroupSeqInfo;        
    UINT32                              udwVideoChnNums;        
    LPNETDEV_VIDEO_IN_CHN_INFO_S        pstVideoInChnInfo;      
}NETDEV_XW_SCENE_DETAIL_INFO_EX_S, *LPNETDEV_XW_SCENE_DETAIL_INFO_EX_S;

/**
 * @struct tagNETDEVXWWndIndex
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWWndIndex
{
    UINT32  udwTVWallID;    /* ID */
    UINT32  udwWndID;       /* ID */
}NETDEV_XW_WND_INDEX_S, *LPNETDEV_XW_WND_INDEX_S;

/**
 * @struct tagNETDEVXWLEDIndex
 * @brief LED 
 * @attention
 */
typedef struct tagNETDEVXWLEDIndex
{
    UINT32  udwTVWallID;        /* ID */
    UINT32  udwVirtualLEDID;    /* LED ID */
}NETDEV_XW_LED_INDEX_S, *LPNETDEV_XW_LED_INDEX_S;

/**
 * @struct tagNETDEVXWBatchResuleInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBatchResuleInfo
{
    UINT32  udwReqSeq;          
    UINT32  udwResuleCode;      
    UINT32  udwID;              /*ID*/
}NETDEV_XW_BATCH_RESULT_INFO_S,*LPNETDEV_XW_BATCH_RESULT_INFO_S;

/**
 * @struct tagNETDEVXWAudioOutputInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWAudioOutputInfo
{
    UINT32  udwID;          /* ID */
    UINT32  udwVolum;       
    UINT32  udwIsMute;      
    BYTE    byRes[64];      
}NETDEV_XW_AUDIO_OUTPUT_INFO_S,*LPNETDEV_XW_AUDIO_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVXWWinAudioOutputInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWWinAudioOutputInfo
{
    UINT32                        udwWindowID;                  /* ID */
    UINT32                        udwPanelID;                   
    NETDEV_XW_AUDIO_OUTPUT_INFO_S stXWAudioOutputInfo;          
    BYTE                          byRes[64];                    
}NETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S,*LPNETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVXWWinAudioOutputList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVXWWinAudioOutputList
{
    UINT32                            udwNum;                                             
    NETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S stXWWinAudioOutputInfo[NETDEV_AUDIO_MAX_NUM];       
    BYTE                              byRes[64];                                          
}NETDEV_XW_WIN_AUDIO_OUTPUT_LIST_S,*LPNETDEV_XW_WIN_AUDIO_OUTPUT_LIST_S;

/**
 * @struct tagNETDEVXWPriviewInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWPriviewInfo
{
    UINT32  udwTVWallID;        /* ID */
    UINT32  udwWndID;           /* ID */
    UINT32  udwPaneID;          /* ID */
    INT32   dwChannelID;        /* ID */
    UINT32  udwStreamIndex;     
    UINT32  udwTransProtocal;   
    UINT32  udwTransType;       /* (0)(1) */
}NETDEV_XW_PRIVIEW_INFO_S, *LPNETDEV_XW_PRIVIEW_INFO_S;

/**
 * @struct tagNETDEVXWPlayBackCond
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWPlayBackCond
{
    UINT32  udwTVWallID;            /* ID */
    UINT32  udwWndID;               /* ID */
    UINT32  udwPaneID;              /* ID */
    INT32   dwChannelID;            /* ID */
    UINT32  udwBeginTime;           
    UINT32  udwEndTime;             
    UINT32  udwStoreType;           /*   NETDEV_STORE_TYPE_E */
    UINT32  udwRecordLocation;      
    UINT32  udwSessionID;           /* session id */
}NETDEV_XW_PLAY_BACK_COND_S, *LPNETDEV_XW_PLAY_BACK_COND_S;

/**
 * @struct tagNETDEVXWPlayBackCond
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWSequenceCond
{
    UINT32  udwTVWallID;        /* ID */
    UINT32  udwSeqID;           /* ID */
    UINT32  udwResourceType;    /*   NETDEV_XW_SEQ_RESOURCE_TYPE_E */
    UINT32  udwResourceID;      /* ID */
    UINT32  udwSeqCmd;          /* , NETDEV_XW_SEQ_CMD_E */
}NETDEV_XW_SEQUENCE_COND_S, *LPNETDEV_XW_SEQUENCE_COND_S;

/**
 * @struct tagstNETDEVVersionInfo
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVVersionInfo
{
    UINT32  udwDefaultLang;                         /*   NETDEV_LANG_TYPE_E */
    UINT32  udwNum;                                 
    UINT32  audwLangType[NETDEV_LEN_16];            /*   NETDEV_LANG_TYPE_E ,*/
    UINT32  udwRegionType;                          /*   NETDEV_REGION_TYPE_E */
    UINT32  udwCustomType;                          /*    NETDEV_CUSTOM_TYPE_E */
    CHAR    szWin32ClientVision[NETDEV_LEN_64];     /* 32C/S[1,32]] */
    CHAR    szWin64ClientVision[NETDEV_LEN_64];     /* 64C/S[1,32]] */
    CHAR    szAgentClientVision[NETDEV_LEN_64];     /* agent[1,32] */
    CHAR    szEztoolClientVision[NETDEV_LEN_64];    /* Eztool[1,32] */
    CHAR    szUNPClientVision[NETDEV_LEN_64];       /* UNP[1,32] */
    CHAR    szGateClientVersion[NETDEV_LEN_64];     /* EZGate[1,32] */
    BYTE    byRes[192];                             
}NETDEV_VERSION_INFO_S, *LPNETDEV_VERSION_INFO_S;

/**
 * @struct tagNETDEVXWDecodeInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWDecodeInfo
{
    UINT32                 udwTvWallID;                               /* ID*/
    CHAR                   szTVWallCode[NETDEV_LEN_64];               /* [1,64] */
    UINT32                 udwWndID;                                  /* ID*/
    UINT32                 udwWndIndex;                               
    UINT32                 udwPaneID;                                 
    UINT32                 udwChnCode;                                /* 0x01000100211*/
    UINT32                 udwStreamStatus;                           /*   NETDEV_XW_WND_STREAM_STATUS_E */
    CHAR                   szCameraCode[NETDEV_LEN_64];               
    CHAR                   szCameraIP[NETDEV_LEN_64];                 /*  [0,64]*/
    CHAR                   szSourceAddress[NETDEV_LEN_64];            /*  [0,64]*/
    UINT32                 udwSourcePort;                             
    CHAR                   szDestAddress[NETDEV_LEN_64];              /* dsp[0,64]*/
    UINT32                 udwDestPort;                               
    CHAR                   szTransport[NETDEV_LEN_16];                /* [0,16], TCP*/
    NETDEV_XW_RESOLUTION_S stResolution;                              
    UINT32                 udwFrameRate;                              
    CHAR                   szVideoEncodeType[NETDEV_LEN_8];           /* [0,8], H.264*/
    CHAR                   szAudioEncodeType[NETDEV_LEN_8];           /* [0,8], G.711U*/
    CHAR                   szFormatType[NETDEV_LEN_16];               /* [0,16], RTP+PSPS*/
    FLOAT                  fPacketDorpRate;                           
    UINT32                 udwPacketDropCnt;                          
    UINT32                 udwTotalPacketNum;                         
    BYTE                   bRes[64];                                  
}NETDEV_XW_DECODE_INFO_S, *LPNETDEV_XW_DECODE_INFO_S;

/**
 * @struct tagNETDEVXWSerialCfgInfo
 * @brief XWID
 * @attention  None
 */
typedef struct tagNETDEVXWSerialCfgInfo
{
    UINT32      udwSerialID;                       /* ID */
    UINT32      udwSerialType;                     /*   NETDEV_XW_SERIAL_TYPE_E */
    UINT32      udwIndex;                          
    UINT32      udwSerialMode;                     /*   NETDEV_XW_SERIAL_MODE_E */
    UINT32      udwWorkMode;                       /*  RS232  NETDEV_XW_SERIAL_MODE_E */
    UINT32      udwBaudRate;                       /*  1200240048009600192003840057600115200*/
    UINT32      udwDataBits;                       /*  5678*/
    UINT32      udwStopBits;                       /*  12*/
    UINT32      udwParity;                         /*   NETDEV_XW_PARITY_TYPE_E */
    UINT32      udwFlowCtrl;                       /*   NETDEV_XW_PARITY_TYPE_E */
    BYTE        byRes[128];                        /*   NETDEV_XW_FLOW_CTRL_E */
}NETDEV_XW_SERIAL_CFG_INFO_S, *LPNETDEV_XW_SERIAL_CFG_INFO_S;

/**
 * @struct tagNETDEVXWSerialList
 * @brief XWID
 * @attention  None
 */
typedef struct tagNETDEVXWSerialList
{
    UINT32                          udwNum;                                     
    NETDEV_XW_SERIAL_CFG_INFO_S     stSerialCfgInfo[NETDEV_XW_SERIAL_NUM];      /*   NETDEV_XW_COM_TYPE_E */
    BYTE                            byRes[128];                                 
}NETDEV_XW_DEVICE_SERIAL_LIST_S, *LPNETDEV_XW_DEVICE_SERIAL_LIST_S;

/*
* @struct tagNETDEVDiscoverCondInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVDiscoverCondInfo
{
    CHAR                szBeginIP[NETDEV_LEN_128];    /* IP,0 */
    CHAR                szEndIP[NETDEV_LEN_128];      /* IP,0 */
    UINT32              udwServiceID;                 /* ID,[0-255],0 */
    UINT32              udwAccessMode;                /* NETDEV_DEVICE_ACCESS_MODE_E */
    BYTE                byRes[128];                   /*   Reserved */
}NETDEV_DISCOVER_COND_INFO_S, *LPNETDEV_DISCOVER_COND_INFO_S;

/*
* @struct tagNETDEVDeviceFindCond
* @brief 
* @attention  None
*/
typedef struct tagNETDEVDeviceFindCond
{
    UINT32              udwDeviceType;                  /*   NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32              udwServiceID;                   /* ID,[0-255],0 */
    BYTE                byRes[128];                     /*   Reserved */
}NETDEV_DEVICE_FIND_COND_S, *LPNETDEV_DEVICE_FIND_COND_S;

/*
* @struct tagNETDEVDiscoverDeviceInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVDiscoverDeviceInfo
{
    UINT32              udwDeviceType;                      /*   NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32              udwDeviceSubType;                   /*   NETDEV_DEVICE_SUB_TYPE_E */
    UINT32              udwPort;                            
    BOOL                bIsAdded;                           /* ,FALSETRUE */
    CHAR                szIPAddress[NETDEV_LEN_64];         /* IP */
    CHAR                szDevModel[NETDEV_LEN_64];          
    CHAR                szSerialNumber[NETDEV_LEN_64];      
    CHAR                szFirmwareVersion[NETDEV_LEN_64];   
    CHAR                szDevMac[NETDEV_LEN_64];            /* MAC */
    CHAR                szManufacturer[NETDEV_LEN_64];      
    CHAR                szUniCode[NETDEV_LEN_64];           
    UINT32              udwProtocolType;                    /*  NETDEV_ACCESS_PROTOCOL_E */
    BYTE                byRes[128];                         /*   Reserved */
}NETDEV_DISCOVER_DEV_INFO_S, *LPNETDEV_DISCOVER_DEV_INFO_S;

/*
* @struct tagstNETDEVDevChnCommonInfo
* @brief 
* @attention  None
*/
typedef struct tagstNETDEVDevChnCommonInfo
{    
    UINT32 udwDevID;                                          /* ID */
    UINT32 udwOrgID;                                          /* ID */
    UINT32 udwChnIndex;                                       
    CHAR  szDevName[NETDEV_LEN_256];                          
    UINT32 udwRight;                                          
    BYTE   byRes[128];                                        
}NETDEV_DEV_CHN_COMMON_INFO_S, *LPNETDEV_DEV_CHN_COMMON_INFO_S;

/**
 * @struct tagstNETDEVChnInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVChnInfo
{    
    UINT32                          udwChannelID;               /* ID */
    CHAR                            szChnName[NETDEV_LEN_256];  
    BYTE                            byRes[128];                 
}NETDEV_CHN_INFO_S, *LPNETDEV_CHN_INFO_S;

/**
 * @struct tagNETDEVStreamFormatInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVStreamFormatInfo
{
    UINT32                           udwStreamIndex;             /*   NETDEV_LIVE_STREAM_INDEX_E */
    UINT32                           udwEncodeFormat;            /*   NETDEV_VIDEO_CODE_TYPE_E */
    BYTE                             byRes[128];                 
}NETDEV_STREAM_FORMAT_INFO_S, *LPNETDEV_STREAM_FORMAT_INFO_S;

/**
 * @struct tagstNETDEVDevVideoChnInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevVideoChnInfo
{    
    UINT32                           udwChannelID;                                  /* ID */
    CHAR                             szChnName[NETDEV_LEN_256];                     
    UINT32                           udwChnStatus;                                  /* ,  NETDEV_CHN_STATUS_E */
    CHAR                             szGBID[NETDEV_LEN_32];                         
    NETDEV_DEV_CHN_COMMON_INFO_S     stCommonInfo;                                  
    UINT32                           udwMaxStream;                                  
    BOOL                             bSupportPTZ;                                   
    UINT32                           udwAudioResID;                                 /* ID */
    LPNETDEV_STREAM_FORMAT_INFO_S    pastStreamFormatList;                          /* , */
    UINT32                           udwAbnormalReason;                             /*   NETDEV_CHN_ABNORMAL_REASON_E */
    BYTE                             byRes[120];                                    
}NETDEV_VIDEO_CHN_INFO_S, *LPNETDEV_VIDEO_CHN_INFO_S;

/**
 * @struct tagstNETDEVVideoChnFindCond
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVVideoChnFindCond
{    
    UINT32                           udwDevID;                /* ID */
    UINT32                           udwOrgID;                /* ID */
    UINT32                           udwLimit;                /* [1,500] */
    UINT32                           udwOffset;               /* 0 */
    UINT32                           udwFindType;             /*  NETDEV_VIDEO_CHN_FIND_TYPE_E */
    BYTE                             byRes[128];             
}NETDEV_VIDEO_CHN_FIND_COND_S, *LPNETDEV_VIDEO_CHN_FIND_COND_S;

/**
 * @struct tagstNETDEVOrgFindCond
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVOrgFindCond
{    
    UINT32                           udwOrgType;              /*   NETDEV_ORG_TYPE_E */
    UINT32                           udwRootOrgID;            /* ID */
    UINT32                           udwFindType;             /*  NETDEV_ORG_FIND_MODE_E */
    BYTE                             byRes[128];             
}NETDEV_ORG_FIND_COND_S, *LPNETDEV_ORG_FIND_COND_S;

/**
* @struct tagstNETDEVModifyDevInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVModifyDevInfo
{
    UINT32                            udwID;                              /* ID */
    CHAR                              szDevName[NETDEV_LEN_64];           
    NETDEV_IPADDR_INFO_S              stDevIPAddress;                     /* IP */
    CHAR                              szLoginName[NETDEV_LEN_64];         
    CHAR                              szPasswd[NETDEV_LEN_64];            /* "" */
    UINT32                            udwAccessProtocol;                  /*   NETDEV_ACCESS_PROTOCOL_E */
    UINT32                            udwDevSubType;                      /*  NETDEV_DEVICE_SUB_TYPE_E */
    UINT32                            udwServerID;                        /* ID[0,255] */
    UINT32                            udwOrgID;                           
    CHAR                              szDescription[NETDEV_LEN_256];      
    NETDEV_ONVIF_INFO_S               stOnvifInfo;                        /* onvif */
    NETDEV_GBINFO_S                   stGBInfo;                           
    UINT32                            uwdIsPTZNeeded;                     /*  0:   1:   255:  */
    UINT32                            udwDeviceType;                      /*   NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32                            udwCustomProtocolID;                /* IDudwAccessProtocol432 */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;                      /*  Type11 malloc */
    UINT32                            udwChlMaxNum;                       /* AccessProtocol4 */
    UINT32                            udwChlIndexNum;                     /* AccessProtocol4256 */
    UINT32*                           pudwChlIndexList;                   
    BYTE                              byRes[100];                         /*   Reserved field*/
}NETDEV_MODIFY_DEV_INFO_S, *LPNETDEV_MODIFY_DEV_INFO_S;

/**
* @struct tagstNETDEVAddDevBasicInfo
* @brief 
* @attention
*/
typedef struct tagstNETDEVAddDevBasicInfo
{    
    UINT32                            udwReqSeq;                          /* [1, 50] */
    CHAR                              szDevName[NETDEV_LEN_64];           
    NETDEV_IPADDR_INFO_S              stDevIPAddress;                     /* IP */
    CHAR                              szLoginName[NETDEV_LEN_64];         
    CHAR                              szPasswd[NETDEV_LEN_64];            /* "" */
    UINT32                            udwAccessProtocol;                  /*   NETDEV_ACCESS_PROTOCOL_E */
    UINT32                            udwDevType;                         /*  NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32                            udwDevSubType;                      /*  NETDEV_DEVICE_SUB_TYPE_E */
    UINT32                            udwServerID;                        /* ID[0,255] */
    UINT32                            udwOrgID;                           
    CHAR                              szDescription[NETDEV_LEN_256];      
    NETDEV_ONVIF_INFO_S               stOnvifInfo;                        /* onvif */
    NETDEV_GBINFO_S                   stGBInfo;                           
    UINT32                            udwIsPTZNeeded;                     /*  0:   1:   255:   */
    CHAR                              szSN[NETDEV_LEN_32];                /* Type9SubType7[1,20] */
    CHAR                              szIMEI[NETDEV_LEN_32];              /* Type9SubType8,[1,16] */
    CHAR                              szDeviceCode[NETDEV_LEN_32];        /*  [1,32]   */
    UINT32                            udwCustomProtocolID;                /* IDudwAccessProtocol432 */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;                      /*  Type11 malloc */
    UINT32                            udwChlMaxNum;                       /* AccessProtocol4 */
    UINT32                            udwChlIndexNum;                     /* AccessProtocol4256 */
    UINT32*                           pudwChlIndexList;                   
    BYTE                              byRes[12];                          /*   Reserved field*/
}NETDEV_ADD_DEV_BASIC_INFO_S, *LPNETDEV_ADD_DEV_BASIC_INFO_S;

/**
 * @struct tagstNETDEVXWAddDevInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVXWAddDevInfo
{
    UINT32                              udwNum;                     
    UINT32                              udwDevType;                 /*  NETDEV_DEVICE_MAIN_TYPE_E */
    LPNETDEV_ADD_DEV_BASIC_INFO_S       pstAddDevBasicInfoList;     
    BYTE                                byRes[128];                 /*   Reserved field */
}NETDEV_ADD_DEV_INFO_S, *LPNETDEV_ADD_DEV_INFO_S;

/**
 * @struct tagNETDEVBatchOperatorInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperatorInfo
{
    UINT32   udwReqSeq;                          
    UINT32   udwResultCode;                      /* ,# NETDEV_PERSON_MONITOR_OPT_RES_CODE_E */
    UINT32   udwID;                              
    CHAR     szName[NETDEV_LEN_260];             /* [1,63] */
    BYTE     byRes[128];                         /*   Reserved */
}NETDEV_BATCH_OPERATOR_INFO_S,*LPNETDEV_BATCH_OPERATOR_INFO_S;

/**
 * @struct tagstNETDEVXWAddDevResultInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVXWAddDevResultInfo
{    
    UINT32                         udwStatus;                       /*  NETDEV_ORG_RESPONSE_STAUTE_E */
    UINT32                         udwNum;                          
    LPNETDEV_BATCH_OPERATOR_INFO_S pstResultInfoList;               
    BYTE                           byRes[128];                      /*   Reserved field */
}NETDEV_ADD_DEV_RESULT_INFO_S, *LPNETDEV_ADD_DEV_RESULT_INFO_S;

/**
 * @struct tagstNETDEVDelDevInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDelDevInfo
{    
    UINT32 udwDevNum;                                         
    UINT32 udwDevType;                                        /*  NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32 *pudwIDs;                                          /* IDdwDevNum  */
    BYTE  byRes[128];                                         /*   Reserved field*/
}NETDEV_DEL_DEV_INFO_S, *LPNETDEV_DEL_DEV_INFO_S;

/**
 * @struct tagstNETDEVDelDevResultInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDelDevResultInfo
{
    UINT32                  udwNum;                                       
    LPNETDEV_OPERATE_INFO_S pstResultInfoList;                            
    BYTE                    byRes[128];                                   /*   Reserved field */
}NETDEV_DEL_DEV_RESULT_INFO_S, *LPNETDEV_DEL_DEV_RESULT_INFO_S;




/**
 * @struct tagNETDEVACSFaceImage
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSFaceImage
{
    UINT32               udwNum;                            
    NETDEV_FILE_INFO_S   stImageList[NETDEV_LEN_16];        
    UINT32               udwMajorImageIndex;                
    BYTE                 byRes[128];                        
}NETDEV_ACS_FACE_IMAGE_S, *LPNETDEV_ACS_FACE_IMAGE_S;

/**
 * @struct tagNETDEVACSStaffInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSStaffInfo
{
    CHAR     szNumber[NETDEV_LEN_16];                               
    CHAR     szBirthday[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           
    CHAR     szDeptName[NETDEV_LEN_260];                            
    UINT32   udwDeptID;                                             /* ID */
    BYTE     byRes[128];                                            
}NETDEV_ACS_STAFF_INFO_S, *LPNETDEV_ACS_STAFF_INFO_S;

 /**
 * @struct tagACSTimeSection
 * @brief 
 * @attention
 */
typedef struct tagACSTimeSection
{
    INT64   tStartTime;                                      /*  UTC s */
    INT64   tEndTime;                                        /*  UTC s */
    BYTE    byRes[32];                                       
}NETDEV_ACS_TIME_SECTION_S, *LPNETDEV_ACS_TIME_SECTION_S;

 /**
 * @struct tagNETDEVACSVisitorInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSVisitorInfo
{
    CHAR                        szVisitorCompany[NETDEV_LEN_260];       /*  [1,64] */
    UINT32                      udwVisitorCount;                        
    UINT32                      udwIntervieweeID;                       /* ID */
    CHAR                        szIntervieweeName[NETDEV_LEN_260];      /*  [1,64] */
    CHAR                        szIntervieweeDept[NETDEV_LEN_260];      /*  [1,64] */
    NETDEV_ACS_TIME_SECTION_S   tScheduleTime;                          
    NETDEV_ACS_TIME_SECTION_S   tRealTime;                              
    UINT32                      udwStatus;                              /*   NETDEV_ACS_VISIT_STATUS_E */
    BYTE                        byRes[128];                             
}NETDEV_ACS_VISITOR_INFO_S, *LPNETDEV_ACS_VISITOR_INFO_S;

/**
 * @struct tagNETDEVIDList
 * @brief ID  
 * @attention  None
 */
typedef struct tagNETDEVIDList
{
    UINT32                          udwNum;                     
    UINT32                         *pudwIDs;                    /* ID Malloc */
    BYTE                            byRes[256];                 
}NETDEV_ID_LIST_S, *LPNETDEV_ID_LIST_S;

/**
 * @struct tagNETDEVACSPersonCardInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonCardInfo
{
    UINT32                      udwCardID;                      /* ID */
    UINT32                      udwCardType;                    
    UINT32                      udwCardStatus;                  /*  # NETDEV_ACS_CARD_STATUS_E  */
    CHAR                        szCardNo[NETDEV_LEN_64];        
    UINT32                      udwReqSeq;                      /* , */
    NETDEV_ACS_TIME_SECTION_S   stValidTime;                    
    BYTE                        byRes[256];                     
}NETDEV_ACS_PERSON_CARD_INFO_S,* LPNETDEV_ACS_PERSON_CARD_INFO_S;

/**
 * @struct tagNETDEVACSPersonInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonInfo
{
    UINT32                          udwReqSeq;                          
    UINT32                          udwPersonID;                        
    CHAR                            szName[NETDEV_LEN_260];             
    UINT32                          udwGender;                          /*   NETDEV_GENDER_TYPE_E */
    NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                     
    CHAR                            szTelephone[NETDEV_LEN_64];         
    CHAR                            szAddress[NETDEV_LEN_260];          
    CHAR                            szDesc[NETDEV_LEN_480];             
    UINT32                          udwCardNum;                         /* [1,6]*/
    NETDEV_ACS_PERSON_CARD_INFO_S   stACSPersonCardList[NETDEV_LEN_6];  
    NETDEV_ACS_FACE_IMAGE_S         stFaceImage;                        
    UINT32                          udwType;                            /*   NETDEV_ACS_PERSON_TYPE_E*/
    NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                        
    NETDEV_ACS_VISITOR_INFO_S       stVisitor;                          
    BYTE                            byRes[256];                         
}NETDEV_ACS_PERSON_INFO_S, *LPNETDEV_ACS_PERSON_INFO_S;

/**
 * @struct tagNETDEVACSPersonList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonList
{
    UINT32                      udwNum;                 
    LPNETDEV_ACS_PERSON_INFO_S  pstPersonInfoList;      /*  udwNum*/
    BYTE                        byRes[128];             
}NETDEV_ACS_PERSON_LIST_S, *LPNETDEV_ACS_PERSON_LIST_S;

/**
 * @struct tagNETDEVFaceBatchInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceBatchInfo
{
    UINT32   udwReqSeq;         
    UINT32   udwResultCode;     
    UINT32   udwID;             
    BYTE     byRes[128];        /*   Reserved */
}NETDEV_FACE_BATCH_INFO_S,*LPNETDEV_FACE_BATCH_INFO_S;

/**
 * @struct tagNETDEVFaceBatchList
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVFaceBatchList
{
    UINT32                      udwNum;         
    LPNETDEV_FACE_BATCH_INFO_S  pstBatchList;   /*  udwNum */
    BYTE                        byRes[128];     /*   Reserved */
}NETDEV_FACE_BATCH_LIST_S,*LPNETDEV_FACE_BATCH_LIST_S;

/**
 * @struct tagNETDEVACSPersonBaseInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonBaseInfo
{
    UINT32                          udwPersonID;                    
    CHAR                            szName[NETDEV_LEN_260];         
    UINT32                          udwGender;                      /*   NETDEV_GENDER_TYPE_E */
    NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                 
    CHAR                            szTelephone[NETDEV_LEN_64];     
    UINT32                          udwCardID;                      
    CHAR                            szCardNo[NETDEV_LEN_16];        
    UINT32                          udwType;                        /*   0  1*/
    NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                    
    NETDEV_ACS_VISITOR_INFO_S       stVisitor;                      
    BYTE                            byRes[256];                     
}NETDEV_ACS_PERSON_BASE_INFO_S, *LPNETDEV_ACS_PERSON_BASE_INFO_S;

/**
 * @struct tagNETDEVACSPersonQueryCond
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonQueryCond
{
    CHAR     szName[NETDEV_LEN_260];                         
    CHAR     szNumber[NETDEV_FACE_IDNUMBER_LEN];             
    UINT32   udwType;                                        /*   0  1*/
    UINT32   udwOffset;                                      /*  0*/
    UINT32   udwLimit;                                       /* 200 */
    BYTE     byRes[128];                                     
}NETDEV_ACS_PERSON_QUERY_COND_S, *LPNETDEV_ACS_PERSON_QUERY_COND_S;

/**
 * @struct tagNETDEVBatchOperateBasicInfo
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateBasicInfo
{
    UINT32   udwTotal;       
    UINT32   udwOffset;      
    UINT32   udwNum;         
    BYTE     byRes[128];     /*   Reserved */
}NETDEV_BATCH_OPERATE_BASIC_S,*LPNETDEV_BATCH_OPERATE_BASIC_S;

/**
 * @struct tagNETDEVACSPersonPermissionInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonPermissionInfo
{
    NETDEV_OPERATE_LIST_S        stPersonList;                    /* ID */
    UINT32                       udwTemplateID;                   /* ID  */
    NETDEV_ACS_TIME_SECTION_S    stValidTime;                     
    NETDEV_OPERATE_LIST_S        stDoorList;                      
    NETDEV_OPERATE_LIST_S        stDoorGroupList;                 
    BYTE                         byRes[256];                      
}NETDEV_ACS_PERSON_PERMISSION_INFO_S, *LPNETDEV_ACS_PERSON_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVACSPermissionGroupInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPermissionGroupInfo
{
    UINT32                       udwPermissionGroupID ;                  /* ID */
    CHAR                         szPermissionGroupName[NETDEV_LEN_260];  
    BYTE                         byRes[256];                             
}NETDEV_ACS_PERMISSION_GROUP_INFO_S, *LPNETDEV_ACS_PERMISSION_GROUP_INFO_S;

/**
 * @struct tagNETDEVACSDoorPermissionInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSDoorPermissionInfo
{
    UINT32                                  udwPermissionNum;                  
    NETDEV_ACS_TIME_SECTION_S               stValidTime;                       
    LPNETDEV_ACS_PERMISSION_GROUP_INFO_S    pstPermissionGroupList;            /* .Num0 */
    BYTE                                    byRes[256];                         
}NETDEV_ACS_DOOR_PERMISSION_INFO_S, *LPNETDEV_ACS_DOOR_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVACSPermissionInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPermissionInfo
{
    UINT32                       udwPermissionID;                   /* ID     */
    CHAR                         szPermissionName[NETDEV_LEN_260];  
    UINT32                       udwPermissionType;                 /* 01 2*/
    NETDEV_OPERATE_LIST_S        stPersonList;                      /* IDdwSize */
    UINT32                       udwTemplateID;                     /* ID */
    NETDEV_ACS_TIME_SECTION_S    stValidTime;                       
    NETDEV_OPERATE_LIST_S        stDoorList;                        /* , dwSize  */
    BYTE                         byRes[256];                        
}NETDEV_ACS_PERMISSION_INFO_S, *LPNETDEV_ACS_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVACSPersonBlacklistInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonBlacklistInfo
{
    UINT32                               udwBlackListID;                    /* ID */
    NETDEV_FACE_MEMBER_ID_INFO_S         stIdentificationInfo;              
    BYTE                                byRes[256];                         
}NETDEV_ACS_PERSON_BLACKLIST_INFO_S, *LPNETDEV_ACS_PERSON_BLACKLIST_INFO_S;

/**
 * @struct tagNETDEVACSPersonPermissionBasicInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonPermissionBasicInfo
{
    UINT32   udwPermissionID;                    
    UINT32   udwPersonID;                        
    CHAR     szPersonName[NETDEV_LEN_260];       
    CHAR     szPersonNumber[NETDEV_LEN_16];      
    UINT32   udwDeptID;                          
    CHAR     szDeptName[NETDEV_LEN_260];         
    UINT32   udwTemplateID;                      /* ID */
    CHAR     szTemplateName[NETDEV_LEN_260];     
    UINT32   udwCardID;                          
    CHAR     szCardNo[NETDEV_LEN_64];            
    UINT32   udwCardStatus;                      
    UINT32   udwAuthStatus;                      /*  0  1*/
    BYTE     byRes[256];                         
}NETDEV_ACS_PERSON_PERMISSION_BASIC_INFO_S, *LPNETDEV_ACS_PERSON_PERMISSION_BASIC_INFO_S;

/**
 * @struct tagNETDEVPermissionGroupInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPermissionGroupInfo
{
    UINT32 udwPermissionGroupID;                                   /* PermissionGroupID */
    CHAR   szPermissionGroupName[NETDEV_LEN_260];                  
    BYTE   byRes[256];                                             
}NETDEV_PERMISSION_GROUP_INFO_S, *LPNETDEV_PERMISSION_GROUP_INFO_S;

/**
 * @struct tagNETDEVCompareInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVCompareInfo
{
    NETDEV_FILE_INFO_S  stPersonImage;                    
    NETDEV_FILE_INFO_S  stSnapshotImage;                  
    BYTE                byRes[128];                       
}NETDEV_COMPARE_INFO_S, *LPNETDEV_COMPARE_INFO_S;

/**
 * @struct tagNETDEVACSAttendanceLogInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSAttendanceLogInfo
{
    UINT32 udwAlarmType;                            
    INT64  tTimeStamp;                              
    CHAR   szDoorName[NETDEV_LEN_260];              
    CHAR   szDoorNo[NETDEV_LEN_64];                 
    UINT32 udwDoorDirect;                           /*  0:,1: */
    CHAR   szCardNo[NETDEV_LEN_64];                 
    CHAR   szPersonName[NETDEV_LEN_260];            
    UINT32 udwPersonType;                           /*    NETDEV_ACS_PERSON_TYPE_E */
    CHAR   szPersonPhone[NETDEV_LEN_64];            
    CHAR   szPersonDept[NETDEV_LEN_260];            
    NETDEV_COMPARE_INFO_S stCompareInfo;            
    NETDEV_FACE_ATTR_S    stFaceAttr;               
    UINT32 udwCardStatus;                           /*  0 1 */
    NETDEV_CTRL_LIB_MATCH_INFO_S stLibMatchInfo;    
    BYTE   byRes[256];                              
}NETDEV_ACS_ATTENDANCE_LOG_INFO_S, *LPNETDEV_ACS_ATTENDANCE_LOG_INFO_S;

 /**
 * @struct tagACSVisitLogInfo
 * @brief 
 * @attention
 */
typedef struct tagACSVisitLogInfo
{
    UINT32 udwLogID;                                /* ID */
    UINT32 udwVisitorID;                            /* ID */
    CHAR   szVisitorName[NETDEV_LEN_260];           /*  [1,64] */
    CHAR   szVisitorCompany[NETDEV_LEN_260];        /*  [1,64] */
    CHAR   szVisitorPhone[NETDEV_LEN_64];           
    CHAR   szCardNo[NETDEV_LEN_16];                 
    UINT32 udwIntervieweeID;                        /* ID */
    CHAR   szIntervieweeName[NETDEV_LEN_260];       /*  [1,64] */
    CHAR   szIntervieweeDept[NETDEV_LEN_260];       /*  [1,64] */
    INT64  tScheduleStartTime;                      /*  UTC s */
    INT64  tRealStartTime;                          /*  UTC s */
    UINT32 udwStatus;                               /*  NETDEV_ACS_VISIT_STATUS_E */
    BYTE   byRes[256];                              
}NETDEV_ACS_VISIT_LOG_INFO_S, *LPNETDEV_ACS_VISIT_LOG_INFO_S;

/**
 * @struct tagNETDEVACSPersonCardList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSPersonCardList
{
    UINT32                              udwNum;             /* 6 */
    LPNETDEV_ACS_PERSON_CARD_INFO_S     pstCardList;        
    BYTE                                byRes[512];         
}NETDEV_ACS_PERSON_CARD_LIST_S, *LPNETDEV_ACS_PERSON_CARD_LIST_S;

/**
 * @struct tagNETDEVACSPersonCardInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSCardInfo
{
    UINT32                              udwCardID;                      /* ID */
    UINT32                              udwCardType;                    /* ,# NETDEV_ACS_CARD_TYPE_E */
    UINT32                              udwCardStatus;                  /* ,# NETDEV_ACS_CARD_STATUS_E */
    CHAR                                szCardNo[NETDEV_LEN_64];        
    UINT32                              udwReqSeq;                      /* , */
    NETDEV_ACS_PERSON_INFO_S            stPersonBaseInfo;               /* , */
    NETDEV_ACS_TIME_SECTION_S           stValidTime;                    
    CHAR                                szPasswd[NETDEV_LEN_256];       
    BYTE                                byRes[256];                     
}NETDEV_ACS_CARD_INFO_S,* LPNETDEV_ACS_CARD_INFO_S;

/**
 * @struct tagNETDEVACSCardList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSCardList
{
    UINT32                      udwNum;                 
    LPNETDEV_ACS_CARD_INFO_S    pstCardList;            
    BYTE                        byRes[256];             
}NETDEV_ACS_CARD_LIST_S, *LPNETDEV_ACS_CARD_LIST_S;

/**
 * @struct tagNETDEVBatchDelResult
 * @brief 
 * @attention
 */
typedef struct tagNETDEVBatchDelResult
{
    UINT32    udwID;            
    UINT32    udwResultCode;    
    BYTE      byRes[256];       
}NETDEV_BATCH_DEL_RESULT_S, *LPNETDEV_BATCH_DEL_RESULT_S;

/**
 * @struct tagNETDEVBatchDeleteResultList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVBatchDeleteResultList
{
    UINT32                                udwNum;           
    UINT32                                udwStatus;        
    LPNETDEV_BATCH_DEL_RESULT_S           pstResultList;    
    BYTE                                  byRes[256];       
}NETDEV_BATCH_DELETE_RESULT_LIST_S, *LPNETDEV_BATCH_DELETE_RESULT_LIST_S;

/**
 * @struct tagNETDEVBatchAddResult
 * @brief 
 * @attention
 */
typedef struct tagNETDEVBatchAddResult
{
    UINT32     udwID;             
    UINT32     udwResultCode;     
    UINT32     udwReqSeq;         
    BYTE       byRes[256];        
}NETDEV_BATCH_ADD_RESULT_S, *LPNETDEV_BATCH_ADD_RESULT_S;

/**
 * @struct tagNETDEVBatchAddResultList
 * @brief 
 * @attention
 */
typedef struct tagNETDEVBatchAddResultList
{
    UINT32                                udwNum;           
    UINT32                                udwStatus;        
    LPNETDEV_BATCH_ADD_RESULT_S           pstResults;       
    BYTE                                  byRes[256];       
}NETDEV_BATCH_ADD_RESULT_LIST_S, *LPNETDEV_BATCH_ADD_RESULT_LIST_S;

/**
 * @struct tagNETDEVACSCardQueryCond
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSCardQueryCond
{
    UINT32                      udwStatus;      /* # NETDEV_ACS_CARD_STATUS_E */
    NETDEV_PAGED_QUERY_INFO_S   stQueryInfo;    
    BYTE                        byRes[256];     
}NETDEV_ACS_CARD_QUERY_COND_S, *LPNETDEV_ACS_CARD_QUERY_COND_S;

/**
 * @struct tagNETDEVACSCardQueryResult
 * @brief 
 * @attention
 */
typedef struct tagNETDEVACSCardQueryResult
{
    UINT32      udwTotal;           
    UINT32      udwOffset;          
    UINT32      udwNum;             
    BYTE        byRes[256];         
}NETDEV_ACS_CARD_QUERY_RESULT_S, *LPNETDEV_ACS_CARD_QUERY_RESULT_S;

/**
 * @struct tagNETDEVAlarmActionType
 * @brief 
 * @attention
 */
typedef struct tagNETDEVSwitchOutputAlarmStatus
{
    UINT32 udwID;               
    INT32  dwAlarmStatus;       
    BYTE   bRes[32];            
}NETDEV_ALARM_STATUS_S,* LPNETDEV_ALARM_STATUS_S;

/*************************************************************************************************************
************************************Begin******************************************************
***************************************************************************************************************/
/**
 * @struct tagstNETDEVDevChnBaseInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnBaseInfo
{    
    INT32 dwChannelID;                                      /* ID */
    INT32 dwDevID;                                          /* ID */
    INT32 dwOrgID;                                          /* ID */
    INT32 dwChnType;                                        /*  NETDEV_CHN_TYPE_E */
    INT32 dwChnStatus;                                      /* ,  NETDEV_CHN_STATUS_E */
    INT32 dwChnIndex;                                       
    CHAR szChnName[NETDEV_NAME_MAX_LEN];                    
    UINT32 udwRight;                                        
    UINT32 udwAbnormalReason;                               /*   NETDEV_CHN_OFFLINE_REASON_E */
    BYTE   byRes[124];                                      
}NETDEV_DEV_CHN_BASE_INFO_S, *LPNETDEV_DEV_CHN_BASE_INFO_S;

/**
 * @struct tagstNETDEVDevChnEncodeInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnEncodeInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;                                  
    INT32                       dwMaxStream;                                    
    NETDEV_STREAM_FORMAT_INFO_S astStreamFormatList[NETDEV_STREAM_MAX_NUM];     
    BOOL                        bSupportPTZ;                                    
    BOOL                        bScrambleEnable;                                
    INT32                       dwAudioResID;                                   /* ID */
    CHAR                        szGBResID[NETDEV_LEN_32];                       /* ID */
    BYTE                        byRes[224];                                     
}NETDEV_DEV_CHN_ENCODE_INFO_S, *LPNETDEV_DEV_CHN_ENCODE_INFO_S;

/**
 * @struct tagQueryCondition
 * @brief 
 * @attention
 */
typedef struct tagQueryCondition
{
    INT32                   dwLimit;                                
    INT32                   dwOffset;                               
    INT32                   dwQryInfoNum;                           
    LPNETDEV_QUERY_INFO_S   pstQueryInfo;                           
    INT32                   dwRecursion;                            /*   0 1 2 */
    BYTE                    byRes[260];                             
}NETDEV_QUERY_CHN_CONDITION_S, *LPNETDEV_QUERY_CHN_CONDITION_S;

/**
 * @struct tagstNETDEVDevChnDecodeInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnDecodeInfo
{    
    NETDEV_DEV_CHN_BASE_INFO_S      stChnBaseInfo;              
    INT32 dwVideoFmtCapSize;                                    
    INT32 adwVideoFormatCap[NETDEV_VIDEO_FORMAT_CAP_NUM];       /*   NETDEV_DC_VIDEOFORMAT_E */
    INT32 dwLayoutCapSize;                                      
    INT32 adwLayoutCap[NETDEV_LAYOUT_CAP_NUM];                  
    INT32 dwResolutionDefault;                                  /*   NETDEV_DC_VIDEOFORMAT_E */
    BYTE   byRes[260];                                          
}NETDEV_DEV_CHN_DECODE_INFO_S, *LPNETDEV_DEV_CHN_DECODE_INFO_S;

/**
 * @struct tagstNETDEVDevChnAlarmOutInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnAlarmOutInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;    
    INT32                       dwRunMode;        /* /# NETDEV_BOOLEAN_MODE_E */
    INT32                       dwDuration;       /* (ms) */
    UINT32                      udwRelayMode;     /*  1 2 */
    UINT32                      udwAlarmOutputNum;
    BYTE                        byRes[252];       
}NETDEV_DEV_CHN_ALARMOUT_INFO_S, *LPNETDEV_DEV_CHN_ALARMOUT_INFO_S;

/**
 * @struct tagstNETDEVDevChnAlarmInInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnAlarmInInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;  
    INT32                       dwRunMode;      /* /# NETDEV_BOOLEAN_MODE_E */
    BOOL                        bEnable;        /* / */
    BYTE                        byRes[260];     
}NETDEV_DEV_CHN_ALARMIN_INFO_S, *LPNETDEV_DEV_CHN_ALARMIN_INFO_S;

/**
 * @struct tagstNETDEVDevChnAudioInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVDevChnAudioInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S      stChnBaseInfo;         
    INT32                           dwAssociatedResID;     /* ID */
    BYTE                            byRes[256];            
}NETDEV_DEV_CHN_AUDIO_INFO_S, *LPNETDEV_DEV_CHN_AUDIO_INFO_S;

/**
 * @struct tagstNETDEVDevChnDaInfo
 * @brief ()
 * @attention
 */
typedef struct tagstNETDEVDevChnDaInfo
{    
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;                          
    CHAR                        szPointCode[NETDEV_DA_POINT_CODE_LEN];  
    CHAR                        szAreaCode[NETDEV_DA_AREA_CODE_LEN];    
    UINT32                      udwPointStatus;                         /* # NETDEV_ALARM_POINT_STATUS_TYPE_E  #NETDEV_DOOR_STATUS_TYPE_E */
    BYTE                        byRes[260];                             
}NETDEV_DEV_CHN_DA_INFO_S, *LPNETDEV_DEV_CHN_DA_INFO_S;

/**
 * @struct tagstNETDEVDevChnXWEncodeInfo
 * @brief XW
 * @attention
 */
typedef struct tagstNETDEVDevChnXWEncodeInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;  
    INT32                       dwVideoSrc;     /*  NETDEV_VIDEO_SRC_TYPE_E */
    BYTE                        byRes[260];     
}NETDEV_DEV_CHN_XW_ENCODE_INFO_S, *LPNETDEV_DEV_CHN_XW_ENCODE_INFO_S;

/**
 * @struct tagNETDEVEmergencyBellInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVEmergencyBellInfo
{
    UINT32   udwID;                                            
    BOOL     bEnable;                                          
    CHAR     szName[NETDEV_EMERGENCY_BRLL_NAME_LEN];           
    UINT32   udwRegionCode;                                    
    UINT32   udwDistrictCode;                                  
    UINT32   udwAddressCode;                                   
    BYTE     byRes[108];                                       
}NETDEV_EMERGENCY_BELL_INFO_S, *LPNETDEV_EMERGENCY_BELL_INFO_S;

/**
 * @struct tagNETDEVEmergencyBellInfoList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVEmergencyBellInfoList
{
    UINT32                         udwNum;                                           /*   NETDEV_EMERGENCY_BRLL_MAX_NUM */
    LPNETDEV_EMERGENCY_BELL_INFO_S pstEmergencyBellList;                             /*  NETDEV_EMERGENCY_BRLL_MAX_NUM */
    BYTE                           byRes[16];                                        
}NETDEV_EMERGENCY_BELL_INFO_LIST_S, *LPNETDEV_EMERGENCY_BELL_INFO_LIST_S;

/**
 * @struct tagNETDEVPtzCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVPtzCapabilityInfo
{
    BOOL   bIsSupportPtz;       /*  0 1 */
    BOOL   bIsSupportTrack;     /*  0 1 */
    BYTE   byRes[128];          
}NETDEV_PTZ_CAPABILITY_INFO_S, *LPNETDEV_PTZ_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVVideoCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVVideoCapabilityInfo
{
    BOOL   bIsSupportImageSettings;     /*  0 1 */
    BOOL   bIsSupportCorrectCfg;        /*  0 1 */
    BOOL   bIsSupportEPTZ;              /*  0 1 */
    BYTE   byRes[120];                  
}NETDEV_VIDEO_CAPABILITY_INFO_S, *LPNETDEV_VIDEO_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVPlayBackCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVPlayBackCapabilityInfo
{
    BOOL   bIsSupportStep;      /*  0 1 */
    BOOL   bIsSupportIntgVod;   /*  0 1 */
    BYTE   byRes[128];          
}NETDEV_PLAYBACK_CAPABILITY_INFO_S, *LPNETDEV_PLAYBACK_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVSmartCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVSmartCapabilityInfo
{
    BOOL   bIsSupportPassengerFlow;             /*  0: 1: */
    BOOL   bIsVehicleDetection;                 /*  0: 1: */
    BOOL   bIsCrossLineSupported;               /*  0: 1: */
    BOOL   bIsIntrusionSupported;               /*  0: 1: */
    BOOL   bIsStructRecognitionSupport;         /*  0 1 */
    BOOL   bIsFaceRecognitionSupported;         /*  0:  1: */
    BOOL   bIsFaceDetectionSupported;           /*  0:  1:  */
    UINT32 udwSupportBoxDomeLinkage;            /*   NETDEV_SUP_BOX_DOME_LINKAGE_E */
    UINT32 udwSupportAttrOverlay;               /* 01 */
    BOOL   bIsLinesPeopleCountingSupported;     /*  FALSE:  TRUE:  */
    BOOL   bIsAreasPeopleCountingSupported;     /*  FALSE:  TRUE:  */
    BYTE   byRes[215];                          
}NETDEV_SMART_CAPABILITY_INFO_S, *LPNETDEV_SMART_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVVideoDetailCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVVideoDetailCapabilityInfo
{
    INT32                             dwChannelID;                     /* ID  */
    NETDEV_PTZ_CAPABILITY_INFO_S      stPtzCapabilityInfo;             
    NETDEV_VIDEO_CAPABILITY_INFO_S    stVideoCapabilityInfo;           
    NETDEV_PLAYBACK_CAPABILITY_INFO_S stPlayBackCapabilityInfo;        
    NETDEV_SMART_CAPABILITY_INFO_S    stSmartCapabilityInfo;           
    BYTE                              byRes[128];                      
}NETDEV_VIDEO_DETAIL_CAPABILITY_INFO_S, *LPNETDEV_VIDEO_DETAIL_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVDevSmartCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVDevSmartCapabilityInfo
{
    BOOL   bIsFaceRecognitionSupported;     /*  0 1 */
    BOOL   bIsFaceDetectionSupported;       /*  0 1 */
    BOOL   bIsVehicleRecognitionSupported;  /*  0 1 */
    BYTE   byRes[255];                      
}NETDEV_DEV_SMART_CAPABILITY_INFO_S, *LPNETDEV_DEV_SMART_CAPABILITY_INFO_S;

 /**
 * @struct tagNETDEVDevCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVDevCapabilityInfo
{
    UINT32                              udwDevID;                          /* ID  */
    NETDEV_DEV_SMART_CAPABILITY_INFO_S  stSmartCapabilityInfo;             
    BYTE                                byRes[256];                        
}NETDEV_DEV_CAPABILITY_INFO_S, *LPNETDEV_DEV_CAPABILITY_INFO_S;

 /**
 * @struct tagNETDEVSystemCapabilityInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVSystemCapabilityInfo
{
    UINT32  udwSize;                             
    CHAR    *pcData;                             /*  Size*/
    BYTE    byRes[256];                          
}NETDEV_SYSTEM_CAPABILITY_INFO_S, *LPNETDEV_SYSTEM_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVVideoSnapCapInfo
 * @brief  Snap parameter capability
 * @attention
 */
typedef struct tagNETDEVVideoSnapCapInfo
{
    BOOL                      bIsSupportSnapshotCfg;                            /* ,0: , 1:  Support configuration or not. 0-No, 1-Yes*/
    UINT32                    udwPictureMaxSize;                                
    UINT32                    udwResolutionNum;                                 
    NETDEV_VIDEO_RESOLUTION_S astResolutionCapList[NETDEV_LEN_16];              
    BYTE                      byRes[255];                                       
}NETDEV_VIDEO_SNAP_CAP_S,*LPNETDEV_VIDEO_SNAP_CAP_S;

/**
 * @struct tagNETDEVVideoSnapshotInfo
 * @brief  Snap parameter info
 * @attention
 */
typedef struct tagNETDEVVideoSnapshotInfo
{
    BOOL                     bIsEnabled;                             /* ,0: , 1:  Support configuration or not. 0-close, 1-open*/
    UINT32                    udwPictureMaxSize;                     
    UINT32                    udwSnapshotInterval;                   /* [1, 60],:SnapshotNum23 */
    UINT32                    udwSnapshotNum;                        /* [1,3] */
    NETDEV_VIDEO_RESOLUTION_S stResolution;                          
    BYTE                      byRes[255];                            
}NETDEV_VIDEO_SNAPSHOT_S,*LPNETDEV_VIDEO_SNAPSHOT_S;

/**
 * @struct tagstNETDEVAlarmLevelInfo
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVAlarmLevelInfo
{
    INT32   dwAlarmType;                    /*   NETDEV_ALARM_TYPE_E */
    INT32   dwAlarmSubType;                 /*   NETDEV_ALARM_SUBTYPE_E */
    INT32   dwAlarmLevel;                   
}NETDEV_ALARM_LEVEL_INFO_S, *LPNETDEV_ALARM_LEVEL_INFO_S;

/**
 * @struct tagstNETDEVAlarmLevelInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAlarmLevelInfoList
{
    INT32                           dwSize;                 
    LPNETDEV_ALARM_LEVEL_INFO_S     pstAlarmLevelInfo;      
}NETDEV_ALARM_LEVEL_INFO_LIST_S, *LPNETDEV_ALARM_LEVEL_INFO_LIST_S;

/**
 * @struct tagNETDEVBatchOperateList
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateList
{
    UINT32                          udwNum;         
    UINT32                          udwStatus;      
    LPNETDEV_BATCH_OPERATOR_INFO_S  pstBatchList;   /*  2000, */
    BYTE                            byRes[128];     /*   Reserved */
}NETDEV_BATCH_OPERATOR_LIST_S,*LPNETDEV_BATCH_OPERATOR_LIST_S;

/**
 * @struct tagNETDEVBatchOperateMemberList
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateMemberList
{
    UINT32  udwTaskNo;             /* NVR */
    UINT32  udwMemberNum;          
    UINT32* pstMemberIDList;       /*  udwNum */
    BYTE    byRes[128];            /*   Reserved */
}NETDEV_BATCH_OPERATE_MEMBER_LIST_S,*LPNETDEV_BATCH_OPERATE_MEMBER_LIST_S;

/**
* @struct tagNETDEVMonitorCapacityInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVMonitorCapacityInfo
{
    UINT32  udwMonitorType;         /*  0   1 */
    UINT32  udwNum;                 
    UINT32  *pudwDevIDList;         /* ID udwNum*/
    BYTE    byRes[128];             /*   Reserved */
}NETDEV_MONITOR_CAPACITY_INFO_S, *LPNETDEV_MONITOR_CAPACITY_INFO_S;

/**
* @struct tagNETDEVDevCapacityInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVDevCapacityInfo
{
    UINT32  udwDevID;               /* ID */
    UINT32  udwCapacity;            
    UINT32  udwMonitoredNum;        
    BYTE    byRes[128];             /*   Reserved */
}NETDEV_DEV_CAPACITY_INFO_S, *LPNETDEV_DEV_CAPACITY_INFO_S;

/**
 * @struct tagNETDEVDeleteDBFlagInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVDeleteDBFlagInfo
{
    BOOL     bIsDeleteMember;       /* 0: 1: */
    UINT32   udwDevID;              /* ID(VMS) */
    BYTE     byRes[124];            /*   Reserved */
}NETDEV_DELETE_DB_FLAG_INFO_S,*LPNETDEV_DELETE_DB_FLAG_INFO_S;

/**
 * @struct tagNETDEVFaceDBMemberCond
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVFaceDBMemberCond
{
    UINT32   udwOffset;     
    UINT32   udwLimit;      
    BYTE    byRes[128];     /*   Reserved */
}NETDEV_FACE_DB_MEMBER_COND_S,*LPNETDEV_FACE_DB_MEMBER_COND_S;

/**
 * @struct tagNETDEVFaceAddMemberList
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceAddMemberList
{
    UINT32                      udwTaskNo;              /* NVR */
    UINT32                      udwNum;                 
    LPNETDEV_FACE_MEMBER_INFO_S pstMemberInfoList;      /*  udwNum */
    BYTE                        byRes[128];             /*   Reserved */
}NETDEV_FACE_ADD_MEMBER_LIST_S,*LPNETDEV_FACE_ADD_MEMBER_LIST_S;

/**
 * @struct tagNETDEVVehicleInfoList
 * @brief   Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVehicleInfoList
{
    UINT32                          udwVehicleNum;          
    LPNETDEV_VEHICLE_DETAIL_INFO_S  pstMemberInfoList;      /*  udwNum */
    BYTE                            byRes[132];             /*   Reserved */
}NETDEV_VEHICLE_INFO_LIST_S,*LPNETDEV_VEHICLE_INFO_LIST_S;

/**
 * @struct tagDSTCfgTimeInfo
 * @brief 
 * @attention
 */
typedef struct tagDSTCfgTimeInfo
{
    UINT32    udwMonth;                   /*  1:  2:.....12:*/
    UINT32    udwWeekNum;                 /*  1: 2: 1: 3: 4: 5: */
    UINT32    udwWeekDay;                 /* X 1:  2:  3:  4:  5:  6:  7:*/
    UINT32    udwHour;                    /* 24000:00     101:00     202:00   303:00     2222:00      2323:00 */
    BYTE      byRes[256];                 
}NETDEV_DST_CFG_TIME_INFO_S,* LPNETDEV_DST_CFG_TIME_INFO_S;

/**
 * @struct tagNETDEVChnPermissionInfo
 * @brief  
 * @attention 
*/
typedef struct tagNETDEVChnPermissionInfo
{
    INT32    dwChannelID;               
    INT32    dwPermission;              /* , # NETDEV_CHN_PERMISSION_TYPE_E */
    BYTE     byRes[256];                /*   Reserved */
}NETDEV_CHN_PERMISSION_INFO_S, *LPNETDEV_CHN_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVUserDetailInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVUserDetailInfo
{
    UINT32                         udwLevel;                                          /*    NETDEV_USER_LEVEL_E */
    CHAR                           szUserName[NETDEV_LEN_64];                         /*   1~18*/
    CHAR                           szPassword[NETDEV_LEN_256];                        /*   0~256 */
    UINT32                         udwBasePermission;                                 /*  NETDEV_USER_BASE_PERMISSION_E BITBIT10*/
    UINT32                         udwNum;                                            
    NETDEV_CHN_PERMISSION_INFO_S   astChnPermission[NETDEV_CHANNEL_MAX];              
    BYTE                           byRes[256];                                        
}NETDEV_USER_DETAIL_INFO_S, *LPNETDEV_USER_DETAIL_INFO_S;

/**
 * @struct tagNETDEVUserModifyDetailInfo
 * @brief
 * @attention 
 */
typedef struct tagNETDEVUserModifyDetailInfo
{
    NETDEV_USER_DETAIL_INFO_S      stUserInfo;
    BOOL                           bIsModifyPassword;                       /* ,  */
    BOOL                           bIsModifyOther;                          /* ,  */
    CHAR                           szNewPassword[NETDEV_LEN_256];           /* ()0~256  */
    CHAR                           szCurrentPassword[NETDEV_LEN_256];       /*   0~256 */
    BYTE                           byRes[256];                              
}NETDEV_USER_MODIFY_DETAIL_INFO_S, *LPNETDEV_USER_MODIFY_DETAIL_INFO_S;

/**
 * @struct tagNETDEVUserDetailList
 * @brief
 * @attention 
 */
typedef struct tagNETDEVUserDetailList
{
    UINT32                      udwNum;                          
    NETDEV_USER_DETAIL_INFO_S   astUserInfo[NETDEV_LEN_64];     
    BYTE                        byRes[128];                      
}NETDEV_USER_DETAIL_LIST_S, *LPNETDEV_USER_DETAIL_LIST_S;

/**
 * @struct tagNetWorkCloudInfo
 * @brief MyCloud
 * @attention
 */
typedef struct tagNetWorkCloudInfo
{
    BOOL        bEnable;                                  /*  0  1 */
    UINT32      udwType;                                  /* 0 */
    UINT32      udwConStatus;                             /*  0 1 */
    CHAR        szDomainAddress[NETDEV_DOMAIN_LEN];       
    CHAR        szDevName[NETDEV_LEN_64];                 /*   Device name */
    CHAR        szUserName[NETDEV_LEN_64];                /*   User name */
    CHAR        szPassWord[NETDEV_LEN_64];                
    UINT32      udwOffLineErrCode;                        /*  # NETDEV_MYCLOUD_OFF_ERR_E */
    CHAR        szRegisterCode[NETDEV_LEN_64];            
    CHAR        szRandomCode[NETDEV_LEN_32];              /* , */
    UINT32      udwRegisterStatus;                         /*  # NETDEV_REGISTER_STATUS_E */
    CHAR        szActiveCode[NETDEV_LEN_64];              
    CHAR        szRedirectServer[NETDEV_LEN_128];         /* , /(/IP),  */
    BYTE        byRes[28];                                
}NETDEV_NETWORK_CLOUD_INFO_S,* LPNETDEV_NETWORK_CLOUD_INFO_S;

/**
 * @struct tagstNETDEVCDNSrvInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVCDNSrvInfo
{
    UINT32  udwState;                           /* :01 */
    FLOAT   fSurplusFlux;                       /* (GB) */
    CHAR    szServerDomain[NETDEV_LEN_256];     
    BYTE    byRes[256];
}NETDEV_CDN_SRV_INFO_S, *LPNETDEV_CDN_SRV_INFO_S;

/**
 * @struct tagstNETDEVCDNRule
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVCDNRule
{
    BOOL    bEnable;        
    UINT32  ProtocolType;   /* ,  NETDEV_CDN_PROT_E */
    BYTE    byRes[256];
}NETDEV_CDN_RULE_S, *LPNETDEV_CDN_RULE_S;

/**
 * @struct tagstNETDEVCDNChnInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVCDNChnInfo
{
    UINT32  udwChannelID;                   
    UINT32  udwStreamType;                  
    CHAR    szStreamUrl[NETDEV_LEN_260];    
    BYTE    byRes[256];
}NETDEV_CDN_CHL_INFO_S, *LPNETDEV_CDN_CHL_INFO_S;

/**
 * @struct tagNETDEVPersonLibCapInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonLibCapInfo
{
    UINT32          udwLibID;            /* ID */
    UINT32          udwCapacity;         /*  */
    BYTE            byRes[128];          
}NETDEV_PERSON_LIB_CAP_INFO_S, *LPNETDEV_PERSON_LIB_CAP_INFO_S;

/**
 * @struct tagNETDEVPersonLibCapList
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonLibCapList
{
    UINT32                        udwMaxPerpleMun;                         /* K */
    UINT32                        udwFreePerpleNum;                        /*  */
    UINT32                        udwMaxLibNum;                            
    UINT32                        udwFreeLibNum;                           
    UINT32                        udwNum;                                  /*  :[0, 16] */
    NETDEV_PERSON_LIB_CAP_INFO_S  stLibCapInfoList[NETDEV_LEN_16];         
    BYTE                          byRes[256];                              
}NETDEV_PERSON_LIB_CAP_LIST_S, *LPNETDEV_PERSON_LIB_CAP_LIST_S;

/**
 * @struct tagNETDEVPersonQueryInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonQueryInfo
{
    UINT32                      udwNum;             
    LPNETDEV_QUERY_INFO_S       pstQueryInfos;      /* Num0*/
    UINT32                      udwLimit;           /* 20 */
    UINT32                      udwOffset;          /* 0 */
    BYTE                        byRes[256];         
}NETDEV_PERSON_QUERY_INFO_S, *LPNETDEV_PERSON_QUERY_INFO_S;

/**
 * @struct tagNETDEVMonitorQueryInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVMonitorQueryInfo
{
    UINT32                      udwLimit;           /* 20 */
    UINT32                      udwOffset;          /* 0 */
    BOOL                        bIsQueryAll;        /* :TRUE,:FALSE */
    BYTE                        byRes[128];         
}NETDEV_MONITOR_QUERY_INFO_S, *LPNETDEV_MONITOR_QUERY_INFO_S;

/**
 * @struct tagNETDEVPersonQueryResultInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonQueryResultInfo
{
    UINT32                          udwTotal;           
    UINT32                          udwOffset;          /* 0 */
    NETDEV_PERSON_INFO_LIST_S       stPersonInfoList;   
    BYTE                            byRes[256];         
}NETDEV_PERSON_QUERY_RESULT_INFO_S, *LPNETDEV_PERSON_QUERY_RESULT_INFO_S;

/*
* @struct tagNETDEVStartInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVStartInfo
{
    UINT32 udwNum;                             
    UINT32 *pudwID;                            /* ID ,*/
    UINT32 udwBegin;                           /* UTC */
    UINT32 udwEnd;                             /* UTC */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_START_INFO_S,*LPNETDEV_START_INFO_S;

/*
* @struct tagNETDEVPicDataInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPicDataInfo
{
    UINT32 udwID;                              
    UINT32 udwTime;                            /* UTC */
    UINT32 udwSize;                            
    CHAR   szName[NETDEV_LEN_256];             /* [1,64] */
    CHAR*  pcData;                             /* base64 */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_DATA_INFO_S,*LPNETDEV_PIC_DATA_INFO_S;

/*
* @struct tagNETDEVPicQueryCond
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPicQueryCond
{
    UINT32 udwSearchID;                        
    UINT32 udwLimit;                           
    UINT32 udwOffset;                          /* 0 */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_QUERY_COND_S,*LPNETDEV_PIC_QUERY_COND_S;

/*
* @struct tagNETDEVPicQueryResult
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPicQueryResult
{
    UINT32 udwTotal;                           
    UINT32 udwNum;                             
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_QUERY_RESULT_S,*LPNETDEV_PIC_QUERY_RESULT_S;

/**
 * @struct tagstNETDEVTmSectInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTmSectInfo
{
    CHAR   szBegin[NETDEV_LEN_64];                                                  /* , hh:mm:ss [0,31] */
    CHAR   szEnd[NETDEV_LEN_64];                                                    /* hh:mm:ss [0,31] */
    BYTE   byRes[128];                                                              
}NETDEV_TM_SECT_INFO_S,*LPNETDEV_TM_SECT_INFO_S;

/**
 * @struct tagstNETDEVVehThroughInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVVehThroughInfo
{
    UINT32                udwType;                                    /*   NETDEV_VEH_RELEASE_TYPE_E */
    UINT32                udwNum;                                     /*  4*/
    NETDEV_TM_SECT_INFO_S astTmSectInfo[NETDEV_LEN_4];                
    BYTE                  byRes[128];                                 
}NETDEV_VEH_THROUGH_INFO_S,*LPNETDEV_VEH_THROUGH_INFO_S;

/**
 * @struct tagstNETDEVVehLaneInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVVehLaneInfo
{
    UINT32 udwVehLaneID;                                                            /* ID */
    CHAR   szName[NETDEV_LEN_128];                                                  
    UINT32 udwType;                                                                 /*   NETDEV_VEH_LANE_TYPE_E */
    UINT32 udwNum;                                                                  /* 4 */
    NETDEV_TM_SECT_INFO_S astEnTmSectInfo[NETDEV_LEN_4];                            
    NETDEV_VEH_THROUGH_INFO_S stTmpVehThrough;                                      
    NETDEV_VEH_THROUGH_INFO_S stRegVehThrough;                                      
    UINT32 udwDevNum;                                                               /*  4*/
    UINT32 audwDevID[NETDEV_LEN_4];                                                 /* ID */
    BYTE   byRes[128];                                                              
}NETDEV_VEH_LANE_INFO_S,*LPNETDEV_VEH_LANE_INFO_S;

/**
 * @struct tagstNETDEVVehLaneInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVVehLaneInfoList
{
    UINT32                 udwNum;                                      /* 2 */
    NETDEV_VEH_LANE_INFO_S astVehLaneInfo[NETDEV_LEN_4];                
    BYTE                   byRes[128];                                  
}NETDEV_VEH_LANE_INFO_LIST_S,*LPNETDEV_VEH_LANE_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntrLaneInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkEntrLaneInfo
{
    UINT32                      udwParkingLotID;                      /* ID */
    UINT32                      udwEntranceID;                        /* ID */
    NETDEV_VEH_LANE_INFO_LIST_S stVehLaneInfoList;                    
    BYTE                        byRes[128];                           
}NETDEV_PARK_ENTR_LANE_INFO_S,*LPNETDEV_PARK_ENTR_LANE_INFO_S;

/**
 * @struct tagstNETDEVParkInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkInfo
{
    UINT32 udwParkingLotID;                                                          /* ID */
    CHAR   szParkingLotName[NETDEV_LEN_260];                                         /* [1,64] */
    UINT32 udwTotalSpaceNum;                                                         
    UINT32 udwRmnSpaceNum;                                                           
    UINT32 udwReserveSpaceNum;                                                       
    UINT32 udwRmnReserveSpaceNum;                                                    
    UINT32 udwMainParkingLotID;                                                      /* ID  */
    BYTE   byRes[256];                                                               
}NETDEV_PARK_INFO_S,*LPNETDEV_PARK_INFO_S;

/**
 * @struct tagstNETDEVParkInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkInfoList
{
    UINT32               udwNum;                                       
    NETDEV_PARK_INFO_S   astParkInfo[NETDEV_LEN_16];                   /*  VMS8 */
    BYTE                 byRes[512];                                   
}NETDEV_PARK_INFO_LIST_S, *LPNETDEV_PARK_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntranceInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkEntranceInfo
{
    UINT32 udwParkEntranceID;                                                        /* ID  */
    CHAR   szName[NETDEV_LEN_260];                                                   /* [1,64] */
    UINT32 udwVehicleLaneNum;                                                        /* 2 */
    BYTE   byRes[256];                                                               
}NETDEV_PARK_ENTRANCE_INFO_S, *LPNETDEV_PARK_ENTRANCE_INFO_S;

/**
 * @struct tagstNETDEVParkEntranceInfoList
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkEntranceInfoList
{
    UINT32                        udwNum;                                            
    NETDEV_PARK_ENTRANCE_INFO_S   astParkEntranceInfo[NETDEV_LEN_32];                /*  16 */
    BYTE                          byRes[512];                                        
}NETDEV_PARK_ENTRANCE_INFO_LIST_S,*LPNETDEV_PARK_ENTRANCE_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntranceID
 * @brief ID
 * @attention
 */
typedef struct tagstNETDEVParkEntranceID
{
    UINT32 udwParkID;                                                                /* ID */
    UINT32 udwEntranceID;                                                            /* ID */
    BYTE   byRes[256];                                                               
}NETDEV_PARK_ENTRANCE_ID_S,*LPNETDEV_PARK_ENTRANCE_ID_S;

/**
 * @struct tagstNETDEVParkSpaceInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkSpaceInfo
{
    UINT32 udwTotalSpaceNum;                                                         
    UINT32 udwRmnSpaceNum;                                                           
    UINT32 udwReserveSpaceNum;                                                       
    UINT32 udwRmnReserveSpaceNum;                                                    
    BYTE   byRes[256];                                                               
}NETDEV_PARK_SPACE_INFO_S,*LPNETDEV_PARK_SPACE_INFO_S;

/**
 * @struct tagstNETDEVChgRuleInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVChgRuleInfo
{
    UINT32 udwNum;                                                                   
    UINT32 udwType;                                                                  /*   NETDEV_CHG_RULE_TYPE_E */
    BYTE   byRes[256];                                                               
}NETDEV_CHG_RULE_INFO_S,*LPNETDEV_CHG_RULE_INFO_S;

/**
 * @struct tagstNETDEVChgRuleQueryCond
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVChgRuleQueryCond
{
    UINT32 udwParkingLotID;                                                          /* ID */
    UINT32 udwChargeRuleType;                                                        /*   NETDEV_CHG_RULE_TYPE_E */
    BYTE   byRes[256];                                                               
}NETDEV_CHG_RULE_QUERY_COND_S,*LPNETDEV_CHG_RULE_QUERY_COND_S;

/**
 * @struct tagstNETDEVAbnChgRuleInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVAbnChgRuleInfo
{
    UINT32 udwID;                                                                    /* ID */
    CHAR   szName[NETDEV_LEN_128];                                                   
    UINT32 udwChgAmount;                                                             
    CHAR   szDescription[NETDEV_LEN_512];                                            /* [1,128] */
    UINT32 udwIsDefaultRule;                                                         /*  0: 1:*/
    BYTE   byRes[128];                                                               
}NETDEV_ABN_CHG_RULE_INFO_S,*LPNETDEV_ABN_CHG_RULE_INFO_S;

/**
 * @struct tagNETDEVEntrVehSnapInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVEntrVehSnapInfo
{
    UINT32 udwID;                                                                    /* ID */
    UINT32 udwChannelID;                                                             /* ID */
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* [1,16] */
    UINT32 udwVehType;                                                               /*   NETDEV_VEHICLE_TYPE_E */
    UINT32 udwVehColor;                                                              /*   NETDEV_VEHICLE_COLOR_E*/
    UINT32 udwVehAttr;                                                               /*   NETDEV_VEH_ATTR_TYPE_E */
    UINT32 udwIsBlackList;                                                           /*  0: 1: */
    UINT32 udwEnterTime;                                                             /* UTC */
    UINT32 udwIsAutoOpenGate;                                                        /*  0: 1: */
    NETDEV_FILE_INFO_S stPlateImage;                                                 
    NETDEV_FILE_INFO_S stVehImage;                                                   
    BYTE   byRes[128];                                                               
}NETDEV_ENTR_VEH_SNAP_INFO_S,*LPNETDEV_ENTR_VEH_SNAP_INFO_S;

/**
 * @struct tagNETDEVEntrInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVEntrInfo
{
    UINT32             udwEnterTime;                                /* UTC */
    NETDEV_FILE_INFO_S stPlateImage;                                
    NETDEV_FILE_INFO_S stVehImage;                                  
    BYTE               byRes[256];                                  
}NETDEV_ENTR_INFO_S,*LPNETDEV_ENTR_INFO_S;

/**
 * @struct tagstNETDEVExitInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVExitInfo 
{
    UINT32             udwExitTime;                                   /* (UTC) */
    UINT32             udwTotalAmount;                                
    UINT32             udwIsAlreadyPaid;                              /*  0: 1: */
    UINT32             udwChargeRecordID;                             /* ID */
    NETDEV_FILE_INFO_S stPlateImage;                                  
    NETDEV_FILE_INFO_S stVehImage;                                    
    CHAR               szOperatorName[NETDEV_LEN_128];                
    BYTE               byRes[256];                                    
}NETDEV_EXIT_INFO_S,*LPNETDEV_EXIT_INFO_S;

/**
 * @struct tagstNETDEVEntrExitMatchInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVEntrExitMatchInfo
{
    UINT32               udwIsWhiteList;                                /*  0 1 */
    UINT32               udwIsBlackList;                                /*  0: 1: */
    UINT32               udwParkingTime;                                
    LPNETDEV_ENTR_INFO_S pstEntrInfo;                                   
    LPNETDEV_EXIT_INFO_S pstExitInfo;                                   
    BYTE                 byRes[128];                                    
}NETDEV_ENTR_EXIT_MATCH_INFO_S,*LPNETDEV_ENTR_EXIT_MATCH_INFO_S;

/**
 * @struct tagstNETDEVParkEventInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkEventInfo
{
    UINT32               udwID;                               /* ID */
    UINT32               udwParkID;                           /* ID */
    CHAR                 szPlateNo[NETDEV_LEN_32];            
    NETDEV_VEH_ATTR_S    stVehAttr;                           
    UINT32               udwVehRemainNum;                     
    UINT32               udwIsWhiteList;                      /*  0 1  */
    UINT32               udwIsBlackList;                      /*  0 1 */
    CHAR                 szEntranceName[NETDEV_LEN_128];      
    CHAR                 szLaneName[NETDEV_LEN_128];          
    UINT32               udwCrossDirection;                   /*  0 1 */
    LPNETDEV_ENTR_INFO_S pstEnterInfo;                        
    LPNETDEV_EXIT_INFO_S pstExitInfo;                         
    BYTE                 byRes[256];                          
}NETDEV_PARK_EVENT_INFO_S,*LPNETDEV_PARK_EVENT_INFO_S;

/**
 * @struct tagstNETDEVParkPayOrderInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkPayOrderInfo
{
    CHAR   szOrderNo[NETDEV_LEN_128];                                               
    UINT32 udwOrderStatus;                                                          /*   NETDEV_ORDER_STATUS_E*/
    CHAR   szPlateNo[NETDEV_LEN_128];                                               
    UINT32 udwPayType;                                                              /*    NETDEV_PAY_TYPE_E */
    CHAR   szPayTradeNo[NETDEV_LEN_128];                                            
    UINT32 udwTotalAmount;                                                          
    UINT32 udwDiscountAmount;                                                       
    BYTE   byRes[256];                                                              
}NETDEV_PARK_PAY_ORDER_INFO_S,*LPNETDEV_PARK_PAY_ORDER_INFO_S;

/**
 * @struct tagstNETDEVParkCost
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVParkCost
{
    UINT32 udwTotalAmount;                                                          
    UINT32 udwEnterTime;                                                            /* UTC */
    UINT32 udwExitLimitTime;                                                        
    BYTE   byRes[256];                                                              
}NETDEV_PARK_COST_S, *LPNETDEV_PARK_COST_S;

/**
 * @struct tagstNETDEVPassRecordInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVPassRecordInfo
{
    UINT32 udwRecordID;                                                              /* ID */
    NETDEV_FILE_INFO_S stPlateImage;                                                 
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* [1,16] */
    CHAR   szName[NETDEV_LEN_128];                                                   /* [1,32] */
    UINT32 udwVehType;                                                               /*   NETDEV_VEHICLE_TYPE_E */
    UINT32 udwVehColor;                                                              /*   NETDEV_VEHICLE_COLOR_E */
    UINT32 udwIsBlackList;                                                           /*  0: 1: */
    UINT32 udwIsWhiteList;                                                           /*  0 1 */
    CHAR   szParkName[NETDEV_LEN_260];                                               /* [1,64] */
    UINT32 udwCrossDirection;                                                        /*  0: 1: */
    UINT32 udwPassTime;                                                              /* UTC */
    CHAR   szEntrName[NETDEV_LEN_260];                                               /* [1,64] */
    BYTE   byRes[128];                                                               
}NETDEV_PASS_RECORD_INFO_S,*LPNETDEV_PASS_RECORD_INFO_S;

/**
 * @struct tagstNETDEVTmpVehChgRecord
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTmpVehChgRecord
{
    UINT32 udwRecordID;                                                              /* ID */
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* [1,16] */
    UINT32 udwVehicleType;                                                           /*   NETDEV_VEHICLE_TYPE_E */
    UINT32 udwChargeTime;                                                            /* UTC */
    INT64  tParkTime;                                                                
    UINT32 udwAmount;                                                                
    CHAR   szAbnRuleName[NETDEV_LEN_128];                                            /* [1,32] */
    UINT32 udwChgType;                                                               /*   NETDEV_CHG_TYPE_E */
    CHAR   szParkName[NETDEV_LEN_260];                                               /* [1,64] */
    CHAR   szOperatorName[NETDEV_LEN_260];                                           /* [1,64] */
    UINT32 udwFree;                                                                  /*  0 1 */
    BYTE   byRes[124];                                                               
}NETDEV_TMP_VEH_CHG_RECORD_S,*LPNETDEV_TMP_VEH_CHG_RECORD_S;

/**
 * @struct tagstNETDEVTmpVehChgAmount
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVTmpVehChgAmount
{
    UINT32 udwAmount;                                                                
    UINT32 udwManualPayment;                                                         
    UINT32 udwSelfhelpPayment;                                                       
    BYTE   byRes[128];                                                               
}NETDEV_TMP_VEH_CHG_AMOUNT_S,*LPNETDEV_TMP_VEH_CHG_AMOUNT_S;

/**
 * @struct tagstNETDEVShiftInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVShiftInfo
{
    CHAR   szName[NETDEV_LEN_260];                                                   
    UINT32 udwAmount;                                                                
    BYTE   byRes[128];                                                               
}NETDEV_SHIFT_INFO_S,*LPNETDEV_SHIFT_INFO_S;

/**
 * @struct tagstNETDEVEntrExitSnapRecordID
 * @brief ID
 * @attention
 */
typedef struct tagstNETDEVEntrExitSnapRecordID
{
    UINT32 udwEnterID;                                                               /* ID */
    UINT32 udwExitID;                                                                /* ID */
    BYTE   byRes[128];                                                               
}NETDEV_ENTR_EXIT_SNAP_RECORDID_S,*LPNETDEV_ENTR_EXIT_SNAP_RECORDID_S;

/**
 * @struct tagstNETDEVChgInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVChgInfo
{
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /*  [1,16] */
    UINT32 udwAmount;                                                                
    UINT32 udwAbnRuleID;                                                             /* ID */
    UINT32 udwIsFree;                                                                /*  0:1:*/
    INT64  tParkingTime;                                                             
    BYTE   byRes[128];                                                               
}NETDEV_CHG_INFO_S,*LPNETDEV_CHG_INFO_S;

 /**
 * @struct tagNETDEVStructAlarmInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVStructAlarmInfo
{
    CHAR   szReference[NETDEV_LEN_260];                   
    UINT32 udwTimeStamp;                                  /*  1970110 */
    UINT32 udwSeq;                                        
    UINT32 udwSrcID;                                      /* ID */
    CHAR   szSrcName[NETDEV_LEN_260];                     
    UINT32 udwNotificationType;                           /*  0 1  */
    CHAR   szDeviceID[NETDEV_LEN_32];                     /* ID[1,32] */
    CHAR   szRelatedID[NETDEV_LEN_64];                    /* ID15 */
    BYTE   byRes[32];                                     
}NETDEV_STRUCT_ALARM_INFO_S,*LPNETDEV_STRUCT_ALARM_INFO_S;

/**
 * @struct tagNETDEVPointInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPointInfo
{
    UINT32 udwX;                                  /* X[0,10000] */
    UINT32 udwY;                                  /* Y[0,10000] */
    BYTE   byRes[32];                             
}NETDEV_POINT_INFO_S,*LPNETDEV_POINT_INFO_S;

/**
 * @struct tagNETDEVRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVRuleInfo
{
    UINT32                udwRuleType;                                  /*   NETDEV_RULE_TYPE_E */
    UINT32                udwTrigerType;                                /*   NETDEV_RULE_TRIGGER_TYPE_E */
    UINT32                udwPointNum;                                  
    LPNETDEV_POINT_INFO_S pstPointInfo;                                 /* ,0 */
    BYTE                  byRes[64];                                    
}NETDEV_RULE_INFO_S,*LPNETDEV_RULE_INFO_S;

/**
 * @struct tagNETDEVFaceStructInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVFaceStructInfo
{
    UINT32               udwFaceID;                                     /* ID */
    UINT32               udwFaceDoforPersonID;                          /* ID */
    CHAR                 szPosition[NETDEV_LEN_64];                     
    UINT32               udwSmallPicAttachIndex;                        
    UINT32               udwLargePicAttachIndex;                        
    CHAR                 szFeaturVersion[NETDEV_LEN_64];                
    CHAR                 szFeature[NETDEV_LEN_1024];                    /*  base64 512 Bytes */
    NETDEV_FACE_ATTR_S   stFaceAttr;                                    
    LPNETDEV_RULE_INFO_S pstRuleInfo;                                   
    UINT32               udwFaceDoforNonMotorID;                        /* ID */
    UINT32               udwFaceDoforVehicleID;                         /* ID */
    BYTE                 byRes[116];                                    
}NETDEV_FACE_STRUCT_INFO_S,*LPNETDEV_FACE_STRUCT_INFO_S;

/**
 * @struct tagNETDEVPersonStructInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonStructInfo
{
    UINT32               udwPersonID;                                   /* ID */
    UINT32               udwPersonDoforFaceID;                          /* ID */
    CHAR                 szPosition[NETDEV_LEN_64];                     
    UINT32               udwSmallPicAttachIndex;                        
    UINT32               udwLargePicAttachIndex;                        
    CHAR                 szFeaturVersion[NETDEV_LEN_64];                
    CHAR                 szFeature[NETDEV_LEN_1024];                    /*  base64 512 Bytes */
    NETDEV_PERSON_ATTR_S stPersonAttr;                                  
    LPNETDEV_RULE_INFO_S pstRuleInfo;                                   
    BYTE   byRes[124];                                                  
}NETDEV_PERSON_STRUCT_INFO_S,*LPNETDEV_PERSON_STRUCT_INFO_S;

/**
 * @struct tagNETDEVPlateAttr
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPlateAttr
{
    CHAR   szPlateNo[NETDEV_LEN_64];                      
    UINT32 udwColor;                                      /*   NETDEV_PLATE_COLOR_E */
    UINT32 udwType;                                       /*   NETDEV_PLATE_TYPE_E */
    BYTE   byRes[128];                                    
}NETDEV_PLATE_ATTR_S,*LPNETDEV_PLATE_ATTR_S;

/**
 * @struct tagNETDEVNonMotorVehicleAttr
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehAttr
{
    UINT32 udwSpeedType;                                  /*   NETDEV_SPEED_TYPE_E */
    UINT32 udwImageDirection;                             /*   NETDEV_IMAGE_DIRECTION_E */
    UINT32 udwNonVehicleType ;                            /*   NETDEV_NON_VEH_TYPE_E */
    BYTE   byRes[128];                                    
}NETDEV_NO_MOTOR_VEH_ATTR_S,*LPNETDEV_NO_MOTOR_VEH_ATTR_S;

/**
 * @struct tagNETDEVNonMotorVehInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehInfo
{
    UINT32                     udwID;                                         /* ID */
    CHAR                       szPosition[NETDEV_LEN_64];                     
    UINT32                     udwSmallPicAttachIndex;                        
    UINT32                     udwLargePicAttachIndex;                        
    NETDEV_NO_MOTOR_VEH_ATTR_S stNoMotorVehAttr;                              
    UINT32                     udwPersonOnNoVehiNum;                          
    LPNETDEV_PERSON_ATTR_S     pstPersonAttr;                                 
    LPNETDEV_RULE_INFO_S       pstRuleInfo;                                   
    BYTE   byRes[124];                                                        
}NETDEV_NON_MOTOR_VEH_INFO_S,*LPNETDEV_NON_MOTOR_VEH_INFO_S;

/**
 * @struct tagNETDEVVehicleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVVehicleInfo
{
    UINT32               udwID;                                         /* ID */
    CHAR                 szPosition[NETDEV_LEN_64];                     
    UINT32               udwSmallPicAttachIndex ;                       
    UINT32               udwLargePicAttachIndex;                        
    UINT32               udwPlatePicAttachIndex;                        
    CHAR                 szFeatureVersion[NETDEV_LEN_64];               
    CHAR                 szFeature[NETDEV_LEN_1024];                    /*  base64 512 Bytes */
    NETDEV_VEH_ATTR_S    stVehAttr;                                     
    NETDEV_PLATE_ATTR_S  stPlateAttr;                                   
    LPNETDEV_RULE_INFO_S pstRuleInfo;                                   
    BYTE                 byRes[124];                                    
}NETDEV_VEH_INFO_S, *LPNETDEV_VEH_INFO_S;

/**
 * @struct tagNETDEVSingleObjectInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSingleObjectInfo
{
    UINT32                      udwObjectType;            /*  #  NETDEV_OBJECT_TYPE_E */
    NETDEV_FACE_STRUCT_INFO_S   stFaceInfo;               
    NETDEV_PERSON_STRUCT_INFO_S stPersonInfo;             
    NETDEV_NON_MOTOR_VEH_INFO_S stNonMotorVehInfo;        
    NETDEV_VEH_INFO_S           stVehInfo;                
    BYTE                        byRes[256];               
}NETDEV_SINGLE_OBJECT_INFO_S,*LPNETDEV_SINGLE_OBJECT_INFO_S;

/**
 * @struct tagNETDEVObjectInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVObjectInfo
{
    UINT32                        udwFaceNum;               
    LPNETDEV_FACE_STRUCT_INFO_S   pstFaceInfo;              
    UINT32                        udwPersonNum;             
    LPNETDEV_PERSON_STRUCT_INFO_S pstPersonInfo;            
    UINT32                        udwNonMotorVehNum;        
    LPNETDEV_NON_MOTOR_VEH_INFO_S pstNonMotorVehInfo;       
    UINT32                        udwVehicleNum;            
    LPNETDEV_VEH_INFO_S           pstVehInfo;               
    BYTE                          byRes[128];               
}NETDEV_OBJECT_INFO_S,*LPNETDEV_OBJECT_INFO_S;

/**
 * @struct tagNETDEVStructImageInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVStructImageInfo
{
    UINT32 udwIndex;                                      
    UINT32 udwType;                                       
    UINT32 udwFormat;                                     /*   NETDEV_IMAGE_FORMAT_E */
    UINT32 udwWidth;                                      
    UINT32 udwHeight;                                     
    UINT32 udwCaptureTime;                                
    CHAR   szUrl[NETDEV_LEN_260];                         /* URL */
    UINT32 udwSize;                                       /* base64 3M */
    CHAR*  pszData;                                       /* base64 */
    BYTE   byRes[128];                                    
}NETDEV_STRUCT_IMAGE_INFO_S, *LPNETDEV_STRUCT_IMAGE_INFO_S;

/**
 * @struct tagNETDEVStructDataInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVStructDataInfo
{
    NETDEV_OBJECT_INFO_S         stObjectInfo;            
    UINT32                       udwImageNum;             
    LPNETDEV_STRUCT_IMAGE_INFO_S pstImageInfo;            
    BYTE                         byRes[128];              
}NETDEV_STRUCT_DATA_INFO_S,*LPNETDEV_STRUCT_DATA_INFO_S;

/**
 * @struct tagNETDEVNonMotorVehRecord
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehRecord
{
    UINT32                      udwRecordID;                       /* ID */
    UINT32                      udwPassingTime;                    /*  UTC  */
    CHAR                        szChannelName[NETDEV_LEN_260];     /*  [1,63] */
    NETDEV_NON_MOTOR_VEH_INFO_S stNonMotorVehInfo;                 
    NETDEV_FILE_INFO_S          stNoMotorVehImage;                 /*  500K */
    NETDEV_FILE_INFO_S          stPanoImage;                       /*  URLsize /LAPI/V1.0/System/Picture*/
    BYTE                        byRes[256];                        
}NETDEV_NON_MOTOR_VEH_RECORD_S,*LPNETDEV_NON_MOTOR_VEH_RECORD_S;

/**
 * @struct tagNETDEVPersonPassRecord
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPersonPassRecord
{
    UINT32               udwRecordID;                     /* ID */
    UINT32               udwPassingTime;                  /*  UTC  */
    CHAR                 szChannelName[NETDEV_LEN_260];   /*  [1,63] */
    NETDEV_FACE_ATTR_S   stFaceAttr;                      
    NETDEV_PERSON_ATTR_S stPersonAttr;                    
    NETDEV_FILE_INFO_S   stFaceImage;                     /*  500K */
    NETDEV_FILE_INFO_S   stPersonImage;                   /*  500K */
    NETDEV_FILE_INFO_S   stPanoImage;                     /*  URLsize /LAPI/V1.0/System/Picture*/
    BYTE                 byRes[256];                      
}NETDEV_PERSON_PASS_RECORD_S,*LPNETDEV_PERSON_PASS_RECORD_S;

/**
 * @struct tagNETDEVRectanglePoint
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVRectanglePoint
{
    NETDEV_POINT_S   stTopLeft;          
    NETDEV_POINT_S   stBottomRight;      
    BYTE             byRes[256];         
}NETDEV_RECTANGLE_POINT_S, *LPNETDEV_RECTANGLE_POINT_S;

/**
 * @struct tagNETDEVManualLink
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVManualLink
{
    UINT32                   udwType;                     /*   NETDEV_LINKAGE_TYPE_E */
    NETDEV_POINT_S           stPoint;                     /*  Type02 */
    NETDEV_RECTANGLE_POINT_S stRectangle;                 /*  Type1 */
    BYTE                     byRes[128];                  
}NETDEV_MANUAL_LINK_S,*LPNETDEV_MANUAL_LINK_S;

/**
 * @struct tagstNETDEVNICCapInfo
 * @brief 
 * @attention 
 */
typedef struct tagstNETDEVNICCapInfo
{
    UINT32   udwWorkModeNum;                                      /*  NVRVMS */
    UINT32   audwWorkModeList[NETDEV_MAX_NIC_WORK_MODE_NUM];      /* ,# NETDEV_NIC_WORK_MODE_E  */
    UINT32   udwNICNum;                                           
    UINT32   udwPortWorkModeNum;                                  /*  IPC */
    UINT32   audwPortWorkModeList[NETDEV_MAX_PORT_WORK_MODE_NUM]; /* ,# NETDEV_PORT_WORK_MODE_E */
    BYTE     byRes[512];                                           /*   Reserved field */
}NETDEV_NIC_CAP_INFO_S, *LPNETDEV_NIC_CAP_INFO_S;

/**
 * @struct tagNETDEVDevAddrInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVDevAddrInfo
{
    CHAR    szUserName[NETDEV_LEN_64];          /*  User Name */
    CHAR    szPassword[NETDEV_LEN_64];          /*  Password */
    CHAR    szIPv4Address[NETDEV_LEN_32];       /* IPv4IP  IP address of IPv4 */
    CHAR    szIPv4GateWay[NETDEV_LEN_32];       /* IPv4  Gateway of IPv4 */
    CHAR    szIPv4SubnetMask[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
    CHAR    szDevSerailNum[NETDEV_LEN_64];      /*   Device serial number */
    CHAR    szDevMac[NETDEV_LEN_64];            /* MAC  Device MAC address */
    BYTE    byRes[512];                         /*   Reserved */
}NETDEV_DEV_ADDR_INFO_S, *LPNETDEV_DEV_ADDR_INFO_S;

/**
 * @struct tagstEventRecordParam
 * @brief 
 * @attention 
 */
typedef struct tagstEventRecordParam
{
    UINT32  udwNum;                                               
    UINT32* pudwChannels;                                         
    UINT32  udwRecordType;                                        /*   NETDEV_EVENT_RECORD_TYPE_E */
    INT64   tBegin;                                               /* UTCs */
    INT64   tEnd;                                                 /* UTCs */
    UINT32  udwLimit;                                             
    UINT32  udwPage;                                              /* LimitLimitPage */
    BYTE    byRes[256];                                           
}NETDEV_EVENT_RECORD_PARAM_S,*LPNETDEV_EVENT_RECORD_PARAM_S;

/**
 * @struct tagstEventRecordInfo
 * @brief 
 * @attention 
 */
typedef struct tagstEventRecordInfo
{
    UINT32 udwChannelID;                                          
    UINT32 udwRecordType;                                         /*   NETDEV_EVENT_RECORD_TYPE_E */
    UINT32 udwBegin;                                              /* UTC */
    UINT32 udwEnd;                                                /* UTC */
    BYTE    byRes[256];                                           
}NETDEV_EVENT_RECORD_INFO_S,*LPNETDEV_EVENT_RECORD_INFO_S;

/**
 * @struct tagNETDEVEnhancedConfigInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVEnhancedConfigInfo
{
    BOOL    bEnabledStorage;                    /* UNP/0:1: */
    BYTE    byRes[512];                         /*   Reserved */
}NETDEV_ENHANCED_CONFIG_INFO_S, *LPNETDEV_ENHANCED_CONFIG_INFO_S;

/**
 * @struct tagNETDEVGISMapInfo
 * @brief GIS
 * @attention  None
 */
typedef struct tagNETDEVGISMapInfo
{
    DOUBLE dlLatitude;                                       /*  [-180.00, +180.00] */
    DOUBLE dlLongitude;                                      /*  [-90.00,+90.00] */
    UINT32 udwInitZoomLevel;                                 /*  [3,999] */
    BYTE   byRes[128];                                       
}NETDEV_GIS_MAP_INFO_S, *LPNETDEV_GIS_MAP_INFO_S;

/**
 * @struct tagNETDEVMapConfigInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVMapConfigInfo
{
    UINT32                udwType;                        /*   NETDEV_MAP_TYPE_E */
    NETDEV_GIS_MAP_INFO_S stGisMapInfo;                   /* GIS */
    BYTE                  byRes[128];                     
}NETDEV_MAP_CONFIG_INFO_S, *LPNETDEV_MAP_CONFIG_INFO_S;

/**
 * @struct tagNETDEVExcpAlarmCapInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVExcpAlarmCapInfo
{
    UINT32   udwSupportTypeNum;                                    
    UINT32   audwSupportType[NETDEV_LEN_64];                       /* ,# NETDEV_EXCP_ALARM_CAP_TYPE_E  */
    BYTE     byRes[512];                                           
}NETDEV_EXCP_ALARM_CAP_INFO_S, *LPNETDEV_EXCP_ALARM_CAP_INFO_S;

/**
* @struct tagNETDEVPositionInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVPositionInfo
{
    UINT32         udwChannelId;    /* ID */
    NETDEV_POINT_S stPoint;         /* ,,[0,9999) */
    BYTE           byRes[128];      
}NETDEV_POSTION_INFO_S, *LPNETDEV_POSTION_INFO_S;

/**
* @struct tagNETDEVFirePointInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVFirePointInfo
{
    UINT32                udwChannelNum;                  
    NETDEV_POSTION_INFO_S stPositionList[NETDEV_LEN_16];  /* ChannelNum0 */
    BYTE                  byRes[256];                     
}NETDEV_FIRE_POINT_INFO, *LPNETDEV_FIRE_POINT_INFO;

/**
* @struct tagNETDEVConflagrationAlarmInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVConflagrationAlarmInfo
{
    CHAR                      szReference[NETDEV_LEN_260];          
    UINT32                    udwTimeStamp;                         /*  UTC  */
    UINT32                    udwAlarmSeq;                          
    NETDEV_GEOLACATION_INFO_S stPTPosition;                         
    FLOAT                     fLensView;                            
    UINT32                    udwNum;                               
    NETDEV_FIRE_POINT_INFO    stFirePointInfoList[NETDEV_LEN_16];   /* Num0 */
    BYTE                      byRes[128];                           
}NETDEV_CONFLAGRATION_ALARM_INFO_S, *LPNETDEV_CONFLAGRATION_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVMotionDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* ,0 1 */
    UINT32  udwRectangleAreaNum;                     /* ,,IPC */
    UINT32  udwBlockWidth;                           
    UINT32  udwBlockHeight;                          
    BYTE    byRes[256];                              
}NETDEV_MOTION_DETECTION_INFO_S, *LPNETDEV_MOTION_DETECTION_INFO_S;

/**
 * @struct tagNETDEVTamperDetectionInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVTamperDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* ,0 1 */
    UINT32  udwTamperRectangleAreaNum;               /* 1 */
    BYTE    byRes[256];                              
}NETDEV_TAMPER_DETECTION_INFO_S, *LPNETDEV_TAMPER_DETECTION_INFO_S;

/**
 * @struct tagNETDEVHumanShapeDetectionInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVHumanShapeDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* ,0 1 */
    UINT32  udwRectangleAreaNum;                     /* 1 */
    BYTE    byRes[256];                              
}NETDEV_HUMAN_SHAPE_DETECTION_INFO_S, *LPNETDEV_HUMAN_SHAPE_DETECTION_INFO_S;

/**
 * @struct tagNETDEVAudioDetectionInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVAudioDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* ,0 1 */
    BYTE    byRes[256];                              
}NETDEV_AUDIO_DETECTION_INFO_S, *LPNETDEV_AUDIO_DETECTION_INFO_S;

/**
* @struct tagNETDEVConflagDetectInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVConflagDetectInfo
{
    BOOL   bIsSupportCfg;                                 /*  0: 1: */
    BYTE   byRes[52];                                     
}NETDEV_CONFLAG_DETECT_INFO_S, *LPNETDEV_CONFLAG_DETECT_INFO_S;

/**
 * @struct tagNETDEVTempratureDetectionInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVTempratureDetectionInfo
{
    INT32    dwSupportUnitNum;                       
    INT32    adwUnitList[NETDEV_LEN_64];             /*  0 1 */
    INT32    dwSupportTypeNum;                       
    INT32    adwTypeList[NETDEV_LEN_64];             /*  0 1 2 3 */
    BYTE     byRes[256];                             
}NETDEV_TEMPERATUE_DETECTION_INFO_S, *LPNETDEV_TEMPERATUE_DETECTION_INFO_S;

/**
 * @struct tagNETDEVChannelsAlarmCapInfo
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVChannelsAlarmCapInfo
{
    NETDEV_MOTION_DETECTION_INFO_S         stMotionDetectionInfo;                
    NETDEV_TAMPER_DETECTION_INFO_S         stTamperDetectionInfo;                
    NETDEV_HUMAN_SHAPE_DETECTION_INFO_S    stHumanShapeDetectionInfo;            
    NETDEV_AUDIO_DETECTION_INFO_S          stAudioDetectionInfo;                 
    NETDEV_CONFLAG_DETECT_INFO_S           stConfiagDetectInfo;                  
    NETDEV_TEMPERATUE_DETECTION_INFO_S     stTemperatureDetection;               
    BYTE    byRes[64];                                                          
}NETDEV_CHN_ALARM_CAP_INFO_S, *LPNETDEV_CHN_ALARM_CAP_INFO_S;

/**
 * @struct tagNETDEVVertifyInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVResetPwdVertifyInfo
{
    CHAR                          szEMail[NETDEV_LEN_256];   
    CHAR                          szPhone[NETDEV_LEN_256];   
    BYTE                          byRes[256];                
}NETDEV_RESET_PWD_VERTIFY_INFO_S, *LPNETDEV_RESET_PWD_VERTIFY_INFO_S;

/**
 * @struct tagNETDEVStorageQuotaInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVStorageQuotaInfo
{
    INT32      dwStorageCapUnit;             /* (GB),# NETDEV_STORAGE_CAP_UNIT_E */
    INT32      dwRecUsedCap;                 
    INT32      dwPicUsedCap;                 
    INT32      dwAIPicUsedCap;               /* IPC */
    INT32      dwUsedCap;                    /* IPC */
    INT32      dwTotalCap;                   
    INT32      dwRecQuota;                   
    INT32      dwPicQuota;                   
    INT32      dwAIPicQuota;                 /* IPC */
    INT32      dwGroupID;                    /* ID */
    INT32      dwGroupTotalCap;              
    BYTE       byRes[256];                   
}NETDEV_STORAGE_QUOTA_INFO_S, *LPNETDEV_STORAGE_QUOTA_INFO_S;

/**
 * @struct tagNETDEVPicStorageStrategyInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVPicStorageStrategyInfo
{
    INT32     dwStorageMode;        /* # NETDEV_PIC_STORAGE_MODE_E */
    INT32     dwFullStrategy;       /* # NETDEV_FULL_STRATEGY_TYPE_E */
    BYTE      byRes[256];           
}NETDEV_PIC_STORAGE_STRATEGY_INFO_S, *LPNETDEV_PIC_STORAGE_STRATEGY_INFO_S;

/**
 * @struct tagNETDEVRecStorageStrategyInfo
 * @brief  
 * @attention 
 */
typedef struct tagNETDEVRecStorageStrategyInfo
{
    BOOL      bStoregeEnabled;      /* ,0:,1: */
    INT32     dwFullStrategy;       /* # NETDEV_FULL_STRATEGY_TYPE_E */
    INT32     dwPlanStreamType;     /* # NETDEV_LIVE_STREAM_INDEX_E */
    INT32     dwManualStreamType;   /* # NETDEV_LIVE_STREAM_INDEX_E */
    INT32     dwEventStreamType;    /* # NETDEV_LIVE_STREAM_INDEX_E */
    BYTE      byRes[256];           
}NETDEV_REC_STORAGE_STRATEGY_INFO_S, *LPNETDEV_REC_STORAGE_STRATEGY_INFO_S;

/**
 * @struct tagNETDEVStorageStrategy
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVStorageStrategy
{
    INT32                                     dwStorageRes;               /* , IPC,# NETDEV_STORAGE_RES_TYPE_E */
    NETDEV_REC_STORAGE_STRATEGY_INFO_S        stRecStoreStrategyInfo;     
    NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stPicStoreStrategyInfo;     
    NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stAIPicStoreStrategyInfo;   
    BYTE                                      byRes[512];                 
}NETDEV_STORAGE_STRATEGY_S, *LPNETDEV_STORAGE_STRATEGY_S;

/** 
 * struct tagNETDEVBackFocusInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVBackFocusInfo
{
    UINT32                  udwCmd;                     /*  # NETDEV_BACKFOCUS_CMD_E */
    UINT32                  udwPara1;                   /*  # NETDEV_BACKFOCUS_CMD_E */
    BYTE                    byRes[256];                 
}NETDEV_BACKFOCUS_INFO_S, *LPNETDEV_BACKFOCUS_INFO_S;

/**
 * @struct tagNETDEVAudioFileCapability
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioFileCapability
{
    UINT32 udwMaxNum;                                                     
    UINT32 udwMaxSize;                                                    /* KB */
    UINT32 udwFormatNum;                                                  
    CHAR   szFormatList[NETDEV_LEN_256];                                  /*  xx;xx;xx;FormatNum0,pcmg711a */
    BYTE   byRes[256];                                                    
}NETDEV_AUDIO_FILE_CAPABILITY_S,*LPNETDEV_AUDIO_FILE_CAPABILITY_S;

/**
 * @struct tagNETDEVLanguageCapability
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVLanguageCapability
{
    UINT32 udwNum;                                                        
    UINT32 audwLanguage[NETDEV_LEN_256];                                  /* [1-16]  NETDEV_LANG_TYPE_E */
    BYTE   byRes[256];                                                    
}NETDEV_LANGUAGE_CAPABILITY_S,*LPNETDEV_LANGUAGE_CAPABILITY_S;

/**
 * @struct tagNETDEVSysCapability
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVSysCapability
{
    NETDEV_AUDIO_FILE_CAPABILITY_S    stAudioFileCapability;               
    NETDEV_LANGUAGE_CAPABILITY_S      stLanguageCapability;                
    BYTE                              byRes[256];                          
}NETDEV_SYS_CAPABILITY_S,*LPNETDEV_SYS_CAPABILITY_S;

/**
 * @struct tagNETDEVAudioOutputCfg
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioOutputCfg
{
    UINT32 udwType;                                  /*   NETDEV_AUDIO_CHL_MODE_E */
    UINT32 udwGain;                                  /*  [0,255] AudioOutTypeNum0 */
    BYTE   byRes[256];                               
}NETDEV_AUDIO_OUTPUT_CFG_S,*LPNETDEV_AUDIO_OUTPUT_CFG_S;

/**
 * @struct tagNETDEVAudioFileInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAudioFileInfo
{
    UINT32 udwID;                                    /* ID */
    UINT32 udwStatus;                                /*   0  1 */
    UINT32 udwInstallType;                           /*  0 1*/
    CHAR   szFileName[NETDEV_LEN_1024];              /*  256 */
    BYTE   byRes[256];                               
}NETDEV_AUDIO_FILE_INFO_S,*LPNETDEV_AUDIO_FILE_INFO_S;

/**
 * @struct tagstNETDEVExceptionOutputInfo
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVExceptionOutputInfo
{
    INT32    dwEventCode;                                      /* ND */
    INT64    tPlayBackTime;                                    /* (ND) */
    CHAR     szFileName[NETDEV_LEN_256];                       
    INT32    dwOldSubID;                                       /* ID */
    INT32    dwNewSubID;                                       /* ID */
    INT32    dwSubType;                                        
    BYTE     byRes[116];                                       
}NETDEV_EXCEPTION_OUTPUT_INFO_S, *LPNETDEV_EXCEPTION_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVAddressInfo
 * @brief IP()
 * @attention 
 */
typedef struct tagNETDEVAddressInfo
{
    INT32                         dwAddressType;                /* IP0IPv4 1IPv6 */
    CHAR                          szIPAddress[NETDEV_LEN_64];   /* IP,[0,128] */
    INT32                         dwPort;                       /*  [1025, 65535]*/
    BYTE                          byRes[512];                   
}NETDEV_ADDRESS_INFO_S, *LPNETDEV_ADDRESS_INFO_S;

/**
 * @struct tagNETDEVTransPortCfg
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSerialTransCfg
{
    BOOL                                 bEnabled;                   /* : 0 1 */
    INT32                                dwSerialID;                 
    INT32                                dwTransMode;                /* 0 TCP 1 UDP */
    NETDEV_ADDRESS_INFO_S                stLocalAddress;             
    NETDEV_ADDRESS_INFO_S                stPeerAddress;              
    BYTE                                 byRes[512];                 
}NETDEV_SERIAL_TRANS_CFG_S, *LPNETDEV_SERIAL_TRANS_CFG_S;

/**
 * @struct tagNETDEVSerialTrans
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSerialTrans
{
    INT32                                          dwChannelID;                   
    NETDEV_SERIAL_TRANS_CFG_S                      stTransPortCfg;                
    BYTE                                           byRes[512];                    
}NETDEV_SERIAL_TRANS_S, *LPNETDEV_SERIAL_TRANS_S;

/**
 * @struct tagNETDEVUserDetailList
 * @brief 
 * @attention 485485
 */
typedef struct tagNETDEVSerialTransList
{
    INT32                         dwSerialTransNum;         
    LPNETDEV_SERIAL_TRANS_S       pstSerialTransList;       /* [0,1], Num0 malloc*/
    BYTE                          byRes[512];               
}NETDEV_SERIAL_TRANS_LIST_S, *LPNETDEV_SERIAL_TRANS_LIST_S;

/**
 * @struct tagNETDEVSeriaParam
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSeriaParam
{
    INT32                                       dwBaudRate;                /* [1200,115200]: bps */
    INT32                                       dwDataBit;                 /* [5-8] */
    INT32                                       dwFlowCtrl;                /* 0 1 2 */
    INT32                                       dwParity;                  /* 0 1 2 */
    INT32                                       dwStopBit;                 
    BYTE                                        byRes[512];                
}NETDEV_SERIAL_PARAM_S, *LPNETDEV_SERIAL_PARAM_S;

/**
 * @struct tagNETDEVSerialPort
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSerialPort
{
    INT32                                       dwChannelID;                
    INT32                                       dwMode;                     /* 1 2 */
    NETDEV_SERIAL_PARAM_S                       stSerialParam;              
    BYTE                                        byRes[512];                 
}NETDEV_SERIAL_PORT_S, *LPNETDEV_SERIAL_PORT_S;

/**
 * @struct tagNETDEVSerialPorts
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSerialPorts
{
    INT32                         dwSerialPortNum;          
    LPNETDEV_SERIAL_PORT_S        pstSerialPortList;        /*  dwSerialPortNum0; dwSerialPortNum0 */
    BYTE                          byRes[512];               
}NETDEV_SERIAL_PORTS_S, *LPNETDEV_SERIAL_PORTS_S;

/**
 * @struct tagNETDEVUserDetailList
 * @brief 
 * @attention 
 */
typedef struct tagNETDEVSerialStart
{
    INT32       dwSerialPort;               /* 1- 2322- 485#485 */
    INT32       dwSerialNum;                
    BYTE        byRes[512];                 
}NETDEV_SERIAL_START_S, *LPNETDEV_SERIAL_START_S;

/**
 * @struct tagNETDEVTimeTemplateBaseInfo
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVTimeTemplateBaseInfo
{
    UINT32                   udwTemplateID;                  /* ID */
    CHAR                     szTemplateName[NETDEV_LEN_256]; 
    UINT32                   udwLastChange;                  
    BYTE                     byRes[256];                     
}NETDEV_TIME_TEMPLATE_BASE_INFO_S, *LPNETDEV_TIME_TEMPLATE_BASE_INFO_S;

/**
 * @struct tagNETDEVTVwallCode
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVTVwallCode
{
    CHAR                            szTVwallCode[NETDEV_LEN_64];  /* [1, 64] */
    BYTE                            byRes[128];                   
}NETDEV_TVWALL_CODE_S, *LPNETDEV_TVWALL_CODE_S;

/**
 * @struct tagNETDEVPermissionInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVPermissionInfo
{
    UINT32                          udwMajorPermission;          /*  # NETDEV_MAJOR_RIGHT_E */
    UINT32                          udwMinorPermission;          /*  # NETDEV_MINOR_RIGHT_XXXX_E */
    UINT32                          udwOrgNum;                   
    UINT32                         *pudwOrgList;                 /* ID Malloc */
    UINT32                          udwChlNum;                   
    UINT32                         *pudwChlList;                 /*  Malloc */
    UINT32                          udwTvwallNum;                
    UINT32                         *pudwTvwallIDList;            /*  Malloc */
    LPNETDEV_TVWALL_CODE_S          pstTVwallCodeList;           /*  Malloc */
    UINT32                          udwEntranceNum;              
    UINT32                         *pudwEntranceIDList;          /*  Malloc */
    BYTE                            byRes[492];                  
}NETDEV_PERMISSION_INFO_S, *LPNETDEV_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVRoleInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVRoleInfo
{
    UINT32                          udwRoleID;                  /* ID */
    UINT32                          udwLevel;                   /*  [0,99] */
    CHAR                            szRoleName[NETDEV_LEN_256]; /*  [1,64] */
    CHAR                            szDesc[NETDEV_LEN_1024];    /*  [0,256] */
    UINT32                          udwOrgID;                   /* ID */
    UINT32                          udwPermissionsNum;          
    LPNETDEV_PERMISSION_INFO_S      pstPermissionList;          /*   Malloc */
    BYTE                            byRes[256];                 
}NETDEV_ROLE_INFO_S, *LPNETDEV_ROLE_INFO_S;

/**
 * @struct tagNETDEVRoleBaseInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVRoleBaseInfo
{
    UINT32                          udwRoleID;                    /* ID */
    CHAR                            szRoleName[NETDEV_LEN_256];   
    BYTE                            byRes[256];                   
}NETDEV_ROLE_BASE_INFO_S, *LPNETDEV_ROLE_BASE_INFO_S;

/**
 * @struct tagNETDEVUserExtendInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVUserExtendInfo
{
    CHAR                            szCertificateCode[NETDEV_LEN_64];       /*  [1,64] */
    CHAR                            szEmail[NETDEV_LEN_64];                 /*  [1,64] */
    CHAR                            szTelephone[NETDEV_LEN_64];             /*  [1,64] */
    CHAR                            szDesc[NETDEV_LEN_512];                 /*  [1,128] */
    CHAR                            szName[NETDEV_LEN_64];                  /*  [1,64] */
    BYTE                            byRes[192];                             
}NETDEV_USER_EXTEND_INFO_S, *LPNETDEV_USER_EXTEND_INFO_S;

/**
 * @struct tagNETDEVUserDetailInfo
 * @brief   
 * @attention  None
 */
typedef struct tagNETDEVUserDetailInfoV30
{
    UINT32                          udwUserID;                              /* ID Get VMS */
    UINT32                          udwLevel;                               /*  Post Put NVR  # NETDEV_USER_LEVEL_E */
    CHAR                            szUserName[NETDEV_LEN_256];             /* [1,64] */
    CHAR                            szPassword[NETDEV_LEN_256];             /*  Post Put[0,256] */
    CHAR                            szOldPassword[NETDEV_LEN_256];          /*  NVR Put[0,256] */
    NETDEV_TIME_TEMPLATE_S          stTimeTemplateInfo;                     /*  GetID Post PutID  VMS */
    NETDEV_TIME_S                   stValidBeginTime;                       /*   Get Post Put VMS */
    NETDEV_TIME_S                   stValidEndTime;                         /*   Get Post Put VMS */
    NETDEV_USER_EXTEND_INFO_S       stUserExtendInfo;                       /*  Post Put VMS  */
    UINT32                          udwOrgID;                               /* ID IPM  */
    BYTE                            byRes[252];                             
}NETDEV_USER_DETAIL_INFO_V30_S, *LPNETDEV_USER_DETAIL_INFO_V30_S;

/**
 * @struct tagNETDEVUserNameInfoList
 * @brief  
 * @attention  None
 */
typedef struct tagNETDEVUserNameInfoList
{
    CHAR                            szUserName[NETDEV_LEN_256];             /* [1,64] */
    BYTE                            byRes[256];                             
}NETDEV_USER_NAME_INFO_LIST_S, *LPNETDEV_USER_NAME_INFO_LIST_S;

/**
 * @struct tagNETDEVAreaPointCoordinate
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAreaPointCoordinate
{
    UINT32  udwX;       /* X[0,9999] */
    UINT32  udwY;       /* Y[0,9999] */
}NETDEV_AREA_POINT_COORDINATE_S,*LPNETDEV_AREA_POINT_COORDINATE_S;

/**
 * @struct tagNETDEVAreaLocationInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAreaLocationInfo
{
    UINT32                              udwAreaPointNum;            /* [3, 6] */
    LPNETDEV_AREA_POINT_COORDINATE_S    pstAreaPointCoordinate;     /* [09999] */
    BYTE                                byRes[512];                 
}NETDEV_AREA_LOCATION_INFO_S,*LPNETDEV_AREA_LOCATION_INFO_S;

/**
 * @struct tagNETDEVDetectLineRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVDetectLineRuleInfo
{
    UINT32                          udwDetectLineID;            /* ID0 */
    BOOL                            bEnabled;                   /* FALSE: TRUE: */
    UINT32                          udwInDirection;             /*  1B->A,BA2:A->B,AB */
    UINT32                          udwStatisticType;           /*   NETDEV_STATISTIC_TYPE_E */
    NETDEV_AREA_POINT_COORDINATE_S  stStartPointCoordinate;     
    NETDEV_AREA_POINT_COORDINATE_S  stEndPointCoordinate;       
    BYTE                            byRes[512];                 
}NETDEV_DETECT_LINE_RULE_INFO_S,*LPNETDEV_DETECT_LINE_RULE_INFO_S;

/**
 * @struct tagNETDEVDetectAreaRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVDetectAreaRuleInfo
{
    UINT32                      udwDetectAreaID;        /* ID0 */
    BOOL                        bEnabled;               /* FALSE: TRUE: */
    NETDEV_AREA_LOCATION_INFO_S stAreaLocationInfo;     
    BYTE                        byRes[512];             
}NETDEV_DETECT_AREA_RULE_INFO_S,*LPNETDEV_DETECT_AREA_RULE_INFO_S;

/**
 * @struct tagNETDEVLinePeopleCountRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVLinePeopleCountRuleInfo
{
    BOOL                                bEnabled;               /* FALSE: TRUE: */
    UINT32                              udwReportInterval;      /*  [1, 60] */
    UINT32                              udwLineNum;             
    LPNETDEV_DETECT_LINE_RULE_INFO_S    pstDetectLineRuleInfo;  /* udwLineNum */
    BYTE                                byRes[512];             
}NETDEV_LINE_PEOPLE_COUNT_RULE_INFO_S,*LPNETDEV_LINE_PEOPLE_COUNT_RULE_INFO_S;

/**
 * @struct tagNETDEVLinePeopleCountResetInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVLinePeopleCountResetInfo
{
    BOOL   bTimingResetEnabled;         /* FALSE: TRUE: */
    CHAR   szResetTime[NETDEV_LEN_64];  /* ,[0, 24]"00:00:00" */
    BYTE   byRes[256];                  
}NETDEV_LINE_PEOPLE_COUNT_RESET_INFO_S,*LPNETDEV_LINE_PEOPLE_COUNT_RESET_INFO_S;

/**
 * @struct tagNETDEVAreaPeopleCountRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAreaPeopleCountRuleInfo
{
    BOOL                                bEnabled;               /* FALSE: TRUE: */
    UINT32                              udwReportInterval;      /*  [1, 60] */
    UINT32                              udwAreaNum;             
    LPNETDEV_DETECT_AREA_RULE_INFO_S    pstDetectAreaRuleInfo;  /* udwAreaNum */
    BYTE                                byRes[512];             
}NETDEV_AREA_PEOPLE_COUNT_RULE_INFO_S,*LPNETDEV_AREA_PEOPLE_COUNT_RULE_INFO_S;

/**
 * @struct tagNETDEVAreaRuleCountData
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAreaRuleCountData
{
    UINT32 udwAreaID;                                /* ID0 */
    UINT32 udwObjectNum;                             
    BYTE   byRes[256];                               
}NETDEV_AREA_RULE_COUNT_DATA_S,*LPNETDEV_AREA_RULE_COUNT_DATA_S;

/**
 * @struct tagNETDEVPeopleCountAreaRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPeopleCountAreaRuleInfo
{
    CHAR                                szReference[NETDEV_LEN_260];    
    INT64                               tTimeStamp;                     /*  1970110 */
    UINT32                              udwSeq;                         
    CHAR                                szDeviceID[NETDEV_LEN_32];      
    UINT32                              udwChannelID;                   /* 0 */
    UINT32                              udwAreaNum;                     /* 00 */
    LPNETDEV_AREA_RULE_COUNT_DATA_S     pstAreaRuleCountDataList;       /* ,  */
    BYTE   byRes[256];                                                  
}NETDEV_PEOPLE_COUNT_AREA_RULE_INFO_S,*LPNETDEV_PEOPLE_COUNT_AREA_RULE_INFO_S;

/**
 * @struct tagNETDEVLineRuleCountData
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVLineRuleCountData
{
    UINT32 udwLineID;                                /* ID0 */
    CHAR   szBeginPassTime[NETDEV_LEN_64];           /* YYYYMMDDHHMMSS24[0,18] */
    CHAR   szEndPassTime[NETDEV_LEN_64];             /* YYYYMMDDHHMMSS24[0,18] */
    UINT32 udwObjectIn;                              
    UINT32 udwObjectOut;                             
    BYTE   byRes[256];                               
}NETDEV_LINE_RULE_COUNT_DATA_S,*LPNETDEV_LINE_RULE_COUNT_DATA_S;

/**
 * @struct tagNETDEVPeopleCountLineRuleInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPeopleCountLineRuleInfo
{
    CHAR                            szReference[NETDEV_LEN_260];    
    INT64                           tTimeStamp;                     /*  1970110 */
    UINT32                          udwSeq;                         
    CHAR                            szDeviceID[NETDEV_LEN_32];      
    UINT32                          udwChannelID;                   /* 0 */
    UINT32                          udwLineNum;                     /* 00 */
    LPNETDEV_LINE_RULE_COUNT_DATA_S pstLineRuleCountDataList;       
    BYTE                            byRes[256];                     
}NETDEV_PEOPLE_COUNT_LINE_RULE_INFO_S,*LPNETDEV_PEOPLE_COUNT_LINE_RULE_INFO_S;

/**
 * @struct tagNETDEVCrowdDensitySummaryInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCrowdDensitySummaryInfo
{
    UINT32  udwTotalIn;        
    UINT32  udwTotalOut;       
    UINT32  udwAlarmThermal;   
    BYTE    byRes[256];     
}NETDEV_CROWD_DENSITY_SUMMARY_INFO_S,*LPNETDEV_CROWD_DENSITY_SUMMARY_INFO_S;

/**
 * @struct tagNETDEVCrowdDensityData
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCrowdDensityData
{
    UINT32                              udwGroupID;                 /* ID */
    INT64                               tBeginTime;                 /* UTC */
    INT64                               tEndTime;                   /* UTC */
    UINT32                              udwObjectIn;                
    UINT32                              udwObjectOut;               
    NETDEV_CROWD_DENSITY_SUMMARY_INFO_S stCrowdDensitySummaryInfo;  
    BYTE                                byRes[256];                 
}NETDEV_CROWD_DENSITY_DATA_S,*LPNETDEV_CROWD_DENSITY_DATA_S;

/**
 * @struct tagNETDEVCrowdDensityInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVCrowdDensityInfo
{
    CHAR                                szReference[NETDEV_LEN_260];    
    INT64                               tTimeStamp;                     /*  1970110 */
    UINT32                              udwSeq;                         
    UINT32                              udwSrcID;                       /* ID */
    CHAR                                szSrcName[NETDEV_LEN_64];       /* ,[1,63] */
    UINT32                              udwRelatedID;                   /* ID */
    NETDEV_CROWD_DENSITY_DATA_S         stCrowdDensityData;             
    BYTE   byRes[256];                                                  
}NETDEV_CROWD_DENSITY_INFO_S,*LPNETDEV_CROWD_DENSITY_INFO_S;

 /**
 * @struct tagNETDEVPeopleCountAlarmInfo
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVPeopleCountAlarmInfo
{
    UINT32                                  udwType;            /* #NETDEV_PEOPLE_COUNT_ALARM_TYPE_E */
    NETDEV_PEOPLE_COUNT_AREA_RULE_INFO_S    stAreaRuleInfo;     
    NETDEV_PEOPLE_COUNT_LINE_RULE_INFO_S    stLineRuleInfo;     
    NETDEV_CROWD_DENSITY_INFO_S             stCrowdDensityInfo; 
    BYTE                                    byRes[512];         
}NETDEV_PEOPLE_COUNT_ALARM_INFO_S,*LPNETDEV_PEOPLE_COUNT_ALARM_INFO_S;

/**
* @struct tagNETDEVAlarmRuleInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVAlarmRuleInfo
{
    BOOL            bEnabled;                   /* , FALSE: TRUE: */
    UINT32          udwAlarmThermal;            
    BYTE            byRes[128];                 /*   Reserved */
}NETDEV_ALARM_RULE_INFO_S,*LPNETDEV_ALARM_RULE_INFO_S;

/**
* @struct tagNETDEVChannelRuleInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVChannelRuleInfo
{
    UINT32      udwChannelID;                   /* ID */
    UINT32      udwRuleNum;                     
    UINT32      audwRuleIDList[NETDEV_LEN_64];  /* ID */
    BYTE        byRes[128];                     /*   Reserved */
}NETDEV_CHANNEL_RULE_INFO_S,*LPNETDEV_CHANNEL_RULE_INFO_S;

/**
* @struct tagNETDEVCrowdDensityRuleInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVCrowdDensityRuleInfo
{
    NETDEV_ALARM_RULE_INFO_S    stMinorAlarmRuleInfo;       
    NETDEV_ALARM_RULE_INFO_S    stMajorAlarmRuleInfo;       
    NETDEV_ALARM_RULE_INFO_S    stCriticalAlarmRuleInfo;    
    BYTE                        byRes[256];                 /*   Reserved */
}NETDEV_CROWD_DENSITY_RULE_INFO_S,*LPNETDEV_CROWD_DENSITY_RULE_INFO_S;

/**
* @struct tagNETDEVCrowdDensityGroupInfo
* @brief 
* @attention None
*/
typedef struct tagNETDEVCrowdDensityGroupInfo
{
    UINT32                              udwGroupID;                 /* ID */
    CHAR                                szGroupName[NETDEV_LEN_64]; /* [0,63] */
    UINT32                              udwStatisticalType;         /*  # NETDEV_CROWD_DENSITY_STATISTIC_TYPE_E */
    UINT32                              udwChannelRuleNum;          
    LPNETDEV_CHANNEL_RULE_INFO_S        pstChannelRuleInfoList;     /* 0 */
    NETDEV_CROWD_DENSITY_RULE_INFO_S    stCrowdDensityRuleInfo;     
    UINT32                              udwReportInterval;          /*  :() */
    BYTE                                byRes[256];                 /*   Reserved */
}NETDEV_CROWD_DENSITY_GROUP_INFO_S,*LPNETDEV_CROWD_DENSITY_GROUP_INFO_S;

/*
* @struct tagNETDEVObjectInfoList
* @brief 
* @attention  None
*/
typedef struct tagNETDEVObjectInfoList
{
    UINT32                        udwObjectID;              /* ID */
    NETDEV_FILE_INFO_S            stSmallImageInfo;         
    NETDEV_SINGLE_OBJECT_INFO_S   stObjectInfo;             
    BYTE                          byRes[1024];              /*   Reserved */
}NETDEV_OBJECT_INFO_LIST_S,*LPNETDEV_OBJECT_INFO_LIST_S;

/*
* @struct tagNETDEVObjectResultInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVObjectResultInfo
{
    UINT32                       udwRecordID;                              /* ID */
    UINT32                       udwType;                                  /*   NETDEV_OBJECT_RECORD_TYPE_E */
    UINT32                       udwTime;                                  /* UTC */
    CHAR                         szChannelName[NETDEV_LEN_256];            /* [1,63] */
    UINT32                       udwChannelID;                             /* ID */
    NETDEV_FILE_INFO_S           stBigImageInfo;                           
    UINT32                       udwObjectInfoNum;                         
    LPNETDEV_OBJECT_INFO_LIST_S  pstObjectInfoList;                        
    BYTE                         byRes[512];                               /*   Reserved */
}NETDEV_OBJECT_RESULT_INFO_S,*LPNETDEV_OBJECT_RESULT_INFO_S;

/**
 * @struct tagNETDEVAlarmRelatedData
 * @brief  Alarm Related Data
 * @attention  None
 */
typedef struct tagNETDEVAlarmRelatedData
{
    NETDEV_STRUCT_DATA_INFO_S stStructDataInfo;         
    BYTE                      bRes[1024];               /*  Reserved */
}NETDEV_ALARM_RELATED_DATA_S, *LPNETDEV_ALARM_RELATED_DATA_S;

/**
* @struct tagNETDEVAlarmPicBaseInfo
* @brief 
* @attention  None
*/
typedef struct tagNETDEVAlarmPicBaseInfo
{
    CHAR   szReference[NETDEV_LEN_260];                     
    UINT32 udwAlarmType;                                    /* # NETDEV_ALARM_TYPE_E */
    INT64  tTimeStamp;                                      /*  1970110 */
    UINT32 udwSeq;                                          
    UINT32 udwSourceID;                                     /* ID VMSIPC */
    CHAR   szSourceName[NETDEV_LEN_256];                    /* [1,63] */
    CHAR   szDeviceID[NETDEV_LEN_32];                       /* ID[1,32] IPCVM */
    CHAR   szRelatedID[NETDEV_LEN_16];                      /* ID15 */
    BYTE   byRes[256];                                      
}NETDEV_ALARM_PIC_BASE_INFO_S,*LPNETDEV_ALARM_PIC_BASE_INFO_S;

/**
 * @struct tagNETDEVAlarmPicData
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVAlarmPicData
{
    NETDEV_ALARM_PIC_BASE_INFO_S stAlarmPicBaseInfo;        
    UINT32                       udwImageNum;               
    LPNETDEV_STRUCT_IMAGE_INFO_S pstImageInfo;              
    BYTE                         byRes[512];                
}NETDEV_ALARM_PIC_DATA_S,*LPNETDEV_ALARM_PIC_DATA_S;

/* END***********   Structure *********************************** */




/**
* SDK   SDK initialization
* @return TRUE, TRUE means success, and any other value means failure.
* @note  Thread not safe
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Init(void);

/**
* SDK   SDK cleaning
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Cleanup(void);

/**
* SDK Get SDK version information 
* @return SDK SDK version information
* @note
* - 8,.0x010800001.8.0.0.
* - The two high bytes,The high-8-bit indicate the major version, and the low-8-bytes indicate the minor version.Two low bytes for additional version numbers For example, 0x01080000 means version 1.8.0.0
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetSDKVersion(void);

/**
*   Get error codes
* @return  Error codes
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetLastError();

/**
*  Set log path
* @param [IN]   pszLogPath  ()  Log path (file name not included)
* @return TRUE,  TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetLogPath(IN CHAR *pszLogPath);

/**
*  Set log file size and number
* @param [IN] dwLogFileSize     () The size of single log file
* @param [IN] dwLogFileNum        Log file number
* @return TRUE, TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ConfigLogFile(IN INT32 dwLogFileSize,
                                                          IN INT32 dwLogFileNum);

/**
*  Set write log flag
* @param [IN]   bWriteLogFlag    TRUE:,FALSE
* @return VOID
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetWriteLogFlag(IN BOOL bWriteLogFlag);


/**
* 
* @param [IN] dwLogLevel     0-1-ERROR2-ERRORWARN3-ERRORWARNINFO4-ERRORWARNINFODEBUG
* @param [IN] pszLogPath     ()
* @param [IN] dwLogFileSize  ()
* @param [IN] dwLogFileNum   
* @return TRUE,
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetLogToFile(IN INT32 dwLogLevel,
                                                         IN CHAR *pszLogPath,
                                                         IN INT32 dwLogFileSize,
                                                         IN INT32 dwLogFileNum
                                                         );

/**
*  Set timeout
* @param [IN]  pstRevTimeout          Pointer to timeout
* @return TRUE,    TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetRevTimeOut(IN LPNETDEV_REV_TIMEOUT_S pstRevTimeout);

/**
*  Set keep-alive parameters
* @param [IN]  dwWaitTime              Waiting time
* @param [IN]  dwTrytimes              Connecting attempts
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetConnectTime(IN INT32 dwWaitTime,
                                                           IN INT32 dwTrytimes);

/**
* 
* @param [IN] pszClientID                              ID 
* @return TRUE
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetClientID(IN CHAR *pszClientID);

/**
* 
* @param [IN]  dwMaxdecNum        
* @return TRUE
* @note 
*    1128
*    2
*    3SDK
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetMaxDecChlNum(IN UINT32 dwMaxdecNum);

/**
*  Device discovery callback function
* @param [IN] pstDevInfo                 Device info
* @param [IN] lpUserData                 User data
* @note
*/
typedef void(STDCALL *NETDEV_DISCOVERY_CALLBACK_PF)(IN LPNETDEV_DISCOVERY_DEVINFO_S pstDevInfo,
                                                    IN LPVOID lpUserData);

/**
*  Registered device discovery callback function
* @param [IN] cbDiscoveryCallBack    Callback function
* @param [IN] lpUserData             User data
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetDiscoveryCallBack(IN NETDEV_DISCOVERY_CALLBACK_PF cbDiscoveryCallBack,
                                                                 IN LPVOID lpUserData);

/**
*  ,,
* This interface is used for device discovery. Please first register callback functions related to device discovery and use this interface for device discovery. Discovered device info will be included in the callback function.
* @param [IN]   pszBeginIP                 IP
* @param [IN]   pszEndIP                   IP
* @return TRUE,
* @note pszBeginIPpszEndIP"0.0.0.0",
*/
NETDEV_API NEWINTERFACE BOOL  STDCALL NETDEV_Discovery(IN CHAR *pszBeginIP,
                                                       IN CHAR *pszEndIP);

/**
* IP
* @param [IN]   pstDevAddrInfo         
* @return TRUE,
* @note 
*/
NETDEV_API NEWINTERFACE BOOL  STDCALL NETDEV_ModifyDeviceAddr(IN LPNETDEV_DEV_ADDR_INFO_S pstDevAddrInfo);

/**
*   User login
* @param [IN]  pszDevIP         IP Device IP
* @param [IN]  wDevPort          Device server port
* @param [IN]  pszUserName       Username
* @param [IN]  pszPassword       Password
* @param [OUT] pstDevInfo        Pointer to device information structure
* @return , 0 ,. Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_Login(IN char *pszDevIP,
                                                    IN INT16 wDevPort,
                                                    IN char *pszUserName,
                                                    IN char *pszPassword,
                                                    OUT LPNETDEV_DEVICE_INFO_S pstDevInfo);

/**
* 
* @param [IN]  pstDevLoginInfo  
* @param [OUT] pstSELogInfo     
* @return ID
* @note LAPI
* -
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_Login_V30(IN LPNETDEV_DEVICE_LOGIN_INFO_S pstDevLoginInfo, 
                                                        OUT LPNETDEV_SELOG_INFO_S pstSELogInfo);

/**
*   User logout
* @param [IN] lpUserID     User login ID
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Logout(IN LPVOID lpUserID);

/**
*   Callback function to receive alarm information
* @param [IN] lpUserID               User login ID
* @param [IN] dwChannelID            Channel ID
* @param [IN] stAlarmInfo            Alarm information
* @param [IN] lpBuf                  Pointer to buffer
* @param [IN] dwBufLen               Length of structure for alarm information
* @param [IN] lpUserData             User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBack_PF)(IN LPVOID lpUserID,
                                                   IN INT32 dwChannelID,
                                                   IN NETDEV_ALARM_INFO_S stAlarmInfo,
                                                   IN LPVOID lpBuf,
                                                   IN INT32 dwBufLen,
                                                   IN LPVOID lpUserData);

/**
* ,ID, Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)
* @param [IN] lpUserID               User login ID
* @param [IN] cbAlarmMessCallBack    Callback function
* @param [IN] lpUserData             User data
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBack(IN LPVOID lpUserID,
                                                             IN NETDEV_AlarmMessCallBack_PF cbAlarmMessCallBack,
                                                             IN LPVOID lpUserData);

/**
*   Callback function to receive alarm information
* @param [IN] lpUserID                    User login ID
* @param [IN] stAlarmInfo                 Alarm information
* @param [IN] lpUserData                  User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBackV2_PF)(IN LPVOID lpUserID,
                                                     IN NETDEV_ALARM_INFO_EX_S stAlarmInfo,
                                                     IN LPVOID lpUserData);

/**
* ,ID,
* @param [IN] lpUserID              
* @param [IN] cbAlarmMessCallBack   
* @param [IN] pstSubscribeInfo      
* @param [IN] lpUserData            
* @return TRUE,
* @note  NETDEV_SetAlarmCallBack_V30
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBackV2(IN LPVOID lpUserID, 
                                                               IN NETDEV_AlarmMessCallBackV2_PF cbAlarmMessCallBack,
                                                               IN LPNETDEV_ALARM_SUB_INFO_S pstSubscribeInfo, 
                                                               IN LPVOID lpUserData);

/**
*  Callback function to receive alarm information
* @param [IN] lpUserID              ID
* @param [IN] pstReportInfo          Alarm information
* @param [IN] lpBuf                  Pointer to buffer
* @param [IN] dwBufLen               Length of structure for alarm information
* @param [IN] dwBufLen               User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBack_PF_V30)(IN LPVOID lpUserID,
                                                       IN LPNETDEV_REPORT_INFO_S pstReportInfo,
                                                       IN LPVOID    lpBuf,
                                                       IN INT32     dwBufLen,
                                                       IN LPVOID    lpUserData);

/**
* 
* Register callback function and receive alarm information, etc.
* @param [IN] lpUserID              ID User login ID
* @param [IN] cbAlarmMessCallBack    Callback function
* @param [IN] lpUserData             User data
* @return TRUE TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBack_V30(IN LPVOID lpUserID,
                                                                 IN NETDEV_AlarmMessCallBack_PF_V30 cbAlarmMessCallBack,
                                                                 IN LPVOID lpUserData);

/**
* .  Callback function to receive exception and reconnection messages
* @param [IN] lpUserID      User login ID
* @param [IN] dwType       :NETDEV_EXCEPTION_TYPE_E Type of exception or reconnection message: NETDEV_EXCEPTION_TYPE_E
* @param [IN] lpExpHandle   Exception type handle
* @param [IN] lpUserData    User data
* @param [OUT] pstExceptionOutputInfo    Exception output information
* @note
*/
typedef void(STDCALL *NETDEV_ExceptionCallBack_PF)(IN LPVOID lpUserID,
                                                   IN INT32 dwType,
                                                   IN LPVOID lpExpHandle,
                                                   IN LPVOID lpUserData,
                                                   IN LPNETDEV_EXCEPTION_OUTPUT_INFO_S pstExceptionOutputInfo
                                                   );

/**
* sdk.  Callback function to register SDK, receive exception and reconnection messages, etc.
* @param [IN] cbExceptionCallBack       , Callback function to receive exception messages, used to call back information about current exceptions
* @param [IN] lpUserData                 User data
* @return TRUE, TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetExceptionCallBack(IN NETDEV_ExceptionCallBack_PF cbExceptionCallBack,
                                                                 IN LPVOID lpUserData);

/**
* 
* @param [IN] lpUserID          ID
* @param [IN] dwAlarmType     NETDEV_SUBSCRIBE_ALARM_TYPE_E 
* @return TRUE
* @note   NETDEV_SetAlarmCallBack
* -
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Subscribe(IN LPVOID lpUserID,
                                                      IN INT32 dwAlarmType);

/**
* 
* @param [IN] lpUserID          ID
* @return TRUE
* @note
* -
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Unsubscribe(IN LPVOID lpUserID);

/**
*         GetDev