package main.java.com.netdevsdk.demo.config.basic;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_BASICINFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;

/**
 * 
 * @introduction Device name
 * @description Support IPC/NVR/VMS
 */
public class DeviceName {

    /**
     * 
     * @introduction Get device name
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getDeviceName() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		NETDEV_DEVICE_BASICINFO_S stDeviceInfo = new NETDEV_DEVICE_BASICINFO_S();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DEVICECFG, stDeviceInfo.getPointer(), stDeviceInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stDeviceInfo.read();
        NetDemo.textFieldConfigDeviceName.setText(Common.byteArrayToString(stDeviceInfo.szDeviceName));
	}
	
	/**
	 * 
	 * @introduction Set device name
	 * @description
	 *
	 */
	public static void setDeviceName() {
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
             JOptionPane.showMessageDialog(null, "VMS cannot modify device name");
                return;
         }

        String strDeviceNameString = NetDemo.textFieldConfigDeviceName.getText();
        try {
            strDeviceNameString=new String(strDeviceNameString.getBytes(),"UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        if((strDeviceNameString==null||strDeviceNameString.equals(""))||strDeviceNameString.length()>20) {
            JOptionPane.showMessageDialog(null, "Length of device name should between 1 and 20!");
            NetDemo.textFieldConfigDeviceName.setText(strDeviceNameString.substring(0, 20));
            return;
        }
        

        boolean bRet = NetDemo.netdevsdk.NETDEV_ModifyDeviceName(NetDemo.lpUserID, strDeviceNameString);
        if(bRet != true)
        {
            System.out.printf("NETDEV_ModifyDeviceName failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Set success");
            NetDemo.jButtonConfigGetDeviceName.doClick();
        }
    
	}
}
