package main.java.com.netdevsdk.demo.config.motion;

import java.awt.event.ItemEvent;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_TYPE_S;

/**
 * 
 * @introduction Motion Area
 * @description Support IPC
 */
public class MotionArea {
    
    /**
     * 
     * @introduction Get motion area
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getMotionArea() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_MOTION_DETECTION_AREA_TYPE_S stMotionAreaType = new NETDEV_MOTION_DETECTION_AREA_TYPE_S();
        stMotionAreaType.write();
        IntByReference dwBytesReturned = new IntByReference();
        
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTION_DETECTION_AREA_TYPE, stMotionAreaType.getPointer(), 132, dwBytesReturned );
        if(bRet != true) {
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stMotionAreaType.read();
        System.out.println(stMotionAreaType.udwAreaType);
        NetDemo.jComboBoxAreaType.setSelectedIndex(stMotionAreaType.udwAreaType);
        //视频通道运动检测区域类型为矩形区域
        if(stMotionAreaType.udwAreaType == 0){
            setMacroElement(false);
            setRectangleElement(true);
            NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S RectangleArea = new NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S();
            RectangleArea.write();
            dwBytesReturned = new IntByReference();
            bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST, RectangleArea.getPointer(), 1444, dwBytesReturned );
            if(bRet != true) {
                System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
                }
            RectangleArea.read();
            System.out.println(RectangleArea.udwNum);
            NetDemo.textFieldConfigChannelMotionRectangleAreaNum.setText(String.valueOf(RectangleArea.udwNum));
            }else if(stMotionAreaType.udwAreaType == 1){
                setMacroElement(true);
                setRectangleElement(false);
         //视频通道运动检测区域类型为宏块区域
            NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S GridArea = new NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S();
            GridArea.write();
            dwBytesReturned = new IntByReference();
            bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTION_DETECTION_AREA_GRID_INFO, GridArea.getPointer(), 1444, dwBytesReturned );
            if(bRet != true) {
                System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            GridArea.read();
        }
    }

    /**
     * 
     * @introduction Set motion area
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setMotionAera() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_MOTION_DETECTION_AREA_TYPE_S stMotionAreaType = new NETDEV_MOTION_DETECTION_AREA_TYPE_S();
        stMotionAreaType.udwAreaType = NetDemo.jComboBoxAreaType.getSelectedIndex();
        stMotionAreaType.write();
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_MOTION_DETECTION_AREA_TYPE, stMotionAreaType.getPointer(), 132);
        if(bRet != true) {
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        JOptionPane.showMessageDialog(null, "Set Success.");
    }
    
    /**
     * 
     * @introduction Modify rectangle area
     * @description
     *
     */
    public static void modifyReactangleArea() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        MotionDetectionAreaWindow mda=new MotionDetectionAreaWindow(NETDEV_MOTION_DETECTION_AREA_TYPE_E.NETDEV_MOTION_DETECTION_AREA_TYPE_RECTANGLE,NetDemo.lpUserID,NetDemo.ChannelID);
        mda.setVisible(true);     
    }
    
    /**
     * 
     * @introduction Modify macro area
     * @description
     *
     */
    public static void modifyMacroArea() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        MotionDetectionAreaWindow mdaw=new MotionDetectionAreaWindow(NETDEV_MOTION_DETECTION_AREA_TYPE_E.NETDEV_MOTION_DETECTION_AREA_TYPE_MB, NetDemo.lpUserID, NetDemo.ChannelID);
        mdaw.setVisible(true);
    
    }
    
    /**
     * 
     * @introduction Change motion area type
     * @description
     *
     */
    public static void changeAreaType(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            NETDEV_MOTION_DETECTION_AREA_TYPE_S stMotionAreaType = new NETDEV_MOTION_DETECTION_AREA_TYPE_S();
            stMotionAreaType.udwAreaType = NetDemo.jComboBoxAreaType.getSelectedIndex();
            if(stMotionAreaType.udwAreaType == 0){
                setMacroElement(false);
                setRectangleElement(true);
            }else if(stMotionAreaType.udwAreaType == 1){
                setMacroElement(true);
                setRectangleElement(false);
                }
            }
        }
       
    public static void setRectangleElement(boolean aFlag){
        NetDemo.lblAreaRectangle.setVisible(aFlag);
        NetDemo.textFieldConfigChannelMotionRectangleAreaNum.setVisible(aFlag);
        NetDemo.jButtonModifyRectangleArea.setVisible(aFlag);
    }
    
    public static void setMacroElement(boolean aFlag){
        NetDemo.lblAreaGridInfo.setVisible(aFlag);
        NetDemo.jButtonModifyMacroArea.setVisible(aFlag);
    }

}
