package main.java.com.netdevsdk.demo.config.network;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEV_ADDR_INFO_S;

/**
 * 
 * @introduction Set IPV4 adress
 * @description Support IPC/NVR
 */
public class IPAdress {
    
    /**
     * 
     * @introduction Set IPV4 adress
     * @description Calling the interface of NETDEV_ModifyDeviceAddr
     *
     */
    public static void setIpv4DeviceAddress() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if((NetDemo.DiscoveryTableModel.getRowCount()>0)&&(NetDemo.DiscoveryTable.getRowCount()>0)) {
            String MAC=null;
            try {
                MAC=(String) NetDemo.DiscoveryTableModel.getValueAt(NetDemo.DiscoveryTable.getSelectedRow(), 3);
            }catch(Exception m1) {
                JOptionPane.showMessageDialog(null, "MAC is null");
                return;
            }
            String Serial=null;
            try {
                Serial=(String) NetDemo.DiscoveryTableModel.getValueAt(NetDemo.DiscoveryTable.getSelectedRow(), 4);
            }catch(Exception m2) {
                JOptionPane.showMessageDialog(null, "Serial Num is null");
                return;
            }
            
            if(MAC==null||MAC.equals("")) {
                JOptionPane.showMessageDialog(null, "MAC is null");
                return;
            }
            if(Serial==null||Serial.equals("")) {
                JOptionPane.showMessageDialog(null, "Serial NUM is null");
                return;
            }
            
            String getUpdateUsername=NetDemo.jTextFieldUpdateUserName.getText();
            String getUpdatePassword=NetDemo.textFieldUpdatePassword.getText();
            String ipAddress=NetDemo.jTextFieldModifyDeviceIpv4Address.getText();
            String gateWay=NetDemo.jTextFieldUpdateChangeDeviceIpGateWay.getText();
            String Mask=NetDemo.jTextFieldUpdateChangeDeviceIpMask.getText();           
            if(getUpdateUsername==null||getUpdateUsername.equals("")) {
                JOptionPane.showMessageDialog(null, "Username is null");
                return;
            } 
            if(getUpdatePassword==null||getUpdatePassword.equals("")) {
                JOptionPane.showMessageDialog(null, "Password is null");
                return;
            }
            if(ipAddress==null||ipAddress.equals("")) {
                JOptionPane.showMessageDialog(null, "IP can not null");
                return;
            }
            if(gateWay==null||gateWay.equals("")) {
                JOptionPane.showMessageDialog(null, "GateWay can not null");
                return;
            }
            if(Mask==null||Mask.equals("")) {
                JOptionPane.showMessageDialog(null, "Mask can not null");
                return;
            }
            
            NETDEV_DEV_ADDR_INFO_S devAddr=new NETDEV_DEV_ADDR_INFO_S();
            Common.stringToByteArray(MAC, devAddr.szDevMac);
            Common.stringToByteArray(Serial, devAddr.szDevSerailNum);
            Common.stringToByteArray(getUpdateUsername, devAddr.szUserName);
            Common.stringToByteArray(getUpdatePassword, devAddr.szPassword);
            Common.stringToByteArray(gateWay, devAddr.szIPv4GateWay);
            Common.stringToByteArray(Mask, devAddr.szIPv4SubnetMask);
            if(Common.isIP(ipAddress)){
                Common.stringToByteArray(ipAddress, devAddr.szIPv4Address);
                devAddr.write();
                boolean bRet= NetDemo.netdevsdk.NETDEV_ModifyDeviceAddr(devAddr);
                if(bRet!=true) {
                    JOptionPane.showMessageDialog(null, "Modify Device Address failed,please check your username and password or other parameters,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                    System.out.printf("NETDEV_NETDEV_ModifyDeviceAddr failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }else {
                    JOptionPane.showMessageDialog(null, "Set success");
                }
            }else {
                JOptionPane.showMessageDialog(null,"Please re-enter ,ip is error");
            }
        }else {
            JOptionPane.showMessageDialog(null, "Please choose device");
            return;
        }
    }
}
