package main.java.com.netdevsdk.demo.config.network;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PROTOCOL_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_UPNP_NAT_STATE_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_UPNP_PORT_STATE_S;

/**
 * 
 * @introduction Port mapping
 * @description Only support IPC
 */
public class OnvifPort {
    /**
     * 
     * @introduction Get port
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getPort() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        NETDEV_UPNP_NAT_STATE_S stNatState = new NETDEV_UPNP_NAT_STATE_S();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetUpnpNatState(NetDemo.lpUserID, stNatState);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetUpnpNatState failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        stNatState.read();
        for(int i =0; i < stNatState.dwSize; i++)
        {
            switch (stNatState.astUpnpPort[i].eType) {
            case NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_HTTP:
                NetDemo.jTextFieldNetworkPortHTTP.setText(String.valueOf(stNatState.astUpnpPort[i].dwPort));
                if(stNatState.astUpnpPort[i].bEnbale == 1) {
                    NetDemo.jComboBoxNetworkPortHTTP.setSelectedIndex(1);
                }else {
                    NetDemo.jComboBoxNetworkPortHTTP.setSelectedIndex(2);
                    } 
                break;
            case NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_HTTPS:
                NetDemo.jTextFieldNetworkPortHTTPS.setText(String.valueOf(stNatState.astUpnpPort[i].dwPort));
                if(stNatState.astUpnpPort[i].bEnbale == 1) {
                    NetDemo.jComboBoxNetworkPortHTTPS.setSelectedIndex(1);
                    }else {
                    NetDemo.jComboBoxNetworkPortHTTPS.setSelectedIndex(2);
                    }
                break;
            case NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_RTSP:
                NetDemo.jTextFieldNetworkPortRTSP.setText(String.valueOf(stNatState.astUpnpPort[i].dwPort));
                if(stNatState.astUpnpPort[i].bEnbale == 1) {
                    NetDemo.jComboBoxNetworkPortRTSP.setSelectedIndex(1);
                    }else {
                    NetDemo.jComboBoxNetworkPortRTSP.setSelectedIndex(2);
                    }
                break;
            default:
                break;
            }
        }
    }

    /**
     * 
     * @introduction Set port
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setPort() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        NETDEV_UPNP_NAT_STATE_S stNatState = new NETDEV_UPNP_NAT_STATE_S();
        stNatState.dwSize = 3;
        for(int i = 0; i < 3; i++) {
            stNatState.astUpnpPort[i] = new NETDEV_UPNP_PORT_STATE_S();
            }
        stNatState.astUpnpPort[0].eType = NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_HTTP;
        
        String  FieldNetworkPortHTTP= NetDemo.jTextFieldNetworkPortHTTP.getText();
        if(FieldNetworkPortHTTP==null||FieldNetworkPortHTTP.equals("")) {
            JOptionPane.showMessageDialog(null, "Please input httpport");
            return;
        }
        
        int getFieldNetworkPortHTTP=0;
        try {
            getFieldNetworkPortHTTP=Integer.parseInt(FieldNetworkPortHTTP);
        }catch(NumberFormatException |InputMismatchException e2) {
            JOptionPane.showMessageDialog(null, "Http port is null or transformation Exception");
            NetDemo.jTextFieldNetworkPortHTTP.setText(null);
            return;
        }
        
        if(getFieldNetworkPortHTTP==0) {
            JOptionPane.showMessageDialog(null, "Http port can not use");
            NetDemo.jTextFieldNetworkPortHTTP.setText(null);
            return;
        }
        if(getFieldNetworkPortHTTP>65535||getFieldNetworkPortHTTP<0) {
            JOptionPane.showMessageDialog(null, "Http port should between 0 and 65535");
            NetDemo.jTextFieldNetworkPortHTTP.setText(null);
            return;
        }
        
        stNatState.astUpnpPort[0].dwPort = getFieldNetworkPortHTTP;
        if(NetDemo.jComboBoxNetworkPortHTTP.getSelectedIndex() == 1) {
            stNatState.astUpnpPort[0].bEnbale = 1;
        }else {
            stNatState.astUpnpPort[0].bEnbale = 0;
        }
        stNatState.astUpnpPort[1].eType = NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_HTTPS;
        
        String  FieldNetworkPortHTTPS= NetDemo.jTextFieldNetworkPortHTTPS.getText();
        if(FieldNetworkPortHTTPS==null||FieldNetworkPortHTTPS.equals("")) {
            JOptionPane.showMessageDialog(null, "Please input httpsport");
            return;
        }
        
        int getFieldNetworkPortHTTPS=0;
        try {
            getFieldNetworkPortHTTPS=Integer.parseInt(FieldNetworkPortHTTPS);
        }catch(NumberFormatException |InputMismatchException e2) {
            JOptionPane.showMessageDialog(null, "Https port is null or transformation Exception");
            NetDemo.jTextFieldNetworkPortHTTPS.setText(null);
            return;
        }
        
        if(getFieldNetworkPortHTTPS==0) {
            JOptionPane.showMessageDialog(null, "Https port can not use");
            NetDemo.jTextFieldNetworkPortHTTPS.setText(null);
            return;
        }
        if(getFieldNetworkPortHTTPS<0 || getFieldNetworkPortHTTPS>65535) {
            JOptionPane.showMessageDialog(null, "Https port should between 0 and 65535");
            NetDemo.jTextFieldNetworkPortHTTPS.setText(null);
            return;
        }
        
        stNatState.astUpnpPort[1].dwPort = getFieldNetworkPortHTTPS;
        if(NetDemo.jComboBoxNetworkPortHTTPS.getSelectedIndex() == 1) {
            stNatState.astUpnpPort[1].bEnbale = 1;
        }else {
            stNatState.astUpnpPort[1].bEnbale = 0;
            }
        stNatState.astUpnpPort[2].eType = NETDEV_PROTOCOL_TYPE_E.NETDEV_PROTOCOL_TYPE_RTSP;
        
        String  FieldNetworkPortRTSP= NetDemo.jTextFieldNetworkPortRTSP.getText();
        if(FieldNetworkPortRTSP==null||FieldNetworkPortRTSP.equals("")) {
            JOptionPane.showMessageDialog(null, "Please input rtspport");
            return;
        }
        
        int getFieldNetworkPortRTSP=0;
        try {
            getFieldNetworkPortRTSP=Integer.parseInt(FieldNetworkPortRTSP);
        }catch(NumberFormatException |InputMismatchException e2) {
            JOptionPane.showMessageDialog(null, "RTSP port is null or transformation Exception");
            NetDemo.jTextFieldNetworkPortRTSP.setText(null);
            return;
        }
        
        
        if(getFieldNetworkPortRTSP==0) {
            JOptionPane.showMessageDialog(null, "RTSP port can not use");
            NetDemo.jTextFieldNetworkPortRTSP.setText(null);
            return;
        }
        if(getFieldNetworkPortRTSP<0 ||getFieldNetworkPortRTSP>65535) {
            JOptionPane.showMessageDialog(null, "RTSP port is more than range");
            NetDemo.jTextFieldNetworkPortRTSP.setText(null);
            return;
        }

        stNatState.astUpnpPort[2].dwPort = getFieldNetworkPortRTSP;
        if(NetDemo.jComboBoxNetworkPortRTSP.getSelectedIndex() == 1) {
            stNatState.astUpnpPort[2].bEnbale = 1;
            }
        else {
            stNatState.astUpnpPort[2].bEnbale = 0;
            }
        stNatState.write();

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetUpnpNatState(NetDemo.lpUserID, stNatState);
        if(bRet != true)
        {
            if(NetDemo.netdevsdk.NETDEV_GetLastError()==-1) {
                JOptionPane.showMessageDialog(null, "Set success");
            }else {
                System.out.printf("NETDEV_SetUpnpNatState failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            } 
        }else {
            JOptionPane.showMessageDialog(null, "Set success");
        }
    
    }
}
