package main.java.com.netdevsdk.demo.config.network;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_NETWORK_PORTS_INFO_S;

/**
 * 
 * @introduction Port configure information
 * @description Support IPC/NVR/VMS
 */
public class Port {

    /**
     * 
     * @introduction Get port information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getPort() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_NETWORK_PORTS_INFO_S ports=new NETDEV_NETWORK_PORTS_INFO_S();
		IntByReference dwBytesReturned=new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORK_PORTS, ports.getPointer(), ports.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	ports.read();
        	NetDemo.textBasicNetWorkPortHttp.setText(String.valueOf(ports.udwHttpPort));
        	NetDemo.textBasicNetWorkPortHttps.setText(String.valueOf(ports.udwHttpsPort));
        	NetDemo.textBasicNetWorkPortRtsp.setText(String.valueOf(ports.udwRtspPort));
        }
	}
	
	/**
	 * 
	 * @introduction Set port infromation 
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setPort() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_NETWORK_PORTS_INFO_S ports=new NETDEV_NETWORK_PORTS_INFO_S();
		IntByReference dwBytesReturned=new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORK_PORTS, ports.getPointer(), ports.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	ports.read();
        	String httpString=NetDemo.textBasicNetWorkPortHttp.getText();
        	int gethttp=0;
        	if(httpString==null||httpString.equals("")) {
        		JOptionPane.showMessageDialog(null, "Please input http port");
        		return;
        	}
        	
        	
        	try {
        		gethttp=Integer.parseInt(httpString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Http port is null or transformation Exception ");
				NetDemo.textBasicNetWorkPortHttp.setText(null);
				return;
			}
        	
        	
        	if(gethttp==0) {
        		JOptionPane.showMessageDialog(null, "Http port can not be used");
        		NetDemo.textBasicNetWorkPortHttp.setText(null);
				return;
        	}
        	
        	if(gethttp<0 || gethttp>65535) {
        		JOptionPane.showMessageDialog(null, "Http port should between zero and 65535");
        		NetDemo.textBasicNetWorkPortHttp.setText(null);
				return;
        	}
        	
        	String httpsString=NetDemo.textBasicNetWorkPortHttps.getText();
        	int gethttps=0;
        	if(httpsString==null||httpsString.equals("")) {
        		JOptionPane.showMessageDialog(null, "Please input https port");
        		return;
        	}
        	try {
        		gethttps=Integer.parseInt(httpsString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Https port is null or transformation Exception");
				NetDemo.textBasicNetWorkPortHttps.setText(null);
				return;
			}
        	
        	if(gethttps<0) {
        		JOptionPane.showMessageDialog(null, "Https port can not less than zero");
        		NetDemo.textBasicNetWorkPortHttps.setText(null);
				return;
        	}
        	
        	String rtspString=NetDemo.textBasicNetWorkPortRtsp.getText();
        	int getRtsp=0;
        	if(rtspString==null||rtspString.equals("")) {
        		JOptionPane.showMessageDialog(null, "Please input rtsp port");
        		return;
        	}
        	try {
        		getRtsp=Integer.parseInt(rtspString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "RTSP port is null or transformation Exception");
				NetDemo.textBasicNetWorkPortRtsp.setText(null);
				return;
			}
        	
        	if(getRtsp<0) {
        		JOptionPane.showMessageDialog(null, "RTSP port can not less than zero");
        		NetDemo.textBasicNetWorkPortRtsp.setText(null);
				return;
        	}
        	
        	ports.udwHttpPort=gethttp;
        	ports.udwHttpsPort=gethttps;
        	ports.udwRtspPort=getRtsp;
        	ports.write();
        	boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORK_PORTS, ports.getPointer(), ports.size() );
            if(bRet2 != true)
            {
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            }
        }
	}	
}
