package main.java.com.netdevsdk.demo.config.network;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VPN_CLIENT_INFO_S;

/**
 * 
 * @introduction VPN
 * @description Support IPC/NVR/VMS
 */
public class Vpn {
	
    /**
     * 
     * @introduction Get VPN information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getVpn() {
        if(null ==NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
		NETDEV_VPN_CLIENT_INFO_S vpnInfo = new NETDEV_VPN_CLIENT_INFO_S();
		vpnInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_VPN_CFG, vpnInfo.getPointer(), vpnInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else {
            vpnInfo.read();
            NetDemo.textVpnAddress.setText(Common.byteArrayToString(vpnInfo.szAddress));
            NetDemo.textVpnPort.setText(String.valueOf(vpnInfo.udwPort));
        }
	}
	
	/**
	 * 
	 * @introduction Set VPN configure
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setVpn() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
		NETDEV_VPN_CLIENT_INFO_S vpnInfo = new NETDEV_VPN_CLIENT_INFO_S();
		vpnInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet =  NetDemo.netdevsdk.NETDEV_GetDevConfig( NetDemo.lpUserID,  NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_VPN_CFG, vpnInfo.getPointer(), vpnInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }else {
            vpnInfo.read();
            String getVpnAddress= NetDemo.textVpnAddress.getText();
            if( getVpnAddress==null||getVpnAddress.equals("")) {
            	JOptionPane.showMessageDialog(null, "VPN is null");
            	return;
            }else {
            	Common.stringToByteArray(getVpnAddress, vpnInfo.szAddress);	
            }
            String getPort= NetDemo.textVpnPort.getText();
            if(getPort==null||getPort.equals("")) {
            	JOptionPane.showMessageDialog(null, "Port is null");
            	return;
            }
            int port=0;
            	try {
            		port=Integer.parseInt(getPort);
            		
            	}catch(Exception el) {
            		JOptionPane.showMessageDialog(null, "Port is null or transformation Exception");
            		 NetDemo.textVpnPort.setText(null);
            		return;
            	}
            	
            	if(port==0) {
            		JOptionPane.showMessageDialog(null, "Zero port can not use");
            		 NetDemo.textVpnPort.setText(null);
            		return;
            	}
            	
            	if(port<0 || port>65535) {
            		JOptionPane.showMessageDialog(null, "Port should between 0 and 65535");
            		 NetDemo.textVpnPort.setText(null);
            		return;
            	}
            	vpnInfo.udwEnabled=1;
            	vpnInfo.udwInterface=0;
            	vpnInfo.udwPort=port;
            	vpnInfo.write();
            
            boolean bRet2 =  NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID,  NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_VPN_CFG, vpnInfo.getPointer(), vpnInfo.size() );
            if(bRet2 != true)
            {
            	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            }
        }
	}
}
