package main.java.com.netdevsdk.demo.config.osd;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_TEXT_OVERLAY_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_OSD_CFG_S;

/**
 * 
 * @introduction OSD configure
 * @description Support IPC/NVR
 */
public class OSD {

    /**
     * 
     * @introduction Get OSD configure
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getOSD() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_VIDEO_OSD_CFG_S stOSDInfo = new NETDEV_VIDEO_OSD_CFG_S();
        stOSDInfo.write();
        IntByReference dwBytesReturned = new IntByReference();

        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_OSDCFG, stOSDInfo.getPointer(), 616, dwBytesReturned );
        if(bRet != true) {
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        stOSDInfo.read();
        NetDemo.jComboBoxConfigOSDTime1.setSelectedIndex(stOSDInfo.stTimeOSD.udwDateFormat);
        NetDemo.jComboBoxConfigOSDTim2.setSelectedIndex(stOSDInfo.stTimeOSD.udwTimeFormat);
        NetDemo.textFieldConfigOSDTimeX.setText(String.valueOf(stOSDInfo.stTimeOSD.stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDTimeY.setText(String.valueOf(stOSDInfo.stTimeOSD.stAreaScope.dwLocateY));
        System.out.println(stOSDInfo.stTimeOSD.bEnableFlag);
        if(stOSDInfo.stTimeOSD.bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDTime.setSelected(true);
        }

        NetDemo.textFieldConfigOSDName.setText(Common.byteArrayToString(stOSDInfo.stNameOSD.szOSDText));
        NetDemo.textFieldConfigOSDNameX.setText(String.valueOf(stOSDInfo.stNameOSD.stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDNameY.setText(String.valueOf(stOSDInfo.stNameOSD.stAreaScope.dwLocateY));
        if(stOSDInfo.stNameOSD.bEnableFlag == 1){
            NetDemo.chckbxConfigOSDName.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText1.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[0].szOSDText));
        NetDemo.textFieldConfigOSDText1X.setText(String.valueOf(stOSDInfo.astTextOverlay[0].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText1Y.setText(String.valueOf(stOSDInfo.astTextOverlay[0].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[0].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText1.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText2.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[1].szOSDText));
        NetDemo.textFieldConfigOSDText2X.setText(String.valueOf(stOSDInfo.astTextOverlay[1].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText2Y.setText(String.valueOf(stOSDInfo.astTextOverlay[1].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[1].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText2.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText3.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[2].szOSDText));
        NetDemo.textFieldConfigOSDText3X.setText(String.valueOf(stOSDInfo.astTextOverlay[2].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText3Y.setText(String.valueOf(stOSDInfo.astTextOverlay[2].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[2].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText3.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText4.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[3].szOSDText));
        NetDemo.textFieldConfigOSDText4X.setText(String.valueOf(stOSDInfo.astTextOverlay[3].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText4Y.setText(String.valueOf(stOSDInfo.astTextOverlay[3].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[3].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText4.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText5.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[4].szOSDText));
        NetDemo.textFieldConfigOSDText5X.setText(String.valueOf(stOSDInfo.astTextOverlay[4].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText5Y.setText(String.valueOf(stOSDInfo.astTextOverlay[4].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[4].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText5.setSelected(true);
        }

        NetDemo.textFieldConfigOSDText6.setText(Common.byteArrayToString(stOSDInfo.astTextOverlay[5].szOSDText));
        NetDemo.textFieldConfigOSDText6X.setText(String.valueOf(stOSDInfo.astTextOverlay[5].stAreaScope.dwLocateX));
        NetDemo.textFieldConfigOSDText6Y.setText(String.valueOf(stOSDInfo.astTextOverlay[5].stAreaScope.dwLocateY));
        if(stOSDInfo.astTextOverlay[5].bEnableFlag == 1) {
            NetDemo.chckbxConfigOSDText6.setSelected(true);
        }
    }

    /**
     * 
     * @introduction Set OSD configure
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setOSD() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NETDEV_VIDEO_OSD_CFG_S stOSDInfo = new NETDEV_VIDEO_OSD_CFG_S();
        for(int i =0; i < NetDEVSDKLib.NETDEV_OSD_TEXTOVERLAY_NUM; i++) {
            stOSDInfo.astTextOverlay[i] = new NETDEV_OSD_TEXT_OVERLAY_S();
        }
        
        /* Time */
        if(NetDemo.chckbxConfigOSDTime.isSelected() == true) {
            stOSDInfo.stTimeOSD.bEnableFlag = 1;
        }
        
        String FieldConfigOSDTimeX=NetDemo.textFieldConfigOSDTimeX.getText();
        if(FieldConfigOSDTimeX==null||FieldConfigOSDTimeX.equals("")) {
            JOptionPane.showMessageDialog(null, "OSDTimeX is null");
            return;
        }
        int ConfigOSDTimeX=0;
        try {
            ConfigOSDTimeX=Integer.parseInt(FieldConfigOSDTimeX);
        }catch(Exception eee) {
            JOptionPane.showMessageDialog(null, "OSDTimeX transformation Exception");
            return;
        }
        if(ConfigOSDTimeX<0) {
            JOptionPane.showMessageDialog(null, "OSDTimeX can not less than zero");
            return;
        }
        stOSDInfo.stTimeOSD.stAreaScope.dwLocateX = ConfigOSDTimeX;
        
        String FieldConfigOSDTimeY=NetDemo.textFieldConfigOSDTimeY.getText();
        if(FieldConfigOSDTimeY==null||FieldConfigOSDTimeY.equals("")) {
            JOptionPane.showMessageDialog(null, "OSDTimeX is null");
            return;
        }
        int ConfigOSDTimeY=0;
        try {
            ConfigOSDTimeY=Integer.parseInt(FieldConfigOSDTimeY);
        }catch(Exception eee) {
            JOptionPane.showMessageDialog(null, "OSDTimeX transformation Exception");
            return;
        }
        if(ConfigOSDTimeY<0) {
            JOptionPane.showMessageDialog(null, "OSDTimeX can not less than zero");
            return;
        }
        stOSDInfo.stTimeOSD.stAreaScope.dwLocateY = ConfigOSDTimeY;
        stOSDInfo.stTimeOSD.udwDateFormat = NetDemo.jComboBoxConfigOSDTime1.getSelectedIndex();
        stOSDInfo.stTimeOSD.udwTimeFormat = NetDemo.jComboBoxConfigOSDTim2.getSelectedIndex();

        /* NAME */
        if(!NetDemo.textFieldConfigOSDName.getText().trim().equals(""))
        {
            if(NetDemo.chckbxConfigOSDName.isSelected() == true) {
                stOSDInfo.stNameOSD.bEnableFlag = 1;
            }
            
            Common.stringToByteArray(NetDemo.textFieldConfigOSDName.getText(), stOSDInfo.stNameOSD.szOSDText);
            String FieldConfigOSDNameX=NetDemo.textFieldConfigOSDNameX.getText();
            if(FieldConfigOSDNameX==null||FieldConfigOSDNameX.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDNameX is null");
                return;
            }
            
            int ConfigOSDNameX=0;
            try {
                ConfigOSDNameX=Integer.parseInt(FieldConfigOSDNameX);
            }catch(Exception e) {
                JOptionPane.showMessageDialog(null, "OSDNameX transformation Exception");
                return;
            }
            if(ConfigOSDNameX<0) {
                JOptionPane.showMessageDialog(null, "OSDNameX can not less than zero");
                return;
            }           
            stOSDInfo.stNameOSD.stAreaScope.dwLocateX = ConfigOSDNameX;

            String FieldConfigOSDNameY=NetDemo.textFieldConfigOSDNameY.getText();
            if(FieldConfigOSDNameY==null||FieldConfigOSDNameY.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDNameY is null");
                return;
            }
            
            int ConfigOSDNameY=0;
            try {
                ConfigOSDNameY=Integer.parseInt(FieldConfigOSDNameY);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDNameY transformation Exception");
                return;
            }
            if(ConfigOSDNameY<0) {
                JOptionPane.showMessageDialog(null, "OSDNameY can not less than zero");
                return;
            }
            stOSDInfo.stNameOSD.stAreaScope.dwLocateY = ConfigOSDNameY;
        }
        stOSDInfo.wTextNum = (short) NetDEVSDKLib.NETDEV_OSD_TEXTOVERLAY_NUM;

         /* Text */
        if(!NetDemo.textFieldConfigOSDText1.getText().trim().equals("")) {
            if(NetDemo.chckbxConfigOSDText1.isSelected() == true) {
                stOSDInfo.astTextOverlay[0].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText1.getText(), stOSDInfo.astTextOverlay[0].szOSDText);
            String FieldConfigOSDText1X=NetDemo.textFieldConfigOSDText1X.getText();
            if(FieldConfigOSDText1X==null||FieldConfigOSDText1X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText1X is null");
                return;
            }
            
            int ConfigOSDText1X=0;
            try {
                ConfigOSDText1X=Integer.parseInt(FieldConfigOSDText1X);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText1X transformation Exception");
                return;
            }
            if(ConfigOSDText1X<0) {
                JOptionPane.showMessageDialog(null, "OSDText1X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[0].stAreaScope.dwLocateX = ConfigOSDText1X;
            
            String FieldConfigOSDText1Y=NetDemo.textFieldConfigOSDText1Y.getText();
            if(FieldConfigOSDText1Y==null||FieldConfigOSDText1Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText1Y is null");
                return;
            }
            int ConfigOSDText1Y=0;
            try {
                ConfigOSDText1Y=Integer.parseInt(FieldConfigOSDText1Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText1Y transformation Exception");
                return;
            }
            if(ConfigOSDText1Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText1Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[0].stAreaScope.dwLocateY = ConfigOSDText1Y;
        }

        if(!NetDemo.textFieldConfigOSDText2.getText().trim().equals("")) {
            if(NetDemo.chckbxConfigOSDText2.isSelected() == true) {
                stOSDInfo.astTextOverlay[1].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText2.getText(), stOSDInfo.astTextOverlay[1].szOSDText);
            
            String FieldConfigOSDText2X=NetDemo.textFieldConfigOSDText2X.getText();
            if(FieldConfigOSDText2X==null||FieldConfigOSDText2X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText2X is null");
                return;
            }
            
            int ConfigOSDText2X=0;
            try {
                ConfigOSDText2X=Integer.parseInt(FieldConfigOSDText2X);
            }catch(Exception e) {
                JOptionPane.showMessageDialog(null, "OSDText2X transformation Exception");
                return;
            }
            if(ConfigOSDText2X<0) {
                JOptionPane.showMessageDialog(null, "OSDText2X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[1].stAreaScope.dwLocateX = ConfigOSDText2X;
            
            String FieldConfigOSDText2Y=NetDemo.textFieldConfigOSDText2Y.getText();
            if(FieldConfigOSDText2Y==null||FieldConfigOSDText2Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText2Y is null");
                return;
            }
            
            int ConfigOSDText2Y=0;
            try {
                ConfigOSDText2Y=Integer.parseInt(FieldConfigOSDText2Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText2Y transformation Exception");
                return;
            }
            if(ConfigOSDText2Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText2Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[1].stAreaScope.dwLocateY = ConfigOSDText2Y;
        }

        if(!NetDemo.textFieldConfigOSDText3.getText().trim().equals(""))
        {
            if(NetDemo.chckbxConfigOSDText3.isSelected() == true) {
                stOSDInfo.astTextOverlay[2].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText3.getText(), stOSDInfo.astTextOverlay[2].szOSDText);
            
            String FieldConfigOSDText3X=NetDemo.textFieldConfigOSDText3X.getText();
            if(FieldConfigOSDText3X==null||FieldConfigOSDText3X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText3X is null");
                return;
            }
            
            int ConfigOSDText3X=0;
            try {
                ConfigOSDText3X=Integer.parseInt(FieldConfigOSDText3X);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText3X transformation Exception");
                return;
            }
            if(ConfigOSDText3X<0) {
                JOptionPane.showMessageDialog(null, "OSDText3X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[2].stAreaScope.dwLocateX = ConfigOSDText3X;

            String FieldConfigOSDText3Y=NetDemo.textFieldConfigOSDText3Y.getText();
            if(FieldConfigOSDText3Y==null||FieldConfigOSDText3Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText3Y is null");
                return;
            }
            
            int ConfigOSDText3Y=0;
            try {
                ConfigOSDText3Y=Integer.parseInt(FieldConfigOSDText3Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText3Y transformation Exception");
                return;
            }
            if(ConfigOSDText3Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText3Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[2].stAreaScope.dwLocateY = ConfigOSDText3Y;
        }

        if(!NetDemo.textFieldConfigOSDText4.getText().trim().equals(""))
        {
            if(NetDemo.chckbxConfigOSDText4.isSelected() == true) {
                stOSDInfo.astTextOverlay[3].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText4.getText(), stOSDInfo.astTextOverlay[3].szOSDText);
            
            String FieldConfigOSDText4X=NetDemo.textFieldConfigOSDText4X.getText();
            if(FieldConfigOSDText4X==null||FieldConfigOSDText4X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText4X is null");
                return;
            }    
            int ConfigOSDText4X=0;
            try {
                ConfigOSDText4X=Integer.parseInt(FieldConfigOSDText4X);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText4X transformation Exception");
                return;
            }
            if(ConfigOSDText4X<0) {
                JOptionPane.showMessageDialog(null, "OSDText4X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[3].stAreaScope.dwLocateX = ConfigOSDText4X;
            
            String FieldConfigOSDText4Y=NetDemo.textFieldConfigOSDText4Y.getText();
            if(FieldConfigOSDText4Y==null||FieldConfigOSDText4Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText4Y is null");
                return;
            }
            
            int ConfigOSDText4Y=0;
            try {
                ConfigOSDText4Y=Integer.parseInt(FieldConfigOSDText4Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText4Y transformation Exception");
                return;
            }
            if(ConfigOSDText4Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText4Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[3].stAreaScope.dwLocateY = ConfigOSDText4Y;
        }

        if(!NetDemo.textFieldConfigOSDText5.getText().trim().equals("")) {
            if(NetDemo.chckbxConfigOSDText5.isSelected() == true) {
                stOSDInfo.astTextOverlay[4].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText5.getText(), stOSDInfo.astTextOverlay[4].szOSDText);
            String FieldConfigOSDText5X=NetDemo.textFieldConfigOSDText5X.getText();
            if(FieldConfigOSDText5X==null||FieldConfigOSDText5X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText5X is null");
                return;
            }
            
            int ConfigOSDText5X=0;
            try {
                ConfigOSDText5X=Integer.parseInt(FieldConfigOSDText5X);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText5X transformation Exception");
                return;
            }
            if(ConfigOSDText5X<0) {
                JOptionPane.showMessageDialog(null, "OSDText5X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[4].stAreaScope.dwLocateX = ConfigOSDText5X;
            
            String FieldConfigOSDText5Y=NetDemo.textFieldConfigOSDText5Y.getText();
            if(FieldConfigOSDText5Y==null||FieldConfigOSDText5Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText5Y is null");
                return;
            }
            
            int ConfigOSDText5Y=0;
            try {
                ConfigOSDText5Y=Integer.parseInt(FieldConfigOSDText5Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText5Y transformation Exception");
                return;
            }
            if(ConfigOSDText5Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText5Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[4].stAreaScope.dwLocateY = ConfigOSDText5Y;
        }

        if(!NetDemo.textFieldConfigOSDText6.getText().trim().equals("")) {
            if(NetDemo.chckbxConfigOSDText6.isSelected() == true) {
                stOSDInfo.astTextOverlay[5].bEnableFlag = 1;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigOSDText6.getText(), stOSDInfo.astTextOverlay[5].szOSDText);
            
            String FieldConfigOSDText6X=NetDemo.textFieldConfigOSDText6X.getText();
            if(FieldConfigOSDText6X==null||FieldConfigOSDText6X.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText6X is null");
                return;
            }
            
            int ConfigOSDText6X=0;
            try {
                ConfigOSDText6X=Integer.parseInt(FieldConfigOSDText6X);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText6X transformation Exception");
                return;
            }
            if(ConfigOSDText6X<0) {
                JOptionPane.showMessageDialog(null, "OSDText6X can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[5].stAreaScope.dwLocateX = ConfigOSDText6X;
            
            String FieldConfigOSDText6Y=NetDemo.textFieldConfigOSDText6Y.getText();
            if(FieldConfigOSDText6Y==null||FieldConfigOSDText6Y.equals("")) {
                JOptionPane.showMessageDialog(null, "OSDText6Y is null");
                return;
            }
            
            int ConfigOSDText6Y=0;
            try {
                ConfigOSDText6Y=Integer.parseInt(FieldConfigOSDText6Y);
            }catch(Exception eee) {
                JOptionPane.showMessageDialog(null, "OSDText6Y transformation Exception");
                return;
            }
            if(ConfigOSDText6Y<0) {
                JOptionPane.showMessageDialog(null, "OSDText6Y can not less than zero");
                return;
            }
            stOSDInfo.astTextOverlay[5].stAreaScope.dwLocateY = ConfigOSDText6Y;
        }

        stOSDInfo.write();

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_OSDCFG, stOSDInfo.getPointer(), 616);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Set success");
            System.out.println(stOSDInfo.stTimeOSD.bEnableFlag);
        }
    
    }
}
