package main.java.com.netdevsdk.demo.config.osd;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_ALIGN_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_CONTENT_STYLE_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_DATE_FORMAT_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_FONT_SIZE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_FONT_STYLE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_MIN_MARGIN_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OSD_TIME_FORMAT_E;

/**
 * 
 * @introduction OSD style
 * @description Support IPC/NVR
 */
public class OSDStyle {
    
    /**
     * 
     * @introduction Get OSD style
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getOSDStyle() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
						NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP) {
			NetDemo.comboBoxFontMargin.setEnabled(false);
			NetDemo.comboBoxFontStyle.setEnabled(false);
			NetDemo.comboBoxFontStyleAlign.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign2.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign3.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign4.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign5.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign6.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign7.setEnabled(false);
			NetDemo.jComboBoxFontStyleAlign8.setEnabled(false);
		  }else {
			  NetDemo.comboBoxFontMargin.setEnabled(true);
			  NetDemo.comboBoxFontStyle.setEnabled(true);
			  NetDemo.comboBoxFontStyleAlign.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign2.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign3.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign4.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign5.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign6.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign7.setEnabled(true);
			  NetDemo.jComboBoxFontStyleAlign8.setEnabled(true);
		  }
		
		NETDEV_OSD_CONTENT_STYLE_S list=new NETDEV_OSD_CONTENT_STYLE_S();
		list.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_OSD_CONTENT_STYLE_CFG, list.getPointer(), list.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else {
        	list.read();
        	if(list.udwFontSize==NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_LARGE) {
        		NetDemo.comboBoxFontStyleSize.setSelectedIndex(0);
        	}else if(list.udwFontSize==NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_BIG) {
        		NetDemo.comboBoxFontStyleSize.setSelectedIndex(1);
        	}else if(list.udwFontSize==NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_MEDIUM) {
        		NetDemo.comboBoxFontStyleSize.setSelectedIndex(2);
        	}else if(list.udwFontSize==NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_SMALL) {
        		NetDemo.comboBoxFontStyleSize.setSelectedIndex(3);
        	}

        	if(list.udwFontStyle==NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_BACKGROUND) {
        		NetDemo.comboBoxFontStyle.setSelectedIndex(0);
        	}else if(list.udwFontStyle==NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_STROKE) {
        		NetDemo.comboBoxFontStyle.setSelectedIndex(1);
        	}
        	else if(list.udwFontStyle==NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_HOLLOW) {
        		NetDemo.comboBoxFontStyle.setSelectedIndex(2);
        	}
        	else if(list.udwFontStyle==NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_NORMAL) {
        		NetDemo.comboBoxFontStyle.setSelectedIndex(3);
        	}
        	
        	if(list.audwFontAlignList[0]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.comboBoxFontStyleAlign.setSelectedIndex(0);
            }else if(list.audwFontAlignList[0]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.comboBoxFontStyleAlign.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[1]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign2.setSelectedIndex(0);
            }else if(list.audwFontAlignList[1]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign2.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[2]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign3.setSelectedIndex(0);
            }else if(list.audwFontAlignList[2]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign3.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[3]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign4.setSelectedIndex(0);
            }else if(list.audwFontAlignList[3]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign4.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[4]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign5.setSelectedIndex(0);
            }else if(list.audwFontAlignList[4]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign5.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[5]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign6.setSelectedIndex(0);
            }else if(list.audwFontAlignList[5]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign6.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[6]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign7.setSelectedIndex(0);
            }else if(list.audwFontAlignList[6]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign7.setSelectedIndex(1);
            }
            
            if(list.audwFontAlignList[7]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT) {
                NetDemo.jComboBoxFontStyleAlign8.setSelectedIndex(0);
            }else if(list.audwFontAlignList[7]==NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT) {
                NetDemo.jComboBoxFontStyleAlign8.setSelectedIndex(1);
            }
        		
        	if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_YYYY_MMDD) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(0);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_MMDD_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(1);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(2);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(3);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(4);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(5);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(6);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(7);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(8);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(9);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(10);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(11);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD ) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(12);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(13);
        	}else if(list.udwDateFormat==NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD ) {
        		NetDemo.comboBoxDateFormatStyle.setSelectedIndex(14);
        	}

        	if(list.udwMargin==NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_NONE) {
        		NetDemo.comboBoxFontMargin.setSelectedIndex(0);
        	}else if(list.udwMargin==NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_SINGLE) {
        		NetDemo.comboBoxFontMargin.setSelectedIndex(1);
        	}else if(list.udwMargin==NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_DOUBLE) {
        		NetDemo.comboBoxFontMargin.setSelectedIndex(2);
        	}

        	if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HHMMSS) {
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(0);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(1);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(2);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(3);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(4);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(5);
        	}else if(list.udwTimeFormat==NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT){
        		NetDemo.comboBoxTimeFormat.setSelectedIndex(6);
        	}

        }
	}
	
	/**
	 * 
	 * @introduction Set OSD style
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setOSDStyle() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		NETDEV_OSD_CONTENT_STYLE_S list=new NETDEV_OSD_CONTENT_STYLE_S();
		list.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_OSD_CONTENT_STYLE_CFG, list.getPointer(),list.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	list.read();
        	
        	int size=0;
			if(NetDemo.comboBoxFontStyleSize.getItemAt(NetDemo.comboBoxFontStyleSize.getSelectedIndex()).equals("LARGE")) {
				size=NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_LARGE;
			}else if(NetDemo.comboBoxFontStyleSize.getItemAt(NetDemo.comboBoxFontStyleSize.getSelectedIndex()).equals("BIG")) {
				size=NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_BIG;
			}else if(NetDemo.comboBoxFontStyleSize.getItemAt(NetDemo.comboBoxFontStyleSize.getSelectedIndex()).equals("MEDIUM")) {
				size=NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_MEDIUM;
			}else if(NetDemo.comboBoxFontStyleSize.getItemAt(NetDemo.comboBoxFontStyleSize.getSelectedIndex()).equals("SMALL")) {
				size=NETDEV_OSD_FONT_SIZE_E.NETDEV_OSD_FONT_SIZE_SMALL;
			}
			list.udwFontSize=size;
			if(NetDemo.comboBoxFontStyleAlign.getItemAt(NetDemo.comboBoxFontStyleAlign.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[0]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.comboBoxFontStyleAlign.getItemAt(NetDemo.comboBoxFontStyleAlign.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[0]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign2.getItemAt(NetDemo.jComboBoxFontStyleAlign2.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[1]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign2.getItemAt(NetDemo.jComboBoxFontStyleAlign2.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[1]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign3.getItemAt(NetDemo.jComboBoxFontStyleAlign3.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[2]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign3.getItemAt(NetDemo.jComboBoxFontStyleAlign3.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[2]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign4.getItemAt(NetDemo.jComboBoxFontStyleAlign4.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[3]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign4.getItemAt(NetDemo.jComboBoxFontStyleAlign4.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[3]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign5.getItemAt(NetDemo.jComboBoxFontStyleAlign5.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[4]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign5.getItemAt(NetDemo.jComboBoxFontStyleAlign5.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[4]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign6.getItemAt(NetDemo.jComboBoxFontStyleAlign6.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[5]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign6.getItemAt(NetDemo.jComboBoxFontStyleAlign6.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[5]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign7.getItemAt(NetDemo.jComboBoxFontStyleAlign7.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[6]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign7.getItemAt(NetDemo.jComboBoxFontStyleAlign7.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[6]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }
            
            if(NetDemo.jComboBoxFontStyleAlign8.getItemAt(NetDemo.jComboBoxFontStyleAlign8.getSelectedIndex()).equals("LEFT")) {
                list.audwFontAlignList[7]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_LEFT;
            }else if(NetDemo.jComboBoxFontStyleAlign8.getItemAt(NetDemo.jComboBoxFontStyleAlign8.getSelectedIndex()).equals("RIGHT")) {
                list.audwFontAlignList[7]=NETDEV_OSD_ALIGN_E.NETDEV_OSD_ALIGN_RIGHT;
            }

            
        	int udwFontStyle=0;
        	if(NetDemo.comboBoxFontStyle.getItemAt(NetDemo.comboBoxFontStyle.getSelectedIndex()).equals("BACKGROUND")) {
        		udwFontStyle=NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_BACKGROUND;
        	}else if(NetDemo.comboBoxFontStyle.getItemAt(NetDemo.comboBoxFontStyle.getSelectedIndex()).equals("STROKE")) {
        		udwFontStyle=NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_STROKE;
        	}else if(NetDemo.comboBoxFontStyle.getItemAt(NetDemo.comboBoxFontStyle.getSelectedIndex()).equals("HOLLOW")) {
        		udwFontStyle=NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_HOLLOW;
        	}else if(NetDemo.comboBoxFontStyle.getItemAt(NetDemo.comboBoxFontStyle.getSelectedIndex()).equals("NORMAL")) {
        		udwFontStyle=NETDEV_OSD_FONT_STYLE_E.NETDEV_OSD_FONT_STYLE_NORMAL;
        	}
        	list.udwFontStyle=udwFontStyle;

        	
        	int margin=0;
        	if(NetDemo.comboBoxFontMargin.getItemAt(NetDemo.comboBoxFontMargin.getSelectedIndex()).equals("NONE")) {
        		margin=NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_NONE;
        	}else if(NetDemo.comboBoxFontMargin.getItemAt(NetDemo.comboBoxFontMargin.getSelectedIndex()).equals("SINGLE")) {
        		margin=NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_SINGLE;
        	}else if(NetDemo.comboBoxFontMargin.getItemAt(NetDemo.comboBoxFontMargin.getSelectedIndex()).equals("DOUBLE")) {
        		margin=NETDEV_OSD_MIN_MARGIN_E.NETDEV_OSD_MIN_MARGIN_DOUBLE;
        	}
        	list.udwMargin=margin;

        	
        	int dateFormat=0;
        	if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("yyyy-MM-dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_YYYY_MMDD;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("MM-dd-yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_MMDD_YYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("yyyy/MM/dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("MM/dd/yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dddd yyyy MM dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dddd MM dd yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dd/MM/yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("MM/dd/yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dd MMMM, yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY ;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("MMMM dd, yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY ;
        	}
        	else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dddd, dd MMMM, yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dddd, MMMM dd, yyyy")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("yyyy/MM/dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("yyyy, MMMM dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD;
        	}else if(NetDemo.comboBoxDateFormatStyle.getItemAt(NetDemo.comboBoxDateFormatStyle.getSelectedIndex()).equals("dddd, yy, MM dd")) {
        		dateFormat=NETDEV_OSD_DATE_FORMAT_E.NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD;
        	}
        	list.udwDateFormat=dateFormat;

        	
        	int timeFormat=0;
        	if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("HH:mm:ss")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HHMMSS;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("hh:mm:ss t.t.")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("hh:mm:ss tt")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("tt hh:mm:ss")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("下午 hh:mm:ss  P.M. hh:mm:ss")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("HH:mm:ss.xxx")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX;
        	}else if(NetDemo.comboBoxTimeFormat.getItemAt(NetDemo.comboBoxTimeFormat.getSelectedIndex()).equals("hh:mm:ss.xxx tt")) {
        		timeFormat=NETDEV_OSD_TIME_FORMAT_E.NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT;
        	}
        	list.udwTimeFormat=timeFormat;
			list.write();
			boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_OSD_CONTENT_STYLE_CFG, list.getPointer(), list.size() );
            if(bRet2 != true) {
            	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set style success");
            }
        }
	}
}
