package main.java.com.netdevsdk.demo.config.server;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DATA_SERVER_INFO;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DATA_SERVER_LIST;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SERVER_USER_INFO_S;

public class SmartServer {

    /**
     * 
     * @introduction Get the smart server information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getSmartServer() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NetDemo.SmartServertableModel.setRowCount(0);
         if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
             
            IntByReference dwBytesReturned = new IntByReference();
            NetDemo.serverList = new NETDEV_DATA_SERVER_LIST();
            boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_INTELLIGENT_SERVER_INFO, NetDemo.serverList.getPointer(),5476,dwBytesReturned);
            if(bRet != true) {
                System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                NetDemo.serverList.read();
                //清空tableModel内容
                NetDemo.SmartServertableModel.setRowCount(0);
                for(int i = 0; i <  NetDemo.serverList.udwNum; i++){
                    Vector<Object> vtData = new Vector<>();
                    vtData.add(NetDemo.serverList.astDataServerList[i].udwIndex);
                    if(NetDemo.serverList.astDataServerList[i].bEnable == 1){
                        vtData.add(true);
                    }else{
                        vtData.add(false);
                    }
                    
                    vtData.add(NetDemo.serverList.astDataServerList[i].udwProtocol);
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szCameraID));
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szTollgateID));
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szServerAddr));
                    vtData.add(NetDemo.serverList.astDataServerList[i].udwServerPort);
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szDrivewayID));
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szDirectionID));
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szDeviceID));
                    vtData.add(Common.byteArrayToString(NetDemo.serverList.astDataServerList[i].szAreaId));
                    NetDemo.SmartServertableModel.insertRow(i, vtData);
                    }
                NetDemo.SmartServerTable.setModel(NetDemo.SmartServertableModel);
                }
            }else{
             JOptionPane.showMessageDialog(null, "Only Support IPC.");
             return; 
                }
         }

    /**
     * 
     * @introduction Set the smart server information
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setSmartServer() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
            NETDEV_DATA_SERVER_LIST serverListData = new NETDEV_DATA_SERVER_LIST(); 
            for(int i =0; i< NetDemo.SmartServertableModel.getRowCount(); i++) {
                serverListData.astDataServerList[i] = new NETDEV_DATA_SERVER_INFO();   
                String getValue=NetDemo.SmartServertableModel.getValueAt(i, 0).toString();
                if(getValue==null||getValue.equals("")) {
                    JOptionPane.showMessageDialog(null, "Index is null");
                    return;
                    }
                    
                int index=0;
                try {
                    index=Integer.valueOf(NetDemo.SmartServertableModel.getValueAt(i, 0).toString());
                    }catch(Exception m) {
                        return;
                        }
                serverListData.astDataServerList[i].udwIndex = index;
                
                if(new Boolean(NetDemo.SmartServertableModel.getValueAt(i, 1).toString()) == true){
                    serverListData.astDataServerList[i].bEnable = 1;
                }else{
                    serverListData.astDataServerList[i].bEnable = 0;
                }
                
                String getProtol=NetDemo.SmartServertableModel.getValueAt(i, 2).toString();
                if(getProtol==null||getProtol.equals("")) {
                    JOptionPane.showMessageDialog(null, "Protol is null");
                    return;
                }
                int protrol=1;
                try {
                    protrol=Integer.valueOf(NetDemo.SmartServertableModel.getValueAt(i, 2).toString());
                }catch(Exception m) {
                    return;
                }
            
                serverListData.astDataServerList[i].udwProtocol = protrol;
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 3).toString(),serverListData.astDataServerList[i].szCameraID);
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 4).toString(),serverListData.astDataServerList[i].szTollgateID);
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 5).toString(),serverListData.astDataServerList[i].szServerAddr);
                
                String getPort=NetDemo.SmartServertableModel.getValueAt(i, 6).toString();
                if(getPort==null||getPort.equals("")) {
                    JOptionPane.showMessageDialog(null, "Port is null");
                    return;
                }
                
                int port=0;
                try {
                    port=Integer.valueOf(NetDemo.SmartServertableModel.getValueAt(i, 6).toString());
                }catch(Exception m2) {
                    return;
                }  
                serverListData.astDataServerList[i].udwServerPort = port;
                
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 7).toString(),serverListData.astDataServerList[i].szDrivewayID);
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 8).toString(),serverListData.astDataServerList[i].szDirectionID);
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 9).toString(),serverListData.astDataServerList[i].szDeviceID);
                Common.stringToByteArray(NetDemo.SmartServertableModel.getValueAt(i, 10).toString(),serverListData.astDataServerList[i].szAreaId);
                try {
                    if(null != NetDemo.serverList.astDataServerList[i]){
                        serverListData.astDataServerList[i].stServerUserInfo = NetDemo.serverList.astDataServerList[i].stServerUserInfo;
                    }else{
                        serverListData.astDataServerList[i].stServerUserInfo = new NETDEV_SERVER_USER_INFO_S();
                    }
                }catch(Exception m3) {
                    
                }
                serverListData.astDataServerList[i].write();
                }
            serverListData.udwNum = NetDemo.SmartServertableModel.getRowCount();
            serverListData.write();
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_INTELLIGENT_SERVER_INFO, serverListData.getPointer(), 5476);
            if(bRet != true) {
                System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
                }else{
                    JOptionPane.showMessageDialog(null, "Set success!");
                    NetDemo.jButtonGetSmartServer.doClick();
                    }
            }else{
                JOptionPane.showMessageDialog(null, "Only Support IPC.");
                return; 
                }
        }
    }
