package main.java.com.netdevsdk.demo.config.temper;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TAMPER_ALARM_INFO_S;

/**
 * 
 * @introduction Temper alarm
 * @description Support IPC/NVR
 */
public class TemperAlarm {
    
    /**
     * 
     * @introduction Get temper alarm sensitivity
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getTemperSensitivity() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NetDemo.textFieldConfigTemperEquipmentSensitivity.setText(null);
		NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo = new NETDEV_TAMPER_ALARM_INFO_S();
		stTamperAlarmInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_TAMPERALARM, stTamperAlarmInfo.getPointer(), stTamperAlarmInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	 stTamperAlarmInfo.read();
        	 NetDemo.textFieldConfigTemperEquipmentSensitivity.setText(String.valueOf(stTamperAlarmInfo.dwSensitivity));
        }
	}
	
	/**
	 * 
	 * @introduction Set temper alarm sensitivity
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setTemperSensitivity() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo = new NETDEV_TAMPER_ALARM_INFO_S();
		String FieldConfigTemperEquipmentSensitivity=NetDemo.textFieldConfigTemperEquipmentSensitivity.getText();
        if(FieldConfigTemperEquipmentSensitivity==null||FieldConfigTemperEquipmentSensitivity.equals("")) {
        	JOptionPane.showMessageDialog(null, "Sensitivity is null");
        	return;
        } 
        int TemperEquipmentSensitivity=1;
        try {
        	TemperEquipmentSensitivity=Integer.parseInt(FieldConfigTemperEquipmentSensitivity);
        }catch(Exception o) {
        	JOptionPane.showMessageDialog(null, "Sensitivity transformation Exception");
        	NetDemo.textFieldConfigTemperEquipmentSensitivity.setText(null);
        	return;
        }
        
        if(TemperEquipmentSensitivity<1 || TemperEquipmentSensitivity>100) {
        	JOptionPane.showMessageDialog(null, "Sensitivity should between 1 and 100");
        	NetDemo.textFieldConfigTemperEquipmentSensitivity.setText(null);
        	return;
        }
        
		stTamperAlarmInfo.dwSensitivity = TemperEquipmentSensitivity;
		stTamperAlarmInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_TAMPERALARM, stTamperAlarmInfo.getPointer(), stTamperAlarmInfo.size());
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	 JOptionPane.showMessageDialog(null, "Set success.");
        }
	}
}
