package main.java.com.netdevsdk.demo.config.video;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FOCUS_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FOCUS_MODE_E;

/**
 * 
 * @introduction Focus mode
 * @description 
 */
public class FocusMode {
    
    /**
     * 
     * @introduction Get focus configure
     * @description Support IPC/NVR/VMS
     *
     */
    public static void getFocusMode() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }      
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_FOCUS_INFO_S focusMode = new NETDEV_FOCUS_INFO_S();
        focusMode.write();
        IntByReference dwBytesReturned = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_FOCUSINFO, focusMode.getPointer(), focusMode.size(), dwBytesReturned );
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            focusMode.read();
            if(focusMode.enFocusMode==1) {
                NetDemo.jComboBoxFocusModeConfig.setSelectedIndex(0); 
            }else if(focusMode.enFocusMode==2){
                NetDemo.jComboBoxFocusModeConfig.setSelectedIndex(1);
            }
        }   
    }

    /**
     * 
     * @introduction Set focus configure
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setFocusMode() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if( NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NETDEV_FOCUS_INFO_S focusMode = new NETDEV_FOCUS_INFO_S();
            int focusM=0;
            if(NetDemo.jComboBoxFocusModeConfig.getSelectedIndex()==0) {
                focusM=NETDEV_FOCUS_MODE_E.NETDEV_FOCUS_AUTO;
            }
            else if(NetDemo.jComboBoxFocusModeConfig.getSelectedIndex()==1){
                focusM=NETDEV_FOCUS_MODE_E.NETDEV_FOCUS_MANUAL;
            }
            focusMode.enFocusMode=focusM;
            focusMode.write();
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_FOCUSINFO, focusMode.getPointer(), focusMode.size() );
            if(bRet != true) {
                JOptionPane.showMessageDialog(null, "Set fail,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Set success");
                }
            }
    }
