package main.java.com.netdevsdk.demo.config.video;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BIT_RATE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LIVE_STREAM_INDEX_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MAIN_STREAM_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_ENCODE_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_CODE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_STREAM_INFO_LIST_S;

/**
 * 
 * @introduction Device stream information
 * @description Support IPC/NVR
 */
public class Stream {

    /**
     * 
     * @introduction Get stream information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getStreamInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
			}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
			}
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS){
			JOptionPane.showMessageDialog(null, "Not support vms");
			return;
			}
		
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC|| 
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE) {
		    NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
			stStreamInfoList.udwNum = 16;
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex())==null) {
				return;
				}
			stStreamInfoList.write();
			IntByReference dwBytesReturned = new IntByReference();
			boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
	        if(bRet != true) {
	        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	        	 return;
	        }else {
	            stStreamInfoList.read();
				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
					if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
					{
					    NetDemo.chckbxBViedeoenable.setSelected(stStreamInfoList.astVideoStreamInfoList[i].bEnabled != 0);
					    
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
						}
						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
						}
						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
						}
						
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
						}
						
						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
						
						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);  
						
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
							NetDemo.jComboBoxUcode.setSelectedIndex(0);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
							NetDemo.jComboBoxUcode.setSelectedIndex(1);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
							NetDemo.jComboBoxUcode.setSelectedIndex(2);
						}
						
						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
					}	
				}
	        }
		}
		else {
			NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
			stStreamInfoList.udwNum = 16;
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex())==null) {
				return;
				}
			stStreamInfoList.write();
			IntByReference dwBytesReturned = new IntByReference();
			boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
	        if(bRet != true) {
	        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }else {
	            stStreamInfoList.read();
	            for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
	            	if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()==0) { 
	            		 if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
							{
			            		 if(NetDemo.jComboBoxMainStreamType.getSelectedIndex()==stStreamInfoList.astVideoStreamInfoList[i].udwMainStreamType) {
			            			 if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
			 							NetDemo.chckbxBViedeoenable.setSelected(false);
			 						}else {
			 							NetDemo.chckbxBViedeoenable.setSelected(true);
			 						}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
			 						}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
			 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
			 						}
			 						
			 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
			 						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
			 						
			 						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
			 						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
										NetDemo.jComboBoxUcode.setSelectedIndex(0);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
										NetDemo.jComboBoxUcode.setSelectedIndex(1);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
										NetDemo.jComboBoxUcode.setSelectedIndex(2);
									}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
			 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
			 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
			 						}else {
			 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
			 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
			 						}
			 						
			 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
			 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
			 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
			 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
			 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
			 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
			 						}
			            	}
	            	}else {
	            		if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
						{
		            			if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
		 							NetDemo.chckbxBViedeoenable.setSelected(false);
		 						}else {
		 							NetDemo.chckbxBViedeoenable.setSelected(true);
		 						}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
		 						}
		 						
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
		 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
		 						}
		 						
		 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
		 						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
		 						
		 						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
		 						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);

		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
									NetDemo.jComboBoxUcode.setSelectedIndex(0);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
									NetDemo.jComboBoxUcode.setSelectedIndex(1);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
									NetDemo.jComboBoxUcode.setSelectedIndex(2);
								}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
		 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
		 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
		 						}else {
		 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
		 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
		 						}
		 						
		 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
		 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
		 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
		 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
		 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
		 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));		
		 						}
	            		}
	            	}
	            }
	        } 
		}
	
	/**
	 * 
	 * @introduction Change stream type combox
	 * @description
	 *
	 */
	public static void comboxMainStreamType() {
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC|| 
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE) {
		    return;
		    }else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
		        return;
		        }
		    else {
			NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
			stStreamInfoList.udwNum = 16;
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex())==null) {
				return;
			}
			stStreamInfoList.write();
			IntByReference dwBytesReturned = new IntByReference();
			boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
	        if(bRet != true) {
	        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }else {
	            stStreamInfoList.read();
	            for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
	            	if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()==0) {
	            		 if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
							{
			            		 if(NetDemo.jComboBoxMainStreamType.getSelectedIndex()==stStreamInfoList.astVideoStreamInfoList[i].udwMainStreamType) {
			            			 if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
			 							NetDemo.chckbxBViedeoenable.setSelected(false);
			 						}else {
			 							NetDemo.chckbxBViedeoenable.setSelected(true);
			 						}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
			 						}
			 						
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
			 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
			 						}
			 						
			 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
			 						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
			 						 
			 						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
			 						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
									
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
										NetDemo.jComboBoxUcode.setSelectedIndex(0);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
										NetDemo.jComboBoxUcode.setSelectedIndex(1);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
										NetDemo.jComboBoxUcode.setSelectedIndex(2);
									}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
			 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
			 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
			 						}else {
			 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
			 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
			 						}
			 						
			 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
			 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
			 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
			 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
			 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
			 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
			            		 }  		
							}
	            		 }else {
	            		     if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID) {
		            			 if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
		 							NetDemo.chckbxBViedeoenable.setSelected(false);
		 							}else {
		 							    NetDemo.chckbxBViedeoenable.setSelected(true);
		 							    }
		            			 
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
		 						}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
		 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
		 						}
		 						
		 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
		 						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
		 						
		 						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
		 						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
								
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
									NetDemo.jComboBoxUcode.setSelectedIndex(0);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
									NetDemo.jComboBoxUcode.setSelectedIndex(1);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
									NetDemo.jComboBoxUcode.setSelectedIndex(2);
								}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
		 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
		 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
		 						}else {
		 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
		 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
		 						}
		 						
		 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
		 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
		 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
		 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
		 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
		 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
						}
	            	}  
	            }
	        }
		}
	}
	
	/**
     * 
     * @introduction Change stream combox
     * @description Inclding MAIN/AUX/THIRD
     *
     */
	public static void comboxStream() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			}

        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
            }
        
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
			JOptionPane.showMessageDialog(null, "Not support vms");
				return;
		}
	
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC|| 
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE) {
			
			NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
			stStreamInfoList.udwNum = 16;
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex())==null) {
				return;
			}
			
			stStreamInfoList.write();
			IntByReference dwBytesReturned = new IntByReference();
			boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
	        if(bRet != true) {
	        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }else {
	            stStreamInfoList.read();
				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
					if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
					{
						if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
							NetDemo.chckbxBViedeoenable.setSelected(false);
						}else {
							NetDemo.chckbxBViedeoenable.setSelected(true);
						}
						
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
						}
						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
						}
						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
						}
						
						
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
						}
						
						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
						NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
						
						int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
						NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
						
						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
							NetDemo.jComboBoxUcode.setSelectedIndex(0);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
							NetDemo.jComboBoxUcode.setSelectedIndex(1);
						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
							NetDemo.jComboBoxUcode.setSelectedIndex(2);
						}
						
						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
					}	
				}
	        }
		}
		else {
			
			NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
			stStreamInfoList.udwNum = 16;
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex())==null) {
				return;
			}
			
			stStreamInfoList.write();
			IntByReference dwBytesReturned = new IntByReference();
			boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
	        if(bRet != true) {
	        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }else {
	            stStreamInfoList.read();
	            for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
	            	if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()==0) {
	            		 if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
							{
			            		 if(NetDemo.jComboBoxMainStreamType.getSelectedIndex()==stStreamInfoList.astVideoStreamInfoList[i].udwMainStreamType) {
			            			 if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
			 							NetDemo.chckbxBViedeoenable.setSelected(false);
			 						}else {
			 							NetDemo.chckbxBViedeoenable.setSelected(true);
			 						}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
			 						}
			 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
			 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
			 						}
			 						
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
			 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
			 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
			 						}
			 						
			 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
			                        NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
			                        
			                        int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
			                        NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
									
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
										NetDemo.jComboBoxUcode.setSelectedIndex(0);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
										NetDemo.jComboBoxUcode.setSelectedIndex(1);
									}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
										NetDemo.jComboBoxUcode.setSelectedIndex(2);
									}
			 						
			 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
			 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
			 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
			 						}else {
			 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
			 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
			 						}
			 						
			 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
			 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
			 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
			 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
			 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
			 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));
			            		 } 		
							}
	            	}else {
	            		if(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex() == stStreamInfoList.astVideoStreamInfoList[i].udwStreamID)
						{
		            			 if(stStreamInfoList.astVideoStreamInfoList[i].bEnabled==0) {
		 							NetDemo.chckbxBViedeoenable.setSelected(false);
		 						}else {
		 							NetDemo.chckbxBViedeoenable.setSelected(true);
		 						}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat == NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat ==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
		 						}
		 						else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat==NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265) {
		 							NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(2);
		 						}
		 						
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
		 						}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType==NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR) {
		 							NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(1);
		 						}
		 						
		 						int udwImageQuality = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality;
		                        NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(udwImageQuality-1);
		                        
		                        int udwSmoothLevel = stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel;
		                        NetDemo.jComboBoxSmoothLevel.setSelectedIndex(udwSmoothLevel-1);
		 					
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF) {
									NetDemo.jComboBoxUcode.setSelectedIndex(0);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC) {
									NetDemo.jComboBoxUcode.setSelectedIndex(1);
								}else if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode==NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED) {
									NetDemo.jComboBoxUcode.setSelectedIndex(2);
								}
		 						
		 						if(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode==0) {
		 							NetDemo.jRadioButtonCloseSVC.setSelected(true);
		 							NetDemo.jRadioButtonOpenSVC.setSelected(false);
		 						}else {
		 							NetDemo.jRadioButtonOpenSVC.setSelected(true);
		 							NetDemo.jRadioButtonCloseSVC.setSelected(false);
		 						}
		 						
		 						int dwWidth=stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth;
		 						NetDemo.textFieldConfigVideoStreamFrameRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate));
		 						NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(String.valueOf(dwWidth));
		 						NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight));
		 						NetDemo.textFieldConfigVideoStreamBitRate.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate));
		 						NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(String.valueOf(stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval));  		
						}	
	            	}	   
	            }
	        }	
		}
	}
	
	/**
	 * 
	 * @introduction Set stream information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setStream() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
			JOptionPane.showMessageDialog(null, "Not support vms");
				return;
		}

		NETDEV_VIDEO_STREAM_INFO_LIST_S stStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_LIST_S();
		stStreamInfoList.udwNum = 16;
		stStreamInfoList.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stStreamInfoList.read();
        	if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC|| 
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE||
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE) {
        		if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("MAIN")) {
        			if(NetDemo.chckbxBViedeoenable.isSelected()==false) {
    					JOptionPane.showMessageDialog(null, "IPC can not close MAIN Stream");
    					return;
    				}
        		}
        	if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("AUX")) {
        		for(int s=0;s<stStreamInfoList.udwNum;s++) {
            		if(stStreamInfoList.astVideoStreamInfoList[s].udwStreamID==2) {
            			if(stStreamInfoList.astVideoStreamInfoList[s].bEnabled==1) {
            				if(NetDemo.chckbxBViedeoenable.isSelected()==false) {
            					JOptionPane.showMessageDialog(null, "if you want to close AUX Stream,please first close THIRD Stream");
            					return;
            				}
            			}
            		}
            	}
        	}
        	if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("THIRD")) {
        		for(int s=0;s<stStreamInfoList.udwNum;s++) {
            		if(stStreamInfoList.astVideoStreamInfoList[s].udwStreamID==1) {
            			if(stStreamInfoList.astVideoStreamInfoList[s].bEnabled==0) {
            				if(NetDemo.chckbxBViedeoenable.isSelected()==true) {
            					JOptionPane.showMessageDialog(null, "if you want to open THIRD Stream,please first open AUX Stream");
            					return;
            				}
            			}
            		}
            	}
        	}	
        }
        	
        	if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
        	        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
          			NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP ) {
        	    
        		  if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("MAIN")||
        				  (NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("AUX"))||
        				  (NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("THIRD"))) {
          			if(NetDemo.chckbxBViedeoenable.isSelected()==false) {
      					JOptionPane.showMessageDialog(null, "NVR can not close Stream");
      					return;
      					}
          			}
        		  }
        	
			String dwWidthSting=NetDemo.textFieldConfigVideoStreamResolutionWidth.getText();
            String udwHeightString=NetDemo.textFieldConfigVideoStreamResolutionHigth.getText();
            String udwBitrateString=NetDemo.textFieldConfigVideoStreamBitRate.getText();
            String udwIFrameIntervalString =NetDemo.textFieldConfigVideoStreamIFremeInterval.getText();
            String udwFrameRateString= NetDemo.textFieldConfigVideoStreamFrameRate.getText();

            int dwWidth=0;
			if(dwWidthSting==null||dwWidthSting.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input Width parameter");
				return;
			}
			try {
				dwWidth=Integer.parseInt(dwWidthSting);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Width is null or transformation Exception");
				NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(null);
				return;
			}
			
			if(dwWidth<0) {
				JOptionPane.showMessageDialog(null, "Width can not less than zero");
				NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(null);
				return;
			}
			
			int udwHeight=0;
			if(udwHeightString==null||udwHeightString.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input Height parameter");
				return;
			}
			try {
				udwHeight=Integer.parseInt(udwHeightString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Height is null or transformation Exception");
				NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(null);
				return;
			}
			
			if(udwHeight<0) {
				JOptionPane.showMessageDialog(null, "Height can not less than zero");
				NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(null);
				return;
			}

			int udwBitrate=0;
			if(udwBitrateString==null||udwBitrateString.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input udwBitrate parameter");
				return;
			}
			try {
				udwBitrate=Integer.parseInt(udwBitrateString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "udwBitrate is null or transformation Exception");
				NetDemo.textFieldConfigVideoStreamBitRate.setText(null);
				return;
			}
			if(udwBitrate<0) {
				JOptionPane.showMessageDialog(null, "udwBitrate can not less than zero");
				NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(null);
				return;
			}
			
		
			int udwIFrameInterval=0;
			if(udwIFrameIntervalString==null||udwIFrameIntervalString.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input IFrameInterval parameter");
				return;
			}
			try {
				udwIFrameInterval=Integer.parseInt(udwIFrameIntervalString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "IFrameInterval is null or transformation Exception");
				NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(null);
				return;
			}
			if(udwIFrameInterval<0) {
				JOptionPane.showMessageDialog(null, "IFrameInterval can not less than zero");
				NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(null);
				return;
			}
			
			int udwFrameRate=0;
			if(udwFrameRateString==null||udwFrameRateString.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input FrameRate parameter");
				return;
			}
			try {
				udwFrameRate=Integer.parseInt(udwFrameRateString);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "FrameRate is null or transformation Exception");
				NetDemo.textFieldConfigVideoStreamFrameRate.setText(null);
				return;
			}
			
			if(udwFrameRate<0) {
				JOptionPane.showMessageDialog(null, "FrameRate can not less than zero");
				NetDemo.textFieldConfigVideoStreamBitRate.setText(null);
				return;
			}
			
			int ucode=0;
			if(NetDemo.jComboBoxUcode.getItemAt(NetDemo.jComboBoxUcode.getSelectedIndex()).equals("Off")) {
				ucode=NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_OFF;
			}else if(NetDemo.jComboBoxUcode.getItemAt(NetDemo.jComboBoxUcode.getSelectedIndex()).equals("Basic")) {
				ucode=NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_BASIC;
			}else if(NetDemo.jComboBoxUcode.getItemAt(NetDemo.jComboBoxUcode.getSelectedIndex()).equals("Smart")) {
				ucode=NETDEV_SMART_ENCODE_MODE_E.NETDEV_SMART_ENCODE_MODE_ADVANCED;
			}
			
			int svc=0;
			if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC|| 
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE||
					NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE) {
				
				if((NetDemo.jRadioButtonCloseSVC.isSelected()==false)&&(NetDemo.jRadioButtonOpenSVC.isSelected()==false)) {
					JOptionPane.showMessageDialog(null, "IPC Support SVC,Please Set SVC");
					return;
				}
				
				if(NetDemo.jRadioButtonCloseSVC.isSelected()) {
					svc=0;
				}else if(NetDemo.jRadioButtonOpenSVC.isSelected()) {
					svc=1;
				}
			}else {
				if(NetDemo.jRadioButtonCloseSVC.isSelected()) {
					svc=0;
				}else if(NetDemo.jRadioButtonOpenSVC.isSelected()) {
					svc=1;
				}
			}
			
			int StreamID=0;
			stStreamInfoList.udwNum = 1;
            /* 设置图像质量，L1-L9 */
			int udwImageQuality=0;
			switch (NetDemo.comboBoxConfigVideoStreamQuality.getSelectedIndex()) {
            case 0:
                udwImageQuality=1;
                break;
            case 1:
                udwImageQuality=2;
                break;
            case 2:
                udwImageQuality=3;
                break;
            case 3:
                udwImageQuality=4;
                break;
            case 4:
                udwImageQuality=5;
                break;
            case 5:
                udwImageQuality=6;
                break;
            case 6:
                udwImageQuality=7;
                break;
            case 7:
                udwImageQuality=8;
                break;
            case 8:
                udwImageQuality=9;
                break;
            default:
                break;
            }
			
			int udwBitrateType=0;
			if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
				udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
			}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
				udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
			}
			
			int EncodeFormat=0;
			if(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getItemAt(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getSelectedIndex()).equals("MJPEG")) {
				EncodeFormat=NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_MJPEG;
			}else if(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getItemAt(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getSelectedIndex()).equals("H.264")){
				EncodeFormat=NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H264;
			}else if(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getItemAt(NetDemo.comboBoxConfigVideoStreamEncodeFormat.getSelectedIndex()).equals("H.265")) {
				EncodeFormat=NETDEV_VIDEO_CODE_TYPE_E.NETDEV_VIDEO_CODE_H265;
			}
			
			int bEnabled=1;
			int StreamType=0;
			if(NetDemo.jComboBoxMainStreamType.getSelectedIndex()==0) {
				StreamType=NETDEV_MAIN_STREAM_TYPE_E.NETDEV_MAIN_STREAM_TYPE_TIME;
			}else if( NetDemo.jComboBoxMainStreamType.getSelectedIndex()==1){
				StreamType=NETDEV_MAIN_STREAM_TYPE_E.NETDEV_MAIN_STREAM_TYPE_EVENT;
			}

			int SmoothLevel=0;
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
        			NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
        			NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP) {
                if( NetDemo.comboBoxConfigVideoStreamEncodeFormat.getSelectedIndex()==0) {
                    JOptionPane.showMessageDialog(null, "NVR not support MJEPG");
                    NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(1);
                    return;
                    }else {
                        if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("MAIN")) {
                            StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;
                            switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                            case 0:
                                SmoothLevel=1;
                                break;
                            case 1:
                                SmoothLevel=2;
                                break;
                            case 2:
                                SmoothLevel=3;
                                break;
                            case 3:
                                SmoothLevel=4;
                                break;
                            case 4:
                                SmoothLevel=5;
                                break;
                            case 5:
                                SmoothLevel=6;
                                break;
                            case 6:
                                SmoothLevel=7;
                                break;
                            case 7:
                                SmoothLevel=8;
                                break;
                            case 8:
                                SmoothLevel=9;
                                break;
                            default:
                                break;
                            }
    				
    				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
    						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
    						stStreamInfoList.astVideoStreamInfoList[i].udwMainStreamType=StreamType;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
    				}
    			}
    			else if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("AUX")) {
    			for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
    				if(NetDemo.chckbxBViedeoenable.isSelected()) {
    					bEnabled=1;
    					try {
    						stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
    					}catch(Exception el) {
    						return;
    					}
    					switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                        case 0:
                            SmoothLevel=1;
                            break;
                        case 1:
                            SmoothLevel=2;
                            break;
                        case 2:
                            SmoothLevel=3;
                            break;
                        case 3:
                            SmoothLevel=4;
                            break;
                        case 4:
                            SmoothLevel=5;
                            break;
                        case 5:
                            SmoothLevel=6;
                            break;
                        case 6:
                            SmoothLevel=7;
                            break;
                        case 7:
                            SmoothLevel=8;
                            break;
                        case 8:
                            SmoothLevel=9;
                            break;
                        default:
                            break;
                        }
    					
    					if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
    						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
    					}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
    						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
    					}
    					StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_AUX;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    					stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;

    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
    				}
    				else {
    					bEnabled=0;
    					switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                        case 0:
                            SmoothLevel=1;
                            break;
                        case 1:
                            SmoothLevel=2;
                            break;
                        case 2:
                            SmoothLevel=3;
                            break;
                        case 3:
                            SmoothLevel=4;
                            break;
                        case 4:
                            SmoothLevel=5;
                            break;
                        case 5:
                            SmoothLevel=6;
                            break;
                        case 6:
                            SmoothLevel=7;
                            break;
                        case 7:
                            SmoothLevel=8;
                            break;
                        case 8:
                            SmoothLevel=9;
                            break;
                        default:
                            break;
                        }
    					try {
    						stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
    					}catch(Exception el) {
    						return;
    					}
    					if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
    						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
    					}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
    						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
    					}
    					StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_AUX;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    					stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;

    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
    					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
    					
    				}
    			}
    			}else if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("THIRD")) {
    				NetDemo.textFieldConfigVideoStreamFrameRate.setEnabled(true);
    				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
    					if(NetDemo.chckbxBViedeoenable.isSelected()) {
    						bEnabled=1;
    						try {
    							stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
    						}catch(Exception el) {
    							return;
    						}
    						switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                            case 0:
                                SmoothLevel=1;
                                break;
                            case 1:
                                SmoothLevel=2;
                                break;
                            case 2:
                                SmoothLevel=3;
                                break;
                            case 3:
                                SmoothLevel=4;
                                break;
                            case 4:
                                SmoothLevel=5;
                                break;
                            case 5:
                                SmoothLevel=6;
                                break;
                            case 6:
                                SmoothLevel=7;
                                break;
                            case 7:
                                SmoothLevel=8;
                                break;
                            case 8:
                                SmoothLevel=9;
                                break;
                            default:
                                break;
                            }
    						if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
    							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
    						}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
    							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
    						}
    						StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_THIRD;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
    					}
    					else {
    						bEnabled=0;
    						if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L1")) {
    							SmoothLevel=1;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L2")) {
    							SmoothLevel=2;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L3")) {
    							SmoothLevel=3;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L4")) {
    							SmoothLevel=4;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L5")) {
    							SmoothLevel=5;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L6")) {
    							SmoothLevel=6;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L7")) {
    							SmoothLevel=7;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L8")) {
    							SmoothLevel=8;
    						}else if(NetDemo.jComboBoxSmoothLevel.getItemAt(NetDemo.jComboBoxSmoothLevel.getSelectedIndex()).equals("L9")) {
    							SmoothLevel=9;
    						}
    						try {
    							stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
    						}catch(Exception el) {
    							return;
    						}
    						if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
    							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
    						}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
    							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
    						}
    						StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_THIRD;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
    						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
    					}
    				}
    			}
    			stStreamInfoList.write();
    			boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size() );
                if(bRet2 != true)
                {
                	JOptionPane.showMessageDialog(null, "set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }else {
                	JOptionPane.showMessageDialog(null, "set success");
                }
        	}
       
        }
        else {
			if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("MAIN")) {
				StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_MAIN;
				 switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                 case 0:
                     SmoothLevel=1;
                     break;
                 case 1:
                     SmoothLevel=2;
                     break;
                 case 2:
                     SmoothLevel=3;
                     break;
                 case 3:
                     SmoothLevel=4;
                     break;
                 case 4:
                     SmoothLevel=5;
                     break;
                 case 5:
                     SmoothLevel=6;
                     break;
                 case 6:
                     SmoothLevel=7;
                     break;
                 case 7:
                     SmoothLevel=8;
                     break;
                 case 8:
                     SmoothLevel=9;
                     break;
                 default:
                     break;
                 }
				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;	
				}
			}
			else if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("AUX")) {	
			for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
				if(NetDemo.chckbxBViedeoenable.isSelected()) {
					bEnabled=1;
					 switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                     case 0:
                         SmoothLevel=1;
                         break;
                     case 1:
                         SmoothLevel=2;
                         break;
                     case 2:
                         SmoothLevel=3;
                         break;
                     case 3:
                         SmoothLevel=4;
                         break;
                     case 4:
                         SmoothLevel=5;
                         break;
                     case 5:
                         SmoothLevel=6;
                         break;
                     case 6:
                         SmoothLevel=7;
                         break;
                     case 7:
                         SmoothLevel=8;
                         break;
                     case 8:
                         SmoothLevel=9;
                         break;
                     default:
                         break;
                     }
					try {
						stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
					}catch(Exception el) {
						return;
					}
				
					if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
					}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
					}
					StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_AUX;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
					stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;

					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
				}
				else {
					bEnabled=0;
					 switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                     case 0:
                         SmoothLevel=1;
                         break;
                     case 1:
                         SmoothLevel=2;
                         break;
                     case 2:
                         SmoothLevel=3;
                         break;
                     case 3:
                         SmoothLevel=4;
                         break;
                     case 4:
                         SmoothLevel=5;
                         break;
                     case 5:
                         SmoothLevel=6;
                         break;
                     case 6:
                         SmoothLevel=7;
                         break;
                     case 7:
                         SmoothLevel=8;
                         break;
                     case 8:
                         SmoothLevel=9;
                         break;
                     default:
                         break;
                     }
					try {
						stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
					}catch(Exception el) {
						return;
					}
					if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
					}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
						udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
					}
					StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_AUX;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
					stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;

					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
					stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;			
				}
			}
			}else if(NetDemo.comboBoxConfigVideoStreamIndex.getItemAt(NetDemo.comboBoxConfigVideoStreamIndex.getSelectedIndex()).equals("THIRD")) {
				NetDemo.textFieldConfigVideoStreamFrameRate.setEnabled(true);
				for(int i=0 ;i < stStreamInfoList.udwNum; i++) {
					if(NetDemo.chckbxBViedeoenable.isSelected()) {
						bEnabled=1;
						 switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                         case 0:
                             SmoothLevel=1;
                             break;
                         case 1:
                             SmoothLevel=2;
                             break;
                         case 2:
                             SmoothLevel=3;
                             break;
                         case 3:
                             SmoothLevel=4;
                             break;
                         case 4:
                             SmoothLevel=5;
                             break;
                         case 5:
                             SmoothLevel=6;
                             break;
                         case 6:
                             SmoothLevel=7;
                             break;
                         case 7:
                             SmoothLevel=8;
                             break;
                         case 8:
                             SmoothLevel=9;
                             break;
                         default:
                             break;
                         }
						try {
							stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
						}catch(Exception el) {
							return;
						}

						if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
						}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
						}
						StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_THIRD;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
					}
					else {
						bEnabled=0;
						 switch (NetDemo.jComboBoxSmoothLevel.getSelectedIndex()) {
                         case 0:
                             SmoothLevel=1;
                             break;
                         case 1:
                             SmoothLevel=2;
                             break;
                         case 2:
                             SmoothLevel=3;
                             break;
                         case 3:
                             SmoothLevel=4;
                             break;
                         case 4:
                             SmoothLevel=5;
                             break;
                         case 5:
                             SmoothLevel=6;
                             break;
                         case 6:
                             SmoothLevel=7;
                             break;
                         case 7:
                             SmoothLevel=8;
                             break;
                         case 8:
                             SmoothLevel=9;
                             break;
                         default:
                             break;
                         }
						try {
							stStreamInfoList.astVideoStreamInfoList[i].bEnabled=bEnabled;
						}catch(Exception el) {
							return;
						}
						if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Fixed Rate")) {
							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_CBR;
						}else if(NetDemo.comboBoxConfigVideoStreamRate.getItemAt(NetDemo.comboBoxConfigVideoStreamRate.getSelectedIndex()).equals("Variable Rate")) {
							udwBitrateType=NETDEV_BIT_RATE_TYPE_E.NETDEV_BIT_RATE_TYPE_VBR;
						}
						StreamID=NETDEV_LIVE_STREAM_INDEX_E.NETDEV_LIVE_STREAM_INDEX_THIRD;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
						stStreamInfoList.astVideoStreamInfoList[i].udwStreamID=StreamID;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwWidth=dwWidth;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwHeight=udwHeight;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwFrameRate=udwFrameRate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrate=udwBitrate;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwEncodeFormat=EncodeFormat;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwIFrameInterval=udwIFrameInterval;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwImageQuality=udwImageQuality;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwBitrateType=udwBitrateType;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.bEnableSVCMode=svc;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmoothLevel=SmoothLevel;
						stStreamInfoList.astVideoStreamInfoList[i].stVideoEncodeInfo.udwSmartEncodeMode=ucode;
					}
				}
			}
			stStreamInfoList.write();
			boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_STREAMCFG_EX, stStreamInfoList.getPointer(), stStreamInfoList.size() );
            if(bRet2 != true)
            {
            	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            	}
            }	
            }
        }
	}
