package main.java.com.netdevsdk.demo.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;

/**
 * 
 * @introduction discover equipment
 * @description Support IPC/NVR/VMS
 */
public class Discovery {
    /**
     * 
     * @introduction discover equipment
     * @description Calling the interface of NETDEV_SetDiscoveryCallBack
     */
        public static void discoverEquipment() {
            NetDemo.DiscoveryTableModel.setRowCount(0);
            String strBeginIP = NetDemo.jTextFieldStartIP.getText();
            String strEndIP = NetDemo.jTextFieldEndIP.getText();
            if(strBeginIP.isEmpty() && strEndIP.isEmpty()) {
                NetDemo.netdevsdk.NETDEV_SetDiscoveryCallBack(NetDemo.cbDiscoveryCallBack, null);
                NetDemo.netdevsdk.NETDEV_Discovery("0.0.0.0", "0.0.0.0");
                NetDemo.jButtonCheckSameDevice.doClick();
                }
            /* Determine IP address format */
            else if(Common.isIP(strBeginIP) && Common.isIP(strEndIP)) {
                NetDemo.netdevsdk.NETDEV_SetDiscoveryCallBack(NetDemo.cbDiscoveryCallBack, null);  
                boolean bRet = NetDemo.netdevsdk.NETDEV_Discovery(strBeginIP, strEndIP);
                if(!bRet) {
                    JOptionPane.showMessageDialog(null, "Discovery failed. Please check the entered IP address.");
                }else  {
                    NetDemo.jButtonCheckSameDevice.doClick();
                }
            }else {
                JOptionPane.showMessageDialog(null, "Please enter the correct start and end addresses, or do not enter.");
            }
        }
        
        /**
         * 
         * @introduction Check the same device
         * @description 
         */
        public static void checkSameDevice() {
            List list=new ArrayList();
            Vector deviceDetail=null;
            /* Record the parameters of the equipment */
            for(int s=0;s<NetDemo.DiscoveryTableModel.getRowCount();s++) 
            {
                deviceDetail=new Vector();
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 0));
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 1));
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 2));
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 3));
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 4));
                deviceDetail.add(NetDemo.DiscoveryTableModel.getValueAt(s, 5));
                list.add(deviceDetail);
            }
            /* Check repeat equipment */
            List getcheckList=(List) list.stream().distinct().collect(Collectors.toList());
            NetDemo.DiscoveryTableModel.setRowCount(0);
            for(int u=0;u<getcheckList.size();u++) 
            {   
                Vector send=(Vector) getcheckList.get(u);
                NetDemo.DiscoveryTableModel.insertRow(u,send);
            }
            NetDemo.DiscoveryTable.setModel(NetDemo.DiscoveryTableModel);
            
        }
}
