package main.java.com.netdevsdk.demo.liveview.live;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.Native;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RECT_S;

/**
 * 
 * @introduction DigitalZoom
 * @description Support IPC/NVR/VMS
 */
public class DigitalZoom {
	
    /**
     * 
     * @introduction Set DigitalZoom
     * @description Calling the interface of NETDEV_SetDigitalZoom to set the digitalZoom, 
     * the parameter should between 0 and 10000
     *
     */
	public static void setDigitalZoom() {
	    if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
        
		int dwLeft=0;
	    int dwTop=0;
	    int dwRight=0;
	    int dwBottom=0;	    
		try {
			dwLeft=Integer.parseInt(NetDemo.jTextFieldDigitalZoomLeft.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Left parameter is null or transformation exception");
			NetDemo.jTextFieldDigitalZoomLeft.setText(null);
			return;
		}		
		if(dwLeft<0||dwLeft>10000) {
			JOptionPane.showMessageDialog(null, "Left parameter should beteen 0~10000");
			return;
		}
		
		try {
			dwTop=Integer.parseInt(NetDemo.jTextFieldDigitalZoomTop.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Top parameter is null or transformation exception");
			return;
		}	
		if(dwTop<0||dwTop>10000) {
			JOptionPane.showMessageDialog(null, "Top parameter should beteen 0~10000");
			return;
		}
		
		try {
			dwRight=Integer.parseInt(NetDemo.jTextFieldDigitalZoomRight.getText());
		}
		catch(NumberFormatException | InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Right parameter is null or transformation exception");
			return;
		}		
		if(dwRight<0||dwRight>10000) {
			JOptionPane.showMessageDialog(null, "Right parameter should beteen 0~10000");
			return;
		}
		
		try {
			dwBottom=Integer.parseInt(NetDemo.jTextFieldDigitalZoomBottom.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Bottom parameter is null or transformation exception");
			return;
		}
		if(dwBottom<0||dwBottom>10000) {
			JOptionPane.showMessageDialog(null, "Bottom parameter should beteen 0~10000");
			return;
		}
		
		if(dwBottom<=dwTop) {
			JOptionPane.showMessageDialog(null, "Bottom must more than top");
			return;
		}
		if(dwRight<=dwLeft) {
			JOptionPane.showMessageDialog(null, "Right must more than left");
			return;
		}
		
		NETDEV_RECT_S pstRect=new NETDEV_RECT_S();
		pstRect.dwLeft=dwLeft;
		pstRect.dwTop=dwTop;
		pstRect.dwRight=dwRight;
		pstRect.dwBottom=dwBottom;
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDigitalZoom(NetDemo.lpPlayHandle,Native.getComponentPointer(NetDemo.panelPlayLabel),pstRect);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Set Digital Zoom. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetDigitalZoom failed, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Success");
        }
	}
	
	/**
	 * 
	 * @introduction Exit DigitalZoom
	 * @description Calling the interface of NETDEV_SetDigitalZoom and set the NETDEV_RECT_S null to exie digitalzoom
	 *
	 */
	public static void closeDigitalZoom() {
	    if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDigitalZoom(NetDemo.lpPlayHandle,Native.getComponentPointer(NetDemo.panelPlayLabel),null);
        if(bRet != true)
        {
        	System.out.printf("NETDEV_SetDigitalZoom failed, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
	}
}
