package main.java.com.netdevsdk.demo.liveview.live;

import java.io.File;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;

/**
 * 
 * @introduction Video Record
 * @description  Support IPC/NVR/VMS
 */
public class Record {
    
    /**
     * 
     * @introduction Start save the video to the local working directory
     * @description Calling the interface of NETDEV_SaveRealData to save the video to the local working directory
     *
     */
    public static void startRecord() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(null != NetDemo.lpPlayHandle){
            String strSeparator = File.separator;
            NetDemo.strRecordPath = System.getProperty("user.dir").replaceAll("%20"," ") + strSeparator+"Record"+strSeparator+"test" + Common.timeStamp() + "_D"+NetDemo.ChannelID;
            boolean bRet = NetDemo.netdevsdk.NETDEV_SaveRealData(NetDemo.lpPlayHandle, NetDemo.strRecordPath, 0);
            if(!bRet){
                JOptionPane.showMessageDialog(null, "Start Record failed.Please check the path.");
            }
            else{
                NetDemo.bStartRecord = true;
                NetDemo.jButtonStopRecord.setEnabled(true);
                NetDemo.jButtonStartRecord.setEnabled(false);
            }
        }else{
            JOptionPane.showMessageDialog(null, "Please start live first.");
        }
    
    }

    /**
     * 
     * @introduction  Stop saving the video to the local working directory
     * @description Calling the interface of NETDEV_StopSaveRealData to stop saving the video to the local working directory
     *
     */
    public static void stopRecord() {
        if(NetDemo.bStartRecord){
            boolean bRet = NetDemo.netdevsdk.NETDEV_StopSaveRealData(NetDemo.lpPlayHandle);
            NetDemo.bStartRecord = false;
            if(!bRet){
                JOptionPane.showMessageDialog(null, "StopRecord failed.Please check the path.");
            }
            else{
                NetDemo.jButtonStopRecord.setEnabled(false);
                NetDemo.jButtonStartRecord.setEnabled(true);
                JOptionPane.showMessageDialog(null, NetDemo.strRecordPath);
            }
        }else{
            JOptionPane.showMessageDialog(null, "Start StartRecord, please.");
        }
    
    }
}
