package main.java.com.netdevsdk.demo.maintenance;

import java.util.regex.Pattern;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_BASICINFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;

/**
 * @description  To export or import the file of configuration.
 * @introduction  Support IPC/NVR/VMS.
 */
public class Configuration {
    /**
     * @description  To export the file of configuration.
     * @introduction Calling the interface of NETDEV_GetDevConfig  NETDEV_GetConfigFile.
     */
    public static void Export() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NETDEV_DEVICE_BASICINFO_S stDeviceInfo = new NETDEV_DEVICE_BASICINFO_S();
        IntByReference dwBytesReturned = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DEVICECFG, stDeviceInfo.getPointer(), stDeviceInfo.size(), dwBytesReturned);
        if(bRet != true)
        {
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stDeviceInfo.read();
        String strFileNameString = "";
        String strCurrentpathString = "";
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
           NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
           NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
           NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS
            ){
             strFileNameString = Common.byteArrayToString(stDeviceInfo.szDevModel) + "_" + NetDemo.strIPAddr + "_" + "config.tgz";
             strCurrentpathString = NetDemo.strPicturePath +  strFileNameString;
        }
        else if((NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR)||
                (NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)||
                (NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR)){
              strFileNameString = Common.byteArrayToString(stDeviceInfo.szDevModel) + "_" + NetDemo.strIPAddr + "_" + "config.xml";
              strCurrentpathString = NetDemo.strPicturePath +  strFileNameString;  
        }
        boolean bRet2 = NetDemo.netdevsdk.NETDEV_GetConfigFile(NetDemo.lpUserID, strCurrentpathString);
        if(bRet2 != true)
        {
            System.out.printf("NETDEV_GetConfigFile failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Export success,file path"+strCurrentpathString);
        }  
    }
    /**
     * @description To import the file of configuration.
     * @introduction Calling the interface of NETDEV_SetConfigFile.
     */
    public static void Import() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetConfigFile(NetDemo.lpUserID, NetDemo.jTextFieldMaintenanceManualConfigurationImport.getText());
        if(bRet != true)
        {
            System.out.printf("NETDEV_SetConfigFile failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            JOptionPane.showMessageDialog(null, "Import file failed, please reselect file, error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            NetDemo.jTextFieldMaintenanceManualConfigurationImport.setText(null);
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Import file success");
        }  
    }
    /**
     * @description To browse the file of Configuration. 
     */
    public static void Browse() {
        JFileChooser fcFileChooser = new JFileChooser();
        fcFileChooser.setMultiSelectionEnabled(false);
        int result=fcFileChooser.showSaveDialog(null);
        if (result==JFileChooser.APPROVE_OPTION)
        {
            fcFileChooser.getSelectedFile();
            String strFilePath = fcFileChooser.getSelectedFile().getAbsolutePath();
            if(strFilePath==null||strFilePath.equals("")) 
            {
                System.out.println("No choose file");
                return;
            }
            String newpath=null;
            try {
                newpath=strFilePath.substring(strFilePath.lastIndexOf("."));
            }catch(Exception y) {
                JOptionPane.showMessageDialog(null, "File is not exist");
                return;
            }
            
            if(newpath==null||newpath.equals("")) 
            {
                System.out.println("No choose file");
                return;
            }
            String reg = "(tgz|xml)";
            Pattern p = Pattern.compile(reg);
            boolean boo = p.matcher(newpath).find();
            if(boo) 
            {
                JOptionPane.showMessageDialog(null, "Choose file ok");
                NetDemo.jTextFieldMaintenanceManualConfigurationImport.setText(strFilePath);
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Only support tgz file or xml file");
            }  
        }
    
    }
}
