package main.java.com.netdevsdk.demo.maintenance;

import javax.swing.JOptionPane;
import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MANUAL_RECORD_CFG_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RECORD_TYPE_E;

/**
 * @description To enable or disable manual recording.
 * @introduction Support NVR/VMS.
 */
public class ManualRecord {
    /**
     * @description  Enable manual recording.
     * @introduction Calling the interface of NETDEV_StartManualRecord.
     */
    public static void startRecord() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NETDEV_MANUAL_RECORD_CFG_S stManualRecordCfg = new NETDEV_MANUAL_RECORD_CFG_S();
        stManualRecordCfg.dwChannelID = NetDemo.ChannelID;
        stManualRecordCfg.enRecordType = NETDEV_RECORD_TYPE_E.NETDEV_RECORD_TYPE_MANUAL;
        boolean bRet = NetDemo.netdevsdk.NETDEV_StartManualRecord(NetDemo.lpUserID, stManualRecordCfg);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_StartManualRecord failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Set success");
        }
    
    }
    /**
     * @description Disable manual recording.
     * @introduction Calling the interface of NETDEV_StopManualRecord.
     */
    public static void stopRecord() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NETDEV_MANUAL_RECORD_CFG_S stManualRecordCfg = new NETDEV_MANUAL_RECORD_CFG_S();
        stManualRecordCfg.dwChannelID = NetDemo.ChannelID;
        stManualRecordCfg.enRecordType = NETDEV_RECORD_TYPE_E.NETDEV_RECORD_TYPE_MANUAL;
        boolean bRet = NetDemo.netdevsdk.NETDEV_StopManualRecord(NetDemo.lpUserID, stManualRecordCfg);
        if(bRet != true)
        {
            System.out.printf("NETDEV_StopManualRecord failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Stop success");
        }
    }
}
