package main.java.com.netdevsdk.demo.objectSearch;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEV_CHN_ENCODE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CHN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_CHN_CONDITION_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_LOGICTYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PIC_QUERY_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PIC_QUERY_RESULT_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OBJECT_RESULT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OBJECT_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_ATTR_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_COND_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_RELATED_DATA_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_STRUCT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEH_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_NON_MOTOR_VEH_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_STRUCT_IMAGE_INFO_S;
import java.text.SimpleDateFormat;
import java.util.Vector;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class objectsearch {

	static String DateFormat = "yyyy-MM-dd HH:mm:ss";

	public static void objectfind() {
		if(null == NetDemo.lpUserID)
		{
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		boolean bRet =  NetDemo.netdevsdk.NETDEV_StopObjectSearch(NetDemo.lpUserID, NetDemo.udwObjectSearchID);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_StopObjectSearch failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		
		NetDemo.ObjectSearchModel.setRowCount(0);
		NETDEV_DEV_CHN_ENCODE_INFO_S stEncodeInfo = new NETDEV_DEV_CHN_ENCODE_INFO_S();
		stEncodeInfo.write();
		
		IntByReference dwBytesReturned = new IntByReference();
	    bRet = NetDemo.netdevsdk.NETDEV_GetChnDetailByChnType(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CHN_TYPE_E.NETDEV_CHN_TYPE_ENCODE, stEncodeInfo.getPointer(), stEncodeInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetChnDetailByChnType failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		
        stEncodeInfo.read();
        
        int DevID = stEncodeInfo.stChnBaseInfo.dwDevID;
        
        NETDEV_QUERY_CHN_CONDITION_S stStartInfo = new NETDEV_QUERY_CHN_CONDITION_S();
		stStartInfo.dwQryInfoNum = 7;
		
		NETDEV_QUERY_INFO_S[] stQueryInfo = (NETDEV_QUERY_INFO_S[])new NETDEV_QUERY_INFO_S().toArray(7);
		
		stQueryInfo[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stQueryInfo[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_BeginTime.getText(), DateFormat)), stQueryInfo[0].szConditionData);
		
		stQueryInfo[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stQueryInfo[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_EndTime.getText(), DateFormat)), stQueryInfo[1].szConditionData);
		
		stQueryInfo[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stQueryInfo[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
		
		stQueryInfo[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_CHANNELID;
		stQueryInfo[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
		Common.stringToByteArray(Integer.toString(NetDemo.ChannelID), stQueryInfo[3].szConditionData);
		
		stQueryInfo[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARM_DEVID;
		stQueryInfo[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
		Common.stringToByteArray(Integer.toString(DevID), stQueryInfo[4].szConditionData);
		
		
		if(0 != NetDemo.comboBox.getSelectedIndex())
		{					
			stQueryInfo[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_OBJECT_TYPE;
			stQueryInfo[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
			Common.stringToByteArray(Integer.toString(NetDemo.comboBox.getSelectedIndex()), stQueryInfo[5].szConditionData);
		}
		else
		{
			stStartInfo.dwQryInfoNum = stStartInfo.dwQryInfoNum - 1;
		}
		
		
        if(0 != NetDemo.comboBox_1.getSelectedIndex())
        {
        	if(1 == NetDemo.comboBox_1.getSelectedIndex())
        	{
        		Common.stringToByteArray("1003", stQueryInfo[stStartInfo.dwQryInfoNum-1].szConditionData);             		
        	}
        	else if(2 == NetDemo.comboBox_1.getSelectedIndex())
        	{
        		Common.stringToByteArray("1004", stQueryInfo[stStartInfo.dwQryInfoNum-1].szConditionData);  
        	}
        	else if(3 == NetDemo.comboBox_1.getSelectedIndex())
        	{
        		Common.stringToByteArray("1015", stQueryInfo[stStartInfo.dwQryInfoNum-1].szConditionData);  
        	}
        	else if(4 == NetDemo.comboBox_1.getSelectedIndex())
        	{
        		Common.stringToByteArray("1016", stQueryInfo[stStartInfo.dwQryInfoNum-1].szConditionData);  
        	}
        	stQueryInfo[stStartInfo.dwQryInfoNum-1].dwQueryType = 8;
			stQueryInfo[stStartInfo.dwQryInfoNum-1].dwLogicFlag = 0;
								
        }
        else
		{
			stStartInfo.dwQryInfoNum = stStartInfo.dwQryInfoNum - 1;
		}
       
		
		stStartInfo.pstQueryInfo = new Memory(stQueryInfo[0].size() * stQueryInfo.length);
		Common.SetStructArrToPointerData(stQueryInfo, stStartInfo.pstQueryInfo);
		
		stStartInfo.write();
		
		IntByReference pudwSearchID = new IntByReference(0);
		
		
		
		bRet = NetDemo.netdevsdk.NETDEV_StartObjectSearch(NetDemo.lpUserID, stStartInfo, pudwSearchID);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_StartObjectSearch failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		else
		{
			NetDemo.udwObjectSearchID = pudwSearchID.getValue();
			IntByReference pudwPercent = new IntByReference(0);
			bRet = NetDemo.netdevsdk.NETDEV_GetObjectSearchProg(NetDemo.lpUserID, pudwSearchID.getValue(), pudwPercent);
			if(bRet != true)
            {
              	System.out.printf("NETDEV_GetObjectSearchProg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
			if(100 == pudwPercent.getValue())
			{
				NETDEV_PIC_QUERY_COND_S pstQueryCond = new NETDEV_PIC_QUERY_COND_S();
				pstQueryCond.udwOffset = 0;
				pstQueryCond.udwSearchID = pudwSearchID.getValue();
				pstQueryCond.udwLimit = 10;
				
				NetDemo.gstQueryCond.udwOffset = pstQueryCond.udwOffset;
				NetDemo.gstQueryCond.udwSearchID = pstQueryCond.udwSearchID;
				NetDemo.gstQueryCond.udwLimit = pstQueryCond.udwLimit;
				
				NETDEV_PIC_QUERY_RESULT_S pstQueryResult = new NETDEV_PIC_QUERY_RESULT_S();
				pstQueryCond.write();
				
				Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindObjectSearchList(NetDemo.lpUserID, pstQueryCond, pstQueryResult);
				if(null == lpFindHandle)
				{
					System.out.printf("NETDEV_FindObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
				}
				else
				{
					NetDemo.btnNewButton_2.setEnabled(true);
					NetDemo.btnNewButton_3.setEnabled(true);
					pstQueryResult.read();
					NetDemo.textField_Total.setText(Integer.toString(pstQueryResult.udwTotal));
					NetDemo.udwObjectSearchTotalNum = pstQueryResult.udwTotal - pstQueryResult.udwNum;
					NetDemo.textField_Remain.setText(Integer.toString(NetDemo.udwObjectSearchTotalNum));
					NetDemo.lpObjectSearchFindHandle = lpFindHandle;
					NetDemo.dwTime = 1;
					NetDemo.ObjectSearchModel.setRowCount(0);
					while(0 != pstQueryResult.udwNum)
					{
						NETDEV_OBJECT_RESULT_INFO_S pstObjectResultInfo = new NETDEV_OBJECT_RESULT_INFO_S();
						
						pstObjectResultInfo.stBigImageInfo = new NETDEV_FILE_INFO_S();
						pstObjectResultInfo.stBigImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
						pstObjectResultInfo.stBigImageInfo.pcData = new Memory(pstObjectResultInfo.stBigImageInfo.udwSize);
						
						pstObjectResultInfo.udwObjectInfoNum = 1;
						NETDEV_OBJECT_INFO_LIST_S[] pstObjectInfoList = new NETDEV_OBJECT_INFO_LIST_S[1];
						NETDEV_PERSON_ATTR_S[] pstPersonAttr = new NETDEV_PERSON_ATTR_S[1];
						for(int i = 0; i < pstObjectResultInfo.udwObjectInfoNum; ++i)
						{
							pstObjectInfoList[i] = new NETDEV_OBJECT_INFO_LIST_S();
							pstObjectInfoList[i].stSmallImageInfo = new NETDEV_FILE_INFO_S();
							pstObjectInfoList[i].stSmallImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
							pstObjectInfoList[i].stSmallImageInfo.pcData = new Memory(pstObjectInfoList[i].stSmallImageInfo.udwSize);
							pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum = 1;
							for(int j = 0; j < pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum; ++j)
							{
								pstPersonAttr[j] = new NETDEV_PERSON_ATTR_S();
							}
							pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr = new Memory(pstPersonAttr[0].size()*pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum);
							Common.SetStructArrToPointerData(pstPersonAttr, pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr);
						}
						
						pstObjectResultInfo.pstObjectInfoList = new Memory(pstObjectInfoList[0].size()*pstObjectResultInfo.udwObjectInfoNum);
						Common.SetStructArrToPointerData(pstObjectInfoList, pstObjectResultInfo.pstObjectInfoList);
						
						
						pstObjectResultInfo.write();
				        	
						bRet = NetDemo.netdevsdk.NETDEV_FindNextObjectSearchInfo(lpFindHandle, pstObjectResultInfo);
						if(bRet != true)
		                {
		                  	System.out.printf("NETDEV_FindNextObjectSearchInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
		                    break;
		                }
						else
						{
							pstQueryResult.udwNum --;
							pstObjectResultInfo.read();
							
							pstObjectInfoList = Common.pointerToStructureArray(pstObjectResultInfo.udwObjectInfoNum,pstObjectResultInfo.pstObjectInfoList, NETDEV_OBJECT_INFO_LIST_S.class);
							
							for(int i = 0; i< 1; i ++)
							{
								pstPersonAttr = Common.pointerToStructureArray(1,pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr, NETDEV_PERSON_ATTR_S.class);										
							}
																
							//System.out.printf("NETDEV_FindNextObjectSearchInfo,udwNum:%d,udwRecordID:%d, udwType:%d,udwTime:%d, szChannelName:%s,udwChannelID:%d\n",pstQueryResult.udwNum, pstObjectResultInfo.udwRecordID, pstObjectResultInfo.udwType, pstObjectResultInfo.udwTime, Common.byteArrayToString(pstObjectResultInfo.szChannelName),pstObjectResultInfo.udwChannelID);
							//System.out.printf("stBigImageInfo,Name:%s,szUrl:%s\n", Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szName), Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szUrl));
							
							Vector<String> ObjectVector = new Vector<String>();
							ObjectVector.add(Integer.toString(pstObjectResultInfo.udwRecordID));
							if(0 == pstObjectResultInfo.udwType)
							{
								ObjectVector.add("Cross line");
							}
							else if(1 == pstObjectResultInfo.udwType)
							{
								ObjectVector.add("Object inside");
							}
							else if(2 == pstObjectResultInfo.udwType)
							{
								ObjectVector.add("Enter area");
							}
							else if(3 == pstObjectResultInfo.udwType)
							{
								ObjectVector.add("Leave area");
							}
							else
							{
								ObjectVector.add("Unknow");
							}
							
							ObjectVector.add(Integer.toString( pstObjectResultInfo.udwTime));
							ObjectVector.add(Common.byteArrayToString(pstObjectResultInfo.szChannelName));
							ObjectVector.add(Integer.toString(pstObjectResultInfo.udwChannelID));
							
							NetDemo.ObjectSearchModel.addRow(ObjectVector);
							
							//大图信息
							//System.out.printf("stBigImageInfo.udwSize:%d\n",pstObjectResultInfo.stBigImageInfo.udwSize);
							String strBigImageInfo = NetDemo.strPicturePath + Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szName) +"_BigImage.jpg";
																
							System.out.printf("stBigImageInfo1.udwSize:%d, data:%s\n",pstObjectResultInfo.stBigImageInfo.udwSize, pstObjectResultInfo.stBigImageInfo.pcData);
							if(0 != pstObjectResultInfo.stBigImageInfo.udwSize)
							{										
								Common.savePicture(pstObjectResultInfo.stBigImageInfo.pcData, pstObjectResultInfo.stBigImageInfo.udwSize, strBigImageInfo);
								
							}									
							 		
							//人员属性信息
							//System.out.printf("ObjectInfo_PersonInfo,udwObjectType:%d, udwObjectID:%d,udwPersonID:%d, szPosition:%s \n",pstObjectInfoList[0].stObjectInfo.udwObjectType,pstObjectInfoList[0].udwObjectID, pstObjectInfoList[0].stObjectInfo.stPersonInfo.udwPersonID,Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stPersonInfo.szPosition));
							//System.out.printf("ObjectInfo_PersonInfo_Person,udwGender:%d, udwAgeRange:%d, udwSleevesLength:%d,udwCoatColor:%d, udwTrousersLength:%d,udwTrousersColor:%d,udwBodyToward:%d,udwShoesTubeLength:%d,udwHairLength:%d,udwBagFlag:%d\n",pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwGender, pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwAgeRange,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwSleevesLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwCoatColor,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwTrousersLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwTrousersColor,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwBodyToward,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwShoesTubeLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwHairLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwBagFlag);
						
							//非机动车信息 
							//System.out.printf("ObjectInfo_NonMotorVeh,udwID:%d, szPosition:%s,udwSmallPicAttachIndex:%d, udwLargePicAttachIndex:%d\n",pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwID, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.szPosition), pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwSmallPicAttachIndex, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwLargePicAttachIndex);
							//System.out.printf("ObjectInfo_NonMotorVeh_VehAttr,udwSpeedType:%d, udwImageDirection:%d, udwNonVehicleType:%d\n",pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwSpeedType, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwImageDirection, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwNonVehicleType);
						    //for(int i = 0; i < 1;i++ )
						    //{
						    	//System.out.printf("ObjectInfo_NonMotorVeh_Person, CoatColor:%d, TrousersColor:%d,\n", pstPersonAttr[i].udwCoatColor, pstPersonAttr[i].udwTrousersColor);
						    //}
							
							//机动车信息
							//System.out.printf("ObjectInfo_stVehInfo,udwID:%d, szPosition:%s\n",pstObjectInfoList[0].stObjectInfo.stVehInfo.udwID, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.szPosition));
							//System.out.printf("ObjectInfo_stVehInfo_VehAttr,udwType:%d, udwColor:%d, udwSpeedUnit:%d,fSpeedValue:%f,udwSpeedType:%d,szVehicleBrand:%s,udwImageDirection:%d\n",pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwType,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwColor,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwSpeedUnit,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.fSpeedValue,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwSpeedType, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.szVehicleBrand),pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwImageDirection);
							//System.out.printf("ObjectInfo_stVehInfo_PlateAttr,szPlateNo:%s, udwColor:%d, udwType:%d\n", Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.szPlateNo),pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.udwColor,pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.udwType);
						
						}
					}	
				}
				
				bRet = NetDemo.netdevsdk.NETDEV_FindCloseObjectSearchList(lpFindHandle);
				if(bRet != true)
                {
                  	System.out.printf("NETDEV_FindCloseObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
			}
							
		}
	}
	
	public static void objectfindNext() {
		NetDemo.ObjectSearchModel.setRowCount(0);
		if(0 < NetDemo.udwObjectSearchTotalNum)
		{
			
			NETDEV_PIC_QUERY_COND_S pstQueryCond = new NETDEV_PIC_QUERY_COND_S();
			pstQueryCond.udwOffset = NetDemo.dwTime * 10;
			pstQueryCond.udwSearchID = NetDemo.udwObjectSearchID;
			pstQueryCond.udwLimit = 10;
			
			NetDemo.gstQueryCond.udwOffset = pstQueryCond.udwOffset;
			NetDemo.gstQueryCond.udwSearchID = pstQueryCond.udwSearchID;
			NetDemo.gstQueryCond.udwLimit = pstQueryCond.udwLimit;
			
			NETDEV_PIC_QUERY_RESULT_S pstQueryResult = new NETDEV_PIC_QUERY_RESULT_S();
			pstQueryCond.write();
			
			Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindObjectSearchList(NetDemo.lpUserID, pstQueryCond, pstQueryResult);
			if(null == lpFindHandle)
			{
				System.out.printf("NETDEV_FindObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
			}
			else
			{
				pstQueryResult.read();
				NetDemo.textField_Total.setText(Integer.toString(pstQueryResult.udwTotal));
				NetDemo.udwObjectSearchTotalNum = NetDemo.udwObjectSearchTotalNum - pstQueryResult.udwNum;
				NetDemo.textField_Remain.setText(Integer.toString(NetDemo.udwObjectSearchTotalNum));
				NetDemo.dwTime = NetDemo.dwTime + 1;
				while(0 != pstQueryResult.udwNum)
				{
					NETDEV_OBJECT_RESULT_INFO_S pstObjectResultInfo = new NETDEV_OBJECT_RESULT_INFO_S();
					
					pstObjectResultInfo.stBigImageInfo = new NETDEV_FILE_INFO_S();
					pstObjectResultInfo.stBigImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
					pstObjectResultInfo.stBigImageInfo.pcData = new Memory(pstObjectResultInfo.stBigImageInfo.udwSize);
					
					pstObjectResultInfo.udwObjectInfoNum = 1;
					NETDEV_OBJECT_INFO_LIST_S[] pstObjectInfoList = new NETDEV_OBJECT_INFO_LIST_S[1];
					NETDEV_PERSON_ATTR_S[] pstPersonAttr = new NETDEV_PERSON_ATTR_S[1];
					for(int i = 0; i < pstObjectResultInfo.udwObjectInfoNum; ++i)
					{
						pstObjectInfoList[i] = new NETDEV_OBJECT_INFO_LIST_S();
						pstObjectInfoList[i].stSmallImageInfo = new NETDEV_FILE_INFO_S();
						pstObjectInfoList[i].stSmallImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
						pstObjectInfoList[i].stSmallImageInfo.pcData = new Memory(pstObjectInfoList[i].stSmallImageInfo.udwSize);
						pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum = 1;
						for(int j = 0; j < pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum; ++j)
						{
							pstPersonAttr[j] = new NETDEV_PERSON_ATTR_S();
						}
						pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr = new Memory(pstPersonAttr[0].size()*pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum);
						Common.SetStructArrToPointerData(pstPersonAttr, pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr);
					}
					
					pstObjectResultInfo.pstObjectInfoList = new Memory(pstObjectInfoList[0].size()*pstObjectResultInfo.udwObjectInfoNum);
					Common.SetStructArrToPointerData(pstObjectInfoList, pstObjectResultInfo.pstObjectInfoList);
					
					
					pstObjectResultInfo.write();
			        	
					boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextObjectSearchInfo(lpFindHandle, pstObjectResultInfo);
					if(bRet != true)
	                {
	                  	System.out.printf("NETDEV_FindNextObjectSearchInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	                  	break;
	                }
					else
					{
						pstQueryResult.udwNum --;
						pstObjectResultInfo.read();
						
						pstObjectInfoList = Common.pointerToStructureArray(pstObjectResultInfo.udwObjectInfoNum,pstObjectResultInfo.pstObjectInfoList, NETDEV_OBJECT_INFO_LIST_S.class);
						
						for(int i = 0; i< 1; i ++)
						{
							pstPersonAttr = Common.pointerToStructureArray(1,pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr, NETDEV_PERSON_ATTR_S.class);										
						}
															
						//System.out.printf("NETDEV_FindNextObjectSearchInfo,udwNum:%d,udwRecordID:%d, udwType:%d,udwTime:%d, szChannelName:%s,udwChannelID:%d\n",pstQueryResult.udwNum, pstObjectResultInfo.udwRecordID, pstObjectResultInfo.udwType, pstObjectResultInfo.udwTime, Common.byteArrayToString(pstObjectResultInfo.szChannelName),pstObjectResultInfo.udwChannelID);
						//System.out.printf("stBigImageInfo,Name:%s,szUrl:%s\n", Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szName), Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szUrl));
						
						Vector<String> ObjectVector = new Vector<String>();
						ObjectVector.add(Integer.toString(pstObjectResultInfo.udwRecordID));
						if(0 == pstObjectResultInfo.udwType)
						{
							ObjectVector.add("Cross line");
						}
						else if(1 == pstObjectResultInfo.udwType)
						{
							ObjectVector.add("Object inside");
						}
						else if(2 == pstObjectResultInfo.udwType)
						{
							ObjectVector.add("Enter area");
						}
						else if(3 == pstObjectResultInfo.udwType)
						{
							ObjectVector.add("Leave area");
						}
						else
						{
							ObjectVector.add("Unknow");
						}
						
						ObjectVector.add(Integer.toString( pstObjectResultInfo.udwTime));
						ObjectVector.add(Common.byteArrayToString(pstObjectResultInfo.szChannelName));
						ObjectVector.add(Integer.toString(pstObjectResultInfo.udwChannelID));
						
						NetDemo.ObjectSearchModel.addRow(ObjectVector);
						
						//大图信息
						//System.out.printf("stBigImageInfo.udwSize:%d\n",pstObjectResultInfo.stBigImageInfo.udwSize);
						
						
						String strBigImageInfo = NetDemo.strPicturePath + Common.byteArrayToString(pstObjectResultInfo.stBigImageInfo.szName) +"_BigImage.jpg";
						
						
						System.out.printf("stBigImageInfo.udwSize:%d, data:%s\n",pstObjectResultInfo.stBigImageInfo.udwSize, pstObjectResultInfo.stBigImageInfo.pcData);
						if(0 != pstObjectResultInfo.stBigImageInfo.udwSize)
						{
							
							Common.savePicture(pstObjectResultInfo.stBigImageInfo.pcData, pstObjectResultInfo.stBigImageInfo.udwSize, strBigImageInfo);
							
						}
						
						//人员属性信息
						//System.out.printf("ObjectInfo_PersonInfo,udwObjectType:%d, udwObjectID:%d,udwPersonID:%d, szPosition:%s \n",pstObjectInfoList[0].stObjectInfo.udwObjectType,pstObjectInfoList[0].udwObjectID, pstObjectInfoList[0].stObjectInfo.stPersonInfo.udwPersonID,Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stPersonInfo.szPosition));
						//System.out.printf("ObjectInfo_PersonInfo_Person,udwGender:%d, udwAgeRange:%d, udwSleevesLength:%d,udwCoatColor:%d, udwTrousersLength:%d,udwTrousersColor:%d,udwBodyToward:%d,udwShoesTubeLength:%d,udwHairLength:%d,udwBagFlag:%d\n",pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwGender, pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwAgeRange,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwSleevesLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwCoatColor,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwTrousersLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwTrousersColor,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwBodyToward,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwShoesTubeLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwHairLength,pstObjectInfoList[0].stObjectInfo.stPersonInfo.stPersonAttr.udwBagFlag);
					
						//非机动车信息 
						//System.out.printf("ObjectInfo_NonMotorVeh,udwID:%d, szPosition:%s,udwSmallPicAttachIndex:%d, udwLargePicAttachIndex:%d\n",pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwID, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.szPosition), pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwSmallPicAttachIndex, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.udwLargePicAttachIndex);
						//System.out.printf("ObjectInfo_NonMotorVeh_VehAttr,udwSpeedType:%d, udwImageDirection:%d, udwNonVehicleType:%d\n",pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwSpeedType, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwImageDirection, pstObjectInfoList[0].stObjectInfo.stNonMotorVehInfo.stNoMotorVehAttr.udwNonVehicleType);
					    //for(int i = 0; i < 1;i++ )
					    //{
					    	//System.out.printf("ObjectInfo_NonMotorVeh_Person, CoatColor:%d, TrousersColor:%d,\n", pstPersonAttr[i].udwCoatColor, pstPersonAttr[i].udwTrousersColor);
					    //}
						
						//机动车信息
						//System.out.printf("ObjectInfo_stVehInfo,udwID:%d, szPosition:%s\n",pstObjectInfoList[0].stObjectInfo.stVehInfo.udwID, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.szPosition));
						//System.out.printf("ObjectInfo_stVehInfo_VehAttr,udwType:%d, udwColor:%d, udwSpeedUnit:%d,fSpeedValue:%f,udwSpeedType:%d,szVehicleBrand:%s,udwImageDirection:%d\n",pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwType,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwColor,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwSpeedUnit,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.fSpeedValue,pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwSpeedType, Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.szVehicleBrand),pstObjectInfoList[0].stObjectInfo.stVehInfo.stVehAttr.udwImageDirection);
						//System.out.printf("ObjectInfo_stVehInfo_PlateAttr,szPlateNo:%s, udwColor:%d, udwType:%d\n", Common.byteArrayToString(pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.szPlateNo),pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.udwColor,pstObjectInfoList[0].stObjectInfo.stVehInfo.stPlateAttr.udwType);
					
						
					}
				}	
			}
			
			boolean bRet = NetDemo.netdevsdk.NETDEV_FindCloseObjectSearchList(lpFindHandle);
			if(bRet != true)
            {
              	System.out.printf("NETDEV_FindCloseObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
		}
		else
		{
			NetDemo.btnNewButton_2.setEnabled(false);
			NetDemo.btnNewButton_3.setEnabled(false);
			JOptionPane.showMessageDialog(null, "Target data query completed");
			return;
		}				
		
	}
	
	public static void getSmallPic() {
		NETDEV_PIC_QUERY_COND_S pstQueryCond = new NETDEV_PIC_QUERY_COND_S();
	    
		pstQueryCond.udwOffset = NetDemo.gstQueryCond.udwOffset;
		pstQueryCond.udwSearchID = NetDemo.gstQueryCond.udwSearchID;
		pstQueryCond.udwLimit = NetDemo.gstQueryCond.udwLimit;
		
		NETDEV_PIC_QUERY_RESULT_S pstQueryResult = new NETDEV_PIC_QUERY_RESULT_S();
		pstQueryCond.write();
		
		Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindObjectSearchList(NetDemo.lpUserID, pstQueryCond, pstQueryResult);
		if(null == lpFindHandle)
		{
			System.out.printf("NETDEV_FindObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
		}
		else
		{
			pstQueryResult.read();
			while(0 != pstQueryResult.udwNum)
			{
				NETDEV_OBJECT_RESULT_INFO_S pstObjectResultInfo = new NETDEV_OBJECT_RESULT_INFO_S();
				
				pstObjectResultInfo.stBigImageInfo = new NETDEV_FILE_INFO_S();
				pstObjectResultInfo.stBigImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
				pstObjectResultInfo.stBigImageInfo.pcData = new Memory(pstObjectResultInfo.stBigImageInfo.udwSize);
				
				pstObjectResultInfo.udwObjectInfoNum = 1;
				NETDEV_OBJECT_INFO_LIST_S[] pstObjectInfoList = new NETDEV_OBJECT_INFO_LIST_S[1];
				NETDEV_PERSON_ATTR_S[] pstPersonAttr = new NETDEV_PERSON_ATTR_S[1];
				for(int i = 0; i < pstObjectResultInfo.udwObjectInfoNum; ++i)
				{
					pstObjectInfoList[i] = new NETDEV_OBJECT_INFO_LIST_S();
					pstObjectInfoList[i].stSmallImageInfo = new NETDEV_FILE_INFO_S();
					pstObjectInfoList[i].stSmallImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
					pstObjectInfoList[i].stSmallImageInfo.pcData = new Memory(pstObjectInfoList[i].stSmallImageInfo.udwSize);
					pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum = 1;
					for(int j = 0; j < pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum; ++j)
					{
						pstPersonAttr[j] = new NETDEV_PERSON_ATTR_S();
					}
					pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr = new Memory(pstPersonAttr[0].size()*pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.udwPersonOnNoVehiNum);
					Common.SetStructArrToPointerData(pstPersonAttr, pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr);
				}
				
				pstObjectResultInfo.pstObjectInfoList = new Memory(pstObjectInfoList[0].size()*pstObjectResultInfo.udwObjectInfoNum);
				Common.SetStructArrToPointerData(pstObjectInfoList, pstObjectResultInfo.pstObjectInfoList);
				
				
				pstObjectResultInfo.write();
		        	
				boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextObjectSearchInfo(lpFindHandle, pstObjectResultInfo);
				if(bRet != true)
                {
                  	System.out.printf("NETDEV_FindNextObjectSearchInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                  	break;
                }
				else
				{
					pstQueryResult.udwNum --;
					pstObjectResultInfo.read();
					
					pstObjectInfoList = Common.pointerToStructureArray(pstObjectResultInfo.udwObjectInfoNum,pstObjectResultInfo.pstObjectInfoList, NETDEV_OBJECT_INFO_LIST_S.class);
					
					for(int i = 0; i< 1; i ++)
					{
						pstPersonAttr = Common.pointerToStructureArray(1,pstObjectInfoList[i].stObjectInfo.stNonMotorVehInfo.pstPersonAttr, NETDEV_PERSON_ATTR_S.class);										
					}
														
					String strSmallImageInfo = NetDemo.strPicturePath +  Common.byteArrayToString(pstObjectInfoList[0].stSmallImageInfo.szName) +"_SmallImage.jpg";
					
					
					System.out.printf("stSmallImageInfo.udwSize:%d, data:%s\n",pstObjectInfoList[0].stSmallImageInfo.udwSize, pstObjectInfoList[0].stSmallImageInfo.pcData);
					if(0 != pstObjectInfoList[0].stSmallImageInfo.udwSize)
					{									
						Common.savePicture(pstObjectInfoList[0].stSmallImageInfo.pcData, pstObjectInfoList[0].stSmallImageInfo.udwSize, strSmallImageInfo);																				
					}	
				}
			}	
		}
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_FindCloseObjectSearchList(lpFindHandle);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_FindCloseObjectSearchList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		
		JOptionPane.showMessageDialog(null, "Save Object Small picture success");
	}
	
	public static void findAlarm() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.");
			return;
		}
		
		NetDemo.AlarmSearchModel.setRowCount(0);
		NETDEV_ALARM_LOG_COND_LIST_S stAlarmCond = new NETDEV_ALARM_LOG_COND_LIST_S();
		for(int i = 0; i< NetDemo.netdevsdk.NETDEV_LOG_QUERY_COND_NUM; i++)
		{
			stAlarmCond.astCondition[i] = new NETDEV_QUERY_INFO_S();
		}
		stAlarmCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
		stAlarmCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
		Common.stringToByteArray(String.valueOf(0), stAlarmCond.astCondition[0].szConditionData);
		
		stAlarmCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_BeginTime.getText(), DateFormat)), stAlarmCond.astCondition[1].szConditionData);
		
		stAlarmCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_EndTime.getText(), DateFormat)), stAlarmCond.astCondition[2].szConditionData);
		
		stAlarmCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
		
		 if(0 != NetDemo.comboBox_1.getSelectedIndex())
         {
            	if(1 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1003", stAlarmCond.astCondition[4].szConditionData);             		
            	}
            	else if(2 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1004", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	else if(3 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1015", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	else if(4 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1016", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	stAlarmCond.astCondition[4].dwQueryType = 8;
            	stAlarmCond.astCondition[4].dwLogicFlag = 7;
            	stAlarmCond.dwCondSize = 5;
         }
		 else
		 {
			 stAlarmCond.dwCondSize = 4;
		 }
		 
		 stAlarmCond.dwPageRow = 20;
		 stAlarmCond.dwFirstRow = 0;
		 
		IntByReference pdwTotalRealRow = new IntByReference(0);
		stAlarmCond.write();
	    Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindAlarmLogList(NetDemo.lpUserID, stAlarmCond, pdwTotalRealRow);
		if(null == lpFindHandle)
		{
			System.out.printf("NETDEV_FindAlarmLogList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
		}
		else
		{
			NetDemo.btnNewButton_4.setEnabled(true);
			NetDemo.textField_AlarmTotal.setText(Integer.toString(pdwTotalRealRow.getValue()));
			int TotalNum = pdwTotalRealRow.getValue();
			NetDemo.dwAlarmSearchTime = 1;
			NetDemo.AlarmSearchModel.setRowCount(0);
			NetDemo.dwAlarmSearchTotal = TotalNum;
			
			if(0 <= NetDemo.dwAlarmSearchTotal-20)
			{
				NetDemo.textField_AlarmRemain.setText(Integer.toString(NetDemo.dwAlarmSearchTotal-20));
			}
			else
			{
				NetDemo.textField_AlarmRemain.setText(Integer.toString(0));
			}
			
			while(0 <= TotalNum && 0 <= stAlarmCond.dwPageRow)
			{
				NETDEV_ALARM_LOG_INFO_S stAlarmLogInfo = new NETDEV_ALARM_LOG_INFO_S();
				boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextAlarmLog(lpFindHandle, stAlarmLogInfo);
				if(bRet != true)
                {
                  	System.out.printf("NETDEV_FindNextAlarmLog failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                  	break;
                }
				else
				{
					TotalNum = TotalNum - 1;
					stAlarmCond.dwPageRow = stAlarmCond.dwPageRow - 1;
					stAlarmLogInfo.read();
					
					Vector<String> ObjectVector = new Vector<String>();
					ObjectVector.add(Integer.toString(stAlarmLogInfo.dwAlarmID));
					
					ObjectVector.add(Common.AlarmTypeToString(stAlarmLogInfo.dwAlarmType));
			
					ObjectVector.add(Long.toString(stAlarmLogInfo.tAlarmTime));
					ObjectVector.add(Common.byteArrayToString(stAlarmLogInfo.szAlarmSrc));
					ObjectVector.add(Integer.toString(stAlarmLogInfo.dwChannelID));
					
					
					NetDemo.AlarmSearchModel.addRow(ObjectVector);
				}
			}
			
		}
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_FindCloseAlarmLog(lpFindHandle);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_FindCloseAlarmLog failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
	}
	
	public static void findNextAlarm() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.");
			return;
		}
		NetDemo.AlarmSearchModel.setRowCount(0);
		NetDemo.dwAlarmSearchTotal = NetDemo.dwAlarmSearchTotal - 20;
		
		if(NetDemo.dwAlarmSearchTotal <= 0)
		{
			NetDemo.btnNewButton_4.setEnabled(false);
			JOptionPane.showMessageDialog(null, "Target data query completed");
			return;
		}
		
		NETDEV_ALARM_LOG_COND_LIST_S stAlarmCond = new NETDEV_ALARM_LOG_COND_LIST_S();
		for(int i = 0; i< NetDemo.netdevsdk.NETDEV_LOG_QUERY_COND_NUM; i++)
		{
			stAlarmCond.astCondition[i] = new NETDEV_QUERY_INFO_S();
		}
		stAlarmCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
		stAlarmCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
		Common.stringToByteArray(String.valueOf(0), stAlarmCond.astCondition[0].szConditionData);
		
		stAlarmCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_BeginTime.getText(), DateFormat)), stAlarmCond.astCondition[1].szConditionData);
		
		stAlarmCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
		Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(NetDemo.textField_EndTime.getText(), DateFormat)), stAlarmCond.astCondition[2].szConditionData);
		
		stAlarmCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
		stAlarmCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
		
		 if(0 != NetDemo.comboBox_1.getSelectedIndex())
         {
            	if(1 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1003", stAlarmCond.astCondition[4].szConditionData);             		
            	}
            	else if(2 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1004", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	else if(3 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1015", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	else if(4 == NetDemo.comboBox_1.getSelectedIndex())
            	{
            		Common.stringToByteArray("1016", stAlarmCond.astCondition[4].szConditionData);  
            	}
            	stAlarmCond.astCondition[4].dwQueryType = 8;
            	stAlarmCond.astCondition[4].dwLogicFlag = 7;
            	stAlarmCond.dwCondSize = 5;
         }
		 else
		 {
			 stAlarmCond.dwCondSize = 4;
		 }
		 
		
		stAlarmCond.dwPageRow = 20;
		stAlarmCond.dwFirstRow = NetDemo.dwAlarmSearchTime * 20;
						 
		IntByReference pdwTotalRealRow = new IntByReference(0);
		stAlarmCond.write();
	    Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindAlarmLogList(NetDemo.lpUserID, stAlarmCond, pdwTotalRealRow);
		if(null == lpFindHandle)
		{
			System.out.printf("NETDEV_FindAlarmLogList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
			JOptionPane.showMessageDialog(null, "Target data query completed");
            return;
		}
		else
		{
			NetDemo.textField_AlarmTotal.setText(Integer.toString(pdwTotalRealRow.getValue()));
			if(0 <= NetDemo.dwAlarmSearchTotal-20)
			{
				NetDemo.textField_AlarmRemain.setText(Integer.toString(NetDemo.dwAlarmSearchTotal-20));
			}
			else
			{
				NetDemo.textField_AlarmRemain.setText(Integer.toString(0));
			}
			
			int TotalNum = NetDemo.dwAlarmSearchTotal;
			NetDemo.dwAlarmSearchTime = NetDemo.dwAlarmSearchTime +1 ;
			//textField_5.setText(Integer.toString(dwAlarmSearchTotal-20*dwAlarmSearchTime));
			NetDemo.AlarmSearchModel.setRowCount(0);
			while(0 <= stAlarmCond.dwPageRow)
			{
				NETDEV_ALARM_LOG_INFO_S stAlarmLogInfo = new NETDEV_ALARM_LOG_INFO_S();
				boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextAlarmLog(lpFindHandle, stAlarmLogInfo);
				if(bRet != true)
                {
                  	System.out.printf("NETDEV_FindNextAlarmLog failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                  	break;
                }
				else
				{
					TotalNum = TotalNum - 1;
					stAlarmCond.dwPageRow = stAlarmCond.dwPageRow - 1;
					stAlarmLogInfo.read();
					
					Vector<String> ObjectVector = new Vector<String>();
					ObjectVector.add(Integer.toString(stAlarmLogInfo.dwAlarmID));
					ObjectVector.add(Common.AlarmTypeToString(stAlarmLogInfo.dwAlarmType));
					ObjectVector.add(Long.toString(stAlarmLogInfo.tAlarmTime));
					ObjectVector.add(Common.byteArrayToString(stAlarmLogInfo.szAlarmSrc));
					ObjectVector.add(Integer.toString(stAlarmLogInfo.dwChannelID));
					
					NetDemo.AlarmSearchModel.addRow(ObjectVector);
				}
			}
		}
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_FindCloseAlarmLog(lpFindHandle);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_FindCloseAlarmLog failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }		
		
	}
	
	public static void getRelatedData() {
		
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.");
			return;
		}
		
		if(NetDemo.dwAlarmID == -1){
			JOptionPane.showMessageDialog(null, "Please select an AlarmID.");
			return;
		}
		
		Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindAlarmRelatedDataList(NetDemo.lpUserID,NetDemo.dwAlarmID);
		if(null == lpFindHandle)
		{
			System.out.printf("NETDEV_FindAlarmRelatedDataList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
		}
		
		
		NETDEV_ALARM_RELATED_DATA_S pstAlarmRelatedData = new NETDEV_ALARM_RELATED_DATA_S();
		
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum = 1;
		//人员信息分配内存
		NETDEV_PERSON_STRUCT_INFO_S[] pstPersonInfo = new NETDEV_PERSON_STRUCT_INFO_S[pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum]; 
						
		for(int i = 0; i < pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum; i++)
		{
			pstPersonInfo[i] = new NETDEV_PERSON_STRUCT_INFO_S();					
		}
		
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstPersonInfo= new Memory(pstPersonInfo[0].size()*pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum);
		Common.SetStructArrToPointerData(pstPersonInfo, pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstPersonInfo);
		
		//车辆信息分配内存
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum = 1;
		NETDEV_VEH_INFO_S[] pstVehInfo = new NETDEV_VEH_INFO_S[pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum];
		
		for(int i = 0; i < pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum; i++)
		{
			pstVehInfo[i] = new NETDEV_VEH_INFO_S();					
		}
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstVehInfo = new Memory(pstVehInfo[0].size()*pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum);
		Common.SetStructArrToPointerData(pstVehInfo, pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstVehInfo);
		
		//非机动车信息
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum = 1;
		NETDEV_NON_MOTOR_VEH_INFO_S[] pstNonMotorVehInfo = new NETDEV_NON_MOTOR_VEH_INFO_S[pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum];
		
		NETDEV_PERSON_ATTR_S[] pstPersonAttr = new NETDEV_PERSON_ATTR_S[1];
		for(int i = 0; i < pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum; i++)
		{
			pstNonMotorVehInfo[i] = new NETDEV_NON_MOTOR_VEH_INFO_S();	
			
			pstNonMotorVehInfo[i].udwPersonOnNoVehiNum = 1;
			for(int j = 0; j < pstNonMotorVehInfo[i].udwPersonOnNoVehiNum; ++j)
			{
				pstPersonAttr[j] = new NETDEV_PERSON_ATTR_S();
			}
			pstNonMotorVehInfo[i].pstPersonAttr = new Memory(pstPersonAttr[0].size()*pstNonMotorVehInfo[i].udwPersonOnNoVehiNum);
			Common.SetStructArrToPointerData(pstPersonAttr, pstNonMotorVehInfo[i].pstPersonAttr);
			
		}
		pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstNonMotorVehInfo = new Memory(pstNonMotorVehInfo[0].size()*pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum);
		Common.SetStructArrToPointerData(pstNonMotorVehInfo, pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstNonMotorVehInfo);
		
		
		//图片信息 
		pstAlarmRelatedData.stStructDataInfo.udwImageNum = 2;
		NETDEV_STRUCT_IMAGE_INFO_S[] pstImageInfo = new NETDEV_STRUCT_IMAGE_INFO_S[pstAlarmRelatedData.stStructDataInfo.udwImageNum];
		for(int j = 0; j < pstAlarmRelatedData.stStructDataInfo.udwImageNum; j++)
		{
			pstImageInfo[j] = new NETDEV_STRUCT_IMAGE_INFO_S();
			pstImageInfo[j].udwSize = Common.NETDEMO_PICTURE_SIZE;
			pstImageInfo[j].pszData = new Memory(pstImageInfo[j].udwSize);
		}
		
		pstAlarmRelatedData.stStructDataInfo.pstImageInfo= new Memory(pstImageInfo[0].size()*pstAlarmRelatedData.stStructDataInfo.udwImageNum);
		Common.SetStructArrToPointerData(pstImageInfo, pstAlarmRelatedData.stStructDataInfo.pstImageInfo);
		
						
		pstAlarmRelatedData.write();
				
		boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextAlarmRelatedDataInfo(lpFindHandle, pstAlarmRelatedData);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_FindNextAlarmRelatedDataInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		else
		{
			pstAlarmRelatedData.read();
			pstPersonInfo = Common.pointerToStructureArray(pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum,pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstPersonInfo, NETDEV_PERSON_STRUCT_INFO_S.class);
			pstVehInfo = Common.pointerToStructureArray(pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum, pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstVehInfo, NETDEV_VEH_INFO_S.class);
			pstImageInfo =  Common.pointerToStructureArray(pstAlarmRelatedData.stStructDataInfo.udwImageNum,pstAlarmRelatedData.stStructDataInfo.pstImageInfo, NETDEV_STRUCT_IMAGE_INFO_S.class);
			pstNonMotorVehInfo = Common.pointerToStructureArray(pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum, pstAlarmRelatedData.stStructDataInfo.stObjectInfo.pstNonMotorVehInfo, NETDEV_NON_MOTOR_VEH_INFO_S.class);
			
			for(int i = 0; i< 1; i ++)
			{
				pstPersonAttr = Common.pointerToStructureArray(1,pstNonMotorVehInfo[i].pstPersonAttr, NETDEV_PERSON_ATTR_S.class);										
			}
			
			//人员信息
			//System.out.printf("personNum:%d,udwPersonID:%d, udwPersonDoforFaceID:%d, szPosition:%s, udwSmallPicAttachIndex:%d\n",pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwPersonNum, pstPersonInfo[0].udwPersonID,  pstPersonInfo[0].udwPersonDoforFaceID, Common.byteArrayToString(pstPersonInfo[0].szPosition), pstPersonInfo[0].udwSmallPicAttachIndex);					
			//System.out.printf("CoatColor:%d,rousersColor:%d\n",pstPersonInfo[0].stPersonAttr.udwCoatColor, pstPersonInfo[0].stPersonAttr.udwTrousersColor);					
			
								
			//车辆信息
			//System.out.printf("VehicleNum:%d,udwID:%d, szPosition:%s, udwSmallPicAttachIndex:%d\n",pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwVehicleNum, pstVehInfo[0].udwID,  Common.byteArrayToString(pstVehInfo[0].szPosition), pstVehInfo[0].udwSmallPicAttachIndex);					
			//System.out.printf("VehAttr, udwType:%d, udwColor:%d\n",pstVehInfo[0].stVehAttr.udwType,pstVehInfo[0].stVehAttr.udwColor);
			//System.out.printf("PlateAttr, udwType:%d, udwColor:%d\n",pstVehInfo[0].stPlateAttr.udwType, pstVehInfo[0].stPlateAttr.udwColor);
			
			//非机动车信息
			//System.out.printf("NonMotorVehicleNum:%d,udwID:%d, szPosition:%s, udwSmallPicAttachIndex:%d\n",pstAlarmRelatedData.stStructDataInfo.stObjectInfo.udwNonMotorVehNum, pstNonMotorVehInfo[0].udwID,  Common.byteArrayToString(pstNonMotorVehInfo[0].szPosition), pstNonMotorVehInfo[0].udwSmallPicAttachIndex);					
			//System.out.printf("PersonOnNoVehicle, PersonOnNoVehicleNum:%d, CoatColor:%d,TrousersColor:%d\n",pstNonMotorVehInfo[0].udwPersonOnNoVehiNum,pstPersonAttr[0].udwCoatColor, pstPersonAttr[0].udwTrousersColor);
			
			if(0 < pstAlarmRelatedData.stStructDataInfo.udwImageNum)
			{
				//图片信息
				for(int j = 0; j < pstAlarmRelatedData.stStructDataInfo.udwImageNum; j++ )
				{
					String strImageInfo = NetDemo.strPicturePath  + "RelatedAlarmPic_" +  NetDemo.dwAlarmID + "_"  +"Image" + j +".jpg";
					if(0 != pstImageInfo[j].udwSize)
				    {
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strImageInfo);	
							JOptionPane.showMessageDialog(null, "The " + (j+1) + " picture was saved successfully");
					}
					else
					{
						JOptionPane.showMessageDialog(null, "The Size of the "+ (j+1) + " picture is 0");
					}
				}
									
			}
			else
			{
				JOptionPane.showMessageDialog(null, " Image Num is 0");
			}
		}
		
					
		bRet = NetDemo.netdevsdk.NETDEV_FindCloseAlarmRelatedDataList(lpFindHandle);
		if(bRet != true)
        {
          	System.out.printf("NETDEV_FindCloseAlarmRelatedDataList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
	}
	
}
