package main.java.com.netdevsdk.demo.playback.config;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.Native;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RECT_S;


/**
 * 
 * @introduction PlayBack DigitalZoom
 * @description Support NVR/VMS
 */
public class PlayBackDigitalZoom {

    /**
     * 
     * @introduction Set the playback digitalzoom
     * @description Calling the interface of NETDEV_SetDigitalZoom to set the digitalZoom, 
     * the parameter should between 0 and 10000
     *
     */
	public static void setPlayBackDigitalZoom() {    
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		int dwLeft=0;
		int dwTop=0;
		int dwRight=0;
		int dwBottom=0;
		
		try {
			dwLeft=Integer.parseInt(NetDemo.jTextFieldPlayBackDigitalZoomLeft.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "left parameter is null or transformation exception");
			return;
		}
		if(dwLeft<0||dwLeft>10000) {
			JOptionPane.showMessageDialog(null, "Left parameter should beteen 0~10000");
			return;
		}
		
		try {
			dwTop=Integer.parseInt(NetDemo.jTextFieldPlayBackDigitalZoomTop.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Top parameter is null or transformation exception");
			NetDemo.jTextFieldPlayBackDigitalZoomTop.setText(null);
			return;
		}	
		if(dwTop<0||dwTop>10000) {
			JOptionPane.showMessageDialog(null, "Top parameter should beteen 0~10000");
			return;
		}
		
		try {
			dwRight=Integer.parseInt(NetDemo.jTextFieldPlayBackDigitalZoomRight.getText());
		}
		catch(NumberFormatException | InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Right parameter is null or transformation exception");
			return;
		}
		if(dwRight<0||dwRight>10000) {
			JOptionPane.showMessageDialog(null, "Right parameter should beteen 0~10000");
			return;
		}

		try {
			dwBottom=Integer.parseInt(NetDemo.jTextFieldPlayBackDigitalZoomBottom.getText());
		}catch(NumberFormatException |InputMismatchException e) {
			JOptionPane.showMessageDialog(null, "Bottom parameter is null or transformation exception");
			return;
		}
		if(dwBottom<0||dwBottom>10000) {
			JOptionPane.showMessageDialog(null, "Bottom parameter should beteen 0~10000");
			return;
		}
				
        if(dwBottom<dwTop) {
            JOptionPane.showMessageDialog(null, "Bottom parameter must more than top");
            return;
        }
        if(dwRight<dwLeft) {
            JOptionPane.showMessageDialog(null, "Right parameter must more than left");
            return;
        }
        
		NETDEV_RECT_S pstRect=new NETDEV_RECT_S();
		pstRect.dwLeft=dwLeft;
		pstRect.dwTop=dwTop;
		pstRect.dwRight=dwRight;
		pstRect.dwBottom=dwBottom;
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDigitalZoom(NetDemo.lpPlayHandle,Native.getComponentPointer(NetDemo.panelPlayLabel),pstRect);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Set DigitalZoom failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetDigitalZoom failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Success");
        }
	}
	
	/**
	 * 
	 * @introduction Exit playBack DigitalZoom
	 * @description Calling the interface of NETDEV_SetDigitalZoom and set the NETDEV_RECT_S null to exie digitalzoom
	 *
	 */
	public static void exitPlayBackDigitalZoom() {
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDigitalZoom(NetDemo.lpPlayHandle,Native.getComponentPointer(NetDemo.panelPlayLabel),null);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Exit DigitalZoom failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetDigitalZoom failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
	}
	
}
