package main.java.com.netdevsdk.demo.playback.play;

import java.util.Vector;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONTH_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONTH_STATUS_S;

/**
 * 
 * @introduction Monthly Record
 * @description Support NVR
 */
public class QueryPlayBackRecordByMonth {
	
    /**
     * 
     * @introduction Query the records for each month in a year 
     * @description  Calling the interface of NETDEV_QuickSearch
     *
     */
	public static void queryPlayBackRecordByMonth() {
		NetDemo.RecordByMonthTableModel.setRowCount(0);
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_MONTH_INFO_S pstMonthInfo=new NETDEV_MONTH_INFO_S();
		NETDEV_MONTH_STATUS_S pstMonthStatus=new NETDEV_MONTH_STATUS_S();
		int Month=1;
		switch (NetDemo.jComboBoxPlayRecordMonth.getItemAt(NetDemo.jComboBoxPlayRecordMonth.getSelectedIndex())) {
        case "January":
            Month = 1;
            break;
        case "February":
            Month = 2;
            break;
        case "March":
            Month = 3;
            break;
        case "April":
            Month = 4;
            break;
        case "May":
            Month = 5;
            break;
        case "June":
            Month = 6;
            break;
        case "July":
            Month = 7;
            break;
        case "August":
            Month = 8;
            break;
        case "September":
            Month = 9;
            break;
        case "October":
            Month = 10;
            break;
        case "November":
            Month = 11;
            break;
        case "December":
            Month = 12;
            break;
        default: 
            break;
		}
		
		String year=NetDemo.jTextFieldPlayBackRecordByMonthISYear.getText();
		int getYear=2020;
		if(year==null || year.equals("")) {
			JOptionPane.showMessageDialog(null, "Year is null");
			return;
		}	
		try {
		    getYear=Integer.parseInt(year);
		}catch(Exception e) {
		    JOptionPane.showMessageDialog(null, "Year transformation Exception");
		    NetDemo.jTextFieldPlayBackRecordByMonthISYear.setText(null);
		    return;
		}
		if(getYear<1970) {
		    JOptionPane.showMessageDialog(null, "Year can not less than 1970");
		    NetDemo.jTextFieldPlayBackRecordByMonthISYear.setText(null);
		    return;
		}
				
		pstMonthInfo.udwYear=getYear;
		pstMonthInfo.udwMonth=Month;
		pstMonthInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_QuickSearch(NetDemo.lpUserID,NetDemo.ChannelID,pstMonthInfo,pstMonthStatus);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get record failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	NetDemo.RecordByMonthTableModel.setRowCount(0);
        	System.out.printf("NETDEV_QuickSearch failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	pstMonthStatus.read();
        	for(int i=0;i<pstMonthStatus.udwDayNumInMonth;i++) {
        		Vector<Object> data=new Vector<>();
        		data.add(getYear);
        		data.add(Month);
        		data.add(i+1);
        		String type=null;
        		if(pstMonthStatus.szVideoStatus[i]==0) {
        			type="No Video";
        		}else if(pstMonthStatus.szVideoStatus[i]==1){
        			type="Event Video";
        		}else if(pstMonthStatus.szVideoStatus[i]==2){
        			type="Ordinary Video";
        		}
        		data.add(type);
        		NetDemo.RecordByMonthTableModel.insertRow(i, data);
        	}
        }
	}
	
	/**
	 * 
	 * @introduction Change the month to refresh data
	 * @description 
	 *
	 */
	public static void ComboxQueryPlayBackRecordByMonth() {
		NetDemo.RecordByMonthTableModel.setRowCount(0);
		
		if(null == NetDemo.lpUserID || NetDemo.ChannelID == 0){
			return;
		}
		
		NETDEV_MONTH_INFO_S pstMonthInfo=new NETDEV_MONTH_INFO_S();
		NETDEV_MONTH_STATUS_S pstMonthStatus=new NETDEV_MONTH_STATUS_S();
		int Month=1;
		switch (NetDemo.jComboBoxPlayRecordMonth.getItemAt(NetDemo.jComboBoxPlayRecordMonth.getSelectedIndex())) {
        case "January":
            Month = 1;
            break;
        case "February":
            Month = 2;
            break;
        case "March":
            Month = 3;
            break;
        case "April":
            Month = 4;
            break;
        case "May":
            Month = 5;
            break;
        case "June":
            Month = 6;
            break;
        case "July":
            Month = 7;
            break;
        case "August":
            Month = 8;
            break;
        case "September":
            Month = 9;
            break;
        case "October":
            Month = 10;
            break;
        case "November":
            Month = 11;
            break;
        case "December":
            Month = 12;
            break;
        default:
            break;
		}
		String year=NetDemo.jTextFieldPlayBackRecordByMonthISYear.getText();
		int getYear=2020;
		if(year==null||year.equals("")) {
			JOptionPane.showMessageDialog(null, "Year is null");
			return;
		}

		try {
		    getYear=Integer.parseInt(year);
		}catch(Exception ee) {
		    JOptionPane.showMessageDialog(null, "Year transformation exception");
		    NetDemo.jTextFieldPlayBackRecordByMonthISYear.setText(null);
		    return;
		}
			 
		if(getYear<1970) {
		    JOptionPane.showMessageDialog(null, "Year can not less than 1970");
		    NetDemo.jTextFieldPlayBackRecordByMonthISYear.setText(null);
		    return;
		}
		
		pstMonthInfo.udwYear=getYear;
		pstMonthInfo.udwMonth=Month;
		pstMonthInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_QuickSearch(NetDemo.lpUserID,NetDemo.ChannelID,pstMonthInfo,pstMonthStatus);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get record failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	pstMonthStatus.read();
        	for(int i=0;i<pstMonthStatus.udwDayNumInMonth;i++) {
        	    Vector<Object> data=new Vector<>();
        		data.add(getYear);
        		data.add(Month);
        		data.add(i+1);
        		String type=null;
        		if(pstMonthStatus.szVideoStatus[i]==0) {
        			type="No Video";
        		}else if(pstMonthStatus.szVideoStatus[i]==1){
        			type="Event Video";
        		}else if(pstMonthStatus.szVideoStatus[i]==2){
        			type="Ordinary Video";
        		}
        		data.add(type);
        		NetDemo.RecordByMonthTableModel.insertRow(i, data);
        	}
        }
	}
}
