package main.java.com.netdevsdk.demo.playback.play;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILECOND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FINDDATA_S;

/**
 * 
 * @introduction Query record
 * @description Support NVR/VMS
 */
public class QueryRecord {
	
    /**
     * 
     * @introduction Query record
     * @description Calling the interface of NETDEV_FindFile NETDEV_FindNextFile NETDEV_FindClose
     *
     */
	public static void queryRecord() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0) {
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
		String beginTime =NetDemo.Begindate.jTextFieldDate.getText();
		String endTime = NetDemo.Enddate.jTextFieldDate.getText();
		if(false == Common.isValidDate(beginTime, NetDemo.DateFormat) ||false == Common.isValidDate(endTime, NetDemo.DateFormat)){
			JOptionPane.showMessageDialog(null, "Please check that the time format is correct.");
			return;
		}
		
		long getBeginTime=Common.date2TimeStamp(beginTime, NetDemo.DateFormat);
		long getEndTime=Common.date2TimeStamp(endTime, NetDemo.DateFormat);
		if(getBeginTime>getEndTime) {
			JOptionPane.showMessageDialog(null, " The start time cannot exceed the end time");
			return;
		}
		

		NETDEV_FILECOND_S pstFindCond = new NETDEV_FILECOND_S();
		pstFindCond.dwChannelID = NetDemo.ChannelID;
		pstFindCond.tBeginTime = Common.date2TimeStamp(beginTime, NetDemo.DateFormat);
		pstFindCond.tEndTime = Common.date2TimeStamp(endTime, NetDemo.DateFormat);

		NetDemo.RecordTableModel.setRowCount(0);
		Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindFile(NetDemo.lpUserID, pstFindCond);
		if(null != lpFindHandle){
			NETDEV_FINDDATA_S pstFindData = new NETDEV_FINDDATA_S();
			boolean bRet = NetDemo.netdevsdk.NETDEV_FindNextFile(lpFindHandle, pstFindData);
			if(!bRet) {
				JOptionPane.showMessageDialog(null, "Get the record failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
				return;			
			}
			while(bRet){
				Vector<String> vector = new Vector<>();
		        vector.add(Common.timeStamp2Date(String.valueOf(pstFindData.tBeginTime), NetDemo.DateFormat));
		        vector.add(Common.timeStamp2Date(String.valueOf(pstFindData.tEndTime), NetDemo.DateFormat));
		        vector.add(Common.utfToString(pstFindData.szFileName));
		        NetDemo.RecordTableModel.insertRow(0,vector);
				bRet = NetDemo.netdevsdk.NETDEV_FindNextFile(lpFindHandle, pstFindData);
			}			
			NetDemo.netdevsdk.NETDEV_FindClose(lpFindHandle);
		}
		else{
			JOptionPane.showMessageDialog(null, "No data");
		}
	}
}
