package main.java.com.netdevsdk.demo.ptz.basicptz;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_E;

/**
 * 
 * @description The control of PTZ direction、Zoom settings、Focus settings and preset location settings
 *
 */
public class BasicPTZ {
    /**
     * 
     * @introduction PTZ direction control
     * @description  The PTZ is controlled by transferring different parameters
     * @param [direction] [PTZ moving direction]
     */
    public static void directionControl(int direction) {
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        int nSpeed = NetDemo.jComboBoxPTZSpeed.getSelectedIndex()+1;
        if(null == NetDemo.lpPlayHandle)
        {
            boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl_Other(NetDemo.lpUserID, NetDemo.ChannelID, direction, nSpeed);
            if(!bRet){
                JOptionPane.showMessageDialog(null, "Check if the corresponding device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            }
        }
        else
        {
            boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl(NetDemo.lpPlayHandle, direction, nSpeed);
            if(!bRet)
            {
                JOptionPane.showMessageDialog(null, "Check if the corresponding device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            }
        }
    }
    
    /**
     * 
     * @introduction PTZ pause 
     * @description
     */
    public static void PTZPause() {
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(NetDemo.ptzPause==0) 
        {
            int nSpeed = NetDemo.jComboBoxPTZSpeed.getSelectedIndex()+1;
            if(null == NetDemo.lpPlayHandle)
            {
                boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP, nSpeed);
                if(!bRet){
                    System.out.println( "Check if the corresponding1 device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                }else {
                    NetDemo.ptzPause=1;
                }
            }
            else
            {
                boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl(NetDemo.lpPlayHandle, NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP, nSpeed);
                if(!bRet)
                {
                    System.out.println( "Check if the corresponding device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                }
                else
                {
                    NetDemo.ptzPause=1;
                }
            }
        }
        else if(NetDemo.ptzPause==1) 
        {
            int nSpeed = NetDemo.jComboBoxPTZSpeed.getSelectedIndex()+1;
            if(null == NetDemo.lpPlayHandle)
            {
                boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP, nSpeed);
                if(!bRet)
                {
                    System.out.println( "Check if the corresponding2 device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                }else {
                    NetDemo.ptzPause=0;
                }
            }
            else
            {
                boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl(NetDemo.lpPlayHandle, NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP, nSpeed);
                if(!bRet)
                {
                    System.out.println( "Check if the corresponding device supports PTZ or if the selected channel is correct.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                }
                else 
                {
                    NetDemo.ptzPause=0;
                }
                }
        }
    }     
}

