package main.java.com.netdevsdk.demo.ptz.ptzextend;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_E;

public class ExtendOperation {
    /**
     * 
     * @introduction The extending operation of PTZ,including wiper,heater,lighter,snow remove.
     * @description  It is mainly including open and close the ability.
     * @param [Parameter1] [operation] Different functions are realized by passing different parameters.
     */
    public static void Operation( int operation) {
        
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        /* PTZ preset operation(Do not need to start preview) */
        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZControl_Other(NetDemo.lpUserID, NetDemo.ChannelID, operation, NetDemo.jComboBoxPTZSpeed.getSelectedIndex()+1);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Set failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZControl_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            if(operation==NETDEV_PTZ_E.NETDEV_PTZ_BRUSHON ||operation==NETDEV_PTZ_E.NETDEV_PTZ_HEATON || operation==NETDEV_PTZ_E.NETDEV_PTZ_LIGHTON || operation==NETDEV_PTZ_E.NETDEV_PTZ_SNOWREMOINGON)
            {
                JOptionPane.showMessageDialog(null, "Open success");
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Close success");
            }
        } 
    }

}
