package main.java.com.netdevsdk.demo.user;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_LEVEL_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_MODIFY_DETAIL_INFO_S;
/**
 * @description To modify the information of user.
 */
public class ModifyUser {
    /**
     * @description To modify the information of user.
     * @introduction Calling the interface of NETDEV_ModifyUser.
     */
	public static void modifyUser() {  
		if(null == NetDemo.lpUserID)
		{
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(0 == NetDemo.UserListTableModel.getRowCount()  || NetDemo.jTableUserList.getSelectedRow() < 0)
		{
			JOptionPane.showMessageDialog(null, "Please find user or seletc user first.");
			return;
		}	
		NETDEV_USER_MODIFY_DETAIL_INFO_S stUserInfo = new NETDEV_USER_MODIFY_DETAIL_INFO_S();
		if(NetDemo.jTextFieldModifyUserUserName.getText()==null||NetDemo.jTextFieldModifyUserUserName.getText().equals("")) 
		{
			JOptionPane.showMessageDialog(null, "Please input username");
			return;
		}
		if(NetDemo.jTextFieldlblModifyUserNewPasswd.getText()==null||NetDemo.jTextFieldlblModifyUserNewPasswd.getText().equals("")) 
		{
			JOptionPane.showMessageDialog(null, "Please input new Pssword");
			return;
		}
		Common.stringToByteArray(NetDemo.jTextFieldModifyUserUserName.getText(), stUserInfo.stUserInfo.szUserName);
		Common.stringToByteArray(NetDemo.jTextFieldModifyUserOldPassword.getText(), stUserInfo.szCurrentPassword);
		Common.stringToByteArray(NetDemo.jTextFieldlblModifyUserNewPasswd.getText(), stUserInfo.szNewPassword);
		if(NetDemo.jComboBoxModifyUserUserType.getSelectedIndex() == 0)
		{
			stUserInfo.stUserInfo.udwLevel = NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_OPERATOR;
		}
		else if(NetDemo.jComboBoxModifyUserUserType.getSelectedIndex() == 1)
		{
			stUserInfo.stUserInfo.udwLevel = NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_USER;
		}
		/* 管理员修改自己的信息 */
		if(NetDemo.jTextFieldModifyUserUserName.getText().compareTo("Admin") == 0)
		{
			stUserInfo.bIsModifyOther = 0;
		}
		else
		{
			stUserInfo.bIsModifyOther = 1;
		}
		/* 如果旧密码和新密码一样 */
		if(NetDemo.jTextFieldModifyUserOldPassword.getText().compareTo(NetDemo.jTextFieldlblModifyUserNewPasswd.getText()) == 0)
		{
			stUserInfo.bIsModifyPassword = 0;
		}
		else
		{
			stUserInfo.bIsModifyPassword = 1;
		}
		boolean bRet = NetDemo.netdevsdk.NETDEV_ModifyUser(NetDemo.lpUserID, stUserInfo);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Modify user failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_ModifyUser failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
        	JOptionPane.showMessageDialog(null, "Modify user success");
        	NetDemo.jTextFieldModifyUserUserName.setText(null);    
        	NetDemo.jTextFieldModifyUserOldPassword.setText(null);    
        	NetDemo.jTextFieldlblModifyUserNewPasswd.setText(null);
        	NetDemo.jComboBoxModifyUserUserType.setSelectedIndex(0);
        	NetDemo.changeName=null;
        }
        NetDemo.jButtonUserListGetUserList.doClick();
	}
}
