package main.java.com.netdevsdk.demo.user;

import java.util.Vector;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_DETAIL_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_DETAIL_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_LEVEL_E;

/**
 * 
 * @introduction The module of user list.
 * @description Only support NVR 
 */
public class Userlist {
	
	/** 
	 * @introduction To acquire the user list.
	 * @description Calling the interface of NETDEV_GetUserDetailList.
	 */
	public static void getUserList() {
		if(null == NetDemo.lpUserID)
		{
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		NetDemo.UserListTableModel.setRowCount(0);
		NETDEV_USER_DETAIL_LIST_S stUserDetailList = new NETDEV_USER_DETAIL_LIST_S();
		for(int i = 0; i<NetDEVSDKLib.NETDEV_LEN_64; i++)
		{
			stUserDetailList.astUserInfo[i] = new NETDEV_USER_DETAIL_INFO_S();
		}
		stUserDetailList.write();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetUserDetailList(NetDemo.lpUserID, stUserDetailList);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get user list,maybe not support. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetUserDetailList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        for(int i = 0; i < stUserDetailList.udwNum; i++)
        {
        	Vector<String> UserListVector= new Vector<String>();

        	UserListVector.add(String.valueOf(i+1));
        	UserListVector.add(Common.byteArrayToString(stUserDetailList.astUserInfo[i].szUserName));
        	if(stUserDetailList.astUserInfo[i].udwLevel == NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_ADMINISTRATOR)
        	{
        		UserListVector.add("ADMINISTRATOR");
        	}
        	else if(stUserDetailList.astUserInfo[i].udwLevel == NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_OPERATOR)
        	{
        		UserListVector.add("OPERATOR");
        	}
        	else if(stUserDetailList.astUserInfo[i].udwLevel == NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_USER)
        	{
        		UserListVector.add("USER");
        	}
        	else if(stUserDetailList.astUserInfo[i].udwLevel == NETDEV_USER_LEVEL_E.NETDEV_USER_LEVEL_Default)
        	{
        		UserListVector.add("Default");
        	}
        	NetDemo.UserListTableModel.addRow(UserListVector);
        }
	}
	/** 
     * @introduction To delete the user .
     * @description Calling the interface of NETDEV_DeleteUser.
     */
	public static void deleteUser() {
		if(null == NetDemo.lpUserID)
		{
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(0 == NetDemo.UserListTableModel.getRowCount()  || NetDemo.jTableUserList.getSelectedRow() < 0)
		{
			JOptionPane.showMessageDialog(null, "Please find user or seletc user first.");
			return;
		}
		String strUserName = (String) NetDemo.jTableUserList.getValueAt(NetDemo.jTableUserList.getSelectedRow(), 1);
		boolean bRet = NetDemo.netdevsdk.NETDEV_DeleteUser(NetDemo.lpUserID, strUserName);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Delete user failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_DeleteUser failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        } 
        NetDemo.jButtonUserListGetUserList.doClick();
	}
	/** 
     * @introduction To acquire the information of the user.
     */
	public static void getUserInfo() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		if(NetDemo.jTableUserList.getSelectedRows().length == 1)
		{
			if(null == NetDemo.lpUserID)
			{
				JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
				return;
			}
			if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
			{
				String userName = NetDemo.jTableUserList.getValueAt(NetDemo.jTableUserList.getSelectedRow(), 1).toString();
				MaintenaceUserInfoWindow ma=new MaintenaceUserInfoWindow(NetDemo.lpUserID,NetDemo.ChannelID,userName);
				ma.setVisible(true);
            }
			else if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 1)
			{
            	JOptionPane.showMessageDialog(null, "Only Support NVR Equipment.");
            }
			
		}
		else if(NetDemo.jTableUserList.getSelectedRows().length>1)
		{
			JOptionPane.showMessageDialog(null, "Only select one.");
			return;
		}
		else if(NetDemo.jTableUserList.getSelectedRows().length == 0)
		{
			JOptionPane.showMessageDialog(null, "Please select one.");
			return;
		}
	}
}
