package main.java.com.netdevsdk.demo.vca.accesscontrol;

import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ACS_ATTENDANCE_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ACS_VISIT_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_COND_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATE_BASIC_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_COMPARE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_ATTR_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_INFO_S;

/**
 * @description To search access records and visitor records.
 * @introduction Only support VMS.
 */
public class ACS {
    /**
     * @description  To search access records.
     * @introduction Calling the interface of NETDEV_FindACSAttendanceLogList  NETDEV_FindNextACSAttendanceLog NETDEV_FindCloseACSAttendanceLogList.
     */
    public static void searchAccessRecords() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=8;
        pstFindCond.dwFirstRow=0;
        pstFindCond.dwCondSize=3;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=4;
        pstFindCond.astCondition[0].dwLogicFlag=3;
        String FieldGetSearchStartTime= NetDemo.BeginAcsDate.getText();
        long get1=Common.date2TimeStamp(FieldGetSearchStartTime.toString(), NetDemo.DateFormat);
        String getStartTime=Long.toString(get1);   
        Common.stringToByteArray(getStartTime, pstFindCond.astCondition[0].szConditionData);
        String FieldGetSearchEndTime = NetDemo.EndAcsDate.getText();
        pstFindCond.astCondition[1]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[1].dwQueryType=4;
        pstFindCond.astCondition[1].dwLogicFlag=4;
        long get2=Common.date2TimeStamp(FieldGetSearchEndTime.toString(), NetDemo.DateFormat);
        if(get1>get2) 
        {
            JOptionPane.showMessageDialog(null, "Start time can not more than end time");
            return;
        }
        String getendtTime=Long.toString(get2);
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[1].szConditionData);
        pstFindCond.astCondition[2]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[2].dwQueryType=4;
        pstFindCond.astCondition[2].dwLogicFlag=9;
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[2].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=0;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle= NetDemo.netdevsdk.NETDEV_FindACSAttendanceLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) {
                NETDEV_ACS_ATTENDANCE_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_ATTENDANCE_LOG_INFO_S();
                pstACSLogInfo.stCompareInfo=new NETDEV_COMPARE_INFO_S();
                pstACSLogInfo.stCompareInfo.stPersonImage=new NETDEV_FILE_INFO_S();
                pstACSLogInfo.stCompareInfo.stPersonImage.pcData=new Memory(1048576);
                pstACSLogInfo.stCompareInfo.stSnapshotImage=new NETDEV_FILE_INFO_S();
                pstACSLogInfo.stCompareInfo.stSnapshotImage.pcData=new Memory(1048576);
                
                pstACSLogInfo.stFaceAttr=new NETDEV_FACE_ATTR_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                NetDemo.getRowData=new Vector();
                do {
                boolean nextAcs= NetDemo.netdevsdk.NETDEV_FindNextACSAttendanceLog(lpFindHandle,pstACSLogInfo);
                if(!nextAcs) {
                    break;
                }
                pstACSLogInfo.read();
                pstResultInfo.read();
//              分页数据
    
        try {
            Vector data=new Vector();
            data.add(i+1);
            String szName=Common.byteArrayToString(pstACSLogInfo.szPersonName);
            data.add(szName);
            Long getTime=pstACSLogInfo.tTimeStamp;
            String new1=String.valueOf(getTime);
            String getNewDateTime=Common.timeStamp2Date(new1, NetDemo.DateFormat); 
            String deptName=Common.byteArrayToString(pstACSLogInfo.szDoorName);
            
            int direct=pstACSLogInfo.udwDoorDirect;
            String getDirect=null;
            if(direct==0) {
                getDirect="in";
            }else if(direct==1) {
                getDirect="out";
            }else {
                getDirect="unknow";
            }

            data.add(getNewDateTime);
            data.add(deptName);
            data.add(getDirect);
            data.add(pstACSLogInfo.stFaceAttr.fTemperature);
            
            NetDemo.getRowData.add(data);
        
        }catch(Exception eee) {
               }i++;
       }
        while (flag && i < 8);
                
        }
        else
        {
            JOptionPane.showMessageDialog(null, "No record");
            DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableACS.getModel();
            defaultTableModel.setRowCount(0);
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
            NetDemo.jTextFieldACSRecord.setText(null);
            NetDemo.jTextFieldCountPageSize.setText(null);
            return;
        }
        NetDemo.netdevsdk.NETDEV_FindCloseACSAttendanceLogList(lpFindHandle);
        DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableACS.getModel();
        defaultTableModel.setRowCount(0);
        NetDemo.jTableACS.setModel(defaultTableModel);

        TableModel ACSTableModel = new DefaultTableModel(NetDemo.getRowData,NetDemo.RecordHeaderNames);
        NetDemo.jTableACS.setModel(ACSTableModel);

        int pageSize=0;
        if(pstResultInfo.udwTotal>0) {
            if(pstResultInfo.udwTotal%8==0) {
                try {
                    pageSize=pstResultInfo.udwTotal/8;
                }catch(Exception m) {
                    
                }
            }else {
                try {
                    pageSize=(pstResultInfo.udwTotal/8)+1;
                }catch(Exception m) {
                    
                }
            }
        }else {
            JOptionPane.showMessageDialog(null, "No data");
            return;
        }
        NetDemo.jTextFieldCountPageSize.setText(String.valueOf(pageSize));  
        NetDemo.currentPage=1;
        if(NetDemo.currentPage==1) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }
        if(NetDemo.currentPage+1>1) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        if(Integer.valueOf(NetDemo.jTextFieldCountPageSize.getText())==1) {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
            NetDemo.jButtonACSRecordsNext.setEnabled(false);
            NetDemo.jButtonACSRecordsGo.setEnabled(false);
        }

        NetDemo.jButtonACSRecordsPre.setEnabled(false);
        NetDemo.jButtonACSRecordsNext.setEnabled(true);
        NetDemo.jButtonACSRecordsGo.setEnabled(true);
        NetDemo.jTextFieldACSRecord.setText("1");
    }
    
    /**
     * @description To acquire data from the previous page.
     * @introduction  Calling the interface of NETDEV_FindACSAttendanceLogList,NETDEV_FindNextACSAttendanceLog,NETDEV_FindCloseACSAttendanceLogList
     */
    public static void accessRecordsPre() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonACSRecordsNext.setEnabled(true);
        if(NetDemo.currentPage>0) 
        {
            NetDemo.currentPage--;
        }
        if(NetDemo.currentPage==1|| NetDemo.currentPage<1) {
            NetDemo.currentPage=1;
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }
        if(NetDemo.currentPage>1) {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=8;
        pstFindCond.dwFirstRow=(NetDemo.currentPage-1)*8;
        pstFindCond.dwCondSize=3;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=4;
        pstFindCond.astCondition[0].dwLogicFlag=3;
        String FieldGetSearchStartTime= NetDemo.BeginAcsDate.getText();
        long get1=Common.date2TimeStamp(FieldGetSearchStartTime.toString(), NetDemo.DateFormat);
        String getStartTime=Long.toString(get1);
        Common.stringToByteArray(getStartTime, pstFindCond.astCondition[0].szConditionData); 
        String FieldGetSearchEndTime = NetDemo.EndAcsDate.getText();
        pstFindCond.astCondition[1]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[1].dwQueryType=4;
        pstFindCond.astCondition[1].dwLogicFlag=4;
        long get2=Common.date2TimeStamp(FieldGetSearchEndTime.toString(), NetDemo.DateFormat);
        String getendtTime=Long.toString(get2);
        if(get1>get2) 
        {
            JOptionPane.showMessageDialog(null, "Start time can not more than end time");
            return;
        }
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[1].szConditionData);
        pstFindCond.astCondition[2]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[2].dwQueryType=4;
        pstFindCond.astCondition[2].dwLogicFlag=9;
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[2].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset = (NetDemo.currentPage2-1)*8;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindACSAttendanceLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) 
        {
            NetDemo.currentPage++;
            NETDEV_ACS_ATTENDANCE_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_ATTENDANCE_LOG_INFO_S();
            pstACSLogInfo.stCompareInfo=new NETDEV_COMPARE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage.pcData=new Memory(1048576);
            pstACSLogInfo.stCompareInfo.stSnapshotImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stSnapshotImage.pcData=new Memory(1048576); 
            pstACSLogInfo.stFaceAttr=new NETDEV_FACE_ATTR_S();
            pstACSLogInfo.write();
            boolean flag = true;
            int i = 0;
            Vector get=new Vector();
            do {
                
                boolean nextAcs = NetDemo.netdevsdk.NETDEV_FindNextACSAttendanceLog(lpFindHandle,pstACSLogInfo);
                if(!nextAcs) 
                {
                   break;
                }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
            try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szPersonName);
                vtData.add(szName);
                Long getTime=pstACSLogInfo.tTimeStamp;
                String new1=String.valueOf(getTime);
                String getNewDateTime=Common.timeStamp2Date(new1, NetDemo.DateFormat);
                String deptName=Common.byteArrayToString(pstACSLogInfo.szDoorName);
                int direct=pstACSLogInfo.udwDoorDirect;
                String getDirect=null;
                if(direct==0) 
                {
                    getDirect="in";
                }
                else if(direct==1) 
                {
                    getDirect="out";
                }
                else 
                {
                    getDirect="unknow";
                }
                vtData.add(getNewDateTime);
                vtData.add(deptName);
                vtData.add(getDirect);
                vtData.add(pstACSLogInfo.stFaceAttr.fTemperature);
                get.add(vtData);
            }catch(Exception eee) {  
            }
            i++;
         }while (flag&&i<8);
             DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableACS.getModel();
             defaultTableModel.setRowCount(0);
             NetDemo.jTableACS.setModel(defaultTableModel);
             TableModel ACSTableModel = new DefaultTableModel(get,NetDemo.RecordHeaderNames);
             NetDemo.jTableACS.setModel(ACSTableModel);
       }
        NetDemo.netdevsdk.NETDEV_FindCloseACSAttendanceLogList(lpFindHandle);   
        NetDemo.currentPage--;  
        NetDemo.jTextFieldACSRecord.setText(String.valueOf(NetDemo.currentPage));
        try {
            if(Integer.parseInt(NetDemo.jTextFieldACSRecord.getText())<0)
            {
                NetDemo.jTextFieldACSRecord.setText(null);
            }
        }catch(Exception m) {
            
        }          
    }
    /**
     * @description Jump to a page.
     * @introduction Calling the interface of NETDEV_FindACSAttendanceLogList,NETDEV_FindNextACSAttendanceLog and NETDEV_FindCloseACSAttendanceLogList
     */
    public static void accessRecordsGo() {

        String getjTextFieldACSRecord = NetDemo.jTextFieldACSRecord.getText();
        
        if(getjTextFieldACSRecord==null||getjTextFieldACSRecord.equals("")) 
        {
            JOptionPane.showMessageDialog(null, "Page is null");
            return;
        }
        if(Integer.valueOf(getjTextFieldACSRecord)>Integer.valueOf(NetDemo.jTextFieldCountPageSize.getText())) 
        {
            JOptionPane.showMessageDialog(null, "The page is large than pagesize");
            NetDemo.jTextFieldACSRecord.setText(String.valueOf(NetDemo.currentPage));
            return;
        }
        if(Integer.valueOf(getjTextFieldACSRecord)==Integer.valueOf(NetDemo.jTextFieldCountPageSize.getText())) 
        {
            NetDemo.jButtonACSRecordsNext.setEnabled(false);
        }
        try {
            NetDemo.currentPage=Integer.parseInt(getjTextFieldACSRecord)-1;
            if((NetDemo.currentPage+1)==0||(NetDemo.currentPage+1)<0) {
                NetDemo.jTextFieldACSRecord.setText("1");
                NetDemo.currentPage=0;
            }
        }catch(Exception m) {
            JOptionPane.showMessageDialog(null, "Page type error,please reinput");
            NetDemo.jTextFieldACSRecord.setText(null);
            return;
        }
        
        
        if((NetDemo.currentPage+1)==1) {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }
        if((NetDemo.currentPage+1)>1) {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=8;
        pstFindCond.dwFirstRow=NetDemo.currentPage*8;
        pstFindCond.dwCondSize=3;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=0;
        pstFindCond.astCondition[0].dwLogicFlag=6;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=4;
        pstFindCond.astCondition[0].dwLogicFlag=3;
        String FieldGetSearchStartTime= NetDemo.BeginAcsDate.getText();
        long get1=Common.date2TimeStamp(FieldGetSearchStartTime.toString(), NetDemo.DateFormat);
        String getStartTime=Long.toString(get1);
        Common.stringToByteArray(getStartTime, pstFindCond.astCondition[0].szConditionData);
        String FieldGetSearchEndTime = NetDemo.EndAcsDate.getText();
        pstFindCond.astCondition[1]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[1].dwQueryType=4;
        pstFindCond.astCondition[1].dwLogicFlag=4;
        long get2=Common.date2TimeStamp(FieldGetSearchEndTime.toString(), NetDemo.DateFormat);
        String getendtTime=Long.toString(get2);
        if(get1>get2) {
            JOptionPane.showMessageDialog(null, "Start time can not more than end time");
            return;
        }
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[1].szConditionData);
        pstFindCond.astCondition[2]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[2].dwQueryType=4;
        pstFindCond.astCondition[2].dwLogicFlag=9;  
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[2].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=NetDemo.currentPage*8;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindACSAttendanceLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) 
        {
            NETDEV_ACS_ATTENDANCE_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_ATTENDANCE_LOG_INFO_S();
            pstACSLogInfo.stCompareInfo=new NETDEV_COMPARE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage.pcData=new Memory(1048576);
            pstACSLogInfo.stCompareInfo.stSnapshotImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stSnapshotImage.pcData=new Memory(1048576);
            pstACSLogInfo.stFaceAttr=new NETDEV_FACE_ATTR_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                Vector get=new Vector();
                do {
                boolean nextAcs= NetDemo.netdevsdk.NETDEV_FindNextACSAttendanceLog(lpFindHandle,pstACSLogInfo);
                    if(!nextAcs) {
                        break;
                    }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
        
            try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szPersonName);
                vtData.add(szName);
                Long getTime=pstACSLogInfo.tTimeStamp;
                String new1=String.valueOf(getTime);
                String getNewDateTime=Common.timeStamp2Date(new1, NetDemo.DateFormat);
                String deptName=Common.byteArrayToString(pstACSLogInfo.szDoorName);
                int direct=pstACSLogInfo.udwDoorDirect;
                String getDirect=null;
                if(direct==0) {
                    getDirect="in";
                }else if(direct==1) {
                    getDirect="out";
                }else {
                    getDirect="unknow";
                }
                vtData.add(getNewDateTime);
                vtData.add(deptName);
                vtData.add(getDirect);
                vtData.add(pstACSLogInfo.stFaceAttr.fTemperature);
                get.add(vtData);
            }catch(Exception eee) {
                
            }
                
            i++;
                }while (flag && i < 8);
                DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableACS.getModel();
                defaultTableModel.setRowCount(0);
                NetDemo.jTableACS.setModel(defaultTableModel);

                TableModel ACSTableModel = new DefaultTableModel(get,NetDemo.RecordHeaderNames);
                NetDemo.jTableACS.setModel(ACSTableModel);
                
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSAttendanceLogList(lpFindHandle);   
        
        int pageSize=0;
        if(pstResultInfo.udwTotal>0) 
        {
            if(pstResultInfo.udwTotal%8==0) {
                try {
                    pageSize=pstResultInfo.udwTotal/8;
                }catch(Exception m) {
                    
                }
            }else {
                try {
                    pageSize=(pstResultInfo.udwTotal/8)+1;
                }catch(Exception m) {
                    
                }
            }
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "No data");
            NetDemo.jTextFieldACSRecord.setText(null);
            return;
        }
        NetDemo.currentPage=NetDemo.currentPage+1;
    }
    
    /**
     * @description To acquire data from the next page.
     * @introduction Calling the interface of NETDEV_FindACSAttendanceLogList,NETDEV_FindNextACSAttendanceLog and NETDEV_FindCloseACSAttendanceLogList
     */
    public static void accessRecordsNext() {

        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if((NetDemo.jTextFieldCountPageSize.getText()==null)||(NetDemo.jTextFieldCountPageSize.getText().equals(""))) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }else {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        
        if(NetDemo.currentPage+1==Integer.valueOf(NetDemo.jTextFieldCountPageSize.getText())) {
            NetDemo.jButtonACSRecordsNext.setEnabled(false);
        }
            
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=8;
        pstFindCond.dwFirstRow=NetDemo.currentPage*8;
        pstFindCond.dwCondSize=3;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=4;
        pstFindCond.astCondition[0].dwLogicFlag=3;  
        
        String FieldGetSearchStartTime = NetDemo.BeginAcsDate.getText();
        
        
        long get1=Common.date2TimeStamp(FieldGetSearchStartTime.toString(), NetDemo.DateFormat);
        String getStartTime=Long.toString(get1);
        
        Common.stringToByteArray(getStartTime, pstFindCond.astCondition[0].szConditionData);
        String FieldGetSearchEndTime = NetDemo.EndAcsDate.getText();
        pstFindCond.astCondition[1]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[1].dwQueryType=4;
        pstFindCond.astCondition[1].dwLogicFlag=4;
        long get2=Common.date2TimeStamp(FieldGetSearchEndTime.toString(), NetDemo.DateFormat);
        String getendtTime=Long.toString(get2);
        if(get1>get2) 
        {
            JOptionPane.showMessageDialog(null, "Start time can not more than end time");
            return;
        }
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[1].szConditionData);
        
        pstFindCond.astCondition[2]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[2].dwQueryType=4;
        pstFindCond.astCondition[2].dwLogicFlag=9;
        
        Common.stringToByteArray(getendtTime, pstFindCond.astCondition[2].szConditionData);
        
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=NetDemo.currentPage*8;

        if(NetDemo.currentPage==1) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }
        if(NetDemo.currentPage+1>1) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle= NetDemo.netdevsdk.NETDEV_FindACSAttendanceLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) {
            NetDemo.currentPage++;
            NETDEV_ACS_ATTENDANCE_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_ATTENDANCE_LOG_INFO_S();
            pstACSLogInfo.stCompareInfo=new NETDEV_COMPARE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stPersonImage.pcData=new Memory(1048576);
            pstACSLogInfo.stCompareInfo.stSnapshotImage=new NETDEV_FILE_INFO_S();
            pstACSLogInfo.stCompareInfo.stSnapshotImage.pcData=new Memory(1048576);
            
            pstACSLogInfo.stFaceAttr=new NETDEV_FACE_ATTR_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                Vector get=new Vector();
                do {
                    boolean nextAcs = NetDemo.netdevsdk.NETDEV_FindNextACSAttendanceLog(lpFindHandle,pstACSLogInfo);
                    if(!nextAcs) {
                        break;
                    }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
               try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szPersonName);
                vtData.add(szName);
                Long getTime=pstACSLogInfo.tTimeStamp;
                String new1=String.valueOf(getTime);
                String getNewDateTime=Common.timeStamp2Date(new1, NetDemo.DateFormat);
                String deptName=Common.byteArrayToString(pstACSLogInfo.szDoorName);
                int direct=pstACSLogInfo.udwDoorDirect;
                String getDirect=null;
                if(direct==0) 
                {
                    getDirect="in";
                }
                else if(direct==1) 
                {
                    getDirect="out";
                }
                else 
                {
                    getDirect="unknow";
                }
                vtData.add(getNewDateTime);
                vtData.add(deptName);
                vtData.add(getDirect);
                vtData.add(pstACSLogInfo.stFaceAttr.fTemperature);
                get.add(vtData);
            }catch(Exception eee) {
                
            }   
            i++;
                }while (flag&&i<8);
                DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableACS.getModel();
                defaultTableModel.setRowCount(0);
                NetDemo.jTableACS.setModel(defaultTableModel);

                TableModel ACSTableModel = new DefaultTableModel(get,NetDemo.RecordHeaderNames);
                NetDemo.jTableACS.setModel(ACSTableModel);
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSAttendanceLogList(lpFindHandle);
        int pageSize=0;
        if(pstResultInfo.udwTotal>0) 
        {
            if(pstResultInfo.udwTotal%8==0) 
            {
                try {
                    pageSize=pstResultInfo.udwTotal/8;
                }catch(Exception m) {
                    
                }
            }
            else
            {
                try {
                    pageSize=(pstResultInfo.udwTotal/8)+1;
                }catch(Exception m) {
                    
                }
            }
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "No data");
            NetDemo.jTextFieldACSRecord.setText(null);
            return;
        }
        if((pageSize==1)||(NetDemo.jTextFieldCountPageSize.getText()==null)||(NetDemo.jTextFieldCountPageSize.getText().equals(""))) 
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(false);
        }
        else
        {
            NetDemo.jButtonACSRecordsPre.setEnabled(true);
        }
        
        NetDemo.jTextFieldACSRecord.setText(String.valueOf(NetDemo.currentPage));
    }
    
    /**
     * @description To search visitor records.
     * @introduction Calling the interface of NETDEV_FindACSVisitLogList,NETDEV_FindNextACSVisitLog,NETDEV_FindCloseACSVisitLog.
     */
    public static void searchVisitorRecords() {
        int total=0;
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=5;
        pstFindCond.dwFirstRow=0;
        pstFindCond.dwCondSize=1;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=0;
        pstFindCond.astCondition[0].dwLogicFlag=6;
        String GetVisitorName = NetDemo.jTextFieldGetVisitorName.getText();
        Common.stringToByteArray(GetVisitorName,pstFindCond.astCondition[0].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=0;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle = NetDemo.netdevsdk.NETDEV_FindACSVisitLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        pstResultInfo.udwTotal=total;
        if(lpFindHandle!=null) {
                NETDEV_ACS_VISIT_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_VISIT_LOG_INFO_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                NetDemo.getVisitorData = new Vector();
                do {
                boolean nextAcs = NetDemo.netdevsdk.NETDEV_FindNextACSVisitLog(lpFindHandle,pstACSLogInfo);
                if(!nextAcs) 
                {
                    break;
                }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
                
//                  分页数据
        
            try {
                Vector data=new Vector();
                data.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szVisitorName);
                String phone=Common.byteArrayToString(pstACSLogInfo.szVisitorPhone);
                data.add(szName);
                data.add(phone);
                data.add(Common.byteArrayToString(pstACSLogInfo.szVisitorCompany));
                data.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeName));
                data.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeDept));
                NetDemo.getVisitorData.add(data);
            
            }catch(Exception eee) {
                
            }   i++;
                
        }while (flag && i < 5);
                
                }else {
                    JOptionPane.showMessageDialog(null, "Get data fail,no record");
                    DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableVisitorACS.getModel();
                    defaultTableModel.setRowCount(0);
                    NetDemo.jTextFieldVisitorPageCount.setText(null);
                    NetDemo.jTextFieldGetVisitorACSRecord.setText(null);
                    NetDemo.jButtonVisitorRecordPre.setEnabled(false);
                    return;
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSVisitLog(lpFindHandle);    
        DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableVisitorACS.getModel();
        defaultTableModel.setRowCount(0);
        NetDemo.jTableVisitorACS.setModel(defaultTableModel);

        TableModel VisitorACSTableModel = new DefaultTableModel(NetDemo.getVisitorData,NetDemo.HeaderNames);
        NetDemo.jTableVisitorACS.setModel(VisitorACSTableModel);    
        NetDemo.jButtonVisitorRecordGo.setEnabled(true);
        NetDemo.jButtonVisitorRecordNext.setEnabled(true);
        NetDemo.jButtonVisitorRecordPre.setEnabled(true);
        int VisitorpageSize=0;
        if(pstResultInfo.udwTotal>0) {
            if(pstResultInfo.udwTotal%5==0) {
                try {
                    VisitorpageSize=pstResultInfo.udwTotal/5;
                }catch(Exception m) {
                    
                }
            }else {
                try {
                    VisitorpageSize=(pstResultInfo.udwTotal/5)+1;
                }catch(Exception m) {
                    
                }
            }
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "No data");
            NetDemo.jTextFieldVisitorPageCount.setText(null);
            return;
        }
        NetDemo.jTextFieldVisitorPageCount.setText(String.valueOf(VisitorpageSize));
        NetDemo.currentPage2=1;
        if(NetDemo.currentPage2==1) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }
        if(NetDemo.currentPage2>1) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(true);
        }
        if(Integer.valueOf(NetDemo.jTextFieldVisitorPageCount.getText())==1) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
            NetDemo.jButtonVisitorRecordNext.setEnabled(false);
            NetDemo.jButtonVisitorRecordGo.setEnabled(false);
        }
        
        
        NetDemo.jTextFieldGetVisitorACSRecord.setText("1");
    }
    /**
     * @description To acquire data from the previous page.
     * @introduction Calling the interface of NETDEV_FindACSVisitLogList,NETDEV_FindACSVisitLogList,NETDEV_FindNextACSVisitLog.
     */
    public static void visitorRecordsPre() {

        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.currentPage2>0) 
        {
            NetDemo.currentPage2--;
        }
        if(NetDemo.currentPage2==1) 
        {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }
        if(NetDemo.currentPage2>1) 
        {
            NetDemo.jButtonVisitorRecordPre.setEnabled(true);
        }
        
        NetDemo.jButtonVisitorRecordNext.setEnabled(true);
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=5;
        pstFindCond.dwFirstRow=(NetDemo.currentPage2-1)*5;
        pstFindCond.dwCondSize=1;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=0;
        pstFindCond.astCondition[0].dwLogicFlag=6;
        String GetVisitorName = NetDemo.jTextFieldGetVisitorName.getText();
        Common.stringToByteArray(GetVisitorName,pstFindCond.astCondition[0].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=(NetDemo.currentPage2-1)*2;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle= NetDemo.netdevsdk.NETDEV_FindACSVisitLogList(NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) {
            NetDemo.currentPage2++;
                NETDEV_ACS_VISIT_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_VISIT_LOG_INFO_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                Vector get=new Vector();
                
                do {
                
                    boolean nextAcs= NetDemo.netdevsdk.NETDEV_FindNextACSVisitLog(lpFindHandle,pstACSLogInfo);
                    if(!nextAcs) {
                        break;
                    }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
        
            try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szVisitorName);
                String phone=Common.byteArrayToString(pstACSLogInfo.szVisitorPhone);
                vtData.add(szName);
                vtData.add(phone);
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szVisitorCompany));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeName));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeDept));
                get.add(vtData);
            }catch(Exception eee) {
                
            }          
            i++;
        }while (flag&&i<5);

                DefaultTableModel defaultTableModel = (DefaultTableModel)NetDemo.jTableVisitorACS.getModel();
                defaultTableModel.setRowCount(0);
                NetDemo.jTableVisitorACS.setModel(defaultTableModel);
                TableModel VisitorACSTableModel = new DefaultTableModel(get,NetDemo.HeaderNames);
                NetDemo.jTableVisitorACS.setModel(VisitorACSTableModel);
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSVisitLog(lpFindHandle);    
        NetDemo.currentPage2--;
        NetDemo.jTextFieldGetVisitorACSRecord.setText(String.valueOf(NetDemo.currentPage2));
        try {
            if(Integer.parseInt(NetDemo.jTextFieldGetVisitorACSRecord.getText())<0) {
                NetDemo.jTextFieldGetVisitorACSRecord.setText(null);
            }
        }catch(Exception t) {
            
        }
    }/**
     * @description Jump to a page.
     * @introduction Calling the interface of NETDEV_FindACSVisitLogList,NETDEV_FindACSVisitLogList,NETDEV_FindNextACSVisitLog.
     */
    public static void visitorRecordsGo() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
            String gettextFieldGetVisitorACSRecord = NetDemo.jTextFieldGetVisitorACSRecord.getText();
            
            if(gettextFieldGetVisitorACSRecord==null||gettextFieldGetVisitorACSRecord.equals("")) 
            {
                JOptionPane.showMessageDialog(null, "Please input page");
                return;
            }
            if(Integer.valueOf(gettextFieldGetVisitorACSRecord)>Integer.valueOf(NetDemo.jTextFieldVisitorPageCount.getText())) {
                JOptionPane.showMessageDialog(null, "The page is large than pagesize");
                return;
            }
            if(Integer.valueOf(gettextFieldGetVisitorACSRecord)==Integer.valueOf(NetDemo.jTextFieldVisitorPageCount.getText())) 
            {
                NetDemo.jButtonVisitorRecordNext.setEnabled(false);
            }
            
            try {
                NetDemo.currentPage2=Integer.parseInt(gettextFieldGetVisitorACSRecord)-1;
                if((NetDemo.currentPage2+1)==0||(NetDemo.currentPage2+1)<0) {
                    NetDemo.jTextFieldGetVisitorACSRecord.setText("1");
                    NetDemo.currentPage2=0;
                }
            }
            catch(Exception m) 
            {
                JOptionPane.showMessageDialog(null, "Page type error,please reinput");
                NetDemo.jTextFieldGetVisitorACSRecord.setText(null);
                return;
            }
            if((NetDemo.currentPage2+1)==1) {
                NetDemo.jButtonVisitorRecordPre.setEnabled(false);
            }
            if((NetDemo.currentPage2+1)>1) 
            {
                NetDemo.jButtonVisitorRecordPre.setEnabled(true);
            }
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=5;
        pstFindCond.dwFirstRow=NetDemo.currentPage2*5;
        pstFindCond.dwCondSize=1;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=0;
        pstFindCond.astCondition[0].dwLogicFlag=6;
        String GetVisitorName =  NetDemo.jTextFieldGetVisitorName.getText();
        Common.stringToByteArray(GetVisitorName,pstFindCond.astCondition[0].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=NetDemo.currentPage2*2;
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle =  NetDemo.netdevsdk.NETDEV_FindACSVisitLogList( NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) {
                NETDEV_ACS_VISIT_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_VISIT_LOG_INFO_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                Vector get=new Vector();
                do {
                boolean nextAcs=  NetDemo.netdevsdk.NETDEV_FindNextACSVisitLog(lpFindHandle,pstACSLogInfo);
                    if(!nextAcs) {
                        break;
                    }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
        
            try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szVisitorName);
                String phone=Common.byteArrayToString(pstACSLogInfo.szVisitorPhone);
                vtData.add(szName);
                vtData.add(phone);
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szVisitorCompany));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeName));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeDept));
                get.add(vtData);
            }catch(Exception eee) {
                
            }
                
            i++;
            
                
                }while (flag && i < 5);
                
                DefaultTableModel defaultTableModel = (DefaultTableModel) NetDemo.jTableVisitorACS.getModel();
                defaultTableModel.setRowCount(0);
                NetDemo.jTableVisitorACS.setModel(defaultTableModel);

                TableModel VisitorACSTableModel = new DefaultTableModel(get, NetDemo.HeaderNames);
                
                NetDemo.jTableVisitorACS.setModel(VisitorACSTableModel);
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSVisitLog(lpFindHandle);
        int VisitorpageSize=0;
        if(pstResultInfo.udwTotal>0) {
            if(pstResultInfo.udwTotal%8==0) {
                try {
                    VisitorpageSize=pstResultInfo.udwTotal/5;
                }catch(Exception m) {
                    
                }
            }else {
                try {
                    VisitorpageSize=(pstResultInfo.udwTotal/5)+1;
                }catch(Exception m) {
                    
                }
            }
        }else {
            JOptionPane.showMessageDialog(null, "No data");
            NetDemo.jTextFieldGetVisitorACSRecord.setText(null);
            return;
        }
        
        NetDemo.currentPage2=NetDemo.currentPage2+1;
        
    }
    /**
     * @description To acquire data from the next page.
     * @introduction Calling the interface of NETDEV_FindACSVisitLogList,NETDEV_FindACSVisitLogList,NETDEV_FindNextACSVisitLog.
     */
    public static void visitorRecordsNext() {
        if(null ==  NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(Integer.parseInt( NetDemo.jTextFieldVisitorPageCount.getText())==1) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }else if(( NetDemo.jTextFieldVisitorPageCount.getText()==null)||( NetDemo.jTextFieldVisitorPageCount.getText().equals("")))
        {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }else {
            NetDemo.jButtonVisitorRecordPre.setEnabled(true);
        }
        
        if(NetDemo.currentPage2+1==Integer.valueOf(NetDemo.jTextFieldVisitorPageCount.getText())) {
            NetDemo.jButtonVisitorRecordNext.setEnabled(false);
        }
        
        NETDEV_ALARM_LOG_COND_LIST_S pstFindCond=new NETDEV_ALARM_LOG_COND_LIST_S();
        pstFindCond.dwPageRow=5;
        pstFindCond.dwFirstRow=NetDemo.currentPage2*5;
        pstFindCond.dwCondSize=1;
        pstFindCond.astCondition[0]=new NETDEV_QUERY_INFO_S();
        pstFindCond.astCondition[0].dwQueryType=0;
        pstFindCond.astCondition[0].dwLogicFlag=6;
        String GetVisitorName = NetDemo.jTextFieldGetVisitorName.getText();
        Common.stringToByteArray(GetVisitorName,pstFindCond.astCondition[0].szConditionData);
        NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo=new NETDEV_BATCH_OPERATE_BASIC_S();
        pstResultInfo.udwOffset=NetDemo.currentPage2*2;
        if(NetDemo.currentPage2==1) 
        {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }
        pstFindCond.write();
        pstResultInfo.write();
        Pointer lpFindHandle =  NetDemo.netdevsdk.NETDEV_FindACSVisitLogList( NetDemo.lpUserID,pstFindCond,pstResultInfo);
        if(lpFindHandle!=null) 
        {
            NetDemo.currentPage2++;
                NETDEV_ACS_VISIT_LOG_INFO_S pstACSLogInfo=new NETDEV_ACS_VISIT_LOG_INFO_S();
                pstACSLogInfo.write();
                boolean flag = true;
                int i = 0;
                Vector get=new Vector();
                do {
                    boolean nextAcs=  NetDemo.netdevsdk.NETDEV_FindNextACSVisitLog(lpFindHandle,pstACSLogInfo);
                    if(!nextAcs) {
                        break;
                    }
                    pstACSLogInfo.read();
                    pstResultInfo.read();
            try {
                Vector vtData = new Vector();
                vtData.add(i+1);
                String szName=Common.byteArrayToString(pstACSLogInfo.szVisitorName);
                String phone=Common.byteArrayToString(pstACSLogInfo.szVisitorPhone);
                vtData.add(szName);
                vtData.add(phone);
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szVisitorCompany));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeName));
                vtData.add(Common.byteArrayToString(pstACSLogInfo.szIntervieweeDept));
                get.add(vtData);
            }catch(Exception eee) {
                
            }   
            i++;
                }while (flag&&i<5);
                DefaultTableModel defaultTableModel = (DefaultTableModel)NetDemo.jTableVisitorACS.getModel();
                defaultTableModel.setRowCount(0);
                NetDemo.jTableVisitorACS.setModel(defaultTableModel);

                TableModel VisitorACSTableModel = new DefaultTableModel(get,NetDemo.HeaderNames);
                
                NetDemo.jTableVisitorACS.setModel(VisitorACSTableModel);
                }
        NetDemo.netdevsdk.NETDEV_FindCloseACSVisitLog(lpFindHandle);
        if(NetDemo.currentPage2+1>1) 
        {
        NetDemo.jButtonVisitorRecordPre.setEnabled(true);
        }
        int VisitorpageSize=0;
        if(pstResultInfo.udwTotal>0) 
        {
            if(pstResultInfo.udwTotal%5==0) 
            {
                try {
                    VisitorpageSize=pstResultInfo.udwTotal/5;
                }catch(Exception m) {
                    
                }
            }
            else 
            {
                try {
                    VisitorpageSize=(pstResultInfo.udwTotal/5)+1;
                }catch(Exception m) {
                    
                }
            }
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "No data");
            return;
        }
        if((VisitorpageSize==0)||(VisitorpageSize==1)||(NetDemo.jTextFieldVisitorPageCount.getText()==null)||(NetDemo.jTextFieldVisitorPageCount.getText().equals(""))) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        } 
        if(Integer.parseInt(NetDemo.jTextFieldVisitorPageCount.getText())==1) {
            NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        }
        NetDemo.jTextFieldGetVisitorACSRecord.setText(String.valueOf(NetDemo.currentPage2));  
    }
}
