package main.java.com.netdevsdk.demo.vca.peoplecounting;

import java.util.Calendar;
import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OPERATE_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRAFFIC_STATIC_FORM_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRAFFIC_STATISTICS_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRAFFIC_STATISTICS_TYPE_E;
/**
 * @description The  CountThreadClass extend Thread and rewrite the method of run.
 *
 */
public class CountThreadClass  extends Thread{
    @Override
   public void run() {
        if(NetDemo.flag==false) 
        {
            System.out.println(NetDemo.t.getState());
            return;
        }
       while(NetDemo.flag)
       {
                   
                   boolean bRet = false;
                   NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S stStatisticCond = new NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S();
                   stStatisticCond.stChannelIDs = new NETDEV_OPERATE_LIST_S();
                   stStatisticCond.stChannelIDs.pstOperateInfo = new Memory(4);
                   stStatisticCond.stChannelIDs.pstOperateInfo.setInt(0, NetDemo.ChannelID);
                   stStatisticCond.stChannelIDs.dwSize = 1;

                   stStatisticCond.udwFormType = NETDEV_TRAFFIC_STATIC_FORM_TYPE_E.NETDEV_TRAFFIC_STAT_FORM_BY_DAY;
                   stStatisticCond.udwStatisticsType = NETDEV_TRAFFIC_STATISTICS_TYPE_E.NETDEV_TRAFFIC_STATISTICS_TYPE_ALL;

                   Calendar calendar = Calendar.getInstance();
                   calendar.set(Calendar.HOUR_OF_DAY, 0);
                   calendar.set(Calendar.HOUR, 0);
                   calendar.set(Calendar.MINUTE, 0);
                   calendar.set(Calendar.SECOND, 0);

                   long now = System.currentTimeMillis() / 1000l;
                   long daySecond = 60 * 60 * 24;
                   stStatisticCond.tBeginTime = now - (now + 8 * 3600) % daySecond;
                   stStatisticCond.tEndTime = stStatisticCond.tBeginTime+24*3600;

                   NetDemo.udwSearchID = new IntByReference();
                   bRet = NetDemo.netdevsdk.NETDEV_StartMultiTrafficStatistic(NetDemo.lpUserID, stStatisticCond, NetDemo.udwSearchID);
                   if(false == bRet){
                       JOptionPane.showMessageDialog(null, "StartTrafficStatistic failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                       System.out.printf("NETDEV_StartMultiTrafficStatistic failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                       return;
                   }

                   /*查询统计进度 Query statistics progress */
                   while(NetDemo.flag)
                   {
                       IntByReference dwProgress = new IntByReference();
                       try {
                           bRet = NetDemo.netdevsdk.NETDEV_GetTrafficStatisticProgress(NetDemo.lpUserID, NetDemo.udwSearchID.getValue(), dwProgress);
                       }catch(Exception k) {
                           continue;
                       }
                       
                       if(dwProgress.getValue() == 100)
                       {
                           break;
                       }
                       else
                       {
                           try {
                               CountThreadClass.sleep(4000);
                           } catch (InterruptedException e) {
                               // TODO Auto-generated catch block
                               e.printStackTrace();
                           }
                       }
                   }

                   try {
                       if(NetDemo.udwSearchID==null||NetDemo.udwSearchID.equals("")){
                           return;
                       }
                   }catch(Exception m) {
                       return;
                   }
                   Pointer lpStaticHandle = NetDemo.netdevsdk.NETDEV_FindTrafficStatisticInfoList(NetDemo.lpUserID, NetDemo.udwSearchID.getValue());
                   
                   if(lpStaticHandle != null)
                   {
                       while(NetDemo.flag)
                       {
                           NETDEV_TRAFFIC_STATISTICS_INFO_S stStatisticInfo = new NETDEV_TRAFFIC_STATISTICS_INFO_S();
                           bRet = NetDemo.netdevsdk.NETDEV_FindNextTrafficStatisticInfo(lpStaticHandle, stStatisticInfo);
                           if(bRet != true)
                           {
                               break;
                           }
                           else
                           {
                               Vector<String> StatisticInfoVector = new Vector<String>();

                               StatisticInfoVector.add(String.valueOf(stStatisticInfo.dwChannelID));
                               StatisticInfoVector.add(String.valueOf(stStatisticInfo.audwEnterCount[0]));
                               StatisticInfoVector.add(String.valueOf(stStatisticInfo.audwExitCount[0]));
                               NetDemo.PeopleCountingVMSNVRRealTimeTableModel.addRow(StatisticInfoVector);
                           }
                       }
                       bRet = NetDemo.netdevsdk.NETDEV_FindCloseTrafficStatisticInfo(lpStaticHandle);
                       if(false == bRet){
                           System.out.printf("NETDEV_FindCloseTrafficStatisticInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                           return;
                       }
                   }
               }
           
   }

}
