package main.java.com.netdevsdk.demo.vca.vehicle;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_COND_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_ALARM_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PLATE_ATTR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_LOGICTYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_ALARM_LOG_RESULT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEHICLE_RECORD_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEH_ATTR_S;
/**
 * @description To query the vehicle alarm record.
 * @introduction Only support VMS.
 */
public class VehicleAlarmRecord {
    /**
     * @introduction To query the vehicle alarm record.
     * @description Calling the interface of NETDEV_FindNextVehicleRecordInfo and  NETDEV_FindCloseVehicleRecordList.
     */
    public static void queryVehicleAlarmRecord() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = false;
        NETDEV_ALARM_LOG_COND_LIST_S stFindCond = new NETDEV_ALARM_LOG_COND_LIST_S();
        NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  stResultInfo = new NETDEV_SMART_ALARM_LOG_RESULT_INFO_S();

        stFindCond.dwFirstRow = 0;
        stFindCond.dwPageRow = 20;
        stFindCond.dwCondSize = 5;

        stFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();

        stFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_VEH_DATA_TYPE;
        stFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        Common.stringToByteArray("0", stFindCond.astCondition[0].szConditionData);

        stFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMTYPE;
        stFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
        if(NetDemo.jComboBoxVehicleAlarmMonitorType.getSelectedIndex() == 0)
        {
            Common.stringToByteArray("1022", stFindCond.astCondition[1].szConditionData);   //NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST
        }
        else if(NetDemo.jComboBoxVehicleAlarmMonitorType.getSelectedIndex() == 1)
        {
            Common.stringToByteArray("1024", stFindCond.astCondition[1].szConditionData);   //NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST
        }

        stFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
        String BeginTime = NetDemo.VehicleAlarmStartTime.getText();
        String EndTime = NetDemo.VehicleAlarmEndTime.getText();
        if(false == Common.isValidDate(BeginTime, NetDemo.DateFormat) ||false == Common.isValidDate(EndTime, NetDemo.DateFormat))
        {
            JOptionPane.showMessageDialog(null, "Please check that the time format is correct.");
            return;
        }
        long get1=Common.date2TimeStamp(BeginTime, NetDemo.DateFormat);
        long get2=Common.date2TimeStamp(EndTime, NetDemo.DateFormat);
        if(get1>get2) 
        {
            JOptionPane.showMessageDialog(null, " Start time can not more than end time");
            return;
        }
        Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, NetDemo.DateFormat)), stFindCond.astCondition[2].szConditionData);
        stFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
        Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, NetDemo.DateFormat)), stFindCond.astCondition[3].szConditionData);
        stFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;

        if(!NetDemo.jTextFieldVehicleAlarmBayonetName.getText().trim().equals(""))
        {
            stFindCond.astCondition[stFindCond.dwCondSize] = new NETDEV_QUERY_INFO_S();
            stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_CHNNAME;
            stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
            Common.stringToByteArray(NetDemo.jTextFieldVehicleAlarmBayonetName.getText(), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData);
            stFindCond.dwCondSize++;
        }

        if(!NetDemo.jTextFieldVehicleAlarmPlateNumber.getText().trim().equals(""))
        {
            stFindCond.astCondition[stFindCond.dwCondSize] = new NETDEV_QUERY_INFO_S();
            stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_PLATE_NUM;
            stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
            Common.stringToByteArray(NetDemo.jTextFieldVehicleAlarmPlateNumber.getText(), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData);

            stFindCond.dwCondSize++;
        }
        if(NetDemo.jComboBoxVehicleAlarmPlateColor.getSelectedIndex() != 0)
        {
            stFindCond.astCondition[stFindCond.dwCondSize] = new NETDEV_QUERY_INFO_S();
            stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_PLATE_COLOR;
            stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
            Common.stringToByteArray(String.valueOf(Common.StringConventToEnumNETDEV_PLATE_COLOR_E(NetDemo.jComboBoxVehicleAlarmPlateColor.getSelectedItem().toString())), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData);

            stFindCond.dwCondSize++;
        }

        if(NetDemo.jComboBoxVehicleAlarmCarColor.getSelectedIndex() != 0)
        {
            stFindCond.astCondition[stFindCond.dwCondSize] = new NETDEV_QUERY_INFO_S();
            stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_VEHICLE_COLOR;
            stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
            Common.stringToByteArray(String.valueOf(Common.StringConventToEnumNETDEV_PLATE_COLOR_E(NetDemo.jComboBoxVehicleAlarmCarColor.getSelectedItem().toString())), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData);

            stFindCond.dwCondSize++;
        }
        if(NetDemo.jComboBoxVehicleAlarmMonitorReason.getSelectedIndex() != 0)
        {
            stFindCond.astCondition[stFindCond.dwCondSize] = new NETDEV_QUERY_INFO_S();
            stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_MONITOY_REASON;
            stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
            Common.stringToByteArray(String.valueOf(Common.StringConventToEnumNETDEV_VEHICLE_MONITOR_TYPE_E(NetDemo.jComboBoxVehicleAlarmMonitorReason.getSelectedItem().toString())), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData);
            stFindCond.dwCondSize++;
        }
        while(true)
        {
            Pointer lpFindVehicleRecordHandlePointer = NetDemo.netdevsdk.NETDEV_FindVehicleRecordInfoList(NetDemo.lpUserID, stFindCond, stResultInfo);
            if(lpFindVehicleRecordHandlePointer != null)
            {
                while(true)
                {
                    NETDEV_VEHICLE_RECORD_INFO_S stRecordInfo = new NETDEV_VEHICLE_RECORD_INFO_S();
                    stRecordInfo.stPlateAttr = new NETDEV_PLATE_ATTR_INFO_S();
                    stRecordInfo.stVehAttr = new NETDEV_VEH_ATTR_S();
                    stRecordInfo.stPlateImage = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stPlateImage.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stPlateImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);

                    stRecordInfo.stVehicleImage = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stVehicleImage.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stVehicleImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);

                    stRecordInfo.stPanoImage = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stPanoImage.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stPanoImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);

                    stRecordInfo.stMonitorAlarmInfo = new NETDEV_MONITOR_ALARM_INFO_S();

                    bRet = NetDemo.netdevsdk.NETDEV_FindNextVehicleRecordInfo(lpFindVehicleRecordHandlePointer, stRecordInfo);
                    if(bRet == true)
                    {
                        //写文件
                        String strTime = Common.getDate();
                        /* 车牌抓拍图片 */
                        if( 0 < stRecordInfo.stPlateImage.udwSize)
                        {
                        	String strFileName = NetDemo.strPicturePath + strTime +"Plate.jpg";
                            Common.savePicture(stRecordInfo.stPlateImage.pcData, stRecordInfo.stPlateImage.udwSize, strFileName);
                        }
                        else
                        {
                        	System.out.println("stPlateImage failed");
                        }

                        /* 全景图 */
                        NETDEV_FILE_INFO_S stFileInfo = new NETDEV_FILE_INFO_S();
                        stFileInfo.udwSize = 1048576;
                        stFileInfo.pcData = new Memory(stFileInfo.udwSize);
                        boolean iRet = NetDemo.netdevsdk.NETDEV_GetVehicleRecordImageInfo(NetDemo.lpUserID, stRecordInfo.udwRecordID, stFileInfo);
                        if(iRet == true)
                        {
                        	String strFileName = NetDemo.strPicturePath + strTime +"VehiclePanoImage.jpg";
                            Common.savePicture(stFileInfo.pcData, stFileInfo.udwSize, strFileName);
                        }
                        else 
                        {
                            System.out.println("NETDEV_GetVehicleRecordImage failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                        }
                    }
                    else
                    {
                        System.out.println("Get picture failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                        break;
                    }
                }
                bRet = NetDemo.netdevsdk.NETDEV_FindCloseVehicleRecordList(lpFindVehicleRecordHandlePointer);
                if(false == bRet){
                    System.out.printf("NETDEV_FindCloseVehicleRecordList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
            }
            else 
            {
                 JOptionPane.showMessageDialog(null, "Query ended");
                  break;
            }
            if(stFindCond.dwFirstRow >= stResultInfo.udwTotal)
            {
                break;
            }
            stFindCond.dwFirstRow += stFindCond.dwPageRow;
        }
    
    }
}
