﻿// CCDLgAddDevice.cpp : 
//

#include "stdafx.h"
#include "NetDemo.h"
#include "DLgAddDevice.h"


// CDLgAddDevice 

IMPLEMENT_DYNAMIC(CDlgAddDevice, CDialog)

CDlgAddDevice::CDlgAddDevice(CWnd* pParent /*=NULL*/)
    : CDialog(CDlgAddDevice::IDD, pParent)
    , m_udwDeviceType(0)
{
    m_dwPort = 80;
}

CDlgAddDevice::~CDlgAddDevice()
{
}

void CDlgAddDevice::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_IP_DOMAIN_NAME, m_strIP);
    DDX_Text(pDX, IDC_EDIT_PORT, m_dwPort);
    DDX_Text(pDX, IDC_EDIT_NAME, m_strUsername);
    DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassword);
    DDX_Control(pDX, IDC_COMBO_DEVICE_TYPE, m_oDeviceType);
    DDX_CBIndex(pDX, IDC_COMBO_DEVICE_TYPE, m_udwDeviceType);
}

BOOL CDlgAddDevice::OnInitDialog()
{
    CDialog::OnInitDialog();

    InitCombo();
    return TRUE;
}

BEGIN_MESSAGE_MAP(CDlgAddDevice, CDialog)
    ON_BN_CLICKED(IDC_ADD_DEVICE, &CDlgAddDevice::OnBnClickedAddDevice)
    ON_BN_CLICKED(IDC_CANCEL, &CDlgAddDevice::OnBnClickedCancel)
END_MESSAGE_MAP()

void CDlgAddDevice::InitCombo()
{
    m_oDeviceType.InsertString(0,_T("IPC/ NVR"));
    m_oDeviceType.InsertString(1,_T("VMS"));
    m_oDeviceType.SetCurSel(0);

    return;
}
void CDlgAddDevice::OnBnClickedAddDevice()
{
    CDialog::OnOK();
    UpdateData();

    if (m_strUsername.IsEmpty() || m_strPassword.IsEmpty() || m_strIP.IsEmpty())
    {
        return;
    }

    NETDEMO_DEVICE_INFO stLocalDeviceInfo;
    memset(&stLocalDeviceInfo, 0, sizeof(stLocalDeviceInfo));

    stLocalDeviceInfo.stDevInfo.dwDevType = m_udwDeviceType;
    strncpy(stLocalDeviceInfo.szIPAddr, m_strIP.GetBuffer(0), sizeof(stLocalDeviceInfo.szIPAddr) - 1);
    stLocalDeviceInfo.dwDevPort = m_dwPort;
    strncpy(stLocalDeviceInfo.szDevUserName, m_strUsername.GetBuffer(0), sizeof(stLocalDeviceInfo.szDevUserName) - 1);
    strncpy(stLocalDeviceInfo.szPassword, m_strPassword.GetBuffer(0), sizeof(stLocalDeviceInfo.szPassword) - 1);

    stLocalDeviceInfo.dwLoginType = NETDEMO_LOGTYPE_LOCAL;
    stLocalDeviceInfo.dwDeviceIndex = 0;

    if (NETDEMO_DEV_VMS == m_udwDeviceType)
    {
        stLocalDeviceInfo.stDevBasicInfo.dwAccessProtocol = NETDEV_LOGIN_PROTO_PRIVATE;
        stLocalDeviceInfo.stDevBasicInfo.dwDevType = NETDEV_DTYPE_VMS;
    }
    else
    {
        stLocalDeviceInfo.stDevBasicInfo.dwAccessProtocol = NETDEV_LOGIN_PROTO_ONVIF;
    }

    GetParent()->SendMessage(WM_ADD_DEVICE, WPARAM(NETDEMO_LOGTYPE_LOCAL), (LPARAM)&stLocalDeviceInfo);
}

void CDlgAddDevice::OnBnClickedCancel()
{
    EndDialog(-1);
}

