// ProduceSafe.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "ProduceSafe.h"


// CProduceSafe Ի

IMPLEMENT_DYNAMIC(CProduceSafe, CDialog)
UINT32 m_udwImageNum = 0;

CProduceSafe::CProduceSafe(CWnd* pParent /*=NULL*/)
    : CDialog(CProduceSafe::IDD, pParent)
    , tAlarmTime(0)
    , m_udwSeq(0)
    , m_strRelatedID(_T("0"))
    , m_strSourceName(_T("0"))
    , m_strAlarmType(_T("0"))
{
    m_dwSubID = -1;
}

CProduceSafe::~CProduceSafe()
{
}

void CProduceSafe::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_EDIT2, tAlarmTime);
    DDX_Text(pDX, IDC_EDIT3, m_udwSeq);
    DDX_Text(pDX, IDC_EDIT4, m_strSourceName);
    DDX_Text(pDX, IDC_EDIT5, m_strRelatedID);
    DDX_Text(pDX, IDC_EDIT4, m_strSourceName);
    DDX_Text(pDX, IDC_EDIT1, m_strAlarmType);
}


BEGIN_MESSAGE_MAP(CProduceSafe, CDialog)
    ON_BN_CLICKED(IDC_BUTTON1, &CProduceSafe::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CProduceSafe::OnBnClickedButton2)
END_MESSAGE_MAP()

BOOL CProduceSafe::OnInitDialog()
{

    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);

    return TRUE;
}

void STDCALL AlarmMsgCallBack_PF_LAPI_PIC(IN LPVOID lpUserID,
                                          IN LPNETDEV_ALARM_PIC_DATA_S pstAlarmPicData,
                                          IN LPVOID    lpUserData
                                          )
{
    if(NULL != pstAlarmPicData)
    {
        CProduceSafe* pBasicInfo = (CProduceSafe*)lpUserData;
        FILE* fp;
        for(UINT32 i = 0 ;i< pstAlarmPicData->udwImageNum; i++)
        {
            if(NULL != pstAlarmPicData->pstImageInfo[i].pszData)
            {
                CString strImageNum = "";
                strImageNum.Format("%d_%d_%d", m_udwImageNum, pstAlarmPicData->stAlarmPicBaseInfo.udwAlarmType, pstAlarmPicData->pstImageInfo[i].udwIndex);
                CString strFileName = gstLocalParam.szPictureSavePath + CString("\\")  +  strImageNum +  CString(".jpg") ;
                fp = fopen(strFileName, "wb+");
                fwrite(pstAlarmPicData->pstImageInfo[i].pszData, pstAlarmPicData->pstImageInfo[i].udwSize, 1, fp);
                fclose(fp);
                m_udwImageNum ++;
            }
        }

        if(1423 == pstAlarmPicData->stAlarmPicBaseInfo.udwAlarmType)
        {
            pBasicInfo->m_strAlarmType = "SafetyHelmetAlarm";
        }
        else if(1424 == pstAlarmPicData->stAlarmPicBaseInfo.udwAlarmType)
        {
            pBasicInfo->m_strAlarmType = "WorkClothesAlarm";
        }
        else
        {
            pBasicInfo->m_strAlarmType = "No such Alarm";
        }
        pBasicInfo->tAlarmTime = pstAlarmPicData->stAlarmPicBaseInfo.tTimeStamp;
        pBasicInfo->m_udwSeq = pstAlarmPicData->stAlarmPicBaseInfo.udwSeq;
        pBasicInfo->m_strSourceName = pstAlarmPicData->stAlarmPicBaseInfo.szSourceName;
        pBasicInfo->m_strRelatedID = pstAlarmPicData->stAlarmPicBaseInfo.szRelatedID;
        pBasicInfo->UpdateData(FALSE);

    }
    return;
}


// CProduceSafe Ϣ

void CProduceSafe::OnBnClickedButton1()
{
    UpdateData(TRUE);
    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();

    NETDEV_LAPI_SUB_INFO_S stSubInfo = {0};
    stSubInfo.udwType = 8192;

    NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo ={0};
    BOOL bRet = NETDEV_SubscibeLapiAlarm(lpDevHandle, &stSubInfo, &stSubSuccInfo);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_SubscibeLapiAlarm");
        return;
    }
    else
    {
        NETDEMO_LOG_SUCC(NULL, "NETDEV_SubscibeLapiAlarm");
    }

    m_dwSubID = stSubSuccInfo.udwID;
    bRet = NETDEV_SetPicAlarmCallBack(lpDevHandle,AlarmMsgCallBack_PF_LAPI_PIC,this);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_SetPicAlarmCallBack");
        return;
    }
    else
    {
        NETDEMO_LOG_SUCC(NULL, "NETDEV_SetPicAlarmCallBack");
    }
    return;
}

void CProduceSafe::OnBnClickedButton2()
{
    UpdateData(TRUE);
    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();

    BOOL bRet = NETDEV_UnSubLapiAlarm(lpDevHandle, m_dwSubID);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_UnSubLapiAlarm");
        return;
    }
    else
    {
        NETDEMO_LOG_SUCC(NULL, "NETDEV_UnSubLapiAlarm");
    }
    return;
}
