// RealtimeMonitoring.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "RealtimeMonitoring.h"
#include "NetDemo.h"

void UTCTime2LocalTime(INT32 dwUTCtime, CString& strAlarmTime)
{
	INT64 dwAlarmTime = dwUTCtime;
	tm *pTime = localtime((time_t*)&dwAlarmTime);
	strAlarmTime.Format("%d-%02d-%02d %02d:%02d:%02d",pTime->tm_year + 1900,pTime->tm_mon+1,pTime->tm_mday,pTime->tm_hour,pTime->tm_min,pTime->tm_sec);

	return;
}

void STDCALL PersonAlarmCallBack(IN LPVOID lpUserID,IN LPNETDEV_PERSON_EVENT_INFO_S pstAlarmData,IN LPVOID  lpUserData)
{
	if (NULL != pstAlarmData)
	{
		CRealtimeMonitoring* pRealtimeMonitoring = (CRealtimeMonitoring*)lpUserData;
		if (NULL != pstAlarmData->stCtrlFaceInfo->stCompareInfo.stFaceImage.pcData &&
			0 != pstAlarmData->stCtrlFaceInfo->stCompareInfo.stFaceImage.udwSize)
		{
			FILE* fp;
			CString strFileName = gstLocalParam.szPictureSavePath + CString("\\") + CString("FaceImage.jpg");
			fp = fopen(strFileName, "wb+");
			fwrite(pstAlarmData->stCtrlFaceInfo->stCompareInfo.stFaceImage.pcData, pstAlarmData->stCtrlFaceInfo->stCompareInfo.stFaceImage.udwSize, 1, fp);
			fclose(fp);
			pRealtimeMonitoring->m_oMatchPic.SetImageFile(strFileName);
		}
		
		CString strAlarmTime;
		UTCTime2LocalTime(pstAlarmData->stCtrlFaceInfo->tPassingTime, strAlarmTime);
		CString strInfo;
		strInfo.Format("%s:Similarity(%d)", pstAlarmData->stCtrlFaceInfo->szChlName, pstAlarmData->stCtrlFaceInfo->stCompareInfo.udwSimilarity);
		CString strMathInfo;
		strMathInfo = strAlarmTime + "  " + strInfo;
		pRealtimeMonitoring->m_strMathInfo = strMathInfo;
		pRealtimeMonitoring->UpdateData(FALSE);
	}
}
void STDCALL VehicleAlarmMessCallBack(IN LPVOID lpUserID,
									  IN LPNETDEV_VEH_RECOGNITION_EVENT_S pstVehicleAlarmInfo,
									  IN LPVOID lpBuf,
									  IN INT32 dwBufLen,
									  IN LPVOID lpUserData)
{
	if (NULL != pstVehicleAlarmInfo)
	{
		CRealtimeMonitoring* pRealtimeMonitoring = (CRealtimeMonitoring*)lpUserData;
		FILE* fp;
		for (int i=0; i<pstVehicleAlarmInfo->stVehicleEventInfo.udwVehicleInfoNum; i++)
		{
			if (NULL != pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].stPlateImage.pcData)
			{
				CString strFileName = gstLocalParam.szPictureSavePath + CString("\\") + CString("VehicleImage.jpg");
				fp = fopen(strFileName, "wb+");
				fwrite(pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].stPlateImage.pcData, pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].stPlateImage.udwSize, 1, fp);
				fclose(fp);
				pRealtimeMonitoring->m_oMatchPic.SetImageFile(strFileName);
			}
			CString strAlarmTime;
			UTCTime2LocalTime(pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].udwPassingTime, strAlarmTime);
			CHAR szTmp[NETDEV_LEN_64] = {0};
			UTF8ToMB(pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].stPlateAttr.szPlateNo, szTmp, sizeof(szTmp) - 1);

			CString strInfo;
			strInfo.Format("%s:No(%s)", pstVehicleAlarmInfo->stVehicleEventInfo.pstVehicleRecordInfo[i].szChannelName, szTmp);
			CString strMathInfo;
			strMathInfo = strAlarmTime + "   " + strInfo;
			pRealtimeMonitoring->m_strMathInfo = strMathInfo;
			pRealtimeMonitoring->UpdateData(FALSE);
		}
	}
}


void STDCALL StructAlarmCallBack(IN LPVOID lpUserID, IN LPNETDEV_STRUCT_ALARM_INFO_S pstAlarmInfo, IN LPNETDEV_STRUCT_DATA_INFO_S pstAlarmData, IN LPVOID  lpUserData)
{
	if (NULL != pstAlarmData && NULL != pstAlarmInfo)
	{
		CRealtimeMonitoring* pRealtimeMonitoring = (CRealtimeMonitoring*)lpUserData;

		CString strAlarmTime;
		UTCTime2LocalTime(pstAlarmInfo->udwTimeStamp, strAlarmTime);
		CString strInfo;
		strInfo.Format("%s:Reference(%s)", pstAlarmInfo->szSrcName, pstAlarmInfo->szReference);
		CString strRecogizeInfo;
		strRecogizeInfo = strAlarmTime + "   " + strInfo;
		pRealtimeMonitoring->m_strRecogizeInfo = strRecogizeInfo;
		pRealtimeMonitoring->UpdateData(FALSE);

		FILE* fp;
		CString strFileName = gstLocalParam.szPictureSavePath + CString("\\") + CString("StructImage.jpg");
		if (0 == pRealtimeMonitoring->m_nType)
		{
			if(NULL != pstAlarmData->stObjectInfo.pstFaceInfo && 0 <pstAlarmData->stObjectInfo.udwFaceNum && NULL != pstAlarmData->pstImageInfo && 0 < pstAlarmData->udwImageNum)
			{
				for(UINT32 i = 0; i < pstAlarmData->stObjectInfo.udwFaceNum; i++)
				{
					for(UINT32 j = 0;j < pstAlarmData->udwImageNum; j++)
					{
						if(pstAlarmData->stObjectInfo.pstFaceInfo[i].udwLargePicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
						else if(pstAlarmData->stObjectInfo.pstFaceInfo[i].udwSmallPicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
					}
				}
			}

			if(NULL != pstAlarmData->stObjectInfo.udwPersonNum && 0 <pstAlarmData->stObjectInfo.udwPersonNum &&  NULL != pstAlarmData->pstImageInfo && 0 < pstAlarmData->udwImageNum)
			{
				for(UINT32 i = 0; i < pstAlarmData->stObjectInfo.udwPersonNum; i++)
				{
					for(UINT32 j = 0;j < pstAlarmData->udwImageNum; j++)
					{
						if(pstAlarmData->stObjectInfo.pstPersonInfo[i].udwLargePicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
						else if(pstAlarmData->stObjectInfo.pstPersonInfo[i].udwSmallPicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
					}

                    /* ӡԱ */
                    /* NETDEMO_LOG_SUCC(NULL, "Gender: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwGender);
                    NETDEMO_LOG_SUCC(NULL, "AgeRange: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwAgeRange);
                    NETDEMO_LOG_SUCC(NULL, "MaskFlag: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwMask);
                    NETDEMO_LOG_SUCC(NULL, "CoatColor: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwCoatColor);
                    NETDEMO_LOG_SUCC(NULL, "TrousersColor: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwTrousersColor);
                    NETDEMO_LOG_SUCC(NULL, "SleevesLength: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwSleevesLength);
                    NETDEMO_LOG_SUCC(NULL, "TrousersLength: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwTrousersLength);
                    NETDEMO_LOG_SUCC(NULL, "CoatTexture: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwCoatTexture);
                    NETDEMO_LOG_SUCC(NULL, "BagFlag: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwBagFlag);
                    NETDEMO_LOG_SUCC(NULL, "BodyToward: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwBodyToward);
                    NETDEMO_LOG_SUCC(NULL, "ShoesTubeLength: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwShoesTubeLength);
                    NETDEMO_LOG_SUCC(NULL, "HairLength: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwHairLength);
                    NETDEMO_LOG_SUCC(NULL, "MovingDirection: %d ",pstAlarmData->stObjectInfo.pstPersonInfo->stPersonAttr.udwMovingDirection); */
				}
			}
		}
		else
		{
			if(NULL != pstAlarmData->stObjectInfo.pstNonMotorVehInfo && 0 <pstAlarmData->stObjectInfo.udwNonMotorVehNum &&  NULL != pstAlarmData->pstImageInfo && 0 < pstAlarmData->udwImageNum)
			{
				for(UINT32 i = 0; i < pstAlarmData->stObjectInfo.udwNonMotorVehNum; i++)
				{
					for(UINT32 j = 0;j < pstAlarmData->udwImageNum; j++)
					{
						if(pstAlarmData->stObjectInfo.pstNonMotorVehInfo[i].udwLargePicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
						else if(pstAlarmData->stObjectInfo.pstNonMotorVehInfo[i].udwSmallPicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
					}
				}
			}

			if(NULL != pstAlarmData->stObjectInfo.pstVehInfo && 0 <pstAlarmData->stObjectInfo.udwVehicleNum &&  NULL != pstAlarmData->pstImageInfo && 0 < pstAlarmData->udwImageNum)
			{
				for(UINT32 i = 0; i < pstAlarmData->stObjectInfo.udwVehicleNum; i++)
				{
					for(UINT32 j = 0;j < pstAlarmData->udwImageNum; j++)
					{
						if(pstAlarmData->stObjectInfo.pstVehInfo[i].udwLargePicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							if (0 != strcmp(pstAlarmData->pstImageInfo[j].szUrl, ""))
							{
								CHAR* szData = new CHAR[pstAlarmData->pstImageInfo[j].udwSize];
								NETDEV_GetSystemPicture(lpUserID, pstAlarmData->pstImageInfo[j].szUrl, pstAlarmData->pstImageInfo[j].udwSize, szData);
								fwrite(szData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
								delete [] szData;
							}
							else
							{
								fwrite(pstAlarmData->pstImageInfo[j].pszData, pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							}
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
						else if(pstAlarmData->stObjectInfo.pstVehInfo[i].udwSmallPicAttachIndex == pstAlarmData->pstImageInfo[j].udwIndex)
						{
							fp = fopen(strFileName, "wb+");
							fwrite(pstAlarmData->pstImageInfo[j].pszData,pstAlarmData->pstImageInfo[j].udwSize, 1, fp);
							fclose(fp);
							pRealtimeMonitoring->m_oRecogizePic.SetImageFile(strFileName);
							continue;
						}
					}
				}
			}
		}
	}
	return ;
}


// CRealtimeMonitoring Ի

IMPLEMENT_DYNAMIC(CRealtimeMonitoring, CDialog)

CRealtimeMonitoring::CRealtimeMonitoring(CWnd* pParent /*=NULL*/)
	: CDialog(CRealtimeMonitoring::IDD, pParent)
	, m_strMathInfo(_T(""))
	, m_strRecogizeInfo(_T(""))
{
	m_nType = 0;
	m_nMathSubID = 0;
	m_nRecogizeSubID = 0;
}

CRealtimeMonitoring::~CRealtimeMonitoring()
{
}

void CRealtimeMonitoring::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_PERSON_MATCH_PIC, m_oMatchPic);
	DDX_Control(pDX, IDC_STATIC_PERSON_RECOGNIZE_PIC, m_oRecogizePic);
	DDX_Text(pDX, IDC_EDIT_PERSON_MATCH, m_strMathInfo);
	DDX_Text(pDX, IDC_EDIT_PERSON_RECOGNIZE, m_strRecogizeInfo);
}


BEGIN_MESSAGE_MAP(CRealtimeMonitoring, CDialog)
	ON_BN_CLICKED(IDC_BTN_PERSON_MATCH_START, &CRealtimeMonitoring::OnBnClickedBtnPersonMatchStart)
	ON_BN_CLICKED(IDC_BTN_PERSON_MATCH_Stop, &CRealtimeMonitoring::OnBnClickedBtnPersonMatchStop)
	ON_BN_CLICKED(IDC_BTN_PERSON_RECOGNIZE_START, &CRealtimeMonitoring::OnBnClickedBtnPersonRecognizeStart)
	ON_BN_CLICKED(IDC_BTN_PERSON_RECOGNIZE_STOP, &CRealtimeMonitoring::OnBnClickedBtnPersonRecognizeStop)
END_MESSAGE_MAP()


// CRealtimeMonitoring Ϣ
BOOL CRealtimeMonitoring::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rc(0, 0, 0, 0);
	GetParent()->GetClientRect(&rc);
	((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
	MoveWindow(&rc);

	InitCtrl();
	return TRUE;
}

void CRealtimeMonitoring::SetType(INT32 nType)
{
	m_nType = nType;
}

void CRealtimeMonitoring::InitCtrl()
{
	if(0 == m_nType)
	{
		GetDlgItem(IDC_STATIC_PERSON_MATCH)->SetWindowText("Person Match");
		GetDlgItem(IDC_STATIC_PERSON_RECOGNIZE)->SetWindowText("Person Recognize");
	}
	else
	{
		GetDlgItem(IDC_STATIC_PERSON_MATCH)->SetWindowText("Vehicle Match");
		GetDlgItem(IDC_STATIC_PERSON_RECOGNIZE)->SetWindowText("Vehicle Recognize");
	}
}
void CRealtimeMonitoring::OnBnClickedBtnPersonMatchStart()
{
	// TODO: ڴӿؼ֪ͨ
	LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
	NETDEV_LAPI_SUB_INFO_S stSubInfo = {0};
	NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = {0};
	if(0 == m_nType)
	{
		//עƥݻص
		NETDEV_SetPersonAlarmCallBack(lpDevHandle,PersonAlarmCallBack,this);
		stSubInfo.udwType = 16;
	}
	else
	{
		//עᳵƥݻص
		NETDEV_SetVehicleAlarmCallBack(lpDevHandle,VehicleAlarmMessCallBack,this);
		stSubInfo.udwType = 64;
	}
	if(NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
	{
		//VMS豸ҪNETDEV_SetAlarmCallBack_V30,ǰDemoڵ¼ʱѵá
        stSubInfo.udwLibIDNum = 0;
        NETDEV_UnSubLapiAlarm(lpDevHandle ,m_nMathSubID);
        BOOL bRet = NETDEV_SubscibeLapiAlarm(lpDevHandle, &stSubInfo, &stSubSuccInfo);
        if (FALSE == bRet)
        {
            MessageBox("Subscibe Alarm failed.");
            return;
        }
        m_nMathSubID = stSubSuccInfo.udwID;
	}
	else
	{
		
		stSubInfo.udwLibIDNum = 0xffff;
		NETDEV_UnSubLapiAlarm(lpDevHandle ,m_nMathSubID);
		BOOL bRet = NETDEV_SubscibeLapiAlarm(lpDevHandle, &stSubInfo, &stSubSuccInfo);
		if (FALSE == bRet)
		{
			MessageBox("Subscibe Alarm failed.");
			return;
		}
		m_nMathSubID = stSubSuccInfo.udwID;
	}
}

void CRealtimeMonitoring::OnBnClickedBtnPersonMatchStop()
{
	// TODO: ڴӿؼ֪ͨ

	LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();

	if(0 == m_nType)
	{
		//עƥݻص
		NETDEV_SetPersonAlarmCallBack(lpDevHandle,NULL,this);
	}
	else
	{
		//עᳵƥݻص
		NETDEV_SetVehicleAlarmCallBack(lpDevHandle,NULL,this);
	}

	NETDEV_UnSubLapiAlarm(lpDevHandle ,m_nMathSubID);
}

void CRealtimeMonitoring::OnBnClickedBtnPersonRecognizeStart()
{
	// TODO: ڴӿؼ֪ͨ
	LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
	NETDEV_LAPI_SUB_INFO_S stSubInfo = {0};
	NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = {0};
	//עṹݻص
	OnBnClickedBtnPersonRecognizeStop();
	NETDEV_SetStructAlarmCallBack(lpDevHandle,StructAlarmCallBack,this);
	if(NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
	{
		INT32 dwCurDevIndex = ga_pMainDlg->GetCurDeviceIndex();
		INT32 dwCurChnID = ga_pMainDlg->GetCurChlIndex();
		INT32 dwCurWinID = ga_pMainDlg->GetCurWinID();
        if(gastLoginDeviceInfo.stDevLoginInfo[dwCurDevIndex].vecChanInfo.size() <= dwCurChnID)
        {
            NETDEMO_LOG_ERROR(NULL, "Please select device");
            return;
        }
		INT32 dwChannelID = gastLoginDeviceInfo.stDevLoginInfo[dwCurDevIndex].vecChanInfo[dwCurChnID].stChnBaseInfo.dwChannelID;
		
		NETDEV_SUBSCRIBE_SMART_INFO_S stSubscribeInfo;
		stSubscribeInfo.udwNum = 1;
		stSubscribeInfo.pudwSmartType = new UINT32();
		if(0 == m_nType)
		{
			*stSubscribeInfo.pudwSmartType = NETDEV_SMART_ALARM_TYPE_FACE_SNAP;
		}
		else
		{
			*stSubscribeInfo.pudwSmartType = NETDEV_SMART_ALARM_TYPE_VEHICLE_SNAP;
		}

		NETDEV_SMART_INFO_S stSmartInfo;
		stSmartInfo.dwChannelID = dwChannelID;
		BOOL bRet = NETDEV_SubscribeSmart(gastLoginDeviceInfo.pHandle, &stSubscribeInfo, &stSmartInfo);
		if(FALSE == bRet){
			MessageBox("Subscibe Alarm failed.");
			return;
		}

		m_nRecogizeSubID = stSmartInfo.udwSubscribeID;
	}
	else
	{
		stSubInfo.udwType = 32;
		stSubInfo.udwLibIDNum = 0xffff;
		BOOL bRet = NETDEV_SubscibeLapiAlarm(lpDevHandle, &stSubInfo, &stSubSuccInfo);
		if (FALSE == bRet)
		{
			MessageBox("Subscibe Alarm failed.");
			return;
		}
		m_nRecogizeSubID = stSubSuccInfo.udwID;
	}
}

void CRealtimeMonitoring::OnBnClickedBtnPersonRecognizeStop()
{
	// TODO: ڴӿؼ֪ͨ
	LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
	NETDEV_SetStructAlarmCallBack(lpDevHandle,NULL,this);
	if(NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
	{
		INT32 dwCurDevIndex = ga_pMainDlg->GetCurDeviceIndex();
		INT32 dwCurChnID = ga_pMainDlg->GetCurChlIndex();
		INT32 dwCurWinID = ga_pMainDlg->GetCurWinID();
        if(gastLoginDeviceInfo.stDevLoginInfo[dwCurDevIndex].vecChanInfo.size() <= dwCurChnID)
        {
            NETDEMO_LOG_ERROR(NULL, "Please select device");
            return;
        }
		INT32 dwChannelID = gastLoginDeviceInfo.stDevLoginInfo[dwCurDevIndex].vecChanInfo[dwCurChnID].stChnBaseInfo.dwChannelID;
		NETDEV_SMART_INFO_S stSmartInfo = {0};
		stSmartInfo.dwChannelID = dwChannelID;
		stSmartInfo.udwSubscribeID = m_nRecogizeSubID;
		NETDEV_UnsubscribeSmart(gastLoginDeviceInfo.pHandle, &stSmartInfo);
	}
	else
	{
		NETDEV_UnSubLapiAlarm(lpDevHandle ,m_nRecogizeSubID);
	}
}
