package main.java.com.netdevsdk.demo.config.basic;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DISK_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DISK_INFO_S;

/**
 * 
 * @introduction Hard disk information
 * @description Support NVR/VMS
 */
public class HardDisk {
    
    /**
     * 
     * @introduction Get the hard disk information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getHardDiskInformation() {
		NetDemo.ConfigBasicHardDiskTableModel.setRowCount(0);
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_DISK_INFO_LIST_S stDiskInfoList = new NETDEV_DISK_INFO_LIST_S();
		for(int i = 0; i < NetDEVSDKLib.NETDEV_DISK_MAX_NUM; i++)
		{
			stDiskInfoList.astDisksInfo[i] = new NETDEV_DISK_INFO_S();
		}
		stDiskInfoList.write();

		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DISKSINFO, stDiskInfoList.getPointer(), stDiskInfoList.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed, error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stDiskInfoList.read();
			for(int i=0; i<stDiskInfoList.dwSize; i++)
			{
				Vector<String> vector = new Vector<String>();
		        vector.add(String.valueOf(i+1));
		        vector.add(String.valueOf(stDiskInfoList.astDisksInfo[i].dwTotalCapacity));
		        vector.add(String.valueOf(stDiskInfoList.astDisksInfo[i].dwUsedCapacity));
		        vector.add(Common.EnumNETDEV_DISK_WORK_STATUS_EConventToString(stDiskInfoList.astDisksInfo[i].enStatus));
		        vector.add(Common.byteArrayToString(stDiskInfoList.astDisksInfo[i].szManufacturer));
		        NetDemo.ConfigBasicHardDiskTableModel.insertRow(i,vector);
			}
        }
	}
}
