package main.java.com.netdevsdk.demo.config.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JDialog;
import javax.swing.JPanel;

import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_REV_TIMEOUT_S;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.util.InputMismatchException;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import java.awt.Color;

public class SettingWindow extends JDialog{
	private static final long serialVersionUID = 1L;

	JPanel  SettingWindowPanel = new JPanel();

	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	private JTextField textFileTimeOut;
	private JTextField textWaitTimes;
	private JTextField textTryTimes;
	private JTextField textFileLogSize;
	private JTextField textFileNum;
	
	public SettingWindow() {
		this.setSize(700,600);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Log Setting");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(SettingWindowPanel, BorderLayout.CENTER);
        SettingWindowPanel.setLayout(null);
        
        JPanel panelRevSetting = new JPanel();
        panelRevSetting.setBorder(new TitledBorder(null, "Rev Time Out", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        panelRevSetting.setBounds(22, 20, 289, 132);
        SettingWindowPanel.add(panelRevSetting);
        panelRevSetting.setLayout(null);
        
        JLabel lblRevTimeOut = new JLabel("Rev Time Out");
        lblRevTimeOut.setBounds(28, 29, 92, 15);
        panelRevSetting.add(lblRevTimeOut);
        
        JTextField textRevTimeOut = new JTextField();
        textRevTimeOut.setBounds(130, 26, 66, 21);
        panelRevSetting.add(textRevTimeOut);
        textRevTimeOut.setColumns(10);
        textRevTimeOut.setText("10");
        
        
        JLabel lblRevTimeOutS = new JLabel("s");
        lblRevTimeOutS.setBounds(204, 29, 54, 15);
        panelRevSetting.add(lblRevTimeOutS);
        
        JLabel lblFileTimeOut = new JLabel("File Time Out");
        lblFileTimeOut.setBounds(28, 54, 92, 15);
        panelRevSetting.add(lblFileTimeOut);
        
        textFileTimeOut = new JTextField();
        textFileTimeOut.setBounds(130, 51, 66, 21);
        panelRevSetting.add(textFileTimeOut);
        textFileTimeOut.setColumns(10);
        textFileTimeOut.setText("70");

        JLabel lblFileTimeOutS = new JLabel("s");
        lblFileTimeOutS.setBounds(204, 54, 54, 15);
        panelRevSetting.add(lblFileTimeOutS);

        JPanel panelKeepAliveTime = new JPanel();
        panelKeepAliveTime.setBorder(new TitledBorder(null, "Keep Alive", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        panelKeepAliveTime.setBounds(355, 20, 319, 132);
        SettingWindowPanel.add(panelKeepAliveTime);
        panelKeepAliveTime.setLayout(null);
        
        JLabel lblWaitTimes = new JLabel("Wait Times");
        lblWaitTimes.setBounds(43, 33, 72, 15);
        panelKeepAliveTime.add(lblWaitTimes);
        
        JLabel lblTryTimes = new JLabel("Try Times");
        lblTryTimes.setBounds(43, 58, 72, 15);
        panelKeepAliveTime.add(lblTryTimes);
        
        textWaitTimes = new JTextField();
        textWaitTimes.setBounds(125, 30, 66, 21);
        panelKeepAliveTime.add(textWaitTimes);
        textWaitTimes.setColumns(10);
        textWaitTimes.setText("10");
        
        textTryTimes = new JTextField();
        textTryTimes.setBounds(125, 55, 66, 21);
        panelKeepAliveTime.add(textTryTimes);
        textTryTimes.setColumns(10);
        textTryTimes.setText("10");
        
        JLabel lblWaitTimesS = new JLabel("s");
        lblWaitTimesS.setBounds(201, 33, 54, 15);
        panelKeepAliveTime.add(lblWaitTimesS);
        
        JLabel lblTryTimesS = new JLabel("s");
        lblTryTimesS.setBounds(201, 58, 54, 15);
        panelKeepAliveTime.add(lblTryTimesS);
        
        JButton btnKeepAliveTimesSave = new JButton("Save");
        btnKeepAliveTimesSave.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		
        		String WaitTimes=textWaitTimes.getText();
        		int getWaitTimes=10;
        		if(WaitTimes==null||WaitTimes.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input WaitTimes parameter");
					return;
				}
				try {
					getWaitTimes=Integer.parseInt(WaitTimes);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "WaitTimes is null or transformation Exception");
					return;
				}
				if(getWaitTimes<1) {
					JOptionPane.showMessageDialog(null, "WaitTimes can not less than one");
					return;
				}
				if(getWaitTimes>300) {
					JOptionPane.showMessageDialog(null, "WaitTimes can not more than three hundred");
					return;
				}
				
				String tryTimes=textTryTimes.getText();
				int getTryTimes=10;
				
				if(tryTimes==null||tryTimes.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input tryTimes parameter");
					return;
				}
				try {
					getTryTimes=Integer.parseInt(tryTimes);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "TryTimes is null or transformation Exception");
					return;
				}
				if(getTryTimes<1 || getTryTimes>300) {
					JOptionPane.showMessageDialog(null, "TryTimes should between 1 and 300");
					return;
				}
				
				boolean rbet=netdevsdk.NETDEV_SetConnectTime(getWaitTimes, getTryTimes);
				if(rbet) {
					JOptionPane.showMessageDialog(null, "Set success");
				}else {
					System.out.println("失败"+netdevsdk.NETDEV_GetLastError());
					JOptionPane.showMessageDialog(null, "Set failed");
					return;
				}
        	}
        });
        btnKeepAliveTimesSave.setBounds(216, 99, 93, 23);
        panelKeepAliveTime.add(btnKeepAliveTimesSave);
          
        JButton btnSave = new JButton("Save");
        btnSave.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		
        		String RevTimeOut=textRevTimeOut.getText();
				int getRevTimeOut=0;
				if(RevTimeOut==null||RevTimeOut.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input RevTimeOut parameter");
					return;
				}
				try {
					getRevTimeOut=Integer.parseInt(RevTimeOut);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "RevTimeOut is null or transformation Exception");
					return;
				}
				if(getRevTimeOut<1 || getRevTimeOut>300) {
					JOptionPane.showMessageDialog(null, "RevTimeOut should between 1 and 300");
					return;
				}	
				
				String fileTimeOut=textFileTimeOut.getText();
				int getFileTimeOut=0;
				
				if(fileTimeOut==null||fileTimeOut.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input fileTimeOut parameter");
					return;
				}
				try {
					getFileTimeOut=Integer.parseInt(fileTimeOut);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "FileTimeOut is null or transformation Exception");
					return;
				}
				if(getFileTimeOut<60 || getFileTimeOut>300) {
					JOptionPane.showMessageDialog(null, "FileTimeOut should between 60 and 300");
					return;
				}
				
				NETDEV_REV_TIMEOUT_S pstRevTimeout=new NETDEV_REV_TIMEOUT_S();
				pstRevTimeout.dwRevTimeOut=getRevTimeOut;
				pstRevTimeout.dwFileReportTimeOut=getFileTimeOut;
				pstRevTimeout.write();
				boolean rbet=netdevsdk.NETDEV_SetRevTimeOut(pstRevTimeout);
				if(rbet) {
					JOptionPane.showMessageDialog(null, "Set success");
					return;
				}else {
					System.out.println("failed"+netdevsdk.NETDEV_GetLastError());
					JOptionPane.showMessageDialog(null, "Set failed");
					return;
				}
        	}
        });
        btnSave.setBounds(186, 99, 93, 23);
        panelRevSetting.add(btnSave);
        
        JPanel panelConfigLogFile = new JPanel();
        panelConfigLogFile.setBorder(new TitledBorder(null, "Config LogFile", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        panelConfigLogFile.setBounds(355, 162, 319, 122);
        SettingWindowPanel.add(panelConfigLogFile);
        panelConfigLogFile.setLayout(null);
        
        JLabel lblFileSize = new JLabel("File Size");
        lblFileSize.setBounds(10, 26, 54, 15);
        panelConfigLogFile.add(lblFileSize);
        
        JLabel lblFilenum = new JLabel("File Num");
        lblFilenum.setBounds(10, 63, 54, 15);
        panelConfigLogFile.add(lblFilenum);
        
        textFileLogSize = new JTextField();
        textFileLogSize.setBounds(74, 23, 66, 21);
        panelConfigLogFile.add(textFileLogSize);
        textFileLogSize.setColumns(10);
        
        JLabel lblFileLogSizeByte = new JLabel("Byte");
        lblFileLogSizeByte.setBounds(144, 26, 54, 15);
        panelConfigLogFile.add(lblFileLogSizeByte);
        
        JLabel lblMax = new JLabel("Max 31457280B");
        lblMax.setForeground(Color.RED);
        lblMax.setBounds(187, 26, 95, 15);
        panelConfigLogFile.add(lblMax);
        
        textFileNum = new JTextField();
        textFileNum.setBounds(74, 60, 66, 21);
        panelConfigLogFile.add(textFileNum);
        textFileNum.setColumns(10);
        
        JButton btnConfigLogFileSave = new JButton("Save");
        btnConfigLogFileSave.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		
        		String fileLogSize=textFileLogSize.getText();
        		int getFileLogSize=1;
        		if(fileLogSize==null||fileLogSize.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input fileLogSize parameter");
					return;
				}
				try {
					getFileLogSize=Integer.parseInt(fileLogSize);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "FileLogSize is null or transformation Exception");
					return;
				}
				if(getFileLogSize<=0) {
					JOptionPane.showMessageDialog(null, "FileLogSizecan not less or equals zero");
					return;
				}
				if(getFileLogSize>31457280) {
					JOptionPane.showMessageDialog(null, "FileLogSize can not more than thirty megabytes");
					return;
				}
				
				
				String fileNum=textFileNum.getText();
				int getFileNum=1;
				if(fileNum==null||fileNum.equals("")) {
					JOptionPane.showMessageDialog(null, "Please input fileNum parameter");
					return;
				}
				try {
					getFileNum=Integer.parseInt(fileNum);
				}catch(NumberFormatException |InputMismatchException e2) {
					JOptionPane.showMessageDialog(null, "FileNum is null or transformation Exception");
					return;
				}
				if(getFileNum<1) {
					JOptionPane.showMessageDialog(null, "FileNum not less one");
					return;
				}
				boolean rbet= netdevsdk.NETDEV_ConfigLogFile(getFileLogSize, getFileNum);
				if(rbet) {
					JOptionPane.showMessageDialog(null, "Set success");
				}else {
					System.out.println("失败"+netdevsdk.NETDEV_GetLastError());
					JOptionPane.showMessageDialog(null, "Set failed");
					return;
				}
        	}
        });
        btnConfigLogFileSave.setBounds(216, 89, 93, 23);
        panelConfigLogFile.add(btnConfigLogFileSave);
        
        JPanel panelWriteLog = new JPanel();
        panelWriteLog.setBorder(new TitledBorder(null, "Write Log", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        panelWriteLog.setBounds(22, 162, 289, 122);
        SettingWindowPanel.add(panelWriteLog);
        panelWriteLog.setLayout(null);
        
        JCheckBox chckbxEnableWriteLogCheckBox = new JCheckBox("Enable");
        chckbxEnableWriteLogCheckBox.setBounds(84, 40, 103, 23);
        panelWriteLog.add(chckbxEnableWriteLogCheckBox);
        chckbxEnableWriteLogCheckBox.setSelected(true);
        
        JButton btnSetEnableWriteLog = new JButton("Set");
        btnSetEnableWriteLog.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
        		
        		int WriteLogFlag=1;
        		if(chckbxEnableWriteLogCheckBox.isSelected()) {
        			WriteLogFlag=1;
        		}else {
        			WriteLogFlag=0;
        		}
        		boolean rbet= netdevsdk.NETDEV_SetWriteLogFlag(WriteLogFlag);
        		if(rbet) {
        			JOptionPane.showMessageDialog(null, "Set success");
        		}else {
        			System.out.println("失败"+netdevsdk.NETDEV_GetLastError());
					JOptionPane.showMessageDialog(null, "Set failed");
					return;
        		}
        	}
        });
        btnSetEnableWriteLog.setBounds(186, 89, 93, 23);
        panelWriteLog.add(btnSetEnableWriteLog);
        }
}
