package main.java.com.netdevsdk.demo.config.image;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IMAGE_ENHANCE_S;

/**
 * 
 * @introduction Image information
 * @description
 */
public class ImageInfo {

    /**
     * 
     * @introduction Get image information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getImageInfo() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
		NETDEV_IMAGE_ENHANCE_S stImageEnhanceInfo = new NETDEV_IMAGE_ENHANCE_S();
		stImageEnhanceInfo.write();
		IntByReference dwBytesReturned = new IntByReference();//268ChannelID
		
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
				NetDemo.pstDeviceInfo.dwDeviceType ==NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
			NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(true);
			NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(true);
		}else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP) {
		    NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
			NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(true);
		}else {
			NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
    		NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(false);
		}
	
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_CHL_IMAGE_ENHANCE, stImageEnhanceInfo.getPointer(),stImageEnhanceInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stImageEnhanceInfo.read();
        	NetDemo.textFieldConfigImageInfoBrightness.setText(String.valueOf(stImageEnhanceInfo.udwBrightness));
        	NetDemo.textFieldConfigImageInfoSaturation.setText(String.valueOf(stImageEnhanceInfo.udwSaturation));
        	NetDemo.textFieldConfigImageInfoContrast.setText(String.valueOf(stImageEnhanceInfo.udwContrast));
        	NetDemo.textFieldConfigImageInfoSharpness.setText(String.valueOf(stImageEnhanceInfo.udwSharpness));
        	NetDemo.textFieldImageInfo2DNoiseReduce.setText(String.valueOf(stImageEnhanceInfo.udw2DNoiseReduce));
        	NetDemo.textFieldImageInfo3DNoiseReduce.setText(String.valueOf(stImageEnhanceInfo.udw3DNoiseReduce));
        }
	}
	
	/**
	 * 
	 * @introduction Set image information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setImageInfo() {
	    if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
		NETDEV_IMAGE_ENHANCE_S stImageEnhanceInfo = new NETDEV_IMAGE_ENHANCE_S();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_CHL_IMAGE_ENHANCE, stImageEnhanceInfo.getPointer(),stImageEnhanceInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stImageEnhanceInfo.read();
        	if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
        	        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
        	        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
    				NetDemo.pstDeviceInfo.dwDeviceType ==NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) { 
        		NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(true);
        		NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(true);
    			String FieldImageInfo3DNoiseReduce=NetDemo.textFieldImageInfo3DNoiseReduce.getText();
    			if(FieldImageInfo3DNoiseReduce==null||FieldImageInfo3DNoiseReduce.equals("")) {
    				JOptionPane.showMessageDialog(null, "3DNoiseReduce is null");
    				return;
    			}
    			
        		String FieldImageInfo2DNoiseReduce =NetDemo.textFieldImageInfo2DNoiseReduce.getText();
        		if(FieldImageInfo2DNoiseReduce==null||FieldImageInfo2DNoiseReduce.equals("")) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce is null");
        			return;
        		}
    			
    			int ImageInfo2DNoiseReduce=0;
        		try {
        			ImageInfo2DNoiseReduce=Integer.parseInt(FieldImageInfo2DNoiseReduce);
        		}catch(Exception ee) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce transformation Exception");
        			NetDemo.textFieldImageInfo2DNoiseReduce.setText(null);
        			return;
        		}
        		if(ImageInfo2DNoiseReduce<0 || ImageInfo2DNoiseReduce>255) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce should between 0 and 255 ");
        			NetDemo.textFieldImageInfo2DNoiseReduce.setText(null);
        			return;
        		}
        		stImageEnhanceInfo.udw2DNoiseReduce=ImageInfo2DNoiseReduce;
    			
    			int ImageInfo3DNoiseReduce=0;
    			try {
    				ImageInfo3DNoiseReduce=Integer.parseInt(FieldImageInfo3DNoiseReduce);
    			}catch(Exception ee) {
    				JOptionPane.showMessageDialog(null, "3DNoiseReduce transformation Exception");
    				NetDemo.textFieldImageInfo3DNoiseReduce.setText(null);
    				return;
    			}
    			if(ImageInfo3DNoiseReduce<0 || ImageInfo3DNoiseReduce>255) {
    				JOptionPane.showMessageDialog(null, "3DNoiseReduce should between 0 and 255 ");
    				NetDemo.textFieldImageInfo3DNoiseReduce.setText(null);
    				return;
    			}
    			stImageEnhanceInfo.udw3DNoiseReduce=ImageInfo3DNoiseReduce;
    			
    		}else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
    		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
    				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP) {
    			NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
        		NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(true);
    			String FieldImageInfo2DNoiseReduce =NetDemo.textFieldImageInfo2DNoiseReduce.getText();
        		if(FieldImageInfo2DNoiseReduce==null||FieldImageInfo2DNoiseReduce.equals("")) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce is null");
        			return;
        		}
    			
    			int ImageInfo2DNoiseReduce=0;
        		try {
        			ImageInfo2DNoiseReduce=Integer.parseInt(FieldImageInfo2DNoiseReduce);
        		}catch(Exception ee) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce transformation Exception");
        			NetDemo.textFieldImageInfo2DNoiseReduce.setText(null);
        			return;
        		}
        		if(ImageInfo2DNoiseReduce<0 || ImageInfo2DNoiseReduce>255) {
        			JOptionPane.showMessageDialog(null, "2DNoiseReduce should between 0 and 255 ");
        			NetDemo.textFieldImageInfo2DNoiseReduce.setText(null);
        			return;
        		}
        		stImageEnhanceInfo.udw2DNoiseReduce=ImageInfo2DNoiseReduce;
    		}else {
    			NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
        		NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(false);
    		}
        	
    		String udwBrightness=NetDemo.textFieldConfigImageInfoBrightness.getText();
    		if(udwBrightness==null||udwBrightness.equals("")) {
    			JOptionPane.showMessageDialog(null, "Brightness is null");
    			return;
    		}
    		
    		int getudwBrightness=0;
    		try {
    			getudwBrightness=Integer.parseInt(udwBrightness);
    		}catch(Exception ee) {
    			JOptionPane.showMessageDialog(null, "Brightness transformation Exception");
    			NetDemo.textFieldConfigImageInfoBrightness.setText(null);
    			return;
    		}
    		
    		if(getudwBrightness<0 || getudwBrightness>255) {
    			JOptionPane.showMessageDialog(null, "Brightness should between 0 and 255");
    			NetDemo.textFieldConfigImageInfoBrightness.setText(null);
    			return;
    		}
    		stImageEnhanceInfo.udwBrightness = getudwBrightness;
    		
    		String FieldConfigImageInfoSaturation=NetDemo.textFieldConfigImageInfoSaturation.getText();
    		if(FieldConfigImageInfoSaturation==null||FieldConfigImageInfoSaturation.equals("")) {
    			JOptionPane.showMessageDialog(null, "Saturation is null");
    			return;
    		}
    		
    		int ConfigImageInfoSaturation=0;
    		try {
    			ConfigImageInfoSaturation=Integer.parseInt(FieldConfigImageInfoSaturation);
    		}catch(Exception ee) {
    			JOptionPane.showMessageDialog(null, "Saturation transformation Exception");
    			NetDemo.textFieldConfigImageInfoSaturation.setText(null);
    			return;
    		}
    		
    		if(ConfigImageInfoSaturation<0 || ConfigImageInfoSaturation>255) {
    			JOptionPane.showMessageDialog(null, "Saturation should between 0 and 255");
    			NetDemo.textFieldConfigImageInfoSaturation.setText(null);
    			return;
    		}
    		stImageEnhanceInfo.udwSaturation = ConfigImageInfoSaturation;
    		
    		String FieldConfigImageInfoContrast=NetDemo.textFieldConfigImageInfoContrast.getText();
    		if(FieldConfigImageInfoContrast==null||FieldConfigImageInfoContrast.equals("")) {
    			JOptionPane.showMessageDialog(null, "Contrast is null");
    			return;
    		}

    		int ConfigImageInfoContrast=0;
    		try {
    			ConfigImageInfoContrast=Integer.parseInt(FieldConfigImageInfoContrast);
    		}catch(Exception ee) {
    			JOptionPane.showMessageDialog(null, "Contrast transformation Exception");
    			NetDemo.textFieldConfigImageInfoContrast.setText(null);
    			return;
    		}
    		
    		if(ConfigImageInfoContrast<0 || ConfigImageInfoContrast>255) {
    			JOptionPane.showMessageDialog(null, "Contrast should between 0 and 255");
    			NetDemo.textFieldConfigImageInfoContrast.setText(null);
    			return;
    		}
    		stImageEnhanceInfo.udwContrast = ConfigImageInfoContrast;
    		
    		String FieldConfigImageInfoSharpness=NetDemo.textFieldConfigImageInfoSharpness.getText();
    		if(FieldConfigImageInfoSharpness==null||FieldConfigImageInfoSharpness.equals("")) {
    			JOptionPane.showMessageDialog(null, "Sharpness is null");
    			return;
    		}

    		int ConfigImageInfoSharpness=0;
    		try {
    			ConfigImageInfoSharpness=Integer.parseInt(FieldConfigImageInfoSharpness);
    		}catch(Exception ee) {
    			JOptionPane.showMessageDialog(null, "Sharpness transformation Exception");
    			NetDemo.textFieldConfigImageInfoSharpness.setText(null);
    			return;
    		}
    		
    		if(ConfigImageInfoSharpness<0 || ConfigImageInfoSharpness>255) {
    			JOptionPane.showMessageDialog(null, "Sharpness should between 0 and 255");
    			NetDemo.textFieldConfigImageInfoSharpness.setText(null);
    			return;
    		}	
    		stImageEnhanceInfo.udwSharpness = ConfigImageInfoSharpness;

    		stImageEnhanceInfo.write();
    		boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_CHL_IMAGE_ENHANCE, stImageEnhanceInfo.getPointer(), stImageEnhanceInfo.size());
            if(bRet2 != true)
            {
            	JOptionPane.showMessageDialog(null, "set data failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            }
        }
	}
}
