package main.java.com.netdevsdk.demo.config.image;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IMAGE_ENHANCE_S;

/**
 * 
 * @introduction Reset image configure
 * @description Support IPC
 */
public class ResetImage {

    /**
     * 
     * @introduction Reset image configure
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
	public static void resetImage() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		NETDEV_IMAGE_ENHANCE_S imageSetting=new NETDEV_IMAGE_ENHANCE_S();
		imageSetting.read();
		imageSetting.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID,NETDEV_CONFIG_COMMAND_E.NETDEV_SET_IMAGE_PARAM_RESET, imageSetting.getPointer(), imageSetting.size() );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	JOptionPane.showMessageDialog(null, "Set success");
        }
	}
}
