package main.java.com.netdevsdk.demo.config.io;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.Util;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_INPUT_SWITCH_INFO_LIST_S;

/**
 * 
 * @introduction Alarm input information
 * @description Support IPC/NVR/VMS
 */
public class AlarmInput {

    /**
     * 
     * @introduction Get alarm input information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getAlarmInput() {
		if(null == NetDemo.lpUserID) {
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		
		NETDEV_INPUT_SWITCH_INFO_LIST_S stInputSwitchInfoList = new NETDEV_INPUT_SWITCH_INFO_LIST_S();
		stInputSwitchInfoList.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_INPUTSWITCH_LIST_CFG, stInputSwitchInfoList.getPointer(), stInputSwitchInfoList.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stInputSwitchInfoList.read();
        	NetDemo.ConfigIOAlarmInputTableModel.setRowCount(0);
        	if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS){
                 for(int i = 0; i < stInputSwitchInfoList.udwNum; i++) {
                    Vector<String> InputSwitchInfoVector = new Vector<String>();
                    InputSwitchInfoVector.add(Common.byteArrayToString(stInputSwitchInfoList.astInputSwitchesInfo[i].szName));     
                    String getAlarmRunMode=null;
                    getAlarmRunMode=Util.getAlarmRunMode(stInputSwitchInfoList.astInputSwitchesInfo[i].dwRunMode);
                    InputSwitchInfoVector.add(getAlarmRunMode);   
                    String getEnable=null;
                    getEnable=Util.getEnable(stInputSwitchInfoList.astInputSwitchesInfo[i].dwEnabled);
                    InputSwitchInfoVector.add(getEnable);
                    NetDemo.ConfigIOAlarmInputTableModel.addRow(InputSwitchInfoVector);
                    }
                 }else {
                     for(int i = 0; i < stInputSwitchInfoList.udwNum; i++) {
                        Vector<String> InputSwitchInfoVector = new Vector<String>();
                        if(stInputSwitchInfoList.astInputSwitchesInfo[i].dwChancelId==0) {
                            InputSwitchInfoVector.add("AlarmInput_A_"+String.valueOf(stInputSwitchInfoList.astInputSwitchesInfo[i].dwInputSwitchIndex));
                        }
                        else {
                            InputSwitchInfoVector.add("AlarmInput_D_"+String.valueOf(stInputSwitchInfoList.astInputSwitchesInfo[i].dwChancelId)+"_"+String.valueOf(stInputSwitchInfoList.astInputSwitchesInfo[i].dwInputSwitchIndex));
                        }
                        
                        String getAlarmRunMode=null;
                        getAlarmRunMode=Util.getAlarmRunMode(stInputSwitchInfoList.astInputSwitchesInfo[i].dwRunMode);
                        InputSwitchInfoVector.add(getAlarmRunMode);
                        
                        String getEnable=null;
                        getEnable=Util.getEnable(stInputSwitchInfoList.astInputSwitchesInfo[i].dwEnabled);
                        InputSwitchInfoVector.add(getEnable);

                        NetDemo.ConfigIOAlarmInputTableModel.addRow(InputSwitchInfoVector);
                        }
                     }
        	}
        }
	}
