package main.java.com.netdevsdk.demo.config.io;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_OUTPUT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_OUTPUT_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BOOLEAN_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CHN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEV_CHN_ALARMOUT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RELAYOUTPUT_STATE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRIGGER_ALARM_OUTPUT_S;

/**
 * 
 * @introduction Alarm output information
 * @description
 */
public class AlarmOutput {

    /**
     * 
     * @introduction Get alarm output information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getAlarmOutPut() {
		NetDemo.jComboBoxAlarmOutPutIndex.removeAllItems();
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList = new NETDEV_ALARM_OUTPUT_LIST_S();
		stAlarmOutputList.dwSize=64;
		stAlarmOutputList.write();
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
		    NetDemo.ChannelID=0;
		     }
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_OUTPUTCFG, stAlarmOutputList.getPointer(), stAlarmOutputList.size(), dwBytesReturned );
		if(bRet != true) {
		     JOptionPane.showMessageDialog(null, "Get data failed error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
		     System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
		     return;
		     }else {
		         stAlarmOutputList.read();
		         if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
	                 for(int i =0; i< stAlarmOutputList.dwSize; i++) {
	                 NetDemo.jComboBoxAlarmOutPutIndex.addItem(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwOutputNum));
	                 }
	                 }else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
	                         NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
	                         NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
							 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
	                     for(int i =0; i< stAlarmOutputList.dwSize; i++) {
	                         try {
	                             if(stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId==0) {
	                                 if(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).equals("relay_output")) {
	                                     NetDemo.jComboBoxAlarmOutPutIndex.addItem("A_"+1);
	                                     }else {
	                                         NetDemo.jComboBoxAlarmOutPutIndex.addItem("A_"+(Integer.parseInt(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12,Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length() ))+1));
	                                         }
	                                 }else {
	                                     NetDemo.jComboBoxAlarmOutPutIndex.addItem("D"+String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId)+"_"+String.valueOf(1));
	                                     } 
	                             }catch(Exception mt) {}
	                         }
	                     }
	                 else {
	                     for(int i =0; i< stAlarmOutputList.dwSize; i++) {
	                         if((Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, 13)).equals("D")) {
	                             for(int s=0;s<NetDemo.DeviceTable.getRowCount();s++) {
	                                 String getChannelId=String.valueOf(NetDemo.DeviceTableModel.getValueAt(s, 0));
	                                 String getStatus=String.valueOf(NetDemo.DeviceTableModel.getValueAt(s, 1));
	                                 if((Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(13, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).lastIndexOf("_"))).equals(getChannelId)) {
	                                     if(getStatus.equals("online")) {
	                                         NetDemo.jComboBoxAlarmOutPutIndex.addItem(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length()));
	                                         }
	                                     }
	                                 }	 
	                             }else {
	                                 NetDemo.jComboBoxAlarmOutPutIndex.addItem("A_"+Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length()));	
	                                 }
	                         }
	                     }
		         NetDemo.textFieldlblConfigIOAlarmOutputName.setText(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[0].szName));
		         NetDemo.comboBoxlblConfigIOAlarmOutputStatus.setSelectedIndex(stAlarmOutputList.astAlarmOutputInfo[0].enDefaultStatus-1);
		         NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[0].dwChancelId));
		         NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[0].dwDurationSec));
		         }
		 }
	
	/**
	 * 
	 * @introduction Change alarm output configure combox
	 * @description
	 *
	 */
	public static void comgboxAlarmOuptConfig() {
		NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList = new NETDEV_ALARM_OUTPUT_LIST_S();
		stAlarmOutputList.dwSize=64;
		stAlarmOutputList.write();
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
		        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
		    NetDemo.ChannelID=0;
		    }
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_ALARM_OUTPUTCFG, stAlarmOutputList.getPointer(), stAlarmOutputList.size(), dwBytesReturned );
		if(bRet != true) {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }else {
                stAlarmOutputList.read();
                if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                    for(int i =0; i< stAlarmOutputList.dwSize; i++) {
                        try {
                            if(NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex()).equals(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwOutputNum))) {
                                NetDemo.textFieldlblConfigIOAlarmOutputName.setText(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName));
                                NetDemo.comboBoxlblConfigIOAlarmOutputStatus.setSelectedIndex(stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus-1);
                                NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId));
                                NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec));
                                }
                            }catch(Exception mm) {} 
                        }
                    }else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
							NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
							NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                        for(int i =0; i< stAlarmOutputList.dwSize; i++) {
                            try {
                                if(NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex()).equals("A_"+(Integer.parseInt(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length()))+1))) {
                                    NetDemo.textFieldlblConfigIOAlarmOutputName.setText(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName));
                                    NetDemo.comboBoxlblConfigIOAlarmOutputStatus.setSelectedIndex(stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus-1);
                                    NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId));
                                    NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec));
                                    }
                                }catch(Exception mm) {} 
                            }
                        }else {
                            for(int i =0; i< stAlarmOutputList.dwSize; i++) {
                                try {
                                    if(NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex()).equals(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length()))
                                            ||NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex()).equals("A_"+Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).substring(12, Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName).length()))) {
                                        NetDemo.textFieldlblConfigIOAlarmOutputName.setText(Common.byteArrayToString(stAlarmOutputList.astAlarmOutputInfo[i].szName));
                                        NetDemo.comboBoxlblConfigIOAlarmOutputStatus.setSelectedIndex(stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus-1);
                                        NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId));
                                        NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(String.valueOf(stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec));
                                 }
                                    }catch(Exception mm) {} 
                                } 
                            }
                }
		}
	
	/**
	 * 
	 * @introduction Set alarm output information
	 * @description
	 *
	 */
	public static void setAlarmOutPut() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		
		NETDEV_ALARM_OUTPUT_INFO_S stAlarmOutputInfo = new NETDEV_ALARM_OUTPUT_INFO_S();
		if(NetDemo.textFieldlblConfigIOAlarmOutputName.getText()==null||NetDemo.textFieldlblConfigIOAlarmOutputName.getText().equals("")) {
			JOptionPane.showMessageDialog(null, "AlarmOutputName is null");
			return;
		}
		Common.stringToByteArray(NetDemo.textFieldlblConfigIOAlarmOutputName.getText(), stAlarmOutputInfo.szName);
		stAlarmOutputInfo.enDefaultStatus = (NetDemo.comboBoxlblConfigIOAlarmOutputStatus.getSelectedIndex()+1);
		
		String FieldConfigIOAlarmOutputChannelID=NetDemo.textFieldConfigIOAlarmOutputChannelID.getText();
		if(FieldConfigIOAlarmOutputChannelID==null||FieldConfigIOAlarmOutputChannelID.equals("")) {
			JOptionPane.showMessageDialog(null, "AlarmOutputChannelID is null");
			return;
		}
		
		int ConfigIOAlarmOutputChannelID=0;
		try {
			ConfigIOAlarmOutputChannelID=Integer.parseInt(FieldConfigIOAlarmOutputChannelID);
		}catch(Exception el) {
			JOptionPane.showMessageDialog(null, "AlarmOutputChannelID transformation Exception");
			NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(null);
			return;
		}
		if(ConfigIOAlarmOutputChannelID<0) {
			JOptionPane.showMessageDialog(null, "AlarmOutputChannelID can not less than zero");
			NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(null);
			return;
		}
		stAlarmOutputInfo.dwChancelId = ConfigIOAlarmOutputChannelID;
		
		String FieldlblConfigIOAlarmOutputDelay=NetDemo.textFieldlblConfigIOAlarmOutputDelay.getText();
		if(FieldlblConfigIOAlarmOutputDelay==null||FieldlblConfigIOAlarmOutputDelay.equals("")) {
			JOptionPane.showMessageDialog(null, "ConfigIOAlarmOutputDelay is null");
			return;
		}
		int ConfigIOAlarmOutputDelay=0;
		try {
			ConfigIOAlarmOutputDelay=Integer.parseInt(FieldlblConfigIOAlarmOutputDelay);
		}catch(Exception el) {
			JOptionPane.showMessageDialog(null, "ConfigIOAlarmOutputDelay transformation Exception");
			NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(null);
			return;
		}
		if(ConfigIOAlarmOutputDelay<0) {
			JOptionPane.showMessageDialog(null, "ConfigIOAlarmOutputDelay can not less than zero");
			NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(null);
			return;
		}
		stAlarmOutputInfo.dwDurationSec =ConfigIOAlarmOutputDelay;
		
		int ConfigIOAlarmOutputIndex=0;
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
				NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
						NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
								NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
		    String getConfigIOAlarmOutputIndex=NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex());
		    try {
		        ConfigIOAlarmOutputIndex=Integer.parseInt(getConfigIOAlarmOutputIndex.substring(getConfigIOAlarmOutputIndex.lastIndexOf("_")+1, getConfigIOAlarmOutputIndex.length()))-1;
		        }catch(Exception tt) {}
		    stAlarmOutputInfo.dwOutputNum = ConfigIOAlarmOutputIndex;
			stAlarmOutputInfo.write();
			boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID,NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_ALARM_OUTPUTCFG, stAlarmOutputInfo.getPointer(), stAlarmOutputInfo.size());
	        if(bRet != true) {
	        	JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
	        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	            }else {
	                JOptionPane.showMessageDialog(null, "Set success");
	                }
	        }else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
			String getConfigIOAlarmOutputIndex=NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex());
			try {
			    ConfigIOAlarmOutputIndex=Integer.parseInt(getConfigIOAlarmOutputIndex);
			    }catch(Exception tt) {}
			
			stAlarmOutputInfo.dwOutputNum = ConfigIOAlarmOutputIndex;
			stAlarmOutputInfo.write();
			boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_ALARM_OUTPUTCFG, stAlarmOutputInfo.getPointer(), stAlarmOutputInfo.size());
	        if(bRet != true)
	        {
	        	JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
	        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }else {
	            JOptionPane.showMessageDialog(null, "Set success");
	        	}
	        }else {
	            if(NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex()).substring(0, 1).equals("A")) {
	                
				String getConfigIOAlarmOutputIndex=NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex());
				try {
					ConfigIOAlarmOutputIndex=Integer.parseInt(getConfigIOAlarmOutputIndex.substring(getConfigIOAlarmOutputIndex.lastIndexOf("_")+1, getConfigIOAlarmOutputIndex.length()));
					}catch(Exception tt) {}
				stAlarmOutputInfo.dwOutputNum = ConfigIOAlarmOutputIndex;
				stAlarmOutputInfo.write();
				boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, 0, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_ALARM_OUTPUTCFG, stAlarmOutputInfo.getPointer(), stAlarmOutputInfo.size());
		        if(bRet != true) {
		        	JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
		        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
		        	return;
		        	}else {
		        	    JOptionPane.showMessageDialog(null, "Set success");
		        	    }
			}else {
				String getConfigIOAlarmOutputIndex=NetDemo.jComboBoxAlarmOutPutIndex.getItemAt(NetDemo.jComboBoxAlarmOutPutIndex.getSelectedIndex());
				try {
				    ConfigIOAlarmOutputIndex=Integer.parseInt(getConfigIOAlarmOutputIndex.substring(getConfigIOAlarmOutputIndex.lastIndexOf("_")+1, getConfigIOAlarmOutputIndex.length()));
				}catch(Exception tt) {}
				stAlarmOutputInfo.dwOutputNum = ConfigIOAlarmOutputIndex;
				stAlarmOutputInfo.write();
				int id=Integer.parseInt(getConfigIOAlarmOutputIndex.substring(1, getConfigIOAlarmOutputIndex.lastIndexOf("_")));
				boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID,id, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_ALARM_OUTPUTCFG, stAlarmOutputInfo.getPointer(), stAlarmOutputInfo.size());
		        if(bRet != true) {
		            JOptionPane.showMessageDialog(null, "Set failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
		        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
		        	return;
		            }else {
		                JOptionPane.showMessageDialog(null, "Set success");
		                }
		        }
	            }
		}
	
	/**
	 * 
	 * @introduction Trigger alarm output
	 * @description
	 *
	 */
	public static void triggerAlarmOutPut() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}

		NETDEV_TRIGGER_ALARM_OUTPUT_S stTriggerAlarmOutput = new NETDEV_TRIGGER_ALARM_OUTPUT_S();
		if(NetDemo.textFieldlblConfigIOAlarmOutputName.getText()==null||NetDemo.textFieldlblConfigIOAlarmOutputName.getText().equals("")) {
			JOptionPane.showMessageDialog(null, "AlarmOutputName is null");
			return;
		}else {
			Common.stringToByteArray(NetDemo.textFieldlblConfigIOAlarmOutputName.getText(), stTriggerAlarmOutput.szName);
			stTriggerAlarmOutput.enOutputState = NETDEV_RELAYOUTPUT_STATE_E.NETDEV_BOOLEAN_STATUS_ACTIVE;
			stTriggerAlarmOutput.write();
			boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_TRIGGER_ALARM_OUTPUT, stTriggerAlarmOutput.getPointer(), stTriggerAlarmOutput.size());
	        if(bRet != true) {
	        	JOptionPane.showMessageDialog(null, "Trigger failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
	        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	            }else {
	                JOptionPane.showMessageDialog(null, "Trigger success");
	                }
	        }
		}
	
	/**
	 * 
	 * @introduction Cancel trigger alarm output
	 * @description
	 *
	 */
	public static void cancelTriggerAlarmOutPut() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		NETDEV_TRIGGER_ALARM_OUTPUT_S stTriggerAlarmOutput = new NETDEV_TRIGGER_ALARM_OUTPUT_S();
		if(NetDemo.textFieldlblConfigIOAlarmOutputName.getText()==null||NetDemo.textFieldlblConfigIOAlarmOutputName.getText().equals("")) {
		    JOptionPane.showMessageDialog(null, "AlarmOutputName is null");
		    return;
		    }else {
		        Common.stringToByteArray(NetDemo.textFieldlblConfigIOAlarmOutputName.getText(), stTriggerAlarmOutput.szName);
			    stTriggerAlarmOutput.enOutputState = NETDEV_RELAYOUTPUT_STATE_E.NETDEV_BOOLEAN_STATUS_INACTIVE;
			    stTriggerAlarmOutput.write();
			    boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_TRIGGER_ALARM_OUTPUT, stTriggerAlarmOutput.getPointer(), stTriggerAlarmOutput.size());
			    if(bRet != true) {
			        JOptionPane.showMessageDialog(null, "Cancel failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			        System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
			        return;
			        }else {
			            JOptionPane.showMessageDialog(null, "Clear success");
			            }
			    }
		}

	/**
	 * 
	 * @introduction Get alarm output channel information
	 * @description
	 *
	 */
	public static void getAlarmOutputChannelInfo() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        int num=0;
        try {
            num=Integer.parseInt(String.valueOf(NetDemo.textFieldConfigIOAlarmOutputChannelNo.getText()));
        }catch(Exception m) {
            return;
        }
        
        NETDEV_DEV_CHN_ALARMOUT_INFO_S stAlarmOutInfo = new NETDEV_DEV_CHN_ALARMOUT_INFO_S();
        stAlarmOutInfo.udwAlarmOutputNum=num;
        stAlarmOutInfo.write();
        IntByReference dwBytesReturned = new IntByReference();
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
            NetDemo.ChannelID = 0;
            }
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetChnDetailByChnType(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CHN_TYPE_E.NETDEV_CHN_TYPE_ALARMOUT, stAlarmOutInfo.getPointer(),stAlarmOutInfo.size(), dwBytesReturned );
        if(bRet != true) {
            JOptionPane.showMessageDialog(null, "Get data failed，error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetChnDetailByChnType failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }else {
             stAlarmOutInfo.read();
             NetDemo.textFieldConfigIOAlarmOutputChannelDelay.setText(String.valueOf(stAlarmOutInfo.dwDuration));
             if(stAlarmOutInfo.dwRunMode==1) {
                 NetDemo.jComboBoxDefaultStatus.setSelectedIndex(0);
             }else if(stAlarmOutInfo.dwRunMode==2) {
                 NetDemo.jComboBoxDefaultStatus.setSelectedIndex(1);
             }   
        }
	}

	/**
	 * 
	 * @introduction Set alarm output channel information
	 * @description
	 *
	 */
	public static void setAlarmOutputChannelInfo() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS
                ) {
            NetDemo.ChannelID = 0;
             }
        int num=0;
        try {
            num=Integer.parseInt(String.valueOf(NetDemo.textFieldConfigIOAlarmOutputChannelNo.getText()));
        }catch(Exception m) {
            return;
        }
        

        NETDEV_DEV_CHN_ALARMOUT_INFO_S stAlarmOutInfo = new NETDEV_DEV_CHN_ALARMOUT_INFO_S();
        stAlarmOutInfo.udwAlarmOutputNum=num;
        stAlarmOutInfo.write();
        IntByReference dwBytesReturned = new IntByReference();
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS
        ) {
            NetDemo.ChannelID = 0;
     }
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetChnDetailByChnType(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CHN_TYPE_E.NETDEV_CHN_TYPE_ALARMOUT, stAlarmOutInfo.getPointer(),stAlarmOutInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed，error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetChnDetailByChnType failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
             stAlarmOutInfo.read();
             String FieldConfigIOAlarmOutputChannelNo=NetDemo.textFieldConfigIOAlarmOutputChannelNo.getText();
            if(FieldConfigIOAlarmOutputChannelNo==null||FieldConfigIOAlarmOutputChannelNo.equals("")) {
                JOptionPane.showMessageDialog(null, "AlarmOutputNum is null");
                return;
            }
            int ConfigIOAlarmOutputChannelNo=0;
            try {
                ConfigIOAlarmOutputChannelNo=Integer.parseInt(FieldConfigIOAlarmOutputChannelNo);
            }catch(Exception el) {
                JOptionPane.showMessageDialog(null, "AlarmOutputNum transformation Exception");
                NetDemo.textFieldConfigIOAlarmOutputChannelNo.setText(null);
                return;
            }
            if(ConfigIOAlarmOutputChannelNo<0) {
                JOptionPane.showMessageDialog(null, "AlarmOutputNum can not less than zero");
                NetDemo.textFieldConfigIOAlarmOutputChannelNo.setText(null);
                return;
            }
            stAlarmOutInfo.udwAlarmOutputNum = ConfigIOAlarmOutputChannelNo;
            
            
            
            String FieldConfigIOAlarmOutputChannelDelay=NetDemo.textFieldConfigIOAlarmOutputChannelDelay.getText();
            if(FieldConfigIOAlarmOutputChannelDelay==null||FieldConfigIOAlarmOutputChannelDelay.equals("")) {
                JOptionPane.showMessageDialog(null, "Delay is null");
                return;
            }
            int ConfigIOAlarmOutputChannelDelay=0;
            try {
                ConfigIOAlarmOutputChannelDelay=Integer.parseInt(FieldConfigIOAlarmOutputChannelDelay);
            }catch(Exception el) {
                JOptionPane.showMessageDialog(null, "Delay transformation Exception");
                NetDemo.textFieldConfigIOAlarmOutputChannelDelay.setText(null);
                return;
            }
            if(ConfigIOAlarmOutputChannelDelay<0) {
                JOptionPane.showMessageDialog(null, "Delay can not less than zero");
                NetDemo.textFieldConfigIOAlarmOutputChannelDelay.setText(null);
                return;
            }
            stAlarmOutInfo.dwDuration = ConfigIOAlarmOutputChannelDelay;
            
            int ConfigIOAlarmOutputChannelDefaultStatus=0;
            if(NetDemo.jComboBoxDefaultStatus.getItemAt(NetDemo.jComboBoxDefaultStatus.getSelectedIndex()).equals("OPEN")) {
                ConfigIOAlarmOutputChannelDefaultStatus=NETDEV_BOOLEAN_MODE_E.NETDEV_BOOLEAN_MODE_OPEN;
            }else if(NetDemo.jComboBoxDefaultStatus.getItemAt(NetDemo.jComboBoxDefaultStatus.getSelectedIndex()).equals("CLOSE")){
                ConfigIOAlarmOutputChannelDefaultStatus=NETDEV_BOOLEAN_MODE_E.NETDEV_BOOLEAN_MODE_CLOSE;
            }
            stAlarmOutInfo.dwRunMode = ConfigIOAlarmOutputChannelDefaultStatus;
            stAlarmOutInfo.write();

            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetChnDetailByChnType(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CHN_TYPE_E.NETDEV_CHN_TYPE_ALARMOUT, stAlarmOutInfo.getPointer(), stAlarmOutInfo.size() );
            if(bRet2 != true) {
                JOptionPane.showMessageDialog(null, "Set data error，error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetChnDetailByChnType failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
                }else {
                    JOptionPane.showMessageDialog(null, "Set success");
                    }
            }
        }
	}
