package main.java.com.netdevsdk.demo.config.motion;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_TYPE_E;

import javax.swing.JComponent;
import javax.swing.JButton;
import javax.swing.JCheckBox;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class MotionDetectionAreaWindow extends JDialog{
    
	private static final long serialVersionUID = 1L;
	private JTable rectangleTable;
	private JTable gridTable;
	private Pointer lpUserId;
	private int ChannelID;
	JPanel MotionDetectionAreaPanel = new JPanel();
	//矩形
	NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S stRectangleInfo;
	JButton RectangleAreaAdd = new JButton("Add");
	JButton RectangleAreaSave = new JButton("Save");
	JButton RectangleAreaDelete = new JButton("Delete");
	//宏块
	NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S stGridInfo;
    private JTextField textFieldConfigChannelMotionGridAreaSensitivity;
	JButton GridAreaSave = new JButton("Save");
	JCheckBox textFieldConfigChannelMotionGridAreaEnabled;
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	
	public static class Montion_DETECTION_AREA_WINDOW_EFFECT{
	    public static final int Montion_DETECTION_AREA_WINDOW_ADD             = 1;        /* 添加运动检测区域信息 */
	    public static final int Montion_DETECTION_AREA_WINDOW_MODIFY          = 2;        /* 修改运动检测区域信息 */
	}

	public MotionDetectionAreaWindow(int dwAreaType,Pointer lpUserID,int ChannelID) {
		this.lpUserId = lpUserID;
		this.ChannelID = ChannelID;
		this.setSize(1400,800);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Modify Montion Dection Area");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(MotionDetectionAreaPanel, BorderLayout.CENTER);
		
        if(dwAreaType == NETDEV_MOTION_DETECTION_AREA_TYPE_E.NETDEV_MOTION_DETECTION_AREA_TYPE_RECTANGLE){
        //判断运动检测区域类型为矩形
        	MotionDetectionAreaPanel.setLayout(null);
    		MotionDetectionAreaPanel.setVisible(true);
    		rectangleTable = new JTable();
    		JScrollPane scrollPaneConfigMotionRectangle = new JScrollPane(rectangleTable,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    		scrollPaneConfigMotionRectangle.setBounds(10, 50, 1300, 500);
    		MotionDetectionAreaPanel.add(scrollPaneConfigMotionRectangle, BorderLayout.CENTER);
    		Vector<String> headerNames=new Vector<>();
    		headerNames.add("Enable");
    		headerNames.add("ID");
    		headerNames.add("Sensitivity（1~100）");
    		headerNames.add("Duration（1~100）");
    		headerNames.add("TargetSize（1~100）");
    		headerNames.add("TopLeftX");
    		headerNames.add("TopLeftY");
    		headerNames.add("BottomRightX");
    		headerNames.add("BottomRightY");
    		Vector data = this.getRectangleData();
    		CheckTableModle RectangleAreatableModel=new CheckTableModle(data,headerNames);
    		rectangleTable.setModel(RectangleAreatableModel);
    		rectangleTable.getTableHeader().setDefaultRenderer(new CheckHeaderCellRenderer(rectangleTable));
    		
    		RectangleAreaAdd.addActionListener(new ActionListener() {
    			public void actionPerformed(ActionEvent e) {
    				if(null == lpUserID) {
    					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
    					return;
    				}
    				if(ChannelID == 0) {
    					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
    					return;
    				}
    				Vector RectangleVector = new Vector();
    				if(RectangleAreatableModel.getRowCount() >= NetDEVSDKLib.NETDEV_LEN_8) {
						JOptionPane.showMessageDialog(null, "Please don't click add button beacuse array size is pass.");
						return;
					}
    				if(rectangleTable.getSelectedRowCount() == 0){
    					int i = RectangleAreatableModel.getRowCount();
    					RectangleVector.add(true);
    					RectangleVector.add(i);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleAreatableModel.insertRow(i, RectangleVector);
    				}else if(rectangleTable.getSelectedRowCount() == 1){
    					int i = rectangleTable.getRowCount();
    					RectangleVector.add(true);
    					RectangleVector.add(i);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleVector.add(0);
    					RectangleAreatableModel.insertRow(i, RectangleVector);
    				}else{
    					JOptionPane.showMessageDialog(null, "Can't select multiple! please select one");
						return;
    				}
    			}
    		});
    		RectangleAreaAdd.setBounds(400, 600, 93, 23);
    		MotionDetectionAreaPanel.add(RectangleAreaAdd);
    		
    		RectangleAreaDelete.addActionListener(new ActionListener() {
    			public void actionPerformed(ActionEvent e) {
    				if(null == lpUserID){
    					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
    					return;
    				}
    				if(ChannelID == 0) {
    					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
    					return;
    				}
    				if(rectangleTable.getSelectedRowCount() == 0) {
    					RectangleAreatableModel.removeRow(RectangleAreatableModel.getRowCount()-1);
    				}else if(rectangleTable.getSelectedRowCount() == 1) {
    					RectangleAreatableModel.removeRow(rectangleTable.getSelectedRow());
    				}else{
    					JOptionPane.showMessageDialog(null, "Can't select multiple! please select one");
    				}
    			}
    		});
    		RectangleAreaDelete.setBounds(600, 600, 93, 23);
    		MotionDetectionAreaPanel.add(RectangleAreaDelete);
    		
    		RectangleAreaSave.addActionListener(new ActionListener() {
    			public void actionPerformed(ActionEvent e) {
    				if(null == lpUserID){
    					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
    					return;
    				}
    				if(ChannelID == 0){
    					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
    					return;
    				}
    				stRectangleInfo = new NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S();
    				for(int i =0; i< RectangleAreatableModel.getRowCount(); i++)
    				{
    					stRectangleInfo.astRectangleAreaInfoList[i] = new NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S();
    					if(new Boolean(RectangleAreatableModel.getValueAt(i, 0).toString()) == true){
    						stRectangleInfo.astRectangleAreaInfoList[i].bEnabled = 1;
    						
    					}else{
    						stRectangleInfo.astRectangleAreaInfoList[i].bEnabled = 0;
    						
    					}
    					stRectangleInfo.astRectangleAreaInfoList[i].udwID = Integer.valueOf(RectangleAreatableModel.getValueAt(i, 1).toString());
    					
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 2).toString())>100) {
    						JOptionPane.showMessageDialog(null, "Sensitivity can not more than one hundred");
    						return;
    					}
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 2).toString())<=0) {
    						JOptionPane.showMessageDialog(null, "Sensitivity can not less than one");
    						return;
    					}
    					
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 3).toString())>100) {
    						JOptionPane.showMessageDialog(null, "Duration can not more than one hundred");
    						return;
    					}
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 3).toString())<=0) {
    						JOptionPane.showMessageDialog(null, "Duration can not less than one");
    						return;
    					}
    					
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 4).toString())>100) {
    						JOptionPane.showMessageDialog(null, "TargetSize can not more than one hundred");
    						return;
    					}
    					if( Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 4).toString())<=0) {
    						JOptionPane.showMessageDialog(null, "TargetSize can not less than one");
    						return;
    					}
    					
    					stRectangleInfo.astRectangleAreaInfoList[i].udwSensitivity = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 2).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].udwDuration = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 3).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].udwTargetSize = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 4).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwTopLeftX = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 5).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwTopLeftY = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 6).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwBottomRightX = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 7).toString());
    					stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwBottomRightY = Integer.valueOf((String) RectangleAreatableModel.getValueAt(i, 8).toString());
    				}
    				stRectangleInfo.udwNum = RectangleAreatableModel.getRowCount();
    				
    				stRectangleInfo.write();
    				boolean bRet = netdevsdk.NETDEV_SetDevConfig(lpUserID, ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST, stRectangleInfo.getPointer(), stRectangleInfo.size());
                    if(bRet != true)
                    {
                    	JOptionPane.showMessageDialog(null, "Set failed,Number of area excess capacity");
                    	System.out.printf("NETDEV_SetDevConfig failed:%d\n", netdevsdk.NETDEV_GetLastError());
                        return;
                    }else {
                    	JOptionPane.showMessageDialog(null, "Set success!");
                    }
    			}
    		});
    		RectangleAreaSave.setBounds(800, 600, 93, 23);
    		MotionDetectionAreaPanel.add(RectangleAreaSave);
    		
        }else if(dwAreaType == NETDEV_MOTION_DETECTION_AREA_TYPE_E.NETDEV_MOTION_DETECTION_AREA_TYPE_MB){
        	//判断运动检测区域类型为宏块
        	MotionDetectionAreaPanel.setLayout(null);
    		MotionDetectionAreaPanel.setVisible(true);
    		JLabel lblAreaGridEnabled = new JLabel("AreaGrid_Enabled");
    		lblAreaGridEnabled.setBounds(10, 10, 120, 35);
    		MotionDetectionAreaPanel.add(lblAreaGridEnabled);
    		textFieldConfigChannelMotionGridAreaEnabled = new JCheckBox("Enable");
    		textFieldConfigChannelMotionGridAreaEnabled.setBounds(130, 10, 100, 35);
    		MotionDetectionAreaPanel.add(textFieldConfigChannelMotionGridAreaEnabled);
    		MotionDetectionAreaPanel.add(textFieldConfigChannelMotionGridAreaEnabled);
    		
    		JLabel lblAreaGridSensitivity = new JLabel("AreaGrid_Sensitivity");
    		lblAreaGridSensitivity.setBounds(400, 10, 140, 35);
    		MotionDetectionAreaPanel.add(lblAreaGridSensitivity);
    		textFieldConfigChannelMotionGridAreaSensitivity = new JTextField();
    		textFieldConfigChannelMotionGridAreaSensitivity.setColumns(10);
    		textFieldConfigChannelMotionGridAreaSensitivity.setBounds(560, 10, 160, 35);
    		MotionDetectionAreaPanel.add(textFieldConfigChannelMotionGridAreaSensitivity);
    		
    		JLabel lblAreaGridPanel = new JLabel();
    		lblAreaGridPanel.setBorder(new TitledBorder(null, "AreaGrid_Info", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    		lblAreaGridPanel.setBounds(10, 110, 1300, 600);
    		MotionDetectionAreaPanel.add(lblAreaGridPanel);
    		
    		gridTable = new JTable();
    		JScrollPane scrollPaneConfigMotionGridRow = new JScrollPane(gridTable,
			JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
    		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    		scrollPaneConfigMotionGridRow.setBounds(30, 140, 1260, 520);
    		MotionDetectionAreaPanel.add(scrollPaneConfigMotionGridRow, BorderLayout.CENTER);
    		Vector headerColumnNames=new Vector();
    		for(int i = 0;i < 22; i++){
    			headerColumnNames.add(i+1);
    		}
    		
    		Vector rowData = this.getGridData();
    		CheckTableModle GridTableModel=new CheckTableModle(rowData,headerColumnNames);
    		gridTable.setModel(GridTableModel);
    		gridTable.getTableHeader().setDefaultRenderer(new CheckHeaderCellRenderer(gridTable));

    		GridAreaSave.addActionListener(new ActionListener() {
    			public void actionPerformed(ActionEvent e) {
    				if(null == lpUserID){
    					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
    					return;
    				}
    				if(ChannelID == 0){
    					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
    					return;
    				}
    				stGridInfo = new NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S();
    				if(textFieldConfigChannelMotionGridAreaEnabled.isSelected() == true){
    					stGridInfo.bEnabled = 1;
    				}else{
    					stGridInfo.bEnabled = 0;
    				}
    				if("".equals(textFieldConfigChannelMotionGridAreaSensitivity.getText()) || textFieldConfigChannelMotionGridAreaSensitivity.getText() == null){
						JOptionPane.showMessageDialog(null, "Must input Sensitivity !");
    					return;
					}
    				
    				if(Integer.valueOf(textFieldConfigChannelMotionGridAreaSensitivity.getText().toString())<=0) {
    					JOptionPane.showMessageDialog(null, "Sensitivity can not less than one");
    					return;
    				}
    				
    				if(Integer.valueOf(textFieldConfigChannelMotionGridAreaSensitivity.getText().toString())>100) {
    					JOptionPane.showMessageDialog(null, "Sensitivity can not more than hundred");
    					return;
    				}
    				
    				stGridInfo.udwSensitivity = Integer.valueOf(textFieldConfigChannelMotionGridAreaSensitivity.getText().toString());

    				for(int i =0; i< NetDEVSDKLib.NETDEV_SCREEN_INFO_ROW; i++)
    				{
    					for(int j =0; j< NetDEVSDKLib.NETDEV_SCREEN_INFO_COLUMN; j++)
        				{
        					try{
								if(Boolean.valueOf(gridTable.getValueAt(i, j).toString()) == true){
									stGridInfo.awGridInfo[i*NetDEVSDKLib.NETDEV_SCREEN_INFO_COLUMN+j] = 1;
								}else{
									stGridInfo.awGridInfo[i*NetDEVSDKLib.NETDEV_SCREEN_INFO_COLUMN+j] = 0;
								}
							}catch (Exception exp){
								exp.printStackTrace();
							}
        				}
    				}

    				stGridInfo.write();
    				boolean bRet = netdevsdk.NETDEV_SetDevConfig(lpUserID, ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_MOTION_DETECTION_AREA_GRID_INFO, stGridInfo.getPointer(), stGridInfo.size());
                    if(bRet != true)
                    {
                    	System.out.printf("NETDEV_SetDevConfig failed:%d\n", netdevsdk.NETDEV_GetLastError());
                        return;
                    }
						JOptionPane.showMessageDialog(null, "Set success!");
    			}
    		});
    		GridAreaSave.setBounds(570, 715, 120, 40);
    		MotionDetectionAreaPanel.add(GridAreaSave);
        }
	}
	
	/**
	 * 
	 * @introduction Get rectangular area table data
	 * @description
	 *
	 */
	public Vector getRectangleData(){
	    Vector data = new Vector();
	    if(null == lpUserId){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return null;
		}
		if(ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return null;
		}

		IntByReference dwBytesReturned = new IntByReference();
		stRectangleInfo = new NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S();
		boolean bRet = netdevsdk.NETDEV_GetDevConfig(lpUserId, ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST, stRectangleInfo.getPointer(),stRectangleInfo.size(),dwBytesReturned);
        if(bRet != true) {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", netdevsdk.NETDEV_GetLastError());
            return null;
        }
		stRectangleInfo.read();
        for(int i = 0; i <  stRectangleInfo.udwNum; i++){
        	Vector<Object> vtData = new Vector<>();
        	if(stRectangleInfo.astRectangleAreaInfoList[i].bEnabled == 1) {
				vtData.add(true);
			}else{
				vtData.add(false);
			}
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].udwID);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].udwSensitivity);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].udwDuration);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].udwTargetSize);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwTopLeftX);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwTopLeftY);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwBottomRightX);
        	vtData.add(stRectangleInfo.astRectangleAreaInfoList[i].stRectAreaInfo.udwBottomRightY);
        	data.add(vtData);
        }
	    return data;
	}

	/**
	 * 
	 * @introduction Get macro block area data
	 * @description
	 *
	 */
	public Vector getGridData(){
	    Vector data = new Vector();
	    if(null == lpUserId){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return null;
		}
		if(ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return null;
		}

		IntByReference dwBytesReturned = new IntByReference();
		stGridInfo = new NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S();
		boolean bRet = netdevsdk.NETDEV_GetDevConfig(lpUserId, ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTION_DETECTION_AREA_GRID_INFO, stGridInfo. getPointer(),stGridInfo.size(),dwBytesReturned);
        if(bRet != true) {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", netdevsdk.NETDEV_GetLastError());
            return null;
        }
        
		stGridInfo.read();
		textFieldConfigChannelMotionGridAreaSensitivity.setText(Integer.valueOf(stGridInfo.udwSensitivity).toString());
		if(stGridInfo.bEnabled == 1){
			textFieldConfigChannelMotionGridAreaEnabled.setSelected(true);
		}else{
			textFieldConfigChannelMotionGridAreaEnabled.setSelected(false);
		}

		int i=0;
		while(i<NetDEVSDKLib.NETDEV_SCREEN_INFO_ROW){
			Vector vtData = new Vector();
			int j=0;
			while(j<NetDEVSDKLib.NETDEV_SCREEN_INFO_COLUMN){
				if(stGridInfo.awGridInfo[i*NetDEVSDKLib.NETDEV_SCREEN_INFO_COLUMN+j]==1){
					vtData.add(true);
				}else{
					vtData.add(false);
				}
				j++;
			}
			data.add(vtData);
			i++;
		}
	    return data;
	}

	class CheckTableModle extends DefaultTableModel {
		public CheckTableModle(Vector data,Vector columnNames) {
			super(data, columnNames);
		}

		// /**
		// * 根据类型返回显示空间
		// * 布尔类型返回显示checkbox
		// */
		public Class getColumnClass(int c) {
		return getValueAt(0, c).getClass();
		}
		
		public void selectAllOrNull(boolean value) {
			for (int i = 0; i < getRowCount(); i++) {
			this.setValueAt(value, i, 0);
				}
		}
	}

	class CheckHeaderCellRenderer implements TableCellRenderer {
	    CheckTableModle tableModel;
	    JTableHeader tableHeader;
		 
	    public CheckHeaderCellRenderer(JTable table) {
	        this.tableModel = (CheckTableModle)table.getModel();
	        this.tableHeader = table.getTableHeader();
	        }
	    @Override
	    public Component getTableCellRendererComponent(JTable table, Object value,
	            boolean isSelected, boolean hasFocus, int row, int column) {
	        String valueStr = (String) value;
	        JLabel label = new JLabel(valueStr);
	        label.setHorizontalAlignment(SwingConstants.CENTER); // 表头标签居中
	        JComponent component = label;
	        component.setForeground(tableHeader.getForeground());
	        component.setBackground(tableHeader.getBackground());
	        component.setFont(tableHeader.getFont());
	        component.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
 
	        return component;
	    }
	}
}
