package main.java.com.netdevsdk.demo.config.network;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SYSTEM_IPADDR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SYSTEM_NTP_INFO_LIST_S;

/**
 * 
 * @introduction NTP
 * @description Support IPC/NVR
 */
public class NTP {

    /**
     * 
     * @introduction Get NTP information
     * @description  Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getNTPInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_SYSTEM_NTP_INFO_LIST_S stNTPInfo = new NETDEV_SYSTEM_NTP_INFO_LIST_S();
		for(int i =0; i<NetDEVSDKLib.NETDEV_NTP_SERVER_LIST_NUM; i++)
		{
			stNTPInfo.astNTPServerInfoList[i] = new NETDEV_SYSTEM_IPADDR_INFO_S();
		}
		stNTPInfo.write();

		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NTPCFG_EX, stNTPInfo.getPointer(), stNTPInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stNTPInfo.read();
        
        for(int i= 0; i< stNTPInfo.ulNum; i++)
        {
        	if(stNTPInfo.astNTPServerInfoList[i].bEnabled ==1)
        	{
        		NetDemo.chckbxConfigNetWorkNTPEnable.setSelected(true);
        	}else {
        		NetDemo.chckbxConfigNetWorkNTPEnable.setSelected(false);
        	}
        	NetDemo.textFieldConfigNetWorkNTPDomainName.setText(Common.byteArrayToString(stNTPInfo.astNTPServerInfoList[i].szDomainName));

        	if(stNTPInfo.astNTPServerInfoList[i].ulAddressType == 0)
        	{
        		NetDemo.jComboBoxConfigNetWorkNTPIPType.setSelectedIndex(0);
        		NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(false);
        	}
        	else if(stNTPInfo.astNTPServerInfoList[i].ulAddressType == 1)
        	{
        		NetDemo.jComboBoxConfigNetWorkNTPIPType.setSelectedIndex(1);
			}
        	else if(stNTPInfo.astNTPServerInfoList[i].ulAddressType == 2)
        	{
        		NetDemo.jComboBoxConfigNetWorkNTPIPType.setSelectedIndex(2);
        		NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(false);
        	}
        	NetDemo.textFieldConfigNetWorkNTPServerIP.setText(Common.byteArrayToString(stNTPInfo.astNTPServerInfoList[i].szIPAddress));
        	NetDemo.textFieldConfigNetWorkNTPPort.setText(String.valueOf(stNTPInfo.astNTPServerInfoList[i].ulPort));
        	NetDemo.textFieldConfigNetWorkNTPSynchronizeInterval.setText(String.valueOf(stNTPInfo.astNTPServerInfoList[i].ulSynchronizeInterval));
        }
	}
	
	/**
	 * 
	 * @introduction Set NTP information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setNTPInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_SYSTEM_NTP_INFO_LIST_S stNTPInfo = new NETDEV_SYSTEM_NTP_INFO_LIST_S();
		for(int i =0; i<NetDEVSDKLib.NETDEV_NTP_SERVER_LIST_NUM; i++)
		{
			stNTPInfo.astNTPServerInfoList[i] = new NETDEV_SYSTEM_IPADDR_INFO_S();
		}
		stNTPInfo.write();

		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NTPCFG_EX, stNTPInfo.getPointer(), stNTPInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            stNTPInfo.read();
            
        	if(NetDemo.chckbxConfigNetWorkNTPEnable.isSelected() == true) {
    			stNTPInfo.astNTPServerInfoList[0].bEnabled = 1;
    		}else {
    			stNTPInfo.astNTPServerInfoList[0].bEnabled = 0;
    		}
        	stNTPInfo.astNTPServerInfoList[0].ulAddressType = NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex();
    			
        	if(NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex()==0) {
                NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(false);
                if(NetDemo.textFieldConfigNetWorkNTPServerIP.getText().equals("0.0.0.0")) {
                    System.arraycopy(NetDemo.textFieldConfigNetWorkNTPServerIP.getText().getBytes(), 0, stNTPInfo.astNTPServerInfoList[0].szIPAddress, 0, NetDemo.textFieldConfigNetWorkNTPServerIP.getText().getBytes().length);
                }else if(Common.isIP(NetDemo.textFieldConfigNetWorkNTPServerIP.getText())) {
                System.arraycopy(NetDemo.textFieldConfigNetWorkNTPServerIP.getText().getBytes(), 0, stNTPInfo.astNTPServerInfoList[0].szIPAddress, 0, NetDemo.textFieldConfigNetWorkNTPServerIP.getText().getBytes().length);
                }else {
                    JOptionPane.showMessageDialog(null, "Ip is error");
                    return;
                    }
                }
        	
        	if(NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex()==2) {
                NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(false);
                if(NetDemo.textFieldConfigNetWorkNTPDomainName.getText()==null||NetDemo.textFieldConfigNetWorkNTPDomainName.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please consider domain name is right  cannot be null");
                    return;
                }
                System.arraycopy(NetDemo.textFieldConfigNetWorkNTPDomainName.getText().getBytes(), 0, stNTPInfo.astNTPServerInfoList[0].szDomainName, 0, NetDemo.textFieldConfigNetWorkNTPDomainName.getText().getBytes().length);
            }

            String  FieldConfigNetWorkNTPPort= NetDemo.textFieldConfigNetWorkNTPPort.getText();
            if(FieldConfigNetWorkNTPPort==null||FieldConfigNetWorkNTPPort.equals("")) {
                JOptionPane.showMessageDialog(null, "Please input ntp port");
                return;
            }
            
            int getFieldConfigNetWorkNTPPort=0;
            try {
                getFieldConfigNetWorkNTPPort=Integer.parseInt(FieldConfigNetWorkNTPPort);
            }catch(NumberFormatException |InputMismatchException e2) {
                JOptionPane.showMessageDialog(null, "NTP port is null or transformation Exception");
                NetDemo.textFieldConfigNetWorkNTPPort.setText(null);
                return;
            }
            
            
            if(getFieldConfigNetWorkNTPPort==0) {
                JOptionPane.showMessageDialog(null, "NTP port can not use");
                NetDemo.textFieldConfigNetWorkNTPPort.setText(null);
                return;
            }
            if(getFieldConfigNetWorkNTPPort<0 || getFieldConfigNetWorkNTPPort>65535) {
                JOptionPane.showMessageDialog(null, "NTP port  should between 0 and 65535");
                NetDemo.textFieldConfigNetWorkNTPPort.setText(null);
                return;
            }
            
            stNTPInfo.astNTPServerInfoList[0].ulPort = getFieldConfigNetWorkNTPPort;
            
            String SynchronizeInterval=NetDemo.textFieldConfigNetWorkNTPSynchronizeInterval.getText();
            
            int Interval=0;
            try {
                Interval=Integer.valueOf(SynchronizeInterval);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "Interval is null or transformation Exception");
                return;
            }
            
            stNTPInfo.astNTPServerInfoList[0].ulSynchronizeInterval = Interval;

            stNTPInfo.write();

            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NTPCFG_EX, stNTPInfo.getPointer(), stNTPInfo.size());
            if(bRet2 != true)
            {
                JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Set success");
                }
            }  
        }
	
	/**
	 * 
	 * @introduction Choose IP type
	 * @description
	 *
	 */
	public static void changeIPType() {
	    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
	       NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
	       NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
	       NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) 
	    {
	        if(NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex()==1) 
	        {
            NetDemo.jComboBoxConfigNetWorkNTPIPType.setSelectedIndex(0);
            NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(false);
            NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(true);
            JOptionPane.showMessageDialog(null, "Not support ipv6,please wait other version,please choose IPV4 or domain name");
            return;
            }   
	    }
	    
	    if(NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex()==0) {
	        NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(false);
	        NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(true);
	        }else if(NetDemo.jComboBoxConfigNetWorkNTPIPType.getSelectedIndex()==2) {
	            NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(true);
                NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(false);
                }else {
                    NetDemo.jComboBoxConfigNetWorkNTPIPType.setSelectedIndex(0);
                    NetDemo.textFieldConfigNetWorkNTPDomainName.setEnabled(false);
                    NetDemo.textFieldConfigNetWorkNTPServerIP.setEnabled(true);
                    JOptionPane.showMessageDialog(null, "Not support ipv6,please wait other version,please choose IPV4 or domain name");
                    return;
                    }        
	    }
	}