package main.java.com.netdevsdk.demo.liveview.information;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_AUDIO_SAMPLE_PARAM_S;

/**
 * 
 * @introduction LiveVoice
 * @description Support IPC/NVR/VMS
 */
public class LiveVoice {
    /**
     * 
     * @introduction Choose voice file
     * @description Choose local voice file
     *
     */
    public static void chooseVoiceFile() {
        String path=null;
        JFileChooser jfierchoose=new JFileChooser();
        jfierchoose.setFileSelectionMode(JFileChooser.FILES_ONLY);
        if(JFileChooser.APPROVE_OPTION==jfierchoose.showOpenDialog(NetDemo.jPanelliveVoice)) {
            path=jfierchoose.getSelectedFile().getPath();
        }
        if(path==null||path.equals("")) {
            System.out.println("File is null");
            return;
        }
        String newpath=null;
        try {
            newpath=path.substring(path.lastIndexOf("."));
        }catch(Exception y) {
            JOptionPane.showMessageDialog(null, "File is not exist");
            return;
        }
        
        if(newpath==null||newpath.equals("")) {
            System.out.println("File is null");
            return;
        }
        if(!(newpath.equals(".pcm"))) {
            JOptionPane.showMessageDialog(null, "Only support pcm file");
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Choose file is ok");
            NetDemo.jTextFieldLiveVoice.setText(path);
            JOptionPane.showMessageDialog(null, "Automatic acquistion");
            NetDemo.jButtonLiveGetVoice.doClick();
        }
    
    }

    /**
     * 
     * @introduction Start voice acquisition
     * @description Only support pcm file
     *
     */
    public static void voiceAcquisition() {
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select the channel first.");
            return;
        }

        String path=NetDemo.jTextFieldLiveVoice.getText();   
        if(path==null||path.equals("")) {
            JOptionPane.showMessageDialog(null, "File is null");
            return;
        }
        
        String fileSuffix=null;
        try {
            fileSuffix=path.substring(path.lastIndexOf("."));
        }catch(Exception t) {
            JOptionPane.showMessageDialog(null, "File is not exist");
            return;
        }
        if(!(fileSuffix.equals(".pcm"))) {
            JOptionPane.showMessageDialog(null, "File type is error, only support pcm file");
            return;
        }
        
        Pointer lpPlayHandle= NetDemo.netdevsdk.NETDEV_StartInputVoiceSrv(NetDemo.lpUserID, NetDemo.ChannelID);
        File file=new File(path);
        try {
        	InputStream input=new FileInputStream(file);
            int dwBufLen=640;
            byte[] szBuff = new byte[dwBufLen];
            NETDEV_AUDIO_SAMPLE_PARAM_S pstVoiceParam=new NETDEV_AUDIO_SAMPLE_PARAM_S();
            while(input.read(szBuff,0,dwBufLen)!=-1) {
                boolean bRet= NetDemo.netdevsdk.NETDEV_InputVoiceData(lpPlayHandle,szBuff, dwBufLen,pstVoiceParam);
                if(!bRet) {
                	input.close();
                    JOptionPane.showMessageDialog(null, "InputVoice fail");
                    NetDemo.jTextFieldLiveVoice.setText(null);
                    System.out.printf("NETDEV_InputVoiceData failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
                Thread.sleep(40);
            }
            
            input.close();
            JOptionPane.showMessageDialog(null, "Success completed");
            NetDemo.jTextFieldLiveVoice.setText(null);
            boolean bRet=NetDemo.netdevsdk.NETDEV_StopInputVoiceSrv(lpPlayHandle);
            if(bRet != true) {
                System.out.printf("NETDEV_StopInputVoiceSrv failed, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
                }
        } catch (IOException | InterruptedException e) {
            JOptionPane.showMessageDialog(null, "File does not exist or has been destoryed");
            NetDemo.jTextFieldLiveVoice.setText(null);
        }
    }
}
