package main.java.com.netdevsdk.demo.liveview.information;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_EFFECT_S;

/**
 * 
 * @introduction Video Effect
 * @description Support IPC/NVR/VMS
 */
public class VideoEffect {

    /**
     * 
     * @introduction Get video effect
     * @description Calling the interface of NETDEV_GetVideoEffect
     *
     */
	public static void getVideoEffect() {
	    if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
		NETDEV_VIDEO_EFFECT_S pstImageInfo=new NETDEV_VIDEO_EFFECT_S();
		pstImageInfo.write();
		boolean bRet=NetDemo.netdevsdk.NETDEV_GetVideoEffect(NetDemo.lpPlayHandle,pstImageInfo);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,maybe not open live or not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetVideoEffect failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	pstImageInfo.read();
        	NetDemo.jTextFieldContrast.setText(String.valueOf(pstImageInfo.dwContrast));
        	NetDemo.jTextFieldBrightness.setText(String.valueOf(pstImageInfo.dwBrightness));
        	NetDemo.jTextFieldSaturation.setText(String.valueOf(pstImageInfo.dwSaturation));
        	NetDemo.jTextFieldHue.setText(String.valueOf(pstImageInfo.dwHue));
        	NetDemo.jTextFieldGamma.setText(String.valueOf(pstImageInfo.dwGamma));
        }
	}
	
	/**
	 * 
	 * @introduction Set video effect
	 * @description Calling the interface of NETDEV_SetVideoEffect
	 *
	 */
	public static void setVideoEffect() {
	    if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel.");
            return;
        }
		NETDEV_VIDEO_EFFECT_S pstImageInfo=new NETDEV_VIDEO_EFFECT_S();
		pstImageInfo.write();
		boolean bRet=NetDemo.netdevsdk.NETDEV_GetVideoEffect(NetDemo.lpPlayHandle,pstImageInfo);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get  data failed,maybe not open live or not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError()+",无法设置");
        	System.out.printf("NETDEV_GetVideoEffect failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	pstImageInfo.read();
        	
			int dwContrast=0;                   //对比度
			int dwBrightness=0;                 //亮度
			int dwSaturation=0;                 //饱和度
			int dwHue=0;                        //色调
			int dwGamma=0;                      //Gamma值
			
			try {
				dwContrast=Integer.parseInt(NetDemo.jTextFieldContrast.getText());
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Contrast parameter is null or transformation exception ");
				NetDemo.jTextFieldContrast.setText(null);
				return;
			}
			
			try {
				dwBrightness=Integer.parseInt(NetDemo.jTextFieldBrightness.getText());
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Brightness parameter is null or transformation exception");
				NetDemo.jTextFieldBrightness.setText(null);
				return;
			}
						
			try {
				dwSaturation=Integer.parseInt(NetDemo.jTextFieldSaturation.getText());
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Saturation parameter is null or transformation exception");
				NetDemo.jTextFieldSaturation.setText(null);
				return;
			}
				
			try {
				dwHue=Integer.parseInt(NetDemo.jTextFieldHue.getText());
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Hue parameter is null or transformation exception");
				NetDemo.jTextFieldHue.setText(null);
				return;
			}

			try {
				dwGamma=Integer.parseInt(NetDemo.jTextFieldGamma.getText());
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Gamma parameter is null or transformation exception");
				NetDemo.jTextFieldGamma.setText(null);
				return;
			}
			
			pstImageInfo.dwContrast=dwContrast;
			pstImageInfo.dwBrightness=dwBrightness;
			pstImageInfo.dwGamma=dwGamma;
			pstImageInfo.dwHue=dwHue;
			pstImageInfo.dwSaturation=dwSaturation;
			pstImageInfo.write();
			
			boolean bRet2=NetDemo.netdevsdk.NETDEV_SetVideoEffect(NetDemo.lpPlayHandle, pstImageInfo);
			if(!bRet2) {
				JOptionPane.showMessageDialog(null, "Set Video Effect failed, error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
				System.out.printf("NETDEV_SetVideoEffect failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
			}else {
				JOptionPane.showMessageDialog(null, "Set success");
			}
        }
	}
}
