package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * 
 * @introduction Callback function to register live stream (decoded media stream data)
 * @description Support IPC/NVR/VMS
 */
public class PlayDecodeVideoCB {
    
    /**
     * 
     * @introduction Start callback function to register live stream (decoded media stream data)
     * @description  Calling the interface of NETDEV_SetPlayDecodeVideoCB to start callback function to register streams (original stream)
     *
     */
    public static void startCallBack() {
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(null != NetDemo.lpPlayHandle){
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetPlayDecodeVideoCB(NetDemo.lpPlayHandle, NetDemo.fPlayDecodeVideoCALLBACK, 1, null);
            if(bRet){
                NetDemo.jButtonStopDecodeData.setEnabled(true);
                NetDemo.jButtonStartDecodeData.setEnabled(false);
            }
            else{
                JOptionPane.showMessageDialog(null, "Set Play Decode Video failed.");
            }
        }else{
            JOptionPane.showMessageDialog(null, "Start live preview, please.");
        }
    }
   
    /**
     * 
     * @introduction stop callback function to register live stream (decoded media stream data)
     * @description  Calling the interface of NETDEV_SetPlayDecodeVideoCB to stop callback function to register streams (original stream)
     *
     */
    public static void stopCallBack() {
        if(null != NetDemo.lpPlayHandle){
            NetDemo.netdevsdk.NETDEV_SetPlayDecodeVideoCB(NetDemo.lpPlayHandle, null, 1, null);
            NetDemo.jButtonStartDecodeData.setEnabled(true);
            NetDemo.jButtonStopDecodeData.setEnabled(false);
        }
    
    }
}
