package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * 
 * @introduction Change sound
 * @description Support IPC/NVR/VMS
 */
public class SoundVolume {
    
    /**
     * 
     * @introduction Change live preview sound
     * @description Calling the interface of NETDEV_SoundVolumeControl
     *
     */
    public static void changeLiveSound(ChangeEvent e) {  
        int volume=((JSlider)e.getSource()).getValue();
        IntByReference pdwVolume=new IntByReference();
        boolean bRet=NetDemo.netdevsdk.NETDEV_GetSoundVolume(NetDemo.lpPlayHandle, pdwVolume);
        NetDemo.netdevsdk.NETDEV_GetSoundVolume(NetDemo.lpTalkHandle, pdwVolume);
        if(bRet) {
            NetDemo.jLabelLiveSound.setText(String.valueOf(pdwVolume.getValue()));
            if(NetDemo.lpTalkHandle!=null) {
                NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpTalkHandle,pdwVolume.getValue());
            }
            boolean bRet2=NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpPlayHandle,pdwVolume.getValue());
            if(bRet2) {
                NetDemo.jLabelLiveSound.setText(String.valueOf(volume));
                NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpTalkHandle,volume);
                NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpPlayHandle,volume);
            }else {
                JOptionPane.showMessageDialog(null, "Play sound failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }else {
            NetDemo.jLabelLiveSound.setText(String.valueOf(volume));
            NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpTalkHandle,volume);
            NetDemo.netdevsdk.NETDEV_SoundVolumeControl(NetDemo.lpPlayHandle,volume);
        }
    
    }

    /**
     * 
     * @introduction Change microphone sound
     * @description Calling the interface of NETDEV_MicVolumeControl
     *
     */
    public static void changeMicrophoneSound(ChangeEvent e) {
        int volume=((JSlider)e.getSource()).getValue();
        IntByReference pdwVolume=new IntByReference();
            if(NetDemo.lpTalkHandle!=null) {
                boolean bRet=NetDemo.netdevsdk.NETDEV_GetMicVolume(NetDemo.lpTalkHandle,pdwVolume);
                if(bRet) {
                    NetDemo.jLableLiveMicSound.setText(String.valueOf(pdwVolume.getValue()));
                    boolean bRet2=NetDemo.netdevsdk.NETDEV_MicVolumeControl(NetDemo.lpTalkHandle, pdwVolume.getValue());
                    if(bRet2) {
                        NetDemo.jLableLiveMicSound.setText(String.valueOf(volume));
                        NetDemo.netdevsdk.NETDEV_MicVolumeControl(NetDemo.lpTalkHandle, volume);
                    }else {
                        JOptionPane.showMessageDialog(null, "Play sound failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                        return;
                    }
                }else {
                    NetDemo.jLableLiveMicSound.setText(String.valueOf(volume));
                    NetDemo.netdevsdk.NETDEV_MicVolumeControl(NetDemo.lpTalkHandle, volume);
                    }
                }   
            }
    }
