package main.java.com.netdevsdk.demo.maintenance;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.*;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.DateChooser;
import main.java.com.netdevsdk.demo.util.Util;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_ALARM_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_ALARM_INFO_S;

import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.awt.event.ActionEvent;


public class MaintenaceAlarmSearchWindow extends JDialog{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTable AlarmTable;
	private Pointer lpUserId;
	private int ChannelID;
	JPanel MaintanceFindAlarmPanel = new JPanel();
	
	JLabel startTimeLabel = new JLabel("startTime");
	JLabel endTimeLabel = new JLabel("endTime");
	JTextField startTimeField;
	JTextField endTimeField;
	
	Vector Alarm_HeaderNames;
	JButton Alarm_Search = new JButton("search");
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	
	public MaintenaceAlarmSearchWindow(Pointer lpUserID,int ChannelID) {
		
		this.lpUserId = lpUserID;
		this.ChannelID = ChannelID;
		this.setSize(1400,800);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Modify Montion DETECTION AREA");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(MaintanceFindAlarmPanel, BorderLayout.CENTER);
        
		MaintanceFindAlarmPanel.setLayout(null);
		MaintanceFindAlarmPanel.setVisible(true);
		startTimeLabel.setBounds(80, 20, 120, 35);
		MaintanceFindAlarmPanel.add(startTimeLabel);
		
		endTimeLabel.setBounds(480, 20, 120, 35);
		MaintanceFindAlarmPanel.add(endTimeLabel);
		String DateFormat = "yyyy-MM-dd HH:mm:ss";

		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		JPanel j5 = new JPanel();
		MaintanceFindAlarmPanel.add(j5);
		j5.setBounds(143, 20, 196, 30);
		DateChooser BeginAlarmSearchdateLog = new DateChooser(j5);
		j5.add(BeginAlarmSearchdateLog);
		
		JPanel j6 = new JPanel();
		MaintanceFindAlarmPanel.add(j6);
		j6.setBounds(539, 25, 196, 30);
		DateChooser EndAlarmSearchdateLog = new DateChooser(j6);
		j6.add(EndAlarmSearchdateLog);

		JLabel TimeBorderPanel = new JLabel();
		TimeBorderPanel.setBorder(new TitledBorder(null, "", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		TimeBorderPanel.setBounds(60, 10, 720, 55);
		MaintanceFindAlarmPanel.add(TimeBorderPanel);

		//判断登陆设备类型为IPC/NVR

		AlarmTable = new JTable();
		JScrollPane scrollPaneMaintenanceIPC = new JScrollPane(AlarmTable,
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPaneMaintenanceIPC.setBounds(60, 100, 1300, 503);
		MaintanceFindAlarmPanel.add(scrollPaneMaintenanceIPC, BorderLayout.CENTER);
		Alarm_HeaderNames = new Vector();
		Alarm_HeaderNames.add("AlarmTime");
		Alarm_HeaderNames.add("AlarmType");

		TableModel tableModel = new DefaultTableModel(Alarm_HeaderNames,0);
		AlarmTable.setModel(tableModel);
		
		Alarm_Search.setBounds(800, 20, 80, 35);
		Alarm_Search.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				if(null == lpUserID){
					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
					return;
				}
				if(ChannelID == 0){
					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
					return;
				}

				NETDEV_FIND_ALARM_COND_S pstAlarmFindCond = new NETDEV_FIND_ALARM_COND_S();
				pstAlarmFindCond.dwChannelID = ChannelID;
				
				
				String BeginTime =BeginAlarmSearchdateLog.jTextFieldDate.getText();
				String EndTime = EndAlarmSearchdateLog.jTextFieldDate.getText();
				
				
				
				if(BeginTime == null || "".equals(BeginTime)){
					JOptionPane.showMessageDialog(null, "Please input startTime.");
				}
				if(EndTime == null || "".equals(EndTime)){
					JOptionPane.showMessageDialog(null, "Please input endTime.");
				}
				
				long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
				
				
				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
				
				
				
				if(get1>get2) {
					JOptionPane.showMessageDialog(null, "start time can not more than end time");
					return;
				}
				
				pstAlarmFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
				pstAlarmFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
				pstAlarmFindCond.write();
				Pointer logPointer = netdevsdk.NETDEV_FindAlarmInfoList(lpUserID,pstAlarmFindCond);
				if(logPointer == null){
					System.out.printf("NETDEV_FindAlarmInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
					if(netdevsdk.NETDEV_GetLastError() == 11){
						JOptionPane.showMessageDialog(null, "no results were found");
					}
					return;
				}
				NETDEV_FIND_ALARM_INFO_S pstAlarmInfo = new NETDEV_FIND_ALARM_INFO_S();
				pstAlarmInfo.write();
				boolean flag = true;
				Vector data = new Vector();
				do {
					flag = netdevsdk.NETDEV_FindNextAlarmInfo(logPointer,pstAlarmInfo);
    				if(flag == false){
    					System.out.printf("NETDEV_FindNextAlarmInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						break;
    				}
    				pstAlarmInfo.read();
    				Vector vtData = new Vector();
    				vtData.add(Common.timeStamp2Date(String.valueOf(pstAlarmInfo.tAlarmTime), DateFormat));
    				String message=Util.getFindAlarmType(pstAlarmInfo.dwAlarmType);
    				vtData.add(message);
    				data.add(vtData);
				} while (flag);
				
				flag = netdevsdk.NETDEV_FindCloseAlarmInfo(logPointer);
				if(flag == false){
					System.out.printf("NETDEV_FindCloseAlarmInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
					return;
				}

				DefaultTableModel defaultTableModel = (DefaultTableModel) AlarmTable.getModel();
				defaultTableModel.setRowCount(0);
				AlarmTable.setModel(defaultTableModel);

				TableModel tableModel = new DefaultTableModel(data,Alarm_HeaderNames);
	    		AlarmTable.setModel(tableModel);

			}
		});
		MaintanceFindAlarmPanel.add(Alarm_Search);
    }

}
