package main.java.com.netdevsdk.demo.maintenance;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * @description Reboot the device.
 * @introduction Support IPC/NVR/VMS
 */
public class Maintenance {
    /**
     * @introduction Reboot the device.
     * @description Calling the interface of NETDEV_Reboot.
     */
    public static void Reboot() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_Reboot(NetDemo.lpUserID);
        if(bRet != true)
        {
            System.out.printf("NETDEV_Reboot failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Reboot success");
        }
    }
    /**
     * @description Factory data reset.
     * @introduction Calling the interface of NETDEV_RestoreConfig.
     */
    public static void factoryDefault() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_RestoreConfig(NetDemo.lpUserID);
        if(bRet != true)
        {
            System.out.printf("NETDEV_RestoreConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
}
